/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.pdfanalysis.utils.analysis.digital;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.DigitalPdfUtils;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.PdfReadUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.PdfTextCode;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.util.Matrix;

public class PDFTextStripperDigital
extends PDFTextStripper {
    private final Map<BigDecimal, Map<BigDecimal, PdfTextCode>> coordinateMap = new TreeMap<BigDecimal, Map<BigDecimal, PdfTextCode>>();

    public Map<BigDecimal, Map<BigDecimal, PdfTextCode>> getCoordinateMap() {
        return this.sortMap();
    }

    protected void writeString(String string, List<TextPosition> textPositions) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        BigDecimal firstX = null;
        BigDecimal firstY = null;
        BigDecimal totalWidth = BigDecimal.ZERO;
        float lastFontSize = 0.0f;
        StringBuilder sb = new StringBuilder();
        HashMap<Float, String> notNeedMap = new HashMap<Float, String>();
        for (TextPosition text : textPositions) {
            Matrix textMatrix;
            float fontSize = text.getFontSizeInPt();
            if (notNeedMap.containsKey(Float.valueOf(fontSize)) || (textMatrix = text.getTextMatrix()).getShearX() == 0.0f && textMatrix.getShearY() == 0.0f) continue;
            notNeedMap.put(Float.valueOf(fontSize), "");
        }
        for (TextPosition text : textPositions) {
            float fontSize;
            String content = text.getUnicode().trim();
            if (StringUtils.isBlank((CharSequence)content) || notNeedMap.containsKey(Float.valueOf(fontSize = text.getFontSizeInPt()))) continue;
            BigDecimal width = BigDecimal.valueOf(text.getWidthDirAdj()).setScale(0, RoundingMode.HALF_UP);
            BigDecimal x = BigDecimal.valueOf(text.getXDirAdj()).setScale(0, RoundingMode.HALF_UP);
            BigDecimal y = BigDecimal.valueOf(text.getYDirAdj()).setScale(0, RoundingMode.HALF_UP);
            if (fontSize < 7.0f) {
                y = y.add(new BigDecimal("4"));
            }
            if (firstY == null) {
                firstY = y;
                firstX = x;
            }
            if (lastFontSize != 0.0f) {
                if (BigDecimal.valueOf(lastFontSize).subtract(BigDecimal.valueOf(fontSize)).abs().compareTo(BigDecimal.valueOf(0.6)) <= 0) {
                    if (y == null || firstY == null || x == null || firstX == null) continue;
                    if (y.subtract(firstY).abs().compareTo(BigDecimal.valueOf(3L)) <= 0 && x.subtract(firstX.add(totalWidth)).abs().compareTo(BigDecimal.valueOf(20L)) <= 0) {
                        totalWidth = x.add(width).subtract(firstX);
                        sb.append(content);
                        lastFontSize = fontSize;
                        continue;
                    }
                }
                if (!sb.toString().contains("\u00a5")) {
                    totalWidth = totalWidth.subtract(new BigDecimal("2"));
                    x = x.add(new BigDecimal("2"));
                }
            }
            if (sb.length() > 0) {
                DigitalPdfUtils.setSortContentData(this.coordinateMap, firstX, firstY, totalWidth, PdfReadUtil.replaceSpecailChar(sb.toString()), 2);
            }
            firstY = y;
            firstX = x;
            totalWidth = width;
            sb = new StringBuilder(content);
            lastFontSize = fontSize;
        }
        DigitalPdfUtils.setSortContentData(this.coordinateMap, firstX, firstY, totalWidth, PdfReadUtil.replaceSpecailChar(sb.toString()), 2);
    }

    private Map<BigDecimal, Map<BigDecimal, PdfTextCode>> sortMap() {
        TreeMap<BigDecimal, Map<BigDecimal, PdfTextCode>> currentMap = new TreeMap<BigDecimal, Map<BigDecimal, PdfTextCode>>();
        for (Map.Entry<BigDecimal, Map<BigDecimal, PdfTextCode>> entry : this.coordinateMap.entrySet()) {
            Map<BigDecimal, PdfTextCode> codeMap = entry.getValue();
            BigDecimal lastWidth = BigDecimal.ZERO;
            for (Map.Entry<BigDecimal, PdfTextCode> xEntry : codeMap.entrySet()) {
                PdfTextCode code = xEntry.getValue();
                String content = code.getContent();
                BigDecimal width = code.getWidth();
                if ("\u53d1".equals(content) && width.compareTo(BigDecimal.valueOf(7L)) == 0 && (lastWidth.compareTo(BigDecimal.valueOf(20L)) == 0 || lastWidth.compareTo(BigDecimal.ZERO) == 0)) continue;
                lastWidth = width.divide(BigDecimal.valueOf(content.length()), 0, RoundingMode.HALF_UP);
                DigitalPdfUtils.setSortContentData(currentMap, code.getX(), code.getY(), code.getWidth(), code.getContent(), 5);
            }
        }
        return currentMap;
    }
}

