/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.pdfanalysis.utils.analysis.digital;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.pdfanalysis.utils.ReUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.AirEleTicketPdfRead;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.DigitalPdfConstants;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.DigitalPdfRead;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.DigitalPdfUtils;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.IPdfRead;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.InvoiceTypeEnum;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.PDFTextStripperDigital;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.PdfTextCode;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.ReflectUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.SpecialCodeEnum;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.VatInvoice;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.VatPdfRead;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PdfReadUtil {
    private static Log log = LogFactory.getLog(PdfReadUtil.class);
    public static String EN_COMMA = ".";

    public static JSONObject read(byte[] fileBytes, boolean more) {
        return PdfReadUtil.readByPdfBox(fileBytes, more);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JSONObject readByPdfBox(byte[] fileBytes, boolean more) {
        try (PDDocument document = PDDocument.load((byte[])fileBytes);){
            List<List<PdfTextCode>> firstContentList = PdfReadUtil.getContentListByPageNum(document, 1);
            InvoiceTypeEnum invoiceType = PdfReadUtil.getInvoiceType(firstContentList);
            if (invoiceType == null) {
                JSONObject jSONObject = PdfReadUtil.getReturnJson("-1", "\u53d1\u7968\u7c7b\u578b\u4e0d\u652f\u6301\u3002", "\u53d1\u7968\u7c7b\u578b\u4e0d\u652f\u6301", null);
                return jSONObject;
            }
            IPdfRead pdfRead = PdfReadUtil.getPdfReadByType(invoiceType);
            if (more) {
                JSONObject jSONObject = pdfRead.readArray(document, invoiceType);
                return jSONObject;
            }
            JSONObject jSONObject = pdfRead.read(document, invoiceType);
            return jSONObject;
        }
        catch (Exception e) {
            log.error("\u89e3\u6790pdf\u51fa\u9519", (Throwable)e);
            return PdfReadUtil.getReturnJson("-1", "\u89e3\u6790pdf\u51fa\u9519\u3002", "\u89e3\u6790pdf\u51fa\u9519", null);
        }
    }

    public static void setSpecialInvoiceDate(VatInvoice invoice, String allText) {
        if (invoice.getInvoiceDate() != null) {
            return;
        }
        Pattern pattern = Pattern.compile("\u5f00\u7968\u65e5\u671f[:\uff1a](?<year>\\d{4})[-\u5e74/](?<month>\\d{1,2})[-\u6708/](?<day>\\d{1,2})(\u65e5?)");
        Matcher matcher = pattern.matcher(allText);
        if (matcher.find()) {
            String invoiceDate = matcher.group("year") + "-" + matcher.group("month") + "-" + matcher.group("day");
            invoice.setInvoiceDate(invoiceDate);
        }
    }

    public static void setInvoiceAmount(VatInvoice invoice, String allText) {
        String totalAmount = DigitalPdfConstants.ZERO_STR;
        String totalTax = DigitalPdfConstants.ZERO_STR;
        String totalAmountStr = ReUtil.get("\u5408\u8ba1\u00a5(?<invoiceAmount>\\S*)", (CharSequence)allText.replace("\n", ""), 1);
        if (totalAmountStr == null) {
            totalAmountStr = ReUtil.get("\u4ef7\u7a0e\u5408\u8ba1(.*?)\u00a5(?<invoiceAmount>\\S*)", (CharSequence)allText.replace("\n", ""), 2);
        }
        String[] totalAmountArr = totalAmountStr.split("\u00a5");
        ArrayList<String> totalAmountArr1 = new ArrayList<String>();
        for (String s : totalAmountArr) {
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            totalAmountArr1.add(s);
        }
        if (totalAmountArr1.size() == 2) {
            totalAmount = (String)totalAmountArr1.get(0);
            totalTax = (String)totalAmountArr1.get(1);
        } else if (totalAmountStr.endsWith("***")) {
            totalAmount = totalAmountStr.substring(0, totalAmountStr.length() - 3);
        }
        totalAmount = totalAmount == null || totalAmount.contains("*") ? DigitalPdfConstants.ZERO_STR : totalAmount;
        totalTax = totalTax == null || totalTax.contains("*") ? DigitalPdfConstants.ZERO_STR : totalTax;
        invoice.setInvoiceAmount(totalAmount);
        invoice.setTotalTaxAmount(totalTax);
    }

    public static JSONObject getDataJsonByList(List<List<PdfTextCode>> contentList) {
        JSONObject dataJson = new JSONObject();
        Map<String, PdfTextCode> specialMap = PdfReadUtil.getSpecialMap(contentList);
        StringBuilder sb = new StringBuilder();
        contentList.forEach(list -> {
            BigDecimal x = BigDecimal.ZERO;
            BigDecimal y = BigDecimal.ZERO;
            BigDecimal width = BigDecimal.ZERO;
            StringBuilder lineStr = new StringBuilder();
            for (PdfTextCode code : list) {
                if (x.compareTo(BigDecimal.ZERO) == 0) {
                    x = code.getX();
                    y = code.getY();
                }
                String specialCode = null;
                String content = code.getContent();
                BigDecimal currentX = code.getX();
                if ("\u5bc6".equals(content) && currentX.compareTo(new BigDecimal("300")) > 0) {
                    specialCode = SpecialCodeEnum.CODE_AREA.getCode();
                } else if ("\u8d2d".equals(content) && currentX.compareTo(new BigDecimal("60")) < 0) {
                    specialCode = SpecialCodeEnum.BUYER_INFO.getCode();
                } else if ("\u9500".equals(content)) {
                    specialCode = SpecialCodeEnum.SALER_INFO.getCode();
                }
                if (specialCode != null) {
                    specialMap.putIfAbsent(specialCode, new PdfTextCode(code.getX(), code.getY(), width, content));
                }
                width = code.getX().add(code.getWidth()).subtract(x);
                if (lineStr.toString().startsWith(SpecialCodeEnum.COMBINE_TOTAL.getDesc()) && !content.startsWith("\u00a5")) {
                    content = "\u00a5" + content;
                }
                lineStr.append(content);
            }
            PdfReadUtil.setSpecialMap(specialMap, lineStr.toString(), x, y, width);
            sb.append((CharSequence)lineStr).append("\r\n");
        });
        dataJson.put("allText", (Object)sb.toString());
        dataJson.put("specialMap", specialMap);
        return dataJson;
    }

    public static String getLineText(List<PdfTextCode> pdfTextCodeList, BigDecimal leftX, BigDecimal rightX, JSONObject param) {
        StringBuilder sb = new StringBuilder();
        BigDecimal startX = BigDecimal.ZERO;
        BigDecimal width = BigDecimal.ZERO;
        BigDecimal lastRightX = BigDecimal.ZERO;
        for (PdfTextCode code : pdfTextCodeList) {
            BigDecimal x = code.getX();
            if (x.compareTo(leftX.add(new BigDecimal("3"))) <= 0 || rightX != null && x.compareTo(rightX) >= 0 || PdfReadUtil.checkMoreThanEnd(param, x) && x.subtract(lastRightX).abs().compareTo(new BigDecimal("20")) > 0) continue;
            if (startX.compareTo(BigDecimal.ZERO) == 0) {
                startX = x;
            }
            sb.append(code.getContent());
            width = width.add(code.getWidth());
            lastRightX = x.add(code.getWidth());
        }
        if (sb.length() > 0) {
            PdfReadUtil.setParamJsom(param, startX, startX.add(width));
        }
        return sb.toString();
    }

    public static String getLineText(List<PdfTextCode> pdfTextCodeList, BigDecimal leftX, BigDecimal rightX, boolean digitalNameFlag, JSONObject param) {
        StringBuilder sb = new StringBuilder();
        BigDecimal startX = BigDecimal.ZERO;
        BigDecimal width = BigDecimal.ZERO;
        BigDecimal lastRightX = BigDecimal.ZERO;
        for (PdfTextCode code : pdfTextCodeList) {
            BigDecimal x = code.getX();
            if ((!digitalNameFlag || x.compareTo(leftX) < 0) && x.compareTo(leftX.add(new BigDecimal("3"))) <= 0 || rightX != null && x.compareTo(rightX) >= 0 || PdfReadUtil.checkMoreThanEnd(param, x) && x.subtract(lastRightX).abs().compareTo(new BigDecimal("20")) > 0) continue;
            if (startX.compareTo(BigDecimal.ZERO) == 0) {
                startX = x;
            }
            sb.append(code.getContent());
            width = width.add(code.getWidth());
            lastRightX = x.add(code.getWidth());
        }
        if (sb.length() > 0) {
            PdfReadUtil.setParamJsom(param, startX, startX.add(width));
        }
        return sb.toString();
    }

    private static boolean checkMoreThanEnd(JSONObject param, BigDecimal x) {
        if (param == null || param.getBigDecimal("endX") == null) {
            return false;
        }
        BigDecimal endX = param.getBigDecimal("endX");
        return x.compareTo(endX) > 0;
    }

    private static void setParamJsom(JSONObject param, BigDecimal x, BigDecimal currentEndX) {
        if (param != null) {
            if (!param.containsKey((Object)"startX")) {
                param.put("startX", (Object)x);
            }
            param.put("currentStartX", (Object)x);
            BigDecimal endX = param.getBigDecimal("endX");
            if (endX == null || currentEndX.compareTo(endX) > 0) {
                param.put("endX", (Object)currentEndX);
            }
        }
    }

    private static Map<String, PdfTextCode> getSpecialMap(List<List<PdfTextCode>> contentList) {
        HashMap<String, PdfTextCode> specialMap = new HashMap<String, PdfTextCode>();
        TreeMap xCodeMap = new TreeMap();
        contentList.forEach(codeList -> codeList.forEach(code -> {
            String content = code.getContent();
            if (DigitalPdfConstants.SPECIAL_KEYS.contains(content) || DigitalPdfConstants.SPECIAL_STR_KEYS.contains(content)) {
                PdfReadUtil.setXcodeMap(xCodeMap, code);
            }
        }));
        for (Map.Entry listEntry : xCodeMap.entrySet()) {
            StringBuilder contentBuilder = new StringBuilder();
            BigDecimal lastY = BigDecimal.ZERO;
            List currentList = (List)listEntry.getValue();
            PdfTextCode firstCode = (PdfTextCode)currentList.get(0);
            for (PdfTextCode textCode : currentList) {
                if (lastY.compareTo(BigDecimal.ZERO) != 0 && lastY.subtract(textCode.getY()).abs().compareTo(new BigDecimal("50")) > 0) {
                    PdfReadUtil.setSpecialMap(specialMap, contentBuilder.toString(), firstCode);
                    contentBuilder = new StringBuilder();
                    firstCode = textCode;
                }
                contentBuilder.append(textCode.getContent());
                lastY = textCode.getY();
            }
            PdfReadUtil.setSpecialMap(specialMap, contentBuilder.toString(), firstCode);
        }
        return specialMap;
    }

    private static void setSpecialMap(Map<String, PdfTextCode> specialMap, String content, PdfTextCode code) {
        for (SpecialCodeEnum specialCodeEnum : DigitalPdfConstants.SPECIAL_ENUMS) {
            if (!content.startsWith(specialCodeEnum.getDesc())) continue;
            specialMap.put(specialCodeEnum.getCode(), code);
            break;
        }
    }

    private static void setXcodeMap(Map<BigDecimal, List<PdfTextCode>> xCodeMap, PdfTextCode code) {
        BigDecimal x = code.getX();
        List<PdfTextCode> list = null;
        for (int i = 0; i < 6; ++i) {
            list = xCodeMap.get(x.add(new BigDecimal(i)));
            if (list != null) {
                x = x.add(new BigDecimal(i));
                break;
            }
            list = xCodeMap.get(x.subtract(new BigDecimal(i)));
            if (list == null) continue;
            x = x.subtract(new BigDecimal(i));
            break;
        }
        if (list == null) {
            list = new ArrayList<PdfTextCode>();
        }
        list.add(code);
        xCodeMap.put(x, list);
    }

    public static void setSpecialMap(Map<String, PdfTextCode> specialMap, String str, BigDecimal x, BigDecimal y, BigDecimal width) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return;
        }
        SpecialCodeEnum specialCode = SpecialCodeEnum.getByDesc(str);
        if (specialCode != null) {
            PdfTextCode pdfTextCode = new PdfTextCode(x, y, width, str);
            String code = specialCode.getCode();
            if (SpecialCodeEnum.BANK_ACCOUNT == specialCode) {
                code = !specialMap.containsKey(SpecialCodeEnum.BUYER_ACCOUNT.getCode()) ? SpecialCodeEnum.BUYER_ACCOUNT.getCode() : SpecialCodeEnum.SALER_ACCOUNT.getCode();
            }
            specialMap.putIfAbsent(code, pdfTextCode);
        }
    }

    public static void setPatternMatchValue(Object invoice, String allText, String reg, String[] keys) {
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(allText);
        block0: while (matcher.find()) {
            int matchNum = matcher.groupCount();
            int valueNum = 0;
            for (String key : keys) {
                Object fieldValue;
                Field field;
                if (matcher.group(key) == null || (field = ReflectUtil.getField(invoice, key)) == null || (fieldValue = ReflectUtil.getFieldValue(invoice, field.getName())) != null) continue;
                ReflectUtil.setFieldValue(invoice, field.getName(), matcher.group(key));
                if (++valueNum == matchNum) continue block0;
            }
        }
    }

    public static void setPatternMatchValue(Object invoice, String allText, String reg, String[] keys, boolean flag) {
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(allText);
        block0: while (matcher.find()) {
            int matchNum = matcher.groupCount();
            int valueNum = 0;
            for (String key : keys) {
                Object fieldValue;
                Field field;
                if (matcher.group(key) == null || (field = ReflectUtil.getField(invoice, key)) == null || (fieldValue = ReflectUtil.getFieldValue(invoice, field.getName())) != null && flag) continue;
                ReflectUtil.setFieldValue(invoice, field.getName(), matcher.group(key));
                if (++valueNum == matchNum) continue block0;
            }
        }
    }

    public static List<List<PdfTextCode>> getContentListByPageNum(PDDocument document, int pageNum) throws IOException {
        PDFTextStripperDigital stripper = new PDFTextStripperDigital();
        stripper.setSortByPosition(true);
        stripper.setStartPage(pageNum);
        stripper.setEndPage(pageNum);
        OutputStreamWriter dummy = new OutputStreamWriter(new ByteArrayOutputStream());
        stripper.writeText(document, dummy);
        Map<BigDecimal, Map<BigDecimal, PdfTextCode>> coordinateMap = stripper.getCoordinateMap();
        Map<BigDecimal, Map<BigDecimal, PdfTextCode>> secondSortMap = PdfReadUtil.secondSort(coordinateMap);
        return PdfReadUtil.getListByMap(secondSortMap);
    }

    public static Map<BigDecimal, Map<BigDecimal, PdfTextCode>> secondSort(Map<BigDecimal, Map<BigDecimal, PdfTextCode>> firstSortMap) {
        TreeMap<BigDecimal, Map<BigDecimal, PdfTextCode>> secondSortMap = new TreeMap<BigDecimal, Map<BigDecimal, PdfTextCode>>();
        for (Map.Entry<BigDecimal, Map<BigDecimal, PdfTextCode>> firstMapEntry : firstSortMap.entrySet()) {
            BigDecimal yKey = firstMapEntry.getKey();
            Map<BigDecimal, PdfTextCode> xMap = firstMapEntry.getValue();
            String everyContent = "";
            BigDecimal xFirst = BigDecimal.ZERO;
            BigDecimal lastX = BigDecimal.ZERO;
            BigDecimal lastWidth = BigDecimal.ZERO;
            BigDecimal totalWidth = BigDecimal.ZERO;
            for (Map.Entry<BigDecimal, PdfTextCode> xMapEntry : xMap.entrySet()) {
                BigDecimal xKey = xMapEntry.getKey();
                PdfTextCode pdfTextCode = xMapEntry.getValue();
                BigDecimal width = pdfTextCode.getWidth().add(BigDecimal.ONE);
                String content = pdfTextCode.getContent();
                if ("\u53d1".equals(content) && everyContent.endsWith("\u589e\u503c\u7a0e\u7535\u5b50")) continue;
                if (totalWidth.compareTo(BigDecimal.ZERO) == 0) {
                    xFirst = xKey;
                }
                BigDecimal diffBig = everyContent.endsWith(DigitalPdfConstants.EN_COLON) || everyContent.endsWith(DigitalPdfConstants.CN_COLON) || everyContent.endsWith(EN_COMMA) ? new BigDecimal("5") : new BigDecimal("0.5");
                if (lastX.compareTo(BigDecimal.ZERO) != 0 && lastX.add(lastWidth).add(diffBig).compareTo(xKey) < 0) {
                    DigitalPdfUtils.setSortContentData(secondSortMap, xFirst, yKey, totalWidth, everyContent, 5);
                    everyContent = "";
                    totalWidth = BigDecimal.ZERO;
                    xFirst = xKey;
                }
                everyContent = everyContent + content;
                totalWidth = totalWidth.add(width);
                lastX = xKey;
                lastWidth = width;
            }
            if (!StringUtils.isNotBlank((CharSequence)everyContent)) continue;
            DigitalPdfUtils.setSortContentData(secondSortMap, xFirst, yKey, totalWidth, everyContent, 5);
        }
        return secondSortMap;
    }

    public static List<List<PdfTextCode>> getListByMap(Map<BigDecimal, Map<BigDecimal, PdfTextCode>> secondSortMap) {
        ArrayList<List<PdfTextCode>> list = new ArrayList<List<PdfTextCode>>(secondSortMap.size());
        for (Map.Entry<BigDecimal, Map<BigDecimal, PdfTextCode>> secondSortEntry : secondSortMap.entrySet()) {
            Map<BigDecimal, PdfTextCode> xMap = secondSortEntry.getValue();
            ArrayList<PdfTextCode> xList = new ArrayList<PdfTextCode>(xMap.size());
            for (Map.Entry<BigDecimal, PdfTextCode> xMapEntry : xMap.entrySet()) {
                xList.add(xMapEntry.getValue());
            }
            list.add(xList);
        }
        return list;
    }

    private static InvoiceTypeEnum getInvoiceType(List<List<PdfTextCode>> pdfTextCodeList) {
        for (List<PdfTextCode> pdfTextCodes : pdfTextCodeList) {
            for (PdfTextCode textCode : pdfTextCodes) {
                InvoiceTypeEnum invoiceType = InvoiceTypeEnum.getByDesc(textCode.getContent());
                if (invoiceType == null) continue;
                return invoiceType;
            }
        }
        return null;
    }

    private static IPdfRead getPdfReadByType(InvoiceTypeEnum invoiceTypeEnum) {
        if (InvoiceTypeEnum.DIGITAL_ELE_INVOICE_ORDINARY == invoiceTypeEnum || InvoiceTypeEnum.DIGITAL_ELE_INVOICE_SPECIAL == invoiceTypeEnum) {
            return new DigitalPdfRead();
        }
        if (InvoiceTypeEnum.DIGITAL_ELE_AIR_TRANSPORT_TICKET_ITINERARY == invoiceTypeEnum) {
            return new AirEleTicketPdfRead();
        }
        return new VatPdfRead();
    }

    public static JSONObject getReturnJson(String type, String description, String error, Object data) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)type);
        jsonObject.put("description", (Object)description);
        jsonObject.put("error", (Object)error);
        jsonObject.put("invoice", data);
        return jsonObject;
    }

    public static String replaceSpecailChar(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        str = str.replaceAll(" ", "").replaceAll("\u3000", "").replaceAll("\uff08", "(").replaceAll("\uff09", ")").replaceAll("\uffe5", "\u00a5").replaceAll("\uff1a", ":").replaceAll("\u00a0", "").replaceAll("\uff0a", "*").replaceAll("\u2f08", "\u4eba").replaceAll("\u2f47", "\u65e5").replaceAll("\u2f6c", "\u76ee").replaceAll("\u2fa6", "\u91d1").replaceAll("\u2f26", "\u5b50").replaceAll("\u2f29", "\u5c0f");
        return str;
    }
}

