/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.pdfanalysis.utils.analysis.digital;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.pdfanalysis.utils.PdfExtractUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.DigitalPdfConstants;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.DigitalPdfUtils;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.IPdfRead;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.InvoiceTypeEnum;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.PDFTextStripperDigital;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.PdfReadUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.PdfTextCode;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.SpecialCodeEnum;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.VatInvoice;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.VatInvoiceItem;
import kd.imc.rim.file.utils.StrUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;

public class VatPdfRead
implements IPdfRead {
    private static Log log = LogFactory.getLog(VatPdfRead.class);

    @Override
    public JSONObject read(PDDocument document, InvoiceTypeEnum invoiceType) {
        JSONObject returnJSON = new JSONObject();
        try {
            VatInvoice invoice = new VatInvoice();
            if (invoiceType != null) {
                invoice.setInvoiceType(invoiceType.getCode());
            }
            ArrayList<VatInvoiceItem> initItemList = new ArrayList<VatInvoiceItem>();
            int numberOfPages = document.getNumberOfPages();
            this.readInvoice(invoice, initItemList, document, numberOfPages);
            DigitalPdfUtils.setModelItemData(invoice, initItemList);
            returnJSON.put("type", (Object)"1");
            returnJSON.put("description", (Object)ResManager.loadKDString((String)"\u975e\u5168\u7535\u7968", (String)"VatPdfRead_0", (String)"imc-rim-file", (Object[])new Object[0]));
            returnJSON.put("invoice", (Object)invoice);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u5168\u7535pdf\u51fa\u9519", (Throwable)e);
            returnJSON.put("type", (Object)"1");
            returnJSON.put("description", (Object)ResManager.loadKDString((String)"\u975e\u5168\u7535\u7968\u6216\u89e3\u6790\u51fa\u9519\u3002", (String)"VatPdfRead_1", (String)"imc-rim-file", (Object[])new Object[0]));
            returnJSON.put("error", (Object)ResManager.loadKDString((String)"\u975e\u5168\u7535\u7968\u6216\u89e3\u6790\u51fa\u9519", (String)"VatPdfRead_2", (String)"imc-rim-file", (Object[])new Object[0]));
        }
        return returnJSON;
    }

    @Override
    public JSONObject readArray(PDDocument document, InvoiceTypeEnum invoiceType) {
        JSONObject returnJSON = new JSONObject();
        ArrayList<VatInvoice> invoiceList = new ArrayList<VatInvoice>();
        try {
            VatInvoice invoice = new VatInvoice();
            if (invoiceType != null) {
                invoice.setInvoiceType(invoiceType.getCode());
            }
            ArrayList<VatInvoiceItem> initItemList = new ArrayList<VatInvoiceItem>();
            int numberOfPages = document.getNumberOfPages();
            this.readInvoice(invoice, initItemList, document, numberOfPages);
            if (invoice.isUnDeal()) {
                return null;
            }
            DigitalPdfUtils.setModelItemData(invoice, initItemList);
            invoiceList.add(invoice);
            returnJSON.put("type", (Object)"2");
            returnJSON.put("description", (Object)ResManager.loadKDString((String)"\u5168\u7535\u7968", (String)"VatPdfRead_3", (String)"imc-rim-file", (Object[])new Object[0]));
            returnJSON.put("invoice", invoiceList);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u5168\u7535pdf\u51fa\u9519", (Throwable)e);
            returnJSON.put("type", (Object)"1");
            returnJSON.put("description", (Object)ResManager.loadKDString((String)"\u975e\u5168\u7535\u7968\u6216\u89e3\u6790\u51fa\u9519\u3002", (String)"VatPdfRead_1", (String)"imc-rim-file", (Object[])new Object[0]));
            returnJSON.put("error", (Object)ResManager.loadKDString((String)"\u975e\u5168\u7535\u7968\u6216\u89e3\u6790\u51fa\u9519", (String)"VatPdfRead_2", (String)"imc-rim-file", (Object[])new Object[0]));
        }
        return returnJSON;
    }

    private void readInvoice(VatInvoice invoice, List<VatInvoiceItem> initItemList, PDDocument document, int totalNum) throws Exception {
        if (totalNum > 1) {
            boolean isEqual;
            VatInvoice vatInvoice = new VatInvoice();
            JSONObject firstPage = PdfExtractUtil.getPageCodeNum2(vatInvoice, document, 1, "\u673a\u5668\u7f16\u53f7:(?<machineNo>\\d{12})|\u53d1\u7968\u4ee3\u7801:(?<invoiceCode>\\d{12})|\u53d1\u7968\u53f7\u7801:(?<invoiceNo>\\d{8})|\u5f00\u7968\u65e5\u671f:(?<invoiceDate>\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5)|\u6821\u9a8c\u7801:(?<checkCode>\\d{20})", DigitalPdfConstants.MACHINE_KEYS);
            JSONObject lastPage = PdfExtractUtil.getPageCodeNum2(vatInvoice, document, totalNum, "\u673a\u5668\u7f16\u53f7:(?<machineNo>\\d{12})|\u53d1\u7968\u4ee3\u7801:(?<invoiceCode>\\d{12})|\u53d1\u7968\u53f7\u7801:(?<invoiceNo>\\d{8})|\u5f00\u7968\u65e5\u671f:(?<invoiceDate>\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5)|\u6821\u9a8c\u7801:(?<checkCode>\\d{20})", DigitalPdfConstants.MACHINE_KEYS);
            boolean bl = isEqual = firstPage.getString("invoiceCode").equals(lastPage.getString("invoiceCode")) && firstPage.getString("invoiceNo").equals(lastPage.getString("invoiceNo"));
            if (!isEqual) {
                invoice.setUnDeal(true);
                return;
            }
        }
        for (int i = 1; i <= totalNum; ++i) {
            List<List<PdfTextCode>> contentList = VatPdfRead.getContentListByPageNum(document, i);
            JSONObject dataJson = PdfReadUtil.getDataJsonByList(contentList);
            Map specialMap = (Map)dataJson.get((Object)"specialMap");
            if (i == 1) {
                this.setBasicData(invoice, dataJson, contentList, specialMap);
                if (totalNum > 1) continue;
            }
            this.setInitItemList(initItemList, contentList, specialMap);
        }
    }

    private void setBasicData(VatInvoice invoice, JSONObject dataJson, List<List<PdfTextCode>> contentList, Map<String, PdfTextCode> specialMap) {
        String invoiceTypeReg;
        Pattern invoiceTypeP;
        Matcher invoiceTypeM;
        String allText = dataJson.getString("allText");
        if (allText.contains("\u8f66\u724c\u53f7") && allText.contains("\u901a\u884c\u65e5\u671f\u8d77") && allText.contains("\u901a\u884c\u65e5\u671f\u6b62")) {
            invoice.setInvoiceType(InvoiceTypeEnum.TOLL.getCode());
        }
        if (invoice.getInvoiceType() == null && (invoiceTypeM = (invoiceTypeP = Pattern.compile(invoiceTypeReg = "\\S*\u7535\u5b50\u666e\u901a\u53d1\u7968")).matcher(allText)).find()) {
            invoice.setInvoiceType(InvoiceTypeEnum.VAT_ELE_INVOICE_ORDINARY.getCode());
        }
        PdfReadUtil.setSpecialInvoiceDate(invoice, allText);
        PdfReadUtil.setPatternMatchValue(invoice, allText, "\u673a\u5668\u7f16\u53f7:(?<machineNo>\\d{12})|\u53d1\u7968\u4ee3\u7801:(?<invoiceCode>\\d{12})|\u53d1\u7968\u53f7\u7801:(?<invoiceNo>\\d{8})|\u5f00\u7968\u65e5\u671f:(?<invoiceDate>\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5)|\u6821\u9a8c\u7801:(?<checkCode>\\d{20})", DigitalPdfConstants.MACHINE_KEYS);
        PdfReadUtil.setInvoiceAmount(invoice, allText);
        PdfReadUtil.setPatternMatchValue(invoice, allText, "\\u0028\u5c0f\u5199\\u0029\u00a5(?<totalAmount>\\S*)\\s", DigitalPdfConstants.AMOUNT_KEYS);
        if (invoice.getTotalAmount() == null) {
            PdfReadUtil.setPatternMatchValue(invoice, allText, "\\u0028\u5c0f\u5199\\u0029(?<totalAmount>\\S*)", DigitalPdfConstants.AMOUNT_KEYS);
        }
        PdfReadUtil.setPatternMatchValue(invoice, allText, "\u6536\u6b3e\u4eba:(?<payee>\\S*)\u590d\u6838:(?<reviewer>\\S*)\u5f00\u7968\u4eba:(?<drawer>\\S*)\u9500\u552e\u65b9", DigitalPdfConstants.LAST_KEYS);
        if (StringUtils.isEmpty((CharSequence)invoice.getDrawer())) {
            PdfReadUtil.setPatternMatchValue(invoice, allText, "\u6536\u6b3e\u4eba:(?<payee>\\S*)\u590d\u6838:(?<reviewer>\\S*)\u5f00\u7968\u4eba:(?<drawer>\\S*)", DigitalPdfConstants.LAST_KEYS);
        }
        this.setSpecialDataToInvoice(specialMap, invoice, contentList);
        String invoiceDate = invoice.getInvoiceDate();
        if (!StringUtils.isNotEmpty((CharSequence)invoiceDate) || invoiceDate.length() != 10 || !invoiceDate.contains("-")) {
            invoice.setInvoiceDate(DigitalPdfUtils.formatDate(invoice.getInvoiceDate()));
        }
    }

    public static List<List<PdfTextCode>> getContentListByPageNum(PDDocument document, int pageNum) throws IOException {
        PDFTextStripperDigital stripper = new PDFTextStripperDigital();
        stripper.setSortByPosition(true);
        stripper.setStartPage(pageNum);
        stripper.setEndPage(pageNum);
        OutputStreamWriter dummy = new OutputStreamWriter(new ByteArrayOutputStream());
        stripper.writeText(document, dummy);
        Map<BigDecimal, Map<BigDecimal, PdfTextCode>> coordinateMap = stripper.getCoordinateMap();
        VatPdfRead.setFormDataToMap(document, coordinateMap, pageNum);
        Map<BigDecimal, Map<BigDecimal, PdfTextCode>> secondSortMap = PdfReadUtil.secondSort(coordinateMap);
        return PdfReadUtil.getListByMap(secondSortMap);
    }

    private static void setFormDataToMap(PDDocument document, Map<BigDecimal, Map<BigDecimal, PdfTextCode>> coordinateMap, int pageNum) {
        PDPage page = document.getPage(pageNum - 1);
        PDRectangle mediaBox = page.getMediaBox();
        float height = mediaBox.getHeight();
        PDAcroForm pdAcroForm = document.getDocumentCatalog().getAcroForm();
        if (pdAcroForm != null) {
            List fields = pdAcroForm.getFields();
            for (PDField field : fields) {
                if (field.getWidgets().size() <= 0 || !document.getPage(pageNum - 1).equals((Object)((PDAnnotationWidget)field.getWidgets().get(0)).getPage())) continue;
                PDRectangle rectangle = ((PDAnnotationWidget)field.getWidgets().get(0)).getRectangle();
                String text = field.getValueAsString();
                if (!StringUtils.isNotBlank((CharSequence)text)) continue;
                BigDecimal width = BigDecimal.valueOf(rectangle.getWidth() - 3.0f).setScale(0, RoundingMode.HALF_UP);
                BigDecimal x = BigDecimal.valueOf(rectangle.getLowerLeftX() + 3.0f).setScale(0, RoundingMode.HALF_UP);
                BigDecimal y = BigDecimal.valueOf(height - rectangle.getLowerLeftY() - 2.0f).setScale(0, RoundingMode.HALF_UP);
                DigitalPdfUtils.setSortContentData(coordinateMap, x, y, width, PdfReadUtil.replaceSpecailChar(text), 5);
            }
        }
    }

    private void setSpecialDataToInvoice(Map<String, PdfTextCode> specialMap, VatInvoice invoice, List<List<PdfTextCode>> contentList) {
        PdfTextCode buyerAccountCode = specialMap.get(SpecialCodeEnum.BUYER_ACCOUNT.getCode());
        PdfTextCode codeAreaCode = specialMap.get(SpecialCodeEnum.CODE_AREA.getCode());
        PdfTextCode machineCode = specialMap.get(SpecialCodeEnum.MACHINE_NO.getCode());
        PdfTextCode taxRateCode = specialMap.get(SpecialCodeEnum.TAX_RATE.getCode());
        PdfTextCode remarkCode = specialMap.get(SpecialCodeEnum.REMARK.getCode());
        BigDecimal buyerLeftX = buyerAccountCode.getX().subtract(new BigDecimal("3.9"));
        BigDecimal buyerRightX = codeAreaCode.getX();
        BigDecimal buyerTopY = machineCode.getY();
        BigDecimal buyerBottomY = taxRateCode.getY();
        this.setInfoData(invoice, contentList, buyerLeftX, buyerRightX, buyerTopY, buyerBottomY, true);
        PdfTextCode totalAmountCode = specialMap.get(SpecialCodeEnum.TOTAL_AMOUNT.getCode());
        PdfTextCode salerAccountCode = specialMap.get(SpecialCodeEnum.SALER_ACCOUNT.getCode());
        BigDecimal saleTopY = totalAmountCode.getY();
        BigDecimal saleBottomY = salerAccountCode.getY().add(new BigDecimal("3.9"));
        BigDecimal remarkLeft = buyerRightX;
        if (remarkCode != null) {
            remarkLeft = remarkCode.getX();
        }
        this.setInfoData(invoice, contentList, buyerLeftX, remarkLeft, saleTopY, saleBottomY, false);
        remarkLeft = remarkLeft.add(new BigDecimal("5"));
        this.setRemarkData(invoice, contentList, remarkLeft, saleTopY, saleBottomY);
    }

    private void setInfoData(VatInvoice invoice, List<List<PdfTextCode>> contentList, BigDecimal leftX, BigDecimal rightX, BigDecimal topY, BigDecimal bottomY, boolean buyerFlag) {
        StringBuilder sb = new StringBuilder();
        JSONObject param = new JSONObject();
        BigDecimal startX = null;
        BigDecimal lastEndX = null;
        for (int i = 0; i < contentList.size(); ++i) {
            String lineContent;
            List<PdfTextCode> pdfTextCodeList = contentList.get(i);
            PdfTextCode pdfTextCode = pdfTextCodeList.get(0);
            BigDecimal y = pdfTextCode.getY();
            if (y.compareTo(topY) <= 0 || y.compareTo(bottomY) >= 0 || StringUtils.isBlank((CharSequence)(lineContent = PdfReadUtil.getLineText(pdfTextCodeList, leftX, rightX, false, param)))) continue;
            BigDecimal currentEndX = param.getBigDecimal("endX");
            if (startX == null) {
                startX = param.getBigDecimal("startX");
            }
            BigDecimal currentFirstX = param.getBigDecimal("currentStartX");
            if (sb.length() > 0 && (currentFirstX.subtract(startX).abs().compareTo(new BigDecimal("20")) <= 0 || lastEndX != null && lastEndX.subtract(currentEndX).abs().compareTo(new BigDecimal("20")) > 0)) {
                this.setInfoDataByReg(invoice, sb.toString(), buyerFlag);
                sb = new StringBuilder();
            }
            sb.append(lineContent);
            lastEndX = currentEndX;
        }
        this.setInfoDataByReg(invoice, sb.toString(), buyerFlag);
    }

    private void setRemarkData(VatInvoice invoice, List<List<PdfTextCode>> contentList, BigDecimal leftX, BigDecimal topY, BigDecimal bottomY) {
        StringBuilder sb = new StringBuilder();
        for (List<PdfTextCode> pdfTextCodeList : contentList) {
            PdfTextCode pdfTextCode = pdfTextCodeList.get(0);
            BigDecimal y = pdfTextCode.getY();
            if (y.compareTo(topY) <= 0 || y.compareTo(bottomY) >= 0) continue;
            for (PdfTextCode code : pdfTextCodeList) {
                BigDecimal x = code.getX();
                if (x.compareTo(leftX) < 0) continue;
                sb.append(code.getContent());
            }
        }
        invoice.setRemark(sb.toString());
    }

    private boolean setInfoDataByReg(VatInvoice invoice, String text, boolean buyerFlag) {
        boolean flag = false;
        Pattern pattern = Pattern.compile("\u540d\u79f0:(?<name>\\S*)|\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7:(?<taxNo>\\S*)|\u5730\u5740\u3001\u7535\u8bdd:(?<addressPhone>\\S*)|\u5f00\u6237\u884c\u53ca\u8d26\u53f7:(?<bankAccount>\\S*)");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            flag = true;
            String name = StrUtil.nullToEmpty(matcher.group("name"));
            String taxNo = StrUtil.nullToEmpty(matcher.group("taxNo"));
            String addressPhone = StrUtil.nullToEmpty(matcher.group("addressPhone"));
            String bankAccount = StrUtil.nullToEmpty(matcher.group("bankAccount"));
            if (buyerFlag) {
                invoice.setBuyerName(name);
                invoice.setBuyerTaxNo(taxNo);
                invoice.setBuyerAccount(bankAccount);
                invoice.setBuyerAddressPhone(addressPhone);
                continue;
            }
            invoice.setSalerName(name);
            invoice.setSalerTaxNo(taxNo);
            invoice.setSalerAccount(bankAccount);
            invoice.setSalerAddressPhone(addressPhone);
        }
        return flag;
    }

    private void setInitItemList(List<VatInvoiceItem> initItemList, List<List<PdfTextCode>> contentList, Map<String, PdfTextCode> specialMap) {
        PdfTextCode taxRateCode = specialMap.get(SpecialCodeEnum.TAX_RATE.getCode());
        PdfTextCode totalCode = specialMap.get(SpecialCodeEnum.COMBINE_TOTAL.getCode());
        if (totalCode == null) {
            totalCode = specialMap.get(SpecialCodeEnum.SUB_TOTAL.getCode());
        }
        BigDecimal topY = taxRateCode.getY();
        BigDecimal bottomY = totalCode.getY();
        boolean headFlag = true;
        List<PdfTextCode> headList = null;
        for (List<PdfTextCode> pdfTextCodeList : contentList) {
            PdfTextCode pdfTextCode = pdfTextCodeList.get(0);
            BigDecimal y = pdfTextCode.getY();
            if (y.compareTo(topY) < 0 || y.compareTo(bottomY) >= 0) continue;
            if (headFlag) {
                headList = DigitalPdfUtils.getItemHeadList(pdfTextCodeList);
                headFlag = false;
                continue;
            }
            initItemList.add(DigitalPdfUtils.getItemByXList(pdfTextCodeList, headList, true));
        }
    }
}

