/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.service;

import com.lowagie.text.Image;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.model.protocol.COMMON_FPKJ_FPT;
import kd.imc.rim.file.model.protocol.COMMON_FPKJ_XMXX;
import kd.imc.rim.file.model.protocol.EInvoiceEntity;
import kd.imc.rim.file.model.protocol.EInvoiceMxEntity;
import kd.imc.rim.file.model.protocol.PdfReturnBean;
import kd.imc.rim.file.model.protocol.RESPONSE_FPKJ;
import kd.imc.rim.file.model.protocol.StencilPlageMx;
import kd.imc.rim.file.model.protocol.StencilPlate;
import kd.imc.rim.file.service.TextFactory;
import kd.imc.rim.file.utils.MathUtil;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class PdfProduceService {
    private static final Log LOGGER = LogFactory.getLog(PdfProduceService.class);

    public PdfReturnBean generatorInvoice(String blockchain, String tag, String invoiceType, Image image, String templatePath, String JQBH, RESPONSE_FPKJ RESPONSE_FPKJ2, COMMON_FPKJ_FPT COMMON_FPKJ_FPT2, List<COMMON_FPKJ_XMXX> COMMON_FPKJ_XMXXS, String inventoryFlag) {
        PdfReturnBean pdfReturnBean = new PdfReturnBean();
        if (StringUtils.isEmpty((CharSequence)RESPONSE_FPKJ2.getFP_DM()) || StringUtils.isEmpty((CharSequence)RESPONSE_FPKJ2.getFP_HM())) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u53d1\u7968\u8d4b\u7801\u5931\u8d25\uff0c\u53d1\u7968\u4ee3\u7801\u53f7\u7801\u4e3a\u7a7a\uff01", (String)"PdfProduceService_0", (String)"imc-rim-file", (Object[])new Object[0]));
        }
        EInvoiceEntity eInvoiceEntity = new EInvoiceEntity();
        this.converInvoiceEntity2EInvoiceEntity(JQBH, RESPONSE_FPKJ2, COMMON_FPKJ_FPT2, COMMON_FPKJ_XMXXS, eInvoiceEntity);
        this.generatePdfFile(blockchain, invoiceType, image, templatePath, eInvoiceEntity, pdfReturnBean, inventoryFlag);
        return pdfReturnBean;
    }

    private void converInvoiceEntity2EInvoiceEntity(String JQBH, RESPONSE_FPKJ RESPONSE_FPKJ2, COMMON_FPKJ_FPT COMMON_FPKJ_FPT2, List<COMMON_FPKJ_XMXX> COMMON_FPKJ_XMXXS, EInvoiceEntity eInvoiceEntity) {
        DecimalFormat df = new DecimalFormat("#########0.00");
        eInvoiceEntity.setJqbh(JQBH);
        eInvoiceEntity.setFpdm(RESPONSE_FPKJ2.getFP_DM());
        eInvoiceEntity.setFphm(RESPONSE_FPKJ2.getFP_HM());
        eInvoiceEntity.setYfpdm(COMMON_FPKJ_FPT2.getYFP_DM());
        eInvoiceEntity.setYfphm(COMMON_FPKJ_FPT2.getYFP_HM());
        eInvoiceEntity.setKplx(COMMON_FPKJ_FPT2.getKPLX());
        eInvoiceEntity.setKprq(RESPONSE_FPKJ2.getKPRQ());
        eInvoiceEntity.setJym(RESPONSE_FPKJ2.getJYM());
        eInvoiceEntity.setEwm(RESPONSE_FPKJ2.getEWM().getBytes(StandardCharsets.UTF_8));
        eInvoiceEntity.setGmf_mc(COMMON_FPKJ_FPT2.getGHF_MC());
        eInvoiceEntity.setGmf_nsrsbh(COMMON_FPKJ_FPT2.getGHF_NSRSBH());
        eInvoiceEntity.setGmf_dzdh(StringUtils.trimToEmpty((String)COMMON_FPKJ_FPT2.getGHF_DZ()) + " " + StringUtils.trimToEmpty((String)COMMON_FPKJ_FPT2.getGHF_GDDH()));
        eInvoiceEntity.setGmf_kpyhjzh(COMMON_FPKJ_FPT2.getFKF_YHZH());
        eInvoiceEntity.setMmq(RESPONSE_FPKJ2.getFWMW());
        eInvoiceEntity.setKphjje(df.format(new Double(RESPONSE_FPKJ2.getHJBHSJE())));
        eInvoiceEntity.setSehj(df.format(new Double(COMMON_FPKJ_FPT2.getKPHJSE())));
        eInvoiceEntity.setJshjxxXx(df.format(new Double(COMMON_FPKJ_FPT2.getKPHJJE())));
        eInvoiceEntity.setXsf_mc(COMMON_FPKJ_FPT2.getXHF_MC());
        eInvoiceEntity.setXsf_nsrsbh(COMMON_FPKJ_FPT2.getXHF_NSRSBH());
        eInvoiceEntity.setXsf_dzdh(StringUtils.trimToEmpty((String)COMMON_FPKJ_FPT2.getXHF_DZ()) + " " + StringUtils.trimToEmpty((String)COMMON_FPKJ_FPT2.getXHF_DH()));
        eInvoiceEntity.setXsf_khyhjzh(COMMON_FPKJ_FPT2.getSKF_YHZH());
        eInvoiceEntity.setBz(COMMON_FPKJ_FPT2.getBZ());
        eInvoiceEntity.setSkr(COMMON_FPKJ_FPT2.getSKY());
        eInvoiceEntity.setFhr(COMMON_FPKJ_FPT2.getFHR());
        eInvoiceEntity.setKpr(COMMON_FPKJ_FPT2.getKPY());
        EInvoiceMxEntity[] eInvoiceMxEntitys = new EInvoiceMxEntity[COMMON_FPKJ_XMXXS.size()];
        EInvoiceMxEntity eInvoiceMxEntity = null;
        for (int i = 0; i < COMMON_FPKJ_XMXXS.size(); ++i) {
            eInvoiceMxEntity = new EInvoiceMxEntity();
            eInvoiceMxEntity.setHwmc(COMMON_FPKJ_XMXXS.get(i).getXMMC());
            eInvoiceMxEntity.setGgxh(COMMON_FPKJ_XMXXS.get(i).getGGXH());
            eInvoiceMxEntity.setDw(COMMON_FPKJ_XMXXS.get(i).getXMDW());
            eInvoiceMxEntity.setShul(COMMON_FPKJ_XMXXS.get(i).getXMSL());
            eInvoiceMxEntity.setDj(COMMON_FPKJ_XMXXS.get(i).getXMDJ());
            eInvoiceMxEntity.setJe(COMMON_FPKJ_XMXXS.get(i).getXMJE());
            eInvoiceMxEntity.setShuil(COMMON_FPKJ_XMXXS.get(i).getSL());
            eInvoiceMxEntity.setSe(COMMON_FPKJ_XMXXS.get(i).getSE());
            eInvoiceMxEntity.setIsDiscount(COMMON_FPKJ_XMXXS.get(i).getFPHXZ());
            eInvoiceMxEntitys[i] = eInvoiceMxEntity;
        }
        eInvoiceEntity.seteInvoiceMxEntitys(eInvoiceMxEntitys);
        eInvoiceEntity.setPurcharseSign(COMMON_FPKJ_FPT2.isPurcharseSign());
        boolean isProductOil = true;
        if (COMMON_FPKJ_XMXXS.size() > 8) {
            isProductOil = false;
        } else {
            for (COMMON_FPKJ_XMXX item : COMMON_FPKJ_XMXXS) {
                if (isProductOil = isProductOil && item.isProductOil()) continue;
                break;
            }
        }
        eInvoiceEntity.setProductOil(isProductOil);
    }

    private void generatePdfFile(String blockchain, String invoiceType, Image image, String templatePath, EInvoiceEntity eInvoiceEntity, PdfReturnBean pdfReturnBean, String inventoryFlag) {
        TextFactory iTextFactory = new TextFactory();
        HashMap<String, Object> qzMap = new HashMap<String, Object>();
        qzMap.put("templatePath", templatePath);
        qzMap.put("image", image);
        qzMap.put("invoiceType", invoiceType);
        qzMap.put("blockchain", blockchain);
        qzMap.put("inventoryFlag", inventoryFlag);
        StencilPlate stencilPlate = this.generatePdfFptxx(eInvoiceEntity, blockchain);
        Map<Integer, Object> resultMap = iTextFactory.producePDF(stencilPlate, qzMap);
        pdfReturnBean.setResultMap(resultMap);
        pdfReturnBean.setKpxmLen(String.valueOf(qzMap.get("kpxmLen")));
    }

    private StencilPlate generatePdfFptxx(EInvoiceEntity eInvoiceEntity, String blockchain) {
        DecimalFormat df = new DecimalFormat("#########0.00");
        StencilPlate stencilPlate = new StencilPlate();
        stencilPlate.setXhfsbm(eInvoiceEntity.getXsf_nsrsbh());
        if (eInvoiceEntity.getGmf_dzdh() != null) {
            if (eInvoiceEntity.getGmf_dzdh().startsWith(" ") || eInvoiceEntity.getGmf_dzdh().endsWith(" ")) {
                stencilPlate.setGmfdz(eInvoiceEntity.getGmf_dzdh().replace(" ", ""));
            } else {
                stencilPlate.setGmfdz(eInvoiceEntity.getGmf_dzdh());
            }
        }
        if (eInvoiceEntity.getGmf_kpyhjzh() != null) {
            if (eInvoiceEntity.getGmf_kpyhjzh().startsWith(" ") || eInvoiceEntity.getGmf_kpyhjzh().endsWith(" ")) {
                stencilPlate.setGmfyh(eInvoiceEntity.getGmf_kpyhjzh().replace(" ", ""));
            } else {
                stencilPlate.setGmfyh(eInvoiceEntity.getGmf_kpyhjzh());
            }
        }
        stencilPlate.setKhmc(eInvoiceEntity.getGmf_mc());
        stencilPlate.setKhsbm(eInvoiceEntity.getGmf_nsrsbh());
        Double billingAmount = Double.parseDouble(eInvoiceEntity.getJshjXx());
        Double Jshj = Double.parseDouble(eInvoiceEntity.getHjje()) + Double.parseDouble(eInvoiceEntity.getHjse());
        stencilPlate.setKphjje("\u00a5" + eInvoiceEntity.getHjje());
        stencilPlate.setJshjxx("\u00a5" + df.format(Jshj));
        stencilPlate.setSehj("\u00a5" + df.format(Double.parseDouble(eInvoiceEntity.getHjse())));
        if (billingAmount < 0.0) {
            stencilPlate.setJshjdx("(\u8d1f\u6570)" + MathUtil.number2CNMontrayUnit(BigDecimal.valueOf(Math.abs(Jshj))));
        } else {
            stencilPlate.setJshjdx(MathUtil.number2CNMontrayUnit(BigDecimal.valueOf(Jshj)));
        }
        if (eInvoiceEntity.isPurcharseSign()) {
            stencilPlate.setCpy("\u6536\u8d2d");
        }
        if ("0".equals(eInvoiceEntity.getKplx())) {
            LOGGER.info("eInvoiceEntity:" + eInvoiceEntity);
            LOGGER.info("stencilPlate:" + stencilPlate);
            stencilPlate.setKplx("");
            stencilPlate.setBz(eInvoiceEntity.getBz());
            if (eInvoiceEntity.isProductOil()) {
                stencilPlate.setCpy("\u6210\u54c1\u6cb9");
            }
        } else if ("1".equals(eInvoiceEntity.getKplx())) {
            stencilPlate.setKplx("\u9500\u9879\u8d1f\u6570");
            if (eInvoiceEntity.isProductOil()) {
                stencilPlate.setCpy("\u6210\u54c1\u6cb9");
            }
            if (!StringUtils.isEmpty((CharSequence)eInvoiceEntity.getBz())) {
                stencilPlate.setBz(eInvoiceEntity.getBz());
            } else {
                stencilPlate.setBz("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801:" + eInvoiceEntity.getYfpdm() + "\u53f7\u7801:" + eInvoiceEntity.getYfphm());
            }
        }
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyyMMdd");
        DateTime dt = new DateTime((Object)eInvoiceEntity.getKprq().substring(0, 10).replaceAll("-", ""));
        String kprqStr1 = eInvoiceEntity.getKprq().substring(0, 4);
        String kprqStr2 = eInvoiceEntity.getKprq().substring(5, 7);
        String kprqStr3 = eInvoiceEntity.getKprq().substring(8, 10);
        String kprqStr = kprqStr1 + "\u5e74" + kprqStr2 + "\u6708" + kprqStr3 + "\u65e5";
        stencilPlate.setKprq(kprqStr);
        stencilPlate.setKprq_n(fmt.print((ReadableInstant)dt).substring(0, 4));
        stencilPlate.setKprq_y(fmt.print((ReadableInstant)dt).substring(4, 6));
        stencilPlate.setKprq_r(fmt.print((ReadableInstant)dt).substring(6, 8));
        stencilPlate.setKpy(eInvoiceEntity.getKpr());
        stencilPlate.setSkr(eInvoiceEntity.getSkr());
        stencilPlate.setFhr(eInvoiceEntity.getFhr());
        if (eInvoiceEntity.getXsf_khyhjzh() != null) {
            if (eInvoiceEntity.getXsf_khyhjzh().startsWith(" ") || eInvoiceEntity.getXsf_khyhjzh().endsWith(" ")) {
                stencilPlate.setXhfyh(eInvoiceEntity.getXsf_khyhjzh().replace(" ", ""));
            } else {
                stencilPlate.setXhfyh(eInvoiceEntity.getXsf_khyhjzh());
            }
        }
        if (eInvoiceEntity.getXsf_dzdh().startsWith(" ") || eInvoiceEntity.getXsf_dzdh().endsWith(" ")) {
            stencilPlate.setXhfdz(eInvoiceEntity.getXsf_dzdh().replace(" ", ""));
        } else {
            stencilPlate.setXhfdz(eInvoiceEntity.getXsf_dzdh());
        }
        stencilPlate.setXhfmc(eInvoiceEntity.getXsf_mc());
        stencilPlate.setXhfsbm(eInvoiceEntity.getXsf_nsrsbh());
        String Ciphertext = eInvoiceEntity.getMmq();
        int mmqlength = Ciphertext.length();
        int l = mmqlength / 4;
        if (StringUtils.isNotEmpty((CharSequence)blockchain)) {
            StringBuilder cipherPadding = new StringBuilder();
            cipherPadding.append(Ciphertext.charAt(0));
            for (int i = 1; i < mmqlength; ++i) {
                cipherPadding.append(' ');
                cipherPadding.append(Ciphertext.charAt(i));
            }
            String cipherPaddingText = cipherPadding.toString();
            stencilPlate.setMmq(cipherPaddingText.substring(0, 43));
            stencilPlate.setMmq1(cipherPaddingText.substring(44, 87));
            stencilPlate.setMmq2(cipherPaddingText.substring(88, 131));
        } else {
            stencilPlate.setMmq(Ciphertext.substring(0, l));
            stencilPlate.setMmq1(Ciphertext.substring(l, 2 * l));
            stencilPlate.setMmq2(Ciphertext.substring(2 * l, 3 * l));
            stencilPlate.setMmq3(Ciphertext.substring(3 * l, mmqlength));
        }
        stencilPlate.setFwm(eInvoiceEntity.getJym());
        stencilPlate.setEwm(new String(eInvoiceEntity.getEwm(), StandardCharsets.UTF_8));
        stencilPlate.setFp_dm(eInvoiceEntity.getFpdm());
        stencilPlate.setFp_hm(eInvoiceEntity.getFphm());
        stencilPlate.setJqbh(eInvoiceEntity.getJqbh());
        stencilPlate.setStencilPlageMxs(this.generatePdfFpMxxx(eInvoiceEntity));
        String slbz = "";
        boolean flag = false;
        StencilPlageMx[] stencilPlageMxs = stencilPlate.getStencilPlageMxs();
        if (stencilPlageMxs != null && stencilPlageMxs.length > 0) {
            StencilPlageMx fpkjxxXmxxsl = stencilPlageMxs[0];
            for (int i = 1; i < stencilPlate.getStencilPlageMxs().length; ++i) {
                if (stencilPlate.getStencilPlageMxs()[i].getSuil().equals(fpkjxxXmxxsl.getSuil())) continue;
                flag = true;
                break;
            }
            slbz = !flag ? fpkjxxXmxxsl.getSuil() : "";
        }
        stencilPlate.setSlbz(slbz);
        return stencilPlate;
    }

    private StencilPlageMx[] generatePdfFpMxxx(EInvoiceEntity eInvoiceEntity) {
        DecimalFormat df = new DecimalFormat("#########0.00");
        EInvoiceMxEntity[] eInvoiceMxEntitys = eInvoiceEntity.geteInvoiceMxEntitys();
        StencilPlageMx[] stencilPlageMxes = new StencilPlageMx[eInvoiceMxEntitys.length];
        StencilPlageMx stencilPlageMx = null;
        for (int i = 0; i < eInvoiceMxEntitys.length; ++i) {
            stencilPlageMx = new StencilPlageMx();
            stencilPlageMx.setXm(eInvoiceMxEntitys[i].getHwmc());
            stencilPlageMx.setDj(eInvoiceMxEntitys[i].getDj());
            stencilPlageMx.setSl(eInvoiceMxEntitys[i].getShul());
            stencilPlageMx.setDw(eInvoiceMxEntitys[i].getDw());
            stencilPlageMx.setGgxh(eInvoiceMxEntitys[i].getGgxh());
            stencilPlageMx.setJe(df.format(Double.valueOf(eInvoiceMxEntitys[i].getJe())) + "  ");
            stencilPlageMx.setSuil(eInvoiceMxEntitys[i].getShuil());
            if ("***".equals(eInvoiceMxEntitys[i].getSe())) {
                stencilPlageMx.setSe(eInvoiceMxEntitys[i].getSe());
            } else {
                stencilPlageMx.setSe(df.format(Double.valueOf(eInvoiceMxEntitys[i].getSe())) + "  ");
            }
            stencilPlageMx.setXh(String.valueOf(i + 1));
            stencilPlageMxes[i] = stencilPlageMx;
        }
        return stencilPlageMxes;
    }
}

