/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.service;

import com.lowagie.text.Image;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.model.protocol.COMMON_FPKJ_FPT;
import kd.imc.rim.file.model.protocol.COMMON_FPKJ_XMXX;
import kd.imc.rim.file.model.protocol.FP_KJMX;
import kd.imc.rim.file.model.protocol.PdfProduceBean;
import kd.imc.rim.file.model.protocol.REQUEST_COMMON_FPKJ;
import kd.imc.rim.file.model.protocol.REQUEST_FPKJ;
import kd.imc.rim.file.model.protocol.RESPONSE_FPKJ;
import kd.imc.rim.file.model.qrcode.QrcodeBean;
import kd.imc.rim.file.utils.DateUtil;
import kd.imc.rim.file.utils.Handle;
import kd.imc.rim.file.utils.MathUtil;
import kd.imc.rim.file.utils.QrcodeUtil;

public class TaxCodeService {
    private static final Log logger = LogFactory.getLog(TaxCodeService.class);

    public PdfProduceBean taxCode(REQUEST_COMMON_FPKJ REQUEST_COMMON_FPKJ2, Map<String, Object> paramMap) {
        PdfProduceBean pdfProduceBean = new PdfProduceBean();
        pdfProduceBean = this.mapToBean(pdfProduceBean, REQUEST_COMMON_FPKJ2, paramMap);
        return pdfProduceBean;
    }

    private PdfProduceBean mapToBean(PdfProduceBean pdfProduceBean, REQUEST_COMMON_FPKJ request_COMMON_FPKJ, Map<String, Object> paramMap) {
        logger.info("\u5f00\u59cb\u8f6c\u6362......");
        RESPONSE_FPKJ RESPONSE_FPKJ2 = new RESPONSE_FPKJ();
        RESPONSE_FPKJ2.setJYM((String)paramMap.get("JYM"));
        RESPONSE_FPKJ2.setFP_HM((String)paramMap.get("FP_HM"));
        RESPONSE_FPKJ2.setFP_DM((String)paramMap.get("FP_DM"));
        RESPONSE_FPKJ2.setFWMW((String)paramMap.get("FWMW"));
        RESPONSE_FPKJ2.setSSYF((String)paramMap.get("SSYF"));
        RESPONSE_FPKJ2.setKPRQ((String)paramMap.get("KPRQ"));
        RESPONSE_FPKJ2.setHJBHSJE((String)paramMap.get("HJBHSJE"));
        RESPONSE_FPKJ2.setSehj((String)paramMap.get("HJSE"));
        RESPONSE_FPKJ2.setEWM(this.generateTwoDimCode(paramMap));
        String JQBH = (String)paramMap.get("jqbh");
        pdfProduceBean.setTemplatePath((String)paramMap.get("templatePath"));
        pdfProduceBean.setImage((Image)paramMap.get("image"));
        pdfProduceBean.setInvoiceType((String)paramMap.get("invoiceType"));
        pdfProduceBean.setTag((String)paramMap.get("tag"));
        pdfProduceBean.setBlockchain((String)paramMap.get("blockchain"));
        pdfProduceBean.setInventoryFlag((String)paramMap.get("inventoryFlag"));
        pdfProduceBean.setJQBH(JQBH);
        pdfProduceBean.setCOMMON_FPKJ_FPT(request_COMMON_FPKJ.getCOMMON_FPKJ_FPT());
        pdfProduceBean.setCOMMON_FPKJ_XMXXS(request_COMMON_FPKJ.getCOMMON_FPKJ_XMXXS());
        pdfProduceBean.setRESPONSE_FPKJ(RESPONSE_FPKJ2);
        return pdfProduceBean;
    }

    private Map<String, Object> organizeParamMap(REQUEST_COMMON_FPKJ REQUEST_COMMON_FPKJ2) {
        COMMON_FPKJ_FPT COMMON_FPKJ_FPT2 = REQUEST_COMMON_FPKJ2.getCOMMON_FPKJ_FPT();
        REQUEST_FPKJ REQUEST_FPKJ2 = new REQUEST_FPKJ(COMMON_FPKJ_FPT2);
        List<COMMON_FPKJ_XMXX> COMMON_FPKJ_XMXXS = REQUEST_COMMON_FPKJ2.getCOMMON_FPKJ_XMXXS();
        ArrayList<FP_KJMX> fp_KJMXs = new ArrayList<FP_KJMX>(16);
        for (COMMON_FPKJ_XMXX common_FPKJ_XMXX : COMMON_FPKJ_XMXXS) {
            FP_KJMX fp_KJMX = new FP_KJMX(common_FPKJ_XMXX);
            fp_KJMXs.add(fp_KJMX);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("fptxx", REQUEST_FPKJ2);
        paramMap.put("fpkjmxList", fp_KJMXs);
        return paramMap;
    }

    private String generateTwoDimCode(Map<String, Object> map) {
        QrcodeBean QrcodeBean2 = new QrcodeBean();
        QrcodeBean2.setHEAD_version("01");
        QrcodeBean2.setEXPRESS_eInvoiceType("10");
        QrcodeBean2.setEXPRESS_eInvoiceCode(map.get("FP_DM").toString());
        QrcodeBean2.setEXPRESS_EInvoiceNo(map.get("FP_HM").toString());
        String hjbhsje = map.get("HJBHSJE").toString();
        try {
            hjbhsje = MathUtil.formatDoubleDigit(Double.parseDouble(hjbhsje));
        }
        catch (Exception e) {
            logger.error("--\u7ebf\u7a0b\uff08ID\uff1a" + Thread.currentThread().getId() + "\uff09\uff0c\u683c\u5f0f\u5316\u5408\u8ba1\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u8be6\u60c5\u4e3a\uff1a", (Throwable)e);
            hjbhsje = map.get("HJBHSJE").toString();
        }
        QrcodeBean2.setEXPRESS_billingAmount(hjbhsje);
        if (Handle.isNotEmpty(map.get("KPRQ"))) {
            String dateString = map.get("KPRQ").toString();
            Date date = null;
            String fmtDate = "";
            try {
                if (dateString.length() > 10) {
                    date = DateUtil.parseDate("yyyy-MM-dd HH:mm:ss", dateString);
                    fmtDate = DateUtil.formatDate("yyyyMMdd", date);
                } else {
                    date = DateUtil.parseDate("yyyy-MM-dd", dateString);
                    fmtDate = DateUtil.formatDate("yyyyMMdd", date);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            QrcodeBean2.setEXPRESS_billingDate(fmtDate);
        }
        QrcodeBean2.setEXPRESS_checkCode((String)map.get("JYM"));
        return QrcodeUtil.generationQrcode(QrcodeBean2);
    }

    private PdfProduceBean testCard(PdfProduceBean pdfProduceBean, REQUEST_COMMON_FPKJ rEQUEST_COMMON_FPKJ) {
        RESPONSE_FPKJ RESPONSE_FPKJ2 = new RESPONSE_FPKJ();
        RESPONSE_FPKJ2.setRETCODE("4011");
        RESPONSE_FPKJ2.setJYM("65560891271390877510");
        RESPONSE_FPKJ2.setRETURNCODE("4011");
        RESPONSE_FPKJ2.setFP_HM("102014");
        RESPONSE_FPKJ2.setXHQDBZ("213232");
        RESPONSE_FPKJ2.setFP_DM("123456");
        RESPONSE_FPKJ2.setRETURNMESSAGE("1");
        RESPONSE_FPKJ2.setFWMW("6134*3>950+75<8/1208-85*</*14>-65-142/+7390*24855672678136749+92184+/8*553-9-8-+5*</*1/670433467<<3<0*24<4*6");
        RESPONSE_FPKJ2.setSSYF("123");
        RESPONSE_FPKJ2.setKPRQ(DateUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date()));
        RESPONSE_FPKJ2.setSZQM("1");
        RESPONSE_FPKJ2.setHJBHSJE(rEQUEST_COMMON_FPKJ.getCOMMON_FPKJ_FPT().getHJBHSJE());
        RESPONSE_FPKJ2.setSehj(rEQUEST_COMMON_FPKJ.getCOMMON_FPKJ_FPT().getKPHJSE());
        RESPONSE_FPKJ2.setEWM("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");
        String JQBH = "12345678";
        pdfProduceBean.setJQBH(JQBH);
        pdfProduceBean.setCOMMON_FPKJ_FPT(rEQUEST_COMMON_FPKJ.getCOMMON_FPKJ_FPT());
        pdfProduceBean.setCOMMON_FPKJ_XMXXS(rEQUEST_COMMON_FPKJ.getCOMMON_FPKJ_XMXXS());
        pdfProduceBean.setRESPONSE_FPKJ(RESPONSE_FPKJ2);
        return pdfProduceBean;
    }
}

