/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.service.einvoicepdf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.service.einvoicepdf.FullDigitalEInvoicePdfWriteDataService;
import kd.imc.rim.file.service.einvoicepdf.FullDigitalEInvoicePdfWritePathService;
import kd.imc.rim.file.service.einvoicepdf.dto.CargoTransportItem;
import kd.imc.rim.file.service.einvoicepdf.dto.FDEIPositionContent;
import kd.imc.rim.file.service.einvoicepdf.dto.FullDigitalEInvoice;
import kd.imc.rim.file.service.einvoicepdf.dto.PDFTemplatePosition;
import kd.imc.rim.file.service.einvoicepdf.dto.PassengerTransportItem;
import kd.imc.rim.file.service.einvoicepdf.enums.DifferenceTaxTypeEnum;
import kd.imc.rim.file.service.einvoicepdf.enums.InvoiceTypeEnum;
import kd.imc.rim.file.service.einvoicepdf.enums.SpecialTypeEnum;
import kd.imc.rim.file.service.einvoicepdf.enums.ZeroTaxRateFlagEnum;
import kd.imc.rim.file.utils.BigDecimalUtil;
import kd.imc.rim.file.utils.EInvoicePdfUtils;
import kd.imc.rim.file.utils.JsonUtils;
import kd.imc.rim.file.utils.MoneyUtil;
import kd.imc.rim.file.utils.PDFXmlUtils;
import kd.imc.rim.file.utils.StrUtil;
import kd.imc.rim.file.utils.common.DateUtils;
import kd.imc.rim.file.utils.common.QRCodeUtil;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;

public class FullDigitalEInvoicePdfService {
    private static final Log log = LogFactory.getLog(FullDigitalEInvoicePdfService.class);

    public byte[] createPdf(FullDigitalEInvoice fullDigitalEInvoice) {
        InvoiceTypeEnum invoiceType = InvoiceTypeEnum.getInvoiceTypeByValue(fullDigitalEInvoice.getInvoiceType());
        if (invoiceType == null) {
            return null;
        }
        String specialTypeStr = fullDigitalEInvoice.getSpecialType();
        SpecialTypeEnum specialType = SpecialTypeEnum.getSpecialTypeByValue(specialTypeStr);
        JSONObject templateJson = PDFXmlUtils.getPDFTemplateInfoFromXMLFile("template/full-digital-invoice-pdf.xml");
        if (templateJson.containsKey((Object)"TEMPLATE")) {
            templateJson = templateJson.getJSONObject("TEMPLATE");
        }
        JSONObject jjzJson = templateJson.getJSONObject("JJZ");
        List<PDFTemplatePosition> jjzPositionList = FullDigitalEInvoicePdfService.getJJZPositionList(jjzJson, fullDigitalEInvoice.getSalerTaxNo());
        JSONObject titleJson = templateJson.getJSONObject("TITLE");
        List<PDFTemplatePosition> titlePositionList = FullDigitalEInvoicePdfService.getTitlePositionList(titleJson, invoiceType.name());
        PDFTemplatePosition drawerPosition = (PDFTemplatePosition)JSONObject.toJavaObject((JSON)templateJson.getJSONObject("drawer"), PDFTemplatePosition.class);
        PDFTemplatePosition dwfPosition = (PDFTemplatePosition)JSONObject.toJavaObject((JSON)templateJson.getJSONObject("DWF"), PDFTemplatePosition.class);
        PDFTemplatePosition pageNoPosition = (PDFTemplatePosition)JSONObject.parseObject((String)JSON.toJSONString((Object)templateJson.getJSONObject("pageNo")), PDFTemplatePosition.class);
        JSONObject contentJson = this.getContentJsonBySpecialType(templateJson, specialType);
        ArrayList<List<PDFTemplatePosition>> specialDataList = new ArrayList<List<PDFTemplatePosition>>();
        ArrayList<Integer> specialLineNumList = new ArrayList<Integer>();
        this.setSpecialDataList(specialDataList, specialLineNumList, fullDigitalEInvoice, contentJson, specialType);
        FDEIPositionContent contentPosition = this.getContentPosition(fullDigitalEInvoice, contentJson, specialType, specialLineNumList);
        contentPosition.setJjzPositionList(jjzPositionList);
        contentPosition.setTitlePositionList(titlePositionList);
        contentPosition.getDrawerPositionList().add(drawerPosition);
        contentPosition.getLastPositionList().add(dwfPosition);
        contentPosition.setPageNoPosition(pageNoPosition);
        contentPosition.setSpecialType(specialType);
        contentPosition.setSpecialPositionList(specialDataList);
        byte[] pdfBytes = this.createPdfByPosition(contentPosition, specialLineNumList);
        if (pdfBytes == null) {
            return null;
        }
        return pdfBytes;
    }

    private JSONObject getContentJsonBySpecialType(JSONObject templateJson, SpecialTypeEnum specialType) {
        JSONObject contentJson = templateJson.getJSONObject("CONTENT");
        if (SpecialTypeEnum.CONSTRUCTION_SERVICE == specialType) {
            JSONObject construction = contentJson.getJSONObject(SpecialTypeEnum.CONSTRUCTION_SERVICE.getIdentification());
            contentJson.putAll((Map)construction);
        } else if (SpecialTypeEnum.REAL_ESTATE_OPERATING_LEASE == specialType || SpecialTypeEnum.SALE_OF_REAL_ESTATE == specialType) {
            JSONObject estate = contentJson.getJSONObject(SpecialTypeEnum.REAL_ESTATE_OPERATING_LEASE.getIdentification());
            contentJson.putAll((Map)estate);
        } else {
            contentJson.putAll((Map)contentJson.getJSONObject("common"));
        }
        if (SpecialTypeEnum.CARGO_TRANSPORT_SERVICE == specialType) {
            JSONObject cargoTransport = contentJson.getJSONObject("cargoTransport");
            contentJson.putAll((Map)cargoTransport);
        } else if (SpecialTypeEnum.PASSENGER_TRANSPORT == specialType) {
            JSONObject passengerTransport = contentJson.getJSONObject("passengerTransport");
            contentJson.putAll((Map)passengerTransport);
        }
        return contentJson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] createPdfByPosition(FDEIPositionContent contentPosition, List<Integer> specialLineNumList) {
        float diffYMM;
        int i;
        BaseFont[] fonts;
        FullDigitalEInvoicePdfWriteDataService writeDataService = new FullDigitalEInvoicePdfWriteDataService();
        try {
            BaseFont courierFont = BaseFont.createFont((String)"fonts/cour.ttf", (String)"Identity-H", (boolean)false);
            BaseFont kaiFont = BaseFont.createFont((String)"fonts/simkai.ttf", (String)"Identity-H", (boolean)false);
            BaseFont songFont = BaseFont.createFont((String)"fonts/simsun.ttc,0", (String)"Identity-H", (boolean)false);
            fonts = new BaseFont[]{songFont, courierFont, kaiFont};
        }
        catch (Exception e) {
            log.error("\u5b57\u4f53\u6587\u4ef6\u4e0d\u5b58\u5728", (Throwable)e);
            return null;
        }
        List<List<PDFTemplatePosition>> detailPositionList = contentPosition.getDetailPositionList();
        List<Integer> currentPageSizeList = contentPosition.getCurrentPageSizeList();
        ArrayList<byte[]> bytesList = new ArrayList<byte[]>();
        int pageNum = contentPosition.getPageNumber();
        boolean lastFlag = false;
        int specialLineNum = specialLineNumList.size();
        if (specialLineNum != 0) {
            --specialLineNum;
        }
        int totalPageNum = pageNum + specialLineNum;
        boolean multiPage = false;
        if (totalPageNum > 1) {
            multiPage = true;
        }
        int pageNo = 0;
        for (i = 0; i < pageNum; ++i) {
            float specialHeight = 0.0f;
            float diffY = 0.0f;
            diffYMM = 0.0f;
            float tableContentHeight = 0.0f;
            List<PDFTemplatePosition> detailDataList = detailPositionList.get(i);
            int currentPageSize = currentPageSizeList.get(i);
            if (i == pageNum - 1 && specialLineNumList.size() < 2) {
                lastFlag = true;
            }
            if (i == 0 && !specialLineNumList.isEmpty()) {
                specialHeight = (float)specialLineNumList.get(0).intValue() * 4.5f;
            }
            if (currentPageSize > 8) {
                diffYMM = tableContentHeight = (float)(currentPageSize - 8) * 4.5f;
            }
            if (multiPage) {
                diffYMM = lastFlag ? (diffYMM += 5.0f) : (diffYMM -= 23.0f);
            }
            if (specialHeight > 0.0f) {
                diffYMM = diffYMM + specialHeight + 5.0f;
            }
            this.setEveryPageDataToPdf(bytesList, contentPosition, detailDataList, fonts, multiPage, lastFlag, totalPageNum, pageNo, diffYMM, tableContentHeight, specialHeight);
            ++pageNo;
        }
        for (i = 1; i < specialLineNumList.size(); ++i) {
            if (i == specialLineNumList.size() - 1) {
                lastFlag = true;
            }
            int currentPageSize = specialLineNumList.get(i);
            float tableContentHeight = (float)currentPageSize * 4.5f;
            diffYMM = (float)(currentPageSize - 8) * 4.5f;
            if (multiPage && !lastFlag) {
                diffYMM -= 28.0f;
            }
            List<PDFTemplatePosition> detailDataList = contentPosition.getSpecialPositionList().get(i);
            this.setEveryPageDataToPdf(bytesList, contentPosition, detailDataList, fonts, multiPage, lastFlag, totalPageNum, pageNo, diffYMM, tableContentHeight, -1.0f);
            ++pageNo;
        }
        PdfCopy pdfCopy = null;
        Document doc = null;
        try {
            Object object;
            Throwable throwable;
            ByteArrayOutputStream bos;
            block33: {
                block34: {
                    bos = new ByteArrayOutputStream();
                    throwable = null;
                    doc = new Document();
                    pdfCopy = new PdfCopy(doc, (OutputStream)bos);
                    pdfCopy.setFullCompression();
                    doc.open();
                    for (byte[] bytes : bytesList) {
                        PdfImportedPage impPage = pdfCopy.getImportedPage(new PdfReader(bytes), 1);
                        pdfCopy.addPage(impPage);
                    }
                    pdfCopy.close();
                    object = bos.toByteArray();
                    if (bos == null) break block33;
                    if (throwable == null) break block34;
                    try {
                        bos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block33;
                }
                bos.close();
            }
            return object;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (bos != null) {
                            if (throwable != null) {
                                try {
                                    bos.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                bos.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (DocumentException | IOException e) {
                    log.error("\u751f\u6210PDF\u51fa\u9519\uff0c\u5904\u7406\u7ed3\u679c\u6587\u4ef6\u65f6\u65e0\u6cd5\u6b63\u5e38\u8bfb\u53d6/\u5173\u95ed\u6587\u4ef6\u6d41", e);
                    byte[] byArray = null;
                    return byArray;
                }
            }
        }
        finally {
            if (pdfCopy != null) {
                pdfCopy.close();
            }
            if (doc != null) {
                doc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEveryPageDataToPdf(List<byte[]> bytesList, FDEIPositionContent contentPosition, List<PDFTemplatePosition> detailDataList, BaseFont[] fonts, boolean multiPage, boolean lastFlag, int pageTotalNum, int pageIndex, float diffYMM, float tableContentHeight, float specialHeight) {
        double epsilon = 1.0E-6;
        boolean specialFlag = (double)Math.abs(specialHeight - -1.0f) < epsilon;
        FullDigitalEInvoicePdfWriteDataService writeDataService = new FullDigitalEInvoicePdfWriteDataService();
        List<PDFTemplatePosition> lastPositionList = contentPosition.getLastPositionList();
        List<List<PDFTemplatePosition>> subMoneyPositionList = contentPosition.getSubMoneyPositionList();
        SpecialTypeEnum specialType = contentPosition.getSpecialType();
        List<List<PDFTemplatePosition>> specialPositionList = contentPosition.getSpecialPositionList();
        float diffY = 0.0f;
        if ((double)Math.abs(diffYMM) > epsilon) {
            diffY = EInvoicePdfUtils.getPxByMm(diffYMM);
        }
        PdfReader reader = null;
        PdfStamper stamp = null;
        try (ByteArrayOutputStream bao = new ByteArrayOutputStream();){
            byte[] blankBytes = EInvoicePdfUtils.generateBlankPdf(210.0f, 140.0f + diffYMM);
            reader = new PdfReader(blankBytes);
            stamp = new PdfStamper(reader, (OutputStream)bao);
            PdfContentByte under = stamp.getOverContent(1);
            this.setCommonData(contentPosition, under, fonts, pageTotalNum, pageIndex + 1, diffY, diffYMM);
            writeDataService.drawTable(under, specialType, diffYMM, tableContentHeight, specialHeight, lastFlag, multiPage);
            if (specialFlag) {
                this.setData(under, fonts, detailDataList, 0.0f, diffY + 125.0f);
            } else {
                this.setData(under, fonts, detailDataList, 0.0f, diffY);
                if (pageIndex == 0 && !specialPositionList.isEmpty()) {
                    specialHeight = multiPage ? (specialHeight -= 23.0f) : (specialHeight += 5.0f);
                    this.setData(under, fonts, specialPositionList.get(0), 0.0f, EInvoicePdfUtils.getPxByMm(specialHeight));
                }
            }
            float lastDiffY = 0.0f;
            if (multiPage) {
                if (!specialFlag) {
                    List<PDFTemplatePosition> subMoney = subMoneyPositionList.get(pageIndex);
                    this.setData(under, fonts, subMoney, 0.0f, diffY);
                } else {
                    lastDiffY = 9.0f;
                }
            }
            if (lastFlag) {
                this.setData(under, fonts, lastPositionList, 0.0f, lastDiffY);
            }
            stamp.setFormFlattening(true);
            stamp.close();
            bytesList.add(bao.toByteArray());
        }
        catch (DocumentException | IOException e) {
            log.error("\u751f\u6210PDF\u51fa\u9519\uff0c\u5904\u7406\u7ed3\u679c\u6587\u4ef6\u65f6\u65e0\u6cd5\u6b63\u5e38\u8bfb\u53d6/\u5173\u95ed\u6587\u4ef6\u6d41", e);
        }
        finally {
            if (stamp != null) {
                try {
                    stamp.close();
                }
                catch (DocumentException | IOException throwable) {}
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void setCommonData(FDEIPositionContent contentPosition, PdfContentByte under, BaseFont[] fonts, int pageNum, int currentPageNo, float diffY, float diffYMM) throws DocumentException {
        List<PDFTemplatePosition> drawerPosition = contentPosition.getDrawerPositionList();
        String ewmLocation = contentPosition.getEwmLocation();
        List<PDFTemplatePosition> jjzList = contentPosition.getJjzPositionList();
        List<PDFTemplatePosition> titleList = contentPosition.getTitlePositionList();
        PDFTemplatePosition pageNoPosition = contentPosition.getPageNoPosition();
        List<PDFTemplatePosition> basicPositionList = contentPosition.getBasicPositionList();
        this.setData(under, fonts, basicPositionList, 0.0f, diffY);
        this.setData(under, fonts, jjzList, EInvoicePdfUtils.getPxByMm(90.0f), EInvoicePdfUtils.getPxByMm(140.0f + diffYMM - 8.5f - 20.0f));
        this.setData(under, fonts, titleList, 0.0f, diffY);
        if (pageNum > 1) {
            List<PDFTemplatePosition> pageNoList = this.getPageNoList(pageNoPosition, pageNum, currentPageNo);
            this.setData(under, fonts, pageNoList, 0.0f, diffY);
        }
        this.setData(under, fonts, drawerPosition, 0.0f, 0.0f);
        Image ewmImage = contentPosition.getEwmImage();
        String[] str = ewmLocation.split(",");
        String str1 = str[0];
        String str2 = str[str.length - 1];
        ewmImage.setAbsolutePosition(Float.parseFloat(str1), Float.parseFloat(str2) + diffY);
        ewmImage.scalePercent(37.0f);
        under.addImage(ewmImage);
    }

    private void setData(PdfContentByte under, BaseFont[] fonts, List<PDFTemplatePosition> dataList, float diffX, float diffY) {
        FullDigitalEInvoicePdfWriteDataService writeDataService = new FullDigitalEInvoicePdfWriteDataService();
        FullDigitalEInvoicePdfWritePathService writePathService = new FullDigitalEInvoicePdfWritePathService();
        for (PDFTemplatePosition position : dataList) {
            if (position == null) continue;
            if (StringUtils.isNotEmpty((CharSequence)position.getTextLocation())) {
                String ctmStr = position.getCtm();
                String[] ctmArr = null;
                if (!StrUtil.isEmpty(ctmStr)) {
                    ctmArr = ctmStr.split(",");
                }
                String msg = position.getMsg();
                float fontSize = position.getFontSize();
                String textLocation = position.getTextLocation();
                String color = position.getColor();
                Integer[] colorArr = (Integer[])ConvertUtils.convert((String[])color.split(","), Integer.class);
                float space = position.getSpace();
                BaseFont font = EInvoicePdfUtils.getFont(position.getFontName(), fonts);
                if (space != 0.0f) {
                    writeDataService.writePdfDataWithSpace(msg, under, font, Float.valueOf(fontSize), textLocation, colorArr, diffX, diffY, space);
                    continue;
                }
                writeDataService.writePdfData(msg, under, font, Float.valueOf(fontSize), textLocation, colorArr, ctmArr, diffX, diffY, position.getFontAlign());
                continue;
            }
            writePathService.setPathValue(position, under, diffX, diffY);
        }
    }

    private static List<PDFTemplatePosition> getJJZPositionList(JSONObject jjzJson, String nsrsbh) {
        String areaCodeStr = EInvoicePdfUtils.getAreaCodeByNsrsbh(nsrsbh);
        JSONArray commonArray = jjzJson.getJSONArray("COMMON");
        JSONArray areaArray = jjzJson.getJSONArray(areaCodeStr);
        JSONArray dataArray = new JSONArray();
        dataArray.addAll((Collection)commonArray);
        dataArray.addAll((Collection)areaArray);
        return JsonUtils.toList(dataArray, PDFTemplatePosition.class);
    }

    private static List<PDFTemplatePosition> getTitlePositionList(JSONObject titleJson, String type) {
        JSONArray commonArray = titleJson.getJSONArray("COMMON");
        JSONObject typeJson = titleJson.getJSONObject(type);
        JSONArray dataArray = new JSONArray();
        dataArray.addAll((Collection)commonArray);
        dataArray.add((Object)typeJson);
        return JsonUtils.toList(dataArray, PDFTemplatePosition.class);
    }

    private static List<PDFTemplatePosition> getJsonPositionList(JSONObject json, String key) {
        PDFTemplatePosition position = (PDFTemplatePosition)JSONObject.parseObject((String)JSON.toJSONString((Object)json.getJSONObject(key)), PDFTemplatePosition.class);
        ArrayList<PDFTemplatePosition> list = new ArrayList<PDFTemplatePosition>(1);
        list.add(position);
        return list;
    }

    private FDEIPositionContent getContentPosition(FullDigitalEInvoice fullDigitalEInvoice, JSONObject contentJson, SpecialTypeEnum specialType, List<Integer> specialLineNumList) {
        JSONObject dataJson = JsonUtils.parseObj(fullDigitalEInvoice);
        if (log.isInfoEnabled()) {
            log.info(String.format("\u751f\u6210pdf\u7684\u53d1\u7968\u6570\u636e\u662f : %s", dataJson.toJSONString()));
        }
        List<PDFTemplatePosition> basicPositionList = this.getBasicContentPositionList(dataJson, contentJson, specialType);
        if (fullDigitalEInvoice.isInput()) {
            PDFTemplatePosition currentPosition = this.getContentPositionByXmlAndStr(null, "inputDataFlag", contentJson, 0);
            basicPositionList.add(currentPosition);
        }
        ArrayList<List<PDFTemplatePosition>> detailPositionLists = new ArrayList<List<PDFTemplatePosition>>(8);
        ArrayList<List<PDFTemplatePosition>> subMoneyPositionLists = new ArrayList<List<PDFTemplatePosition>>(8);
        ArrayList<Integer> currentPageSizeList = new ArrayList<Integer>(8);
        ArrayList<PDFTemplatePosition> detailPositionList = new ArrayList<PDFTemplatePosition>(8);
        ArrayList<PDFTemplatePosition> subMoneyPositionList = new ArrayList<PDFTemplatePosition>(8);
        ArrayList<PDFTemplatePosition> lastPositionList = new ArrayList<PDFTemplatePosition>(8);
        boolean transferFlag = SpecialTypeEnum.CARGO_TRANSPORT_SERVICE == specialType || SpecialTypeEnum.PASSENGER_TRANSPORT == specialType;
        int currentPageSize = 0;
        int currentPageIndex = 0;
        BigDecimal subMoney = BigDecimal.ZERO;
        BigDecimal subTax = BigDecimal.ZERO;
        boolean lastFlag = false;
        boolean lastDataFlag = false;
        JSONArray detailList = dataJson.getJSONArray("itemList");
        boolean differenceTaxFlag = false;
        String differenceTaxType = fullDigitalEInvoice.getDifferenceTaxType();
        if (DifferenceTaxTypeEnum.PART_DIFF == DifferenceTaxTypeEnum.getDifferenceTaxTypeByValue(differenceTaxType)) {
            differenceTaxFlag = true;
        }
        for (int i = 0; i < detailList.size(); ++i) {
            boolean flag;
            JSONObject detailJson = detailList.getJSONObject(i);
            boolean bl = flag = BigDecimal.ZERO.compareTo(detailJson.getBigDecimal("unitPrice")) == 0 && BigDecimal.ZERO.compareTo(detailJson.getBigDecimal("num")) == 0;
            if (BigDecimal.ZERO.compareTo(detailJson.getBigDecimal("detailAmount")) != 0 && flag) {
                detailJson.put("num", (Object)"");
                detailJson.put("unitPrice", (Object)"");
            }
            for (String key : detailJson.keySet()) {
                PDFTemplatePosition contentPosition;
                if (!contentJson.containsKey((Object)key) || "goodsName".equals(key) || "specModel".equals(key) || "unit".equals(key)) continue;
                if ("taxRate".equals(key)) {
                    this.setTaxRate(detailJson, key, differenceTaxFlag);
                }
                if ((contentPosition = this.getContentPositionByXml(detailJson, key, contentJson, currentPageSize)) == null) continue;
                if (detailPositionList == null) {
                    detailPositionList = new ArrayList(8);
                }
                detailPositionList.add(contentPosition);
            }
            subMoney = subMoney.add(BigDecimalUtil.getJsonBigDecimalVal(detailJson.getString("detailAmount")));
            subTax = subTax.add(BigDecimalUtil.getJsonBigDecimalVal(detailJson.getString("taxAmount")));
            String goodsName = EInvoicePdfUtils.replaceBreakLine(detailJson.getString("goodsName"));
            Integer goodsNameMaxLength = contentJson.getJSONObject("goodsName").getInteger("maxLength");
            if (goodsNameMaxLength == null) {
                goodsNameMaxLength = 11;
            }
            List<String> goodsNameList = EInvoicePdfUtils.subStringByChineseLength(goodsName, goodsNameMaxLength, true);
            String specModel = EInvoicePdfUtils.replaceBreakLine(detailJson.getString("specModel"));
            JSONObject specModelJson = contentJson.getJSONObject("specModel");
            List<Object> specModelList = new ArrayList(8);
            if (specModelJson != null) {
                Integer specModelMaxLength = contentJson.getJSONObject("specModel").getInteger("maxLength");
                if (specModelMaxLength == null) {
                    specModelMaxLength = 7;
                }
                specModelList = EInvoicePdfUtils.subStringByChineseLength(specModel, specModelMaxLength, true);
            }
            String unit = EInvoicePdfUtils.replaceBreakLine(detailJson.getString("unit"));
            Integer unitMaxLength = contentJson.getJSONObject("unit").getInteger("maxLength");
            if (unitMaxLength == null) {
                unitMaxLength = 4;
            }
            List<String> unitList = EInvoicePdfUtils.subStringByChineseLength(unit, unitMaxLength, true);
            int maxNum = Math.max(Math.max(goodsNameList.size(), specModelList.size()), unitList.size());
            for (int j = 0; j < maxNum; ++j) {
                PDFTemplatePosition contentPosition;
                if (detailPositionList == null) {
                    detailPositionList = new ArrayList(8);
                }
                if (subMoneyPositionList == null) {
                    subMoneyPositionList = new ArrayList(8);
                }
                if (j < goodsNameList.size() && !StringUtils.isEmpty((CharSequence)goodsNameList.get(j))) {
                    String currentgoodsName = goodsNameList.get(j);
                    contentPosition = this.getContentPositionByXmlAndStr(currentgoodsName, "goodsName", contentJson, currentPageSize);
                    detailPositionList.add(contentPosition);
                }
                if (j < specModelList.size() && !StringUtils.isEmpty((CharSequence)((CharSequence)specModelList.get(j)))) {
                    String currentspecModel = (String)specModelList.get(j);
                    contentPosition = this.getContentPositionByXmlAndStr(currentspecModel, "specModel", contentJson, currentPageSize);
                    detailPositionList.add(contentPosition);
                }
                if (j < unitList.size() && !StringUtils.isEmpty((CharSequence)unitList.get(j))) {
                    String currentUnit = unitList.get(j);
                    contentPosition = this.getContentPositionByXmlAndStr(currentUnit, "unit", contentJson, currentPageSize);
                    detailPositionList.add(contentPosition);
                }
                ++currentPageSize;
                if (i == detailList.size() - 1 && j == maxNum - 1) {
                    lastDataFlag = true;
                }
                if (lastDataFlag && specialLineNumList.size() < 2) {
                    lastFlag = true;
                }
                int specialMaxNum = 47;
                if (currentPageIndex == 0 && transferFlag) {
                    specialMaxNum = 20;
                }
                if (!lastDataFlag && currentPageSize < specialMaxNum) continue;
                int diffPageY = currentPageSize - 8;
                float totalAmountY = 0.0f;
                if (lastFlag && currentPageIndex == 0) {
                    totalAmountY = EInvoicePdfUtils.getPxByMm(5.0f);
                }
                this.setTotalMoneyList(detailPositionLists, detailPositionList, fullDigitalEInvoice, contentJson, totalAmountY, diffPageY);
                this.setSubMoneyList(subMoneyPositionLists, subMoneyPositionList, contentJson, subMoney, subTax, diffPageY);
                currentPageSizeList.add(currentPageSize);
                ++currentPageIndex;
                currentPageSize = 0;
                subMoney = BigDecimal.ZERO;
                subTax = BigDecimal.ZERO;
                detailPositionList = null;
                subMoneyPositionList = null;
            }
        }
        PDFTemplatePosition drawer = this.getContentPositionByXmlAndStr(fullDigitalEInvoice.getDrawer(), "drawer", contentJson, 0);
        ArrayList<PDFTemplatePosition> drawerList = new ArrayList<PDFTemplatePosition>();
        drawerList.add(drawer);
        this.setLastDataList(lastPositionList, contentJson, fullDigitalEInvoice);
        Image image = QRCodeUtil.encoderQRCodeByte(dataJson);
        String ewmLocation = this.getTextLocationByXml(contentJson.getJSONObject("qrCode"), 0);
        FDEIPositionContent content = new FDEIPositionContent();
        content.setBasicPositionList(basicPositionList);
        content.setCurrentPageSizeList(currentPageSizeList);
        content.setDetailPositionList(detailPositionLists);
        content.setSubMoneyPositionList(subMoneyPositionLists);
        content.setLastPositionList(lastPositionList);
        content.setEwmImage(image);
        content.setPageNumber(currentPageIndex);
        content.setEwmLocation(ewmLocation);
        content.setDrawerPositionList(drawerList);
        return content;
    }

    private void setTotalMoneyList(List<List<PDFTemplatePosition>> detailPositionLists, List<PDFTemplatePosition> detailPositionList, FullDigitalEInvoice fullDigitalEInvoice, JSONObject contentJson, float totalAmountY, int diffPageY) {
        ArrayList<PDFTemplatePosition> detailPositionList2 = new ArrayList<PDFTemplatePosition>(16);
        detailPositionList2.addAll(detailPositionList);
        BigDecimal invoiceAmount = fullDigitalEInvoice.getInvoiceAmount();
        BigDecimal totalTaxAmount = fullDigitalEInvoice.getTotalTaxAmount();
        detailPositionList2.add(this.getContentPositionByXmlAndStrWithDiff(EInvoicePdfUtils.getPriceWithSymbol(invoiceAmount), "invoiceAmount", contentJson, diffPageY, totalAmountY));
        detailPositionList2.add(this.getContentPositionByXmlAndStrWithDiff(EInvoicePdfUtils.getPriceWithSymbol(totalTaxAmount), "totalTaxAmount", contentJson, diffPageY, totalAmountY));
        detailPositionLists.add(detailPositionList2);
    }

    private void setTaxRate(JSONObject detailJson, String key, boolean differenceTaxFlag) {
        ZeroTaxRateFlagEnum zeroTaxRateFlag;
        String taxRateStr = "***";
        String zeroTaxRateFlagStr = detailJson.getString("zeroTaxRateFlag");
        boolean zeroTaxFlag = false;
        if (!StringUtils.isEmpty((CharSequence)zeroTaxRateFlagStr) && (zeroTaxRateFlag = ZeroTaxRateFlagEnum.getZeroTaxRateFlagByValue(zeroTaxRateFlagStr)) != null) {
            if (!differenceTaxFlag) {
                taxRateStr = zeroTaxRateFlag.getMsg();
            }
            detailJson.put("taxAmount", (Object)zeroTaxRateFlag.getTaxAmount());
            zeroTaxFlag = true;
        }
        if (!differenceTaxFlag && !zeroTaxFlag) {
            BigDecimal taxRate = detailJson.getBigDecimal(key);
            if (taxRate == null) {
                taxRate = BigDecimal.ZERO;
            }
            taxRateStr = taxRate.compareTo(new BigDecimal("1")) <= 0 ? taxRate.multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString() + "%" : taxRate.stripTrailingZeros().toPlainString() + "%";
        }
        detailJson.put(key, (Object)taxRateStr);
    }

    private void setSpecialDataList(List<List<PDFTemplatePosition>> specialDataList, List<Integer> specialLineNumList, FullDigitalEInvoice fullDigitalEInvoice, JSONObject contentJson, SpecialTypeEnum specialType) {
        JSONArray specialArray;
        if (SpecialTypeEnum.CARGO_TRANSPORT_SERVICE == specialType) {
            List<CargoTransportItem> cargoTransportList = fullDigitalEInvoice.getCargoTransportList();
            specialArray = new JSONArray(cargoTransportList.size());
            specialArray.addAll(cargoTransportList);
        } else if (SpecialTypeEnum.PASSENGER_TRANSPORT == specialType) {
            List<PassengerTransportItem> passengerTransportList = fullDigitalEInvoice.getTravelerList();
            specialArray = new JSONArray(passengerTransportList.size());
            specialArray.addAll(passengerTransportList);
        } else {
            return;
        }
        if (!specialArray.isEmpty()) {
            Map<String, List<String>> specialDataMap = EInvoicePdfUtils.getSpecialDataMap(fullDigitalEInvoice, contentJson, specialType);
            if (specialDataMap.isEmpty()) {
                return;
            }
            int maxNum = Integer.parseInt(specialDataMap.get("maxNum").get(0));
            if (specialDataMap.get("maxNum") != null) {
                specialDataMap.remove("maxNum");
            }
            ArrayList<PDFTemplatePosition> specialPositionList = null;
            int pageNo = 0;
            int lineNum = 0;
            for (int i = 0; i < maxNum; ++i) {
                int maxLineNum;
                if (specialPositionList == null) {
                    specialPositionList = new ArrayList<PDFTemplatePosition>(8);
                }
                for (Map.Entry<String, List<String>> entry : specialDataMap.entrySet()) {
                    String key = entry.getKey();
                    List<String> valueList = entry.getValue();
                    if (i >= valueList.size()) continue;
                    String value = valueList.get(i);
                    PDFTemplatePosition contentPosition = this.getContentPositionByXmlAndStr(value, key, contentJson, lineNum);
                    specialPositionList.add(contentPosition);
                }
                int n = maxLineNum = pageNo == 0 ? 21 : 47;
                if (++lineNum != maxLineNum && i != maxNum - 1) continue;
                specialDataList.add(specialPositionList);
                if (lineNum < 8) {
                    lineNum = 8;
                }
                specialLineNumList.add(lineNum);
                specialPositionList = null;
                lineNum = 0;
                ++pageNo;
            }
        }
    }

    private void setLastDataList(List<PDFTemplatePosition> lastPositionList, JSONObject contentJson, FullDigitalEInvoice fullDigitalEInvoice) {
        ArrayList<PDFTemplatePosition> lastPositionList1 = new ArrayList<PDFTemplatePosition>(16);
        lastPositionList1.addAll(lastPositionList);
        BigDecimal totalAmount = fullDigitalEInvoice.getTotalAmount();
        lastPositionList1.add(this.getContentPositionByXmlAndStr(EInvoicePdfUtils.getPriceWithSymbol(totalAmount), "totalAmount", contentJson, 0));
        lastPositionList1.add(this.getContentPositionByXmlAndStr(MoneyUtil.moneyCapital(EInvoicePdfUtils.getPriceWithScale(totalAmount)), "totalAmountDX", contentJson, 0));
        lastPositionList1.addAll(this.getRemarkList(contentJson, fullDigitalEInvoice.getRemark()));
        lastPositionList.addAll(lastPositionList1);
    }

    private void setDetailList(List<List<PDFTemplatePosition>> detailPositionLists, List<PDFTemplatePosition> detailPositionList, FullDigitalEInvoice fullDigitalEInvoice, JSONObject contentJson, float totalAmountY, float drawerY, int diffPageY) {
        BigDecimal invoiceAmount = fullDigitalEInvoice.getInvoiceAmount();
        BigDecimal totalTaxAmount = fullDigitalEInvoice.getTotalTaxAmount();
        detailPositionList.add(this.getContentPositionByXmlAndStrWithDiff(fullDigitalEInvoice.getDrawer(), "drawer", contentJson, diffPageY, drawerY));
        detailPositionList.add(this.getContentPositionByXmlAndStrWithDiff(EInvoicePdfUtils.getPriceWithSymbol(invoiceAmount), "invoiceAmount", contentJson, diffPageY, totalAmountY));
        detailPositionList.add(this.getContentPositionByXmlAndStrWithDiff(EInvoicePdfUtils.getPriceWithSymbol(totalTaxAmount), "totalTaxAmount", contentJson, diffPageY, totalAmountY));
        detailPositionLists.add(detailPositionList);
    }

    private void setSubMoneyList(List<List<PDFTemplatePosition>> subMoneyPositionLists, List<PDFTemplatePosition> subMoneyPositionList, JSONObject contentJson, BigDecimal subMoney, BigDecimal subTax, int diffPageY) {
        subMoneyPositionList.add(this.getContentPositionByXmlAndStr(EInvoicePdfUtils.getPriceWithSymbol(subMoney), "subAmWithoutTax", contentJson, diffPageY));
        subMoneyPositionList.add(this.getContentPositionByXmlAndStr(EInvoicePdfUtils.getPriceWithSymbol(subTax), "subTaxAm", contentJson, diffPageY));
        subMoneyPositionLists.add(subMoneyPositionList);
    }

    private List<PDFTemplatePosition> getBasicContentPositionList(JSONObject dataJson, JSONObject contentJson, SpecialTypeEnum specialType) {
        ArrayList<PDFTemplatePosition> list = new ArrayList<PDFTemplatePosition>();
        for (String key : contentJson.keySet()) {
            PDFTemplatePosition currentPosition;
            if ("differenceTaxType".equals(key)) {
                DifferenceTaxTypeEnum differenceTaxType = DifferenceTaxTypeEnum.getDifferenceTaxTypeByValue(dataJson.getString(key));
                if (differenceTaxType == null) continue;
                PDFTemplatePosition currentPosition2 = this.getContentPositionByXmlAndStr(differenceTaxType.getMsg(), key, contentJson, 0);
                list.add(currentPosition2);
                continue;
            }
            if ("specialMark".equals(key) && specialType != null) {
                currentPosition = this.getContentPositionByXmlAndStr(specialType.getMsg(), key, contentJson, 0);
                list.add(currentPosition);
                continue;
            }
            if (!dataJson.containsKey((Object)key) || "itemList".equals(key) || "drawer".equals(key) || "invoiceAmount".equals(key) || "totalTaxAmount".equals(key) || "totalAmount".equals(key) || "remark".equals(key) || "qrCode".equals(key)) continue;
            if ("issueTime".equals(key)) {
                String issueTimeCn = DateUtils.format(dataJson.getDate(key), "yyyy\u5e74MM\u6708dd\u65e5");
                dataJson.put(key, (Object)issueTimeCn);
            }
            if ((currentPosition = this.getContentPositionByXml(dataJson, key, contentJson, 0)) == null) continue;
            list.add(currentPosition);
        }
        return list;
    }

    private void setDifferenceTaxType(JSONObject contentJson, JSONObject dataJson, List<PDFTemplatePosition> list) {
        BigDecimal totalAmount = dataJson.getBigDecimal("totalAmount");
        if (totalAmount.compareTo(BigDecimal.ZERO) < 0) {
            PDFTemplatePosition currentPosition = this.getContentPositionByXmlAndStr(null, "negativeMark", contentJson, 0);
            list.add(currentPosition);
        }
    }

    private PDFTemplatePosition getContentPositionByXml(JSONObject dataJson, String key, JSONObject positionJson, int currentPageSize) {
        return this.getContentPositionByXmlAndStr(dataJson.getString(key), key, positionJson, currentPageSize);
    }

    private PDFTemplatePosition getContentPositionByXmlAndStr(String str, String key, JSONObject positionJson, int currentPageSize) {
        return this.getContentPositionByXmlAndStrWithDiff(str, key, positionJson, currentPageSize, 0.0f);
    }

    private PDFTemplatePosition getContentPositionByXmlAndStrWithDiff(String str, String key, JSONObject positionJson, int currentPageSize, float diffY) {
        PDFTemplatePosition position = (PDFTemplatePosition)JSONObject.parseObject((String)JSON.toJSONString((Object)positionJson.get((Object)key)), PDFTemplatePosition.class);
        if (position == null) {
            return null;
        }
        if (str != null) {
            position.setMsg(str);
        }
        String textLocation = this.getTextLocation(position.getTextLocation(), currentPageSize, diffY);
        position.setTextLocation(textLocation);
        return position;
    }

    private String getTextLocation(String textLocation, int currentPageSize, float diffY) {
        if (currentPageSize > 0 || diffY != 0.0f) {
            StringBuilder textLocationBd = new StringBuilder();
            String[] textLocationArr = textLocation.split(",");
            diffY = Float.parseFloat(textLocationArr[1]) + diffY;
            if (currentPageSize > 0) {
                diffY -= EInvoicePdfUtils.getPxByMm(4.5f * (float)currentPageSize);
            }
            textLocationBd.append(textLocationArr[0]).append(",").append(diffY);
            if (textLocationArr.length > 2) {
                for (int i = 2; i < textLocationArr.length; ++i) {
                    textLocationBd.append(",").append(textLocationArr[i]);
                }
            }
            textLocation = textLocationBd.toString();
        }
        return textLocation;
    }

    private String getTextLocationByXml(JSONObject contentJson, int currentPageSize) {
        String textLocation = contentJson.getString("textLocation");
        StringBuilder sb = new StringBuilder(textLocation);
        if (currentPageSize > 0) {
            String[] textLocationArr = textLocation.split(",");
            float diffY = Float.parseFloat(textLocationArr[1]) - EInvoicePdfUtils.getPxByMm(4.5f * (float)currentPageSize);
            textLocation = textLocationArr[0] + "," + diffY;
            sb = new StringBuilder(textLocation);
            if (textLocationArr.length > 2) {
                for (int i = 2; i < textLocationArr.length; ++i) {
                    sb.append(",").append(textLocationArr[i]);
                }
            }
        }
        return sb.toString();
    }

    private List<PDFTemplatePosition> getPageNoList(PDFTemplatePosition pageNoPosition, int pageNum, int currentPageNo) {
        PDFTemplatePosition currentPosition = (PDFTemplatePosition)JsonUtils.clone(pageNoPosition);
        String msg = currentPosition.getMsg();
        msg = msg.replace("A", String.valueOf(pageNum));
        msg = msg.replace("B", String.valueOf(currentPageNo));
        String textLocation = currentPosition.getTextLocation();
        String[] textLocationArr = textLocation.split(",");
        if (pageNum >= 10) {
            float ymX = Float.parseFloat(textLocationArr[0]) - 4.1f;
            if (currentPageNo >= 10) {
                ymX -= 4.2f;
            }
            textLocation = ymX + "," + textLocationArr[1];
        }
        currentPosition.setMsg(msg);
        currentPosition.setTextLocation(textLocation);
        ArrayList<PDFTemplatePosition> pageNoList = new ArrayList<PDFTemplatePosition>();
        pageNoList.add(currentPosition);
        return pageNoList;
    }

    private List<PDFTemplatePosition> getRemarkList(JSONObject contentJson, String remark) {
        ArrayList<PDFTemplatePosition> remarkList = new ArrayList<PDFTemplatePosition>(8);
        List<String> remarkDetailList = EInvoicePdfUtils.subStringByChineseLength(remark, 61, true);
        float diffY = 0.0f;
        for (String remarkStr : remarkDetailList) {
            PDFTemplatePosition remarkPosition = this.getContentPositionByXmlAndStrWithDiff(remarkStr, "remark", contentJson, 0, diffY);
            remarkList.add(remarkPosition);
            diffY -= EInvoicePdfUtils.getPxByMm(3.0f);
        }
        return remarkList;
    }
}

