/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.service.einvoicepdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kd.imc.rim.file.constant.FullDigitalEInvoiceConstant;
import kd.imc.rim.file.service.einvoicepdf.enums.SpecialTypeEnum;
import kd.imc.rim.file.utils.EInvoicePdfUtils;
import kd.imc.rim.file.utils.pdf.PdfUtils;
import org.apache.commons.lang3.StringUtils;

public class FullDigitalEInvoicePdfWriteDataService {
    private static final Set<Integer> borderSideSet = new HashSet<Integer>(Arrays.asList(1, 8, 4, 2));
    private static final int TABLE_HEAD_COLUMNS = 4;
    private static final float[] TABLE_HEAD_WIDTH_ARR = new float[]{PdfUtils.getPxByMm(6.0f), PdfUtils.getPxByMm(94.5f), PdfUtils.getPxByMm(6.0f), PdfUtils.getPxByMm(94.5f)};
    private static final float HEAD_HEIGHT = 22.0f;
    private static final float[] CONTENT_WIDTH_ARR = new float[]{PdfUtils.getPxByMm(41.0f), PdfUtils.getPxByMm(25.0f), PdfUtils.getPxByMm(10.0f), PdfUtils.getPxByMm(23.0f), PdfUtils.getPxByMm(25.0f), PdfUtils.getPxByMm(25.0f), PdfUtils.getPxByMm(25.0f), PdfUtils.getPxByMm(27.0f)};
    private static final float CONTENT_HEIGHT = 39.5f;
    private static final float[] ESTATE_CONTENT_WIDTH_ARR = new float[]{PdfUtils.getPxByMm(22.0f), PdfUtils.getPxByMm(45.0f), PdfUtils.getPxByMm(16.0f), PdfUtils.getPxByMm(24.0f), PdfUtils.getPxByMm(23.0f), PdfUtils.getPxByMm(22.0f), PdfUtils.getPxByMm(22.0f), PdfUtils.getPxByMm(27.0f)};
    private static final float[] CONSTRUCTION_CONTENT_WIDTH_ARR = new float[]{PdfUtils.getPxByMm(24.0f), PdfUtils.getPxByMm(36.0f), PdfUtils.getPxByMm(39.0f), PdfUtils.getPxByMm(49.0f), PdfUtils.getPxByMm(22.0f), PdfUtils.getPxByMm(31.0f)};
    private static final float[] GOODS_TRANSPORT_CONTENT_WIDTH_ARR = new float[]{PdfUtils.getPxByMm(40.0f), PdfUtils.getPxByMm(40.0f), PdfUtils.getPxByMm(42.0f), PdfUtils.getPxByMm(42.0f), PdfUtils.getPxByMm(37.0f)};
    private static final float[] GOODS_PASSENGER_CONTENT_WIDTH_ARR = new float[]{PdfUtils.getPxByMm(20.5f), PdfUtils.getPxByMm(38.0f), PdfUtils.getPxByMm(25.0f), PdfUtils.getPxByMm(37.0f), PdfUtils.getPxByMm(39.0f), PdfUtils.getPxByMm(17.0f), PdfUtils.getPxByMm(24.5f)};
    private static final int CONTENT_HJ_COLUMNS = 3;
    private static final float[] CONTENT_HJ_WIDTH_ARR = new float[]{PdfUtils.getPxByMm(52.0f), PdfUtils.getPxByMm(88.0f), PdfUtils.getPxByMm(61.0f)};
    private static final float CONTENT_DX_HJ_HEIGHT = 8.0f;
    private static final float CONTENT_BZ_HEIGHT = 20.0f;

    public void drawTable(PdfContentByte pcb, SpecialTypeEnum specialType, float diffYMM, float tableContentHeight, float specialHeight, boolean lastFlag, boolean multiPage) throws IOException, DocumentException {
        Rectangle signRect = new Rectangle(EInvoicePdfUtils.getPxByMm(4.5f), EInvoicePdfUtils.getPxByMm(88.0f + diffYMM), EInvoicePdfUtils.getPxByMm(205.5f), EInvoicePdfUtils.getPxByMm(110.0f + diffYMM));
        BaseFont kaiFont = BaseFont.createFont((String)"fonts/simkai.ttf", (String)"Identity-H", (boolean)false);
        Font kai = new Font(kaiFont, 9.0f, 0);
        kai.setColor(FullDigitalEInvoiceConstant.TEMPLATE_COLOR);
        PdfPTable tableHead = new PdfPTable(4);
        tableHead.setLockedWidth(true);
        tableHead.setTotalWidth(TABLE_HEAD_WIDTH_ARR);
        tableHead.addCell(this.getLeadingCell("\u8d2d\u4e70\u65b9\u4fe1\u606f", kai, 22.0f, 0.3f));
        tableHead.addCell(this.getListCommonCell("", kai, 22.0f, 1, 5));
        tableHead.addCell(this.getLeadingCell("\u9500\u552e\u65b9\u4fe1\u606f", kai, 22.0f, 0.3f));
        tableHead.addCell(this.getListCommonCell("", kai, 22.0f, 1, 5));
        float contentHeight = 39.5f + tableContentHeight;
        PdfPTable tableContent = SpecialTypeEnum.REAL_ESTATE_OPERATING_LEASE == specialType || SpecialTypeEnum.SALE_OF_REAL_ESTATE == specialType ? this.getEstateContentTable(contentHeight, kai) : (SpecialTypeEnum.CONSTRUCTION_SERVICE == specialType ? this.getConstructionContentTable(contentHeight, kai) : this.getCommonContentTable(contentHeight, kai));
        float contentXjHeight = 0.0f;
        float contentHjHeight = 4.5f;
        PdfPTable tableContentHj = new PdfPTable(3);
        tableContentHj.setTotalWidth(CONTENT_HJ_WIDTH_ARR);
        if (multiPage) {
            contentXjHeight = 5.0f;
            tableContentHj.addCell(this.getListCellWithOneBorder("\u5c0f       \u8ba1", kai, contentXjHeight, 1, 1, 4));
            tableContentHj.addCell(this.getListCellWithNoBorder(" ", kai, contentXjHeight, 1, 1));
            tableContentHj.addCell(this.getListCellWithOneBorder(" ", kai, contentXjHeight, 1, 1, 8));
        }
        tableContentHj.addCell(this.getListCellWithTwoBorder("\u5408       \u8ba1", kai, contentHjHeight, 1, 1, 4, 2));
        tableContentHj.addCell(this.getListCellWithOneBorder(" ", kai, contentHjHeight, 1, 1, 2));
        tableContentHj.addCell(this.getListCellWithTwoBorder(" ", kai, contentHjHeight, 1, 1, 8, 2));
        PdfPTable tableContentHjdx = null;
        PdfPTable tableContentRemark = null;
        PdfPTable transportContent = null;
        if (lastFlag) {
            if (SpecialTypeEnum.CARGO_TRANSPORT_SERVICE == specialType || SpecialTypeEnum.PASSENGER_TRANSPORT == specialType) {
                transportContent = this.drawTransportContent(specialType, specialHeight, kai);
                specialHeight += 5.0f;
            }
            tableContentHjdx = new PdfPTable(3);
            tableContentHjdx.setTotalWidth(CONTENT_HJ_WIDTH_ARR);
            tableContentHjdx.addCell(this.getListCellDisableBorderSide("\u4ef7\u7a0e\u5408\u8ba1\uff08\u5927\u5199\uff09", kai, 8.0f, 1, 5, 1));
            tableContentHjdx.addCell(this.getListCellWithOneBorder(" ", kai, 8.0f, 1, 1, 2));
            tableContentHjdx.addCell(this.getListCellWithTwoBorder("\uff08\u5c0f\u5199\uff09", kai, 8.0f, 0, 5, 8, 2));
            tableContentRemark = this.drawTableLast(kai);
            contentHjHeight += contentXjHeight;
        }
        tableHead.writeSelectedRows(0, -1, signRect.getLeft(), signRect.getTop(), pcb);
        tableContent.writeSelectedRows(0, -1, signRect.getLeft(), signRect.getTop() - PdfUtils.getPxByMm(22.0f), pcb);
        tableContentHj.writeSelectedRows(0, -1, signRect.getLeft(), signRect.getTop() - PdfUtils.getPxByMm(22.0f + contentHeight), pcb);
        if (transportContent != null) {
            transportContent.writeSelectedRows(0, -1, signRect.getLeft(), signRect.getTop() - PdfUtils.getPxByMm(22.0f + contentHeight + contentHjHeight), pcb);
        }
        if (tableContentHjdx != null) {
            tableContentHjdx.writeSelectedRows(0, -1, signRect.getLeft(), signRect.getTop() - PdfUtils.getPxByMm(22.0f + contentHeight + contentHjHeight + specialHeight), pcb);
        }
        if (tableContentRemark != null) {
            tableContentRemark.writeSelectedRows(0, -1, signRect.getLeft(), signRect.getTop() - PdfUtils.getPxByMm(22.0f + contentHeight + contentHjHeight + specialHeight + 8.0f), pcb);
        }
    }

    private PdfPTable getCommonContentTable(float contentHeight, Font kai) throws DocumentException {
        PdfPTable tableContent = new PdfPTable(CONTENT_WIDTH_ARR.length);
        tableContent.setTotalWidth(CONTENT_WIDTH_ARR);
        tableContent.addCell(this.getListCellWithOneBorder("\u9879\u76ee\u540d\u79f0", kai, contentHeight, 1, 1, 4));
        tableContent.addCell(this.getListCellWithOneBorder("\u89c4\u683c\u578b\u53f7", kai, contentHeight, 0, 1, -1));
        tableContent.addCell(this.getListCellWithOneBorder("\u5355 \u4f4d", kai, contentHeight, 1, 4, -1));
        tableContent.addCell(this.getListCellWithOneBorder("\u6570 \u91cf", kai, contentHeight, 2, 4, -1));
        tableContent.addCell(this.getListCellWithOneBorder("\u5355 \u4ef7", kai, contentHeight, 2, 4, -1));
        tableContent.addCell(this.getListCellWithOneBorder("\u91d1 \u989d", kai, contentHeight, 2, 4, -1));
        tableContent.addCell(this.getListCellWithOneBorder("\u7a0e\u7387/\u5f81\u6536\u7387", kai, contentHeight, 1, 4, -1));
        tableContent.addCell(this.getListCellWithOneBorder("\u7a0e \u989d", kai, contentHeight, 2, 4, 8));
        return tableContent;
    }

    private PdfPTable getEstateContentTable(float contentHeight, Font kai) throws DocumentException {
        PdfPTable tableContent = new PdfPTable(CONTENT_WIDTH_ARR.length);
        tableContent.setTotalWidth(ESTATE_CONTENT_WIDTH_ARR);
        tableContent.addCell(this.getListCellWithOneBorder("\u9879\u76ee\u540d\u79f0", kai, contentHeight, 2, 1, 4));
        tableContent.addCell(this.getListCellWithOneBorder("\u4ea7\u6743\u8bc1\u4e66/\u4e0d\u52a8\u4ea7\u6743\u8bc1\u53f7", kai, contentHeight, 2, 1, -1));
        tableContent.addCell(this.getListCellWithOneBorder("\u9762\u79ef\u5355\u4f4d", kai, contentHeight, 2, 4, -1));
        tableContent.addCell(this.getListCellWithOneBorder("\u6570  \u91cf", kai, contentHeight, 2, 4, -1));
        tableContent.addCell(this.getListCellWithOneBorder("\u5355  \u4ef7", kai, contentHeight, 2, 4, -1));
        tableContent.addCell(this.getListCellWithOneBorder("\u91d1  \u989d", kai, contentHeight, 2, 4, -1));
        tableContent.addCell(this.getListCellWithOneBorder("\u7a0e\u7387/\u5f81\u6536\u7387", kai, contentHeight, 2, 4, -1));
        tableContent.addCell(this.getListCellWithOneBorder("\u7a0e  \u989d", kai, contentHeight, 2, 4, 8));
        return tableContent;
    }

    private PdfPTable getConstructionContentTable(float contentHeight, Font kai) throws DocumentException {
        PdfPTable tableContent = new PdfPTable(CONSTRUCTION_CONTENT_WIDTH_ARR.length);
        tableContent.setTotalWidth(CONSTRUCTION_CONTENT_WIDTH_ARR);
        tableContent.addCell(this.getListCellWithOneBorder("\u9879\u76ee\u540d\u79f0", kai, contentHeight, 2, 1, 4));
        tableContent.addCell(this.getListCellWithOneBorder("\u5efa\u7b51\u670d\u52a1\u53d1\u751f\u5730", kai, contentHeight, 2, 1, -1));
        tableContent.addCell(this.getListCellWithOneBorder("\u5efa\u7b51\u9879\u76ee\u540d\u79f0", kai, contentHeight, 2, 4, -1));
        tableContent.addCell(this.getListCellWithOneBorder("\u91d1  \u989d", kai, contentHeight, 2, 4, -1));
        tableContent.addCell(this.getListCellWithOneBorder("\u7a0e\u7387/\u5f81\u6536\u7387", kai, contentHeight, 2, 4, -1));
        tableContent.addCell(this.getListCellWithOneBorder("\u7a0e  \u989d", kai, contentHeight, 2, 4, 8));
        return tableContent;
    }

    private PdfPTable drawTransportContent(SpecialTypeEnum specialType, float transportHeight, Font kai) throws DocumentException {
        if (SpecialTypeEnum.CARGO_TRANSPORT_SERVICE == specialType) {
            return this.drawCargoTransportContent(transportHeight, kai);
        }
        return this.drawPassengerTransportContent(transportHeight, kai);
    }

    private PdfPTable drawCargoTransportContent(float transportHeight, Font kai) throws DocumentException {
        PdfPTable tableContent = new PdfPTable(GOODS_TRANSPORT_CONTENT_WIDTH_ARR.length);
        tableContent.setTotalWidth(GOODS_TRANSPORT_CONTENT_WIDTH_ARR);
        tableContent.addCell(this.getListCellWithOneBorder("\u8fd0\u8f93\u5de5\u5177\u79cd\u7c7b", kai, 5.0f, 1, 4, 4));
        tableContent.addCell(this.getListCellWithNoBorder("\u8fd0\u8f93\u5de5\u5177\u724c\u53f7", kai, 5.0f, 1, 4));
        tableContent.addCell(this.getListCellWithNoBorder("\u8d77\u8fd0\u5730", kai, 5.0f, 1, 4));
        tableContent.addCell(this.getListCellWithNoBorder("\u5230\u8fbe\u5730", kai, 5.0f, 1, 4));
        tableContent.addCell(this.getListCellWithOneBorder("\u8fd0\u8f93\u8d27\u7269\u540d\u79f0", kai, 5.0f, 1, 4, 8));
        PdfPCell cell = this.getListCommonCell("", kai, transportHeight, 1, 4);
        cell.setColspan(5);
        tableContent.addCell(cell);
        return tableContent;
    }

    private PdfPTable drawPassengerTransportContent(float transportHeight, Font kai) throws DocumentException {
        PdfPTable tableContent = new PdfPTable(GOODS_PASSENGER_CONTENT_WIDTH_ARR.length);
        tableContent.setTotalWidth(GOODS_PASSENGER_CONTENT_WIDTH_ARR);
        tableContent.addCell(this.getListCellWithOneBorder("\u51fa\u884c\u4eba", kai, 5.0f, 1, 4, 4));
        tableContent.addCell(this.getListCellWithNoBorder("\u6709\u6548\u8eab\u4efd\u8bc1\u4ef6\u53f7", kai, 5.0f, 1, 4));
        tableContent.addCell(this.getListCellWithNoBorder("\u51fa\u884c\u65e5\u671f", kai, 5.0f, 1, 4));
        tableContent.addCell(this.getListCellWithNoBorder("\u51fa\u53d1\u5730", kai, 5.0f, 1, 4));
        tableContent.addCell(this.getListCellWithNoBorder("\u5230\u8fbe\u5730", kai, 5.0f, 1, 4));
        tableContent.addCell(this.getListCellWithNoBorder("\u7b49  \u7ea7", kai, 5.0f, 1, 4));
        tableContent.addCell(this.getListCellWithOneBorder("\u4ea4\u901a\u5de5\u5177\u7c7b\u578b", kai, 5.0f, 1, 4, 8));
        PdfPCell cell = this.getListCommonCell("", kai, transportHeight, 1, 4);
        cell.setColspan(7);
        tableContent.addCell(cell);
        return tableContent;
    }

    private PdfPTable drawTableLast(Font kai) throws DocumentException {
        float[] remarkWidthArr = new float[]{PdfUtils.getPxByMm(6.0f), PdfUtils.getPxByMm(195.0f)};
        PdfPTable tableContentRemark = new PdfPTable(2);
        tableContentRemark.setTotalWidth(remarkWidthArr);
        tableContentRemark.addCell(this.getListCellDisableBorderSide("\u5907\n\n\u6ce8", kai, 20.0f, 1, 5, 1));
        tableContentRemark.addCell(this.getListCellWithTwoBorder(" ", kai, 20.0f, 1, 1, 8, 2));
        return tableContentRemark;
    }

    private PdfPCell getLeadingCell(String content, Font fontProve, float height, float leading) {
        PdfPCell cell = this.getListCommonCell(content, fontProve, height, 1, 5);
        if (leading > 0.0f) {
            cell.setLeading(EInvoicePdfUtils.getPxByMm(leading), 1.0f);
        }
        return cell;
    }

    private PdfPCell getListCellWithOneBorder(String content, Font fontProve, float height, int align, int verticalAlignment, int ableBorderSide) {
        PdfPCell cell = this.getListCommonCell(content, fontProve, height, align, verticalAlignment);
        this.setCellOneBorder(cell, ableBorderSide);
        return cell;
    }

    private PdfPCell getListCellWithTwoBorder(String content, Font fontProve, float height, int align, int verticalAlignment, int ableBorderSideOne, int ableBorderSideTwo) {
        PdfPCell cell = this.getListCommonCell(content, fontProve, height, align, verticalAlignment);
        this.setCellTwoBorder(cell, ableBorderSideOne, ableBorderSideTwo);
        return cell;
    }

    private PdfPCell getListCellDisableBorderSide(String content, Font fontProve, float height, int align, int verticalAlignment, int disableBorderSide) {
        PdfPCell cell = this.getListCommonCell(content, fontProve, height, align, verticalAlignment);
        cell.disableBorderSide(disableBorderSide);
        return cell;
    }

    private PdfPCell getListCellWithNoBorder(String content, Font fontProve, float height, int align, int verticalAlignment) {
        PdfPCell cell = this.getListCommonCell(content, fontProve, height, align, verticalAlignment);
        cell.disableBorderSide(4);
        cell.disableBorderSide(1);
        cell.disableBorderSide(8);
        cell.disableBorderSide(2);
        return cell;
    }

    private void setCellOneBorder(PdfPCell cell, int ableBorderSide) {
        for (int borderSide : borderSideSet) {
            if (ableBorderSide == borderSide) continue;
            cell.disableBorderSide(borderSide);
        }
    }

    private void setCellTwoBorder(PdfPCell cell, int ableBorderSideOne, int ableBorderSideTwo) {
        for (int borderSide : borderSideSet) {
            if (ableBorderSideOne == borderSide || ableBorderSideTwo == borderSide) continue;
            cell.disableBorderSide(borderSide);
        }
    }

    private PdfPCell getListCommonCell(String content, Font fontProve, float height, int align, int verticalAlignment) {
        Paragraph paragraph = new Paragraph(content, fontProve);
        paragraph.setAlignment(align);
        PdfPCell cell = new PdfPCell((Phrase)paragraph);
        cell.setBorderWidth(PdfUtils.getPxByMm(0.25f));
        cell.setUseAscender(true);
        cell.setVerticalAlignment(verticalAlignment);
        cell.setHorizontalAlignment(align);
        cell.setBorderColor(FullDigitalEInvoiceConstant.TEMPLATE_COLOR);
        cell.setFixedHeight(PdfUtils.getPxByMm(height));
        return cell;
    }

    public void writePdfData(String value, PdfContentByte under, BaseFont font, Float fontSize, String locStr, Integer[] colorArr, String[] ctmStrArr, float diffX, float diffY, int fontAlign) {
        if (value == null) {
            value = "";
        }
        under.saveState();
        String[] loc = StringUtils.split((String)locStr, (String)",");
        fontSize = Float.valueOf(this.getTextFontSize(loc, font, fontSize, value));
        under.beginText();
        if (loc == null) {
            return;
        }
        float x = Float.parseFloat(loc[0]);
        float y = Float.parseFloat(loc[1]);
        under.resetRGBColorFill();
        under.setRGBColorFill(colorArr[0].intValue(), colorArr[1].intValue(), colorArr[2].intValue());
        under.setFontAndSize(font, fontSize.floatValue());
        if (ctmStrArr != null && ctmStrArr.length > 0) {
            under.setTextMatrix(Float.parseFloat(ctmStrArr[0]), Float.parseFloat(ctmStrArr[2]), Float.parseFloat(ctmStrArr[1]), Float.parseFloat(ctmStrArr[3]), Float.parseFloat(ctmStrArr[4]) + diffX, Float.parseFloat(ctmStrArr[5]) + diffY);
            under.showText(value);
        } else {
            switch (fontAlign) {
                case 2: {
                    x = Float.parseFloat(loc[2]);
                    break;
                }
                case 1: {
                    x = (x + Float.parseFloat(loc[2])) / 2.0f + diffX;
                    break;
                }
            }
            under.showTextAligned(fontAlign, value, x + diffX, y + diffY, 0.0f);
        }
        under.endText();
        under.restoreState();
    }

    private float getTextFontSize(String[] loc, BaseFont font, Float fontSize, String text) {
        if (loc != null && loc.length == 4) {
            float width = Float.parseFloat(loc[2]) - Float.parseFloat(loc[0]);
            float widthPoint = font.getWidthPoint(text, fontSize.floatValue());
            while (widthPoint > width) {
                fontSize = Float.valueOf(fontSize.floatValue() - 0.1f);
                widthPoint = font.getWidthPoint(text, fontSize.floatValue());
            }
        }
        return fontSize.floatValue();
    }

    public void writePdfDataWithSpace(String value, PdfContentByte under, BaseFont font, Float fontSize, String locStr, Integer[] colorArr, float diffX, float diffY, float space) {
        if (value == null) {
            value = "";
        }
        under.saveState();
        int align = 0;
        String[] loc = StringUtils.split((String)locStr, (String)",");
        under.beginText();
        float x = Float.parseFloat(loc[0]);
        float y = Float.parseFloat(loc[1]);
        under.resetRGBColorFill();
        under.setRGBColorFill(colorArr[0].intValue(), colorArr[1].intValue(), colorArr[2].intValue());
        under.setFontAndSize(font, fontSize.floatValue());
        for (int i = 0; i < value.length(); ++i) {
            String text = value.substring(i, i + 1);
            if (i > 0) {
                x += space;
                if (!EInvoicePdfUtils.isContainChinese(value.substring(i - 1, i))) {
                    x -= space / 2.0f;
                }
            }
            under.showTextAligned(align, text, x + diffX, y + diffY, 0.0f);
        }
        under.endText();
        under.restoreState();
    }
}

