/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.service.einvoicepdf;

import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import kd.imc.rim.file.model.RgbBean;
import kd.imc.rim.file.service.einvoicepdf.dto.PDFTemplatePosition;
import kd.imc.rim.file.utils.pdf.RgbUtils;
import org.apache.commons.lang3.StringUtils;

public class FullDigitalEInvoicePdfWritePathService {
    public void setPathValue(PDFTemplatePosition position, PdfContentByte under, float diffX, float diffY) {
        String strokeColor = position.getStrokeColor();
        String fillColor = position.getFillColor();
        String pathLocation = position.getPathLocation();
        pathLocation = pathLocation.replace("ZM", "Z M");
        String[] pathArr = pathLocation.split(" (?=[SMLQBAC])");
        String transform = position.getTransform();
        under.saveState();
        boolean fillFlag = false;
        if (!StringUtils.isEmpty((CharSequence)fillColor) && !"none".equals(fillColor)) {
            fillFlag = true;
            this.setFillColor(fillColor, under);
        } else {
            if (StringUtils.isEmpty((CharSequence)strokeColor)) {
                strokeColor = fillColor;
            }
            float width = position.getWidth();
            this.setStrokeColor(strokeColor, width, under);
        }
        this.execTransForm(under, transform);
        this.writePath(under, pathArr, diffX, diffY);
        if (fillFlag) {
            under.fill();
        }
        under.closePathStroke();
        under.restoreState();
    }

    private void setFillColor(String fillColor, PdfContentByte under) {
        RgbBean colorArr = RgbUtils.hexToRGB(fillColor);
        Color baseColor = new Color(colorArr.getRed(), colorArr.getGreen(), colorArr.getBlue());
        under.setColorFill(baseColor);
    }

    private void setStrokeColor(String strokeColor, float strokeWidth, PdfContentByte under) {
        RgbBean colorArr = RgbUtils.hexToRGB(strokeColor);
        Color baseColor = new Color(colorArr.getRed(), colorArr.getGreen(), colorArr.getBlue());
        if (strokeWidth == 0.0f) {
            strokeWidth = 0.25f;
        }
        under.setColorStroke(baseColor);
        under.setLineWidth(strokeWidth);
    }

    private void execTransForm(PdfContentByte under, String transform) {
        if (!StringUtils.isEmpty((CharSequence)transform)) {
            AffineTransform affineTransform = new AffineTransform();
            if (transform.contains("translate")) {
                String[] translateArr = transform.replace("translate(", "").replace(")", "").split(",");
                float translateX = Float.parseFloat(translateArr[0]);
                float translateY = Float.parseFloat(translateArr[1]);
                affineTransform.translate(translateX, -translateY);
                under.transform(affineTransform);
            } else if (transform.contains("matrix")) {
                String[] ctmStrArr = transform.replace("matrix(", "").replace(")", "").split(" ");
                affineTransform.setTransform(Float.parseFloat(ctmStrArr[0]), Float.parseFloat(ctmStrArr[2]), Float.parseFloat(ctmStrArr[1]), Float.parseFloat(ctmStrArr[3]), Float.parseFloat(ctmStrArr[4]), Float.parseFloat(ctmStrArr[5]));
                under.transform(affineTransform);
            }
        }
    }

    private void writePath(PdfContentByte under, String[] pathArr, float diffX, float diffY) {
        block10: for (String pathStr : pathArr) {
            String[] pathSplitArr = pathStr.split(" ");
            switch (pathSplitArr[0]) {
                case "M": {
                    this.writeLinePath(under, pathSplitArr, true, diffX, diffY);
                    continue block10;
                }
                case "C": {
                    this.writeCurvePath(under, pathSplitArr, diffX, diffY);
                    continue block10;
                }
                case "L": {
                    this.writeLinePath(under, pathSplitArr, false, diffX, diffY);
                    continue block10;
                }
            }
        }
    }

    private void writeLinePath(PdfContentByte under, String[] pathSplitArr, boolean startFlag, float diffX, float diffY) {
        float pathX = Float.parseFloat(pathSplitArr[1]) + diffX;
        float pathY = Float.parseFloat(pathSplitArr[2]) + diffY;
        if (startFlag) {
            under.moveTo(pathX, pathY);
        } else {
            under.lineTo(pathX, pathY);
        }
    }

    private void writeCurvePath(PdfContentByte under, String[] pointSplitArr, float diffX, float diffY) {
        float pathCx1 = Float.parseFloat(pointSplitArr[1]) + diffX;
        float pathCy1 = Float.parseFloat(pointSplitArr[2]) + diffY;
        float pathCx2 = Float.parseFloat(pointSplitArr[3]) + diffX;
        float pathCy2 = Float.parseFloat(pointSplitArr[4]) + diffY;
        float pathCx3 = Float.parseFloat(pointSplitArr[5]) + diffX;
        float pathCy3 = Float.parseFloat(pointSplitArr[6]) + diffY;
        under.curveTo(pathCx1, pathCy1, pathCx2, pathCy2, pathCx3, pathCy3);
    }
}

