/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.StringUtils;

public class CompressHelper {
    private static final Log logger = LogFactory.getLog(CompressHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, byte[]> decompress(byte[] zipData) {
        if (zipData == null || zipData.length == 0) {
            return null;
        }
        HashMap<String, byte[]> sources = new HashMap<String, byte[]>();
        ByteArrayInputStream bis = null;
        ZipInputStream zip = null;
        try {
            ZipEntry entry;
            bis = new ByteArrayInputStream(zipData);
            zip = new ZipInputStream(bis);
            while ((entry = zip.getNextEntry()) != null) {
                byte[] bb = CompressHelper.getByte(sources, zip, entry);
                sources.put(entry.getName(), bb);
            }
            HashMap<String, byte[]> hashMap = sources;
            return hashMap;
        }
        catch (Exception e) {
            logger.error("decompress-error", (Throwable)e);
            Map<String, byte[]> map = null;
            return map;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (Exception exception) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static byte[] getByte(Map<String, byte[]> sources, ZipInputStream zip, ZipEntry entry) throws IOException {
        byte[] buf = new byte[1024];
        int num = -1;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            while ((num = zip.read(buf, 0, buf.length)) != -1) {
                bos.write(buf, 0, num);
            }
            bos.close();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static String decodeBase64AndGZip(String inputStr) {
        if (StringUtils.isEmpty((Object)inputStr)) {
            return "";
        }
        String out = inputStr;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(Base64.getDecoder().decode(inputStr));
             GZIPInputStream gzip = new GZIPInputStream(bis);
             ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int num;
            byte[] buf = new byte[1024];
            while ((num = gzip.read(buf, 0, buf.length)) != -1) {
                bos.write(buf, 0, num);
            }
            byte[] bytes = bos.toByteArray();
            out = new String(bytes, StandardCharsets.UTF_8);
            bos.flush();
        }
        catch (IOException e) {
            logger.error("decodeBase64AndGZip-error", (Throwable)e);
        }
        return out;
    }
}

