/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.imc.rim.file.service.einvoicepdf.dto.CargoTransportItem;
import kd.imc.rim.file.service.einvoicepdf.dto.FullDigitalEInvoice;
import kd.imc.rim.file.service.einvoicepdf.dto.PassengerTransportItem;
import kd.imc.rim.file.service.einvoicepdf.enums.SpecialTypeEnum;
import kd.imc.rim.file.utils.AreaUtil;
import kd.imc.rim.file.utils.XmlHelperUtils;
import org.apache.commons.lang3.StringUtils;

public class EInvoicePdfUtils {
    private static final String chineseReg = "[\u4e00-\u9fa5|\\\uff01|\\\uff0c|\\\u3002|\\\uff08|\\\uff09|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\uff1f|\\\uff1a|\\\uff1b|\\\u3010|\\\u3011]";

    public static boolean isContainChinese(String str) {
        Pattern p = Pattern.compile(chineseReg);
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static BaseFont getFont(String fontFamilyStr, BaseFont[] fonts) {
        String fontFamilyStrLow = fontFamilyStr.toLowerCase();
        if (fontFamilyStrLow.contains("courier")) {
            return fonts[1];
        }
        if (fontFamilyStrLow.contains("kai")) {
            return fonts[2];
        }
        return fonts[0];
    }

    public static float getFloatPxByStr(String str) {
        float mm = Float.parseFloat(str.replace("mm", "").trim());
        return EInvoicePdfUtils.getPxByMm(mm);
    }

    public static float getPxByMm(float mmValue) {
        return mmValue * 72.0f / 25.4f;
    }

    public static float getNormalPxBySvgPx(float pxValue) {
        return pxValue * 72.0f / 96.0f;
    }

    public static float getNormalPxBySvgStrPx(String pxValueStr) {
        return EInvoicePdfUtils.getNormalPxBySvgPx(Float.parseFloat(pxValueStr));
    }

    public static String getPriceSubstrToTwo(String dt) {
        DecimalFormat df = new DecimalFormat("0.00");
        if (dt != null) {
            String newNum = dt.replace(",", "");
            dt = String.valueOf(df.format(Double.parseDouble(newNum)));
        }
        return dt;
    }

    public static String getAreaNameByNsrsbh(String nsrsbh) {
        String areaName = null;
        if (nsrsbh.trim().length() >= 18 || nsrsbh.trim().startsWith("9")) {
            areaName = AreaUtil.getJJZAreaMap().get(nsrsbh.substring(2, 6));
            if (StringUtils.isEmpty((CharSequence)areaName)) {
                areaName = AreaUtil.getJJZAreaMap().get(nsrsbh.substring(2, 4));
            }
            if (StringUtils.isEmpty((CharSequence)areaName)) {
                areaName = AreaUtil.getJJZAreaMap().get(nsrsbh.substring(1, 3));
            }
        }
        if (StringUtils.isEmpty(areaName)) {
            areaName = AreaUtil.getJJZAreaMap().get(nsrsbh.substring(0, 4));
        }
        if (StringUtils.isEmpty((CharSequence)areaName)) {
            areaName = AreaUtil.getJJZAreaMap().get(nsrsbh.substring(0, 2));
        }
        return areaName;
    }

    public static String getAreaCodeByNsrsbh(String nsrsbh) {
        String areaCodeStr = EInvoicePdfUtils.getAreaNameByNsrsbh(nsrsbh);
        if (areaCodeStr != null) {
            String[] areaArr = areaCodeStr.split("-");
            return areaArr[0];
        }
        return "";
    }

    public static List<String> subStringByChineseLength(String str, int maxLengh, boolean supportHHF) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)str) || maxLengh <= 0) {
            return list;
        }
        StringBuilder builder = new StringBuilder();
        BigDecimal totalZWCnt = new BigDecimal(0);
        for (int i = 0; i < str.length() && totalZWCnt.compareTo(new BigDecimal(maxLengh)) < 0; ++i) {
            if (list.size() == 6) {
                builder = new StringBuilder();
                break;
            }
            String temp = str.substring(i, i + 1);
            if (supportHHF && temp.equals("\n")) {
                if (StringUtils.isEmpty((CharSequence)builder.toString())) continue;
                list.add(builder.toString());
                builder = new StringBuilder();
                totalZWCnt = new BigDecimal(0);
                continue;
            }
            String currentStr = str.substring(i, i + 1);
            BigDecimal zwCnt = EInvoicePdfUtils.isContainChinese(currentStr) ? BigDecimal.ONE : new BigDecimal("0.5");
            if ((totalZWCnt = totalZWCnt.add(zwCnt)).compareTo(new BigDecimal(maxLengh)) > 0) {
                list.add(builder.toString());
                totalZWCnt = zwCnt;
                builder = new StringBuilder();
                builder.append(temp);
                continue;
            }
            if (totalZWCnt.compareTo(new BigDecimal(maxLengh)) == 0) {
                builder.append(temp);
                list.add(builder.toString());
                builder = new StringBuilder();
                totalZWCnt = new BigDecimal(0);
                continue;
            }
            builder.append(temp);
        }
        if (!StringUtils.isEmpty((CharSequence)builder.toString())) {
            list.add(builder.toString());
        }
        return list;
    }

    public static byte[] generateBlankPdf(float width, float height) throws IOException, DocumentException {
        byte[] blankPdfBytes;
        try (ByteArrayOutputStream bao = new ByteArrayOutputStream();){
            Document document = new Document(new Rectangle(EInvoicePdfUtils.getPxByMm(width), EInvoicePdfUtils.getPxByMm(height)));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)bao);
            document.open();
            document.add((Element)new Paragraph(" "));
            document.close();
            writer.close();
            blankPdfBytes = bao.toByteArray();
        }
        return blankPdfBytes;
    }

    public static String replaceBreakLine(String str) {
        str = StringUtils.replace((String)str, (String)"\\r\\n", (String)"\n");
        str = StringUtils.replace((String)str, (String)"\\n", (String)"\n");
        str = StringUtils.replace((String)str, (String)"\r\n", (String)"\n");
        return str;
    }

    public static String getBigDecimalStr(BigDecimal bigDecimal) {
        String str = "";
        if (bigDecimal != null) {
            str = bigDecimal.toPlainString();
        }
        return str;
    }

    public static String getPriceWithSymbol(BigDecimal bigDecimal) {
        return "\u00a5" + EInvoicePdfUtils.getPriceWithScale(bigDecimal);
    }

    public static String getPriceWithScale(BigDecimal bigDecimal) {
        String str = bigDecimal != null ? bigDecimal.setScale(2, RoundingMode.HALF_UP).toPlainString() : "0.00";
        return str;
    }

    private static void setSpecialDataMap(JSONArray specialArray, JSONObject contentJson, Map<String, List<String>> specialDataMap) {
        int maxNum = 0;
        for (int i = 0; i < specialArray.size(); ++i) {
            JSONObject specialData = specialArray.getJSONObject(i);
            for (String key : specialData.keySet()) {
                String value = specialData.getString(key);
                Object maxLengthObj = contentJson.get((Object)key);
                Integer maxLength = maxLengthObj instanceof Integer ? (Integer)maxLengthObj : contentJson.getJSONObject(key).getInteger("maxLength");
                if (maxLength == null) {
                    maxLength = 10;
                }
                List<String> dataList = EInvoicePdfUtils.subStringByChineseLength(value, maxLength, true);
                List<String> list = specialDataMap.get(key);
                if (list == null) {
                    list = dataList;
                } else {
                    list.addAll(dataList);
                }
                if (maxNum < list.size()) {
                    maxNum = list.size();
                }
                specialDataMap.put(key, list);
            }
            for (String key : specialData.keySet()) {
                List<String> list = specialDataMap.get(key);
                int blankNum = maxNum - list.size();
                for (int j = 0; j < blankNum; ++j) {
                    list.add("");
                }
            }
        }
        specialDataMap.put("maxNum", Collections.singletonList(String.valueOf(maxNum)));
    }

    public static Map<String, List<String>> getSpecialDataMap(FullDigitalEInvoice fullDigitalEInvoice, JSONObject contentJson, SpecialTypeEnum specialType) {
        LinkedHashMap<String, List<String>> specialDataMap = new LinkedHashMap<String, List<String>>();
        JSONArray specialArray = null;
        if (SpecialTypeEnum.CARGO_TRANSPORT_SERVICE == specialType) {
            List<CargoTransportItem> cargoTransportList = fullDigitalEInvoice.getCargoTransportList();
            specialArray = new JSONArray(cargoTransportList.size());
            specialArray.addAll(cargoTransportList);
        } else if (SpecialTypeEnum.PASSENGER_TRANSPORT == specialType) {
            List<PassengerTransportItem> passengerTransportList = fullDigitalEInvoice.getTravelerList();
            specialArray = new JSONArray(passengerTransportList.size());
            specialArray.addAll(passengerTransportList);
        }
        if (specialArray != null && !specialArray.isEmpty()) {
            EInvoicePdfUtils.setSpecialDataMap(specialArray, contentJson, specialDataMap);
        }
        return specialDataMap;
    }

    public static JSONObject getElementMaxLengthJson(org.dom4j.Element element) {
        JSONObject jsonObject = new JSONObject();
        for (org.dom4j.Element detailElement : element.elements()) {
            JSONObject maxLengthJson = new JSONObject();
            maxLengthJson.put("maxLength", (Object)XmlHelperUtils.getAttributeValue(detailElement, "maxLength", 100));
            jsonObject.put(detailElement.getName(), (Object)maxLengthJson);
        }
        return jsonObject;
    }
}

