/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.aws.ofd.util.ofd.OfdConvertUtil;
import kd.imc.aws.ofd.util.ofd.OfdUtil;
import kd.imc.rim.file.model.FileConvertResult;
import kd.imc.rim.file.utils.LoadFontUtils;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class FileConvertUtils {
    private static final float RENDER_IMAGE_SCALE = 1.6f;
    private static final Log logger = LogFactory.getLog(FileConvertUtils.class);
    private static final String FMT_ATT_PATH = "/%s/%s/%s%s/rim/%s/convert/";

    public static FileConvertResult convert(byte[] fileContent, String type) {
        FileConvertResult result = new FileConvertResult();
        long start = System.currentTimeMillis();
        try {
            if ("pdf".equalsIgnoreCase(type)) {
                result.setPdfUrl(FileConvertUtils.upload(fileContent, "pdf"));
                logger.info("\u6587\u4ef6\u5904\u7406\u8017\u65f61{},{}", (Object)type, (Object)(System.currentTimeMillis() - start));
                String image = FileConvertUtils.pdf2image(fileContent, "jpg");
                result.setImageUrl(image);
                result.setSnapshotUrl(image);
                result.setSuccess(true);
            } else if ("ofd".equalsIgnoreCase(type)) {
                result.setOfdUrl(FileConvertUtils.upload(fileContent, "ofd"));
                logger.info("\u6587\u4ef6\u5904\u7406\u8017\u65f61{},{}", (Object)type, (Object)(System.currentTimeMillis() - start));
                result.setPdfUrl(FileConvertUtils.ofd2pdf(fileContent));
                logger.info("\u6587\u4ef6\u5904\u7406\u8017\u65f62{},{}", (Object)type, (Object)(System.currentTimeMillis() - start));
                String image = FileConvertUtils.ofd2image(fileContent, 0);
                logger.info("\u6587\u4ef6\u5904\u7406\u8017\u65f63{},{}", (Object)type, (Object)(System.currentTimeMillis() - start));
                result.setImageUrl(image);
                result.setSnapshotUrl(image);
                result.setSuccess(true);
            } else {
                result.setImageUrl(FileConvertUtils.upload(fileContent, "jpg"));
                result.setSnapshotUrl(result.getImageUrl());
                result.setSuccess(true);
            }
        }
        catch (Throwable e) {
            logger.info("\u6587\u4ef6\u8f6c\u6362\u62a5\u9519\uff1a" + type, (Object)e);
            result.setSuccess(false);
        }
        logger.info("\u6587\u4ef6\u5904\u7406\u8017\u65f6{},{}", (Object)type, (Object)(System.currentTimeMillis() - start));
        return result;
    }

    public static String pdf2image(byte[] byteArray, String type) {
        return FileConvertUtils.pdf2image(byteArray, type, 1.6f);
    }

    /*
     * Exception decompiling
     */
    public static String pdf2image(byte[] byteArray, String type, float imageScale) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String pdf2image(String base64, String type, float imageScale) {
        byte[] byteArray = Base64.getDecoder().decode(base64);
        return FileConvertUtils.pdf2image(byteArray, type, imageScale);
    }

    /*
     * Exception decompiling
     */
    public static byte[] pdf2imageByte(byte[] byteArray, String type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String ofd2pdf(byte[] byteArray) {
        byte[] pdfByte = OfdUtil.convertToPdfNew(byteArray);
        return FileConvertUtils.upload(pdfByte, "pdf");
    }

    public static String ofd2image(byte[] byteArray, int pageNo) {
        byte[] pngByte = OfdConvertUtil.convertToImage(byteArray, 1.0f, 2, pageNo);
        return FileConvertUtils.upload(pngByte, "jpg");
    }

    public static String ofd2pdf(byte[] byteArray, String fileName, String storePath) {
        byte[] pdfByte = OfdUtil.convertToPdfNew(byteArray);
        return FileConvertUtils.upload(pdfByte, fileName, storePath);
    }

    public static Map<String, String> ofd2imageAndPdf(byte[] byteArray, int pageNo, String fileName, String storePath) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        try {
            long start = System.currentTimeMillis();
            byte[] pdfByte = OfdUtil.convertToPdfNew(byteArray);
            logger.info("ofd\u8f6cpdf\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
            byte[] imageArray = FileConvertUtils.pdf2imageByte(pdfByte, "jpg");
            logger.info("ofd\u8f6c\u56fe\u7247\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
            String pdfUrl = FileConvertUtils.upload(pdfByte, null, storePath + ".pdf");
            String imageUrl = FileConvertUtils.upload(imageArray, null, storePath + ".jpg");
            map.put("pdfUrl", pdfUrl);
            map.put("imageUrl", imageUrl);
        }
        catch (Exception e) {
            logger.error("ofd\u8f6c\u56fe\u7247\u5931\u8d25", (Throwable)e);
        }
        return map;
    }

    public static String ofd2image(byte[] byteArray, int pageNo, String fileName, String storePath) {
        byte[] pngByte = OfdConvertUtil.convertToImage(byteArray, 1.0f, 2, pageNo);
        return FileConvertUtils.upload(pngByte, fileName, storePath);
    }

    public static String ofd2image(byte[] byteArray) {
        byte[] pngByte = OfdUtil.convertToImage(byteArray, 2);
        return FileConvertUtils.upload(pngByte, "jpg");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String upload(byte[] byteArray, String fileType) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(byteArray);){
            String fileHash = FileConvertUtils.getSHA256(byteArray);
            String fileName = fileHash + '.' + fileType;
            String storePath = FileConvertUtils.getInvoiceDir() + fileName;
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            if (!fileService.exists(storePath)) {
                FileItem fileItem = new FileItem(fileName, storePath, (InputStream)stream);
                if (fileService.exists(storePath)) {
                    fileService.delete(storePath);
                }
                String path = fileService.upload(fileItem);
                FileConvertUtils.saveBasAttachment(path, fileName, null, null, byteArray.length);
                String string2 = path;
                return string2;
            }
            String string = storePath;
            return string;
        }
        catch (Exception e) {
            logger.error("upload-error", (Throwable)e);
            return null;
        }
    }

    private static void saveBasAttachment(String path, String fileName, String billtype, String interid, int fileSize) {
        try (TXHandle h = TX.requiresNew();){
            try {
                QFilter billIdsFilter = new QFilter("ffileid", "=", (Object)path);
                DynamicObject idObject = QueryServiceHelper.queryOne((String)"bos_attachment", (String)"id", (QFilter[])billIdsFilter.toArray());
                DynamicObject dynamicObject = null;
                Date today = new Date();
                if (idObject != null) {
                    dynamicObject = BusinessDataServiceHelper.loadSingle((Object)idObject.get("id"), (String)"bos_attachment");
                } else {
                    dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
                    dynamicObject.set("fcreatetime", (Object)today);
                    dynamicObject.set("finterid", (Object)String.valueOf(System.currentTimeMillis()));
                }
                if (StringUtils.isEmpty((CharSequence)billtype)) {
                    billtype = "rim_fpzs_main";
                }
                if (!StringUtils.isEmpty((CharSequence)interid)) {
                    dynamicObject.set("finterid", (Object)interid);
                }
                dynamicObject.set("fbilltype", (Object)"rim_fpzs_main");
                dynamicObject.set("fmodifytime", (Object)today);
                dynamicObject.set("faliasfilename", (Object)fileName);
                dynamicObject.set("fattachmentname", (Object)fileName);
                dynamicObject.set("fextname", (Object)(fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : ""));
                int size = fileSize / 1024;
                if (size > 0) {
                    dynamicObject.set("fattachmentsize", (Object)size);
                } else {
                    dynamicObject.set("fattachmentsize", (Object)1);
                }
                dynamicObject.set("fcreatemen", (Object)RequestContext.get().getUserId());
                dynamicObject.set("fattachmentpanel", (Object)"attachmentpanel");
                dynamicObject.set("ffileid", (Object)path);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
            catch (Throwable e) {
                logger.info("\u4fdd\u5b58bos_attachment1\u5931\u8d25:{},{},{}", new Object[]{path, fileName, e.getMessage()});
                h.markRollback();
            }
        }
        catch (Throwable e) {
            logger.info("\u4fdd\u5b58bos_attachment2\u5931\u8d25:{},{}", (Object)path, (Object)fileName);
        }
    }

    public static String pdf2imageAndUpload(byte[] byteArray, String fileName, String storePath) {
        byte[] imageArray = FileConvertUtils.pdf2imageByte(byteArray, "jpg");
        if (imageArray != null) {
            return FileConvertUtils.upload(imageArray, fileName, storePath);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String upload(byte[] byteArray, String fileName, String storePath) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(byteArray);){
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            if (StringUtils.isEmpty((CharSequence)fileName)) {
                fileName = FilenameUtils.getName((String)storePath);
            }
            if (!fileService.exists(storePath)) {
                FileItem fileItem = new FileItem(fileName, storePath, (InputStream)stream);
                if (fileService.exists(storePath)) {
                    fileService.delete(storePath);
                }
                String uploadResult = fileService.upload(fileItem);
                FileConvertUtils.saveBasAttachment(uploadResult, fileName, null, null, byteArray.length);
                String string2 = uploadResult;
                return string2;
            }
            String string = storePath;
            return string;
        }
        catch (Exception e) {
            logger.error("upload-error", (Throwable)e);
            return null;
        }
    }

    public static String getInvoiceDir() {
        RequestContext context = RequestContext.get();
        Calendar calendar = Calendar.getInstance();
        String year = String.valueOf(calendar.get(1));
        int tempMonth = calendar.get(2) + 1;
        String month = tempMonth >= 10 ? String.valueOf(tempMonth) : "0" + tempMonth;
        int date = calendar.get(5);
        return String.format(FMT_ATT_PATH, context.getTenantId(), context.getAccountId(), year, month, date);
    }

    public static String getSHA256(byte[] byteArray) {
        try {
            MessageDigest MD5 = MessageDigest.getInstance("SHA-256");
            MD5.update(byteArray, 0, byteArray.length);
            return new String(Hex.encodeHex((byte[])MD5.digest()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return FileConvertUtils.randomUUID();
        }
    }

    private static synchronized String randomUUID() {
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "") + "0";
        return uuid;
    }

    static {
        LoadFontUtils.init();
    }
}

