/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.constant.ErrorCodeConstant;
import kd.imc.rim.file.utils.Base64Util;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM3Util {
    private static final Log LOGGER = LogFactory.getLog(SM3Util.class);
    private static final String ALGORITHM_NAME = "SM3";

    public static String doDigestToBase64Str(byte[] bytes) {
        return Base64Util.base64encoder(SM3Util.doDigest(bytes));
    }

    public static byte[] doDigest(byte[] bytes) {
        MessageDigest messageDigest = SM3Util.createMessageDigest();
        try {
            if (null != bytes) {
                messageDigest.update(bytes);
            }
            return messageDigest.digest();
        }
        catch (Exception e) {
            LOGGER.error(ErrorCodeConstant.HASH_ERROR.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ErrorCodeConstant.HASH_ERROR, new Object[0]);
        }
    }

    private static MessageDigest createMessageDigest() {
        MessageDigest messageDigest;
        BouncyCastleProvider provider = new BouncyCastleProvider();
        try {
            messageDigest = MessageDigest.getInstance(ALGORITHM_NAME, (Provider)provider);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(ErrorCodeConstant.HASH_IDENTIFIES_ERROR.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ErrorCodeConstant.HASH_IDENTIFIES_ERROR, new Object[0]);
        }
        return messageDigest;
    }
}

