/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils;

import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfPKCS7;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.model.X500Name;
import kd.imc.rim.file.utils.ofd.OfdSignUtil;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SignatureUtils {
    private static Log logger = LogFactory.getLog(SignatureUtils.class);

    public static Boolean isOriginal(byte[] byteArray, String fileType, int originType) {
        if (byteArray == null || byteArray.length < 1) {
            return Boolean.FALSE;
        }
        if ("pdf".equalsIgnoreCase(fileType)) {
            return SignatureUtils.getPdfOriginalType(byteArray) >= originType;
        }
        if ("ofd".equalsIgnoreCase(fileType)) {
            try {
                long start = System.currentTimeMillis();
                OfdSignUtil.verifySignAndGetCerInfo(byteArray, false, false);
                logger.info("ofd\u9a8c\u7b7e\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
                return Boolean.TRUE;
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        return Boolean.FALSE;
    }

    public static Boolean isOriginal(byte[] byteArray, String fileType) {
        return SignatureUtils.isOriginal(byteArray, fileType, 1);
    }

    public static int getPdfOriginalType(byte[] byteArray) {
        if (byteArray == null || byteArray.length < 1) {
            return -1;
        }
        long start = System.currentTimeMillis();
        try {
            PdfReader reader = new PdfReader(byteArray);
            int pageNumber = reader.getNumberOfPages();
            AcroFields fields = reader.getAcroFields();
            ArrayList names = fields.getSignatureNames();
            ArrayList<String> signList = new ArrayList<String>(names.size());
            for (String signName : names) {
                boolean cover = fields.signatureCoversWholeDocument(signName);
                if (!cover && pageNumber != 1) continue;
                try {
                    PdfDictionary v = fields.getSignatureDictionary(signName);
                    PdfPKCS7 pdfPKCS7 = fields.verifySignature(signName, "BC");
                    X509Certificate certificate = pdfPKCS7.getSigningCertificate();
                    ASN1Sequence seq = (ASN1Sequence)SignatureUtils.getSubject(certificate.getTBSCertificate());
                    X500Name x500Name = new X500Name(seq);
                    signList.add(x500Name.toString());
                }
                catch (CertificateEncodingException e) {
                    return -1;
                }
                catch (Exception ex) {
                    String rootCauseMessage = SignatureUtils.getMessage(ex);
                    if ("FPZYZ".equals(signName) && null != SignatureUtils.getContainsStr(rootCauseMessage, "com.lowagie.text.ExceptionConverternull")) {
                        logger.info("Pdf\u9a8c\u7b7e\u8017\u65f610:FPZYZ {}", (Object)(System.currentTimeMillis() - start));
                        return 1;
                    }
                    if (null != SignatureUtils.getContainsStr(rootCauseMessage, "PKCS#7", "Unknown named curve", "NoSuchAlgorithmException", "ExceptionConverter", "org.bouncycastle.asn1.DLSequence cannot be cast to org.bouncycastle.asn1.ASN1ObjectIdentifier") && (cover || pageNumber == 1)) {
                        logger.info("Pdf\u9a8c\u7b7e\u8017\u65f610:{}", (Object)(System.currentTimeMillis() - start));
                        return 1;
                    }
                    logger.info("Pdf\u9a8c\u7b7e\u8017\u65f611:{},{}", (Object)(System.currentTimeMillis() - start), (Object)ex.getMessage());
                    return -1;
                }
                logger.info("Pdf\u9a8c\u7b7e\u8017\u65f620:{},{},{}", new Object[]{System.currentTimeMillis() - start, cover, signList.size()});
                if (!cover && pageNumber != 1 || signList.isEmpty()) continue;
                return 2;
            }
        }
        catch (IOException e) {
            logger.error("Pdf\u9a8c\u7b7e-error", (Throwable)e);
        }
        logger.info("Pdf\u9a8c\u7b7e\u8017\u65f630:{}", (Object)(System.currentTimeMillis() - start));
        return -1;
    }

    public static Boolean isPdfOriginal(byte[] byteArray) {
        if (byteArray == null || byteArray.length < 1) {
            return Boolean.FALSE;
        }
        long start = System.currentTimeMillis();
        try {
            PdfReader reader = new PdfReader(byteArray);
            int pageNumber = reader.getNumberOfPages();
            AcroFields fields = reader.getAcroFields();
            ArrayList names = fields.getSignatureNames();
            ArrayList<String> signList = new ArrayList<String>(names.size());
            for (String signName : names) {
                block7: {
                    boolean cover = fields.signatureCoversWholeDocument(signName);
                    if (!cover && pageNumber != 1) continue;
                    try {
                        PdfDictionary v = fields.getSignatureDictionary(signName);
                        PdfName sub = v.getAsName(PdfName.SUBFILTER);
                        PdfString contents = v.getAsString(PdfName.CONTENTS);
                        PdfPKCS7 pdfPKCS7 = fields.verifySignature(signName, "BC");
                        X509Certificate certificate = pdfPKCS7.getSigningCertificate();
                        ASN1Sequence seq = (ASN1Sequence)SignatureUtils.getSubject(certificate.getTBSCertificate());
                        X500Name x500Name = new X500Name(seq);
                        signList.add(x500Name.toString());
                    }
                    catch (CertificateEncodingException e) {
                        return Boolean.FALSE;
                    }
                    catch (Exception ex) {
                        String rootCauseMessage = SignatureUtils.getMessage(ex);
                        if (null == SignatureUtils.getContainsStr(rootCauseMessage, "PKCS#7", "Unknown named curve", "NoSuchAlgorithmException", "ExceptionConverter", "org.bouncycastle.asn1.DLSequence cannot be cast to org.bouncycastle.asn1.ASN1ObjectIdentifier")) break block7;
                        return Boolean.TRUE;
                    }
                }
                logger.info("Pdf\u9a8c\u7b7e\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
                return !signList.isEmpty();
            }
        }
        catch (IOException e) {
            logger.error("Pdf\u9a8c\u7b7e-error", (Throwable)e);
        }
        logger.info("Pdf\u9a8c\u7b7e\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
        return Boolean.FALSE;
    }

    public static String getMessage(Throwable e) {
        if (e == null) {
            return null;
        }
        return e.getClass().getName() + e.getMessage();
    }

    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        if (str == null || str.length() == 0 || testStrs == null || testStrs.length < 1) {
            return null;
        }
        for (CharSequence checkStr : testStrs) {
            if (!str.toString().contains(checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ASN1Primitive getSubject(byte[] enc) throws IOException {
        try (ASN1InputStream in = new ASN1InputStream((InputStream)new ByteArrayInputStream(enc));){
            ASN1Sequence seq = (ASN1Sequence)in.readObject();
            ASN1Primitive aSN1Primitive = (ASN1Primitive)seq.getObjectAt(seq.getObjectAt(0) instanceof ASN1TaggedObject ? 5 : 4);
            return aSN1Primitive;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

