/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils.common;

import com.alibaba.fastjson.JSONObject;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.lowagie.text.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import kd.imc.rim.file.service.einvoicepdf.enums.InvoiceTypeEnum;
import kd.imc.rim.file.utils.common.CRCUtil;
import kd.imc.rim.file.utils.common.DateUtils;

public class QRCodeUtil {
    private static final String character_set = "UTF-8";
    private static final ErrorCorrectionLevel error_correction = ErrorCorrectionLevel.M;
    private static final int margin = 0;
    private static final String qr_version = "5";
    private static final String image_type = "png";

    public static byte[] encoderQRCodeByte(String content) throws WriterException, IOException {
        int width = 148;
        int height = 148;
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, character_set);
        hints.put(EncodeHintType.ERROR_CORRECTION, error_correction);
        hints.put(EncodeHintType.MARGIN, 0);
        hints.put(EncodeHintType.QR_VERSION, qr_version);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints);
        BufferedImage image = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, image_type, out);
        return out.toByteArray();
    }

    public static String createString(JSONObject dataJson) throws UnsupportedEncodingException {
        StringBuilder content = new StringBuilder();
        String versionNo = "01";
        String invoiceTypeStr = InvoiceTypeEnum.ORDINARY_INVOICE.getTaxValue();
        InvoiceTypeEnum invoiceType = InvoiceTypeEnum.getInvoiceTypeByValue(dataJson.getString("invoiceType"));
        if (invoiceType != null) {
            invoiceTypeStr = invoiceType.getTaxValue();
        }
        String invoiceCode = dataJson.getString("invoiceCode");
        String invoiceNo = dataJson.getString("invoiceNo");
        String totalMoney = dataJson.getString("totalAmount");
        String invoiceDate = DateUtils.format(dataJson.getDate("issueTime"), "yyyyMMdd");
        String invoiceCheckCode = dataJson.getString("JYM");
        if (invoiceDate != null && !"".equals(invoiceDate)) {
            invoiceDate = invoiceDate.substring(0, 8);
        }
        content.append(versionNo).append(",");
        content.append(invoiceTypeStr).append(",");
        content.append(invoiceCode).append(",");
        content.append(invoiceNo).append(",");
        content.append(totalMoney).append(",");
        content.append(invoiceDate).append(",");
        content.append(invoiceCheckCode);
        content.append(",");
        String crcCode = CRCUtil.getCrc(content.toString());
        content.append(crcCode);
        return content.toString();
    }

    public static Image encoderQRCodeByte(JSONObject dataJson) {
        try {
            String ewmStr = QRCodeUtil.createString(dataJson);
            byte[] ewmBytes = QRCodeUtil.encoderQRCodeByte(ewmStr);
            return Image.getInstance((byte[])ewmBytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

