/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils.common;

import java.nio.charset.StandardCharsets;
import kd.imc.rim.file.utils.DateUtil;

public class TranslateUtil {
    public static String transformat(byte[] bytes, String type) throws Exception {
        if (type.equalsIgnoreCase("BCD")) {
            return TranslateUtil.bcd2Str(bytes);
        }
        if (type.equalsIgnoreCase("ASC")) {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        if (type.equalsIgnoreCase("HEX")) {
            return TranslateUtil.Hex2Str(bytes);
        }
        if (type.equalsIgnoreCase("CN")) {
            return TranslateUtil.SinoChar2Str(bytes);
        }
        if (type.equalsIgnoreCase("DECIMAL")) {
            return TranslateUtil.Decimal2Str(bytes);
        }
        if (type.equalsIgnoreCase("HEXSTR")) {
            return TranslateUtil.HexStr2Str(bytes);
        }
        if (type.equalsIgnoreCase("DATESTRING")) {
            return TranslateUtil.DateFormat2Str(bytes);
        }
        if (type.equalsIgnoreCase("TAXCTRCODE")) {
            return TranslateUtil.TaxCtrCode2Str(bytes);
        }
        return null;
    }

    public static String TaxCtrCode2Str(byte[] bytes) throws Exception {
        byte[] temp = new byte[4];
        System.arraycopy(bytes, 0, temp, 0, temp.length);
        String skm1 = TranslateUtil.transformat(temp, "HEX");
        System.arraycopy(bytes, 4, temp, 0, temp.length);
        String skm2 = TranslateUtil.transformat(temp, "HEX");
        for (int n = skm1.length(); n < 10; ++n) {
            skm1 = "0" + skm1;
        }
        for (int m = skm2.length(); m < 10; ++m) {
            skm2 = "0" + skm2;
        }
        return skm1 + skm2;
    }

    public static String DateFormat2Str(byte[] hex) throws Exception {
        return DateUtil.hexToDateString(hex);
    }

    public static String HexStr2Str(byte[] bytes) throws Exception {
        String temp = "";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            while (temp.length() < 2) {
                temp = "0" + temp;
            }
            sb.append(temp);
        }
        return sb.toString();
    }

    public static String SinoChar2Str(byte[] bytes) throws Exception {
        return new String(bytes, "gb18030").trim();
    }

    public static String bcd2Str(byte[] bytes) throws Exception {
        char[] temp = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            char val = (char)((bytes[i] & 0xF0) >> 4 & 0xF);
            temp[i * 2] = (char)(val > '\t' ? val + 65 - 10 : val + 48);
            val = (char)(bytes[i] & 0xF);
            temp[i * 2 + 1] = (char)(val > '\t' ? val + 65 - 10 : val + 48);
        }
        return new String(temp);
    }

    public static String Hex2Str(byte[] hex) throws Exception {
        long ll = 0L;
        for (int i = 0; i < hex.length; ++i) {
            ll = hex[i] < 0 ? ll * 256L + (long)(256 + hex[i]) : ll * 256L + (long)hex[i];
        }
        return String.valueOf(ll);
    }

    public static String Decimal2Str(byte[] hex) throws Exception {
        long ll = 0L;
        for (int i = 1; i < hex.length; ++i) {
            ll = hex[i] < 0 ? ll * 256L + (long)(256 + hex[i]) : ll * 256L + (long)hex[i];
        }
        int location = hex[0] & 0xFF;
        double value = (double)ll / Math.pow(10.0, location);
        return String.valueOf(value);
    }
}

