/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils.common;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.imc.rim.file.utils.common.IXMLShell;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XMLShellImp
implements IXMLShell {
    private static final Log log = LogFactory.getLog(XMLShellImp.class);
    private String rootNodeName = "ROOT";

    public XMLShellImp() {
    }

    public XMLShellImp(String rootEleName) {
        this.rootNodeName = rootEleName;
    }

    @Override
    public Document genXMLRootEle(Document document) {
        if (document == null) {
            document = DocumentHelper.createDocument();
        }
        document.addElement(this.rootNodeName);
        return document;
    }

    @Override
    public void recurInsertEle(Element parentE, Object object) throws Exception {
        String fieldName = null;
        Class<?> cls = null;
        Method methodTitle = null;
        Element secondE = null;
        Element thirdE = null;
        Object tmpObj = null;
        if (parentE == null || object == null) {
            log.warn("null object");
            return;
        }
        cls = object.getClass();
        log.debug("class name:" + cls.getName());
        if (object instanceof List) {
            List tList = (List)object;
            if (tList.size() == 0) {
                log.warn("----empty object----");
                return;
            }
            Object e = tList.get(0);
            tmpObj = e;
            if (e != null) {
                secondE = parentE.addElement(this.getClsShortName(tmpObj.getClass()) + "S");
                secondE.addAttribute("class", this.getClsShortName(Array.newInstance(tmpObj.getClass(), 0).getClass()));
                secondE.addAttribute("size", "" + tList.size());
                Iterator it = tList.iterator();
                while (it.hasNext()) {
                    thirdE = secondE.addElement(this.getClsShortName(tmpObj.getClass()));
                    this.recurInsertEle(thirdE, it.next());
                }
            } else {
                log.warn("----empty list----");
            }
        } else if (cls.isArray()) {
            fieldName = this.getClsShortName(cls.getComponentType());
            secondE = parentE.addElement(fieldName + "S");
            secondE.addAttribute("class", this.getClsShortName(cls));
            int len = 0;
            if (object != null && (len = Array.getLength(object)) > 0) {
                secondE.addAttribute("size", "" + len);
                for (int j = 0; j < len; ++j) {
                    thirdE = secondE.addElement(fieldName);
                    if (XMLShellImp.isPrimitiveCls(cls.getComponentType())) {
                        thirdE.setText(Array.get(object, j).toString());
                        continue;
                    }
                    this.recurInsertEle(thirdE, Array.get(object, j));
                }
            } else {
                secondE.addAttribute("size", "0");
            }
        } else {
            if (parentE.getParent() == null) {
                parentE = parentE.addElement(this.getClsShortName(cls));
                parentE.addAttribute("class", this.getClsShortName(cls));
            }
            Field[] field = cls.getDeclaredFields();
            for (int i = 0; i < field.length; ++i) {
                fieldName = field[i].getName();
                log.debug("field name:" + fieldName);
                if (fieldName.startsWith("class$") || fieldName.equals("ZY") || fieldName.equals("JYFW")) continue;
                methodTitle = cls.getMethod(this.getOnetoUpperCase(fieldName), new Class[0]);
                log.debug("method name:" + methodTitle);
                Object childObj = methodTitle.invoke(object, null);
                if (!XMLShellImp.isPrimitiveCls(field[i].getType())) {
                    if (field[i].getType().isArray()) {
                        secondE = parentE.addElement(fieldName);
                        secondE.addAttribute("class", this.getClsShortName(field[i].getType()));
                        int len = 0;
                        if (childObj != null && (len = Array.getLength(childObj)) > 0) {
                            tmpObj = Array.get(childObj, 0);
                            secondE.addAttribute("size", "" + len);
                            for (int j = 0; j < len; ++j) {
                                thirdE = secondE.addElement(this.getClsShortName(field[i].getType().getComponentType()));
                                if (XMLShellImp.isPrimitiveCls(tmpObj.getClass())) {
                                    thirdE.setText(Array.get(childObj, j).toString());
                                    continue;
                                }
                                this.recurInsertEle(thirdE, Array.get(childObj, j));
                            }
                            continue;
                        }
                        secondE.addAttribute("size", "0");
                        continue;
                    }
                    if (childObj == null) continue;
                    secondE = parentE.addElement(fieldName);
                    secondE.addAttribute("class", this.getClsShortName(field[i].getType()));
                    this.recurInsertEle(secondE, childObj);
                    continue;
                }
                secondE = parentE.addElement(fieldName);
                Object o = methodTitle.invoke(object, null);
                if (o == null) continue;
                secondE.setText(o.toString());
            }
        }
    }

    private String getClsShortName(Class cls) {
        String clsShortName = null;
        if (cls == null) {
            return null;
        }
        int lastDotIndex = cls.getName().lastIndexOf(46);
        if (lastDotIndex < 0) {
            log.error("error");
            return null;
        }
        clsShortName = cls.getName().substring(lastDotIndex + 1);
        return clsShortName;
    }

    private String getOnetoUpperCase(String str) {
        return "get" + this.firsttoUpperCase(str);
    }

    public String firsttoUpperCase(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    private String getElementClassAtt(Element e) {
        Iterator attIt = e.attributeIterator();
        while (attIt.hasNext()) {
            Attribute attri = (Attribute)attIt.next();
            if (!"class".equals(attri.getName().trim())) continue;
            if (attri.getValue().endsWith(";")) {
                return "[Lcom.kingdee.protocol.bean." + attri.getValue();
            }
            return "com.kingdee.protocol.bean." + attri.getValue();
        }
        return null;
    }

    private String getElementSizeAtt(Element e) {
        Iterator attIt = e.attributeIterator();
        while (attIt.hasNext()) {
            Attribute attri = (Attribute)attIt.next();
            if (!"size".equals(attri.getName().trim())) continue;
            return attri.getValue();
        }
        return null;
    }

    private Object readEle(Element parentE, Class objCls) throws Exception {
        if (objCls.isArray() || objCls.isAssignableFrom(List.class) || objCls.isAssignableFrom(ArrayList.class)) {
            log.error("parameters error");
            return null;
        }
        Object obj = objCls.newInstance();
        Field[] field = objCls.getDeclaredFields();
        String fieldName = null;
        Iterator it = parentE.elementIterator();
        block0: while (it.hasNext()) {
            Element ele = (Element)it.next();
            for (int i = 0; i < field.length; ++i) {
                fieldName = field[i].getName();
                if (fieldName.startsWith("class$") || !fieldName.equals(ele.getName())) continue;
                ReflectionUtils.makeAccessible((Field)field[i]);
                this.recurSetObject(field[i], obj, ele);
                continue block0;
            }
        }
        return obj;
    }

    @Override
    public List recurReadEle(Element parentE) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        Class<?> parentCls = null;
        int arraySize = 0;
        String tmpStr = null;
        String parentClsName = this.getElementClassAtt(parentE);
        if (parentClsName == null || parentClsName.equals("")) {
            log.warn("--error paramter---");
            return null;
        }
        parentCls = Class.forName(parentClsName);
        tmpStr = this.getElementSizeAtt(parentE);
        if (tmpStr != null && !tmpStr.equals("")) {
            arraySize = Integer.parseInt(tmpStr);
        }
        if (parentCls.isArray()) {
            if (arraySize != 0) {
                int index = 0;
                Object object = Array.newInstance(parentCls.getComponentType(), arraySize);
                if (XMLShellImp.isPrimitiveCls(parentCls.getComponentType())) {
                    Iterator firtIt = parentE.elementIterator();
                    while (firtIt.hasNext()) {
                        Element secondE = (Element)firtIt.next();
                        Array.set(object, index, secondE.getTextTrim());
                        ++index;
                    }
                } else {
                    index = 0;
                    Iterator firtIt = parentE.elementIterator();
                    while (firtIt.hasNext()) {
                        Element secondE = (Element)firtIt.next();
                        Object secondObj = this.readEle(secondE, parentCls.getComponentType());
                        Array.set(object, index, secondObj);
                        ++index;
                    }
                }
                list.add(object);
            }
        } else {
            Object object = this.readEle(parentE, parentCls);
            list.add(object);
        }
        return list.size() == 0 ? null : list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveXML(Document document, File file, String encoding) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(encoding);
        try (XMLWriter writer = null;
             FileWriter fw = new FileWriter(file);){
            writer = new XMLWriter((Writer)fw, format);
            writer.write(document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveXML(Document document, OutputStream out, String encoding) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(encoding);
        try (XMLWriter writer = null;){
            writer = new XMLWriter(out, format);
            writer.write(document);
        }
    }

    @Override
    public List parseXML(InputStream in) throws Exception {
        ArrayList<List> list = new ArrayList<List>();
        SAXReader sr = new SAXReader();
        Document doc = sr.read(in);
        Element root = doc.getRootElement();
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element firstE = (Element)it.next();
            list.add(this.recurReadEle(firstE));
        }
        return list;
    }

    @Override
    public List parseXML(File file) throws Exception {
        ArrayList<List> list = new ArrayList<List>();
        SAXReader sr = new SAXReader();
        Document doc = sr.read(file);
        Element root = doc.getRootElement();
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element firstE = (Element)it.next();
            list.add(this.recurReadEle(firstE));
        }
        return list;
    }

    private void recurSetObject(Field field, Object object, Element element) throws Exception {
        String clsName = this.getElementClassAtt(element);
        List tList = null;
        log.debug("in recurSetObject element text = " + element.getTextTrim());
        if (field.getType().equals(Integer.TYPE)) {
            field.set(object, Integer.valueOf(element.getTextTrim()));
        } else if (field.getType().equals(Double.TYPE)) {
            field.set(object, Double.valueOf(element.getTextTrim()));
        } else if (field.getType().equals(Long.TYPE)) {
            field.set(object, Long.valueOf(element.getTextTrim()));
        } else if (field.getType().equals(String.class)) {
            field.set(object, element.getTextTrim());
        } else if (field.getType().isArray()) {
            if (clsName != null) {
                tList = this.recurReadEle(element);
                if (tList != null) {
                    field.set(object, tList.get(0));
                } else {
                    field.set(object, null);
                }
            } else {
                field.set(object, null);
            }
        } else if (field.getType().equals(List.class) || field.getType().equals(ArrayList.class)) {
            tList = this.recurReadEle(element);
            field.set(object, tList);
            log.warn("----warning \u5bf9\u8c61\u4e2d\u6ca1\u6709\u5bf9list\u505a\u652f\u6301----");
        } else {
            tList = this.recurReadEle(element);
            if (tList != null) {
                field.set(object, tList.get(0));
            } else {
                field.set(object, null);
            }
        }
    }

    private static boolean isPrimitiveCls(Class cls) {
        return cls == String.class || cls.isPrimitive();
    }

    public String getRootNodeName() {
        return this.rootNodeName;
    }

    public void setRootNodeName(String rootNodeName) {
        this.rootNodeName = rootNodeName;
    }

    public static void recurOutPut(Object obj) {
        block3: {
            Class<?> cls;
            block2: {
                cls = obj.getClass();
                if (!List.class.isInstance(obj)) break block2;
                for (Object o : (List)obj) {
                    XMLShellImp.recurOutPut(o);
                }
                break block3;
            }
            if (!cls.isArray()) break block3;
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                XMLShellImp.recurOutPut(Array.get(obj, i));
            }
        }
    }
}

