/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils.ofd;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.aws.ofd.util.OfdErrorType;
import kd.imc.rim.file.model.ofd.OfdInvoiceDto;
import kd.imc.rim.file.utils.BigDecimalUtil;
import kd.imc.rim.file.utils.CompressHelper;
import kd.imc.rim.file.utils.StrUtil;
import kd.imc.rim.file.utils.XmlUtil;
import kd.imc.rim.file.utils.ofd.OfdAnalysisUtil;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class OfdReadUtil {
    private static Log LOGGER = LogFactory.getLog(OfdReadUtil.class);

    public static Map<String, Object> extractData(byte[] fileBytes) {
        byte[] invoiceByte;
        Document document;
        String rootName;
        byte[] documentByte;
        String attachmentsPath;
        byte[] ofdMainByte;
        String docRootPath;
        StringBuilder dirPath;
        String path;
        Map<String, byte[]> decompressFileMap = CompressHelper.decompress(fileBytes);
        byte[] attachmentsByte = decompressFileMap.get(path = (dirPath = OfdReadUtil.getLastDirPath(docRootPath = OfdReadUtil.getTextByPath(ofdMainByte = decompressFileMap.get("OFD.xml"), "DocBody/DocRoot"))).append(attachmentsPath = OfdReadUtil.getTextByPath(documentByte = decompressFileMap.get(docRootPath), "Attachments")).toString().trim());
        String attachmentPath = OfdReadUtil.getTextByPath(attachmentsByte, "Attachment/FileLoc");
        if (attachmentPath == null) {
            attachmentPath = OfdReadUtil.getTextByPath(attachmentsByte, "Attachment/FileLoc");
        }
        if ("xbrl".equalsIgnoreCase(rootName = (document = OfdReadUtil.getDocumentByBytes(invoiceByte = decompressFileMap.get((dirPath = OfdReadUtil.getLastDirPath(path).append(attachmentPath)).toString()))).getRootElement().getQName().getName()) || !StringUtils.isEmpty((CharSequence)attachmentPath) && attachmentPath.toLowerCase(Locale.ROOT).endsWith("xbrl")) {
            String fileName = attachmentPath;
            String[] attachmentArr = attachmentPath.split("/");
            if (attachmentArr.length > 0) {
                fileName = attachmentArr[attachmentArr.length - 1];
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("file_type", "xbrl");
            dataMap.put("file_data", document.asXML());
            dataMap.put("file_name", fileName);
            return dataMap;
        }
        return OfdReadUtil.getInvoiceMap(invoiceByte);
    }

    public static Map<String, Object> extractDataFromAttachment(byte[] invoiceByte, String attachmentPath) {
        Document document = OfdReadUtil.getDocumentByBytes(invoiceByte);
        String rootName = document.getRootElement().getQName().getName();
        if ("xbrl".equalsIgnoreCase(rootName) || !StringUtils.isEmpty((CharSequence)attachmentPath) && attachmentPath.toLowerCase(Locale.ROOT).endsWith("xbrl")) {
            String fileName = attachmentPath;
            String[] attachmentArr = attachmentPath.split("/");
            if (attachmentArr.length > 0) {
                fileName = attachmentArr[attachmentArr.length - 1];
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("file_type", "xbrl");
            dataMap.put("file_data", document.asXML());
            dataMap.put("file_name", fileName);
            return dataMap;
        }
        Map<String, Object> invoiceMap = OfdReadUtil.getInvoiceMap(invoiceByte);
        invoiceMap.put("file_type", "xml");
        return invoiceMap;
    }

    public static JSONObject read(byte[] fileBytes) {
        OfdInvoiceDto dto;
        Map<String, byte[]> decompressFileMap = CompressHelper.decompress(fileBytes);
        JSONObject invoiceMap = OfdReadUtil.readInvoiceFormPage0(decompressFileMap);
        if (invoiceMap == null || invoiceMap.isEmpty()) {
            invoiceMap = OfdReadUtil.readInvoiceFormAttach(decompressFileMap);
        }
        if (invoiceMap == null || invoiceMap.isEmpty()) {
            try {
                invoiceMap = XmlUtil.Dom2AllElectricInvoiceMap(decompressFileMap.get("OFD.xml"));
            }
            catch (Exception e) {
                LOGGER.info("ofd\u89e3\u6790\u5931\u8d25" + e);
            }
        }
        if ((invoiceMap == null || invoiceMap.isEmpty()) && (dto = OfdAnalysisUtil.analysisOfdByCoordinate(decompressFileMap)) != null) {
            String json = JSONObject.toJSONString((Object)dto);
            invoiceMap = JSONObject.parseObject((String)json);
        }
        if (invoiceMap != null && !invoiceMap.isEmpty()) {
            OfdReadUtil.setInvoiceType(decompressFileMap, invoiceMap);
        }
        return invoiceMap;
    }

    private static JSONObject readInvoiceFormAttach(Map<String, byte[]> decompressFileMap) {
        String fileName = XmlUtil.getAttachFileName(decompressFileMap.get("Doc_0/Attachs/Attachments.xml"));
        if (fileName == null) {
            return null;
        }
        try {
            JSONObject result = XmlUtil.readAttach(decompressFileMap.get("Doc_0/Attachs/" + fileName));
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static JSONObject readInvoiceFormPage0(Map<String, byte[]> decompressFileMap) {
        try {
            String fileName = XmlUtil.getTagsFileName(decompressFileMap.get("Doc_0/Tags/CustomTags.xml"));
            Map<String, String> tagsMap = XmlUtil.Dom2TagsMap(decompressFileMap.get("Doc_0/Tags/" + fileName));
            JSONObject invoiceMap = XmlUtil.readPage0(tagsMap, decompressFileMap.get("Doc_0/Pages/Page_0/Content.xml"));
            return invoiceMap;
        }
        catch (Exception e) {
            LOGGER.info("ofd\u89e3\u6790\u660e\u7ec6\u5931\u8d25" + e);
            return null;
        }
    }

    private static void setInvoiceType(Map<String, byte[]> decompressFileMap, JSONObject invoiceMap) {
        String invoiceNo = invoiceMap.getString("invoiceNo");
        if (invoiceNo != null && invoiceNo.length() >= 19) {
            BigDecimal invoiceAmount = BigDecimal.ZERO;
            if (StringUtils.isNotEmpty((CharSequence)invoiceMap.getString("invoiceAmount"))) {
                invoiceAmount = BigDecimalUtil.transDecimal(invoiceMap.getString("invoiceAmount").replaceAll("\u00a5", ""));
            }
            BigDecimal totalTaxAmount = BigDecimal.ZERO;
            if (StringUtils.isNotEmpty((CharSequence)invoiceMap.getString("totalTaxAmount"))) {
                totalTaxAmount = BigDecimalUtil.transDecimal(invoiceMap.getString("totalTaxAmount").replaceAll("\u00a5", ""));
            }
            invoiceMap.put("totalAmount", (Object)invoiceAmount.add(totalTaxAmount));
            invoiceMap.put("invoiceAmount", (Object)invoiceAmount);
            invoiceMap.put("totalTaxAmount", (Object)totalTaxAmount);
            byte[] contentByte = decompressFileMap.get("Doc_0/Tpls/Tpl_0/Content.xml");
            if (contentByte == null) {
                contentByte = decompressFileMap.get("Doc_0/Pages/Page_0/Content.xml");
            }
            invoiceMap.put("invoiceType", (Object)OfdReadUtil.getInvoiceType(contentByte));
            invoiceMap.put("invoiceCode", (Object)"");
            invoiceMap.put("description", (Object)ResManager.loadKDString((String)"\u5168\u7535\u7968", (String)"OfdReadUtil_0", (String)"imc-rim-file", (Object[])new Object[0]));
            invoiceMap.put("type", (Object)"2");
        } else {
            invoiceMap.put("description", (Object)ResManager.loadKDString((String)"\u975e\u7535\u7968", (String)"OfdReadUtil_1", (String)"imc-rim-file", (Object[])new Object[0]));
            invoiceMap.put("type", (Object)"1");
        }
    }

    private static String getInvoiceType(byte[] contentByte) {
        try {
            String text = new String(contentByte, StandardCharsets.UTF_8);
            if (text.indexOf("\u4e13\u7528\u53d1\u7968") > 0) {
                return "27";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "26";
    }

    private static Map<String, Object> getInvoiceMap(byte[] invoiceByte) {
        try {
            Document document = OfdReadUtil.getDocumentByBytes(invoiceByte);
            String xml = document.asXML();
            return XmlUtil.Dom2Map(xml);
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.getDescription(), (Throwable)e);
            throw new KDException(new ErrorCode(OfdErrorType.EXTRACT_ERROR.errcode, OfdErrorType.EXTRACT_ERROR.getDescription()), new Object[0]);
        }
    }

    public static Map<String, Object> getOfdContentTagMap(byte[] dataByte) {
        try {
            Document document = OfdReadUtil.getDocumentByBytes(dataByte);
            String xml = document.asXML();
            return XmlUtil.Dom2MapV2(xml);
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.getDescription(), (Throwable)e);
            throw new KDException(new ErrorCode(OfdErrorType.EXTRACT_ERROR.errcode, OfdErrorType.EXTRACT_ERROR.getDescription()), new Object[0]);
        }
    }

    private static Document getDocumentByBytes(byte[] invoiceByte) {
        try {
            return XmlUtil.loadXML(invoiceByte);
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.getDescription(), (Throwable)e);
            throw new KDException(new ErrorCode(OfdErrorType.EXTRACT_ERROR.errcode, OfdErrorType.EXTRACT_ERROR.getDescription()), new Object[0]);
        }
    }

    public static Element getElementByPath(Map<String, byte[]> ofdFileMap, Element element, String dirPath) {
        String pagePath = dirPath + element.attributeValue("BaseLoc");
        return OfdReadUtil.getElementByByte(ofdFileMap.get(pagePath));
    }

    public static Element getElementByPath(Map<String, byte[]> ofdFileMap, String filePath) {
        return OfdReadUtil.getElementByByte(OfdReadUtil.getByteByPath(ofdFileMap, filePath));
    }

    public static byte[] getByteByPath(Map<String, byte[]> ofdFileMap, String filePath) {
        if (filePath != null && filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        return ofdFileMap.get(filePath);
    }

    public static Element getElementByByte(byte[] fileByte) {
        try {
            if (fileByte == null || fileByte.length == 0) {
                return null;
            }
            Document document = XmlUtil.loadXML(fileByte);
            return document.getRootElement();
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.LOAD_ERROR.getDescription(), (Throwable)e);
            throw new KDException(new ErrorCode(OfdErrorType.LOAD_ERROR.errcode, OfdErrorType.LOAD_ERROR.getDescription()), new Object[0]);
        }
    }

    public static StringBuilder getLastDirPath(String path) {
        String[] pathArr;
        StringBuilder buffer = new StringBuilder();
        for (String pathStr : pathArr = path.split("/")) {
            if (pathStr == null || pathStr.trim().equals("") || pathStr.contains(".")) continue;
            buffer.append(pathStr).append('/');
        }
        return buffer;
    }

    public static void getAllElementByElementName(Element parentElement, String elementName, String moreElementName, List<Element> targetList) {
        try {
            List moreElementList;
            List elementList = parentElement.elements(elementName);
            if (elementList != null && !elementList.isEmpty()) {
                targetList.addAll(elementList);
            }
            if ((moreElementList = parentElement.elements(moreElementName)) != null && !moreElementList.isEmpty()) {
                for (Element moreElement : moreElementList) {
                    OfdReadUtil.getAllElementByElementName(moreElement, elementName, moreElementName, targetList);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.getDescription(), (Throwable)e);
            throw new KDException(new ErrorCode(OfdErrorType.EXTRACT_ERROR.errcode, OfdErrorType.EXTRACT_ERROR.getDescription()), new Object[0]);
        }
    }

    public static String getDirPath(String path, String lastPath) {
        if (!StrUtil.isEmpty(path)) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!StrUtil.isEmpty(lastPath) && !path.startsWith(lastPath = OfdReadUtil.getLastDirPath(lastPath).toString())) {
                path = lastPath + path;
            }
        }
        return path;
    }

    public static String getTextByPath(byte[] fileByte, String path) {
        String text;
        try {
            String[] dirArr;
            Element elementNow = OfdReadUtil.getElementByByte(fileByte);
            for (String dir : dirArr = path.split("/")) {
                String[] arr;
                boolean moreFlag = false;
                if (dir.contains("|||") && (arr = dir.split("\\|\\|\\|")) != null && arr.length == 2) {
                    List elementList = elementNow.elements(arr[0]);
                    for (Element e : elementList) {
                        if (!arr[1].equals(e.attributeValue("Name"))) continue;
                        elementNow = e;
                        moreFlag = true;
                        break;
                    }
                }
                if (moreFlag) continue;
                if (elementNow.element(dir) != null) {
                    elementNow = elementNow.element(dir);
                    continue;
                }
                return null;
            }
            text = elementNow.getText();
            text = OfdReadUtil.removeStartSymbol(text, "/");
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.getDescription(), (Throwable)e);
            return null;
        }
        return text;
    }

    private static String removeStartSymbol(String str, String symbol) {
        while (!StrUtil.isEmpty(str) && str.startsWith(symbol)) {
            str = str.substring(1);
        }
        return str;
    }
}

