/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.async;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.dto.allele.AllEleCreditQuotaResponseDTO;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MqPublishUtils;
import kd.imc.bdm.lqpt.model.request.base.redconfirmdownload.RedConfirmDownloadHeadRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.base.redconfirmdownload.RedConfirmDownloadHeadItem;
import kd.imc.bdm.lqpt.model.response.base.redconfirmdownload.RedConfirmDownloadHeadResponse;
import kd.imc.bdm.lqpt.model.response.collect.InvoiceStatusQueryResponse;
import kd.imc.bdm.lqpt.service.ElectInvoiceUploadService;
import kd.imc.bdm.lqpt.service.InvoiceNoService;
import kd.imc.bdm.lqpt.service.SxedService;
import kd.imc.sim.async.AbstractAsyncIssueHandler;
import kd.imc.sim.common.helper.RimLqptQueryHelper;
import kd.imc.sim.common.helper.allele.AllEleInvoiceFileHelper;
import kd.imc.sim.common.helper.allele.CreditQuotaHelper;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LqAsyncIssueHandlerImpl
extends AbstractAsyncIssueHandler {
    @Override
    public void handlerInvoice(List<DynamicObject> asyncInvoices) {
        LOGGER.info(String.format("SyncLqptInvoiceTask request size: %d", asyncInvoices.size()));
        ElectInvoiceUploadService uploadService = new ElectInvoiceUploadService();
        InvoiceNoService invoiceNoService = new InvoiceNoService();
        for (DynamicObject asyncInvoice : asyncInvoices) {
            this.handOneleLqptInvoice(uploadService, invoiceNoService, asyncInvoice);
        }
    }

    /*
     * Loose catch block
     */
    public boolean handOneleLqptInvoice(ElectInvoiceUploadService uploadService, InvoiceNoService invoiceNoService, DynamicObject asyncInvoice) {
        block75: {
            Throwable throwable;
            DLock lock;
            block69: {
                boolean bl;
                block73: {
                    block74: {
                        DynamicObject invoice;
                        block70: {
                            boolean bl2;
                            block71: {
                                block72: {
                                    LqptResponse lqptResponse;
                                    block63: {
                                        boolean uploadTime22222222222222222222;
                                        block67: {
                                            block68: {
                                                block64: {
                                                    boolean uploadTime22222222222222222222;
                                                    block65: {
                                                        block66: {
                                                            block57: {
                                                                boolean date2222222222;
                                                                block61: {
                                                                    block62: {
                                                                        block58: {
                                                                            boolean bl3;
                                                                            block59: {
                                                                                block60: {
                                                                                    Date date2222222222;
                                                                                    block54: {
                                                                                        boolean bl4;
                                                                                        block55: {
                                                                                            block56: {
                                                                                                block51: {
                                                                                                    boolean bl5;
                                                                                                    block52: {
                                                                                                        block53: {
                                                                                                            block48: {
                                                                                                                boolean bl6;
                                                                                                                block49: {
                                                                                                                    block50: {
                                                                                                                        lock = DLock.create((String)(LqAsyncIssueHandlerImpl.class + asyncInvoice.getString("orderno")));
                                                                                                                        throwable = null;
                                                                                                                        if (lock.tryLock()) break block48;
                                                                                                                        bl6 = true;
                                                                                                                        if (lock == null) break block49;
                                                                                                                        if (throwable == null) break block50;
                                                                                                                        try {
                                                                                                                            lock.close();
                                                                                                                        }
                                                                                                                        catch (Throwable throwable2) {
                                                                                                                            throwable.addSuppressed(throwable2);
                                                                                                                        }
                                                                                                                        break block49;
                                                                                                                    }
                                                                                                                    lock.close();
                                                                                                                }
                                                                                                                return bl6;
                                                                                                            }
                                                                                                            invoice = this.checkInvoiceIssue(asyncInvoice);
                                                                                                            if (invoice != null) break block51;
                                                                                                            bl5 = true;
                                                                                                            if (lock == null) break block52;
                                                                                                            if (throwable == null) break block53;
                                                                                                            try {
                                                                                                                lock.close();
                                                                                                            }
                                                                                                            catch (Throwable throwable3) {
                                                                                                                throwable.addSuppressed(throwable3);
                                                                                                            }
                                                                                                            break block52;
                                                                                                        }
                                                                                                        lock.close();
                                                                                                    }
                                                                                                    return bl5;
                                                                                                }
                                                                                                if (LOGGER.isInfoEnabled()) {
                                                                                                    LOGGER.info(String.format("\u67e5\u8be2\u5f00\u7968\u7ed3\u679c\u53c2\u6570[%s]", SerializationUtils.toJsonString((Object)asyncInvoice)));
                                                                                                }
                                                                                                lqptResponse = uploadService.uploadResult(invoice, asyncInvoice);
                                                                                                if (LOGGER.isInfoEnabled()) {
                                                                                                    LOGGER.info(String.format("\u67e5\u8be2\u5f00\u7968\u7ed3\u679c\u8fd4\u56de[%s]", JSONObject.toJSONString((Object)lqptResponse)));
                                                                                                }
                                                                                                if (!lqptResponse.success()) break block54;
                                                                                                this.handleLqptInvoiceSuccess(invoice, asyncInvoice);
                                                                                                bl4 = true;
                                                                                                if (lock == null) break block55;
                                                                                                if (throwable == null) break block56;
                                                                                                try {
                                                                                                    lock.close();
                                                                                                }
                                                                                                catch (Throwable throwable4) {
                                                                                                    throwable.addSuppressed(throwable4);
                                                                                                }
                                                                                                break block55;
                                                                                            }
                                                                                            lock.close();
                                                                                        }
                                                                                        return bl4;
                                                                                    }
                                                                                    if (!"01".equals(lqptResponse.getErrcode())) break block57;
                                                                                    Date uploadTime22222222222222222222 = asyncInvoice.getDate("createdate");
                                                                                    if (uploadTime22222222222222222222 == null || !new Date().after(date2222222222 = DateUtils.addMinute((Date)DateUtils.addHour((Date)uploadTime22222222222222222222, (int)12), (int)10))) break block58;
                                                                                    invoice.set("result", (Object)lqptResponse.getDescription());
                                                                                    JSONObject json = new JSONObject();
                                                                                    json.put("orderno", (Object)invoice.getString("orderno"));
                                                                                    json.put("errormsg", (Object)invoice.getString("result"));
                                                                                    json.put("errcode", (Object)lqptResponse.getErrcode());
                                                                                    this.updateRedConfirmBillStatus(invoice, IssueStatusEnum.failed.getCode());
                                                                                    this.updateInvoiceStatus(json, IssueStatusEnum.failed.getCode(), false);
                                                                                    DeleteServiceHelper.delete((String)"sim_async_issue_invoice", (QFilter[])new QFilter("orderno", "=", (Object)json.getString("orderno")).toArray());
                                                                                    bl3 = true;
                                                                                    if (lock == null) break block59;
                                                                                    if (throwable == null) break block60;
                                                                                    try {
                                                                                        lock.close();
                                                                                    }
                                                                                    catch (Throwable throwable5) {
                                                                                        throwable.addSuppressed(throwable5);
                                                                                    }
                                                                                    break block59;
                                                                                }
                                                                                lock.close();
                                                                            }
                                                                            return bl3;
                                                                        }
                                                                        invoice.set("result", (Object)ResManager.loadKDString((String)"\u4e50\u4f01\u67e5\u8be2\u53d1\u7968\u7ed3\u679c\u8fd4\u56de[\u53d1\u7968\u4e0a\u4f20\u5904\u7406\u4e2d]", (String)"LqAsyncIssueHandlerImpl_0", (String)"imc-sim-service", (Object[])new Object[0]));
                                                                        ImcSaveServiceHelper.update((DynamicObject)invoice);
                                                                        this.updateQueryCount(asyncInvoice);
                                                                        date2222222222 = false;
                                                                        if (lock == null) break block61;
                                                                        if (throwable == null) break block62;
                                                                        try {
                                                                            lock.close();
                                                                        }
                                                                        catch (Throwable json) {
                                                                            throwable.addSuppressed(json);
                                                                        }
                                                                        break block61;
                                                                    }
                                                                    lock.close();
                                                                }
                                                                return date2222222222;
                                                            }
                                                            if (!"02".equals(lqptResponse.getErrcode())) break block63;
                                                            if (!this.getRedConfirmUsed(invoice, asyncInvoice, lqptResponse)) break block64;
                                                            uploadTime22222222222222222222 = true;
                                                            if (lock == null) break block65;
                                                            if (throwable == null) break block66;
                                                            try {
                                                                lock.close();
                                                            }
                                                            catch (Throwable date2222222222) {
                                                                throwable.addSuppressed(date2222222222);
                                                            }
                                                            break block65;
                                                        }
                                                        lock.close();
                                                    }
                                                    return uploadTime22222222222222222222;
                                                }
                                                this.handleFailed(invoice, invoiceNoService, lqptResponse);
                                                uploadTime22222222222222222222 = true;
                                                if (lock == null) break block67;
                                                if (throwable == null) break block68;
                                                try {
                                                    lock.close();
                                                }
                                                catch (Throwable date2222222222) {
                                                    throwable.addSuppressed(date2222222222);
                                                }
                                                break block67;
                                            }
                                            lock.close();
                                        }
                                        return uploadTime22222222222222222222;
                                    }
                                    if (!"03".equals(lqptResponse.getErrcode())) break block69;
                                    String invoiceNo = invoice.getString("invoiceno");
                                    QFilter invoiceFilter = InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)"", (String)invoiceNo).and("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode()).and("issuesource", "=", (Object)"13").and("id", "!=", invoice.getPkValue());
                                    if (!QueryServiceHelper.exists((String)"sim_vatinvoice", (QFilter[])invoiceFilter.toArray())) break block70;
                                    if (LOGGER.isInfoEnabled()) {
                                        LOGGER.info(String.format("\u6570\u636e\u5e93\u5df2\u5b58\u5728\u53d1\u7968\u53f7\u7801\u4e3a[%s]\u7684\u53d1\u7968", invoice.getString("invoiceno")));
                                    }
                                    this.handleFailed(invoice, invoiceNoService, lqptResponse);
                                    ImcSaveServiceHelper.update((DynamicObject)invoice);
                                    try {
                                        if ("1".equals(ImcConfigUtil.getValue((String)"invoiceRepeatEnterMq", (String)"invoiceRepeatEnterMq"))) {
                                            String lockKey = "invoiceRepeatLock" + invoice.getString("orderno");
                                            if (String.valueOf(lqptResponse.getDescription()).contains("\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728")) {
                                                String repeatNum;
                                                String string = repeatNum = StringUtils.isBlank((CharSequence)CacheHelper.get((String)lockKey)) ? "0" : CacheHelper.get((String)lockKey);
                                                if (Integer.parseInt(repeatNum) < 200) {
                                                    repeatNum = String.valueOf(Integer.parseInt(repeatNum) + 1);
                                                    CacheHelper.put((String)lockKey, (String)repeatNum, (int)3600);
                                                    ArrayList<String> message = new ArrayList<String>();
                                                    message.add(invoice.getString("orderno"));
                                                    MqPublishUtils.publish((String)"imc", (String)"imc.sim.sim_queue", message);
                                                }
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        LOGGER.info("invoiceRepeatEnterMqError:" + e.getMessage(), (Object)e);
                                    }
                                    bl2 = true;
                                    if (lock == null) break block71;
                                    if (throwable == null) break block72;
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    break block71;
                                }
                                lock.close();
                            }
                            return bl2;
                        }
                        this.updateQueryCount(asyncInvoice);
                        bl = this.queryRimInvoiceStatus(asyncInvoice, invoice);
                        if (lock == null) break block73;
                        if (throwable == null) break block74;
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                        break block73;
                    }
                    lock.close();
                }
                return bl;
            }
            try {
                break block75;
                catch (Exception e) {
                    LOGGER.error(String.format("\u67e5\u8be2\u5f00\u7968\u7ed3\u679c\u5f02\u5e38[%s]", SerializationUtils.toJsonString((Object)asyncInvoice)), (Throwable)e);
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            catch (Throwable throwable9) {
                throw throwable9;
            }
            finally {
                if (lock != null) {
                    if (throwable != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable10) {
                            throwable.addSuppressed(throwable10);
                        }
                    } else {
                        lock.close();
                    }
                }
            }
        }
        return false;
    }

    private boolean getRedConfirmUsed(DynamicObject invoice, DynamicObject asyncInvoice, LqptResponse lqptResponse) {
        if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) >= 0) {
            return false;
        }
        String errorMsg = ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"redconfirm_used_msg");
        if (StringUtils.isBlank((CharSequence)errorMsg)) {
            errorMsg = ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u5df2\u4f7f\u7528\uff0c\u4e0d\u53ef\u5f00\u5177\u3002\u8bf7\u5148\u7533\u8bf7\u65b0\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\u3002", (String)"LqAsyncIssueHandlerImpl_1", (String)"imc-sim-service", (Object[])new Object[0]);
        }
        if (!errorMsg.equals(lqptResponse.getDescription())) {
            return false;
        }
        try {
            RedConfirmDownloadHeadResponse lqResponse;
            List lqList;
            String redConfirmBillNo = invoice.getString("infocode");
            String taxNo = invoice.getString("salertaxno");
            RedConfirmDownloadHeadRequest lqRequest = new RedConfirmDownloadHeadRequest();
            lqRequest.setNsrsbh(taxNo);
            lqRequest.setYhjslx("0");
            lqRequest.setXsfmc(invoice.getString("salername"));
            lqRequest.setXsfnsrsbh(taxNo);
            lqRequest.setHzfpxxqrdbh(redConfirmBillNo);
            lqRequest.setPageNumber(Integer.valueOf(1));
            lqRequest.setPageSize(Integer.valueOf(1));
            DynamicObject redConfirmBill = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)"uploaddate", (QFilter[])new QFilter("number", "=", (Object)redConfirmBillNo).toArray());
            if (null != redConfirmBill && redConfirmBill.getDate("uploaddate") != null) {
                Date lrrq = DateUtils.getDayStart((Date)redConfirmBill.getDate("uploaddate"));
                lqRequest.setLrrqq(DateUtils.addDay((Date)lrrq, (int)-1));
                lqRequest.setLrrqz(DateUtils.addDay((Date)lrrq, (int)1));
            }
            if (CollectionUtils.isEmpty((Collection)(lqList = (lqResponse = RedConfirmBillHelper.queryRedConfirmListByLq(lqRequest)).getList()))) {
                return false;
            }
            RedConfirmDownloadHeadItem redConfirmDownloadHeadItem = (RedConfirmDownloadHeadItem)lqList.get(0);
            if (!redConfirmDownloadHeadItem.getHzfpxxqrdbh().equals(invoice.getString("infocode"))) {
                return false;
            }
            if (StringUtils.isBlank((CharSequence)redConfirmDownloadHeadItem.getHzfphm()) || StringUtils.isBlank((CharSequence)redConfirmDownloadHeadItem.getHzkprq())) {
                return false;
            }
            InvoiceNoService invoiceNoService = new InvoiceNoService();
            String invoiceNo = asyncInvoice.getString("invoiceno");
            if (StringUtils.isNotBlank((CharSequence)invoiceNo) && !redConfirmDownloadHeadItem.getHzfphm().equals(invoiceNo)) {
                invoiceNoService.sendBack(taxNo, invoiceNo);
            }
            invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"sim_vatinvoice");
            String redInvoiceNo = redConfirmDownloadHeadItem.getHzfphm();
            QFilter qFilter = new QFilter("nsrsbh", "=", (Object)taxNo).and("fpqshm", "<=", (Object)redInvoiceNo).and("fpzzhm", ">=", (Object)redInvoiceNo);
            if (!QueryServiceHelper.exists((String)"bdm_lqpt_yfm", (QFilter[])qFilter.toArray())) {
                invoice.set("issuesource", (Object)"12");
            }
            invoice.set("invoiceno", (Object)redInvoiceNo);
            invoice.set("issuetime", (Object)DateUtils.handleDate((String)redConfirmDownloadHeadItem.getHzkprq()));
            asyncInvoice.set("invoiceno", (Object)redInvoiceNo);
            asyncInvoice.set("issuetime", (Object)DateUtils.handleDate((String)redConfirmDownloadHeadItem.getHzkprq()));
            this.handleLqptInvoiceSuccess(invoice, asyncInvoice, false);
            invoiceNoService.invoiceSuccess(taxNo, redInvoiceNo);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7" + invoice.getString("infocode") + "\u4fee\u590d\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean queryRimInvoiceStatus(DynamicObject asyncInvoice, DynamicObject invoice) {
        String accountingQuery = ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"open_rim_invoice_account_query");
        if (!"1".equals(accountingQuery)) {
            return false;
        }
        if (asyncInvoice.getInt("querycount") <= 300) {
            return false;
        }
        Date issueTime = invoice.getDate("issuetime");
        if (issueTime == null) {
            return false;
        }
        InvoiceStatusQueryResponse queryResponse = new RimLqptQueryHelper().invoiceAccountingQuery(invoice.getString("salertaxno"), invoice.getString("invoicetype"), "", invoice.getString("invoiceno"), invoice.getDate("issuetime"));
        if (queryResponse.getKprq() == null) {
            return false;
        }
        if (DateUtils.format((Date)queryResponse.getKprq(), (String)"yyyy-MM-dd HH:mm:ss").equals(DateUtils.format((Date)issueTime, (String)"yyyy-MM-dd HH:mm:ss"))) {
            this.handleLqptInvoiceSuccess(invoice, asyncInvoice);
            return true;
        }
        return false;
    }

    private void updateQueryCount(DynamicObject asyncInvoice) {
        int queryCount = asyncInvoice.getInt("querycount");
        asyncInvoice.set("querycount", (Object)(++queryCount));
        ImcSaveServiceHelper.update((DynamicObject)asyncInvoice);
    }

    public void handleFailed(DynamicObject invoice, InvoiceNoService invoiceNoService, LqptResponse lqptResponse) {
        invoice.set("result", (Object)lqptResponse.getDescription());
        String invoiceNo = invoice.getString("invoiceno");
        if (StringUtils.isNotBlank((CharSequence)invoiceNo) && InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype"))) {
            invoiceNoService.sendBack(invoice.getString("salertaxno"), invoiceNo);
            invoice.set("issuetime", null);
        }
        this.handleLqptInvoiceFailed(invoice, lqptResponse.getErrcode());
    }

    public void handleLqptInvoiceSuccess(DynamicObject invoice, DynamicObject asyncInvoice) {
        this.handleLqptInvoiceSuccess(invoice, asyncInvoice, true);
    }

    private void handleLqptInvoiceSuccess(DynamicObject invoice, DynamicObject asyncInvoice, boolean queryInvoice) {
        if (queryInvoice) {
            invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"sim_vatinvoice");
        }
        if (StringUtils.isBlank((CharSequence)invoice.getString("invoiceno")) && StringUtils.isNotBlank((CharSequence)asyncInvoice.getString("invoiceno"))) {
            invoice.set("invoiceno", asyncInvoice.get("invoiceno"));
        }
        if (invoice.getDate("issuetime") == null && asyncInvoice.getDate("issuetime") != null) {
            invoice.set("issuetime", asyncInvoice.get("issuetime"));
        }
        if (StringUtils.isNotBlank((CharSequence)invoice.getString("invoiceno"))) {
            IssueInvoiceService.deleteIncomeDownloadInvoice((String)"", (String)invoice.getString("invoiceno"));
        }
        this.beforeDoSaveInvoice(invoice);
        IssueInvoiceService.saveInvoice((DynamicObject)invoice);
        IssueInvoiceService.afterSaveInvoiceOperation((DynamicObject)invoice);
        this.afterDoSaveInvoie(invoice);
    }

    private void afterDoSaveInvoie(DynamicObject invoice) {
        this.updateRedConfirmBillStatus(invoice, IssueStatusEnum.ok.getCode());
        DeleteServiceHelper.delete((String)"sim_async_issue_invoice", (QFilter[])new QFilter("orderno", "=", (Object)invoice.getString("orderno")).toArray());
    }

    private void beforeDoSaveInvoice(DynamicObject invoice) {
        IssueInvoiceService.updateBaseInvoiceType((DynamicObject)invoice);
        AllEleInvoiceFileHelper.addFileRecord((DynamicObject)invoice, (String)"lqpt");
        IssueInvoiceService.warpPushStatus((DynamicObject)invoice);
        invoice.set("invoicestatus", (Object)"0");
        invoice.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
        invoice.set("invoicecopy", (Object)"-1");
        invoice.set("billstatus", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
        invoice.set("result", (Object)"");
        invoice.set("downloadflag", (Object)"0");
        invoice.set("printflag", (Object)"0");
        invoice.set("reissuestatus", (Object)"0");
        String taxNo = invoice.getString("salertaxno");
        try {
            CreditQuotaHelper.setCreditQuota((String)taxNo, (AllEleCreditQuotaResponseDTO)new SxedService().querySxed(taxNo));
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u67e5\u8be2\u6388\u4fe1\u989d\u5ea6\u5931\u8d25\uff0c\u7a0e\u53f7[%s]", taxNo), (Throwable)e);
        }
    }
}

