/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceBuyerTypeEnum;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.enums.AsstactTypeEnum;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.InvTitleSettingHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.formplugin.match.BillMatchHelper;

public class InvTitleMatchHelper {
    private static final Log LOG = LogFactory.getLog(InvTitleMatchHelper.class);

    public static void matchInvTitle(Map<String, List<Map<String, Object>>> oriBillListMap, Long orgId) {
        boolean isComplete;
        String buyerName;
        String buyerProperty;
        List<Map<String, Object>> billList;
        DynamicObject invTitleSetting = InvTitleSettingHelper.getInvTitleSetting((Long)orgId);
        if (invTitleSetting == null) {
            return;
        }
        if (invTitleSetting.getBoolean(InvTitleSettingHelper.InvTitleMappingEnum.TIT_MAPP_BILL_IMPORT.getCode())) {
            BillMatchHelper billMatchHelper = new BillMatchHelper();
            for (Map.Entry<String, List<Map<String, Object>>> entry : oriBillListMap.entrySet()) {
                billList = entry.getValue();
                if (null == billList || billList.isEmpty()) {
                    return;
                }
                for (Map<String, Object> map : billList) {
                    String originalBuyerTaxNo;
                    buyerProperty = String.valueOf(map.get("buyerproperty"));
                    buyerName = (String)map.get("buyername");
                    DynamicObject titleObj = InvTitleMatchHelper.getTitleObjByFilter(buyerName, originalBuyerTaxNo = (String)map.get("buyertaxno"), "", orgId, InvTitleMatchHelper.getTitleBuyerType(buyerProperty));
                    if (null == titleObj) {
                        if (invTitleSetting.getBoolean("forcemapping")) {
                            throw new MsgException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u6620\u5c04\u7684\u5f00\u7968\u62ac\u5934\uff0c\u8bf7\u67e5\u8bc1\u540e\u518d\u5bfc\u5165\u5f00\u7968\u7533\u8bf7\u5355", (String)"OriginalBillImportPlugin_308", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        }
                        if (!StringUtils.equals((CharSequence)buyerProperty, (CharSequence)"1") || !StringUtils.isEmpty((CharSequence)originalBuyerTaxNo)) continue;
                        LOG.info("\u5339\u914d\u4e2a\u4eba\u4fe1\u606f...");
                        map.put("buyertaxno", InvTitleMatchHelper.matchBuyerPerson(orgId, buyerName));
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)buyerProperty, (CharSequence)"1") && InvTitleMatchHelper.checkBuyerInfoByPerson(map) || InvTitleMatchHelper.checkBuyerInfo(map)) continue;
                    map.put("buyername", titleObj.getString("name"));
                    String buyerTaxNo = titleObj.getString("taxno");
                    if (StringUtils.equals((CharSequence)buyerProperty, (CharSequence)"1")) {
                        buyerTaxNo = titleObj.getString("idcode");
                    }
                    map.put("buyertaxno", buyerTaxNo);
                    DynamicObjectCollection items = titleObj.getDynamicObjectCollection("items");
                    if (!CollectionUtils.isEmpty((Collection)items)) {
                        DynamicObject billHead = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
                        DynamicObjectUtil.map2DynamicObject(map, (DynamicObject)billHead);
                        billMatchHelper.matchBuyerAddrAndBank(billHead, items);
                        map.put("buyeraddr", billHead.getString("buyeraddr"));
                        map.put("buyerbank", billHead.getString("buyerbank"));
                        map.put("buyerphone", billHead.getString("buyerphone"));
                        map.put("buyeremail", billHead.getString("buyeremail"));
                    }
                    if (!StringUtils.equals((CharSequence)buyerProperty, (CharSequence)"1") || !StringUtils.isEmpty((CharSequence)buyerTaxNo)) continue;
                    LOG.info("\u5339\u914d\u4e2a\u4eba\u4fe1\u606f2...");
                    map.put("buyertaxno", InvTitleMatchHelper.matchBuyerPerson(orgId, buyerName));
                }
            }
        }
        if (isComplete = invTitleSetting.getBoolean("iscomplete")) {
            for (Map.Entry<String, List<Map<String, Object>>> entry : oriBillListMap.entrySet()) {
                billList = entry.getValue();
                if (null == billList || billList.isEmpty()) {
                    return;
                }
                for (Map<String, Object> map : billList) {
                    DynamicObjectCollection items;
                    buyerProperty = String.valueOf(map.get("buyerproperty"));
                    if ("1".equals(buyerProperty)) continue;
                    buyerName = (String)map.get("buyername");
                    String buyerTaxpayerId = (String)map.get("buyertaxno");
                    QFilter orgIdFilter = ImcBaseDataHelper.getInvTitleFilter((Object)orgId).and("buyertype", "=", (Object)InvTitleMatchHelper.getTitleBuyerType(buyerProperty));
                    QFilter titleFilter = null;
                    DynamicObject titleObj = null;
                    if (StringUtils.isNotEmpty((CharSequence)buyerName) && StringUtils.isNotEmpty((CharSequence)buyerTaxpayerId)) {
                        titleFilter = new QFilter("name", "=", (Object)buyerName);
                        titleFilter.and("taxno", "=", (Object)buyerTaxpayerId);
                        titleObj = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_invice_title_strate", (boolean)true), (QFilter[])titleFilter.and(orgIdFilter).toArray());
                        if (titleObj == null) {
                            titleFilter = new QFilter("taxno", "=", (Object)buyerTaxpayerId);
                            titleObj = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_invice_title_strate", (boolean)true), (QFilter[])titleFilter.and(orgIdFilter).toArray());
                        }
                    } else {
                        if (StringUtils.isNotBlank((CharSequence)buyerName)) {
                            titleFilter = new QFilter("name", "=", (Object)buyerName);
                        }
                        if (StringUtils.isNotBlank((CharSequence)buyerTaxpayerId)) {
                            titleFilter = new QFilter("taxno", "=", (Object)buyerTaxpayerId);
                        }
                        if (titleFilter != null) {
                            titleObj = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_invice_title_strate", (boolean)true), (QFilter[])titleFilter.and(orgIdFilter).toArray());
                        }
                    }
                    if (titleObj == null) continue;
                    map.put("buyertaxno", titleObj.getString("taxno"));
                    if (StringUtils.isBlank((Object)map.get("buyername"))) {
                        map.put("buyername", titleObj.getString("name"));
                    }
                    if (CollectionUtils.isEmpty((Collection)(items = titleObj.getDynamicObjectCollection("items")))) continue;
                    DynamicObject billHead = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
                    DynamicObjectUtil.map2DynamicObject(map, (DynamicObject)billHead);
                    new BillMatchHelper().matchBuyerAddrAndBank(billHead, items);
                    if (StringUtils.isBlank((Object)map.get("buyeraddr"))) {
                        map.put("buyeraddr", billHead.getString("buyeraddr"));
                    }
                    if (StringUtils.isBlank((Object)map.get("buyerbank"))) {
                        map.put("buyerbank", billHead.getString("buyerbank"));
                    }
                    if (StringUtils.isBlank((Object)map.get("buyerphone"))) {
                        map.put("buyerphone", billHead.getString("buyerphone"));
                    }
                    if (!StringUtils.isBlank((Object)map.get("buyeremail"))) continue;
                    map.put("buyeremail", billHead.getString("buyeremail"));
                }
            }
        }
    }

    public static String matchBuyerPerson(long orgId, String buyerName) {
        Map<String, String> matchResult = InvTitleMatchHelper.matchBuyerPersonInfo(orgId, buyerName);
        if (null == matchResult) {
            return null;
        }
        return matchResult.get("idcode");
    }

    public static Map<String, String> matchBuyerPersonInfo(long orgId, String buyerName) {
        HashMap<String, String> matchResult = new HashMap<String, String>();
        matchResult.put("name", buyerName);
        if (StringUtils.isBlank((CharSequence)buyerName)) {
            return null;
        }
        DynamicObject fpyTitle = null;
        String queryFields = "name,idcode";
        QFilter qFilterBase = new QFilter("buyertype", "=", (Object)InvoiceBuyerTypeEnum.person.getTypeCode());
        QFilter baseDataFilter = ImcBaseDataHelper.getInvTitleFilter((Object)orgId);
        QFilter custNameFilter = new QFilter("cust.customername", "=", (Object)buyerName);
        QFilter copy = qFilterBase.copy();
        QFilter baseFilterCopy = baseDataFilter.copy();
        QFilter filter = baseFilterCopy.and(copy).and(custNameFilter);
        DynamicObject[] fpyTitleColl = BusinessDataServiceHelper.load((String)"bdm_invice_title_strate", (String)queryFields, (QFilter[])filter.toArray());
        if (fpyTitleColl.length == 0) {
            QFilter qFilter = qFilterBase.copy();
            qFilter.and("name", "=", (Object)buyerName);
            qFilter.and(baseDataFilter.copy());
            fpyTitleColl = BusinessDataServiceHelper.load((String)"bdm_invice_title_strate", (String)queryFields, (QFilter[])qFilter.toArray());
        }
        if (fpyTitleColl.length > 0) {
            LOG.info("\u8d2d\u65b9\u62ac\u5934\u4fe1\u606f\uff1a{}", (Object)fpyTitleColl[0].getString("idcode"));
            fpyTitle = fpyTitleColl[0];
        }
        if (null != fpyTitle) {
            matchResult.put("name", fpyTitle.getString("name"));
            matchResult.put("idcode", fpyTitle.getString("idcode"));
            return matchResult;
        }
        QFilter platformFilter = new QFilter("type", "=", (Object)"4");
        QFilter baseCustomerFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)orgId);
        platformFilter.and("enable", "=", (Object)"1");
        platformFilter.and("name", "=", (Object)buyerName);
        platformFilter.and(baseCustomerFilter);
        DynamicObject[] platformColl = BusinessDataServiceHelper.load((String)"bd_customer", (String)"idno", (QFilter[])platformFilter.toArray());
        if (platformColl != null && platformColl.length == 1) {
            LOG.info("\u5e73\u53f0\u57fa\u7840\u8d44\u6599\u5339\u914d\u5230\u4e00\u4e2a\u76f4\u63a5\u66f4\u65b0\u6570\u636e\uff1a{}", (Object)platformColl[0].getString("idno"));
            matchResult.put("idcode", platformColl[0].getString("idno"));
            return matchResult;
        }
        return null;
    }

    public static void matchInvTitle(List<BillVo> billVoList, boolean isOpenTitleMapping, DynamicObject invTitleSettingDO) {
        try {
            boolean isComplete;
            String buyerName;
            String buyerProperty;
            if (LOG.isInfoEnabled()) {
                LOG.info("\u62ac\u5934\u6620\u5c04 " + isOpenTitleMapping);
            }
            if (invTitleSettingDO == null) {
                return;
            }
            if (CollectionUtils.isEmpty(billVoList)) {
                return;
            }
            if (isOpenTitleMapping) {
                BillMatchHelper billMatchHelper = new BillMatchHelper();
                for (BillVo billVo : billVoList) {
                    buyerProperty = String.valueOf(billVo.getBuyerProperty());
                    if ("1".equals(buyerProperty) && InvTitleMatchHelper.checkBuyerInfoByPerson(billVo)) continue;
                    buyerName = billVo.getBuyerName();
                    DynamicObject titleObj = InvTitleMatchHelper.getTitleObjByFilter(buyerName, billVo.getBuyerTaxpayerId(), billVo.getBuyerCode(), billVo.getOrgId(), InvTitleMatchHelper.getTitleBuyerType(buyerProperty));
                    if (null == titleObj) {
                        InvTitleMatchHelper.setBuyInfoByBill(buyerProperty, buyerName, billVo);
                        if (!invTitleSettingDO.getBoolean("forcemapping")) continue;
                        throw new MsgException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u6620\u5c04\u7684\u5f00\u7968\u62ac\u5934\uff0c\u8bf7\u67e5\u8bc1\u540e\u518d\u5bfc\u5165\u5f00\u7968\u7533\u8bf7\u5355", (String)"OriginalBillImportPlugin_308", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    }
                    billVo.setBuyerName(titleObj.getString("name"));
                    if (StringUtils.equals((CharSequence)buyerProperty, (CharSequence)"1")) {
                        billVo.setBuyerTaxpayerId(titleObj.getString("idcode"));
                    } else {
                        billVo.setBuyerTaxpayerId(titleObj.getString("taxno"));
                    }
                    DynamicObjectCollection items = titleObj.getDynamicObjectCollection("items");
                    if (!CollectionUtils.isEmpty((Collection)items)) {
                        DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
                        DynamicObjectUtil.bean2DynamicObject((Object)billVo, (DynamicObject)bill);
                        billMatchHelper.matchBuyerAddrAndBank(bill, items);
                        billVo.setBuyerAddressAndTel(bill.getString("buyeraddr"));
                        billVo.setBuyerBankAndAccount(bill.getString("buyerbank"));
                        billVo.setBuyerRecipientPhone(bill.getString("buyerphone"));
                        billVo.setBuyerRecipientMail(bill.getString("buyeremail"));
                    }
                    InvTitleMatchHelper.setBuyInfoByBill(buyerProperty, buyerName, billVo);
                }
            }
            if (isComplete = invTitleSettingDO.getBoolean("iscomplete")) {
                for (BillVo billVo : billVoList) {
                    DynamicObjectCollection items;
                    buyerProperty = String.valueOf(billVo.getBuyerProperty());
                    if ("1".equals(buyerProperty) && InvTitleMatchHelper.checkBuyerInfoByPerson(billVo)) continue;
                    buyerName = billVo.getBuyerName();
                    String buyerTaxpayerId = billVo.getBuyerTaxpayerId();
                    QFilter orgIdFilter = ImcBaseDataHelper.getInvTitleFilter((Object)billVo.getOrgId()).and("buyertype", "=", (Object)InvTitleMatchHelper.getTitleBuyerType(buyerProperty));
                    QFilter titleFilter = null;
                    DynamicObject titleObj = null;
                    if (StringUtils.isNotEmpty((CharSequence)buyerName) && StringUtils.isNotEmpty((CharSequence)buyerTaxpayerId)) {
                        titleFilter = new QFilter("name", "=", (Object)buyerName);
                        titleFilter.and("taxno", "=", (Object)buyerTaxpayerId);
                        titleObj = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_invice_title_strate", (boolean)true), (QFilter[])titleFilter.and(orgIdFilter).toArray());
                        if (titleObj == null) {
                            titleFilter = new QFilter("taxno", "=", (Object)buyerTaxpayerId);
                            titleObj = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_invice_title_strate", (boolean)true), (QFilter[])titleFilter.and(orgIdFilter).toArray());
                        }
                    } else {
                        if (StringUtils.isNotBlank((CharSequence)buyerName)) {
                            titleFilter = new QFilter("name", "=", (Object)buyerName);
                        }
                        if (StringUtils.isNotBlank((CharSequence)buyerTaxpayerId)) {
                            titleFilter = new QFilter("taxno", "=", (Object)buyerTaxpayerId);
                        }
                        if (titleFilter != null) {
                            titleObj = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_invice_title_strate", (boolean)true), (QFilter[])titleFilter.and(orgIdFilter).toArray());
                        }
                    }
                    if (titleObj == null) continue;
                    billVo.setBuyerTaxpayerId(titleObj.getString("taxno"));
                    if (StringUtils.isBlank((CharSequence)billVo.getBuyerName())) {
                        billVo.setBuyerName(titleObj.getString("name"));
                    }
                    if (CollectionUtils.isEmpty((Collection)(items = titleObj.getDynamicObjectCollection("items")))) continue;
                    DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
                    DynamicObjectUtil.bean2DynamicObject((Object)billVo, (DynamicObject)bill);
                    new BillMatchHelper().matchBuyerAddrAndBank(bill, items);
                    if (StringUtils.isEmpty((CharSequence)billVo.getBuyerAddressAndTel())) {
                        billVo.setBuyerAddressAndTel(bill.getString("buyeraddr"));
                    }
                    if (StringUtils.isEmpty((CharSequence)billVo.getBuyerBankAndAccount())) {
                        billVo.setBuyerBankAndAccount(bill.getString("buyerbank"));
                    }
                    if (StringUtils.isEmpty((CharSequence)billVo.getBuyerRecipientPhone())) {
                        billVo.setBuyerRecipientPhone(bill.getString("buyerphone"));
                    }
                    if (!StringUtils.isEmpty((CharSequence)billVo.getBuyerRecipientMail())) continue;
                    billVo.setBuyerRecipientMail(bill.getString("buyeremail"));
                }
            }
        }
        catch (Exception e) {
            LOG.info(String.format("\u5339\u914d\u5f00\u7968\u62ac\u5934\u5931\u8d25\uff1a%s", e));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5339\u914d\u5f00\u7968\u62ac\u5934\u5931\u8d25\uff1a%s", (String)"InvTitleMatchHelper_0", (String)"imc-sim-service", (Object[])new Object[0]), e));
        }
    }

    private static String getTitleBuyerType(String billBuyerType) {
        String buyerType = "1";
        if ("1".equals(billBuyerType)) {
            buyerType = "2";
        } else if ("2".equals(billBuyerType)) {
            buyerType = "3";
        }
        return buyerType;
    }

    private static void setBuyInfoByBill(String buyerProperty, String buyerName, BillVo billVo) {
        if (StringUtils.equals((CharSequence)buyerProperty, (CharSequence)"1") && StringUtils.isEmpty((CharSequence)billVo.getBuyerTaxpayerId())) {
            billVo.setBuyerTaxpayerId(InvTitleMatchHelper.matchBuyerPerson(billVo.getOrgId(), buyerName));
        }
    }

    private static DynamicObject getTitleObjByFilter(String name, String taxNo, String buyerCode, Long orgId, String cusType) {
        QFilter titleBuyerCodeFilter;
        DynamicObject titleObj;
        String selFields = PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_invice_title_strate", (boolean)true);
        QFilter orgIdFilter = ImcBaseDataHelper.getInvTitleFilter((Object)orgId).and("buyertype", "=", (Object)cusType);
        if (StringUtils.isNotBlank((CharSequence)buyerCode) && null != (titleObj = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (String)selFields, (QFilter[])(titleBuyerCodeFilter = new QFilter("number", "in", (Object)buyerCode)).and(orgIdFilter).toArray()))) {
            return titleObj;
        }
        if (StringUtils.isBlank((CharSequence)name) && StringUtils.isBlank((CharSequence)taxNo)) {
            return null;
        }
        QFilter titleFilter = new QFilter("1", "=", (Object)-1);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            titleFilter.or("name", "=", (Object)name);
        }
        if (StringUtils.isNotBlank((CharSequence)taxNo)) {
            titleFilter.or("taxno", "=", (Object)taxNo);
        }
        if (null == (titleObj = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (String)selFields, (QFilter[])titleFilter.and(orgIdFilter).toArray()))) {
            QFilter cusFilter = new QFilter("1", "=", (Object)-1);
            if (StringUtils.isNotBlank((CharSequence)name)) {
                cusFilter.or("cust.".concat("customername"), "=", (Object)name);
            }
            if (StringUtils.isNotBlank((CharSequence)taxNo)) {
                cusFilter.or("cust.".concat("customertaxno"), "=", (Object)taxNo);
            }
            titleObj = BusinessDataServiceHelper.loadSingle((String)"bdm_invice_title_strate", (String)selFields, (QFilter[])cusFilter.and(orgIdFilter).toArray());
        }
        return titleObj;
    }

    public static boolean checkBuyerInfoByPerson(Object bill) {
        if (bill instanceof Map) {
            return StringUtils.isNotBlank(((Map)bill).get("buyertaxno")) && StringUtils.isNotBlank(((Map)bill).get("buyername"));
        }
        if (bill instanceof BillVo) {
            return StringUtils.isNotBlank((CharSequence)((BillVo)bill).getBuyerTaxpayerId()) && StringUtils.isNotBlank((CharSequence)((BillVo)bill).getBuyerName());
        }
        if (bill instanceof DynamicObject) {
            return StringUtils.isNotBlank((CharSequence)((DynamicObject)bill).getString("buyertaxno")) && StringUtils.isNotBlank((CharSequence)((DynamicObject)bill).getString("buyername"));
        }
        return false;
    }

    public static boolean checkBuyerInfo(Map<String, Object> bill) {
        return StringUtils.isNotBlank((Object)bill.get("buyertaxno")) && StringUtils.isNotBlank((Object)bill.get("buyername")) && StringUtils.isNotBlank((Object)bill.get("buyeraddr")) && StringUtils.isNotBlank((Object)bill.get("buyerbank"));
    }

    public static boolean checkOpenTitleMapping(Long org) {
        DynamicObject invTitleSetting = InvTitleSettingHelper.getInvTitleSetting((Long)org);
        return invTitleSetting != null && invTitleSetting.getBoolean(InvTitleSettingHelper.InvTitleMappingEnum.TIT_MAPP_BILL_IMPORT.getCode());
    }

    public static void setAsstactInfo(List<BillVo> bills, boolean isOpenTitleMapping) {
        if (!isOpenTitleMapping) {
            LOG.info("InvTitleMatchHelper setAsstactInfo isOpenTitleMapping is false");
            return;
        }
        for (BillVo bill : bills) {
            String asstactType = bill.getAsstactType();
            String asstact = bill.getAsstact();
            if (StringUtils.isBlank((CharSequence)asstactType) || StringUtils.isBlank((CharSequence)asstact)) continue;
            InvTitleMatchHelper.getAsstactInfo(bill);
        }
    }

    private static void getAsstactInfo(BillVo bill) {
        AsstactTypeEnum asstact = AsstactTypeEnum.getByCode((String)bill.getAsstactType());
        LOG.info(String.format("InvTitleMatchHelper getAsstactInfo bill:%s", SerializationUtils.toJsonString((Object)bill)));
        if (null == asstact) {
            return;
        }
        String number = bill.getAsstact();
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        qFilter.and("enable", "=", (Object)"1");
        Long orgId = bill.getOrgId();
        DynamicObject dynamicObject = null;
        switch (asstact) {
            case CUSTOMERS: {
                QFilter customer = BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)orgId);
                dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_customer", (String)"name", (QFilter[])qFilter.and(customer).toArray());
                break;
            }
            case SUPPLIER: {
                QFilter customer = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)orgId);
                dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)"name", (QFilter[])qFilter.and(customer).toArray());
            }
        }
        if (dynamicObject != null && StringUtils.isBlank((CharSequence)bill.getBuyerName())) {
            bill.setBuyerName(dynamicObject.getString("name"));
        }
    }
}

