/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.dto.BillDetailVo;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.model.GoodsInfo;
import kd.imc.bdm.common.service.OpenInvoiceService;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.MaterialInfoUtil;
import kd.imc.sim.common.dto.GoodsInfoQueryDTO;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.formplugin.match.ConditionMatchHelper;
import org.apache.commons.collections4.CollectionUtils;

public class MaterialToGoodsInfoHelp {
    private static final Log LOGGER = LogFactory.getLog(MaterialToGoodsInfoHelp.class);
    private static final int MAX_SIZE = 1000;
    public static final String GOODSINFO_COMPLETION = "GOODSINFO_COMPLETION";
    public static final String CALCULATION_UNIT_CONVERSION_RATE = "calculation_unit_conversion_rate";

    @Deprecated
    public static void instanceMaterialInfoUtilByBillList(List<BillVo> bills, long orgId, boolean isBotp) {
        HashSet codeSet = Sets.newHashSet();
        HashSet nameSet = Sets.newHashSet();
        HashSet materialTypeSet = Sets.newHashSet();
        for (BillVo bill : bills) {
            for (BillDetailVo detailVo : bill.getBillDetail()) {
                String goodsCode = detailVo.getGoodsCode();
                String goodsName = detailVo.getGoodsName();
                String materialType = detailVo.getMaterialType();
                if (StringUtils.isNotBlank((CharSequence)goodsCode)) {
                    codeSet.add(goodsCode);
                }
                if (StringUtils.isNotBlank((CharSequence)goodsName)) {
                    nameSet.add(goodsName);
                }
                if (!StringUtils.isNotBlank((CharSequence)materialType)) continue;
                materialTypeSet.add(materialType);
            }
        }
        MaterialInfoUtil.getInstance((long)orgId, (Set)nameSet, (Set)codeSet, (Set)materialTypeSet, (boolean)isBotp);
    }

    public static Map<String, DynamicObject> loadPushGoodsInfoData(long orgId, List<BillVo> bills) {
        List<DynamicObject> goodsInfoList = MaterialToGoodsInfoHelp.loadBatchesGoodsInfo(orgId, bills);
        HashMap goodsInfoMap = Maps.newHashMapWithExpectedSize((int)goodsInfoList.size());
        for (DynamicObject goodsInfo : goodsInfoList) {
            DynamicObjectCollection items = goodsInfo.getDynamicObjectCollection("bdm_goods_info_item");
            for (DynamicObject item : items) {
                String sourceType = StringUtils.isBlank((CharSequence)item.getString("sourcetype")) ? GoodsInfoConstant.SourceTypeEnum.MATERIAL.getCode() : item.getString("sourcetype");
                GoodsInfoConstant.SourceTypeEnum sourceTypeEnum = GoodsInfoConstant.SourceTypeEnum.getValueByCode((String)sourceType);
                switch (sourceTypeEnum) {
                    case MATERIAL: {
                        String materialNo = item.getString("material_no".concat(".number"));
                        String materialName = item.getString("material_name");
                        String materialModelNum = item.getString("material_modelnum");
                        goodsInfoMap.put(sourceType + '&' + materialNo, goodsInfo);
                        goodsInfoMap.put(sourceType + '&' + materialName, goodsInfo);
                        goodsInfoMap.put(sourceType + '&' + materialNo + '&' + materialName, goodsInfo);
                        goodsInfoMap.put(sourceType + '&' + materialNo + '&' + materialName + '&' + materialModelNum, goodsInfo);
                        break;
                    }
                    case MATERIAL_TYPE: {
                        String materialTypeNumber = item.getString("materialtype".concat(".number"));
                        String materialTypeName = item.getString("materialtype".concat(".name"));
                        goodsInfoMap.put(sourceType + '&' + materialTypeNumber, goodsInfo);
                        goodsInfoMap.put(sourceType + '&' + materialTypeName, goodsInfo);
                        goodsInfoMap.put(sourceType + '&' + materialTypeNumber + '&' + materialTypeName, goodsInfo);
                        break;
                    }
                    case GOODS_NAME: {
                        String modelCode;
                        String materialName = item.getString("material_name");
                        String materialModelNum = item.getString("material_modelnum");
                        goodsInfoMap.put(sourceType + '&' + materialName + '&' + item.getString("material_modelnum"), goodsInfo);
                        if (StringUtils.isNotBlank((CharSequence)materialModelNum)) {
                            goodsInfoMap.put(sourceType + '&' + materialName + '&' + materialModelNum, goodsInfo);
                        }
                        if (!StringUtils.isNotBlank((CharSequence)(modelCode = item.getString("modelnum_code")))) break;
                        goodsInfoMap.put(sourceType + '&' + modelCode, goodsInfo);
                        break;
                    }
                    case EXPENSE_ITEM: {
                        String expenseItemNumber = item.getString("expenseitem".concat(".number"));
                        String expenseItemName = item.getString("expenseitem".concat(".name"));
                        goodsInfoMap.put(sourceType + '&' + expenseItemNumber + '&' + expenseItemName, goodsInfo);
                    }
                }
            }
        }
        return goodsInfoMap;
    }

    private static List<DynamicObject> loadBatchesGoodsInfo(Long org, List<BillVo> bills) {
        HashSet nameSet = Sets.newHashSet();
        HashSet codeSet = Sets.newHashSet();
        HashSet materialTypeSet = Sets.newHashSet();
        for (BillVo bill : bills) {
            for (BillDetailVo detailVo : bill.getBillDetail()) {
                String goodsCode = detailVo.getGoodsCode();
                String goodsName = detailVo.getGoodsName();
                String materialType = detailVo.getMaterialType();
                if (StringUtils.isNotBlank((CharSequence)goodsCode)) {
                    codeSet.add(goodsCode);
                }
                if (StringUtils.isNotBlank((CharSequence)goodsName)) {
                    nameSet.add(goodsName);
                }
                if (!StringUtils.isNotBlank((CharSequence)materialType)) continue;
                materialTypeSet.add(materialType);
            }
        }
        ArrayList goodsInfoBatchesList = Lists.newArrayListWithCapacity((int)nameSet.size());
        String pushMatchRules = bills.get(0).getPushMatchRules();
        GoodsInfoConstant.PushMatchRulesEnum valueByCode = GoodsInfoConstant.PushMatchRulesEnum.getValueByCode((String)pushMatchRules);
        switch (valueByCode) {
            case DEFAULT_MATERIAL: {
                goodsInfoBatchesList.addAll(MaterialToGoodsInfoHelp.loadGoodsInfo(nameSet, "bdm_goods_info_item.material_name", org));
                goodsInfoBatchesList.addAll(MaterialToGoodsInfoHelp.loadGoodsInfo(codeSet, "bdm_goods_info_item.material_no.number", org));
                break;
            }
            case MATERIAL_TYPE: {
                goodsInfoBatchesList.addAll(MaterialToGoodsInfoHelp.loadGoodsInfo(materialTypeSet, "bdm_goods_info_item.materialtype.name", org));
                break;
            }
            case GOODS_NAME: {
                if (!codeSet.isEmpty()) {
                    goodsInfoBatchesList.addAll(MaterialToGoodsInfoHelp.loadGoodsInfo(codeSet, "bdm_goods_info_item.modelnum_code", org));
                }
                goodsInfoBatchesList.addAll(MaterialToGoodsInfoHelp.loadGoodsInfo(nameSet, "bdm_goods_info_item.material_name", org));
                break;
            }
            case EXPENSE_ITEM: {
                goodsInfoBatchesList.addAll(MaterialToGoodsInfoHelp.loadGoodsInfo(codeSet, "bdm_goods_info_item.expenseitem.number", org));
            }
        }
        return goodsInfoBatchesList;
    }

    private static List<DynamicObject> loadGoodsInfo(Set<String> fieldSet, String property, long org) {
        QFilter orgFilter = ImcBaseDataHelper.getGoodsInfoFilter((Object)org);
        ArrayList goodsInfoBatchesList = Lists.newArrayListWithCapacity((int)fieldSet.size());
        ArrayList codeList = Lists.newArrayList(fieldSet);
        for (int begin = 0; begin < fieldSet.size(); begin = 1000 + begin) {
            int end = begin + 1000 > fieldSet.size() ? fieldSet.size() : begin + 1000;
            List tempList = codeList.subList(begin, end);
            QFilter tempFilter = new QFilter(property, "in", tempList);
            goodsInfoBatchesList.addAll(Lists.newArrayList((Object[])BusinessDataServiceHelper.load((String)"bdm_goods_info", (String)GoodsInfoConstant.SELECT_PROPERTIES, (QFilter[])new QFilter[]{orgFilter, tempFilter}, (String)"ctrlstrategy ,priority desc")));
        }
        return goodsInfoBatchesList;
    }

    public static boolean getLoadTag(List<BillVo> bills) {
        for (BillVo bill : bills) {
            if (GoodsInfoConstant.PushMatchRulesEnum.SOURCE_MATERIAL_NAME.getCode().equals(bill.getPushMatchRules())) continue;
            return true;
        }
        return false;
    }

    public static DynamicObject getMappingGoodsInfo(BillDetailVo detail, String matchRules, Map<String, DynamicObject> goodsInfoMap) {
        GoodsInfoConstant.PushMatchRulesEnum pushMatchRulesEnum = GoodsInfoConstant.PushMatchRulesEnum.getValueByCode((String)matchRules);
        StringBuilder key = new StringBuilder(pushMatchRulesEnum.getSourceType());
        switch (pushMatchRulesEnum) {
            case DEFAULT_MATERIAL: {
                if (StringUtils.isNotBlank((CharSequence)detail.getGoodsCode())) {
                    key.append('&').append(detail.getGoodsCode());
                }
                if (!StringUtils.isNotBlank((CharSequence)detail.getGoodsName())) break;
                key.append('&').append(detail.getGoodsName());
                break;
            }
            case MATERIAL_TYPE: {
                key.append('&').append(detail.getMaterialType());
                break;
            }
            case GOODS_NAME: {
                if (StringUtils.isNotBlank((CharSequence)detail.getGoodsCode())) {
                    StringBuilder modelCodeBuilder = new StringBuilder(pushMatchRulesEnum.getSourceType());
                    modelCodeBuilder.append('&').append(detail.getGoodsCode());
                    if (goodsInfoMap.get(modelCodeBuilder.toString()) != null) {
                        return goodsInfoMap.get(modelCodeBuilder.toString());
                    }
                }
                key.append('&').append(detail.getGoodsName()).append('&').append(detail.getSpecification());
                break;
            }
            case SOURCE_MATERIAL_NAME: {
                return null;
            }
            case EXPENSE_ITEM: {
                key.append('&').append(detail.getGoodsCode()).append('&').append(detail.getGoodsName());
            }
        }
        return goodsInfoMap.get(key.toString());
    }

    public static void intiQuerySet(Set<String> codeSet, Set<String> nameSet, Set<String> materialTypeSet, List<Map<String, Object>> items) {
        for (Map<String, Object> item : items) {
            if ("0".equals(item.get("rowtype"))) continue;
            Object goodsCode = item.get("spbm");
            Object goodsName = item.get("goodsname");
            Object materialType = item.get("materialtype");
            if (StringUtils.isNotBlank((Object)goodsCode)) {
                codeSet.add(goodsCode.toString());
            }
            if (StringUtils.isNotBlank((Object)goodsName)) {
                nameSet.add(goodsName.toString());
            }
            if (!StringUtils.isNotBlank((Object)materialType)) continue;
            materialTypeSet.add(materialType.toString());
        }
    }

    public static void fillInGoodsInfo(BillDetailVo detailVo, Map<String, DynamicObject> goodsNameMap, Map<String, DynamicObject> goodsCodeMap, boolean completion, boolean isCompletionPolicylogo) {
        MaterialToGoodsInfoHelp.fillInGoodsInfo(detailVo, goodsNameMap, goodsCodeMap, completion, isCompletionPolicylogo, true, false, null);
    }

    public static void fillInGoodsInfo(BillDetailVo detailVo, Map<String, DynamicObject> goodsNameMap, Map<String, DynamicObject> goodsCodeMap, boolean completion, boolean isCompletionPolicylogo, boolean isUseGodsSpecAndUnit, boolean isUseFilter, DynamicObject bill) {
        String filterStr;
        String goodsCode = detailVo.getGoodsCode();
        String goodsName = detailVo.getGoodsName();
        DynamicObject obj = goodsCodeMap.get(goodsCode);
        if (obj == null) {
            obj = goodsNameMap.get(goodsName);
        }
        if (obj == null) {
            return;
        }
        if (isUseFilter && StringUtils.isNotBlank((CharSequence)(filterStr = obj.getString("filter_tag"))) && !ConditionMatchHelper.verify(filterStr, bill)) {
            return;
        }
        MaterialToGoodsInfoHelp.setGoodsOriInfo(detailVo);
        detailVo.setGoodsName(obj.getString("name"));
        detailVo.setGoodsCode(obj.getString("number"));
        if (StringUtils.isBlank((CharSequence)detailVo.getTaxRate())) {
            detailVo.setTaxRate(obj.getString("taxrate"));
        }
        detailVo.setGoodsId(Long.valueOf(String.valueOf(obj.get("id"))));
        boolean isNormal = "2".equals(detailVo.getLineProperty() + "");
        detailVo.setTaxCodeId(Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("taxcode"))));
        if (completion) {
            if (StringUtils.isBlank((CharSequence)detailVo.getSpecification()) && isNormal) {
                detailVo.setSpecification(obj.getString("specifications"));
            }
            if (StringUtils.isBlank((CharSequence)detailVo.getUnits()) && isNormal) {
                detailVo.setUnits(obj.getString("unit"));
            }
            if (StringUtils.isBlank((CharSequence)detailVo.getRevenueCode())) {
                detailVo.setRevenueCode(obj.getString("taxcode".concat(".").concat("mergecode")));
            }
            if (isCompletionPolicylogo) {
                if (detailVo.getPrivilegeFlag() == null) {
                    String privilegeFlag = obj.getString("privilegeflag");
                    if (StringUtils.isNotBlank((CharSequence)privilegeFlag)) {
                        detailVo.setPrivilegeFlag(Integer.valueOf(privilegeFlag));
                    } else {
                        detailVo.setPrivilegeFlag(Integer.valueOf("0"));
                    }
                }
                if ("1".equals(detailVo.getPrivilegeFlag().toString()) && StringUtils.isBlank((CharSequence)detailVo.getPrivilegeContent())) {
                    detailVo.setPrivilegeContent(obj.getString("privilegetype"));
                }
            }
            return;
        }
        detailVo.setRevenueCode(obj.getString("taxcode".concat(".").concat("mergecode")));
        if (isUseGodsSpecAndUnit && isNormal) {
            detailVo.setSpecification(obj.getString("specifications"));
            detailVo.setUnits(obj.getString("unit"));
        }
        detailVo.setPrivilegeFlag(Integer.valueOf(Integer.parseInt(obj.getString("privilegeflag"))));
        detailVo.setPrivilegeContent(obj.getString("privilegetype"));
    }

    private static void setGoodsOriInfo(BillDetailVo detailVo) {
        detailVo.setOriGoodsName(detailVo.getGoodsName());
        detailVo.setOriSpecification(detailVo.getSpecification());
        detailVo.setOriUnit(detailVo.getUnits());
        detailVo.setOriNum(detailVo.getQuantity());
    }

    public static void setDetail(BillDetailVo detail, DynamicObject goodsInfo, String fillValueRule) {
        detail.setOriUnit(detail.getUnits());
        detail.setOriGoodsName(detail.getGoodsName());
        detail.setOriGoodsCode(detail.getGoodsCode());
        MaterialToGoodsInfoHelp.setGoodsName(detail, goodsInfo, fillValueRule);
        DynamicObject taxClassCode = goodsInfo.getDynamicObject("taxcode");
        if (Objects.isNull(taxClassCode)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7a0e\u5206\u7f16\u7801\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5f00\u7968\u9879\uff1a%s", (String)"MaterialToGoodsInfoHelp_0", (String)"imc-sim-service", (Object[])new Object[0]), goodsInfo.getString("number")));
        }
        String number = taxClassCode.getString("mergecode");
        DynamicObject taxClassCodeByNumber = TaxClassCodeCheckHelper.geTaxCode((String)number);
        if (StringUtils.isBlank((CharSequence)fillValueRule)) {
            detail.setSpecification(goodsInfo.getString("specifications"));
            detail.setUnits(goodsInfo.getString("unit"));
            String privilegeFlag = goodsInfo.getString("privilegeflag");
            if (StringUtils.isBlank((CharSequence)privilegeFlag)) {
                detail.setPrivilegeFlag(Integer.valueOf(0));
            } else {
                detail.setPrivilegeFlag(Integer.valueOf(Integer.parseInt(privilegeFlag)));
            }
            detail.setPrivilegeContent(goodsInfo.getString("privilegetype"));
            if (StringUtils.isBlank((CharSequence)detail.getTaxRate())) {
                detail.setTaxRate(goodsInfo.getString("taxrate"));
            }
        }
        if (null == taxClassCodeByNumber) {
            detail.setTaxCodeId(Long.valueOf(goodsInfo.getDynamicObject("taxcode").getLong("id")));
        } else {
            detail.setTaxCodeId(Long.valueOf(taxClassCodeByNumber.getLong("id")));
        }
        detail.setGoodsCode(goodsInfo.getString("number"));
        detail.setRevenueCode(goodsInfo.getDynamicObject("taxcode").getString("mergecode"));
        detail.setGoodsId(Long.valueOf(String.valueOf(goodsInfo.get("id"))));
    }

    private static void setGoodsName(BillDetailVo detail, DynamicObject goodsInfo, String fillValueRule) {
        String goodsName = StringUtils.isNotBlank((CharSequence)fillValueRule) ? MaterialToGoodsInfoHelp.getGoodNameByField(detail, fillValueRule) : goodsInfo.getString("name");
        detail.setGoodsName(goodsName);
    }

    private static String getGoodNameByField(BillDetailVo detail, String field) {
        try {
            String s = "get" + MaterialToGoodsInfoHelp.captureName(field);
            Class<?> clazz = detail.getClass();
            Method getMethod = clazz.getMethod(s, new Class[0]);
            return getMethod.invoke((Object)detail, new Object[0]).toString();
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u539f\u5355\u6570\u636e\u5931\u8d25,\u8bf7\u6b63\u786e\u586b\u5199\u53d6\u503c\u89c4\u5219", (String)"MaterialToGoodsInfoHelp_1", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }

    private static String captureName(String field) {
        char[] cs = field.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    @Deprecated
    public static DynamicObject getGoodInfoByMaterial(BillVo bill, String code, String name, Long org) {
        DynamicObject goodByMaterial = MaterialToGoodsInfoHelp.getGoodByGoodName(bill, code, name);
        if (null == goodByMaterial) {
            goodByMaterial = MaterialToGoodsInfoHelp.getGoodByMaterial(bill, code, name);
        }
        if (null == goodByMaterial) {
            goodByMaterial = MaterialToGoodsInfoHelp.getGoodByType(bill, code, name);
        }
        if (null == goodByMaterial) {
            // empty if block
        }
        return goodByMaterial;
    }

    public static DynamicObject getGoodByGoodName(BillVo bill, String code, String name) {
        Set goodsByMaterSet = MaterialInfoUtil.getGoodsByMater((String)code, (String)name);
        List<DynamicObject> goodsByMaterList = MaterialToGoodsInfoHelp.sortedGoodsInfo(goodsByMaterSet);
        ArrayList objects = Lists.newArrayListWithExpectedSize((int)goodsByMaterList.size());
        block0: for (DynamicObject dynamicObject : goodsByMaterList) {
            DynamicObjectCollection infoItem = dynamicObject.getDynamicObjectCollection("bdm_goods_info_item");
            for (DynamicObject item : infoItem) {
                if (!item.getString("sourcetype").equals("2") || !item.getString("material_name").equals(name)) continue;
                objects.add(dynamicObject);
                continue block0;
            }
        }
        return MaterialToGoodsInfoHelp.getDynamicObject(bill, objects);
    }

    private static DynamicObject getDynamicObject(Object billObj, List<DynamicObject> goodsByMaterList) {
        DynamicObject bill;
        if (billObj instanceof DynamicObject) {
            bill = (DynamicObject)billObj;
        } else {
            bill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
            DynamicObjectUtil.bean2DynamicObject((Object)billObj, (DynamicObject)bill);
        }
        for (DynamicObject good : goodsByMaterList) {
            String filterStr = good.getString("filter_tag");
            if (!ConditionMatchHelper.verify(filterStr, bill)) continue;
            LOGGER.info(String.format("\u5f00\u7968\u9879\u5df2\u5339\u914d\u5230\uff0c\u7b56\u7565id\u4e3a[%s]\uff0c\u7b56\u7565\u6761\u4ef6\u4e3a[%s]", good.getPkValue(), filterStr));
            return good;
        }
        return null;
    }

    public static DynamicObject getGoodByMaterial(Object bill, String code, String name) {
        Set goodsByMaterSet = MaterialInfoUtil.getGoodsByMater((String)code, (String)name);
        List<DynamicObject> goodsByMaterList = MaterialToGoodsInfoHelp.sortedGoodsInfo(goodsByMaterSet);
        ArrayList objects = Lists.newArrayListWithExpectedSize((int)goodsByMaterList.size());
        block0: for (DynamicObject goodsInfo : goodsByMaterList) {
            DynamicObjectCollection infoItem = goodsInfo.getDynamicObjectCollection("bdm_goods_info_item");
            for (DynamicObject item : infoItem) {
                boolean isMaterial = item.getString("sourcetype").equals("0") || StringUtils.isBlank((CharSequence)item.getString("sourcetype"));
                if (!isMaterial || !item.getString("material_no".concat(".number")).equals(code) && !item.getString("material_no".concat(".name")).equals(name)) continue;
                objects.add(goodsInfo);
                continue block0;
            }
        }
        return MaterialToGoodsInfoHelp.getDynamicObject(bill, objects);
    }

    public static DynamicObject getGoodByExpenseItem(Object bill, String number, String name) {
        LOGGER.info(String.format("MaterialToGoodsInfoHelp getGoodByExpenseItem bill:%s code:%s name:%s", SerializationUtils.toJsonString((Object)bill), number, name));
        if (StringUtils.isBlank((CharSequence)number) || StringUtils.isBlank((CharSequence)name)) {
            LOGGER.info("getGoodByExpenseItem \u8d39\u7528\u9879\u76ee\u540d\u79f0\u6216\u8005\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u5339\u914d");
            return null;
        }
        Set goodsByMaterSet = MaterialInfoUtil.getGoodsByExpenseItem((String)number, (String)name);
        return MaterialToGoodsInfoHelp.getDynamicObject(bill, Lists.newArrayList((Iterable)goodsByMaterSet));
    }

    public static DynamicObject getGoodByType(Object bill, String code, String type) {
        Set goodsByMaterSet = MaterialInfoUtil.getGoodsByMaterType((String)code, (String)type);
        if (CollectionUtils.isEmpty((Collection)goodsByMaterSet)) {
            return null;
        }
        List<DynamicObject> goodsByMaterList = MaterialToGoodsInfoHelp.sortedGoodsInfo(goodsByMaterSet);
        return MaterialToGoodsInfoHelp.getDynamicObject(bill, goodsByMaterList);
    }

    public static DynamicObject getGoodByMaterialNotFilter(String code, String name) {
        Set goodsByMaterSet = MaterialInfoUtil.getGoodsByMater((String)code, (String)name);
        List<DynamicObject> goodsByMaterList = MaterialToGoodsInfoHelp.sortedGoodsInfo(goodsByMaterSet);
        for (DynamicObject dynamicObject : goodsByMaterList) {
            DynamicObjectCollection infoItem = dynamicObject.getDynamicObjectCollection("bdm_goods_info_item");
            for (DynamicObject item : infoItem) {
                if (!item.getString("sourcetype").equals("0") || !item.getString("material_no".concat(".number")).equals(code) && !item.getString("material_no".concat(".name")).equals(name)) continue;
                return dynamicObject;
            }
        }
        return null;
    }

    private static List<DynamicObject> sortedGoodsInfo(Set<DynamicObject> goodsByMaterSet) {
        return goodsByMaterSet.stream().sorted(Comparator.comparing(o -> o.getInt("priority"))).sorted(Comparator.comparing(o -> o.getString("ctrlstrategy"), Comparator.reverseOrder())).collect(Collectors.toList());
    }

    public static DynamicObject getGoodByNameNotFilter(String code, String name) {
        Set goodsByMaterSet = MaterialInfoUtil.getGoodsByMater((String)code, (String)name);
        List<DynamicObject> goodsByMaterList = MaterialToGoodsInfoHelp.sortedGoodsInfo(goodsByMaterSet);
        for (DynamicObject dynamicObject : goodsByMaterList) {
            DynamicObjectCollection infoItem = dynamicObject.getDynamicObjectCollection("bdm_goods_info_item");
            for (DynamicObject item : infoItem) {
                if (!item.getString("sourcetype").equals("2") || !item.getString("modelnum_code").equals(code) && !item.getString("material_name").equals(name)) continue;
                return dynamicObject;
            }
        }
        return null;
    }

    public static DynamicObject getGoodByTypeNotFilter(String code, String type) {
        Set goodsByMaterSet = MaterialInfoUtil.getGoodsByMaterType((String)code, (String)type);
        if (CollectionUtils.isEmpty((Collection)goodsByMaterSet)) {
            return null;
        }
        List<DynamicObject> goodsByMaterList = MaterialToGoodsInfoHelp.sortedGoodsInfo(goodsByMaterSet);
        return goodsByMaterList.get(0);
    }

    public static Map<String, DynamicObject> initMaterialTypeName(Set<GoodsInfoQueryDTO> dtos) {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        QFilter qFilter = null;
        for (GoodsInfoQueryDTO dto : dtos) {
            if (null == qFilter) {
                qFilter = new QFilter("number", "=", (Object)dto.getCode());
                qFilter.and("name", "=", (Object)dto.getName());
                continue;
            }
            QFilter qFilter1 = new QFilter("number", "=", (Object)dto.getCode());
            qFilter1.and("name", "=", (Object)dto.getName());
            qFilter.or(qFilter1);
        }
        filter.and(qFilter);
        DynamicObject[] materialsDO = BusinessDataServiceHelper.load((String)"bd_material", (String)"number,name,group", (QFilter[])filter.toArray());
        HashMap<String, DynamicObject> materialType = new HashMap<String, DynamicObject>(materialsDO.length);
        for (DynamicObject material : materialsDO) {
            String number = material.getString("number");
            String name = material.getString("name");
            materialType.put(name + ':' + number, material);
        }
        return materialType;
    }

    public static DynamicObject getGoodByExpenseItemNotFilter(String number, String name) {
        LOGGER.info(String.format("MaterialToGoodsInfoHelp getGoodByExpenseItemNotFilter number:%s ,name:%s", number, name));
        Set goodsInfos = MaterialInfoUtil.getGoodsByExpenseItem((String)number, (String)name);
        if (CollectionUtils.isNotEmpty((Collection)goodsInfos)) {
            List<DynamicObject> goodsByMaterList = MaterialToGoodsInfoHelp.sortedGoodsInfo(goodsInfos);
            return goodsByMaterList.get(0);
        }
        LOGGER.info(String.format("ExpenseItem Mapping is null number:%s ,name:%s", number, name));
        return null;
    }

    public static boolean getCompletion(long orgId) {
        Map<String, Object> goodsInfoCompletion = MaterialToGoodsInfoHelp.getGoodsInfoCompletion(orgId);
        return (Boolean)goodsInfoCompletion.get("completion");
    }

    public static boolean getCompletionPolicylogo(long orgId) {
        Map<String, Object> goodsInfoCompletion = MaterialToGoodsInfoHelp.getGoodsInfoCompletion(orgId);
        return (Boolean)goodsInfoCompletion.get("completion_policylogo");
    }

    private static Map<String, Object> getGoodsInfoCompletion(long orgId) {
        String goodsInfoCompletionStr = CacheHelper.get((String)(GOODSINFO_COMPLETION + orgId));
        if (StringUtils.isNotBlank((CharSequence)goodsInfoCompletionStr)) {
            return (Map)SerializationUtils.fromJsonString((String)goodsInfoCompletionStr, Map.class);
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_inv_item_setting", (String)String.join((CharSequence)",", "completion", "completion_policylogo"), (QFilter[])new QFilter("org", "=", (Object)orgId).toArray());
        Map<String, Object> goodsInfoCompletionMap = new HashMap<String, Boolean>(4);
        if (null == dynamicObject) {
            goodsInfoCompletionMap.put("completion", Boolean.FALSE);
            goodsInfoCompletionMap.put("completion_policylogo", Boolean.FALSE);
        } else {
            goodsInfoCompletionMap = DynamicObjectUtil.dynamicObject2Map((DynamicObject)dynamicObject);
        }
        CacheHelper.put((String)(GOODSINFO_COMPLETION + orgId), (String)SerializationUtils.toJsonString(goodsInfoCompletionMap));
        return goodsInfoCompletionMap;
    }

    public static void setGoodsInfoByInstitute(Map<String, Object> detail, Map<String, String> goodsCodeMap) {
        if (StringUtils.isNotBlank((Object)detail.get("goodscode"))) {
            return;
        }
        OpenInvoiceService service = new OpenInvoiceService();
        List goodsList = service.queryGoodsInfoByFpy((String)detail.get("goodsname"));
        LOGGER.info(String.format("MaterialToGoodsInfoHelp setGoodsInfoByInstitute goodsList:%s", SerializationUtils.toJsonString((Object)goodsList)));
        if (CollectionUtils.isEmpty((Collection)goodsList)) {
            return;
        }
        GoodsInfo goodsInfo = (GoodsInfo)goodsList.get(0);
        String goodsCode = goodsInfo.getGoodsCode();
        detail.put("goodscode", goodsCode);
        goodsCodeMap.put((String)detail.get("goodsname"), goodsCode);
    }

    private static void setDetail(Map<String, Object> detail, DynamicObject goodByMaterial) {
        detail.put("spbm", goodByMaterial.get("number"));
        detail.put("goodsname", goodByMaterial.getString("name"));
        detail.put("specification", goodByMaterial.get("specifications"));
        detail.put("goodscode", goodByMaterial.getDynamicObject("taxcode").getString("mergecode"));
        detail.put("unit", goodByMaterial.get("unit"));
        Object taxRate = detail.get("taxrate");
        if (StringUtils.isBlank((Object)taxRate)) {
            detail.put("taxrate", goodByMaterial.get("taxrate"));
        }
        detail.put("policylogo", goodByMaterial.get("privilegeflag"));
        detail.put("policycontants", goodByMaterial.get("privilegetype"));
        detail.put("goodsid", goodByMaterial.get("id"));
    }

    public static void matchGoodsInfoJournal(Map<String, Object> detail, String spbm, String goodsName) {
        DynamicObject goodByMaterial = MaterialToGoodsInfoHelp.getGoodByNameNotFilter(StringUtils.isNotBlank((CharSequence)spbm) ? spbm : null, StringUtils.isNotBlank((CharSequence)goodsName) ? goodsName : null);
        if (null == goodByMaterial) {
            goodByMaterial = MaterialToGoodsInfoHelp.getGoodByMaterialNotFilter(StringUtils.isNotBlank((CharSequence)spbm) ? spbm : null, StringUtils.isNotBlank((CharSequence)goodsName) ? goodsName : null);
        }
        if (null == goodByMaterial) {
            goodByMaterial = MaterialToGoodsInfoHelp.getGoodByTypeNotFilter(StringUtils.isNotBlank((CharSequence)spbm) ? spbm : null, StringUtils.isNotBlank((CharSequence)goodsName) ? goodsName : null);
        }
        if (null == goodByMaterial) {
            goodByMaterial = MaterialToGoodsInfoHelp.getGoodByExpenseItemNotFilter(StringUtils.isNotBlank((CharSequence)spbm) ? spbm : null, StringUtils.isNotBlank((CharSequence)goodsName) ? goodsName : null);
        }
        if (null != goodByMaterial) {
            MaterialToGoodsInfoHelp.setDetail(detail, goodByMaterial);
        }
    }

    public static BigDecimal gerOriNum(BigDecimal conversionRate, BigDecimal newNum) {
        if (null == newNum || BigDecimalUtil.compareZero((BigDecimal)newNum)) {
            return newNum;
        }
        if (null == conversionRate || BigDecimalUtil.compareZero((BigDecimal)conversionRate)) {
            return newNum;
        }
        return UnitPriceHelper.calcNum((BigDecimal)newNum, (BigDecimal)conversionRate);
    }
}

