/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.dto.BillDetailVo;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.dto.GoodsInfoItemVo;
import kd.imc.bdm.common.dto.GoodsInfoVo;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.MaterialInfoUtil2;
import kd.imc.sim.common.dto.goodsinfo.UnitConversionConfig;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.formplugin.match.ConditionMatchHelper;
import org.apache.commons.collections4.CollectionUtils;

public class MaterialToGoodsInfoHelp2 {
    private static final Log LOGGER = LogFactory.getLog(MaterialToGoodsInfoHelp2.class);
    public static final String CALCULATION_UNIT_CONVERSION_RATE = "calculation_unit_conversion_rate";

    public static void instanceMaterialInfoUtilByBillList2(List<BillVo> bills, long orgId, boolean isBotp) {
        HashSet codeSet = Sets.newHashSet();
        HashSet nameSet = Sets.newHashSet();
        HashSet materialTypeSet = Sets.newHashSet();
        for (BillVo bill : bills) {
            for (BillDetailVo detailVo : bill.getBillDetail()) {
                String goodsCode = detailVo.getGoodsCode();
                String goodsName = detailVo.getGoodsName();
                String materialType = detailVo.getMaterialType();
                if (StringUtils.isNotBlank((CharSequence)goodsCode)) {
                    codeSet.add(goodsCode);
                }
                if (StringUtils.isNotBlank((CharSequence)goodsName)) {
                    nameSet.add(goodsName);
                }
                if (!StringUtils.isNotBlank((CharSequence)materialType)) continue;
                materialTypeSet.add(materialType);
            }
        }
        MaterialInfoUtil2.getInstance((long)orgId, (Set)nameSet, (Set)codeSet, (Set)materialTypeSet, (boolean)isBotp);
    }

    @Deprecated
    public static GoodsInfoVo getGoodInfoByMaterial(BillVo bill, String code, String name, Long org) {
        GoodsInfoVo goodByMaterial = MaterialToGoodsInfoHelp2.getGoodByGoodName(bill, code, name);
        if (null == goodByMaterial) {
            goodByMaterial = MaterialToGoodsInfoHelp2.getGoodByMaterial(bill, code, name);
        }
        if (null == goodByMaterial) {
            goodByMaterial = MaterialToGoodsInfoHelp2.getGoodByType(bill, code, name);
        }
        if (null == goodByMaterial) {
            // empty if block
        }
        return goodByMaterial;
    }

    public static GoodsInfoVo getGoodByGoodName(BillVo bill, String code, String name) {
        Set goodsByMaterSet = MaterialInfoUtil2.getGoodsByMater((String)code, (String)name);
        List<GoodsInfoVo> goodsByMaterList = MaterialToGoodsInfoHelp2.sortedGoodsInfo(goodsByMaterSet);
        ArrayList objects = Lists.newArrayListWithExpectedSize((int)goodsByMaterList.size());
        block0: for (GoodsInfoVo goodsInfoVo : goodsByMaterList) {
            List usedItems = goodsInfoVo.getUsedItems();
            for (GoodsInfoItemVo item : usedItems) {
                if (!item.getSourcetype().equals("2") || !item.getMaterialName().equals(name)) continue;
                objects.add(goodsInfoVo);
                continue block0;
            }
        }
        return MaterialToGoodsInfoHelp2.getDynamicObject(bill, objects);
    }

    private static GoodsInfoVo getDynamicObject(Object billObj, List<GoodsInfoVo> goodsByMaterList) {
        DynamicObject bill;
        if (billObj instanceof DynamicObject) {
            bill = (DynamicObject)billObj;
        } else {
            bill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
            DynamicObjectUtil.bean2DynamicObject((Object)billObj, (DynamicObject)bill);
        }
        for (GoodsInfoVo good : goodsByMaterList) {
            String filterStr = good.getFilterTag();
            if (!ConditionMatchHelper.verify(filterStr, bill)) continue;
            return good;
        }
        return null;
    }

    public static GoodsInfoVo getGoodByMaterial(Object bill, String code, String name) {
        Set goodsByMaterSet = MaterialInfoUtil2.getGoodsByMater((String)code, (String)name);
        List<GoodsInfoVo> goodsByMaterList = MaterialToGoodsInfoHelp2.sortedGoodsInfo(goodsByMaterSet);
        ArrayList objects = Lists.newArrayListWithExpectedSize((int)goodsByMaterList.size());
        block0: for (GoodsInfoVo goodsInfo : goodsByMaterList) {
            List usedItems = goodsInfo.getUsedItems();
            for (GoodsInfoItemVo item : usedItems) {
                boolean isMaterial;
                boolean bl = isMaterial = item.getSourcetype().equals("0") || StringUtils.isBlank((CharSequence)item.getSourcetype());
                if ((!isMaterial || !item.getMaterial().getString("number").equals(code)) && !item.getMaterial().getString("name").equals(name)) continue;
                objects.add(goodsInfo);
                continue block0;
            }
        }
        return MaterialToGoodsInfoHelp2.getDynamicObject(bill, objects);
    }

    public static GoodsInfoVo getGoodByExpenseItem(Object bill, String number, String name) {
        LOGGER.info(String.format("MaterialToGoodsInfoHelp getGoodByExpenseItem bill:%s code:%s name:%s", SerializationUtils.toJsonString((Object)bill), number, name));
        if (StringUtils.isBlank((CharSequence)number) || StringUtils.isBlank((CharSequence)name)) {
            LOGGER.info("getGoodByExpenseItem \u8d39\u7528\u9879\u76ee\u540d\u79f0\u6216\u8005\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u5339\u914d");
            return null;
        }
        Set goodsByMaterSet = MaterialInfoUtil2.getGoodsByExpenseItem((String)number, (String)name);
        return MaterialToGoodsInfoHelp2.getDynamicObject(bill, Lists.newArrayList((Iterable)goodsByMaterSet));
    }

    public static GoodsInfoVo getGoodByType(Object bill, String code, String type) {
        Set goodsByMaterSet = MaterialInfoUtil2.getGoodsByMaterType((String)code, (String)type);
        if (CollectionUtils.isEmpty((Collection)goodsByMaterSet)) {
            return null;
        }
        List<GoodsInfoVo> goodsByMaterList = MaterialToGoodsInfoHelp2.sortedGoodsInfo(goodsByMaterSet);
        return MaterialToGoodsInfoHelp2.getDynamicObject(bill, goodsByMaterList);
    }

    private static List<GoodsInfoVo> sortedGoodsInfo(Set<GoodsInfoVo> goodsByMaterSet) {
        return goodsByMaterSet.stream().sorted(Comparator.comparing(GoodsInfoVo::getPriority)).sorted(Comparator.comparing(GoodsInfoVo::getCtrlstrategy, Comparator.reverseOrder())).collect(Collectors.toList());
    }

    public static void setUnitConversion(UnitConversionConfig unitConversionConfig, GoodsInfoVo goodByMaterial, DynamicObject billItem, boolean isAllEle) {
        StringBuilder description = unitConversionConfig.getBuilder();
        if (!unitConversionConfig.getUnitToGoodsInfo().booleanValue()) {
            description.append(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u6ca1\u6709\u53d6\u4e0b\u6e38", (String)"MaterialToGoodsInfoHelp_2", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        if (!"01".equals(unitConversionConfig.getMatchRulesType()) && !"00".equals(unitConversionConfig.getMatchRulesType())) {
            description.append(ResManager.loadKDString((String)"\u5355\u4f4d\u6362\u7b97\u975e\u7269\u6599\u5339\u914d\u6216\u8005\u4f18\u5148\u7ea7\u5339\u914d", (String)"MaterialToGoodsInfoHelp_3", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        String benchMark = billItem.getString("benchmark");
        if ("1".equals(benchMark)) {
            description.append(ResManager.loadKDString((String)"\u91d1\u989d\u57fa\u51c6\u4e0d\u5339\u914d", (String)"MaterialToGoodsInfoHelp_4", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        DynamicObject materielfield = billItem.getDynamicObject("materielfield");
        if (null == materielfield) {
            description.append(ResManager.loadKDString((String)"\u5355\u636e\u7684\u7269\u6599\u5b57\u6bb5\u4e3a\u7a7a", (String)"MaterialToGoodsInfoHelp_5", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        Object invoiceItemsCode = materielfield.getPkValue();
        List usedItems = goodByMaterial.getUsedItems();
        for (GoodsInfoItemVo item : usedItems) {
            if (!GoodsInfoConstant.SourceTypeEnum.MATERIAL.getCode().equals(item.getSourcetype())) continue;
            String billItemUnit = billItem.getString("oriunit");
            if (StringUtils.isBlank((CharSequence)billItemUnit) || null == item.getBaseUnit()) {
                description.append(ResManager.loadKDString((String)"\u5355\u636e\u7684\u539f\u59cb\u8ba1\u91cf\u5355\u4f4d\u5b57\u6bb5\u4e3a\u7a7a\u6216\u8005\u5f00\u7968\u9879\u76ee\u7684\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a;", (String)"MaterialToGoodsInfoHelp_6", (String)"imc-sim-service", (Object[])new Object[0]));
                continue;
            }
            DynamicObject material = item.getMaterial();
            if (!invoiceItemsCode.equals(material.getPkValue())) continue;
            if (!billItemUnit.equals(item.getBaseUnit().getLocaleString("name").getLocaleValue_zh_CN())) {
                description.append(ResManager.loadKDString((String)"\u5355\u636e\u7684\u539f\u59cb\u8ba1\u91cf\u5355\u4f4d\u540d\u79f0\u548c\u5f00\u7968\u9879\u7684\u8ba1\u91cf\u5355\u4f4d\u540d\u79f0\u4e0d\u7b49;", (String)"MaterialToGoodsInfoHelp_7", (String)"imc-sim-service", (Object[])new Object[0]));
                continue;
            }
            String modelnumRate = item.getModelnumRate();
            if (StringUtils.isEmpty((CharSequence)modelnumRate)) continue;
            billItem.set("unitfield", material.get("baseunit"));
            BigDecimal conversionRate = new BigDecimal(modelnumRate);
            description.append(ResManager.loadKDString((String)"\u51c6\u5907\u8fdb\u5165\u8ba1\u91cf\u5355\u4f4d\u8f6c\u6362;", (String)"MaterialToGoodsInfoHelp_8", (String)"imc-sim-service", (Object[])new Object[0]));
            MaterialToGoodsInfoHelp2.setInvoiceUintPrice(conversionRate, billItem, "", unitConversionConfig.getPrecision(), unitConversionConfig.getFromPricePrecision(), isAllEle);
        }
    }

    public static void setInvoiceUintPrice(BigDecimal conversionRate, DynamicObject billItem, String hsbz, int precision, int fromPricePrecision, boolean isAllEle) {
        if (StringUtils.isBlank((CharSequence)billItem.getString("num")) || StringUtils.isBlank((Object)conversionRate) || conversionRate.compareTo(BigDecimal.ONE) == 0) {
            LOGGER.info("\u6ca1\u6709\u6570\u91cf\uff0c\u4e0d\u6d89\u53ca\u8ba1\u7b97\u6362\u7b97\u7387 \u6362\u7b97\u7387\u4e3a1 \u4e0d\u8fdb\u884c\u53cd\u7b97");
            return;
        }
        BigDecimal num = billItem.getBigDecimal("num");
        if (BigDecimalUtil.compareZero((BigDecimal)num)) {
            return;
        }
        BigDecimal newNum = UnitPriceHelper.getNumValue((BigDecimal)num.multiply(conversionRate), (String)ResManager.loadKDString((String)"\u7ecf\u8fc7\u5355\u4f4d\u8f6c\u6362\u7387\u540e\u8ba1\u7b97\u7684\u6570\u91cf", (String)"MaterialToGoodsInfoHelp_9", (String)"imc-sim-service", (Object[])new Object[0]));
        String conversionConfig = ImcConfigUtil.getValue((String)CALCULATION_UNIT_CONVERSION_RATE, (String)CALCULATION_UNIT_CONVERSION_RATE);
        BigDecimal newTaxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)billItem.getBigDecimal("taxamount"), (BigDecimal)newNum, (boolean)isAllEle);
        BigDecimal newUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)billItem.getBigDecimal("amount"), (BigDecimal)newNum, (boolean)isAllEle);
        billItem.set("num", (Object)newNum);
        billItem.set("taxunitprice", (Object)newTaxUnitPrice);
        billItem.set("unitprice", (Object)newUnitPrice);
        BigDecimal newFromTaxPrice = billItem.getBigDecimal("fromtaxprice").divide(conversionRate, fromPricePrecision, 4);
        BigDecimal newFromPrice = billItem.getBigDecimal("fromprice").divide(conversionRate, fromPricePrecision, 4);
        BigDecimal abs = BigDecimalUtil.abs((BigDecimal)newFromPrice.subtract(billItem.getBigDecimal("fromamount")));
        if (abs.compareTo(new BigDecimal("0.01")) > 0 && MaterialToGoodsInfoHelp2.getConversionConfig(conversionConfig)) {
            newFromTaxPrice = billItem.getBigDecimal("fromtaxamount").divide(newNum, fromPricePrecision, 4);
            newFromPrice = billItem.getBigDecimal("fromamount").divide(newNum, fromPricePrecision, 4);
        }
        billItem.set("fromtaxprice", (Object)newFromTaxPrice);
        billItem.set("fromprice", (Object)newFromPrice);
        billItem.set("remainvalidnum", (Object)newNum);
        billItem.set("modelnumrate", (Object)conversionRate);
        billItem.set("orimodelnumrate", (Object)conversionRate);
        billItem.set("CURRENTMODELNUMRATE", (Object)1);
    }

    private static boolean getConversionConfig(String conversionConfig) {
        return StringUtils.isBlank((CharSequence)conversionConfig) || Boolean.parseBoolean(conversionConfig);
    }
}

