/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.goodsinfo;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.dto.BillDetailVo;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;

public class UnitConversionHelp {
    private static final Log LOGGER = LogFactory.getLog(UnitConversionHelp.class);

    public void setUnitConversion(DynamicObject goodByMaterial, BillDetailVo billDetail, boolean isAllEle) {
        DynamicObjectCollection items = goodByMaterial.getDynamicObjectCollection("bdm_goods_info_item");
        for (DynamicObject item : items) {
            Object conversionRateObj;
            DynamicObject material;
            if (!GoodsInfoConstant.SourceTypeEnum.MATERIAL.getCode().equals(item.getString("sourcetype"))) continue;
            String billUnit = billDetail.getOriUnit();
            String oriGoodsName = billDetail.getOriGoodsName();
            String oriGoodsCode = billDetail.getOriGoodsCode();
            if (StringUtils.isBlank((CharSequence)billUnit) || null == item.getDynamicObject("baseunit") || null == (material = item.getDynamicObject("material_no")) || !material.getString("name").equals(oriGoodsName) && !material.getString("number").equals(oriGoodsCode) || !billUnit.equals(item.getString("baseunit.name")) || (conversionRateObj = item.get("modelnum_rate")) == null) continue;
            BigDecimal conversionRate = item.getBigDecimal("modelnum_rate");
            this.setInvoiceUintPrice(conversionRate, billDetail, isAllEle);
        }
    }

    private void setInvoiceUintPrice(BigDecimal conversionRate, BillDetailVo billDetail, boolean isAllEle) {
        if (StringUtils.isBlank((CharSequence)billDetail.getQuantity()) || StringUtils.isBlank((Object)conversionRate) || StringUtils.isBlank((CharSequence)billDetail.getPrice())) {
            return;
        }
        BigDecimal num = new BigDecimal(billDetail.getQuantity());
        BigDecimal unitPrice = new BigDecimal(billDetail.getPrice());
        if (BigDecimalUtil.compareZero((BigDecimal)num)) {
            return;
        }
        BigDecimal newNum = UnitPriceHelper.getNumValue((BigDecimal)num.multiply(conversionRate), (String)ResManager.loadKDString((String)"\u7ecf\u8fc7\u5355\u4f4d\u6362\u7b97\u7387\u6362\u7b97\u540e\u7684\u6570\u91cf", (String)"UnitConversionHelp_0", (String)"imc-sim-service", (Object[])new Object[0]));
        BigDecimal newUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)unitPrice, (BigDecimal)conversionRate, (boolean)true);
        BigDecimal newAmount = newUnitPrice.multiply(newNum);
        BigDecimal abs = BigDecimalUtil.abs((BigDecimal)newAmount.subtract(billDetail.getAmount()));
        String conversionConfig = ImcConfigUtil.getValue((String)"calculation_unit_conversion_rate", (String)"calculation_unit_conversion_rate");
        if (abs.compareTo(new BigDecimal("0.01")) > 0 && this.getConversionConfig(conversionConfig)) {
            LOGGER.info("\u6267\u884c\u53cd\u7b97----");
            newUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)billDetail.getAmount(), (BigDecimal)newNum, (boolean)isAllEle);
        }
        String newNumStr = newNum.toPlainString();
        billDetail.setQuantity(newNumStr);
        billDetail.setPrice(newUnitPrice.toPlainString());
        billDetail.setRemainQuantity(newNumStr);
        billDetail.setModelnumrate(conversionRate.toPlainString());
    }

    private boolean getConversionConfig(String conversionConfig) {
        return StringUtils.isBlank((CharSequence)conversionConfig) || Boolean.parseBoolean(conversionConfig);
    }
}

