/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.declarationbill.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.CurrencyConstant;
import kd.imc.bdm.common.constant.table.BgdBillConstant;
import kd.imc.bdm.common.dto.BillDetailVo;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.InvItemConfigHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.bdm.common.util.declarationbill.SignUtil;
import kd.imc.sim.common.dto.bgd.config.BgdConfig;
import kd.imc.sim.common.dto.bgd.request.BgdDetailRequestDTO;
import kd.imc.sim.common.dto.bgd.request.BgdExchangeRateRequestDTO;
import kd.imc.sim.common.dto.bgd.request.BgdListRequestDTO;
import kd.imc.sim.common.dto.bgd.request.BgdRequestDTO;
import kd.imc.sim.common.dto.bgd.response.BgdDetailResponseDTO;
import kd.imc.sim.common.dto.bgd.response.BgdExchangeRateResponseDTO;
import kd.imc.sim.common.dto.bgd.response.BgdItemsDTO;
import kd.imc.sim.common.dto.bgd.response.BgdListResponseDTO;
import kd.imc.sim.common.dto.bgd.service.BgdCollectDTO;
import kd.imc.sim.common.helper.MaterialToGoodsInfoHelp;
import kd.imc.sim.common.helper.cache.GoodsInfoCacheHelper;

public class BgdHelper {
    private static final String SUCCESS_CODE = "1000";
    private static Log LOGGER = LogFactory.getLog(BgdHelper.class);

    public static BgdConfig getBgdConfig(BgdCollectDTO dto, DynamicObject valueConfig) {
        DynamicObject org = dto.getOrg();
        BgdConfig config = new BgdConfig();
        config.setOrg(org);
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"epinfo", (QFilter[])new QFilter("id", "=", dto.getOrg().getPkValue()).toArray());
        if (orgs.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u5728\u53d1\u7968\u4e91\u6ca1\u6709\u5f15\u5165\uff0c\u8bf7\u5148\u5f15\u5165", (String)"BgdHelper_0", (String)"imc-sim-service", (Object[])new Object[0]), org.getString("name")));
        }
        DynamicObject epInfo = orgs[0].getDynamicObject("epinfo");
        if (null == epInfo) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u5728\u53d1\u7968\u4e91\u6ca1\u6709\u914d\u7f6e\u4f01\u4e1a\u4fe1\u606f\uff0c\u8bf7\u5148\u914d\u7f6e", (String)"BgdHelper_1", (String)"imc-sim-service", (Object[])new Object[0]), org.getString("name")));
        }
        String mockBgdurl = ImcConfigUtil.getValue((String)"MOCK_BGD", (String)"MOCK_BGD_URL");
        if ("1".equals(mockBgdurl)) {
            config.setAppKey("fe1a6646-dab3-4fea-aff5-dc00f0b8ef00");
            config.setUrl("http://test.xunoi.com:8082");
            config.setSecret("d9b3cb2a10b8462d8b7c0cee2a9315ab");
        } else {
            QFilter filter = new QFilter("taxnumber", "=", (Object)epInfo.getString("number")).and("validation", "=", (Object)"2").and("enable", "=", (Object)"1");
            DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_customs_declaration", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_customs_declaration"), (QFilter[])filter.toArray(), (String)"createtime desc");
            if (array.length == 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7:%s\u6ca1\u6709\u9a8c\u8bc1\u901a\u8fc7\u4e14\u53ef\u7528\u7684\u62a5\u5173\u5355\u521d\u59cb\u5316\u914d\u7f6e\u4fe1\u606f", (String)"BgdHelper_2", (String)"imc-sim-service", (Object[])new Object[0]), org.getString("name")));
            }
            config.setAppKey(array[0].getString("appkey"));
            String environment = array[0].getString("environment");
            String url = "1".equals(environment) ? "http://api.xunoi.com" : "http://test.xunoi.com:8082";
            config.setUrl(url);
            config.setSecret(array[0].getString("secretkey"));
            config.setProxyUrl("");
        }
        if (valueConfig == null) {
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bdm_customs_config", (Long)org.getLong("id")).and("enable", "=", (Object)"1");
            DynamicObject[] configs = BusinessDataServiceHelper.load((String)"bdm_customs_config", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_customs_config"), (QFilter[])baseDataFilter.toArray(), (String)"createtime desc");
            if (configs.length == 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7:%s\u6ca1\u6709\u53ef\u7528\u7684\u62a5\u5173\u5355\u5f00\u7968\u914d\u7f6e\u4fe1\u606f", (String)"BgdHelper_3", (String)"imc-sim-service", (Object[])new Object[0]), org.getString("name")));
            }
            valueConfig = configs[0];
        }
        config.setExchangeConfig(valueConfig.getString("ratedate"));
        config.setIssueConfig(valueConfig.getString("openinvoicetype"));
        config.setSpecConfig(valueConfig.getString("specmodel"));
        config.setNumConfig(valueConfig.getString("unitnum"));
        config.setConfigObj(valueConfig);
        DynamicObject[] currencys = BusinessDataServiceHelper.load((String)"bd_currency", (String)"number,name", null);
        Map<String, DynamicObject> currencyMap = Arrays.stream(currencys).collect(Collectors.toMap(o -> o.getString("number"), o -> o));
        config.setCurrencyBaseDataMap(currencyMap);
        QFilter startFilter = new QFilter("nf", "=", (Object)dto.getStartYear()).and(new QFilter("yf", "=", (Object)dto.getStartMonth()));
        QFilter endFilter = new QFilter("nf", "=", (Object)dto.getEndYear()).and(new QFilter("yf", "=", (Object)dto.getEndMonth()));
        DynamicObject[] exchangeRates = BusinessDataServiceHelper.load((String)"bdm_cur_exchange_rate", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_cur_exchange_rate"), (QFilter[])startFilter.or(endFilter).toArray());
        HashMap<String, DynamicObject> dbExchangeRateMap = new HashMap<String, DynamicObject>(8);
        for (DynamicObject o2 : exchangeRates) {
            dbExchangeRateMap.put(o2.getString("bzdm") + o2.get("nf") + o2.get("yf"), o2);
        }
        config.setDbExchangeRateMap(dbExchangeRateMap);
        Map<String, String> currNameCodeMap = BgdHelper.getCurrNameCodeMap();
        config.setCurrNameCodeMap(currNameCodeMap);
        config.setTaxClassCodeIdMap(TaxClassCodeCheckHelper.getTaxClassCodeMap());
        config.setNewExchangeRateMap(new HashMap());
        dto.setOrg(null);
        dto.setStart(null);
        dto.setEnd(null);
        Date date = new Date();
        String batchNo = "bg_" + DateUtils.format((Date)date, (String)"yyyyMMddHHmmss");
        config.setBatchNo(batchNo);
        return config;
    }

    public static BgdConfig getBgdConfig(BgdCollectDTO dto) {
        return BgdHelper.getBgdConfig(dto, null);
    }

    public static void fillData(DynamicObject bgdBill, BgdDetailResponseDTO detail, BgdListResponseDTO bgdListResponseDTO, BgdConfig config) {
        Map currencyMap = config.getCurrencyBaseDataMap();
        bgdBill.set("org", config.getOrg().getPkValue());
        bgdBill.set("createtime", (Object)new Date());
        bgdBill.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        bgdBill.set("billno", (Object)bgdListResponseDTO.getCusCiqNo());
        if (UnitTestHelper.isUnitTest()) {
            bgdBill.set("billno", (Object)("E" + RandomString.nextString((int)18, (boolean)true, (boolean)false)));
        }
        bgdBill.set("entryid", (Object)bgdListResponseDTO.getEntryId());
        bgdBill.set("batchno", (Object)config.getBatchNo());
        bgdBill.set("pushstatus", (Object)BgdBillConstant.PushStatus.NO_PUSH);
        bgdBill.set("billstatus", (Object)"D");
        bgdBill.set("clearancestatus", (Object)bgdListResponseDTO.getCusDecStatusName());
        bgdBill.set("issueway", (Object)config.getIssueConfig());
        bgdBill.set("collectstatus", (Object)"0");
        if (null == detail) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)ImcConfigUtil.getValue((String)"modifyCURR", (String)"modifyCURR"))) {
            String currCode = ImcConfigUtil.getValue((String)"modifyCURR", (String)"modifyCURR");
            BgdHelper.modifyCurr(currCode, detail, config);
        }
        bgdBill.set("othercurr", currencyMap.get(detail.getOtherCurr()));
        bgdBill.set("feecurr", currencyMap.get(detail.getFeeCurr()));
        bgdBill.set("insurcurr", currencyMap.get(detail.getInsurCurr()));
        bgdBill.set("localcurrency", currencyMap.get(CurrencyConstant.CHW));
        bgdBill.set("issuerule", (Object)config.getConfigObj());
        bgdBill.set("collectstatus", (Object)"1");
        List taxGdDyCkbgdDetails = detail.getTaxGdDyCkbgdDetails();
        String tradeCurrName = null;
        if (null != taxGdDyCkbgdDetails && taxGdDyCkbgdDetails.size() > 0) {
            tradeCurrName = ((BgdItemsDTO)taxGdDyCkbgdDetails.get(0)).getTradeCurrName();
            String tradeCurr = ((BgdItemsDTO)taxGdDyCkbgdDetails.get(0)).getTradeCurr();
            bgdBill.set("tradecurr", currencyMap.get(tradeCurr));
            bgdBill.set("tradecurrcode", (Object)tradeCurr);
        }
        Map nameCodeMap = config.getCurrNameCodeMap();
        bgdBill.set("feeexchangerate", (Object)BgdHelper.getExchangeRate(detail.getIedate(), (String)nameCodeMap.get(detail.getFeeCurrName()), config).setScale(4, RoundingMode.HALF_UP));
        bgdBill.set("insurexchangerate", (Object)BgdHelper.getExchangeRate(detail.getIedate(), (String)nameCodeMap.get(detail.getInsurCurrName()), config).setScale(4, RoundingMode.HALF_UP));
        bgdBill.set("otherexchangerate", (Object)BgdHelper.getExchangeRate(detail.getIedate(), (String)nameCodeMap.get(detail.getOtherCurrName()), config).setScale(4, RoundingMode.HALF_UP));
        bgdBill.set("dealexchangerate", (Object)BgdHelper.getExchangeRate(detail.getIedate(), (String)nameCodeMap.get(tradeCurrName), config).setScale(4, RoundingMode.HALF_UP));
        bgdBill.set("dollarexchangerate", (Object)BgdHelper.getExchangeRate(detail.getIedate(), "502", config).setScale(4, RoundingMode.HALF_UP));
        bgdBill.set("transportinfo", (Object)BgdHelper.concat(detail.getTrafName(), detail.getCustomMasterName()));
        bgdBill.set("markno", (Object)BgdHelper.concat(detail.getMarkNo(), detail.getNoteS()));
        bgdBill.set("attadocucdstr", (Object)BgdHelper.concat(detail.getAttaDocuCdstr(), detail.getAttEdocNo()));
    }

    private static void modifyCurr(String jsonStr, BgdDetailResponseDTO detail, BgdConfig config) {
        Map currencyMap = config.getCurrencyBaseDataMap();
        JSONObject json = JSONObject.parseObject((String)jsonStr);
        String otherCode = json.getString("otherCode");
        String feeCode = json.getString("feeCode");
        String insurCode = json.getString("insurCode");
        String tradeCode = json.getString("tradeCode");
        detail.setOtherCurr(otherCode);
        detail.setFeeCurr(feeCode);
        detail.setInsurCurr(insurCode);
        String tradeCurrName = null;
        for (Map.Entry entry : currencyMap.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            String key = (String)entry.getKey();
            if (!key.equals(tradeCode)) continue;
            tradeCurrName = value.getString("name");
        }
        List taxGdDyCkbgdDetails = detail.getTaxGdDyCkbgdDetails();
        if (null != taxGdDyCkbgdDetails && taxGdDyCkbgdDetails.size() > 0) {
            ((BgdItemsDTO)taxGdDyCkbgdDetails.get(0)).setTradeCurrName(tradeCurrName);
            ((BgdItemsDTO)taxGdDyCkbgdDetails.get(0)).setTradeCurr(tradeCode);
        }
        detail.setFeeCurrName(tradeCurrName);
        detail.setInsurCurrName(tradeCurrName);
        detail.setOtherCurrName(tradeCurrName);
    }

    private static String concat(String a, String b) {
        if (StringUtils.isBlank((CharSequence)a)) {
            a = "";
        }
        if (StringUtils.isBlank((CharSequence)b)) {
            b = "";
        }
        return a + b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BigDecimal getExchangeRate(Date date, String bzdm, BgdConfig config) {
        BgdExchangeRateResponseDTO exchangeRateResponseDTO;
        if ("1".equals(ImcConfigUtil.getValue((String)"localDev", (String)"localDev"))) {
            return new BigDecimal("7.01256");
        }
        if (StringUtils.isBlank((CharSequence)bzdm)) {
            return BigDecimal.ZERO;
        }
        Map dbExchangeRateMap = config.getDbExchangeRateMap();
        Map newExchangeRateMap = config.getNewExchangeRateMap();
        String key = BgdHelper.getKey(bzdm, date);
        DynamicObject exchangeRate = (DynamicObject)dbExchangeRateMap.get(key);
        if (null == exchangeRate && null != newExchangeRateMap) {
            exchangeRate = (DynamicObject)newExchangeRateMap.get(key);
        }
        BgdExchangeRateRequestDTO exRateRequest = new BgdExchangeRateRequestDTO();
        exRateRequest.setNf(DateUtils.format((Date)date, (String)"yyyy"));
        exRateRequest.setYf(DateUtils.format((Date)date, (String)"MM"));
        exRateRequest.setBzdm(bzdm);
        if (null == exchangeRate) {
            exchangeRateResponseDTO = BgdHelper.queryExchangeRate(exRateRequest, config);
        } else if ("2".equals(config.getExchangeConfig())) {
            BigDecimal workDayExrate = exchangeRate.getBigDecimal("yhl");
            if (!BigDecimalUtil.compareZero((BigDecimal)workDayExrate)) return exchangeRate.getBigDecimal("yhl");
            exchangeRateResponseDTO = BgdHelper.queryExchangeRate(exRateRequest, config);
        } else {
            BigDecimal dayExrate;
            String mm = DateUtils.format((Date)date, (String)"dd");
            if (mm.startsWith("0")) {
                mm = String.valueOf(mm.charAt(1));
            }
            if (!BigDecimalUtil.compareZero((BigDecimal)(dayExrate = exchangeRate.getBigDecimal("yhl" + mm)))) return dayExrate;
            exchangeRateResponseDTO = BgdHelper.queryExchangeRate(exRateRequest, config);
        }
        if (null == exchangeRateResponseDTO) {
            return BigDecimal.ZERO;
        }
        DynamicObject newExchangeRate = DynamicObjectUtil.bean2DynamicObject((Object)exchangeRateResponseDTO, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"bdm_cur_exchange_rate"));
        newExchangeRate.set("mergekey", (Object)(exRateRequest.getBzdm() + exRateRequest.getNf() + exRateRequest.getYf()));
        config.getNewExchangeRateMap().put(key, newExchangeRate);
        BgdHelper.deleteDbExrate(exchangeRate);
        dbExchangeRateMap.remove(key);
        if ("2".equals(config.getExchangeConfig())) {
            return newExchangeRate.getBigDecimal("yhl");
        }
        String mm = DateUtils.format((Date)date, (String)"dd");
        if (!mm.startsWith("0")) return newExchangeRate.getBigDecimal("yhl" + mm);
        mm = String.valueOf(mm.charAt(1));
        return newExchangeRate.getBigDecimal("yhl" + mm);
    }

    private static void deleteDbExrate(DynamicObject exchangeRate) {
        if (null != exchangeRate) {
            DeleteServiceHelper.delete((String)"bdm_cur_exchange_rate", (QFilter[])new QFilter("id", "=", exchangeRate.getPkValue()).toArray());
        }
    }

    public static String getKey(String bzdm, Date date) {
        return bzdm + DateUtils.format((Date)date, (String)"yyyyMM");
    }

    public static BgdExchangeRateResponseDTO queryExchangeRate(BgdExchangeRateRequestDTO requestDTO, BgdConfig config) {
        String result;
        String url = config.getUrl();
        String proxyUrl = config.getProxyUrl();
        String commonAppkey = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.BGD_COMMON_APPKEY);
        String commonSecret = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.BGD_COMMON_SECRET);
        String appKey = config.getAppKey();
        String secret = config.getSecret();
        if (StringUtils.isNotBlank((CharSequence)commonAppkey) && StringUtils.isNotBlank((CharSequence)commonSecret)) {
            appKey = commonAppkey;
            secret = commonSecret;
        }
        String interfaceName = "queryExchangeRate";
        HashMap<String, String> formData = BgdHelper.getFormData((BgdRequestDTO)requestDTO, appKey, secret, interfaceName);
        LOGGER.info(String.format("param:%s", JSONObject.toJSONString(formData)));
        String mockBgd = ImcConfigUtil.getValue((String)"MOCK_BGD", (String)"MOCK_BGD");
        try {
            result = "1".equals(mockBgd) ? "{\"code\":\"0\",\"data\":\"{\\\"code\\\":\\\"1000\\\",\\\"data\\\":[{\\\"nf\\\":\\\"2022\\\",\\\"yf\\\":\\\"07\\\",\\\"bzdm\\\":\\\"142\\\",\\\"yhl\\\":100,\\\"rhl1\\\":100,\\\"rhl2\\\":100,\\\"rhl3\\\":100,\\\"rhl4\\\":100,\\\"rhl5\\\":100,\\\"rhl6\\\":100,\\\"rhl7\\\":100,\\\"rhl8\\\":100,\\\"rhl9\\\":100,\\\"rhl10\\\":100,\\\"rhl11\\\":100,\\\"rhl12\\\":100,\\\"rhl13\\\":100,\\\"rhl14\\\":100,\\\"rhl15\\\":100,\\\"rhl16\\\":100,\\\"rhl17\\\":100,\\\"rhl18\\\":100,\\\"rhl19\\\":100,\\\"rhl20\\\":100,\\\"rhl21\\\":100,\\\"rhl22\\\":100,\\\"rhl23\\\":0,\\\"rhl24\\\":0,\\\"rhl25\\\":0,\\\"rhl26\\\":0,\\\"rhl27\\\":0,\\\"rhl28\\\":0,\\\"rhl29\\\":0,\\\"rhl30\\\":0,\\\"rhl31\\\":0,\\\"workday\\\":\\\"2022-07-01\\\"}],\\\"msg\\\":\\\"\u64cd\u4f5c\u6210\u529f\\\"}\"}" : HttpUtil.doPostJson((String)url, (String)proxyUrl, null, (String)JSONObject.toJSONString(formData));
            LOGGER.info(String.format("queryExchangeRate:%s", result));
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            String tip = ResManager.loadKDString((String)"\u83b7\u53d6\u7a0e\u7387\u4fe1\u606f\u5f02\u5e38", (String)"BgdHelper_4", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(tip + e.getMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)result)) {
            JSONObject jsonObject = BgdHelper.getJsonData(result);
            if (SUCCESS_CODE.equals(jsonObject.get((Object)"code"))) {
                JSONArray data = jsonObject.getJSONArray("data");
                if (null == data) {
                    return null;
                }
                BgdExchangeRateResponseDTO exchangeResponse = (BgdExchangeRateResponseDTO)JSONObject.parseObject((String)data.getJSONObject(0).toJSONString(), BgdExchangeRateResponseDTO.class);
                BgdHelper.dealExchangeRate(exchangeResponse);
                return exchangeResponse;
            }
            String msg = jsonObject.getString("msg");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u62a5\u5173\u5355\u6c47\u7387\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\uff1a[%s]", (String)"BgdHelper_5", (String)"imc-sim-service", (Object[])new Object[0]), msg));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u62a5\u5173\u5355\u6c47\u7387\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a", (String)"BgdHelper_6", (String)"imc-sim-service", (Object[])new Object[0]));
    }

    public static void dealExchangeRate(BgdExchangeRateResponseDTO exchangeResponse) {
        Field[] fields;
        Class<?> clazz = exchangeResponse.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            String name = field.getName();
            if (!name.contains("yhl") && !name.contains("rhl")) continue;
            try {
                ReflectionUtils.makeAccessible((Field)field);
                Object value = field.get(exchangeResponse);
                if (null == value) continue;
                BigDecimal divideValue = ((BigDecimal)value).divide(new BigDecimal("100"), 12, 4);
                field.set(exchangeResponse, divideValue);
            }
            catch (IllegalAccessException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static List<BgdListResponseDTO> queryBgdList(BgdListRequestDTO requestDTO, BgdConfig config) {
        String result;
        if (StringUtils.isBlank((CharSequence)requestDTO.getDdateks()) || StringUtils.isBlank((CharSequence)requestDTO.getDdatejs())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f\u8d77\u548c\u7533\u62a5\u65e5\u671f\u6b62\u5fc5\u586b", (String)"BgdHelper_8", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        String url = config.getUrl();
        String proxyUrl = config.getProxyUrl();
        String appKey = config.getAppKey();
        String secret = config.getSecret();
        String interfaceName = "queryBgdDyCkList";
        HashMap<String, String> formData = BgdHelper.getFormData((BgdRequestDTO)requestDTO, appKey, secret, interfaceName);
        LOGGER.info(String.format("param:%s", JSONObject.toJSONString(formData)));
        String mockBgd = ImcConfigUtil.getValue((String)"MOCK_BGD", (String)"MOCK_BGD");
        try {
            result = "1".equals(mockBgd) ? "{\"code\":\"0\",\"data\":\"{\\\"code\\\":\\\"1000\\\",\\\"data\\\":[{\\\"id\\\":\\\"803c6868-4e9a-46d7-bbb8-17a632094024\\\",\\\"cusCiqNo\\\":\\\"E20210000583512765\\\",\\\"preEntryId\\\":\\\"530120210010156142\\\",\\\"entryId\\\":\\\"530120210010156142\\\",\\\"iedate\\\":\\\"2021-02-23\\\",\\\"ddate\\\":\\\"2021-02-23\\\",\\\"supvModeCdde\\\":\\\"0110\\\",\\\"supvModeCddeName\\\":\\\"\u4e00\u822c\u8d38\u6613\\\",\\\"cusDecStatus\\\":\\\"10\\\",\\\"cusDecStatusName\\\":\\\"\u7ed3\u5173\\\",\\\"customMaster\\\":\\\"5301\\\",\\\"customMasterName\\\":\\\"\u7687\u5c97\u6d77\u5173\\\",\\\"updateTime\\\":\\\"2021-02-23\\\"},{\\\"id\\\":\\\"7ae80a6e-d594-4b62-9778-36fad5867b4e\\\",\\\"cusCiqNo\\\":\\\"E20210000583508735\\\",\\\"preEntryId\\\":\\\"530120210010156542\\\",\\\"entryId\\\":\\\"530120210010156542\\\",\\\"iedate\\\":\\\"2021-02-24\\\",\\\"ddate\\\":\\\"2021-02-23\\\",\\\"supvModeCdde\\\":\\\"0110\\\",\\\"supvModeCddeName\\\":\\\"\u4e00\u822c\u8d38\u6613\\\",\\\"cusDecStatus\\\":\\\"10\\\",\\\"cusDecStatusName\\\":\\\"\u7ed3\u5173\\\",\\\"customMaster\\\":\\\"5301\\\",\\\"customMasterName\\\":\\\"\u7687\u5c97\u6d77\u5173\\\",\\\"updateTime\\\":\\\"2021-02-23\\\"},{\\\"id\\\":\\\"d53c14d4-3f69-4d28-b61c-ebb6055ec8ab\\\",\\\"cusCiqNo\\\":\\\"E20210000583827621\\\",\\\"preEntryId\\\":\\\"530120210010159072\\\",\\\"entryId\\\":\\\"530120210010159072\\\",\\\"iedate\\\":\\\"2021-02-24\\\",\\\"ddate\\\":\\\"2021-02-24\\\",\\\"supvModeCdde\\\":\\\"0110\\\",\\\"supvModeCddeName\\\":\\\"\u4e00\u822c\u8d38\u6613\\\",\\\"cusDecStatus\\\":\\\"10\\\",\\\"cusDecStatusName\\\":\\\"\u7ed3\u5173\\\",\\\"customMaster\\\":\\\"5301\\\",\\\"customMasterName\\\":\\\"\u7687\u5c97\u6d77\u5173\\\",\\\"updateTime\\\":\\\"2021-02-24\\\"}],\\\"msg\\\":\\\"\u64cd\u4f5c\u6210\u529f\\\"}\"}" : HttpUtil.doPostJson((String)url, (String)proxyUrl, null, (String)JSONObject.toJSONString(formData));
            LOGGER.info(String.format("queryBgdList:%s", result));
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f\u8d77\u548c\u7533\u62a5\u65e5\u671f\u6b62\u5fc5\u586b", (String)"BgdHelper_9", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new KDBizException(msg + e.getMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)result)) {
            JSONObject jsonObject = BgdHelper.getJsonData(result);
            if (SUCCESS_CODE.equals(jsonObject.get((Object)"code"))) {
                JSONArray data = jsonObject.getJSONArray("data");
                if (null == data) {
                    return new ArrayList<BgdListResponseDTO>();
                }
                return JSONObject.parseArray((String)data.toJSONString(), BgdListResponseDTO.class);
            }
            throw new KDBizException(jsonObject.getString("msg"));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u62a5\u5173\u5355\u5217\u8868\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a", (String)"BgdHelper_10", (String)"imc-sim-service", (Object[])new Object[0]));
    }

    public static BgdDetailResponseDTO queryBgdDetail(BgdDetailRequestDTO requestDTO, BgdConfig config) {
        String result;
        String url = config.getUrl();
        String proxyUrl = config.getProxyUrl();
        String appKey = config.getAppKey();
        String secret = config.getSecret();
        String interfaceName = "queryBgdDyCk";
        HashMap<String, String> formData = BgdHelper.getFormData((BgdRequestDTO)requestDTO, appKey, secret, interfaceName);
        LOGGER.info(String.format("param:%s", JSONObject.toJSONString(formData)));
        String mockBgd = ImcConfigUtil.getValue((String)"MOCK_BGD", (String)"MOCK_BGD");
        BgdDetailResponseDTO response = new BgdDetailResponseDTO();
        response.setErrorCode(ErrorType.FAIL.getCode());
        try {
            result = "1".equals(mockBgd) ? "{}" : HttpUtil.doPostJson((String)url, (String)proxyUrl, null, (String)JSONObject.toJSONString(formData));
            LOGGER.info(String.format("queryBgdDetail:%s", result));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)result)) {
            JSONObject jsonObject = BgdHelper.getJsonData(result);
            if (SUCCESS_CODE.equals(jsonObject.get((Object)"code"))) {
                JSONArray array = jsonObject.getJSONArray("data");
                if (null == array) {
                    response.setErrorMsg(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u62a5\u5173\u5355\u8be6\u7ec6\u4fe1\u606f", (String)"BgdHelper_11", (String)"imc-sim-service", (Object[])new Object[0]));
                    return response;
                }
                JSONObject oneBgd = array.getJSONObject(0);
                JSONObject mainData = oneBgd.getJSONObject("taxGdDyCkbgd");
                String billNo = mainData.getString("cusCiqNo");
                BgdHelper.saveDetailMap(billNo, result, config);
                if ("1".equals(mockBgd)) {
                    mainData.put("cusCiqNo", (Object)("E" + RandomString.nextString((int)18, (boolean)true, (boolean)false)));
                }
                BgdDetailResponseDTO bgdDetailResponseDTO = (BgdDetailResponseDTO)JSONObject.parseObject((String)mainData.toJSONString(), BgdDetailResponseDTO.class);
                JSONArray items = oneBgd.getJSONArray("taxGdDyCkbgdDetails");
                List bgdItemsDTOS = JSONObject.parseArray((String)items.toJSONString(), BgdItemsDTO.class);
                bgdDetailResponseDTO.setTaxGdDyCkbgdDetails(bgdItemsDTOS);
                JSONArray taxGdDyckCkbgdPredecdocvo = oneBgd.getJSONArray("taxGdDyckCkbgdPredecdocvo");
                if (null != taxGdDyckCkbgdPredecdocvo && taxGdDyckCkbgdPredecdocvo.size() > 0) {
                    JSONObject docVo = taxGdDyckCkbgdPredecdocvo.getJSONObject(0);
                    bgdDetailResponseDTO.setAttEdocNo(docVo.getString("attEdocNo"));
                    bgdDetailResponseDTO.setAttTypeCode(docVo.getString("attTypeCode"));
                    bgdDetailResponseDTO.setAttTypeCodeName(docVo.getString("attTypeCodeName"));
                }
                return bgdDetailResponseDTO;
            }
            LOGGER.info(result);
            response.setErrorMsg(jsonObject.getString("msg"));
            return response;
        }
        response.setErrorMsg(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u62a5\u5173\u5355\u8be6\u7ec6\u4fe1\u606f", (String)"BgdHelper_11", (String)"imc-sim-service", (Object[])new Object[0]));
        return response;
    }

    private static void saveDetailMap(String billNo, String response, BgdConfig config) {
        HashMap<String, String> detailMap = config.getDetailMap();
        if (null == detailMap) {
            detailMap = new HashMap<String, String>();
            config.setDetailMap(detailMap);
        }
        detailMap.put(billNo, response);
    }

    private static JSONObject getJsonData(String result) {
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        jsonObject = jsonObject.getJSONObject("data");
        return jsonObject;
    }

    private static HashMap<String, String> getFormData(BgdRequestDTO requestDTO, String appKey, String secret, String interfaceName) {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("access_token", "");
        String encodeParam = BgdHelper.getEncodeParam(JSONObject.toJSONString((Object)requestDTO));
        JSONObject innerData = new JSONObject();
        innerData.put("app_key", (Object)appKey);
        innerData.put("data", (Object)encodeParam);
        String encodeFormData = BgdHelper.getEncodeParam(innerData.toJSONString());
        formData.put("data", encodeFormData);
        formData.put("app_key", appKey);
        formData.put("format", "json");
        formData.put("name", interfaceName);
        formData.put("version", "1.0");
        String timeStamp = DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        formData.put("timestamp", timeStamp);
        String sign = SignUtil.createSign(formData, (String)secret);
        formData.put("sign", sign);
        LOGGER.info(String.format("formDataJson:%s", JSONObject.toJSONString(formData)));
        return formData;
    }

    private static String getEncodeParam(String params) {
        try {
            params = URLEncoder.encode(params, "utf-8");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return params;
    }

    public static Map<String, String> getCurrNameCodeMap() {
        String str = CacheHelper.get((String)"currencyCodeNameMap");
        if (StringUtils.isBlank((CharSequence)str)) {
            DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_curr_table", (String)"name,number", null);
            if (array.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5e01\u5236\u4ee3\u7801\u8868\u672a\u521d\u59cb\u5316", (String)"BgdHelper_12", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            Map<String, String> currNameCodeMap = Arrays.stream(array).collect(Collectors.toMap(o -> o.getString("name"), o -> o.getString("number")));
            CacheHelper.put((String)"currencyCodeNameMap", (String)JSONObject.toJSONString(currNameCodeMap), (int)600);
            return currNameCodeMap;
        }
        return (Map)JSONObject.parseObject((String)str, Map.class);
    }

    public static Map<String, String> getCurrCodeNameMap() {
        Map<String, String> map = BgdHelper.getCurrNameCodeMap();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            result.put(value, key);
        }
        return result;
    }

    public static void goodsMatch(List<DynamicObject> list, long orgId, BgdConfig config) {
        if (list.size() == 0) {
            return;
        }
        ArrayList<BillVo> bills = new ArrayList<BillVo>();
        HashMap<BillVo, DynamicObject> billVoBillMap = new HashMap<BillVo, DynamicObject>();
        for (DynamicObject bgdBill : list) {
            BillVo billVo = new BillVo();
            billVo.setOrgId(Long.valueOf(orgId));
            bills.add(billVo);
            List billDetail = billVo.getBillDetail();
            DynamicObjectCollection items = bgdBill.getDynamicObjectCollection("sim_original_bill_item");
            for (int i = 0; i < items.size(); ++i) {
                BillDetailVo billDetailVo = new BillDetailVo();
                billDetailVo.setGoodsCode(((DynamicObject)items.get(i)).getString("spbm"));
                billDetailVo.setGoodsName(((DynamicObject)items.get(i)).getString("goodsname"));
                billDetail.add(billDetailVo);
            }
            billVoBillMap.put(billVo, bgdBill);
        }
        HashMap<String, DynamicObject> pushGoodsInfoData = new HashMap<String, DynamicObject>(8);
        MaterialToGoodsInfoHelp.instanceMaterialInfoUtilByBillList(bills, ((BillVo)bills.get(0)).getOrgId(), false);
        Map invItemConfig = InvItemConfigHelper.getInvItemConfig((Long)bills.get(0).getOrgId());
        BgdHelper.goodsMapping(bills, pushGoodsInfoData, false, orgId, billVoBillMap);
        Map taxClassCodeIdMap = config.getTaxClassCodeObjMap();
        for (int i = 0; i < bills.size(); ++i) {
            DynamicObject bgdBill = list.get(i);
            DynamicObjectCollection items = bgdBill.getDynamicObjectCollection("sim_original_bill_item");
            List billDetails = bills.get(i).getBillDetail();
            for (int j = 0; j < billDetails.size(); ++j) {
                BillDetailVo billDetailVo = (BillDetailVo)billDetails.get(j);
                DynamicObject bgdItem = (DynamicObject)items.get(j);
                bgdItem.set("taxrate", (Object)billDetailVo.getTaxRate());
                bgdItem.set("goodscode", (Object)billDetailVo.getRevenueCode());
                if (StringUtils.isBlank((CharSequence)billDetailVo.getRevenueCode()) && !UnitTestHelper.isUnitTest()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u672a\u5339\u914d\u5230\u5f00\u7968\u9879", (String)"BgdHelper_13", (String)"imc-sim-service", (Object[])new Object[0]), billDetailVo.getGoodsName()));
                }
                bgdItem.set("goodssimplename", (Object)billDetailVo.getRevenueName());
                bgdItem.set("policylogo", (Object)billDetailVo.getPrivilegeFlag());
                bgdItem.set("policycontants", (Object)billDetailVo.getPrivilegeContent());
                bgdItem.set("taxratecodeid", taxClassCodeIdMap.get(billDetailVo.getRevenueCode()));
                bgdItem.set("goodssimplename", ((DynamicObject)taxClassCodeIdMap.get(billDetailVo.getRevenueCode())).get("simplename"));
            }
        }
    }

    private static void goodsMapping(List<BillVo> bills, Map<String, DynamicObject> pushGoodsInfoData, boolean isCondition, long orgId, Map<BillVo, DynamicObject> billVoBillMap) {
        HashSet<String> goodsNameSet = new HashSet<String>(bills.size());
        HashSet<String> goodsCodeSet = new HashSet<String>(bills.size());
        for (BillVo bill : bills) {
            List billDetail = bill.getBillDetail();
            for (BillDetailVo billDetailVo : billDetail) {
                goodsNameSet.add(billDetailVo.getGoodsName());
                goodsCodeSet.add(billDetailVo.getGoodsCode());
            }
        }
        Map goodsNameMap = GoodsInfoCacheHelper.getGoodsInfo((String)"name", (Long)orgId, goodsNameSet);
        Map goodsCodeMap = GoodsInfoCacheHelper.getGoodsInfo((String)"number", (Long)orgId, goodsCodeSet);
        for (BillVo bill : bills) {
            for (BillDetailVo detail : bill.getBillDetail()) {
                if (StringUtils.isBlank((CharSequence)detail.getMaterialType())) {
                    detail.setMaterialType(null);
                }
                MaterialToGoodsInfoHelp.fillInGoodsInfo(detail, goodsNameMap, goodsCodeMap, false, false, false, true, billVoBillMap.get(bill));
            }
        }
    }

    public static boolean isRmbFobWay(String issueWay, String transModeName) {
        return "2".equals(issueWay) || "FOB".equals(transModeName);
    }

    public static BigDecimal getIssueNum(DynamicObject item, BgdConfig config) {
        if ("3".equals(config.getNumConfig())) {
            return item.getBigDecimal("gqty");
        }
        if ("1".equals(config.getNumConfig())) {
            return item.getBigDecimal("qty1");
        }
        return item.getBigDecimal("qty2");
    }

    public static BgdConfig getBaseConfig(DynamicObject configObj) {
        BgdConfig config = new BgdConfig();
        config.setExchangeConfig(configObj.getString("ratedate"));
        config.setIssueConfig(configObj.getString("openinvoicetype"));
        config.setSpecConfig(configObj.getString("specmodel"));
        config.setNumConfig(configObj.getString("unitnum"));
        config.setConfigObj(configObj);
        config.setSplitRemark(configObj.getString("splitremark"));
        config.setRemarkKeys(configObj.getString("remarkselectkeys"));
        String fields = String.join((CharSequence)",", "selectalias", "selectkey", "selected");
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_customs_select_remark", (String)fields, (QFilter[])new QFilter("remarkid", "=", (Object)configObj.getLong("id")).toArray());
        HashSet<String> showFields = new HashSet<String>();
        HashMap<String, String> showFiledsMap = new HashMap<String, String>();
        for (DynamicObject dynamicObject : array) {
            String selected = dynamicObject.getString("selected");
            if (!"1".equals(selected)) continue;
            showFields.add(dynamicObject.getString("selectkey"));
            showFiledsMap.put(dynamicObject.getString("selectkey"), dynamicObject.getString("selectalias"));
        }
        config.setShowFiledsMap(showFiledsMap);
        config.setShowFields(showFields);
        return config;
    }

    public static BigDecimal getExchangeRate(Date date, DynamicObject currency, BgdConfig config) {
        if (null == currency) {
            return BigDecimal.ZERO;
        }
        String bzdm = BgdHelper.getBzdmFromCurrency(currency);
        return BgdHelper.getExchangeRate(date, bzdm, config).setScale(2, RoundingMode.HALF_UP);
    }

    public static String getBzdmFromCurrency(DynamicObject currency) {
        Map<String, String> nameCodeMap = BgdHelper.getCurrNameCodeMap();
        return nameCodeMap.get(currency.getString("name"));
    }

    public static boolean isEqualsCurr(DynamicObject fromCurr, DynamicObject curr) {
        if (fromCurr == curr) {
            return true;
        }
        if (null == fromCurr || null == curr) {
            return false;
        }
        return fromCurr.getPkValue() == curr.getPkValue();
    }
}

