/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.utils.MathUtils;

public class RimInvoiceHelper {
    private static final String RIM_ALL_E_BILL_KEY = "rim_inv_electric";

    public static DynamicObject createInvoiceByRim(DynamicObject rimInvoice) {
        DynamicObject invoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        invoice.set("issuetime", rimInvoice.get("invoice_date"));
        DynamicObject invoiceType = rimInvoice.getDynamicObject("invoice_type");
        if (invoiceType != null) {
            invoice.set("invoicetype", (Object)InvoiceType.getInvoiceTypeCodeByBaseCode((String)invoiceType.getString("number")));
        }
        invoice.set("salertaxno", rimInvoice.get("saler_tax_no"));
        invoice.set("salername", rimInvoice.get("saler_name"));
        String name = rimInvoice.getDynamicObjectType().getName();
        if (!RIM_ALL_E_BILL_KEY.equals(name)) {
            invoice.set("salerbank", rimInvoice.get("saler_account"));
            invoice.set("saleraddr", rimInvoice.get("saler_address_phone"));
            invoice.set("buyerbank", rimInvoice.get("buyer_account"));
            invoice.set("buyeraddr", rimInvoice.get("buyer_address_phone"));
        }
        invoice.set("buyertaxno", rimInvoice.get("buyer_tax_no"));
        invoice.set("buyerproperty", (Object)"0");
        invoice.set("buyername", rimInvoice.get("buyer_name"));
        invoice.set("totalamount", rimInvoice.get("total_amount"));
        invoice.set("totaltax", rimInvoice.get("total_tax_amount"));
        invoice.set("invoiceamount", rimInvoice.get("invoice_amount"));
        if (rimInvoice.containsProperty("invoice_code")) {
            invoice.set("invoicecode", rimInvoice.get("invoice_code"));
        }
        invoice.set("invoiceno", rimInvoice.get("invoice_no"));
        invoice.set("billno", (Object)UUID.getBatchNumber());
        invoice.set("orgid", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)rimInvoice.getDynamicObject("org")));
        invoice.set("hsbz", (Object)"0");
        invoice.set("remark", rimInvoice.get("remark"));
        DynamicObjectCollection invoiceItems = invoice.getDynamicObjectCollection("items");
        DynamicObjectCollection rimItems = rimInvoice.getDynamicObjectCollection("items");
        String specialType = "00";
        for (int i = 0; i < rimItems.size(); ++i) {
            DynamicObject rimItem = (DynamicObject)rimItems.get(i);
            DynamicObject item = invoiceItems.addNew();
            item.set("seq", (Object)(i + 1));
            item.set("goodsname", rimItem.get("goods_name"));
            item.set("goodscode", rimItem.get("goods_code"));
            item.set("specification", rimItem.get("spec_model"));
            item.set("unitprice", rimItem.get("unit_price"));
            BigDecimal num = rimItem.getBigDecimal("num");
            item.set("num", (Object)num);
            item.set("taxrate", (Object)rimItem.getBigDecimal("tax_rate").stripTrailingZeros().toString());
            item.set("unit", rimItem.get("unit"));
            item.set("amount", rimItem.get("detail_amount"));
            item.set("tax", rimItem.get("tax_amount"));
            item.set("taxamount", (Object)item.getBigDecimal("amount").add(item.getBigDecimal("tax")));
            if (!MathUtils.isNullOrZero((BigDecimal)num)) {
                item.set("taxunitprice", (Object)item.getBigDecimal("taxamount").divide(num, 8, 4));
            }
            if (item.getString("goodscode").startsWith("1030402")) {
                specialType = "11";
            }
            if (item.getBigDecimal("amount").compareTo(BigDecimal.ZERO) > 0) {
                item.set("rowtype", (Object)"0");
            } else {
                item.set("rowtype", (Object)"1");
                ((DynamicObject)invoiceItems.get(i - 1)).set("rowtype", (Object)"2");
            }
            item.set("taxpremark", rimItem.get("preferential_policy"));
            item.set("zzstsgl", rimItem.get("vat_exception"));
        }
        if (invoiceItems.size() > 8) {
            invoice.set("inventorymark", (Object)"1");
        } else {
            invoice.set("inventorymark", (Object)"0");
        }
        invoice.set("specialtype", (Object)specialType);
        return invoice;
    }
}

