/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.control;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.enums.SeatClassTypeEnum;
import kd.imc.sim.common.enums.TransportTypeEnum;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.imc.sim.common.utils.MathUtils;

public class InvoiceOriginalFormControl {
    public static void notEdit(AbstractFormPlugin plugin) {
        plugin.getView().setEnable(Boolean.FALSE, new String[]{"billsourcetype", "systemsource", "validstate", "billsource", "billstatus", "confirmstate", "auditor", "auditdate", "auditsuggestion"});
        plugin.getView().setEnable(Boolean.FALSE, new String[]{"totalamount", "invoiceamount", "totaltax", "confirmamount", "mainissuedamount", "mainissuedtax", "surplusamount", "surplustax", "maintaxdeviation"});
        plugin.getView().setEnable(Boolean.FALSE, new String[]{"oldtotalamount"});
        plugin.getView().setEnable(Boolean.FALSE, new String[]{"foreignissuedamount", "foreigninvoiceamount", "foreigntax", "foreigntotalamount", "foreignissuedtotalamount", "foreignissuedtax", "foreigntaxdifference"});
        Object systemSource = plugin.getView().getModel().getValue("systemsource");
        if (BotpHelper.isFromArZANGU((Object)systemSource)) {
            plugin.getView().setEnable(Boolean.TRUE, new String[]{"exratetable", "exchangedate", "exrate", "quotation"});
        } else {
            plugin.getView().setEnable(Boolean.FALSE, new String[]{"exratetable", "exchangedate", "exrate", "quotation"});
        }
    }

    public static void buyerNameEdit(AbstractFormPlugin plugin) {
        plugin.getView().setVisible(Boolean.FALSE, new String[]{"buyername", "epnamequery", "cardtype"});
    }

    public static void botpNotEdit(AbstractFormPlugin plugin) {
        plugin.getView().setEnable(Boolean.FALSE, new String[]{"salertaxno", "salername", "salesorg", "settlementorg", "capitalorg"});
        plugin.getView().setVisible(Boolean.TRUE, new String[]{"itemdel"});
    }

    public static void addTextEditClickListener(AbstractFormPlugin plugin, String ... keys) {
        for (String key : keys) {
            TextEdit textEdit = (TextEdit)plugin.getView().getControl(key);
            if (textEdit == null) continue;
            textEdit.addClickListener((ClickListener)plugin);
        }
    }

    public static void dealItemEnalbeStatus(DynamicObjectCollection itemList, AbstractFormPlugin plugin) {
        boolean isNotForceGoodsMatch = !BotpHelper.isForceGoodsMatch();
        Object fromCurr = plugin.getView().getModel().getValue("fromcurr");
        plugin.getView().setEnable(Boolean.TRUE, new String[]{"sim_original_bill_item"});
        boolean isFrom = CurrencyHelper.isFrom((Object)fromCurr);
        Object systemSource = plugin.getView().getModel().getValue("systemsource");
        boolean fromArZANGU = BotpHelper.isFromArZANGU((Object)systemSource);
        boolean isIncludeTax = "1".equals(plugin.getView().getModel().getValue("hsbz"));
        int itemSize = itemList.size();
        int maxI = itemSize - 1;
        for (int i = 0; i < itemSize; ++i) {
            boolean isNotlast;
            HashSet<String> enableSet = new HashSet<String>();
            HashSet<String> disableSet = new HashSet<String>();
            plugin.getView().setEnable(Boolean.FALSE, i, new String[]{"taxrate", "goodsid", "unitprice", "extrafield", "extrafield2", "extrafield3", "extrafield4", "extrafield5", "orinum", "origoodsname", "oriunitprice", "oriunit", "policycontants", "policylogo", "tax", "taxunitprice", "remark", "orispecification", "expenseitem", "materielfield"});
            InvoiceOriginalFormControl.baseEnableFromBenchMark(itemList, plugin, i, isFrom, enableSet, disableSet);
            DynamicObject item = (DynamicObject)itemList.get(i);
            String rowType = item.getString("rowtype");
            if ("1".equals(rowType)) {
                InvoiceOriginalFormControl.disableField(enableSet, disableSet, "fromamount", "fromtaxamount", "num", "amount", "taxamount", "unitprice", "taxrate", "taxratecodeid", "materielfield", "expenseitem", "goodsid", "taxunitprice", "goodsname", "specification", "unit");
            }
            if (fromArZANGU) {
                InvoiceOriginalFormControl.enableField(enableSet, disableSet, "taxrate");
            }
            if (MathUtils.isNotZero((BigDecimal)item.getBigDecimal("fromdiscountamount"))) {
                InvoiceOriginalFormControl.disableField(enableSet, disableSet, "fromamount", "fromtaxamount", "num");
            }
            boolean bl = isNotlast = itemSize >= i + 2;
            if (isNotlast && !"1".equals(rowType)) {
                DynamicObject nextRow = (DynamicObject)itemList.get(i + 1);
                String nextRowType = nextRow.getString("rowtype");
                if ("1".equals(nextRowType)) {
                    if (isNotForceGoodsMatch) {
                        InvoiceOriginalFormControl.enableField(enableSet, disableSet, "taxratecodeid");
                    }
                    InvoiceOriginalFormControl.disableField(enableSet, disableSet, "fromtaxamount", "amount", "fromprice", "fromtaxprice", "fromtax", "taxamount", "fromamount", "num");
                }
                if (!"1".equals(nextRowType)) {
                    InvoiceOriginalFormControl.dealZanGuItemEnable(isFrom, fromArZANGU, isIncludeTax, enableSet, disableSet, item);
                }
            }
            if (i == maxI && !"1".equals(rowType)) {
                InvoiceOriginalFormControl.dealZanGuItemEnable(isFrom, fromArZANGU, isIncludeTax, enableSet, disableSet, item);
            }
            plugin.getView().setEnable(Boolean.TRUE, i, enableSet.toArray(new String[0]));
            plugin.getView().setEnable(Boolean.FALSE, i, disableSet.toArray(new String[0]));
        }
    }

    private static void dealZanGuItemEnable(boolean isFrom, boolean fromArZANGU, boolean isIncludeTax, Set<String> enableSet, Set<String> disableSet, DynamicObject item) {
        if (fromArZANGU) {
            String rowType = item.getString("rowtype");
            if ("0".equals(item.get("benchmark")) && !"1".equals(rowType)) {
                InvoiceOriginalFormControl.enableField(enableSet, disableSet, "num");
            }
            if (isIncludeTax) {
                if (isFrom) {
                    InvoiceOriginalFormControl.enableField(enableSet, disableSet, "fromtaxamount");
                } else {
                    InvoiceOriginalFormControl.enableField(enableSet, disableSet, "taxamount");
                }
            } else if (isFrom) {
                InvoiceOriginalFormControl.enableField(enableSet, disableSet, "fromamount");
            } else {
                InvoiceOriginalFormControl.enableField(enableSet, disableSet, "amount");
            }
        }
    }

    private static void baseEnableFromBenchMark(DynamicObjectCollection itemList, AbstractFormPlugin plugin, int i, boolean isFrom, Set<String> enableSet, Set<String> disableSet) {
        if ("0".equals(((DynamicObject)itemList.get(i)).get("benchmark"))) {
            InvoiceOriginalFormControl.enableField(enableSet, disableSet, "num");
        } else {
            InvoiceOriginalFormControl.disableField(enableSet, disableSet, "num");
        }
        if (isFrom) {
            if ("0".equals(plugin.getView().getModel().getValue("hsbz"))) {
                InvoiceOriginalFormControl.enableField(enableSet, disableSet, "fromamount");
                InvoiceOriginalFormControl.disableField(enableSet, disableSet, "fromtaxamount", "amount", "fromprice", "fromtaxprice", "fromtax", "taxamount");
            } else {
                InvoiceOriginalFormControl.disableField(enableSet, disableSet, "fromamount", "taxamount", "fromprice", "fromtaxprice", "fromtax", "amount");
                InvoiceOriginalFormControl.enableField(enableSet, disableSet, "fromtaxamount");
            }
        } else if ("0".equals(plugin.getView().getModel().getValue("hsbz"))) {
            InvoiceOriginalFormControl.enableField(enableSet, disableSet, "amount");
            InvoiceOriginalFormControl.disableField(enableSet, disableSet, "taxamount");
        } else {
            InvoiceOriginalFormControl.disableField(enableSet, disableSet, "amount");
            InvoiceOriginalFormControl.enableField(enableSet, disableSet, "taxamount");
        }
    }

    private static void enableField(Set<String> enableSet, Set<String> disableSet, String ... fields) {
        for (String field : fields) {
            enableSet.add(field);
            disableSet.remove(field);
        }
    }

    private static void disableField(Set<String> enableSet, Set<String> disableSet, String ... fields) {
        for (String field : fields) {
            disableSet.add(field);
            enableSet.remove(field);
        }
    }

    public static void editableInfluence(DynamicObjectCollection itemList, Object editable, AbstractFormPlugin plugin) {
        if ("1".equals(editable)) {
            for (int i = 0; i < itemList.size(); ++i) {
                plugin.getView().setEnable(Boolean.FALSE, i, new String[]{"num", "amount", "taxamount", "unitprice", "taxrate", "taxratecodeid", "materielfield", "expenseitem", "goodsid", "taxunitprice"});
            }
            plugin.getView().setVisible(Boolean.FALSE, new String[]{"itemdel"});
        } else {
            for (int i = 0; i < itemList.size(); ++i) {
                plugin.getView().setEnable(Boolean.TRUE, i, new String[]{"num", "amount", "taxamount", "unitprice", "taxrate", "taxratecodeid", "materielfield", "expenseitem", "goodsid"});
            }
            plugin.getView().setVisible(Boolean.TRUE, new String[]{"itemdel"});
        }
    }

    public static void itemEditAble(DynamicObjectCollection itemList, Boolean editAble, AbstractFormPlugin plugin) {
        for (int i = 0; i < itemList.size(); ++i) {
            plugin.getView().setEnable(editAble, i, new String[]{"tax"});
        }
    }

    public static void editModelNumRate(PropertyChangedArgs e, AbstractFormPlugin plugin, int editIndex) {
        Object value;
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        BigDecimal newValue = (BigDecimal)changeData.getNewValue();
        BigDecimal oldValue = (BigDecimal)changeData.getOldValue();
        if (!BigDecimalUtil.greaterZero((BigDecimal)newValue)) {
            model.setValue("modelnumrate", (Object)oldValue);
            return;
        }
        BigDecimal oriNum = (BigDecimal)model.getValue("orinum", editIndex);
        model.beginInit();
        BigDecimal numValue = UnitPriceHelper.getNumValue((BigDecimal)oriNum.multiply(newValue));
        model.setValue("num", (Object)numValue, editIndex);
        model.setValue("remainvalidnum", (Object)numValue, editIndex);
        BigDecimal fromTaxAmount = (BigDecimal)model.getValue("fromtaxamount");
        BigDecimal fromAmount = (BigDecimal)model.getValue("fromamount");
        BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount");
        BigDecimal amount = (BigDecimal)model.getValue("amount");
        DynamicObject fromCurr = (DynamicObject)model.getValue("fromcurr");
        if (CurrencyHelper.isFrom((Object)fromCurr)) {
            int pricePrecision = fromCurr.getInt("priceprecision");
            BigDecimal fromTaxPrice = fromTaxAmount.divide(numValue, pricePrecision, RoundingMode.HALF_UP);
            BigDecimal fromPrice = fromAmount.divide(numValue, pricePrecision, RoundingMode.HALF_UP);
            model.setValue("fromtaxprice", (Object)fromTaxPrice, editIndex);
            model.setValue("fromprice", (Object)fromPrice, editIndex);
        }
        boolean isAllEle = AllEleAuthHelper.isElePaper((Object)(value = model.getValue("iselepaper"))) || InvoiceUtils.isAllEInvoice((Object)((String)model.getValue("invoicetype")));
        BigDecimal taxPrice = PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)numValue, (boolean)isAllEle);
        BigDecimal price = PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)numValue, (boolean)isAllEle);
        model.setValue("taxunitprice", (Object)taxPrice, editIndex);
        model.setValue("unitprice", (Object)price, editIndex);
        BigDecimal oriModelrate = (BigDecimal)model.getValue("orimodelnumrate");
        BigDecimal currentModelrate = oriModelrate.divide(newValue);
        model.setValue("CURRENTMODELNUMRATE", (Object)currentModelrate);
        model.endInit();
        view.updateView("fromtaxprice", editIndex);
        view.updateView("fromprice", editIndex);
        view.updateView("taxunitprice", editIndex);
        view.updateView("unitprice", editIndex);
        view.updateView("num", editIndex);
        view.updateView("remainvalidnum", editIndex);
        view.updateView("CURRENTMODELNUMRATE", editIndex);
        view.updateView("num", editIndex);
    }

    public static void enableUnitChange(DynamicObjectCollection itemList, AbstractFormPlugin plugin) {
    }

    public static void editExchangeRte(AbstractFormPlugin plugin, String quotation, BigDecimal exchangeRate) {
        IDataModel model = plugin.getView().getModel();
        model.beginInit();
        DynamicObjectCollection items = model.getEntryEntity("sim_original_bill_item");
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalInvoiceAmount = BigDecimal.ZERO;
        Object hsbz = model.getValue("hsbz");
        boolean isIncludeTax = "1".equals(hsbz);
        Object value = model.getValue("iselepaper");
        boolean isAllEle = AllEleAuthHelper.isElePaper((Object)value) || InvoiceUtils.isAllEInvoice((Object)((String)model.getValue("invoicetype")));
        for (int i = 0; i < items.size(); ++i) {
            DynamicObject item = (DynamicObject)items.get(i);
            BigDecimal fromTaxAmount = item.getBigDecimal("fromtaxamount");
            BigDecimal itemTaxAmount = CurrencyHelper.calToAmount((String)quotation, (BigDecimal)exchangeRate, (BigDecimal)fromTaxAmount);
            String taxRate = item.getString("taxrate");
            BigDecimal amountPercent = BigDecimal.ONE.divide(BigDecimal.ONE.add(new BigDecimal(taxRate)), 20, RoundingMode.HALF_UP);
            BigDecimal itemAmount = itemTaxAmount.multiply(amountPercent).setScale(2, RoundingMode.HALF_UP);
            BigDecimal itemTax = itemTaxAmount.subtract(itemAmount);
            BigDecimal num = item.getBigDecimal("num");
            if (BigDecimalUtil.greaterZero((BigDecimal)num)) {
                BigDecimal price = PriceHelper.calcPriceOrNum((BigDecimal)itemAmount, (BigDecimal)num, (boolean)isAllEle);
                BigDecimal taxPrice = PriceHelper.calcPriceOrNum((BigDecimal)itemTaxAmount, (BigDecimal)num, (boolean)isAllEle);
                model.setValue("unitprice", (Object)price, i);
                model.setValue("oriunitprice", (Object)price, i);
                model.setValue("taxunitprice", (Object)taxPrice, i);
            }
            model.setValue("taxamount", (Object)itemTaxAmount, i);
            model.setValue("tax", (Object)itemTax, i);
            model.setValue("amount", (Object)itemAmount, i);
            if (isIncludeTax) {
                model.setValue("remainvalidamount", (Object)itemTaxAmount, i);
            } else {
                model.setValue("remainvalidamount", (Object)itemAmount, i);
            }
            model.setValue("remainvalidtax", (Object)itemTax, i);
            model.setValue("combinelocalamount", (Object)itemTaxAmount, i);
            totalTax = totalTax.add(itemTax);
            totalInvoiceAmount = totalInvoiceAmount.add(itemAmount);
        }
        model.setValue("totalamount", (Object)totalInvoiceAmount.add(totalTax));
        model.setValue("totaltax", (Object)totalTax);
        model.setValue("invoiceamount", (Object)totalInvoiceAmount);
        model.setValue("oldtotalamount", (Object)totalInvoiceAmount.add(totalTax));
        model.setValue("surplusamount", (Object)totalInvoiceAmount);
        model.setValue("surplustax", (Object)totalTax);
        model.endInit();
        InvoiceOriginalFormControl.updateItemFields(plugin, "unitprice", "taxunitprice", "taxamount", "tax", "amount", "remainvalidamount", "remainvalidtax", "combinelocalamount", "oriunitprice");
        InvoiceOriginalFormControl.updateHeadFields(plugin, "totalamount", "totaltax", "invoiceamount", "oldtotalamount", "surplusamount", "surplustax");
    }

    private static void updateHeadFields(AbstractFormPlugin plugin, String ... params) {
        for (String param : params) {
            plugin.getView().updateView(param);
        }
    }

    private static void updateItemFields(AbstractFormPlugin plugin, String ... params) {
        DynamicObjectCollection items = plugin.getView().getModel().getEntryEntity("sim_original_bill_item");
        IFormView view = plugin.getView();
        for (int i = 0; i < items.size(); ++i) {
            for (String param : params) {
                view.updateView(param, i);
            }
        }
    }

    public static void updateExrate(AbstractFormPlugin plugin) {
        IFormView view = plugin.getView();
        DynamicObject fromCurr = (DynamicObject)view.getModel().getValue("fromcurr");
        DynamicObject toCurr = (DynamicObject)view.getModel().getValue("tocurr");
        DynamicObject exrateTable = (DynamicObject)view.getModel().getValue("exratetable");
        Date date = (Date)view.getModel().getValue("exchangedate");
        String quotation = (String)view.getModel().getValue("quotation");
        if (null == fromCurr || null == toCurr || null == exrateTable || null == date || StringUtils.isBlank((Object)quotation)) {
            return;
        }
        InvoiceOriginalFormControl.setExrateValue(plugin, fromCurr, toCurr, exrateTable, date, quotation);
    }

    private static void setExrateValue(AbstractFormPlugin plugin, DynamicObject fromCurr, DynamicObject toCurr, DynamicObject exrateTable, Date usefulDate, String quotation) {
        BigDecimal exrateValue = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)((Long)fromCurr.getPkValue()), (Long)((Long)toCurr.getPkValue()), (Long)((Long)exrateTable.getPkValue()), (Date)usefulDate, (boolean)"0".equals(quotation));
        IFormView view = plugin.getView();
        if (null == exrateValue) {
            view.getModel().beginInit();
            view.getModel().setValue("exrate", null);
            view.getModel().endInit();
            view.updateView("exrate");
            return;
        }
        view.getModel().setValue("exrate", (Object)exrateValue);
    }

    public static void dealCheckTravelerItemMethod(String billNo, DynamicObjectCollection itemObjectCollection, DynamicObjectCollection dynamicObjectCollection) {
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            return;
        }
        int count = BillValidaterHelper.countItemNumMethod(itemObjectCollection, null);
        if (count > 1) {
            String errorMsg = ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u53ea\u652f\u6301\u4e00\u884c\u5546\u54c1\u660e\u7ec6", (String)"BillValidaterHelper_129", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new MsgException(errorMsg);
        }
        String templateErrorType = InvoiceCheckService.BILL_ERROR_TEMPLATE();
        for (int rowIndex = 0; rowIndex < dynamicObjectCollection.size(); ++rowIndex) {
            DynamicObject travelObject = (DynamicObject)dynamicObjectCollection.get(rowIndex);
            int seq = rowIndex + 1;
            String traveler = travelObject.getString("traveler");
            String travlerError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u884c\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_44", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull((String)traveler, (String)String.format(templateErrorType, billNo, travlerError));
            String travlerLenError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u884c\u4eba\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_45", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen((String)traveler, (Integer)20, (String)String.format(templateErrorType, billNo, travlerLenError));
            String cardType = travelObject.getString("travelercardtype");
            String cardTypeError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u884c\u4eba\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_46", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull((String)cardType, (String)String.format(templateErrorType, billNo, cardTypeError));
            String cardTypeLenError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u884c\u4eba\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_47", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen((String)cardType, (Integer)20, (String)String.format(templateErrorType, billNo, cardTypeLenError));
            String cardNo = travelObject.getString("travelercardno");
            String cardNoError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u884c\u4eba\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_48", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull((String)cardNo, (String)String.format(templateErrorType, billNo, cardNoError));
            String cardNoLenError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u884c\u4eba\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_49", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen((String)cardNo, (Integer)20, (String)String.format(templateErrorType, billNo, cardNoLenError));
            Date travel_date = travelObject.getDate("traveldate");
            if (travel_date == null) {
                String travelDateError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u884c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_50", (String)"imc-sim-common", (Object[])new Object[0]), seq);
                String msg = String.format(templateErrorType, billNo, travelDateError);
                throw new MsgException(msg);
            }
            String travelDate = DateUtils.format((Date)travel_date);
            String travelDateLenError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u884c\u65e5\u671f\u4e0d\u80fd\u8d85\u8fc740\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_51", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen((String)travelDate, (Integer)40, (String)String.format(templateErrorType, billNo, travelDateLenError));
            String startPlace = travelObject.getString("travelerstartplace");
            String startPlaceError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u53d1\u5730\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_52", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull((String)startPlace, (String)String.format(templateErrorType, billNo, startPlaceError));
            String startPlaceLenError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u53d1\u5730\u4e0d\u80fd\u8d85\u8fc780\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_53", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen((String)startPlace, (Integer)80, (String)String.format(templateErrorType, billNo, startPlaceLenError));
            String endPlace = travelObject.getString("travelerendplace");
            String endPlaceError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5230\u8fbe\u5730\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_54", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull((String)endPlace, (String)String.format(templateErrorType, billNo, endPlaceError));
            String endPlaceLenError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5230\u8fbe\u5730\u4e0d\u80fd\u8d85\u8fc780\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_55", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen((String)endPlace, (Integer)80, (String)String.format(templateErrorType, billNo, endPlaceLenError));
            String transportType = travelObject.getString("travelertransporttype");
            String transportTypeError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4ea4\u901a\u5de5\u5177\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_56", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull((String)transportType, (String)String.format(templateErrorType, billNo, transportTypeError));
            String transportTypeLenError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4ea4\u901a\u5de5\u5177\u7c7b\u578b\u4e0d\u80fd\u8d85\u8fc780\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_57", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen((String)transportType, (Integer)80, (String)String.format(templateErrorType, billNo, transportTypeLenError));
            String seatClass = travelObject.getString("travelerseatclass");
            if (!TransportTypeEnum.FLIGHT.getCode().equals(transportType) && !TransportTypeEnum.TRAIN.getCode().equals(transportType) && !TransportTypeEnum.SHIP.getCode().equals(transportType)) continue;
            String seatClassError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceAllESpecialCheckService_58", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkNull((String)seatClass, (String)String.format(templateErrorType, billNo, seatClassError));
            String seatClassLenError = String.format(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u660e\u7ec6\u7b2c%s\u884c\uff0c\u7b49\u7ea7\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26", (String)"InvoiceAllESpecialCheckService_59", (String)"imc-sim-common", (Object[])new Object[0]), seq);
            InvoiceCheckService.checkLen((String)seatClass, (Integer)20, (String)String.format(templateErrorType, billNo, seatClassLenError));
        }
    }

    public static void dealCheckTransportTypeMethod(DynamicObjectCollection dynamicObjectCollection) {
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            return;
        }
        for (int rowIndex = 0; rowIndex < dynamicObjectCollection.size(); ++rowIndex) {
            DynamicObject travelObject = (DynamicObject)dynamicObjectCollection.get(rowIndex);
            String transportType = travelObject.getString("travelertransporttype");
            String seatClass = travelObject.getString("travelerseatclass");
            int row = rowIndex + 1;
            if (!TransportTypeEnum.FLIGHT.getCode().equals(transportType) && !TransportTypeEnum.TRAIN.getCode().equals(transportType) && !TransportTypeEnum.SHIP.getCode().equals(transportType)) continue;
            if (StringUtils.isBlank((CharSequence)seatClass)) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7b2c%s\u884c\u7684\u5ea7\u4f4d\u7b49\u7ea7\u4e3a\u7a7a\uff01", (String)"InvoiceOriginalFormPlugin_49", (String)"imc-sim-formplugin", (Object[])new Object[0]), row);
                throw new KDBizException(errorMsg);
            }
            List list = SeatClassTypeEnum.getSeatClassNameByCode((String)transportType);
            if (list.contains(seatClass)) continue;
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7b2c%s\u884c\u7684\u4ea4\u901a\u5de5\u5177\u7c7b\u4e0e\u5ea7\u4f4d\u7b49\u7ea7\u4e24\u8005\u4e0d\u5339\u914d\uff01", (String)"InvoiceOriginalFormPlugin_50", (String)"imc-sim-formplugin", (Object[])new Object[0]), row);
            throw new KDBizException(errorMsg);
        }
    }
}

