/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.control;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageTypes;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.dto.BillCheckProcessDto;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.file.util.Handle;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.AbstractBillSplitServiceImpl;
import kd.imc.sim.formplugin.issuing.helper.IssueInvoiceControlHelper;

public class OriginalBillPluginIssueControl {
    private static final Log LOGGER = LogFactory.getLog(OriginalBillPluginIssueControl.class);
    private static final String SIM_ISSUE_RESULT = "sim_issue_result";

    public static DynamicObject genWaitInvoice(DynamicObject redInfo) {
        return OriginalBillPluginIssueControl.genWaitInvoice(redInfo, false);
    }

    public static DynamicObject genWaitInvoice(DynamicObject redInfo, boolean isNew) {
        DynamicObject waitInvoice = null;
        if (!isNew) {
            waitInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("infocode", "=", (Object)redInfo.getString("infocode")).and("invoicestatus", "!=", (Object)"6").toArray());
        }
        if (waitInvoice == null) {
            waitInvoice = RedInfoHelper.redInfoToInvoice((DynamicObject)redInfo);
            AbstractBillSplitServiceImpl.buildMainInvoiceData(waitInvoice);
            waitInvoice.set("buyertype", (Object)(redInfo.getString("infosource").equalsIgnoreCase("6") ? "11" : "4"));
            waitInvoice.set("billdate", (Object)new Date());
            waitInvoice.set("invoicecode", (Object)"");
            waitInvoice.set("invoiceno", (Object)"");
            waitInvoice.set("orderno", (Object)redInfo.getString("orderno"));
            waitInvoice.set("taxedtype", (Object)TaxedTypeEnum.normal.getValue());
        }
        return waitInvoice;
    }

    public static void issuePush(AbstractFormPlugin plugin, Object[] pks, Map<String, Object> returnData) {
        String labelTitleStr;
        HashMap handleMap;
        StringBuilder msg = new StringBuilder();
        DynamicObject[] bills = OriginalBillPluginIssueControl.loadBillPage(pks);
        int sum = bills.length;
        int success = 0;
        int error = 0;
        boolean is2MQ = Boolean.parseBoolean(String.valueOf(returnData.get("is2MQ")));
        String deviceNo = (String)returnData.get("deviceNo");
        String terminalNo = (String)returnData.get("terminalNo");
        String account = (String)returnData.get("account");
        boolean isMergeBill = Boolean.parseBoolean(String.valueOf(returnData.get("isMergeBill")));
        boolean isMergeBillDetail = Boolean.parseBoolean(String.valueOf(returnData.get("isMergeBillDetail")));
        if (isMergeBill) {
            BotpHelper.checkBillsComplete((DynamicObject[])bills);
        }
        ArrayList<HashMap> handleList = new ArrayList<HashMap>(bills.length);
        ArrayList verificationBills = Lists.newArrayList();
        BillCheckProcessDto process = new BillCheckProcessDto(Boolean.TRUE);
        for (DynamicObject bill : bills) {
            handleMap = Maps.newHashMap();
            ApiResult apiResult = BillValidaterHelper.validBillInvoice(bill, false, process);
            if (!apiResult.getSuccess()) {
                handleMap.put("status", ResManager.loadKDString((String)"\u5931\u8d25", (String)"OriginalBillPluginIssueControl_0", (String)"imc-sim-service", (Object[])new Object[0]));
                handleMap.put("message", apiResult.getMessage());
                msg.append(String.format("%s:%s\u3002<br>", bill.getString("billno"), apiResult.getMessage()));
                ++error;
                handleList.add(handleMap);
                continue;
            }
            verificationBills.add(bill);
        }
        if (verificationBills.size() > 0) {
            DynamicObject[] billArr = new DynamicObject[verificationBills.size()];
            boolean isLqptChannel = EnterpriseHelper.isLqptChannel((String)((DynamicObject)verificationBills.get(0)).getString("salertaxno"));
            for (int i = 0; i < verificationBills.size(); ++i) {
                billArr[i] = (DynamicObject)verificationBills.get(i);
                billArr[i].set("jqbh", (Object)deviceNo);
                billArr[i].set("terminalno", (Object)terminalNo);
                billArr[i].set("account", (Object)account);
                if (!Handle.isNotEmpty((Object)account) || isLqptChannel) continue;
                billArr[i].set("drawer", (Object)AllEleAuthHelper.getDrawerByAccount((String)billArr[i].getString("salertaxno"), (String)account));
            }
            try {
                Map<String, Object> map = IssueInvoiceControlHelper.issueInvoice(billArr, deviceNo, terminalNo, account, is2MQ ? 1 : 0, isMergeBill, isMergeBillDetail);
                Map failedInfo = (Map)map.get("failedInfo");
                success = billArr.length - failedInfo.size();
                error += failedInfo.size();
                for (DynamicObject verificationBill : verificationBills) {
                    Object message = failedInfo.get(verificationBill.getPkValue().toString());
                    if (null == message) {
                        message = failedInfo.get(verificationBill.getString("billno"));
                    }
                    String billNo = verificationBill.getString("billno");
                    handleMap = Maps.newHashMap();
                    handleMap.put("billno", billNo);
                    if (failedInfo.containsKey(verificationBill.getPkValue().toString())) {
                        msg.append(String.format(ResManager.loadKDString((String)"%1$s:\u5355\u636e\u63d0\u4ea4\u5931\u8d25\u3002%2$s", (String)"OriginalBillPluginIssueControl_1", (String)"imc-sim-service", (Object[])new Object[0]), billNo, message));
                        handleMap.put("status", ResManager.loadKDString((String)"\u5931\u8d25", (String)"OriginalBillPluginIssueControl_0", (String)"imc-sim-service", (Object[])new Object[0]));
                        handleMap.put("message", message);
                    } else if (failedInfo.containsKey(verificationBill.getString("billno"))) {
                        msg.append(message);
                        handleMap.put("status", ResManager.loadKDString((String)"\u5931\u8d25", (String)"OriginalBillPluginIssueControl_0", (String)"imc-sim-service", (Object[])new Object[0]));
                        handleMap.put("message", message);
                    } else {
                        if (BillHelper.isRedInfo((DynamicObject)verificationBill) && !AllEleAuthHelper.isElePaper((Object)verificationBill.getString("iselepaper"))) {
                            handleMap.put("message", ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u81f3\u7ea2\u5b57\u8868\u5217\u8868", (String)"OriginalBillPluginIssueControl_2", (String)"imc-sim-service", (Object[])new Object[0]));
                        } else {
                            handleMap.put("message", ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u81f3\u5f85\u5f00\u53d1\u7968\u5217\u8868", (String)"OriginalBillPluginIssueControl_3", (String)"imc-sim-service", (Object[])new Object[0]));
                        }
                        handleMap.put("status", ResManager.loadKDString((String)"\u6210\u529f", (String)"OriginalBillPluginIssueControl_4", (String)"imc-sim-service", (Object[])new Object[0]));
                    }
                    handleList.add(handleMap);
                }
            }
            catch (MsgException e) {
                LOGGER.error("\u63d0\u4ea4\u5931\u8d25\uff1a", (Throwable)e);
                String message = ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u660e\u7ec6\u8d85\u8fc7\u7a0e\u63a7\u5c3e\u5dee\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u540e\u5f00\u7968\u3002", (String)"OriginalBillPluginIssueControl_5", (String)"imc-sim-service", (Object[])new Object[0]);
                if ("mergeMoreThanTaxControl".equals(e.getErrorCode())) {
                    message = ResManager.loadKDString((String)"\u5355\u636e\u7684\u660e\u7ec6\u5408\u5e76\u540e\u8d85\u8fc7\u7a0e\u63a7\u5141\u8bb8\u7684\u5c3e\u5dee\uff0c\u65e0\u6cd5\u5408\u5e76\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u5355\u636e\u6216\u5728\u3010\u53d1\u7968\u62c6\u5408\u8bbe\u7f6e\u3011\u4e2d\u91cd\u65b0\u914d\u7f6e\u5408\u5e76\u89c4\u5219\u3002", (String)"OriginalBillPluginIssueControl_6", (String)"imc-sim-service", (Object[])new Object[0]);
                }
                plugin.getView().showMessage(message, e.getErrorMsg(), MessageTypes.Commit);
                return;
            }
            catch (Exception e) {
                LOGGER.error("\u63d0\u4ea4\u5931\u8d25\uff1a", (Throwable)e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25,%s", (String)"OriginalBillPluginIssueControl_7", (String)"imc-sim-service", (Object[])new Object[0]), e.getMessage()));
            }
        }
        if (BillHelper.isRedInfo((DynamicObject)bills[0])) {
            labelTitleStr = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5171\u63d0\u4ea4%1$s\u5f20\u5355\u636e\uff0c\u63d0\u4ea4\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002\u8bf7\u524d\u5f80\u7ea2\u5b57\u4fe1\u606f\u8868\u5217\u8868\u64cd\u4f5c\u7ea2\u51b2\u3002", (String)"OriginalBillPluginIssueControl_15", (String)"imc-sim-service", (Object[])new Object[0]), sum, success, error);
        } else {
            String first = ResManager.loadKDString((String)"\u672c\u6b21\u5171\u63d0\u4ea4%1$s\u5f20\u5355\u636e\uff0c\u63d0\u4ea4\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"OriginalBillPluginIssueControl_14", (String)"imc-sim-service", (Object[])new Object[0]);
            labelTitleStr = success > 0 ? String.format(first.concat(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u5df2\u5f00\u53d1\u7968\u67e5\u8be2\u5f00\u5177\u6210\u529f\u7684\u53d1\u7968\uff0c\u5f85\u5f00\u53d1\u7968\u5217\u8868\u67e5\u770b\u5f00\u5177\u4e2d\u7684\u53d1\u7968\u3002", (String)"OriginalBillPluginIssueControl_8", (String)"imc-sim-service", (Object[])new Object[0])), sum, success, error) : String.format(first, sum, success, error);
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("title", labelTitleStr);
        customParams.put("msg", msg.toString());
        customParams.put("hasMore", sum > 5);
        customParams.put("listdata", handleList);
        ViewUtil.openDialog((AbstractFormPlugin)plugin, customParams, (String)SIM_ISSUE_RESULT, (String)"quick_issue");
    }

    private static DynamicObject[] loadBillPage(Object[] billIds) {
        String fields = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)true);
        String orderby = "originbillseq desc";
        int size = BigDecimalUtil.transDecimal((Object)ImcConfigUtil.getValue((String)"sim_orginal_bill_query", (String)"sim_orginal_bill_query_size")).intValue();
        if (size > 1) {
            DynamicObject[] dataArray;
            long start = System.currentTimeMillis();
            ArrayList<Object> list = new ArrayList<Object>(size);
            ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(size);
            for (int i = 0; i < billIds.length; ++i) {
                if (i % size == 0 && !list.isEmpty()) {
                    DynamicObject[] dataArray2 = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)fields, (QFilter[])new QFilter("id", "in", list).toArray(), (String)orderby);
                    if (dataArray2 != null) {
                        DynamicObject[] dynamicObjectArray = dataArray2;
                        int n = dynamicObjectArray.length;
                        for (int j = 0; j < n; ++j) {
                            DynamicObject obj = dynamicObjectArray[j];
                            dataList.add(obj);
                        }
                    }
                    list.clear();
                }
                list.add(billIds[i]);
            }
            if (!list.isEmpty() && (dataArray = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)fields, (QFilter[])new QFilter("id", "in", list).toArray(), (String)orderby)) != null) {
                for (DynamicObject obj : dataArray) {
                    dataList.add(obj);
                }
            }
            LOGGER.info("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u5355\u6570\u91cf:" + billIds.length + ",\u5206\u9875:" + size + ",\u8017\u65f6:" + (System.currentTimeMillis() - start));
            return dataList.toArray(new DynamicObject[0]);
        }
        return BusinessDataServiceHelper.load((String)"sim_original_bill", (String)fields, (QFilter[])new QFilter("id", "in", (Object)billIds).toArray(), (String)orderby);
    }

    public static boolean checkBillDev(DynamicObject[] dynamicObjects) {
        HashSet devSet = Sets.newHashSetWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (InvoiceUtils.isAllEInvoice((Object)dynamicObject.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)dynamicObject.getString("iselepaper"))) continue;
            devSet.add(dynamicObject.getString("jqbh"));
        }
        return devSet.size() <= 1;
    }

    public static void checkOnlyType(DynamicObject[] dynamicObjects) {
        HashSet invoiceTypeSet = Sets.newHashSet();
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (InvoiceUtils.isAllEInvoice((Object)dynamicObject.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)dynamicObject.getString("iselepaper"))) {
                invoiceTypeSet.add("ALL_E_INVOICE");
                continue;
            }
            invoiceTypeSet.add("APPRECIATION_INVOICE");
        }
        if (invoiceTypeSet.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u7535\u7968\u4e0d\u80fd\u4e0e\u589e\u503c\u7a0e\u53d1\u7968\u540c\u65f6\u64cd\u4f5c", (String)"OriginalBillPluginIssueControl_9", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }
}

