/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent;

import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AbstractAllEBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AllEBillWorkbenchCacheHelper;

public class AllEBillIssueResultTabCustomEvent
extends AbstractAllEBillWorkbenchCustomEvent {
    private static final ImmutableSet<String> showDetialSet = new ImmutableSet.Builder().add((Object[])new String[]{"issuestatus", "billno", "invoiceno", "totalamount"}).add((Object[])new String[]{"invoicetype", "buyername", "result", "id"}).build();

    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        switch (eventName) {
            case "result/positive/showDetail": 
            case "result/negative/showDetail": {
                this.showDetail(that, eventName, new HashMap<String, Object>(4));
                break;
            }
            case "result/reIssue": {
                this.reIssue(that, eventArgs);
            }
        }
    }

    private void reIssue(AbstractFormPlugin that, String id) {
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])new QFilter("id", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)id)).toArray());
        if (invoice != null) {
            IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])new DynamicObject[]{invoice});
            this.showDetail(that, invoice.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) > 0 ? "result/positive/showDetail" : "result/negative/showDetail", new HashMap<String, Object>(4));
        }
    }

    void showDetail(AbstractFormPlugin that, String eventKey, Map<String, Object> map) {
        List<Long> ids = eventKey.equals("result/positive/showDetail") ? AllEBillWorkbenchCacheHelper.getCacheInvoiceIdList(that, "invoiceIdPks") : AllEBillWorkbenchCacheHelper.getCacheInvoiceIdList(that, "redInvoiceIdPks");
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"sim_vatinvoice", (String)String.join((CharSequence)",", showDetialSet), (QFilter[])new QFilter("id", "in", ids).toArray());
        AllEBillIssueResultTabCustomEvent.getIssueResultMap(that, (DynamicObject[])invoices.toArray((Object[])new DynamicObject[0]), false, eventKey, map);
    }

    static void getIssueResultMap(AbstractFormPlugin that, DynamicObject[] invoices, boolean clearMapKey, String eventKey, Map<String, Object> rMap) {
        ArrayList<Map<String, Object>> invoiceList = new ArrayList<Map<String, Object>>(invoices.length);
        int issueCount = 0;
        for (DynamicObject invoice : invoices) {
            invoiceList.add(AllEBillIssueResultTabCustomEvent.createInvoiceMap(invoice, clearMapKey));
            String issueStatus = invoice.getString("issuestatus");
            if (!IssueStatusEnum.ok.getCode().equals(issueStatus) && !IssueStatusEnum.failed.getCode().equals(issueStatus)) continue;
            ++issueCount;
        }
        rMap.put("isComplete", issueCount == invoices.length);
        rMap.put("result", invoiceList);
        AllEBillIssueResultTabCustomEvent.putPageCache(that, eventKey, issueCount == invoices.length ? "1" : "0");
        if (eventKey.equals("result/positive/showDetail")) {
            rMap.put("invoicecount", AllEBillIssueResultTabCustomEvent.getPageCacheVal(that, "blueInvoiceCount"));
        } else {
            rMap.put("invoicecount", AllEBillIssueResultTabCustomEvent.getPageCacheVal(that, "redInvoiceCount"));
        }
        if (StringUtils.isNotBlank((CharSequence)AllEBillWorkbenchCacheHelper.getCurrentSellerTaxNo(that))) {
            rMap.put("creditQuota", CacheHelper.get((String)("creditQuota_" + AllEBillWorkbenchCacheHelper.getCurrentSellerTaxNo(that))));
        }
        AllEBillIssueResultTabCustomEvent.updateCustomControl(that, rMap, eventKey);
    }

    private static Map<String, Object> createInvoiceMap(DynamicObject invoice, boolean clearMapKey) {
        Map invoiceMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)invoice, (boolean)true);
        if (!clearMapKey) {
            return invoiceMap;
        }
        HashSet keys = new HashSet(invoiceMap.keySet());
        for (String key : keys) {
            if (showDetialSet.contains((Object)key)) continue;
            invoiceMap.remove(key);
        }
        return invoiceMap;
    }
}

