/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.formplugin.bill.originalbill.util.BillIssueResultTabCustomEventUtil;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.pluginworkutils.WorkbenchPrintUtil;

public class BillIssueResultTabCustomEvent
extends AbstractBillWorkbenchCustomEvent {
    private static Log LOGGER = LogFactory.getLog(BillIssueResultTabCustomEvent.class);

    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs eventKey) {
        String event = eventKey.getEventName();
        String params = eventKey.getEventArgs();
        if (StringUtils.isBlank((CharSequence)params)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillIssueResultTabCustomEvent_0", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        switch (event) {
            case "issue/showDetail": {
                this.buildResult(that, params);
                break;
            }
            case "issue/reIssue": {
                this.reIssue(that, event, params);
                break;
            }
            case "issue/paperInvPrint": {
                DynamicObject[] printInvObjs = BillIssueResultTabCustomEvent.getInvObjsByInvId(params);
                WorkbenchPrintUtil.dealInvPrint(that, printInvObjs);
                break;
            }
        }
    }

    private void reIssue(AbstractFormPlugin that, String event, String params) {
        DynamicObject[] invObjs = BillIssueResultTabCustomEvent.getInvObjsByInvId(params);
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("salertaxno", invObjs[0].getString("salertaxno"));
        paramMap.put("eventkey", event);
        paramMap.put("reopenid", params);
        if (InvoiceUtils.isAllEInvoice((Object)invObjs[0].getString("invoicetype")) && AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)that, (Map)paramMap)) {
            return;
        }
        IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])invObjs);
        that.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u91cd\u65b0\u5f00\u7968", (String)"BillIssueResultTabCustomEvent_1", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
    }

    public static DynamicObject[] getInvObjsByInvId(String params) {
        List array = JSONArray.parseArray((String)JSON.parseArray((String)params).toJSONString(), Long.class);
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("id", "in", (Object)array).toArray());
    }

    private void buildResult(AbstractFormPlugin that, String params) {
        try {
            String currentSalerTaxNo = BillIssueResultTabCustomEvent.getPageCacheVal(that, "currentSalerTaxNo");
            Map<String, Object> rMap = BillIssueResultTabCustomEventUtil.buildWorkBenchIssuesResult(currentSalerTaxNo, params);
            BillIssueResultTabCustomEvent.updateCustomControl(that, rMap, "issue/showDetail");
        }
        catch (Exception e) {
            LOGGER.error("\u5de5\u4f5c\u53f0\u6784\u5efa\u5f00\u7968\u7ed3\u679c\u62a5\u9519", (Throwable)e);
            that.getView().showErrorNotification(e.getMessage());
            BillIssueResultTabCustomEvent.updateCustomControlError(that, null, "issue/showDetail");
        }
    }
}

