/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.event;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.dto.merge.MergeRequestDTO;
import kd.imc.bdm.common.dto.merge.MergeResponseDTO;
import kd.imc.bdm.common.dto.split.LimitAmountsDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.RedConfirmHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeHelper;

public class BillTabCustomEvent
extends AbstractBillWorkbenchCustomEvent {
    private static final Log LOGGER = LogFactory.getLog(BillTabCustomEvent.class);

    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs e) {
        String event = e.getEventName();
        String param = e.getEventArgs();
        switch (event) {
            case "bill/showOriginalBill": {
                this.openOriginalBill(that, param);
                break;
            }
            case "bill/mergebill": {
                this.mergeBill(that, param);
                break;
            }
            case "bill/changeJqbh": {
                this.changeJqbh(that, param);
            }
        }
    }

    private void changeJqbh(AbstractFormPlugin that, String jqbh) {
        try {
            String orgIdStr = BillTabCustomEvent.getPageCacheVal(that, "currentOrg");
            DynamicObject devObj = EquipmentUtil.getDevByCode((Long)Long.parseLong(orgIdStr), (String)jqbh);
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)Long.parseLong(orgIdStr));
            List<Object> terminalNos = new ArrayList(1);
            if ("8".equals(devObj.getString("equipmenttype"))) {
                DynamicObject[] equipmentArr = EquipmentUtil.getEquipmentListByDevNo((String)jqbh, (String)saleInfo.getSaleTaxNo());
                terminalNos = Stream.of(equipmentArr).map(e -> e.getString("terminalno")).collect(Collectors.toList());
            }
            LimitAmountsDTO limitAmountsDTO = new LimitAmountsDTO(devObj);
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("jqbh", jqbh);
            map.put("taxequipment", new BillMergeHelper().getItemsMaxTaxDiff(jqbh));
            map.put("limitAmounts", limitAmountsDTO);
            map.put("terminalNos", terminalNos);
            BillTabCustomEvent.updateCustomControl(that, map, "bill/changeJqbh");
        }
        catch (Exception e2) {
            LOGGER.error("\u5207\u6362\u8bbe\u5907\u5931\u8d25", (Throwable)e2);
            BillTabCustomEvent.updateCustomControlError(that, null, "bill/changeJqbh");
            BillTabCustomEvent.handleExcepiton(that, e2);
        }
    }

    private void mergeBill(AbstractFormPlugin that, String param) {
        try {
            MergeResponseDTO mergeResponse;
            JSONObject json = JSONObject.parseObject((String)param);
            List pks = json.getJSONArray("pks").toJavaList(String.class);
            if (CollectionUtils.isEmpty((Collection)pks)) {
                BillTabCustomEvent.updateCustomControlError(that, null, "bill/mergebill");
                this.openNoSelectConfirm(that);
                return;
            }
            String currentUserId = RequestContext.get().getUserId();
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)BillTabCustomEvent.getMergeBillQueryField(), (QFilter[])new QFilter("id", "in", (Object)pks.stream().map(Long::valueOf).toArray()).toArray(), (String)"originbillseq desc");
            HashMap<String, StringBuilder> usedMap = new HashMap<String, StringBuilder>();
            HashMap<Long, String> userPkNameMap = new HashMap<Long, String>();
            for (DynamicObject dynamicObject : bills) {
                this.checkBillUsed(usedMap, userPkNameMap, dynamicObject);
            }
            if (usedMap.size() > 0) {
                String tips = this.generateTips(usedMap);
                throw new KDBizException(tips);
            }
            String deviceNo = json.getString("deviceNo");
            if (!InvoiceUtils.isAllEInvoice((Object)bills[0].getString("invoicetype")) && !AllEleAuthHelper.isElePaper((Object)bills[0].getString("iselepaper")) && StringUtils.isBlank((CharSequence)deviceNo)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8bbe\u5907\uff01", (String)"BillTabCustomEvent_0", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            Boolean mergeBill1 = json.getBoolean("mergeBill");
            if (mergeBill1.booleanValue()) {
                BotpHelper.checkBillsComplete((DynamicObject[])bills);
            }
            boolean isMergeBill = json.getBoolean("mergeBill");
            if (RedConfirmHelper.isRedConfirmBill((DynamicObject)bills[0])) {
                for (DynamicObject bill : bills) {
                    if (!StringUtils.isNotBlank((CharSequence)bill.getString("infocode"))) continue;
                    isMergeBill = false;
                }
            }
            MergeRequestDTO mergeRequestDTO = new MergeRequestDTO.Builder().mergeBill(isMergeBill).mergeBillDetail(json.getBoolean("mergeBillDetail").booleanValue()).setJqbh(deviceNo).bills(bills).build();
            try {
                mergeResponse = new BillMergeHelper().mergeBill(mergeRequestDTO);
            }
            catch (MsgException e) {
                String message = ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u660e\u7ec6\u8d85\u8fc7\u7a0e\u63a7\u5c3e\u5dee\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u540e\u5f00\u7968\u3002", (String)"BillTabCustomEvent_1", (String)"imc-sim-service", (Object[])new Object[0]);
                if ("mergeMoreThanTaxControl".equals(e.getErrorCode())) {
                    message = ResManager.loadKDString((String)"\u5355\u636e\u7684\u660e\u7ec6\u5408\u5e76\u540e\u8d85\u8fc7\u7a0e\u63a7\u5141\u8bb8\u7684\u5c3e\u5dee\uff0c\u65e0\u6cd5\u5408\u5e76\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u5355\u636e\u6216\u5728\u3010\u53d1\u7968\u62c6\u5408\u8bbe\u7f6e\u3011\u4e2d\u91cd\u65b0\u914d\u7f6e\u5408\u5e76\u89c4\u5219\u3002", (String)"BillTabCustomEvent_2", (String)"imc-sim-service", (Object[])new Object[0]);
                }
                that.getView().showMessage(message, e.getErrorMsg(), MessageTypes.Commit);
                BillTabCustomEvent.updateCustomControlError(that, null, "bill/mergebill");
                return;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u5de5\u4f5c\u53f0\u5408\u5e76\u540e\u7684\u5355\u636e\u6570\u91cf\u4e3a : " + mergeResponse.getBills().size());
            }
            HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
            returnMap.put("mergeBill", this.dealMergeBill(mergeResponse.getBills()));
            returnMap.putAll(BillTabCustomEvent.splitCacheBill(that, mergeResponse, deviceNo, null));
            this.handleTaxDeviation(returnMap);
            BillTabCustomEvent.putPageCache(that, "mergeRelations", JSONObject.toJSONString((Object)mergeResponse.getRelations()));
            BillTabCustomEvent.putPageCache(that, "billNoMap", JSONObject.toJSONString((Object)mergeResponse.getBillNoMap()));
            for (String pk : pks) {
                CacheHelper.put((String)(pk + "workbench"), (String)currentUserId);
            }
            BillTabCustomEvent.updateCustomControl(that, returnMap, "bill/mergebill");
        }
        catch (Exception e) {
            LOGGER.error("\u8fdb\u5165\u5355\u636e\u5904\u7406\u9875\u9762\u5931\u8d25", (Throwable)e);
            BillTabCustomEvent.handleExcepiton(that, e);
            BillTabCustomEvent.updateCustomControlError(that, null, "bill/mergebill");
        }
    }

    private void openNoSelectConfirm(AbstractFormPlugin that) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bill/mergebill", (IFormPlugin)that);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"BillTabCustomEvent_3", (String)"imc-sim-service", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u9000\u51fa\u5de5\u4f5c\u53f0", (String)"BillTabCustomEvent_4", (String)"imc-sim-service", (Object[])new Object[0]));
        that.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u5f00\u7968\u5355\u636e\uff0c\u8bf7\u9000\u51fa\u5de5\u4f5c\u53f0\u91cd\u65b0\u9009\u53d6\u5355\u636e", (String)"BillTabCustomEvent_5", (String)"imc-sim-service", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    private void openOriginalBill(AbstractFormPlugin that, String pk) {
        if (StringUtils.isBlank((CharSequence)pk)) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u65e0\u6b64\u5355\u636e", (String)"BillTabCustomEvent_6", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        if (!QueryServiceHelper.exists((String)"sim_original_bill", (Object)Long.valueOf(pk))) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u65e0\u6b64\u5355\u636e", (String)"BillTabCustomEvent_6", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        BillShowParameter listParam = new BillShowParameter();
        listParam.setPkId((Object)pk);
        listParam.setStatus(OperationStatus.VIEW);
        listParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listParam.setFormId("sim_original_bill");
        listParam.setCustomParam("source", (Object)"workbench");
        that.getView().showForm((FormShowParameter)listParam);
    }
}

