/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.pluginworkutils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.CheckPhoneEnum;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.BillDetailVo;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.dto.merge.MergeResponseDTO;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.InvoiceValidHelper;
import kd.imc.bdm.common.helper.MsgSendAuthHelper;
import kd.imc.bdm.common.helper.RedConfirmHelper;
import kd.imc.bdm.common.helper.cache.MsgAuthSettingCacheHelper;
import kd.imc.bdm.common.helper.invoice.RemarkTemplateHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceQueryUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.ZeroTaxMarkUtil;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginIssueControl;
import kd.imc.sim.formplugin.bill.originalbill.util.Dto.CheckResult;
import kd.imc.sim.formplugin.bill.originalbill.util.OriginalBillFormEditUtil;
import kd.imc.sim.formplugin.bill.originalbill.workbench.dto.BillPreviewStatisticsDTO;
import kd.imc.sim.formplugin.bill.originalbill.workbench.dto.WorkbenchIssueContentDTO;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillInvoiceRelationHelper;
import kd.imc.sim.formplugin.issuing.helper.IssueInvoiceControlHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class BillProcessTabUtil {
    private static final Log LOGGER = LogFactory.getLog(BillProcessTabUtil.class);

    public static Map<String, String> getDefaultRuleMap() {
        return ImcConfigUtil.getValue((String)"sim_default_rule_map");
    }

    public static void handleCustomEventBlueCode(AbstractFormPlugin _this, ClosedCallBackEvent event) {
        if (null == event.getReturnData()) {
            return;
        }
        ListSelectedRowCollection list = (ListSelectedRowCollection)event.getReturnData();
        if (list.size() == 0) {
            return;
        }
        Object objId = list.get(0).getPrimaryKeyValue();
        QFilter filter = new QFilter("id", "=", objId);
        DynamicObject vatObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "invoicecode", "invoiceno", "issuetime", "invoicetype"), (QFilter[])filter.toArray());
        if (vatObj == null) {
            return;
        }
        WorkbenchIssueContentDTO issueContent = (WorkbenchIssueContentDTO)JSONObject.parseObject((String)AbstractBillWorkbenchCustomEvent.getPageCacheVal(_this, "workbenchIssueContent"), WorkbenchIssueContentDTO.class);
        JSONObject invoice = issueContent.getBillIdInvoiceMap().getJSONArray(issueContent.getMergeBillId()).getJSONObject(0);
        BillProcessTabUtil.setChooseBlueInvoiceCache(vatObj, invoice, _this);
        invoice.put("originalinvoicecode", (Object)vatObj.getString("invoicecode"));
        invoice.put("originalinvoiceno", (Object)vatObj.getString("invoiceno"));
        invoice.put("originalissuetime", (Object)vatObj.getString("issuetime"));
        invoice.put("originalinvoicetype", (Object)vatObj.getString("invoicetype"));
        invoice.put("redreason", (Object)"2");
        String remark = invoice.getString("remark");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)remark)) {
            String regex = "\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801:(\\d{10}|\\d{12}) \u53f7\u7801:\\d{8}";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(remark);
            remark = matcher.replaceAll("");
        }
        invoice.put("remark", (Object)remark);
        HashMap customMap = Maps.newHashMap();
        customMap.put("data", issueContent.getBillIdInvoiceMap());
        AbstractBillWorkbenchCustomEvent.updateCustomControl(_this, customMap, "process/blueinvoice");
    }

    private static void setChooseBlueInvoiceCache(DynamicObject vatObj, JSONObject invoice, AbstractFormPlugin that) {
        String originalInvoiceCode = invoice.getString("originalinvoicecode");
        String originalInvoiceNo = invoice.getString("originalinvoiceno");
        String hasChooseInvoiceStr = AbstractBillWorkbenchCustomEvent.getPageCacheVal(that, "hasChooseBlueInvoiceMap");
        JSONObject cacheJson = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)hasChooseInvoiceStr) ? new JSONObject() : JSONObject.parseObject((String)hasChooseInvoiceStr);
        if (vatObj.getString("invoicecode").equals(originalInvoiceCode) && vatObj.getString("invoiceno").equals(originalInvoiceNo)) {
            return;
        }
        Set entries = cacheJson.entrySet();
        for (Map.Entry entry : entries) {
            Object codeAndNo = entry.getValue();
            if (!codeAndNo.equals(vatObj.getString("invoicecode") + '_' + vatObj.getString("invoiceno"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u84dd\u7968\u5df2\u88ab\u5176\u4ed6\u53d1\u7968\u9009\u53d6,\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"BillProcessTabUtil_0", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        cacheJson.put(vatObj.getString("invoicecode") + '_' + vatObj.getString("invoiceno"), (Object)(vatObj.getString("invoicecode") + '_' + vatObj.getString("invoiceno")));
        cacheJson.remove((Object)(originalInvoiceCode + '_' + originalInvoiceNo));
        AbstractBillWorkbenchCustomEvent.putPageCache(that, "hasChooseBlueInvoiceMap", cacheJson.toJSONString());
    }

    public static void handleRedInfoCallBack(AbstractFormPlugin _this, ClosedCallBackEvent event) {
        if (null == event.getReturnData()) {
            return;
        }
        ListSelectedRowCollection list = (ListSelectedRowCollection)event.getReturnData();
        if (list.size() == 0) {
            return;
        }
        if (list.size() > 10) {
            _this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7\u6700\u591a\u4e0d\u80fd\u8d85\u8fc710\u4e2a", (String)"BillProcessTabUtil_1", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] vatObj = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"infocode,originalissuetime,originalinvoicecode,originalinvoiceno", (QFilter[])new QFilter("id", "in", (Object)list.getPrimaryKeyValues()).toArray());
        if (vatObj == null) {
            return;
        }
        String infocodes = Arrays.stream(vatObj).map(o -> o.getString("infocode")).collect(Collectors.joining(","));
        Map<String, Object> map = BillProcessTabUtil.dealWithInfoCodeByHand(_this, infocodes);
        AbstractBillWorkbenchCustomEvent.updateCustomControl(_this, map, "process/openredinfolist");
    }

    public static Map<String, Object> dealWithInfoCodeByHand(AbstractFormPlugin _this, String infoCodes) {
        WorkbenchIssueContentDTO issueContent = (WorkbenchIssueContentDTO)JSONObject.parseObject((String)AbstractBillWorkbenchCustomEvent.getPageCacheVal(_this, "workbenchIssueContent"), WorkbenchIssueContentDTO.class);
        String invoiceContent = issueContent.getInvoiceContent();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoiceContent)) {
            invoiceContent = ImcConfigUtil.getValue((String)"sim_redinfo_deal_bill", (String)AbstractBillWorkbenchCustomEvent.getPageCacheVal(_this, "currentSalerTaxNo"));
        }
        invoiceContent = null == invoiceContent ? "1" : invoiceContent;
        MergeResponseDTO request = new MergeResponseDTO();
        request.setBillNoMap((Map)SerializationUtils.fromJsonString((String)AbstractBillWorkbenchCustomEvent.getPageCacheVal(_this, "billNoMap"), Map.class));
        request.setInvoiceContent(invoiceContent);
        Map billMap = (Map)SerializationUtils.fromJsonString((String)AbstractBillWorkbenchCustomEvent.getPageCacheVal(_this, issueContent.getMergeBillId()), Map.class);
        DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
        DynamicObjectUtil.map2DynamicObject((Map)billMap, (DynamicObject)bill);
        if (issueContent.getTaxFreeAdjust() != null && issueContent.getTaxFreeAdjust().booleanValue()) {
            BillProcessTabUtil.dealInvoiceTaxAdjust2Bill(issueContent, bill);
        }
        bill.set("splitrule", (Object)"imc_no_split");
        bill.set("infocode", (Object)infoCodes);
        request.setBills(Collections.singletonList(bill));
        request.setRelations(JSONObject.parseArray((String)AbstractBillWorkbenchCustomEvent.getPageCacheVal(_this, "mergeRelations"), BillRelationDTO.class));
        Map<String, Object> map = AbstractBillWorkbenchCustomEvent.splitCacheBill(_this, request, issueContent.getJqbh(), null);
        map.put("ruleCode", "imc_no_split");
        BillProcessTabUtil.setSelectInfoCodes(_this, infoCodes, true);
        return map;
    }

    public static void setSelectInfoCodes(AbstractFormPlugin that, String infoCodes, boolean isWorkbenchFillIn) {
        String[] infoCodeArr;
        String selectedInfoCodes = AbstractBillWorkbenchCustomEvent.getPageCacheVal(that, "selectedInfoCodes");
        JSONObject cacheJson = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)selectedInfoCodes) ? new JSONObject() : JSONObject.parseObject((String)selectedInfoCodes);
        for (String infoCode : infoCodeArr = infoCodes.split(",")) {
            cacheJson.put(infoCode, (Object)isWorkbenchFillIn);
        }
        AbstractBillWorkbenchCustomEvent.putPageCache(that, "selectedInfoCodes", cacheJson.toJSONString());
    }

    private static void dealInvoiceTaxAdjust2Bill(WorkbenchIssueContentDTO issueContent, DynamicObject bill) {
        JSONObject invoices = issueContent.getBillIdInvoiceMap().getJSONArray(issueContent.getMergeBillId()).getJSONObject(0);
        JSONArray items = invoices.getJSONArray("items");
        JSONArray relations = issueContent.getBillInvoiceRelationMap().getJSONArray(issueContent.getMergeBillId());
        Map relationMap = relations.stream().collect(Collectors.groupingBy(k -> ((JSONObject)k).getString("sdetailid"), TreeMap::new, Collectors.mapping(v -> ((JSONObject)v).getString("tdetailid"), Collectors.toSet())));
        DynamicObjectCollection billItems = bill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject billItem : billItems) {
            Set tDetailIdSet = (Set)relationMap.get(billItem.getString("id"));
            List tItems = items.stream().map(item -> (JSONObject)item).filter(item -> tDetailIdSet.contains(item.getString("id"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tItems)) continue;
            BigDecimal amountSum = BigDecimal.ZERO;
            BigDecimal taxSum = BigDecimal.ZERO;
            BigDecimal taxAmountSum = BigDecimal.ZERO;
            for (JSONObject tItem : tItems) {
                amountSum = amountSum.add(tItem.getBigDecimal("amount"));
                taxSum = taxSum.add(tItem.getBigDecimal("tax"));
                taxAmountSum = taxAmountSum.add(tItem.getBigDecimal("taxamount"));
            }
            billItem.set("amount", (Object)amountSum);
            billItem.set("tax", (Object)taxSum);
            billItem.set("taxamount", (Object)taxAmountSum);
            billItem.set("remainvalidamount", (Object)taxAmountSum);
            billItem.set("remainvalidtax", (Object)taxSum);
        }
    }

    public static List<DynamicObject> updateSplitUseCount(String jsonStr, String splitrule, long orgId) {
        ArrayList result = Lists.newArrayList();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)jsonStr) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)splitrule)) {
            return result;
        }
        JSONArray invoices = JSONArray.parseArray((String)jsonStr);
        if (invoices.size() == 0) {
            return result;
        }
        JSONArray splitJson = JSONArray.parseArray((String)splitrule);
        DynamicObject[] splitRule = BusinessDataServiceHelper.load((String)"sim_split_use", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_split_use"), (QFilter[])new QFilter("orgid", "=", (Object)orgId).toArray());
        for (Object datum : invoices) {
            JSONObject dyData = JSONObject.parseObject((String)datum.toString());
            String rulecode = dyData.getString("splitrule");
            Boolean flag = Boolean.FALSE;
            for (DynamicObject object : splitRule) {
                if (!object.getString("rulecode").equals(rulecode)) continue;
                object.set("usecount", (Object)(object.getInt("usecount") + 1));
                result.add(object);
                flag = Boolean.TRUE;
                break;
            }
            if (flag.booleanValue()) continue;
            String rulename = "";
            for (Object o : splitJson) {
                JSONObject splityet = (JSONObject)o;
                if (!splityet.get((Object)"ruleCode").equals(rulecode)) continue;
                rulename = splityet.get((Object)"ruleName").toString();
                break;
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)rulecode) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)rulename)) continue;
            DynamicObject newDy = BusinessDataServiceHelper.newDynamicObject((String)"sim_split_use");
            newDy.set("usecount", (Object)1);
            newDy.set("rulecode", (Object)rulecode);
            newDy.set("rulename", (Object)rulename);
            newDy.set("orgid", (Object)orgId);
            result.add(newDy);
        }
        return result;
    }

    public static void handleCustomEventSaveData(AbstractFormPlugin _this, ClosedCallBackEvent event) {
        if ("workout".equals(event.getReturnData())) {
            _this.getView().returnDataToParent((Object)"refresh");
            _this.getView().close();
            return;
        }
        HashMap<String, Object> showDataMap = new HashMap<String, Object>(8);
        showDataMap.put("previewDataSave", Boolean.TRUE);
        showDataMap.put("invoiceList", SerializationUtils.fromJsonString((String)AbstractBillWorkbenchCustomEvent.getPageCacheVal(_this, "resetJson"), Map.class));
        showDataMap.put("invoiceRelationMap", SerializationUtils.fromJsonString((String)AbstractBillWorkbenchCustomEvent.getPageCacheVal(_this, "resetRelation"), Map.class));
        AbstractBillWorkbenchCustomEvent.updateCustomControl(_this, showDataMap, "preview/save_data");
    }

    public static void confrimCheck(AbstractFormPlugin that, String tipMsg, String yesMsg, String noMsg, String callBackId) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackId, (IFormPlugin)that);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), yesMsg);
        btnNameMaps.put(MessageBoxResult.No.getValue(), noMsg);
        that.getView().showConfirm(tipMsg, "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    public static void saveInvoiceData(Map<String, List<DynamicObject>> arrList) {
        List<DynamicObject> invoiceList = arrList.get("invoiceList");
        List<DynamicObject> redInfoList = arrList.get("redInfoList");
        List<DynamicObject> relations = arrList.get("relations");
        if (invoiceList.size() > 0) {
            BillProcessTabUtil.fillInvoiceInfoFromBill(null, BillProcessTabUtil.generateRelations(relations), invoiceList);
            BillProcessTabUtil.saveRedInfoOrInvoice(invoiceList, relations, "sim_vatinvoice");
            BillProcessTabUtil.updateRedConfirmBill(invoiceList, relations);
        }
        if (redInfoList.size() > 0) {
            BillProcessTabUtil.saveRedInfoOrInvoice(redInfoList, relations, "sim_red_info");
        }
    }

    private static List<BillRelationDTO> generateRelations(List<DynamicObject> relations) {
        ArrayList<BillRelationDTO> relationDtos = new ArrayList<BillRelationDTO>();
        for (DynamicObject relation : relations) {
            BillRelationDTO dto = new BillRelationDTO();
            dto.setsBillId(Long.valueOf(relation.getLong("sbillid")));
            dto.setsDetailId(Long.valueOf(relation.getLong("sdetailid")));
            dto.settBillId(Long.valueOf(relation.getLong("tbillid")));
            dto.settDetailId(Long.valueOf(relation.getLong("tdetailid")));
            relationDtos.add(dto);
        }
        return relationDtos;
    }

    private static void updateRedConfirmBill(List<DynamicObject> invoiceList, List<DynamicObject> relations) {
        DynamicObject[] redConfirms;
        boolean isElePaper;
        DynamicObject invoice = invoiceList.get(0);
        String issueType = invoice.getString("issuetype");
        String elePaper = invoice.getString("iselepaper");
        String invoiceType = invoice.getString("invoicetype");
        boolean bl = isElePaper = InvoiceUtils.isAllEInvoice((Object)invoiceType) || AllEleAuthHelper.isElePaper((Object)elePaper);
        if (!IssueType.RED_INVOICE.getTypeCode().equals(issueType) || !isElePaper) {
            return;
        }
        ArrayList<DynamicObject> updateRedConfirms = new ArrayList<DynamicObject>();
        for (DynamicObject oneInvoice : invoiceList) {
            String infoCode = oneInvoice.getString("infocode");
            Object org = oneInvoice.get("orgid");
            Long orgPk = BillProcessTabUtil.getOrgPk(oneInvoice, org);
            QFilter redConfirmFilter = RedConfirmHelper.getFilter((String)infoCode, (Long)orgPk);
            DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill"), (QFilter[])redConfirmFilter.toArray());
            if (array.length <= 0) continue;
            array[0].set("billno", oneInvoice.get("billno"));
            array[0].set("source", (Object)"5");
            updateRedConfirms.add(array[0]);
        }
        if (updateRedConfirms.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateRedConfirms.toArray(new DynamicObject[0]));
        }
        HashSet<Long> sbillIds = new HashSet<Long>();
        HashSet<Long> tbillIds = new HashSet<Long>();
        HashMap<Long, Long> billRedConfrimMap = new HashMap<Long, Long>();
        HashMap<Object, DynamicObject> redConfirmMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject relation : relations) {
            sbillIds.add(relation.getLong("sbillid"));
            tbillIds.add(relation.getLong("tbillid"));
            billRedConfrimMap.put(relation.getLong("sbillid"), relation.getLong("tbillid"));
        }
        QFilter redConfirmFilter = new QFilter("id", "in", (Object)tbillIds.toArray(new Long[0]));
        for (DynamicObject redConfirm : redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill"), (QFilter[])redConfirmFilter.toArray())) {
            redConfirmMap.put(redConfirm.getPkValue(), redConfirm);
        }
        DynamicObject[] oriBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"id,infocode,originaletaxinvoiceno,blueinvoicecode,blueinvoiceno,blueinvoicetype,originalissuetime,redreason", (QFilter[])new QFilter("id", "in", (Object)sbillIds.toArray(new Long[0])).toArray());
        HashSet<DynamicObject> updateBill = new HashSet<DynamicObject>();
        for (DynamicObject oriBill : oriBills) {
            Long redConfirmPk;
            DynamicObject redConfirm;
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)oriBill.getString("infocode")) || null == (redConfirm = (DynamicObject)redConfirmMap.get(redConfirmPk = (Long)billRedConfrimMap.get(oriBill.getLong("id"))))) continue;
            oriBill.set("originaletaxinvoiceno", redConfirm.get("originalEtaxInvoiceNo"));
            oriBill.set("blueinvoicecode", redConfirm.get("originalinvoicecode"));
            oriBill.set("blueinvoiceno", redConfirm.get("originalinvoiceno"));
            oriBill.set("blueinvoicetype", redConfirm.get("originalinvoicetype"));
            oriBill.set("originalissuetime", redConfirm.get("originalissuetime"));
            oriBill.set("infocode", redConfirm.get("number"));
            Object redReason = redConfirm.get("redreason");
            String billRedReason = RedConfirmHelper.matchBillRedReason((Object)redReason);
            oriBill.set("redreason", (Object)billRedReason);
            updateBill.add(oriBill);
        }
        if (updateBill.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateBill.toArray(new DynamicObject[0]));
        }
    }

    private static Long getOrgPk(DynamicObject oneInvoice, Object org) {
        Long orgPk = 0L;
        if (org instanceof String) {
            orgPk = Long.parseLong((String)org);
        }
        if (org instanceof DynamicObject) {
            orgPk = (Long)oneInvoice.getDynamicObject("orgid").getPkValue();
        }
        if (org instanceof Long) {
            orgPk = (Long)org;
        }
        return orgPk;
    }

    private static void saveRedInfoOrInvoice(List<DynamicObject> objs, List<DynamicObject> relations, String tableName) {
        DynamicObject waitInvoice;
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(objs.size());
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(objs.size());
        ArrayList<DynamicObject> updateRelationList = new ArrayList<DynamicObject>(objs.size());
        InvoiceUtils.dealInvoicesListMark(new HashMap(), objs);
        for (DynamicObject obj : objs) {
            if (tableName.equals("sim_vatinvoice")) {
                String infoCode;
                boolean isElePaper;
                DynamicObject invoice;
                obj.set("billstatus", (Object)"");
                obj.set("issuebillstatus", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
                if (obj.getDynamicObjectCollection("items").size() > 8) {
                    obj.set("inventorymark", (Object)"1");
                }
                if (null != (invoice = BusinessDataServiceHelper.loadSingle((String)tableName, (String)"id", (QFilter[])new QFilter("id", "=", obj.get("id")).toArray()))) {
                    updateList.add(obj);
                } else {
                    saveList.add(obj);
                }
                String issueType = obj.getString("issuetype");
                String elePaper = obj.getString("iselepaper");
                String invoiceType = obj.getString("invoicetype");
                boolean bl = isElePaper = InvoiceUtils.isAllEInvoice((Object)invoiceType) || AllEleAuthHelper.isElePaper((Object)elePaper);
                if (isElePaper && IssueType.RED_INVOICE.getTypeCode().equals(issueType) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(infoCode = obj.getString("infocode")))) {
                    QFilter redConfirmFilter = RedConfirmHelper.getFilter((String)infoCode, (Long)BillProcessTabUtil.getOrgPk(obj, obj.get("orgid")));
                    DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill"), (QFilter[])redConfirmFilter.toArray());
                    if (array.length > 0 && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)obj.getString("originalinvoicecode"))) {
                        obj.set("originalinvoicecode", array[0].get("originalinvoicecode"));
                        obj.set("originalinvoiceno", array[0].get("originalinvoiceno"));
                        obj.set("originalinvoicetype", array[0].get("originalinvoicetype"));
                        obj.set("originalissuetime", array[0].get("originalissuetime"));
                        obj.set("originalEtaxInvoiceNo", array[0].get("originalEtaxInvoiceNo"));
                    }
                }
                BillProcessTabUtil.warpRedAllEInvoiceData(relations, obj);
                continue;
            }
            DynamicObject redInfo = null;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)obj.getString("infocode"))) {
                redInfo = BusinessDataServiceHelper.loadSingle((String)tableName, (String)String.join((CharSequence)",", "originalinvoicecode", "originalinvoiceno", "originalissuetime"), (QFilter[])new QFilter("infocode", "=", obj.get("infocode")).and("org", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("org"))).toArray());
            } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)obj.getString("originalinvoicecode")) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)obj.getString("originalinvoiceno"))) {
                redInfo = BusinessDataServiceHelper.loadSingle((String)tableName, (String)String.join((CharSequence)",", "originalinvoicecode", "originalinvoiceno", "originalissuetime"), (QFilter[])new QFilter("id", "=", obj.get("id")).toArray());
            }
            if (redInfo != null) {
                if (!Objects.equals(obj.get("id"), redInfo.getPkValue())) {
                    List redInfoRelation = relations.stream().filter(relation -> Objects.equals(relation.get("tbillid"), obj.get("id"))).collect(Collectors.toList());
                    for (DynamicObject object : redInfoRelation) {
                        object.set("tbillid", redInfo.getPkValue());
                        updateRelationList.add(object);
                    }
                }
                obj.set("originalinvoicecode", redInfo.get("originalinvoicecode"));
                obj.set("originalinvoiceno", redInfo.get("originalinvoiceno"));
                obj.set("originalissuetime", redInfo.get("originalissuetime"));
                updateList.add(obj);
                continue;
            }
            saveList.add(obj);
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            ImcSaveServiceHelper.update(updateList);
            for (DynamicObject redInfo : updateList) {
                if (!"sim_red_info".equals(redInfo.getDataEntityType().getName())) continue;
                waitInvoice = OriginalBillPluginIssueControl.genWaitInvoice(redInfo);
                ImcSaveServiceHelper.save((DynamicObject)waitInvoice);
            }
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            if ("sim_red_info".equals(tableName)) {
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)tableName, (DynamicObject[])saveList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                if (!operationResult.isSuccess()) {
                    throw new KDBizException(operationResult.getMessage());
                }
            } else {
                ImcSaveServiceHelper.save(saveList);
            }
            for (DynamicObject redInfo : saveList) {
                if (!"sim_red_info".equals(redInfo.getDataEntityType().getName()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)redInfo.getString("infocode"))) continue;
                waitInvoice = OriginalBillPluginIssueControl.genWaitInvoice(redInfo);
                ImcSaveServiceHelper.save((DynamicObject)waitInvoice);
            }
        }
        if (CollectionUtils.isNotEmpty(updateRelationList)) {
            ImcSaveServiceHelper.update(updateRelationList);
        }
    }

    public static DynamicObject warpRedAllEInvoiceData(List<DynamicObject> relations, DynamicObject redInvoiceDO) {
        DynamicObject redConfirmBillObj;
        boolean isRedEle;
        boolean isEle = InvoiceUtils.isAllEInvoice((Object)redInvoiceDO.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)redInvoiceDO.getString("iselepaper"));
        boolean bl = isRedEle = isEle && InvoiceUtils.isRed((String)redInvoiceDO.getString("issuetype"));
        if (!isRedEle) {
            return null;
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)redInvoiceDO.getString("infocode"))) {
            Boolean isPartRed = Boolean.FALSE;
            BillVo billVo = (BillVo)DynamicObjectUtil.dynamicObject2Bean(BillVo.class, (DynamicObject)redInvoiceDO);
            billVo.setBlueinvoiceCode(redInvoiceDO.getString("originalinvoicecode"));
            billVo.setBlueinvoiceNo(redInvoiceDO.getString("originalinvoiceno"));
            QFilter blueFilter = InvoiceQueryUtil.getInvoiceByCodeAndNo((String)billVo.getBlueinvoiceCode(), (String)billVo.getBlueinvoiceNo());
            DynamicObject blueInvoiceObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])blueFilter.toArray());
            if (null == blueInvoiceObj) {
                return null;
            }
            if (billVo.getTotalAmount().abs().compareTo(blueInvoiceObj.getBigDecimal("invoiceamount")) < 0) {
                billVo = (BillVo)DynamicObjectUtil.dynamicObject2Bean(BillVo.class, (DynamicObject)redInvoiceDO);
                isPartRed = Boolean.TRUE;
                DynamicObjectCollection items = redInvoiceDO.getDynamicObjectCollection("items");
                ArrayList<BillDetailVo> billDetail = new ArrayList<BillDetailVo>(items.size());
                for (int i = 0; i < items.size(); ++i) {
                    BillDetailVo billDetailVo = (BillDetailVo)DynamicObjectUtil.dynamicObject2Bean(BillDetailVo.class, (DynamicObject)((DynamicObject)items.get(i)));
                    billDetailVo.setOriginalSeq(Integer.valueOf(((DynamicObject)items.get(i)).getInt("originseq")));
                    String privilegeFlag = ((DynamicObject)items.get(i)).getString("taxpremark");
                    String privilegeContent = ((DynamicObject)items.get(i)).getString("zzstsgl");
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)privilegeFlag) && "1".equals(privilegeFlag)) {
                        billDetailVo.setPrivilegeFlag(Integer.valueOf(1));
                        billDetailVo.setPrivilegeContent(privilegeContent);
                    }
                    billDetail.add(billDetailVo);
                }
                billVo.setBillDetail(billDetail);
            } else {
                billVo.setBillNo(redInvoiceDO.getString("billno"));
                billVo.setRedReason(redInvoiceDO.getString("redreason"));
                billVo.setAccount(redInvoiceDO.getString("account"));
                billVo.setTotalAmount(redInvoiceDO.getBigDecimal("invoiceamount"));
                billVo.setTotalTaxAmount(redInvoiceDO.getBigDecimal("totaltax"));
                billVo.setIncludeTaxAmount(redInvoiceDO.getBigDecimal("invoiceamount").add(redInvoiceDO.getBigDecimal("totaltax")));
            }
            redConfirmBillObj = RedConfirmBillHelper.createRedConfirmByBlue(billVo, redInvoiceDO.getString("orderno"), blueInvoiceObj, isPartRed);
            redInvoiceDO.set("infocode", (Object)redConfirmBillObj.getString("number"));
            redInvoiceDO.set("govuuid", (Object)redConfirmBillObj.getString("govuuid"));
            redInvoiceDO.set("originalissuetime", (Object)redConfirmBillObj.getDate("originalissuetime"));
            redConfirmBillObj.set("buyerphone", (Object)redInvoiceDO.getString("buyerphone"));
            redConfirmBillObj.set("buyeremail", (Object)redInvoiceDO.getString("buyeremail"));
            RedConfirmHelper.replaceItems((DynamicObject)redConfirmBillObj, (DynamicObject)redInvoiceDO);
        } else {
            QFilter qFilter = new QFilter("number", "=", redInvoiceDO.get("infocode"));
            redConfirmBillObj = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)true), (QFilter[])qFilter.toArray());
        }
        if (redConfirmBillObj != null) {
            String redConfirmBillRemark = redConfirmBillObj.getString("remark");
            String redInvoiceDORemark = redInvoiceDO.getString("remark");
            redConfirmBillObj.set("remark", (Object)(redConfirmBillRemark + (String)redInvoiceDORemark));
        }
        DynamicObject billDO = null;
        for (DynamicObject relation : relations) {
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)relation.getString("sbillno"), (CharSequence)redInvoiceDO.getString("batchbelong")) || !"sim_red_confirm_bill".equals(relation.getString("ttable"))) continue;
            relation.set("tbillno", (Object)redInvoiceDO.getString("billno"));
            billDO = BusinessDataServiceHelper.loadSingle((Object)relation.get("sbillid"), (String)"sim_original_bill");
            if (redConfirmBillObj != null) {
                relation.set("tbillid", redConfirmBillObj.getPkValue());
                redConfirmBillObj.set("billno", (Object)redInvoiceDO.getString("billno"));
                redConfirmBillObj.set("source", (Object)"5");
                redConfirmBillObj.set("systemsource", billDO.get("systemsource"));
                ImcSaveServiceHelper.update((DynamicObject)redConfirmBillObj);
            }
            billDO.set("infocode", redInvoiceDO.get("infocode"));
            billDO.set("salerorbuyer", (Object)"0");
            billDO.set("blueinvoiceno", redInvoiceDO.get("originalinvoiceno"));
            billDO.set("originalissuetime", redInvoiceDO.get("originalissuetime"));
            billDO.set("originaletaxinvoiceno", redInvoiceDO.get("originalEtaxInvoiceNo"));
            billDO.set("blueinvoicetype", redInvoiceDO.get("originalinvoicetype"));
            billDO.set("redreason", redInvoiceDO.get("redreason"));
            ImcSaveServiceHelper.update((DynamicObject)billDO);
        }
        ImcSaveServiceHelper.update(relations);
        Map extraField = ImcConfigUtil.getValue((String)"bill_extra_field");
        if (!extraField.isEmpty() && billDO != null && redConfirmBillObj != null) {
            for (Map.Entry entry : extraField.entrySet()) {
                String field = (String)entry.getKey();
                LOGGER.info("BillProcessTabUtil: " + billDO.get(field));
                redConfirmBillObj.set(field, billDO.get(field));
            }
            ImcSaveServiceHelper.save((DynamicObject)redConfirmBillObj);
        }
        return redConfirmBillObj;
    }

    public static Map<String, List<DynamicObject>> json2Array(AbstractFormPlugin that, JSONObject jsonArs) {
        JSONObject invoices = jsonArs.getJSONObject("invoices");
        JSONObject invRelations = jsonArs.getJSONObject("invRealtion");
        ArrayList invoiceList = Lists.newArrayListWithCapacity((int)8);
        ArrayList redInfoList = Lists.newArrayListWithCapacity((int)8);
        long currentOrgId = Long.parseLong(AbstractBillWorkbenchCustomEvent.getPageCacheVal(that, "currentOrg"));
        for (String mergeBillId : invoices.keySet()) {
            JSONArray invoiceOrRedInfos = invoices.getJSONArray(mergeBillId);
            JSONArray invRelationArr = invRelations.getJSONArray(mergeBillId);
            int splitOrder = 1;
            for (Object inoviceOrRedInfo : invoiceOrRedInfos) {
                DynamicObject invoiceOrRedInfoDynamicObject;
                JSONObject invoiceOrRedInfoJson = (JSONObject)inoviceOrRedInfo;
                BillProcessTabUtil.setFreightsItemId(invoiceOrRedInfoJson);
                invoiceOrRedInfoJson.put("jqbh", (Object)jsonArs.getString("jqbh"));
                invoiceOrRedInfoJson.put("terminalno", (Object)jsonArs.getString("terminalNo"));
                invoiceOrRedInfoJson.put("account", (Object)jsonArs.getString("currentAccount"));
                BillProcessTabUtil.handleSplitByDetail(invoiceOrRedInfoJson, invRelationArr, jsonArs.getJSONObject("billNoMap"), splitOrder);
                ++splitOrder;
                String elePaperInvoice = invoiceOrRedInfoJson.getString("iselepaper");
                boolean isElePaperInvoice = AllEleAuthHelper.isElePaper((Object)elePaperInvoice);
                if (InvoiceUtils.isRedInfo((BigDecimal)invoiceOrRedInfoJson.getBigDecimal("invoiceamount"), (String)invoiceOrRedInfoJson.getString("invoicetype")) && !isElePaperInvoice) {
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)invoiceOrRedInfoJson.getString("infocode"))) {
                        DynamicObject redInfo = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)"id", (QFilter[])new QFilter("infocode", "=", (Object)invoiceOrRedInfoJson.getString("infocode")).and("org", "=", (Object)currentOrgId).toArray());
                        if (redInfo == null) {
                            invoiceOrRedInfoJson.put("status", (Object)"3");
                            invoiceOrRedInfoJson.put("infosource", (Object)"6");
                            invoiceOrRedInfoJson.put("invoicecode", (Object)"");
                            invoiceOrRedInfoJson.put("invoiceno", (Object)"");
                        }
                    } else {
                        invoiceOrRedInfoJson.put("infosource", (Object)"5");
                        invoiceOrRedInfoJson.put("invoicecode", (Object)"");
                        invoiceOrRedInfoJson.put("invoiceno", (Object)"");
                    }
                    invoiceOrRedInfoDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_info");
                    redInfoList.add(invoiceOrRedInfoDynamicObject);
                } else {
                    invoiceOrRedInfoDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
                    invoiceList.add(invoiceOrRedInfoDynamicObject);
                }
                BillProcessTabUtil.convertJsonToInvoiceOrRedInfo(invoiceOrRedInfoJson, invoiceOrRedInfoDynamicObject);
            }
        }
        AbstractBillWorkbenchCustomEvent.putPageCache(that, "resetJson", invoices.toJSONString());
        AbstractBillWorkbenchCustomEvent.putPageCache(that, "resetRelation", invRelations.toJSONString());
        JSONArray originalbillArr = jsonArs.getJSONArray("invBill");
        DynamicObject[] originalBills = BusinessDataServiceHelper.load((Object[])originalbillArr.stream().map(o -> ((JSONObject)o).getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
        List<DynamicObject> originalBillList = Stream.of(originalBills).collect(Collectors.toList());
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>(2);
        if (!jsonArs.getBoolean("previewDataSave").booleanValue()) {
            String mergeRelationStr = AbstractBillWorkbenchCustomEvent.getPageCacheVal(that, "mergeRelations");
            List mergeRelations = JSONArray.parseArray((String)mergeRelationStr, BillRelationDTO.class);
            JSONArray mergeBillArr = jsonArs.getJSONArray("treatmentShowBillList");
            ArrayList invRelationDTOS = Lists.newArrayList();
            for (String mergeBillId : invRelations.keySet()) {
                JSONArray invRelation = invRelations.getJSONArray(mergeBillId);
                invRelationDTOS.addAll(JSONArray.parseArray((String)invRelation.toJSONString(), BillRelationDTO.class));
            }
            BillProcessTabUtil.doOriginalTaxDeviation(originalBillList, mergeBillArr, invoices, mergeRelations, invRelationDTOS);
            BillProcessTabUtil.setDrawerAndAccount(originalBillList, jsonArs.getString("currentAccount"));
            List<BillRelationDTO> finalRelationDTOS = BillInvoiceRelationHelper.mergeRelation(mergeRelations, invRelationDTOS);
            if (redInfoList.size() > 0) {
                BillProcessTabUtil.doBlueInfoToOriginal(redInfoList, finalRelationDTOS, originalBillList);
            }
            if (invoiceList.size() > 0) {
                BillProcessTabUtil.doBlueInfoToOriginal(invoiceList, finalRelationDTOS, originalBillList);
            }
            IssueInvoiceControlHelper.setOriginalBillByInvRelation(originalBillList, finalRelationDTOS);
            List<DynamicObject> relations = IssueInvoiceControlHelper.saveInvRelation(finalRelationDTOS);
            resultMap.put("relations", relations);
        } else {
            resultMap.put("relations", new ArrayList(1));
        }
        resultMap.put("invoiceList", invoiceList);
        resultMap.put("redInfoList", redInfoList);
        return resultMap;
    }

    public static void setFreightsItemId(JSONObject invoiceOrRedInfoJson) {
        JSONArray freightsItemArr = invoiceOrRedInfoJson.getJSONArray("freights");
        if (freightsItemArr == null || freightsItemArr.isEmpty()) {
            return;
        }
        for (int i = 0; i < freightsItemArr.size(); ++i) {
            JSONObject freightsItem = freightsItemArr.getJSONObject(i);
            freightsItem.put("id", (Object)String.valueOf(DBServiceHelper.genGlobalLongId()));
        }
    }

    public static void convertJsonToInvoiceOrRedInfo(JSONObject inoviceOrRedInfoJson, DynamicObject dynamicObject) {
        DynamicObjectUtil.json2DynamicObjectContainItems((JSONObject)inoviceOrRedInfoJson, (DynamicObject)dynamicObject, (boolean)true);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.getDynamicObjectCollection("items").forEach(ZeroTaxMarkUtil::handlerZeroTaxMark);
        if (dynamicObject.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0 && InvoiceUtils.isSpecialInvoice((String)dynamicObject.getString("invoicetype")) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dynamicObject.getString("applicant"))) {
            dynamicObject.set("originaldeduction", (Object)BigDecimal.ZERO);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dynamicObject.getString("infocode"))) {
                dynamicObject.set("originalinvoicecode", (Object)"");
                dynamicObject.set("originalinvoiceno", (Object)"");
                dynamicObject.set("originalissuetime", (Object)"");
            }
            if (dynamicObject.getString("applicant").equals(RedInfoConstant.ApplicantEnum.SALER.getCode())) {
                dynamicObject.set("applytaxno", (Object)dynamicObject.getString("salertaxno"));
            } else {
                dynamicObject.set("applytaxno", (Object)dynamicObject.getString("buyertaxno"));
            }
        }
    }

    public static void handleSplitByDetail(JSONObject invoiceOrRedInfoJson, JSONArray invRelationArr, JSONObject billNoMap, int splitOrder) {
        String invoiceId = invoiceOrRedInfoJson.getString("id");
        if (!invoiceId.trim().startsWith("items")) {
            return;
        }
        String billno = invoiceOrRedInfoJson.getString("billno");
        invoiceOrRedInfoJson.put("billno", (Object)billNoMap.getString(billno));
        String newInvoiceId = String.valueOf(DBServiceHelper.genGlobalLongId());
        invoiceOrRedInfoJson.put("id", (Object)newInvoiceId);
        invoiceOrRedInfoJson.put("orderno", (Object)UUID.next());
        invoiceOrRedInfoJson.put("splitorder", (Object)splitOrder);
        invoiceOrRedInfoJson.put("issuewritebackstatus", (Object)"0");
        invoiceOrRedInfoJson.put("abolishwritebackstatus", (Object)"2");
        invoiceOrRedInfoJson.put("invoicingoperator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        JSONArray items = invoiceOrRedInfoJson.getJSONArray("items");
        for (int i = 0; i < items.size(); ++i) {
            JSONObject itemJSON = items.getJSONObject(i);
            itemJSON.put("seq", (Object)i);
            String rowType = itemJSON.getString("rowtype");
            if ("2".equals(rowType)) {
                itemJSON.put("rowtype", (Object)"0");
            } else if ("1".equals(rowType)) {
                JSONObject beDiscountItem = items.getJSONObject(i - 1);
                beDiscountItem.put("rowtype", (Object)"2");
            }
            for (Object invRelation : invRelationArr) {
                JSONObject relationJson = (JSONObject)invRelation;
                String detailId = itemJSON.getString("id");
                if (!relationJson.get((Object)"tbillid").equals(invoiceId) || !relationJson.get((Object)"tdetailid").equals(detailId)) continue;
                String newDetalID = String.valueOf(DBServiceHelper.genGlobalLongId());
                itemJSON.put("id", (Object)newDetalID);
                relationJson.put("tbillid", (Object)newInvoiceId);
                relationJson.put("tdetailid", (Object)newDetalID);
                relationJson.put("tbillno", billNoMap.get((Object)relationJson.getString("tbillno")));
            }
        }
    }

    public static void doOriginalTaxDeviation(List<DynamicObject> originalBillList, JSONArray mergeBillArr, JSONObject invoices, List<BillRelationDTO> mergeRelations, List<BillRelationDTO> invRelations) {
        BillProcessTabUtil.writeInvoiceDeviationToMergeBill(invRelations, invoices, mergeBillArr);
        Map<Long, List<BillRelationDTO>> mergeDetailIdMap = mergeRelations.stream().collect(Collectors.groupingBy(BillRelationDTO::gettDetailId));
        Map<Long, DynamicObject> originalBillItemMap = BillProcessTabUtil.getOriginalBillItemMap(originalBillList);
        for (Object mergeBillJson : mergeBillArr) {
            JSONObject mergeBill = (JSONObject)mergeBillJson;
            JSONArray mergeBillItems = mergeBill.getJSONArray("sim_original_bill_item");
            for (Object mergeBillItemJson : mergeBillItems) {
                JSONObject mergeBillItem = (JSONObject)mergeBillItemJson;
                List<BillRelationDTO> relationList = mergeDetailIdMap.get(mergeBillItem.getLong("id"));
                ArrayList itemList = Lists.newArrayListWithCapacity((int)relationList.size());
                for (BillRelationDTO billRelationDTO : relationList) {
                    itemList.add(originalBillItemMap.get(billRelationDTO.getsDetailId()));
                }
                itemList.stream().max(Comparator.comparing(itemTax -> itemTax.getBigDecimal("tax"))).ifPresent(detail -> {
                    BigDecimal adJusttaxdeviation = BigDecimalUtil.getJsonBigDecimalVal((Object)mergeBillItem.getBigDecimal("taxdeviation"));
                    BillRelationDTO billRelationDTO = relationList.stream().filter(relation -> detail.getLong("id") == relation.getsDetailId().longValue()).findFirst().orElse(null);
                    if (billRelationDTO != null) {
                        BigDecimal taxDeviation = detail.getBigDecimal("taxdeviation");
                        billRelationDTO.setTax(billRelationDTO.getTax().add(taxDeviation).subtract(adJusttaxdeviation));
                        billRelationDTO.setAmount(billRelationDTO.getAmount().subtract(taxDeviation).add(adJusttaxdeviation));
                    }
                });
            }
        }
    }

    private static Map<Long, DynamicObject> getOriginalBillItemMap(List<DynamicObject> originalBillList) {
        HashMap originalBillItemMap = Maps.newHashMap();
        for (DynamicObject originalBill : originalBillList) {
            DynamicObjectCollection originalBillItems = originalBill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject originalBillItem : originalBillItems) {
                originalBillItemMap.put(originalBillItem.getLong("id"), originalBillItem);
            }
        }
        return originalBillItemMap;
    }

    private static void writeInvoiceDeviationToMergeBill(List<BillRelationDTO> invRelations, JSONObject invoices, JSONArray mergeBillArr) {
        Map<Long, List<BillRelationDTO>> detailIdMap = invRelations.stream().collect(Collectors.groupingBy(BillRelationDTO::gettDetailId));
        Map<Long, JSONObject> mergeDetailMap = BillProcessTabUtil.getMergeDetailMap(mergeBillArr);
        for (String mergeBillId : invoices.keySet()) {
            JSONArray invoiceOrRedInfos = invoices.getJSONArray(mergeBillId);
            for (Object inoviceOrRedInfo : invoiceOrRedInfos) {
                JSONObject invoiceOrRedInfoJson = (JSONObject)inoviceOrRedInfo;
                JSONArray items = invoiceOrRedInfoJson.getJSONArray("items");
                for (Object itemJson : items) {
                    JSONObject item = (JSONObject)itemJson;
                    if (!item.containsKey((Object)"adjustedData")) continue;
                    try {
                        List<BillRelationDTO> invRelationList = detailIdMap.get(item.getLong("id"));
                        ArrayList mergeItemList = Lists.newArrayListWithCapacity((int)invRelationList.size());
                        for (BillRelationDTO billRelationDTO : invRelationList) {
                            JSONObject mergeDetail = mergeDetailMap.get(billRelationDTO.getsDetailId());
                            if (mergeDetail == null) continue;
                            mergeItemList.add(mergeDetail);
                        }
                        mergeItemList.stream().max(Comparator.comparing(itemTax -> itemTax.getBigDecimal("tax"))).ifPresent(detail -> detail.put("taxdeviation", (Object)BigDecimalUtil.getJsonBigDecimalVal((Object)detail.get((Object)"taxdeviation")).subtract(BigDecimalUtil.getJsonBigDecimalVal((Object)item.get((Object)"adjustedData")))));
                    }
                    catch (Exception e) {
                        LOGGER.error("\u5f00\u7968\u53cd\u5199\u7a0e\u989d\u5c3e\u5dee\u5230\u5f00\u7968\u7533\u8bf7\u5355\u62a5\u9519\uff1a", (Object)e.getMessage());
                    }
                }
            }
        }
    }

    private static Map<Long, JSONObject> getMergeDetailMap(JSONArray mergeBillArr) {
        HashMap mergeDetailMap = Maps.newHashMap();
        for (Object mergeBillJson : mergeBillArr) {
            JSONObject mergeBill = (JSONObject)mergeBillJson;
            JSONArray mergeBillItems = mergeBill.getJSONArray("sim_original_bill_item");
            for (Object mergeBillItemJson : mergeBillItems) {
                JSONObject mergeBillItem = (JSONObject)mergeBillItemJson;
                mergeDetailMap.put(mergeBillItem.getLong("id"), mergeBillItem);
            }
        }
        return mergeDetailMap;
    }

    public static boolean checkBlueInvoiceAmount(JSONObject dyJson) {
        DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"totalamount", (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)dyJson.getString("originalinvoicecode"), (String)dyJson.getString("originalinvoiceno")).toArray());
        if (null == blueInvoice) {
            return false;
        }
        BigDecimal blueTotalAmount = blueInvoice.getBigDecimal("totalamount");
        BigDecimal redTotalAmount = dyJson.getBigDecimal("totalamount");
        return redTotalAmount.abs().compareTo(blueTotalAmount.abs()) > 0;
    }

    public static void doBlueInfoToOriginal(List<DynamicObject> redInfoOrInvoiceList, List<BillRelationDTO> finalRelationDTOS, List<DynamicObject> originalBillList) {
        long dealOriginalBillStartTime = System.currentTimeMillis();
        LOGGER.info(String.format("workbench\u5f00\u59cb\u5904\u7406\u539f\u59cb\u5355\u636e\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4:%s", dealOriginalBillStartTime + ""));
        for (DynamicObject originalBill : originalBillList) {
            List tRedInfoOrInvoiceIds = finalRelationDTOS.stream().filter(relation -> relation.getsBillId().equals(originalBill.getLong("id"))).map(BillRelationDTO::gettBillId).distinct().collect(Collectors.toList());
            List<DynamicObject> redInfoOrInvoices = redInfoOrInvoiceList.stream().filter(redInfo -> tRedInfoOrInvoiceIds.contains(redInfo.getLong("id"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(redInfoOrInvoices)) continue;
            if (originalBill.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0 && InvoiceUtils.isSpecialInvoice((String)originalBill.getString("invoicetype"))) {
                String infoCodes = redInfoOrInvoices.stream().map(redInfo -> redInfo.getString("infocode")).collect(Collectors.joining(","));
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)infoCodes)) {
                    originalBill.set("applicant", (Object)redInfoOrInvoices.get(0).getString("applicant"));
                    originalBill.set("infocode", (Object)infoCodes);
                    continue;
                }
                BillProcessTabUtil.fillBlueInvoiceCode(originalBill, redInfoOrInvoices.get(0), true);
                continue;
            }
            BillProcessTabUtil.fillNonRedInfoBlueInvoiceCode(originalBill, redInfoOrInvoices);
        }
        long dealOriginalBillEndTime = System.currentTimeMillis();
        long dealOriginalBillUseTime = dealOriginalBillEndTime - dealOriginalBillStartTime;
        LOGGER.info(String.format("workbench\u7ed3\u675f\u5904\u7406\u539f\u59cb\u5355\u636e\u6570\u636e\uff0c\u7ed3\u675f\u65f6\u95f4:%s \u8017\u65f6(\u5355\u4f4d\uff1ams):%s", dealOriginalBillEndTime + "", dealOriginalBillUseTime));
    }

    private static void fillNonRedInfoBlueInvoiceCode(DynamicObject originalBill, List<DynamicObject> redInfoOrInvoices) {
        for (DynamicObject invoiceOrRedInfo : redInfoOrInvoices) {
            if (invoiceOrRedInfo.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) >= 0) continue;
            BillProcessTabUtil.fillBlueInvoiceCode(originalBill, invoiceOrRedInfo, false);
        }
    }

    private static void fillBlueInvoiceCode(DynamicObject originalBill, DynamicObject invoiceOrRedInfo, boolean isRedInfo) {
        if (isRedInfo) {
            originalBill.set("blueinvoicecode", (Object)invoiceOrRedInfo.getString("originalinvoicecode"));
            originalBill.set("blueinvoiceno", (Object)invoiceOrRedInfo.getString("originalinvoiceno"));
            originalBill.set("applicant", (Object)invoiceOrRedInfo.getString("applicant"));
        } else if (originalBill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) < 0) {
            String oriBlueInvoiceCode = originalBill.getString("blueinvoicecode");
            String invoiceBlueInvoiceCode = invoiceOrRedInfo.getString("originalinvoicecode");
            String oriBlueInvoiceNo = originalBill.getString("blueinvoiceno");
            String invoiceBlueInvoiceNo = invoiceOrRedInfo.getString("originalinvoiceno");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)oriBlueInvoiceCode)) {
                if (!oriBlueInvoiceCode.contains(invoiceBlueInvoiceCode)) {
                    originalBill.set("blueinvoicecode", (Object)(oriBlueInvoiceCode + ";" + invoiceBlueInvoiceCode));
                }
            } else {
                originalBill.set("blueinvoicecode", (Object)invoiceBlueInvoiceCode);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)oriBlueInvoiceNo)) {
                if (!oriBlueInvoiceNo.contains(invoiceBlueInvoiceNo)) {
                    originalBill.set("blueinvoiceno", (Object)(oriBlueInvoiceNo + ";" + invoiceBlueInvoiceNo));
                }
            } else {
                originalBill.set("blueinvoiceno", (Object)invoiceBlueInvoiceNo);
            }
            originalBill.set("blueinvoicetype", (Object)invoiceOrRedInfo.getString("originalinvoicetype"));
            originalBill.set("redreason", (Object)invoiceOrRedInfo.getString("redreason"));
        }
        originalBill.set("originalissuetime", (Object)invoiceOrRedInfo.getDate("originalissuetime"));
    }

    public static Map<String, Object> processnextstep(AbstractFormPlugin that, JSONObject requestJson) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        JSONObject billInvoiceList = requestJson.getJSONObject("data");
        JSONArray errRedInfoJSON = new JSONArray();
        JSONArray errBlueInfoJSON = new JSONArray();
        JSONArray errBlueMsgJSON = new JSONArray();
        JSONArray errBlueAmountJSON = new JSONArray();
        JSONArray errBuyerInfoJOSN = new JSONArray();
        JSONArray errNormalRedJOSN = new JSONArray();
        Boolean flag = Boolean.TRUE;
        Boolean blueEtc = Boolean.FALSE;
        Boolean negativeNormalInvoice = Boolean.FALSE;
        boolean workbenchtype = true;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)AbstractBillWorkbenchCustomEvent.getPageCacheVal(that, "workbenchtype"))) {
            workbenchtype = false;
        }
        long currentOrgId = Long.parseLong(AbstractBillWorkbenchCustomEvent.getPageCacheVal(that, "currentOrg"));
        boolean msgSendFlag = MsgSendAuthHelper.msgSendAuthByOrgId((Long)currentOrgId);
        String checkPhone = MsgAuthSettingCacheHelper.getCacheCheckPhoneByOrgId((long)currentOrgId);
        HashSet redConfirmBillNoBillNoSet = Sets.newHashSetWithExpectedSize((int)32);
        block0: for (String mergeBillId : billInvoiceList.keySet()) {
            JSONArray invoices = billInvoiceList.getJSONArray(mergeBillId);
            for (int i = 0; i < invoices.size(); ++i) {
                String originalRemark;
                boolean isRedConfirm;
                String reuslt;
                String billno;
                boolean isEle;
                JSONObject invoice = invoices.getJSONObject(i);
                RedConfirmHelper.dealRedConfirmBillItem((JSONObject)invoice);
                boolean elePaper = AllEleAuthHelper.isElePaper((Object)invoice.getString("iselepaper"));
                boolean bl = isEle = elePaper || InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype"));
                if (isEle && IssueType.RED_INVOICE.getTypeCode().equals(invoice.get((Object)"issuetype"))) {
                    String redConfirmBillNo = (String)invoice.get((Object)"infocode");
                    if (redConfirmBillNoBillNoSet.contains(redConfirmBillNo)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u5355\u636e\u7f16\u53f7%s\u5728\u8be5\u6279\u6b21\u4e2d\u91cd\u590d", (String)"BillProcessTabUtil_2", (String)"imc-sim-service", (Object[])new Object[0]), redConfirmBillNo));
                    }
                    redConfirmBillNoBillNoSet.add(redConfirmBillNo);
                }
                String invoiceType = invoice.getString("invoicetype");
                if (!workbenchtype) {
                    billno = invoice.getString("billno");
                } else {
                    JSONObject mergeBillJson = JSONObject.parseObject((String)AbstractBillWorkbenchCustomEvent.getPageCacheVal(that, mergeBillId));
                    billno = mergeBillJson.getString("billno");
                }
                if (!elePaper && invoice.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) < 0 && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)invoice.getString("infocode")) && InvoiceUtils.isSpecialInvoice((String)invoiceType) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(reuslt = OriginalBillFormEditUtil.checkInfoCode(invoice.getString("infocode"), billno, invoice.getString("infocodefrombill"), DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get((Object)"orgid")))))) {
                    throw new KDBizException(reuslt);
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)invoice.getString("buyerproperty")) && invoice.getString("buyerproperty").equals("1")) {
                    negativeNormalInvoice = Boolean.TRUE;
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoice.getString("buyername"))) {
                        errBuyerInfoJOSN.add((Object)billno);
                        flag = Boolean.FALSE;
                        continue block0;
                    }
                    if (elePaper || invoice.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) >= 0 || !InvoiceUtils.isNormalInvoice((String)invoiceType)) continue;
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoice.getString("originalinvoicecode")) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoice.getString("originalinvoiceno"))) {
                        errBlueInfoJSON.add((Object)billno);
                        flag = Boolean.FALSE;
                        continue block0;
                    }
                    if (!RegexUtil.isInvoiceCode((String)invoice.getString("originalinvoicecode")) || !RegexUtil.isInvoiceNo((String)invoice.getString("originalinvoiceno"))) {
                        errBlueMsgJSON.add((Object)billno);
                        flag = Boolean.FALSE;
                        continue block0;
                    }
                    boolean isBiggerThanBlue = BillProcessTabUtil.checkBlueInvoiceAmount(invoice);
                    if (!isBiggerThanBlue) continue;
                    errBlueAmountJSON.add((Object)billno);
                    flag = Boolean.FALSE;
                    continue block0;
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoice.getString("buyername")) || InvoiceUtils.isSpecialInvoice((String)invoice.getString("invoicetype")) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoice.getString("buyertaxno"))) {
                    errBuyerInfoJOSN.add((Object)billno);
                    flag = Boolean.FALSE;
                    continue block0;
                }
                if (invoice.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) < 0) {
                    if (InvoiceUtils.isNormalInvoice((String)invoiceType) && !isEle) {
                        negativeNormalInvoice = Boolean.TRUE;
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoice.getString("originalinvoicecode")) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoice.getString("originalinvoiceno"))) {
                            errBlueInfoJSON.add((Object)billno);
                            flag = Boolean.FALSE;
                            continue block0;
                        }
                        if (!RegexUtil.isInvoiceCode((String)invoice.getString("originalinvoicecode")) || !RegexUtil.isInvoiceNo((String)invoice.getString("originalinvoiceno"))) {
                            errBlueMsgJSON.add((Object)billno);
                            flag = Boolean.FALSE;
                            continue block0;
                        }
                        if (BillProcessTabUtil.checkBlueInvoiceAmount(invoice)) {
                            errBlueAmountJSON.add((Object)billno);
                            flag = Boolean.FALSE;
                            continue block0;
                        }
                        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
                        DynamicObjectUtil.json2DynamicObjectContainItems((JSONObject)invoice, (DynamicObject)obj);
                        obj.set("blueinvoicecode", invoice.get((Object)"originalinvoicecode"));
                        obj.set("blueinvoiceno", invoice.get((Object)"originalinvoiceno"));
                        obj.set("blueinvoicetype", invoice.get((Object)"originalinvoicetype"));
                        CheckResult checkResult = OriginalBillFormEditUtil.checkNormalRedReasonInfo(new DynamicObject[]{obj}, Boolean.FALSE, Boolean.FALSE);
                        ArrayList<String> errMsgList = checkResult.getErrMsgList();
                        if (!errMsgList.isEmpty()) {
                            String[] start = errMsgList.get(0).split("\\[");
                            String[] end = start[1].split("\\]");
                            errNormalRedJOSN.add((Object)(start[0] + "[" + billno + "]" + end[1]));
                            flag = Boolean.FALSE;
                            continue block0;
                        }
                    } else if ((InvoiceUtils.isSpecialInvoice((String)invoiceType) || isEle) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoice.getString("infocode"))) {
                        if (invoice.getString("applicant").equals(RedInfoConstant.ApplicantEnum.SALER.getCode())) {
                            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoice.getString("originalissuetime")) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoice.getString("originalinvoicecode")) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoice.getString("originalinvoiceno"))) {
                                errBlueInfoJSON.add((Object)billno);
                                flag = Boolean.FALSE;
                            }
                        } else if (!invoice.getString("applicant").equals(RedInfoConstant.ApplicantEnum.SALER.getCode())) {
                            errRedInfoJSON.add((Object)invoice);
                            flag = Boolean.FALSE;
                        }
                    }
                } else if (InvoiceUtils.isEtcInvoice((String)invoiceType) && CheckPhoneEnum.DEFAULT.getCode().equals(checkPhone)) {
                    blueEtc = Boolean.TRUE;
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoice.getString("buyeremail")) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoice.getString("buyerphone"))) {
                        errBlueInfoJSON.add((Object)billno);
                        flag = Boolean.FALSE;
                    } else {
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)invoice.getString("buyeremail"))) {
                            String[] split = invoice.getString("buyeremail").split(";");
                            if (split.length > 3) {
                                errBlueInfoJSON.add((Object)billno);
                                flag = Boolean.FALSE;
                            } else {
                                for (String s : split) {
                                    if (RegexUtil.isEmail((String)s)) continue;
                                    errBlueInfoJSON.add((Object)billno);
                                    flag = Boolean.FALSE;
                                    break;
                                }
                            }
                        }
                        if (flag.booleanValue() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)invoice.getString("buyerphone")) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoice.getString("buyeremail"))) {
                            if (!msgSendFlag) {
                                that.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e{%1$s}\u6240\u5c5e\u4f01\u4e1a\u8fd8\u672a\u5f00\u901a\u53d1\u7968\u4e91\u77ed\u4fe1\u670d\u52a1\uff0c\u65e0\u6cd5\u63a8\u9001\u53d1\u7968\u77ed\u4fe1\u3002\u8bf7\u5148\u5728\u57fa\u7840\u53c2\u6570\u8bbe\u7f6e/\u77ed\u4fe1\u6743\u9650\u63a7\u5236/\u4e2d\u5f00\u542f\u77ed\u4fe1\u670d\u52a1\u53c2\u6570", (String)"BillProcessTabUtil_3", (String)"imc-sim-service", (Object[])new Object[0]), billno));
                                return result;
                            }
                            if (!InvoiceValidHelper.isMobile((String)invoice.getString("buyerphone"))) {
                                errBlueInfoJSON.add((Object)billno);
                                flag = Boolean.FALSE;
                            }
                        }
                    }
                }
                DynamicObject invDy = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
                DynamicObjectUtil.json2DynamicObjectContainItems((JSONObject)invoice, (DynamicObject)invDy, (boolean)true);
                String remark = RemarkTemplateHelper.generateRemark((DynamicObject)invDy);
                boolean isRedInfo = invDy.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0 && InvoiceUtils.isSpecialInvoice((String)invDy.getString("invoicetype"));
                boolean bl2 = isRedConfirm = invDy.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0 && InvoiceUtils.isAllEInvoice((Object)invDy.getString("invoicetype"));
                if (isRedConfirm) {
                    String redConfirmBillNo = invoice.getString("infocode");
                    String oriInvoiceNo = invoice.getString("originalinvoiceno");
                    String redConfirmRemark = RemarkTemplateHelper.generateRedAllEleRemark((String)redConfirmBillNo, (String)oriInvoiceNo);
                    String oriRemark = invoice.getString("remark");
                    invoice.put("remark", (Object)(redConfirmRemark + oriRemark));
                    invoice.put("addPreviewApplyReason", (Object)redConfirmRemark);
                    continue;
                }
                if (isRedInfo || !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(originalRemark = invoice.getString("remark"))) && (originalRemark.contains(invDy.getString("originalinvoicecode")) || originalRemark.contains(invDy.getString("originalinvoiceno")))) continue;
                invoice.put("remark", (Object)remark);
            }
        }
        HashMap tipsMap = Maps.newHashMap();
        if (errBuyerInfoJOSN.size() > 0) {
            that.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u8bf7\u8865\u8d2d\u65b9\u4fe1\u606f", (String)"BillProcessTabUtil_4", (String)"imc-sim-service", (Object[])new Object[0]), errBuyerInfoJOSN.toJSONString()));
        } else if (errBlueInfoJSON.size() > 0) {
            String message = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u8bf7\u8865\u5145\u539f\u84dd\u7968\u4ee3\u7801\u3001\u539f\u84dd\u7968\u53f7\u7801\u3001\u539f\u84dd\u7968\u5f00\u7968\u65e5\u671f\uff0c\u6216\u8005\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7\u3002", (String)"BillProcessTabUtil_5", (String)"imc-sim-service", (Object[])new Object[0]);
            if (negativeNormalInvoice.booleanValue()) {
                message = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u8bf7\u8865\u5145\u539f\u84dd\u7968\u4ee3\u7801\u3001\u539f\u84dd\u7968\u53f7\u7801\u3001\u539f\u84dd\u7968\u5f00\u7968\u65e5\u671f\u3001\u539f\u84dd\u7968\u79cd\u7c7b\u3001\u51b2\u7ea2\u539f\u56e0", (String)"BillProcessTabUtil_6", (String)"imc-sim-service", (Object[])new Object[0]);
            } else if (blueEtc.booleanValue()) {
                message = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u8bf7\u8865\u5145\u6b63\u786e\u7684\u6536\u7968\u90ae\u7bb1\u6216\u6536\u7968\u624b\u673a\u53f7\uff0c\u6536\u7968\u90ae\u7bb1\u4e0d\u80fd\u8d85\u8fc73\u4e2a\uff0c\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00\u3002", (String)"BillProcessTabUtil_7", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            that.getView().showTipNotification(String.format(message, errBlueInfoJSON.toJSONString()));
        } else if (errBlueMsgJSON.size() > 0) {
            that.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u7684\u539f\u84dd\u7968\u4ee3\u7801\u3001\u539f\u84dd\u7968\u53f7\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6b63\u3002", (String)"BillProcessTabUtil_8", (String)"imc-sim-service", (Object[])new Object[0]), errBlueMsgJSON.toJSONString()));
        } else if (errBlueAmountJSON.size() > 0) {
            that.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u7684\u539f\u84dd\u7968\u4ee3\u7801\u3001\u539f\u84dd\u7968\u53f7\u7801\u5bf9\u5e94\u53d1\u7968\u7684\u91d1\u989d\u5c0f\u4e8e\u7ea2\u5b57\u53d1\u7968\u7684\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BillProcessTabUtil_9", (String)"imc-sim-service", (Object[])new Object[0]), errBlueAmountJSON.toJSONString()));
        } else if (errRedInfoJSON.size() > 0) {
            tipsMap.put("data", errRedInfoJSON);
            ViewUtil.openDialog((AbstractFormPlugin)that, (String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u65e0\u7ea2\u5b57\u4fe1\u606f\u8868\uff0c\u8bf7\u5148\u8865\u5145\u6570\u636e", (String)"BillProcessTabUtil_10", (String)"imc-sim-service", (Object[])new Object[0]), (Map)tipsMap, (String)"sim_process_redinfo_check", (String)"sim_process_redinfo_check");
        } else if (errNormalRedJOSN.size() > 0) {
            that.getView().showTipNotification(String.join((CharSequence)"\r\n", (Iterable)JSONArray.toJavaObject((JSON)errNormalRedJOSN, ArrayList.class)));
        }
        if (flag.booleanValue()) {
            result.put("data", "success");
            result.put("treatmentInvoiceList", billInvoiceList);
            BillProcessTabUtil.statisticsInvoice(that, billInvoiceList);
            result.put("eventKey", "process/nextstepcheck");
        }
        return result;
    }

    private static void statisticsInvoice(AbstractFormPlugin that, JSONObject billInvoiceList) {
        HashMap<Object, BillPreviewStatisticsDTO> map = new HashMap<Object, BillPreviewStatisticsDTO>(4);
        Set entries = billInvoiceList.entrySet();
        for (Map.Entry entry : entries) {
            JSONArray billInvoices = (JSONArray)entry.getValue();
            for (int i = 0; i < billInvoices.size(); ++i) {
                JSONObject invoice = billInvoices.getJSONObject(i);
                BillPreviewStatisticsDTO previewStatistics = map.computeIfAbsent(invoice.get((Object)"invoicetype"), k -> new BillPreviewStatisticsDTO());
                previewStatistics.setInvoiceType(invoice.getString("invoicetype"));
                previewStatistics.setInvoiceCount(previewStatistics.getInvoiceCount() + 1);
                previewStatistics.setInvoiceAmount(previewStatistics.getInvoiceAmount().add(invoice.getBigDecimal("invoiceamount")));
                previewStatistics.setTotalTax(previewStatistics.getTotalTax().add(invoice.getBigDecimal("totaltax")));
                previewStatistics.setTotalAmount(previewStatistics.getTotalAmount().add(invoice.getBigDecimal("totalamount")));
            }
        }
        AbstractBillWorkbenchCustomEvent.putPageCache(that, "sim_preview_statistics", JSONObject.toJSONString(map.values()));
    }

    public static void handleCustomEventSelectSalerAddr(AbstractFormPlugin that, ClosedCallBackEvent event) {
        if (null == event.getReturnData()) {
            return;
        }
        ListSelectedRowCollection list = (ListSelectedRowCollection)event.getReturnData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        if (list.size() > 1) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u5355\u6761\u8bb0\u5f55", (String)"BillProcessTabUtil_11", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        Object primaryKeyValue = list.get(0).getPrimaryKeyValue();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"sim_invoice_setting");
        JSONObject jsonData = new JSONObject();
        jsonData.put("invoiceaddr", (Object)object.getString("invoiceaddr"));
        jsonData.put("openuserbank", (Object)object.getString("openuserbank"));
        HashMap customMap = Maps.newHashMap();
        customMap.put("data", jsonData);
        AbstractBillWorkbenchCustomEvent.updateCustomControl(that, customMap, "preview/change_saler_address");
    }

    public static void handleCustomEventopenQueryPlaceList(AbstractFormPlugin that, ClosedCallBackEvent event, String eventKey) {
        ListSelectedRowCollection list = (ListSelectedRowCollection)event.getReturnData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        DynamicObject admindivision = BusinessDataServiceHelper.loadSingleFromCache((Object)list.get(0).getPrimaryKeyValue(), (String)"bdm_admindivision");
        HashMap<String, String> showDataMap = new HashMap<String, String>((Map<String, String>)JSONObject.parseObject((String)that.getPageCache().get(that.getView().getPageId() + "queryPlace")));
        showDataMap.put("place", admindivision.getString("name"));
        HashMap customMap = Maps.newHashMap();
        customMap.put("data", showDataMap);
        AbstractBillWorkbenchCustomEvent.updateCustomControl(that, customMap, eventKey);
    }

    public static void handleCustomEventShowConfirm(AbstractFormPlugin that, MessageBoxClosedEvent event) {
        String cacheValue = AbstractBillWorkbenchCustomEvent.getPageCacheVal(that, "common/show_confirm");
        JSONObject json = JSONObject.parseObject((String)cacheValue);
        if (event.getResult() == MessageBoxResult.Yes) {
            json.put("isOk", (Object)Boolean.TRUE);
        } else {
            json.put("isOk", (Object)Boolean.FALSE);
        }
        that.getPageCache().remove("common/show_confirm");
        HashMap customMap = Maps.newHashMap();
        customMap.put("data", json);
        AbstractBillWorkbenchCustomEvent.updateCustomControl(that, customMap, "common/show_confirm");
    }

    public static void fillInvoiceInfoFromBill(DynamicObject[] bills, List<BillRelationDTO> invRelation, List<DynamicObject> invoiceList) {
        try {
            JSONObject convertJson;
            Set<Object> invFieldSet;
            String configValue = ImcConfigUtil.getValue((String)CacheKeyEnum.SIM_BILL_2_INV_ITEMS_MAPPING.getConfigType(), (String)CacheKeyEnum.SIM_BILL_2_INV_ITEMS_MAPPING.getConfigKey());
            if (StringUtils.isBlank((String)configValue)) {
                return;
            }
            if (invoiceList.size() == 0) {
                return;
            }
            if (null == bills) {
                Set billPk = invRelation.stream().map(BillRelationDTO::getsBillId).collect(Collectors.toSet());
                bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)true), (QFilter[])new QFilter("id", "in", (Object)billPk.toArray()).toArray());
            }
            if (!BillProcessTabUtil.isConvert(invoiceList, invFieldSet = (convertJson = JSONObject.parseObject((String)configValue)).values().stream().collect(Collectors.toSet()))) {
                return;
            }
            HashMap<Long, Set<Long>> invItem2BillMap = new HashMap<Long, Set<Long>>();
            HashMap<Long, DynamicObject> itemPkMap = new HashMap<Long, DynamicObject>();
            BillProcessTabUtil.billItemsRelation(bills, invRelation, invItem2BillMap, itemPkMap);
            BillProcessTabUtil.convertItemField(invoiceList, convertJson, invItem2BillMap, itemPkMap);
        }
        catch (Exception e) {
            LOGGER.error("fillInvoiceInfoFromBillError:" + e.getMessage(), (Throwable)e);
        }
    }

    private static void convertItemField(List<DynamicObject> invoiceList, JSONObject convertJson, HashMap<Long, Set<Long>> invItem2BillMap, HashMap<Long, DynamicObject> itemPkMap) {
        for (DynamicObject waitInv : invoiceList) {
            DynamicObjectCollection items = waitInv.getDynamicObjectCollection("items");
            for (DynamicObject item : items) {
                long itemPk = item.getLong("id");
                Set<Long> billDetailPks = invItem2BillMap.get(itemPk);
                for (Map.Entry entry : convertJson.entrySet()) {
                    String fromField = (String)entry.getKey();
                    String toField = (String)entry.getValue();
                    Object toValue = item.get(toField);
                    Object fromValue = BillProcessTabUtil.getFromValue(billDetailPks, itemPkMap, fromField);
                    if (!BillProcessTabUtil.isFieldBlank(toValue) || BillProcessTabUtil.isFieldBlank(fromValue)) continue;
                    item.set(toField, fromValue);
                }
            }
        }
    }

    private static Object getFromValue(Set<Long> billDetailPks, HashMap<Long, DynamicObject> itemPkMap, String fromField) {
        for (Long billDetailPk : billDetailPks) {
            Object value;
            DynamicObject billDetail = itemPkMap.get(billDetailPk);
            if (null == billDetail || BillProcessTabUtil.isFieldBlank(value = billDetail.get(fromField))) continue;
            return value;
        }
        return null;
    }

    private static boolean isFieldBlank(Object value) {
        if (null == value || value instanceof String) {
            return StringUtils.isBlank((String)((String)value));
        }
        if (value instanceof BigDecimal) {
            return BigDecimalUtil.compareZero((BigDecimal)((BigDecimal)value));
        }
        if (value instanceof Long) {
            return BigDecimalUtil.compareZero((BigDecimal)new BigDecimal((Long)value));
        }
        return false;
    }

    private static void billItemsRelation(DynamicObject[] bills, List<BillRelationDTO> invRelation, HashMap<Long, Set<Long>> invItem2BillMap, HashMap<Long, DynamicObject> itemPkMap) {
        for (BillRelationDTO billRelationDTO : invRelation) {
            invItem2BillMap.computeIfAbsent(billRelationDTO.gettDetailId(), k -> new HashSet());
            Set<Long> sDetailIds = invItem2BillMap.get(billRelationDTO.gettDetailId());
            sDetailIds.add(billRelationDTO.getsDetailId());
        }
        for (DynamicObject bill : bills) {
            DynamicObjectCollection billItems = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject billItem : billItems) {
                itemPkMap.put((Long)billItem.getPkValue(), billItem);
            }
        }
    }

    private static boolean isConvert(List<DynamicObject> invoiceList, Set<Object> invFieldSet) {
        boolean isConvert = false;
        for (DynamicObject invoice : invoiceList) {
            DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
            for (DynamicObject item : items) {
                for (Object o : invFieldSet) {
                    String invItemFieldKey = (String)o;
                    Object value = item.get(invItemFieldKey);
                    if (null == value || value instanceof String) {
                        if (StringUtils.isBlank((String)((String)value))) {
                            isConvert = true;
                        }
                    } else if (value instanceof BigDecimal) {
                        if (BigDecimalUtil.compareZero((BigDecimal)((BigDecimal)value))) {
                            isConvert = true;
                        }
                    } else if (value instanceof Long && BigDecimalUtil.compareZero((BigDecimal)new BigDecimal((Long)value))) {
                        isConvert = true;
                    }
                    if (!isConvert) continue;
                    break;
                }
                if (!isConvert) continue;
                break;
            }
            if (!isConvert) continue;
            break;
        }
        return isConvert;
    }

    public static void setDrawerAndAccount(List<DynamicObject> originalBillList, String accountStr) {
        String account;
        String drawer;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)accountStr) || CollectionUtils.isEmpty(originalBillList)) {
            return;
        }
        if (accountStr.contains("|")) {
            drawer = accountStr.split("\\|")[0].replaceAll(" ", "");
            account = accountStr.split("\\|")[1].replaceAll(" ", "");
        } else {
            account = accountStr;
            drawer = AllEleAuthHelper.getDrawerByAccount((String)originalBillList.get(0).getString("salertaxno"), (String)accountStr);
        }
        for (DynamicObject bill : originalBillList) {
            bill.set("account", (Object)account);
            bill.set("drawer", (Object)drawer);
        }
    }
}

