/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.pluginworkutils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageTypes;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.utils.BillOperationLockUtil;
import kd.imc.sim.common.utils.SimpleGoodsNameUtil;
import kd.imc.sim.common.utils.ZeroTaxMarkUtil;
import kd.imc.sim.common.utils.ZeroTaxRateShowHelper;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.pluginworkutils.BillProcessTabUtil;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillSplitWorkBenchMergeHelper;
import kd.imc.sim.formplugin.issuing.helper.IssueInvoiceControlHelper;

public class BillSplitWorkBenchUtil {
    private static final Log LOGGER = LogFactory.getLog(BillSplitWorkBenchUtil.class);

    public static void processNextStep(AbstractFormPlugin that, String ars) {
        try {
            boolean itemIsAllLargeZero;
            JSONObject request = JSONObject.parseObject((String)ars);
            String result = BillSplitWorkBenchUtil.checkAmountBiggerThanZero(request);
            if (StringUtils.isNotBlank((CharSequence)result)) {
                that.getView().showErrorNotification(result);
                return;
            }
            Map<String, Object> processMap = BillProcessTabUtil.processnextstep(that, request);
            if (CollectionUtils.isEmpty(processMap)) {
                return;
            }
            JSONObject billInvoiceJson = (JSONObject)processMap.get("treatmentInvoiceList");
            processMap.put("invRealtion", request.get((Object)"invRealtion"));
            String originTreatmentInvoiceListStr = JSONObject.toJSONString((Object)billInvoiceJson);
            DynamicObject[] originalBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "invoiceamount", "totaltax", "totalamount", "systemsource", "splitormergeflag"), (QFilter[])new QFilter("id", "in", (Object)request.getJSONArray("billIds").stream().map(json -> Long.parseLong(String.valueOf(json))).toArray()).toArray());
            BigDecimal allAmount = BigDecimal.ZERO;
            BigDecimal allTax = BigDecimal.ZERO;
            BigDecimal allTaxAmount = BigDecimal.ZERO;
            for (DynamicObject originalBill : originalBills) {
                allAmount = allAmount.add(originalBill.getBigDecimal("invoiceamount"));
                allTax = allTax.add(originalBill.getBigDecimal("totaltax"));
                allTaxAmount = allTaxAmount.add(originalBill.getBigDecimal("totalamount"));
            }
            boolean mergeBillDetail = BillSplitWorkBenchUtil.getMergeBillDetailFlag(request, originalBills);
            if (mergeBillDetail) {
                try {
                    billInvoiceJson = BillSplitWorkBenchMergeHelper.dynamicObjectCount(that, billInvoiceJson, request.getString("jqbh"), request, allAmount);
                    if (StringUtils.isBlank((CharSequence)AbstractBillWorkbenchCustomEvent.getPageCacheVal(that, "treatmentHadEdit"))) {
                        BillSplitWorkBenchUtil.dealInvRelation(processMap, billInvoiceJson);
                    }
                }
                catch (MsgException e) {
                    that.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u7684\u660e\u7ec6\u5408\u5e76\u540e\u8d85\u8fc7\u7a0e\u63a7\u5141\u8bb8\u7684\u5c3e\u5dee\uff0c\u65e0\u6cd5\u5408\u5e76\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u5355\u636e\u6216\u5728\u3010\u53d1\u7968\u62c6\u5408\u8bbe\u7f6e\u3011\u4e2d\u91cd\u65b0\u914d\u7f6e\u5408\u5e76\u89c4\u5219\u3002", (String)"BillSplitWorkBenchUtil_0", (String)"imc-sim-service", (Object[])new Object[0]), e.getErrorMsg(), MessageTypes.Commit);
                    return;
                }
            }
            if (itemIsAllLargeZero = BillSplitWorkBenchUtil.checkDetailItemIsLargeZero(billInvoiceJson)) {
                AbstractBillWorkbenchCustomEvent.putPageCache(that, "invRelations", SerializationUtils.toJsonString((Object)processMap.get("invRealtion")));
                ZeroTaxRateShowHelper.dealProcessInvoiceAndItem(processMap);
                AbstractBillWorkbenchCustomEvent.updateCustomControl(that, processMap, "process/nextstepcheck");
                return;
            }
            if (!mergeBillDetail) {
                that.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u7684\u660e\u7ec6\u5546\u54c1\u884c\u5b58\u5728\u672a\u5408\u5e76\u7684\u975e\u6b63\u6570\u884c\uff0c\u8bf7\u8c03\u6574\u660e\u7ec6\u540e\u518d\u64cd\u4f5c", (String)"BillSplitWorkBenchUtil_1", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            JSONObject invoice = billInvoiceJson.getJSONArray(billInvoiceJson.keySet().toArray(new String[0])[0]).getJSONObject(0);
            if (allTaxAmount.compareTo(invoice.getBigDecimal("totalamount")) != 0) {
                that.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1\u4e0e\u539f\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"BillSplitWorkBenchUtil_2", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            BillSplitWorkBenchUtil.checkMergeBillDetialIsLargeZero(billInvoiceJson);
            processMap.put("allAmount", allAmount.setScale(2, 4).toString());
            processMap.put("allTax", allTax.setScale(2, 4).toString());
            processMap.put("allTaxAmount", allTaxAmount.setScale(2, 4).toString());
            processMap.put("origin_treatmentInvoiceList", JSONObject.parseObject((String)originTreatmentInvoiceListStr));
            AbstractBillWorkbenchCustomEvent.putPageCache(that, "sim_process_discount", SerializationUtils.toJsonString(processMap));
            ViewUtil.openNormalConfirm((AbstractFormPlugin)that, (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u4e2d\u7684\u8d1f\u6570\u884c\u65e0\u6cd5\u88ab\u5408\u5e76\u51b2\u62b5\uff0c\u662f\u5426\u624b\u52a8\u6307\u5b9a\u8d1f\u6570\u884c\u4f5c\u4e3a\u6b63\u6570\u884c\u7684\u6298\u6263\u884c\u8fdb\u884c\u5f00\u7968\uff1f%s\u5982\u4e0d\u6307\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u5355\u636e\u540e\u63d0\u4ea4\u5f00\u7968\u3002", (String)"BillSplitWorkBenchUtil_10", (String)"imc-sim-service", (Object[])new Object[0]), System.lineSeparator()), (String)"sim_process_discounttip");
        }
        catch (Exception e) {
            LOGGER.error("\u624b\u5de5\u5904\u7406\u5408\u5e76\u70b9\u51fb\u4e0b\u4e00\u6b65\u5931\u8d25", (Throwable)e);
            AbstractBillWorkbenchCustomEvent.handleExcepiton(that, e);
            AbstractBillWorkbenchCustomEvent.updateCustomControlError(that, null, "process/nextstepcheck");
        }
    }

    private static boolean getMergeBillDetailFlag(JSONObject request, DynamicObject[] originalBills) {
        if (!"KINGDEE_FI".equals(originalBills[0].getString("systemsource"))) {
            return request.getBoolean("mergeBill");
        }
        String splitOrMergeFlag = originalBills[0].getString("splitormergeflag");
        return "2".equals(splitOrMergeFlag) || "3".equals(splitOrMergeFlag);
    }

    private static void dealInvRelation(Map<String, Object> processMap, JSONObject billInvoiceJson) {
        JSONObject relationJson = (JSONObject)processMap.get("invRealtion");
        Set mergeBillIdSet = billInvoiceJson.keySet();
        for (String mergeBillId : mergeBillIdSet) {
            JSONArray invoiceArr = billInvoiceJson.getJSONArray(mergeBillId);
            JSONArray relationArr = relationJson.getJSONArray(mergeBillId);
            for (int invoiceIndex = 0; invoiceIndex < invoiceArr.size(); ++invoiceIndex) {
                JSONObject invoice = invoiceArr.getJSONObject(invoiceIndex);
                JSONArray items = invoice.getJSONArray("items");
                for (int itemIndex = 0; itemIndex < items.size(); ++itemIndex) {
                    JSONObject item = items.getJSONObject(itemIndex);
                    String itemId = item.getString("id");
                    for (int i = 0; i < relationArr.size(); ++i) {
                        JSONObject relation = relationArr.getJSONObject(i);
                        if (!itemId.contains(relation.getString("tdetailid"))) continue;
                        relation.put("tdetailid", (Object)itemId);
                    }
                }
            }
        }
    }

    private static void checkMergeBillDetialIsLargeZero(JSONObject billInvciceJson) {
        Set billIdSet = billInvciceJson.keySet();
        for (String billId : billIdSet) {
            JSONArray invoiceArr = billInvciceJson.getJSONArray(billId);
            for (int i = 0; i < invoiceArr.size(); ++i) {
                JSONObject invoice = invoiceArr.getJSONObject(i);
                JSONArray items = invoice.getJSONArray("items");
                Map<String, List<JSONObject>> groupItems = items.stream().map(item -> (JSONObject)item).collect(Collectors.groupingBy(item -> item.getString("taxrate")));
                Set<Map.Entry<String, List<JSONObject>>> entries = groupItems.entrySet();
                for (Map.Entry<String, List<JSONObject>> entry : entries) {
                    BigDecimal sumAmount = entry.getValue().stream().map(item -> item.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (sumAmount.compareTo(BigDecimal.ZERO) > 0) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u7387%s\u5408\u5e76\u540e\u540c\u7a0e\u7387\u8d1f\u6570\u884c\u5927\u4e8e\u6b63\u6570\u884c\uff0c\u8bf7\u8c03\u6574\u660e\u7ec6\u540e\u518d\u64cd\u4f5c", (String)"BillSplitWorkBenchUtil_5", (String)"imc-sim-service", (Object[])new Object[0]), new BigDecimal(entry.getKey()).multiply(new BigDecimal("100")).toString() + "%"));
                }
            }
        }
    }

    public static boolean checkLookBillNos(JSONObject jsonArs) {
        JSONArray invBill = jsonArs.getJSONArray("invBill");
        ArrayList billNos = Lists.newArrayListWithCapacity((int)invBill.size());
        long org = invBill.getJSONObject(0).getLong("orgid");
        for (int i = 0; i < invBill.size(); ++i) {
            JSONObject inv = invBill.getJSONObject(i);
            billNos.add(inv.getString("billno"));
        }
        return BillOperationLockUtil.getBillsLock((List)billNos, (boolean)jsonArs.getBoolean("previewDataSave"), (long)org);
    }

    public static Map<String, List<DynamicObject>> json2Array(AbstractFormPlugin that, JSONObject jsonArs) {
        boolean treatmentHadEdit = StringUtils.isNotBlank((CharSequence)AbstractBillWorkbenchCustomEvent.getPageCacheVal(that, "treatmentHadEdit"));
        Map<String, Object> dealMap = BillSplitWorkBenchUtil.dealWithSpiltInvoiceJson(treatmentHadEdit, jsonArs, AbstractBillWorkbenchCustomEvent.getPageCacheVal(that, "invRelations"));
        AbstractBillWorkbenchCustomEvent.putPageCache(that, "resetJson", ((JSONObject)dealMap.get("invoices")).toJSONString());
        AbstractBillWorkbenchCustomEvent.putPageCache(that, "resetRelation", ((JSONObject)dealMap.get("invRealtion")).toJSONString());
        return (Map)dealMap.get("resultMap");
    }

    public static Map<String, Object> dealWithSpiltInvoiceJson(boolean treatmentHadEdit, JSONObject jsonArs, String invRelationStr) {
        HashMap reuslt = Maps.newHashMapWithExpectedSize((int)8);
        JSONObject invoices = jsonArs.getJSONObject("invoices");
        JSONArray originalBills = jsonArs.getJSONArray("invBill");
        JSONObject invRealtion = JSONObject.parseObject((String)invRelationStr);
        if (!treatmentHadEdit) {
            originalBills = BillSplitWorkBenchUtil.checkOriginalBillIsUse(originalBills, invRealtion);
        }
        ArrayList invoiceList = Lists.newArrayListWithCapacity((int)8);
        BigDecimal invoiceTotalTax = BigDecimal.ZERO;
        for (String mergeBillId : invoices.keySet()) {
            JSONArray invoiceArr = invoices.getJSONArray(mergeBillId);
            for (Object invoiceObj : invoiceArr) {
                JSONObject invoice = (JSONObject)invoiceObj;
                invoice.put("jqbh", (Object)jsonArs.getString("jqbh"));
                invoice.put("terminalno", (Object)jsonArs.getString("terminalNo"));
                invoice.put("account", (Object)jsonArs.getString("currentAccount"));
                BillSplitWorkBenchUtil.handleSplitByDetail(treatmentHadEdit, invoice, originalBills, invRealtion, mergeBillId);
                invoiceTotalTax = invoiceTotalTax.add(invoice.getBigDecimal("totaltax"));
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
                DynamicObjectUtil.json2DynamicObjectContainItems((JSONObject)invoice, (DynamicObject)dynamicObject, (boolean)true);
                dynamicObject.set("auditor", (Object)0L);
                dynamicObject.set("auditdate", null);
                dynamicObject.set("invoicecode", (Object)"");
                dynamicObject.set("invoiceno", (Object)"");
                dynamicObject.set("issuetime", null);
                dynamicObject.set("invoicestatus", (Object)"");
                dynamicObject.set("createtime", (Object)new Date());
                DynamicObjectCollection items = dynamicObject.getDynamicObjectCollection("items");
                for (DynamicObject item : items) {
                    ZeroTaxMarkUtil.handlerZeroTaxMark((DynamicObject)item);
                    SimpleGoodsNameUtil.handlerSimpleGoodsName((DynamicObject)item);
                }
                invoiceList.add(dynamicObject);
            }
        }
        HashMap<String, List<Object>> resultMap = new HashMap<String, List<Object>>(4);
        if (!jsonArs.getBoolean("previewDataSave").booleanValue()) {
            DynamicObject[] originalBillArr = BusinessDataServiceHelper.load((Object[])originalBills.stream().map(o -> ((JSONObject)o).getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
            List<DynamicObject> originalBillList = Stream.of(originalBillArr).collect(Collectors.toList());
            for (Object invoice : invoiceList) {
                invoice.set("batchbelong", ((DynamicObject)originalBillList.get(0)).get("billno"));
            }
            ArrayList invRelationDTOS = Lists.newArrayList();
            for (String invs : invRealtion.keySet()) {
                JSONArray invsArr = invRealtion.getJSONArray(invs);
                invRelationDTOS.addAll(JSONArray.parseArray((String)invsArr.toJSONString(), BillRelationDTO.class));
            }
            IssueInvoiceControlHelper.setSplitOriginalBillByInvRelation(originalBillList, invRelationDTOS);
            if (treatmentHadEdit) {
                BillSplitWorkBenchUtil.writeBackTaxdeviation(originalBillList, invoiceTotalTax);
            }
            List<DynamicObject> relations = IssueInvoiceControlHelper.saveInvRelation(invRelationDTOS);
            resultMap.put("relations", relations);
        } else {
            resultMap.put("relations", new ArrayList(1));
        }
        resultMap.put("invoiceList", invoiceList);
        resultMap.put("redInfoList", new ArrayList(1));
        reuslt.put("invoices", invoices);
        reuslt.put("invRealtion", invRealtion);
        reuslt.put("resultMap", resultMap);
        return reuslt;
    }

    public static void writeBackTaxdeviation(List<DynamicObject> originalBillList, BigDecimal invoiceTotalTax) {
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "confirmstate", "totaltax", "maintaxdeviation"), (QFilter[])new QFilter("id", "in", (Object)originalBillList.stream().map(bill -> bill.getLong("id")).toArray()).toArray());
        BigDecimal billTotalTax = Stream.of(bills).map(bill -> bill.getBigDecimal("totaltax")).reduce(BigDecimal.ZERO, BigDecimal::add);
        Stream.of(bills).max(Comparator.comparing(o -> o.getBigDecimal("totaltax"))).ifPresent(maxTaxBill -> maxTaxBill.set("maintaxdeviation", (Object)billTotalTax.subtract(invoiceTotalTax)));
        for (DynamicObject bill2 : bills) {
            bill2.set("confirmstate", (Object)"2");
        }
        ImcSaveServiceHelper.update((DynamicObject[])bills);
    }

    private static void handleSplitByDetail(boolean treatmentHadEdit, JSONObject invoice, JSONArray originalBill, JSONObject invRealtion, String mergeBillId) {
        String invoiceId = invoice.getString("id");
        if (!invoiceId.trim().startsWith("items")) {
            return;
        }
        Object org = originalBill.getJSONObject(0).get((Object)"orgid");
        invoice.put("billno", (Object)("200_" + UUID.getBatchNumber() + "_0001"));
        invoice.put("orderno", (Object)UUID.next());
        invoice.put("id", (Object)String.valueOf(DBServiceHelper.genGlobalLongId()));
        invoice.put("issuewritebackstatus", (Object)"0");
        invoice.put("abolishwritebackstatus", (Object)"2");
        invoice.put("invoicingoperator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        JSONArray jsonArray = invoice.getJSONArray("items");
        HashMap<String, String> webId2DbId = new HashMap<String, String>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject itemJSON = jsonArray.getJSONObject(i);
            itemJSON.put("seq", (Object)i);
            String newItemId = String.valueOf(DBServiceHelper.genGlobalLongId());
            webId2DbId.put(itemJSON.getString("id"), newItemId);
            itemJSON.put("id", (Object)newItemId);
        }
        if (treatmentHadEdit) {
            JSONArray newRelationArr = new JSONArray();
            for (Object invBillObj : originalBill) {
                JSONObject bill = (JSONObject)invBillObj;
                JSONObject newRelation = new JSONObject();
                newRelation.put("sbillid", bill.get((Object)"id"));
                newRelation.put("sbillno", bill.get((Object)"billno"));
                newRelation.put("tbillid", invoice.get((Object)"id"));
                newRelation.put("tbillno", (Object)invoice.getString("billno"));
                newRelation.put("ttable", (Object)"sim_vatinvoice");
                newRelation.put("orgid", org);
                newRelationArr.add((Object)newRelation);
            }
            invRealtion.put(mergeBillId, (Object)newRelationArr);
            return;
        }
        JSONArray relationArr = invRealtion.getJSONArray(mergeBillId);
        for (Object relationObj : relationArr) {
            JSONObject relationJson = (JSONObject)relationObj;
            String tDetialId = (String)webId2DbId.get(relationJson.getString("tdetailid"));
            if (!relationJson.get((Object)"tbillid").equals(invoiceId) || !StringUtils.isNotBlank((CharSequence)tDetialId)) continue;
            relationJson.put("tbillid", invoice.get((Object)"id"));
            relationJson.put("tdetailid", (Object)tDetialId);
            relationJson.put("tbillno", (Object)invoice.getString("billno"));
            relationJson.put("orgid", org);
        }
    }

    public static JSONArray checkOriginalBillIsUse(JSONArray billInv, JSONObject invRealtion) {
        List relationList = invRealtion.values().stream().map(relation -> (JSONArray)relation).collect(Collectors.toList());
        Set billIds = relationList.stream().flatMap(Collection::stream).map(relation -> ((JSONObject)relation).getString("sbillid")).collect(Collectors.toSet());
        JSONArray result = new JSONArray();
        for (int i = 0; i < billInv.size(); ++i) {
            JSONObject inv = billInv.getJSONObject(i);
            if (!billIds.contains(inv.getString("id"))) continue;
            result.add((Object)inv);
        }
        return result;
    }

    public static boolean checkDetailItemIsLargeZero(JSONObject billInvciceJson) {
        Set billIdSet = billInvciceJson.keySet();
        boolean result = true;
        for (String billId : billIdSet) {
            JSONArray invoiceArr = billInvciceJson.getJSONArray(billId);
            for (int invoiceIndex = 0; invoiceIndex < invoiceArr.size(); ++invoiceIndex) {
                JSONObject invoice = invoiceArr.getJSONObject(invoiceIndex);
                JSONArray items = invoice.getJSONArray("items");
                for (int itemIndex = 0; itemIndex < items.size(); ++itemIndex) {
                    JSONObject item = items.getJSONObject(itemIndex);
                    if (item.getBigDecimal("amount").compareTo(BigDecimal.ZERO) == 0) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u5408\u5e76\u540e\u91d1\u989d\u4e0d\u80fd\u4e3a0\uff0c\u5546\u54c1\u540d\u79f0\u4e3a[%s]", (String)"BillSplitWorkBenchUtil_6", (String)"imc-sim-service", (Object[])new Object[0]), item.getString("goodsname")));
                    }
                    if ("1".equals(item.getString("rowtype"))) {
                        JSONObject beDiscountItem = items.getJSONObject(itemIndex - 1);
                        if (beDiscountItem.getBigDecimal("amount").compareTo(item.getBigDecimal("amount").abs()) >= 0) continue;
                        result = false;
                        continue;
                    }
                    if (item.getBigDecimal("amount").compareTo(BigDecimal.ZERO) >= 0) continue;
                    result = false;
                }
            }
        }
        return result;
    }

    public static String checkAmountBiggerThanZero(JSONObject request) {
        String result = "";
        JSONObject billInvoiceJson = request.getJSONObject("data");
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        for (String billId : billInvoiceJson.keySet()) {
            JSONArray invoiceArr = billInvoiceJson.getJSONArray(billId);
            for (int i = 0; i < invoiceArr.size(); ++i) {
                JSONObject invoice = invoiceArr.getJSONObject(i);
                totalAmount = totalAmount.add(invoice.getBigDecimal("totalamount"));
                invoiceAmount = invoiceAmount.add(invoice.getBigDecimal("invoiceamount"));
                totalTax = totalTax.add(invoice.getBigDecimal("totaltax"));
            }
        }
        if (totalAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return ResManager.loadKDString((String)"\u6700\u7ec8\u7684\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u80fd\u5c0f\u4e8e\u96f6", (String)"BillSplitWorkBenchUtil_7", (String)"imc-sim-service", (Object[])new Object[0]);
        }
        if (invoiceAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return ResManager.loadKDString((String)"\u6700\u7ec8\u7684\u91d1\u989d\u5408\u8ba1\u4e0d\u80fd\u5c0f\u4e8e\u96f6", (String)"BillSplitWorkBenchUtil_8", (String)"imc-sim-service", (Object[])new Object[0]);
        }
        if (totalTax.compareTo(BigDecimal.ZERO) < 0) {
            return ResManager.loadKDString((String)"\u6700\u7ec8\u7684\u7a0e\u989d\u5408\u8ba1\u4e0d\u80fd\u5c0f\u4e8e\u96f6", (String)"BillSplitWorkBenchUtil_9", (String)"imc-sim-service", (Object[])new Object[0]);
        }
        return result;
    }
}

