/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.pluginworkutils;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.dto.bill.workbench.WorkbenchPrintInvoiceGroupDTO;
import kd.imc.sim.common.helper.WorkbenchPrintInvoiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class WorkbenchPrintUtil {
    private static Log LOGGER = LogFactory.getLog(WorkbenchPrintUtil.class);
    private static final String INV_PRINT_TIP_FORM_ID = "sim_inv_print_tip";

    public static void dealInvPrint(AbstractFormPlugin that, DynamicObject[] printInvObjs) {
        List invoiceList = Stream.of(printInvObjs).filter(invoice -> IssueStatusEnum.ok.getCode().equals(invoice.getString("issuestatus")) && InvoiceUtils.isPaperInvoice((String)invoice.getString("invoicetype"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(invoiceList)) {
            that.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u6253\u5370\u7684\u53d1\u7968", (String)"WorkbenchPrintUtil_0", (String)"imc-sim-service", (Object[])new Object[0]));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u53d1\u7968\u6253\u5370\u6570\u636e\u5f02\u5e38\uff0c\u63d0\u4ea4\u7684\u53d1\u7968\u6570\u636e\u662f\uff1a%s", SerializationUtils.toJsonString((Object)printInvObjs)));
            }
            return;
        }
        HashMap paramMap = Maps.newHashMap();
        List printGroups = WorkbenchPrintInvoiceHelper.groupBy(invoiceList);
        paramMap.put(InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), WorkbenchPrintUtil.getPrintGroupByInvoiceType(printGroups, InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode()));
        paramMap.put(InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode(), WorkbenchPrintUtil.getPrintGroupByInvoiceType(printGroups, InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode()));
        List detailInvoiceList = WorkbenchPrintInvoiceHelper.getDetailList(invoiceList);
        paramMap.put("detailInvoiceList", detailInvoiceList);
        paramMap.put("jqbh", ((DynamicObject)invoiceList.get(0)).getString("jqbh"));
        ViewUtil.openDialog((AbstractFormPlugin)that, (Map)paramMap, (String)INV_PRINT_TIP_FORM_ID, (String)INV_PRINT_TIP_FORM_ID.concat("CALLBACK"));
    }

    private static WorkbenchPrintInvoiceGroupDTO getPrintGroupByInvoiceType(List<WorkbenchPrintInvoiceGroupDTO> printGroups, String invoiceType) {
        List groups = printGroups.stream().filter(group -> invoiceType.equals(group.getInvoiceType())).collect(Collectors.toList());
        return CollectionUtils.isEmpty(groups) ? null : (WorkbenchPrintInvoiceGroupDTO)groups.get(0);
    }
}

