/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench.task;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.dto.minusbill.MinusBillDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillMatchConfig;
import kd.imc.sim.formplugin.bill.originalbill.workbench.task.AbstractJobTask;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;
import kd.imc.sim.formplugin.match.RedConfirmMatchHelper;

public class AutoBillMatchTask
extends AbstractJobTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u81ea\u52a8\u5339\u914d", (String)"AutoBillMatchTask_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), null);
        Map request = (Map)map.get("request");
        try (DLock lock = DLock.create((String)("AutoMatchLock" + RequestContext.get().getOrgId()));){
            if (!lock.tryLock(1000L)) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", Boolean.FALSE);
                result.put("errMsg", String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u6b63\u5728\u81ea\u52a8\u5339\u914d\uff0c\u8bf7\u5339\u914d\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u64cd\u4f5c", (String)"AutoBillMatchTask_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), RequestContext.get().getOrgId()));
                this.feedbackCustomdata(result);
                return;
            }
            Object redPK = request.get("redConfig");
            Object bluePK = request.get("blueConfig");
            if (StringUtils.isBlank(redPK) || StringUtils.isBlank(bluePK)) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", Boolean.FALSE);
                result.put("errMsg", String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u84dd\u7968/\u5339\u914d\u7ea2\u5b57\u786e\u8ba4\u5355\u89c4\u5219\uff0c\u8bf7\u5148\u914d\u7f6e", (String)"AutoBillMatchTask_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), RequestContext.get().getOrgId()));
                this.feedbackCustomdata(result);
                return;
            }
            DynamicObject redConfig = BusinessDataServiceHelper.loadSingle(redPK, (String)"bdm_match_redconfirm");
            DynamicObject blueConfig = BusinessDataServiceHelper.loadSingle(bluePK, (String)"bdm_match_ori_inv_setting");
            String redReason = (String)request.get("redReason");
            List matchBillListStr = (List)request.get("matchBills");
            ArrayList matchBillList = Lists.newArrayListWithCapacity((int)0);
            for (String matchBillStr : matchBillListStr) {
                DynamicObject matchBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_match_bill");
                DynamicObjectUtil.json2DynamicObjectContainItems((JSONObject)JSONObject.parseObject((String)matchBillStr), (DynamicObject)matchBill, (boolean)true);
                if (MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(matchBill.getString("matchstatus"))) continue;
                matchBillList.add(matchBill);
            }
            if (matchBillList.size() == 0) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", Boolean.FALSE);
                result.put("errMsg", String.format(ResManager.loadKDString((String)"\u5339\u914d\u5b8c\u6210\uff0c\u65e0\u9700\u518d\u6b21\u5339\u914d", (String)"AutoBillMatchTask_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), RequestContext.get().getOrgId()));
                this.feedbackCustomdata(result);
                return;
            }
            this.autoMatchDataFormat(redConfig, blueConfig, redReason, matchBillList);
        }
    }

    private void autoMatchDataFormat(DynamicObject redConfig, DynamicObject blueConfig, String redReason, List<DynamicObject> matchBillList) {
        int num = 1;
        this.feedbackProgress(this.calculateProcess(num, matchBillList.size()), String.format(ResManager.loadKDString((String)"\u5171%1$s\u4e2a\u5355\u636e\uff0c\u7b2c%2$s\u4e2a\u5355\u636e", (String)"AutoBillMatchTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), matchBillList.size(), num), null);
        ArrayList matchBillBlueList = Lists.newArrayListWithCapacity((int)0);
        ArrayList matchBillRedList = Lists.newArrayListWithCapacity((int)0);
        ArrayList matchBillSuccessList = Lists.newArrayListWithCapacity((int)0);
        for (DynamicObject dynamicObject : matchBillList) {
            dynamicObject.set("matchConfig", (Object)redConfig);
            if (!StringUtils.isEmpty((CharSequence)dynamicObject.getString("redreason"))) continue;
            dynamicObject.set("redreason", (Object)redReason);
        }
        for (DynamicObject dynamicObject : matchBillList) {
            if (MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode().equals(dynamicObject.getString("matchstatus")) && "0".equals(dynamicObject.getString("matchtarget"))) {
                matchBillBlueList.add(dynamicObject);
                continue;
            }
            matchBillRedList.add(dynamicObject);
        }
        if (redConfig != null) {
            RedConfirmMatchHelper redConfirmMatchHelper = new RedConfirmMatchHelper();
            redConfirmMatchHelper.matchRedConfirm(matchBillRedList);
            for (DynamicObject matchBill : matchBillRedList) {
                if (MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode().equals(matchBill.getString("matchstatus")) || MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(matchBill.getString("matchstatus"))) {
                    matchBillSuccessList.add(matchBill);
                    continue;
                }
                matchBillBlueList.add(matchBill);
            }
        } else {
            for (DynamicObject dynamicObject : matchBillList) {
                if (MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode().equals(dynamicObject.getString("matchstatus")) && "1".equals(dynamicObject.getString("matchtarget"))) continue;
                matchBillBlueList.add(dynamicObject);
            }
        }
        if (matchBillSuccessList.size() != 0) {
            num = matchBillSuccessList.size();
            this.feedbackProgress(this.calculateProcess(num, matchBillList.size()), String.format(ResManager.loadKDString((String)"\u5171%1$s\u4e2a\u5355\u636e\uff0c\u7b2c%2$s\u4e2a\u5355\u636e", (String)"AutoBillMatchTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), matchBillList.size(), num), null);
        }
        if (blueConfig != null) {
            MinusBillMatchHelper minusBillMatchHelper = new MinusBillMatchHelper();
            MinusBillMatchConfig minusBillMatchConfig = AutoBillMatchTask.buildMatchConfigByDynamicObject(blueConfig);
            HashSet matchInvoiceItems = new HashSet(matchBillBlueList.size());
            HashSet<Long> oriInvoiceIdSet = new HashSet<Long>(matchBillBlueList.size());
            for (DynamicObject matchBillDynamic : matchBillBlueList) {
                this.feedbackProgress(this.calculateProcess(num, matchBillList.size()), String.format(ResManager.loadKDString((String)"\u5171%1$s\u4e2a\u5355\u636e\uff0c\u7b2c%2$s\u4e2a\u5355\u636e", (String)"AutoBillMatchTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), matchBillList.size(), num), null);
                ++num;
                MinusBillDTO minusBillDTO = minusBillMatchHelper.createMinusBillByMatchBill(minusBillMatchConfig, matchBillDynamic);
                minusBillDTO.setMergebillId(Long.valueOf(matchBillDynamic.getLong("id")));
                minusBillDTO.setConfig(minusBillMatchConfig);
                if (StringUtils.isEmpty((CharSequence)minusBillDTO.getRedreason())) {
                    minusBillDTO.setRedreason(matchBillDynamic.getString("redreason"));
                }
                minusBillDTO.getMatchInvoiceItems().addAll(matchInvoiceItems);
                minusBillDTO.setMatchInvoiceIds(oriInvoiceIdSet);
                minusBillMatchHelper.match(minusBillDTO);
                matchInvoiceItems.addAll(minusBillDTO.getMatchInvoiceItems());
                matchBillDynamic.set("matchtarget", (Object)"0");
                matchBillDynamic.set("matchtype", (Object)"1");
                minusBillMatchHelper.updateMatchBill(minusBillDTO, matchBillDynamic, oriInvoiceIdSet);
                matchBillSuccessList.add(matchBillDynamic);
            }
            if (!CollectionUtils.isEmpty(oriInvoiceIdSet)) {
                minusBillMatchHelper.updateInvoiceOccupyStatus(oriInvoiceIdSet, "1", "sim_vatinvoice");
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)0);
        for (DynamicObject dynamicObject : matchBillSuccessList) {
            arrayList.add(SerializationUtils.toJsonString((Object)dynamicObject));
        }
        result.put("success", Boolean.TRUE);
        result.put("matchBillList", arrayList);
        result.put("errMsg", ResManager.loadKDString((String)"\u5339\u914d\u5b8c\u6210", (String)"AutoBillMatchTask_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        this.feedbackCustomdata(result);
    }

    private int calculateProcess(int num, int size) {
        return num * 100 / size;
    }

    public static MinusBillMatchConfig buildMatchConfigByDynamicObject(DynamicObject dynamicObject) {
        MinusBillMatchConfig config = new MinusBillMatchConfig();
        config.setId(Long.valueOf(dynamicObject.getLong("id")));
        config.setStart(dynamicObject.getInt("starttime"));
        config.setEnd(dynamicObject.getInt("endtime"));
        config.setTimeType(dynamicObject.getString("timerange"));
        config.setUnitPriceAffectType(dynamicObject.getString("deviationtype"));
        config.setUnitPriceAffect(dynamicObject.getBigDecimal("deviation"));
        config.setBlueOrder(dynamicObject.getString("redrule"));
        config.setMatchSkp(Boolean.valueOf(dynamicObject.getBoolean("canredtaxcontrol")));
        config.setIgnorePrice(Boolean.valueOf(dynamicObject.getBoolean("ignoreprice")));
        config.setDiscountMatchPrice(Boolean.valueOf(dynamicObject.getBoolean("discountmatchprice")));
        config.setMatchMultiRow(Boolean.valueOf(dynamicObject.getBoolean("matchmulti")));
        config.setQuantityLimit(Integer.valueOf(dynamicObject.getInt("quantitylimit")));
        config.setHeadField(dynamicObject.getString("invoicematchkey"));
        config.setItemField(dynamicObject.getString("itemmatchkey"));
        config.setAmountStandard(Boolean.valueOf(!"2".equals(dynamicObject.getString("matchstandard"))));
        return config;
    }
}

