/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbenchreverse.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.split.LimitAmountsDTO;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.dto.split.SplitResponseDTO;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.invoice.RemarkTemplateHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.InvoiceCancelHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginIssueControl;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.BillIssueResultTabCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbenchreverse.dto.ReverseBillRelationDTO;
import kd.imc.sim.formplugin.bill.originalbill.workbenchreverse.event.BillReverseCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbenchreverse.helper.WorkbenchReverseHelper;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.NoSplitServiceImpl;
import kd.imc.sim.formplugin.issuing.helper.IssueInvoiceControlHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BillReverseReIssueCustomEvent
extends AbstractBillWorkbenchCustomEvent {
    private static Log LOGGER = LogFactory.getLog(BillIssueResultTabCustomEvent.class);

    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs e) {
        try {
            that.getView().showLoading(new LocaleString());
            if ("reverseReIssue/confirmIssue".equals(e.getEventName())) {
                this.saveDataOrSubmitData(that, e.getEventArgs(), e.getEventName());
            }
        }
        finally {
            that.getView().hideLoading();
        }
    }

    private void saveDataOrSubmitData(AbstractFormPlugin that, String params, String eventKey) {
        HashMap invoiceReasonMap;
        List invoicePair;
        Throwable throwable;
        TXHandle tx;
        block19: {
            block20: {
                block21: {
                    tx = TX.required();
                    throwable = null;
                    Map<String, Object> result = this.saveDataAndRelation(that, params);
                    invoicePair = (List)result.get("pairList");
                    invoiceReasonMap = (HashMap)result.get("invoiceReasonMap");
                    if (!CollectionUtils.isEmpty((Collection)invoicePair)) break block19;
                    ViewUtil.openNormalConfirm((AbstractFormPlugin)that, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u5ba1\u6838\u6210\u529f\uff0c\u7cfb\u7edf\u5c06\u81ea\u52a8\u4e3a\u60a8\u5173\u8054\u5355\u636e\u3002\u5f85\u5355\u636e\u5ba1\u6838\u6210\u529f\u540e\u65b9\u53ef\u8fdb\u884c\u5f00\u7968/\u4f5c\u5e9f", (String)"BillReverseReIssueCustomEvent_0", (String)"imc-sim-service", (Object[])new Object[0]), (String)"reverseReIssue/confirmIssue");
                    if (tx == null) break block20;
                    if (throwable == null) break block21;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                tx.close();
            }
            return;
        }
        try {
            try {
                for (Pair pair : invoicePair) {
                    List list = (List)pair.getValue();
                    if ("C".equals(pair.getLeft())) {
                        this.submitInvoice2Cancel(list, invoiceReasonMap);
                        continue;
                    }
                    IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])list.toArray(new DynamicObject[0]));
                }
                that.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"BillReverseReIssueCustomEvent_1", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(2000));
                BillReverseReIssueCustomEvent.updateCustomControl(that, null, eventKey);
            }
            catch (Exception e) {
                String errMsg = e instanceof MsgException ? ((MsgException)((Object)e)).getErrorMsg() : e.getMessage();
                tx.markRollback();
                LOGGER.error("\u9006\u5411\u5de5\u4f5c\u53f0\u63d0\u4ea4\u5931\u8d25", (Throwable)e);
                BillReverseReIssueCustomEvent.updateCustomControlError(that, null, eventKey);
                that.getView().showErrorNotification(errMsg);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void submitInvoice2Cancel(List<DynamicObject> list, Map<String, String> invoiceReasonMap) {
        RequestContext context = RequestContext.get();
        ThreadPools.executeOnceIncludeRequestContext((String)"invalid_bill", () -> {
            RequestContext.copyAndSet((RequestContext)context);
            QFilter qFilter = new QFilter("invoicecode", "=", (Object)"-1").and("invoiceno", "=", (Object)"-1");
            for (DynamicObject invalidBill : list) {
                qFilter.or(InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invalidBill.getString("invoicecode"), (String)invalidBill.getString("invoiceno")));
            }
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])qFilter.toArray());
            if (invoices.length == 0) {
                return;
            }
            for (DynamicObject invoice : invoices) {
                invoice.set("billstatus", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
                invoice.set("abolishtype", (Object)"0");
            }
            ImcSaveServiceHelper.update((DynamicObject[])invoices);
            for (DynamicObject invoice : invoices) {
                String invoiceCode = invoice.getString("invoicecode");
                String invoiceNo = invoice.getString("invoiceno");
                String abolishReason = null == invoiceReasonMap.get(invoiceCode + invoiceNo) ? "" : (String)invoiceReasonMap.get(invoiceCode + invoiceNo);
                InvoiceCancelHelper.cancelInvoice((DynamicObject)invoice, (String)context.getUserName(), (String)abolishReason);
            }
        });
    }

    private Map<String, Object> saveDataAndRelation(AbstractFormPlugin that, String params) {
        JSONObject json = JSONObject.parseObject((String)params);
        this.saveBillRelationData(that);
        Map<String, Object> result = this.saveReverseBillAndInvoice(that, json);
        List returnPair = (List)result.get("pairList");
        returnPair.addAll(this.saveReIssueBillAndInvoice(that, json));
        this.setInvoiceIsoccupy(that);
        that.getPageCache().put("saveData", "1");
        return result;
    }

    private Map<String, Object> saveReverseBillAndInvoice(AbstractFormPlugin that, JSONObject json) {
        ArrayList<Pair> list = new ArrayList<Pair>(4);
        String cacheStr = that.getPageCache().get("reverseBillList");
        if (StringUtils.isBlank((CharSequence)cacheStr)) {
            HashMap<String, Object> result = new HashMap<String, Object>(6);
            HashMap invoiceReasonMap = new HashMap();
            result.put("pairList", list);
            result.put("invoiceReasonMap", invoiceReasonMap);
            return result;
        }
        JSONArray cacheReverseBill = JSONObject.parseArray((String)cacheStr);
        JSONArray reverseBillRequestArr = json.getJSONArray("reverseBill");
        boolean isRedFlush = "B".equals(cacheReverseBill.getJSONObject(0).getString("billsourcetype"));
        String handleRedBill = that.getPageCache().get("handle_red_bill");
        if (StringUtils.isBlank((CharSequence)handleRedBill) && isRedFlush) {
            BillReverseCustomEvent.handlePartRedFlush(cacheReverseBill, reverseBillRequestArr);
            that.getPageCache().put("reverseBillList", cacheReverseBill.toJSONString());
        }
        DynamicObject[] reverseBillList = this.getCacheBill(that, "reverseBillList");
        WorkbenchReverseHelper.overrideJsonArray2Dynamic(reverseBillRequestArr, reverseBillList);
        ArrayList<DynamicObject> invoices = new ArrayList<DynamicObject>(reverseBillRequestArr.size());
        ArrayList<BillRelationDTO> relations = new ArrayList<BillRelationDTO>(reverseBillRequestArr.size());
        ArrayList<DynamicObject> issueInvoice = new ArrayList<DynamicObject>(reverseBillRequestArr.size());
        ArrayList<DynamicObject> invalidBill = new ArrayList<DynamicObject>(reverseBillRequestArr.size());
        ArrayList<DynamicObject> redInfos = new ArrayList<DynamicObject>(reverseBillRequestArr.size());
        NoSplitServiceImpl noSplit = new NoSplitServiceImpl();
        SplitRequestDTO request = this.getSplitRequest();
        request.setBillNoMap(new HashMap(reverseBillList.length));
        long user = Long.parseLong(RequestContext.get().getUserId());
        for (DynamicObject reverseBill : reverseBillList) {
            if ("C".equals(reverseBill.getString("billsourcetype"))) {
                if (!BillStatusEnum.notApproval.contains((Object)reverseBill.getString("billstatus"))) continue;
                invalidBill.add(reverseBill);
                continue;
            }
            this.reverseCheckRedInfo(reverseBill);
            if (!BillStatusEnum.notApproval.contains((Object)reverseBill.getString("billstatus"))) continue;
            SplitResponseDTO response = this.getSplitResponse(noSplit, request, reverseBill);
            if ("sim_red_info".equals(((DynamicObject)response.getInvoices().get(0)).getDynamicObjectType().getName())) {
                List redInfoList = response.getInvoices();
                for (DynamicObject redInfo : redInfoList) {
                    redInfo.set("billstatus", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
                    if (!StringUtils.isNotBlank((CharSequence)redInfo.getString("infocode"))) continue;
                    DynamicObject waitInvoice = OriginalBillPluginIssueControl.genWaitInvoice(redInfo, true);
                    waitInvoice.set("invoicingoperator", (Object)user);
                    issueInvoice.add(waitInvoice);
                    ImcSaveServiceHelper.save((DynamicObject)waitInvoice);
                }
                redInfos.addAll(redInfoList);
            } else {
                invoices.addAll(response.getInvoices());
                issueInvoice.addAll(response.getInvoices());
            }
            if ("B".equalsIgnoreCase(reverseBill.getString("billsourcetype"))) {
                this.clearRedBillRedMark(reverseBill);
            }
            relations.addAll(response.getRelations());
            IssueInvoiceControlHelper.setOriginalAllConfirmed(reverseBill);
        }
        this.saveBillAndInvoice(reverseBillList, relations, invoices, redInfos);
        HashMap<String, String> invoiceReasonMap = new HashMap<String, String>();
        for (DynamicObject bill : reverseBillList) {
            invoiceReasonMap.put(bill.getString("invoicecode") + bill.getString("invoiceno"), bill.getString("abolishreason"));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("invoiceReasonMap", invoiceReasonMap);
        this.saveBillInvRelation(relations);
        this.setCacheData(that, reverseBillList);
        if (!CollectionUtils.isEmpty(issueInvoice)) {
            list.add(Pair.of((Object)"invoice", issueInvoice));
        }
        if (!CollectionUtils.isEmpty(invalidBill)) {
            list.add(Pair.of((Object)"C", invalidBill));
        }
        result.put("pairList", list);
        return result;
    }

    private void clearRedBillRedMark(DynamicObject reverseBill) {
        String blueInvoiceCode = reverseBill.getString("blueinvoicecode");
        String blueInvoiceNo = reverseBill.getString("blueinvoiceno");
        if (StringUtils.isNotBlank((CharSequence)blueInvoiceCode) && StringUtils.isNotBlank((CharSequence)blueInvoiceNo)) {
            String invoiceRemark = reverseBill.getString("invoiceremark");
            String remark = invoiceRemark == null ? "" : invoiceRemark;
            String redRemark = RemarkTemplateHelper.getRedInvoiceRemarkTemplate((String)blueInvoiceCode, (String)blueInvoiceNo);
            String oldRemark = remark.replace(redRemark, "");
            reverseBill.set("invoiceremark", (Object)oldRemark);
        }
    }

    private void saveBillAndInvoice(DynamicObject[] billArr, List<BillRelationDTO> relations, List<DynamicObject> invoices, List<DynamicObject> redInfos) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_original_bill", (DynamicObject[])billArr, null);
        if (!operationResult.isSuccess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25\uff1a%s", (String)"BillReverseReIssueCustomEvent_8", (String)"imc-sim-service", (Object[])new Object[0]), OperationConstant.getErrorMsg((OperationResult)operationResult)));
        }
        if (!CollectionUtils.isEmpty(invoices)) {
            ImcSaveServiceHelper.save(invoices);
        }
        if (!CollectionUtils.isEmpty(redInfos)) {
            this.saveRedInfo(redInfos);
        }
        Map<Object, String> billIdNoMap = Stream.of(billArr).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v.getString("billno")));
        for (BillRelationDTO relation : relations) {
            String billNo;
            if (StringUtils.isNotBlank((CharSequence)relation.getsBillNo()) || !StringUtils.isNotBlank((CharSequence)(billNo = billIdNoMap.get(relation.getsBillId())))) continue;
            relation.setsBillNo(billNo);
        }
    }

    private void reverseCheckRedInfo(DynamicObject reverseBill) {
        String infoCode = reverseBill.getString("infocode");
        if (StringUtils.isNotBlank((CharSequence)infoCode)) {
            QFilter qFilter = new QFilter("infocode", "=", (Object)infoCode).and("org", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)reverseBill.get("orgid")));
            DynamicObject redInfo = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)String.join((CharSequence)",", "status", "infosource", "applicant"), (QFilter[])qFilter.toArray());
            if (redInfo == null) {
                throw new MsgException(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0d\u5b58\u5728", (String)"BillReverseReIssueCustomEvent_3", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            if (!"3".equals(redInfo.getString("status"))) {
                throw new MsgException(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u72b6\u6001\u4e3a\u975e\u5ba1\u6838\u901a\u8fc7\uff0c\u4e0d\u5141\u8bb8\u5f00\u7968", (String)"BillReverseReIssueCustomEvent_4", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            if ("5".equals(redInfo.getString("infosource")) || "6".equals(redInfo.getString("infosource"))) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868[%s]\u5df2\u5173\u8054\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u5f00\u7968", (String)"BillReverseReIssueCustomEvent_5", (String)"imc-sim-service", (Object[])new Object[0]), infoCode));
            }
            qFilter = new QFilter("infocode", "=", (Object)infoCode);
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)"sim_original_bill", (String)String.join((CharSequence)",", "billno"), (QFilter[])qFilter.toArray());
            if (bill != null) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868[%1$s]\u5df2\u88ab\u5355\u636e\u9009\u4e2d\uff0c\u5355\u636e\u7f16\u53f7[%2$s]\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u5f00\u7968", (String)"BillReverseReIssueCustomEvent_6", (String)"imc-sim-service", (Object[])new Object[0]), infoCode, bill.getString("billno")));
            }
            reverseBill.set("applicant", (Object)redInfo.getString("applicant"));
        } else {
            String applicant = reverseBill.getString("applicant");
            if (StringUtils.isNotBlank((CharSequence)applicant) && !RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
                throw new MsgException(ResManager.loadKDString((String)"\u8d2d\u65b9\u7533\u8bf7\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7\u5fc5\u586b", (String)"BillReverseReIssueCustomEvent_7", (String)"imc-sim-service", (Object[])new Object[0]));
            }
        }
    }

    private List<Pair<String, List<DynamicObject>>> saveReIssueBillAndInvoice(AbstractFormPlugin that, JSONObject json) {
        ArrayList<Pair<String, List<DynamicObject>>> list = new ArrayList<Pair<String, List<DynamicObject>>>(4);
        String cacheStr = that.getPageCache().get("reIssueBillList");
        if (StringUtils.isBlank((CharSequence)cacheStr)) {
            return list;
        }
        JSONArray reIssueBillRequestArr = json.getJSONArray("reIssueBill");
        ArrayList<DynamicObject> invoices = new ArrayList<DynamicObject>(reIssueBillRequestArr.size());
        ArrayList<DynamicObject> issueInvoice = new ArrayList<DynamicObject>(reIssueBillRequestArr.size());
        ArrayList<BillRelationDTO> relations = new ArrayList<BillRelationDTO>(reIssueBillRequestArr.size());
        ArrayList<DynamicObject> redInfos = new ArrayList<DynamicObject>(reIssueBillRequestArr.size());
        DynamicObject[] reIssueBillList = this.getCacheBill(that, "reIssueBillList");
        NoSplitServiceImpl noSplit = new NoSplitServiceImpl();
        SplitRequestDTO request = this.getSplitRequest();
        request.setBillNoMap(new HashMap(reIssueBillList.length));
        WorkbenchReverseHelper.overrideJsonArray2Dynamic(reIssueBillRequestArr, reIssueBillList);
        for (DynamicObject reIssueBill : reIssueBillList) {
            SplitResponseDTO response;
            if (!BillStatusEnum.notApproval.contains((Object)reIssueBill.getString("billstatus"))) {
                reIssueBill.set("confirmstate", (Object)"0");
                continue;
            }
            if (BillHelper.isRedInfo((DynamicObject)reIssueBill)) {
                request.setRuleCode("D");
            }
            if ("sim_red_info".equals(((DynamicObject)(response = this.getSplitResponse(noSplit, request, reIssueBill)).getInvoices().get(0)).getDynamicObjectType().getName())) {
                List redInfoList = response.getInvoices();
                for (DynamicObject redInfo : redInfoList) {
                    DynamicObject waitInvoice = OriginalBillPluginIssueControl.genWaitInvoice(redInfo, true);
                    waitInvoice.set("issuebillstatus", (Object)BillStatusEnum.TEMP_SAVE.getCode());
                    if (StringUtils.isNotBlank((CharSequence)redInfo.getString("infocode"))) {
                        issueInvoice.add(waitInvoice);
                    }
                    ImcSaveServiceHelper.save((DynamicObject)waitInvoice);
                }
                redInfos.addAll(redInfoList);
            } else {
                for (DynamicObject invoice : response.getInvoices()) {
                    invoice.set("issuebillstatus", (Object)BillStatusEnum.TEMP_SAVE.getCode());
                }
                invoices.addAll(response.getInvoices());
                issueInvoice.addAll(response.getInvoices());
            }
            relations.addAll(response.getRelations());
            IssueInvoiceControlHelper.setOriginalAllConfirmed(reIssueBill);
        }
        this.saveBillAndInvoice(reIssueBillList, relations, invoices, redInfos);
        if (!CollectionUtils.isEmpty(issueInvoice) && this.isOnlyReOpen(that)) {
            list.add((Pair<String, List<DynamicObject>>)Pair.of((Object)"invoice", issueInvoice));
        }
        this.saveBillInvRelation(relations);
        this.setCacheData(that, reIssueBillList);
        return list;
    }

    private void saveRedInfo(List<DynamicObject> redInfos) {
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(redInfos.size());
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(redInfos.size());
        for (DynamicObject redInfo : redInfos) {
            if (QueryServiceHelper.exists((String)"sim_red_info", (Object)redInfo.getPkValue())) {
                updateList.add(redInfo);
                continue;
            }
            saveList.add(redInfo);
        }
        if (!CollectionUtils.isEmpty(saveList)) {
            ImcSaveServiceHelper.save(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            ImcSaveServiceHelper.update(updateList);
        }
    }

    private void setCacheData(AbstractFormPlugin that, DynamicObject[] billList) {
        String billIdStr = that.getPageCache().get("billIds");
        List billIdList = new ArrayList(billList.length);
        if (StringUtils.isNotBlank((CharSequence)billIdStr)) {
            billIdList = JSONObject.parseArray((String)billIdStr, Long.class);
        }
        billIdList.addAll(Stream.of(billList).map(bill -> bill.getLong("id")).collect(Collectors.toList()));
        that.getPageCache().put("billIds", JSONObject.toJSONString(billIdList));
        boolean isRedFlush = "B".equals(billList[0].getString("billsourcetype"));
        if (isRedFlush) {
            HashMap partRedFlushMap = new HashMap(billList.length);
            for (DynamicObject bill2 : billList) {
                String blueInvoiceCode = bill2.getString("blueinvoicecode");
                String blueInvoiceNo = bill2.getString("blueinvoiceno");
                DynamicObjectCollection items = bill2.getDynamicObjectCollection("sim_original_bill_item");
                HashMap<String, String> itemMap = new HashMap<String, String>(items.size());
                for (DynamicObject item : items) {
                    String amountStr = item.getBigDecimal("amount").setScale(2, 4).toString();
                    String taxStr = item.getBigDecimal("tax").setScale(2, 4).toString();
                    itemMap.put(String.valueOf(item.getLong("blueinvoiceitemid")), amountStr + '_' + taxStr);
                }
                partRedFlushMap.put(blueInvoiceCode + "blueinvoicecode" + blueInvoiceNo, itemMap);
            }
            that.getPageCache().put("part_red_bill_cache", SerializationUtils.toJsonString(partRedFlushMap));
        }
    }

    private SplitResponseDTO getSplitResponse(NoSplitServiceImpl noSplit, SplitRequestDTO request, DynamicObject bill) {
        this.setSplitBillRemainValidAmount(bill);
        request.setBill(bill);
        request.getBillNoMap().put(bill.getString("billno"), "200_" + UUID.getBatchNumber() + "_0001");
        return noSplit.split(request);
    }

    private void setSplitBillRemainValidAmount(DynamicObject bill) {
        boolean isTax = "1".equals(bill.getString("hsbz"));
        DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : items) {
            item.set("remainvalidamount", (Object)item.getBigDecimal("remainvalidamount").add(isTax ? BigDecimal.ZERO : item.getBigDecimal("remainvalidtax")));
        }
    }

    private DynamicObject[] getCacheBill(AbstractFormPlugin that, String cacheKey) {
        String cacheStr = that.getPageCache().get(cacheKey);
        JSONArray cacheArr = JSONObject.parseArray((String)cacheStr);
        return WorkbenchReverseHelper.getDynamicObjectListFromJSONArray(cacheArr, "sim_original_bill");
    }

    private void setInvoiceIsoccupy(AbstractFormPlugin that) {
        if (this.isOnlyReOpen(that)) {
            return;
        }
        JSONArray pairArr = (JSONArray)that.getView().getFormShowParameter().getCustomParam("invoicePairList");
        HashSet invoiceId = new HashSet(pairArr.size());
        for (int i = 0; i < pairArr.size(); ++i) {
            JSONObject pair = pairArr.getJSONObject(i);
            invoiceId.addAll(pair.values());
        }
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "occupystatus", "invoicecode", "invoiceno", "itemremainredamount", "itemremainredtax"), (QFilter[])new QFilter("id", "in", invoiceId).toArray());
        String partRedBillCache = that.getPageCache().get("part_red_bill_cache");
        Map partRedFlushMap = new HashMap(invoices.length);
        if (StringUtils.isNotBlank((CharSequence)partRedBillCache)) {
            partRedFlushMap = (Map)SerializationUtils.fromJsonString((String)partRedBillCache, Map.class);
        }
        for (DynamicObject invoice : invoices) {
            Map itemMap = (Map)partRedFlushMap.get(invoice.getString("invoicecode") + "blueinvoicecode" + invoice.getString("invoiceno"));
            if (CollectionUtils.isEmpty((Map)itemMap)) {
                invoice.set("occupystatus", (Object)"1");
                continue;
            }
            DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
            if (items.stream().allMatch(item -> item.getBigDecimal("itemremainredamount").compareTo(BigDecimal.ZERO) == 0)) {
                invoice.set("occupystatus", (Object)"1");
                continue;
            }
            for (DynamicObject item2 : items) {
                String amountTaxStr = (String)itemMap.get(String.valueOf(item2.getLong("id")));
                if (StringUtils.isBlank((CharSequence)amountTaxStr)) continue;
                String[] amountTax = amountTaxStr.split("_");
                BigDecimal amount = new BigDecimal(amountTax[0]);
                BigDecimal tax = new BigDecimal(amountTax[1]);
                if (MathUtils.isNullOrZero((BigDecimal)amount)) continue;
                item2.set("itemremainredamount", (Object)item2.getBigDecimal("itemremainredamount").add(amount));
                item2.set("itemremainredtax", (Object)item2.getBigDecimal("itemremainredtax").add(tax));
            }
            if (!items.stream().allMatch(item -> MathUtils.isNullOrZero((BigDecimal)item.getBigDecimal("itemremainredamount")))) continue;
            invoice.set("occupystatus", (Object)"1");
        }
        ImcSaveServiceHelper.update((DynamicObject[])invoices);
    }

    private boolean isOnlyReOpen(AbstractFormPlugin that) {
        String operateKey = (String)that.getView().getFormShowParameter().getCustomParam("operateKey");
        return "bill_reopen".equals(operateKey);
    }

    private void saveBillRelationData(AbstractFormPlugin that) {
        List<ReverseBillRelationDTO> reverseBillRelationDTOS = this.getReverseBillRelation(that);
        ArrayList<DynamicObject> reverseBillRelationList = new ArrayList<DynamicObject>(reverseBillRelationDTOS.size());
        for (ReverseBillRelationDTO reverseBillRelationDTO : reverseBillRelationDTOS) {
            DynamicObject relation = BusinessDataServiceHelper.newDynamicObject((String)"sim_bill_relation");
            DynamicObjectUtil.bean2DynamicObject((Object)reverseBillRelationDTO, (DynamicObject)relation);
            reverseBillRelationList.add(relation);
        }
        ImcSaveServiceHelper.save(reverseBillRelationList);
    }

    private void saveBillInvRelation(List<BillRelationDTO> relations) {
        if (CollectionUtils.isEmpty(relations)) {
            return;
        }
        ArrayList<DynamicObject> relationList = new ArrayList<DynamicObject>(relations.size());
        for (BillRelationDTO relation : relations) {
            DynamicObject relationObj = BusinessDataServiceHelper.newDynamicObject((String)"sim_bill_inv_relation");
            DynamicObjectUtil.bean2DynamicObject((Object)relation, (DynamicObject)relationObj);
            relationList.add(relationObj);
        }
        ImcSaveServiceHelper.save(relationList);
    }

    private List<ReverseBillRelationDTO> getReverseBillRelation(AbstractFormPlugin that) {
        ArrayList<ReverseBillRelationDTO> reverseBillrelations = new ArrayList<ReverseBillRelationDTO>(100);
        reverseBillrelations.addAll(this.getBillRelation(that, "billReverseBillRelation"));
        reverseBillrelations.addAll(this.getBillRelation(that, "reverseBillReIssueBillRelation"));
        reverseBillrelations.addAll(this.getBillRelation(that, "billReIssueBillRelation"));
        return reverseBillrelations;
    }

    private List<ReverseBillRelationDTO> getBillRelation(AbstractFormPlugin that, String cacheKey) {
        String cacheStr = that.getPageCache().get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)cacheStr)) {
            return JSONObject.parseArray((String)cacheStr, ReverseBillRelationDTO.class);
        }
        return Collections.emptyList();
    }

    private SplitRequestDTO getSplitRequest() {
        SplitRequestDTO splitRequestDTO = new SplitRequestDTO();
        LimitAmountsDTO limitAmount = new LimitAmountsDTO(true);
        splitRequestDTO.setLimitAmounts(limitAmount);
        return splitRequestDTO;
    }
}

