/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbenchreverse.event;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.formplugin.bill.originalbill.util.BillIssueResultTabCustomEventUtil;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.AbstractBillWorkbenchCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.event.BillIssueResultTabCustomEvent;
import kd.imc.sim.formplugin.bill.originalbill.workbench.pluginworkutils.WorkbenchPrintUtil;

public class BillReverseReIssueResultCustomEvent
extends AbstractBillWorkbenchCustomEvent {
    private static Log LOGGER = LogFactory.getLog(BillIssueResultTabCustomEvent.class);

    @Override
    public void customEvent(AbstractFormPlugin that, CustomEventArgs eventKey) {
        String event = eventKey.getEventName();
        String params = eventKey.getEventArgs();
        String billIds = that.getPageCache().get("billIds");
        if (StringUtils.isBlank((CharSequence)billIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u770b\u5f00\u7968\u7ed3\u679c billIds \u4e0d\u80fd\u4e3a\u7a7a", (String)"BillReverseReIssueResultCustomEvent_0", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        switch (event) {
            case "issue/showDetail": {
                this.buildResult(that, billIds);
                break;
            }
            case "issue/reIssue": {
                DynamicObject[] invObjs = BillIssueResultTabCustomEventUtil.getInvObjsByInvId(params);
                ArrayList<DynamicObject> updateObjs = new ArrayList<DynamicObject>(invObjs.length);
                for (DynamicObject invObj : invObjs) {
                    DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
                    obj.set("id", (Object)invObj.getLong("id"));
                    obj.set("issuestatus", (Object)IssueStatusEnum.submit.getCode());
                    updateObjs.add(obj);
                }
                ImcSaveServiceHelper.update(updateObjs);
                IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])invObjs);
                that.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u91cd\u65b0\u5f00\u7968", (String)"BillReverseReIssueResultCustomEvent_1", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
                break;
            }
            case "issue/paperInvPrint": {
                DynamicObject[] printInvObjs = BillIssueResultTabCustomEventUtil.getInvObjsByInvId(params);
                WorkbenchPrintUtil.dealInvPrint(that, printInvObjs);
                break;
            }
        }
    }

    private void buildResult(AbstractFormPlugin that, String billIds) {
        try {
            Map<String, Object> rMap = BillIssueResultTabCustomEventUtil.buildWorkBenchReverseIssuesResult(billIds);
            BillReverseReIssueResultCustomEvent.updateCustomControl(that, rMap, "issue/showDetail");
        }
        catch (Exception e) {
            LOGGER.error("\u9006\u5411\u5de5\u4f5c\u53f0\u6784\u5efa\u5f00\u7968\u7ed3\u679c\u62a5\u9519", (Throwable)e);
            that.getView().showErrorNotification(e.getMessage());
            BillReverseReIssueResultCustomEvent.updateCustomControlError(that, null, "issue/showDetail");
        }
    }
}

