/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;

public class BillCalcMethod {
    public static BigDecimal getTaxDeviation(DynamicObject tObj, DynamicObject item, BigDecimal taxAmount, BigDecimal tax) {
        BigDecimal calcTax = BillCalcMethod.calcBillTax(taxAmount, tax, BillCalcMethod.getDeduction(tObj, item), item.getString("taxrate"), 1);
        return item.getBigDecimal("remainvalidtax").subtract(calcTax).setScale(6, 4);
    }

    public static BigDecimal getDeduction(DynamicObject tObj, DynamicObject item) {
        BigDecimal deduction = tObj.getBigDecimal("deduction");
        if (item.getBigDecimal("itemdeduction").compareTo(BigDecimal.ZERO) != 0) {
            deduction = item.getBigDecimal("itemdeduction");
        }
        return deduction;
    }

    public static void calcPrice(DynamicObject item, boolean isAllEle) {
        BigDecimal num = item.getBigDecimal("remainvalidnum");
        if (MathUtils.isNullOrZero((BigDecimal)num)) {
            item.set("taxunitprice", (Object)BigDecimal.ZERO);
            item.set("unitprice", (Object)BigDecimal.ZERO);
            return;
        }
        BigDecimal unitPrice = item.getBigDecimal("unitprice");
        int unitPriceLength = unitPrice.stripTrailingZeros().toPlainString().length();
        BigDecimal amount = item.getBigDecimal("remainvalidamount").subtract(item.getBigDecimal("remainvalidtax"));
        int priceMaxLength = 16;
        if (isAllEle) {
            priceMaxLength = 25;
        }
        if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)num, (BigDecimal)unitPrice), (BigDecimal)amount, (BigDecimal)InvoiceConstant.DIFF_01) || unitPriceLength > priceMaxLength) {
            item.set("unitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)num, (boolean)isAllEle));
        }
        BigDecimal taxUnitPrice = item.getBigDecimal("taxunitprice");
        int taxUnitPriceLength = taxUnitPrice.stripTrailingZeros().toPlainString().length();
        if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)num, (BigDecimal)taxUnitPrice), (BigDecimal)item.getBigDecimal("remainvalidamount"), (BigDecimal)InvoiceConstant.DIFF_01) || taxUnitPriceLength > priceMaxLength) {
            item.set("taxunitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)item.getBigDecimal("remainvalidamount"), (BigDecimal)num, (boolean)isAllEle));
        }
    }

    public static BigDecimal calcBillTax(BigDecimal itemTaxAmount, BigDecimal tax, BigDecimal deduction, String taxRate, int calcCount) {
        if (calcCount > 5) {
            return TaxCalcUtil.calTax((BigDecimal)itemTaxAmount, (BigDecimal)deduction, (String)taxRate, (boolean)true, (int)6);
        }
        BigDecimal calcTax = TaxCalcUtil.calTax((BigDecimal)itemTaxAmount.subtract(tax), (BigDecimal)deduction, (String)taxRate, (boolean)false, (int)6);
        BigDecimal amount = itemTaxAmount.subtract(calcTax);
        BigDecimal calcTaxDouble = TaxCalcUtil.calTax((BigDecimal)amount, (BigDecimal)deduction, (String)taxRate, (boolean)false, (int)6);
        boolean singleRowDiffFlag = BigDecimalUtil.compare((BigDecimal)calcTaxDouble, (BigDecimal)calcTax, (BigDecimal)InvoiceConstant.DIFFF_06);
        if (singleRowDiffFlag) {
            return BillCalcMethod.calcBillTax(itemTaxAmount, calcTax, deduction, taxRate, calcCount + 1);
        }
        return calcTax;
    }
}

