/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillCheckMethod;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BillNegativeOffsetMethod {
    static void differentGoodsItemsMerge(List<BillRelationDTO> relations, Map<Long, DynamicObject> detailId2BillMap, DynamicObject bill, DynamicObject rule) {
        BillCheckMethod.checkPartApply(detailId2BillMap, bill, relations);
        boolean isAmountBiggerThanZero = bill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) > 0;
        Pair<List<DynamicObject>, Map<String, List<DynamicObject>>> pair = BillNegativeOffsetMethod.buildOffsetMap(bill);
        if (((List)pair.getKey()).size() == 0) {
            return;
        }
        Map offsetItemMaps = (Map)pair.getValue();
        boolean isNumAdd = "2".equals(rule.getString("negativenumtype"));
        List offsettingItemList = (List)pair.getKey();
        for (DynamicObject offsettingItem : offsettingItemList) {
            List<Object> canOffsetItemList;
            List offsetItems = (List)offsetItemMaps.get(offsettingItem.getString("taxrate"));
            BillNegativeOffsetMethod.checkCanOffsetItems(offsetItems, isAmountBiggerThanZero, bill);
            if (isNumAdd) {
                Stream<Object> stream = offsetItems.stream();
                if (offsettingItem.getBigDecimal("remainvalidnum").compareTo(BigDecimal.ZERO) != 0) {
                    stream = stream.filter(item -> item.getBigDecimal("remainvalidnum").compareTo(BigDecimal.ZERO) != 0);
                }
                canOffsetItemList = stream.filter(item -> item.getBigDecimal("remainvalidamount").add(item.getBigDecimal("discountamount")).abs().compareTo(offsettingItem.getBigDecimal("remainvalidamount").abs()) > 0).filter(item -> item.getBigDecimal("remainvalidnum").abs().compareTo(offsettingItem.getBigDecimal("remainvalidnum").abs()) > 0).sorted(Comparator.comparing(o -> o.getBigDecimal("remainvalidnum").abs(), Comparator.reverseOrder())).collect(Collectors.toList());
            } else {
                canOffsetItemList = offsetItems.stream().sorted(Comparator.comparing(o -> o.getBigDecimal("remainvalidamount").add(o.getBigDecimal("discountamount")).abs(), Comparator.reverseOrder())).collect(Collectors.toList());
            }
            if ("2".equals(rule.getString("priceoffsettype"))) {
                canOffsetItemList = BillNegativeOffsetMethod.checkPriceDeviationOffset(offsettingItem, canOffsetItemList, rule, bill);
                BillNegativeOffsetMethod.checkCanOffsetItems(canOffsetItemList, isAmountBiggerThanZero, bill);
            }
            BillNegativeOffsetMethod.executeOffset(offsettingItem, canOffsetItemList, bill, isNumAdd, relations);
        }
    }

    private static void checkCanOffsetItems(List<DynamicObject> offsetItems, boolean isAmountBiggerThanZero, DynamicObject bill) {
        if (CollectionUtils.isEmpty(offsetItems)) {
            if (isAmountBiggerThanZero) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u5931\u8d25\uff0c\u8d1f\u6570\u5546\u54c1\u51b2\u62b5\u4e0d\u4e86,\u5f00\u7968\u7533\u8bf7\u5355\u7f16\u53f7%s\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u9700\u8981\u5408\u5e76\u7684\u5355\u636e\uff01", (String)"BillNegativeOffsetMethod_1", (String)"imc-sim-service", (Object[])new Object[0]), bill.getString("billno")));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u5931\u8d25\uff0c\u6b63\u6570\u5546\u54c1\u51b2\u62b5\u4e0d\u4e86,\u5f00\u7968\u7533\u8bf7\u5355\u7f16\u53f7%s\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u9700\u8981\u5408\u5e76\u7684\u5355\u636e\uff01", (String)"BillNegativeOffsetMethod_2", (String)"imc-sim-service", (Object[])new Object[0]), bill.getString("billno")));
        }
    }

    private static List<DynamicObject> checkPriceDeviationOffset(DynamicObject offsettingItem, List<DynamicObject> orderOffsetItemList, DynamicObject rule, DynamicObject bill) {
        ArrayList<DynamicObject> canOffsetItems = new ArrayList<DynamicObject>(orderOffsetItemList.size());
        BigDecimal canOffSetAmount = BigDecimal.ZERO;
        for (DynamicObject offsetItem : orderOffsetItemList) {
            BigDecimal rightPrice;
            BigDecimal offsettingUnitPrice = offsettingItem.getBigDecimal("unitprice");
            BigDecimal offsetUnitPrice = offsetItem.getBigDecimal("unitprice");
            if (MathUtils.isNullOrZero((BigDecimal)offsettingUnitPrice)) {
                if (!MathUtils.isNullOrZero((BigDecimal)offsetUnitPrice)) continue;
                canOffsetItems.add(offsetItem);
                canOffSetAmount = canOffSetAmount.add(offsetItem.getBigDecimal("remainvalidamount"));
                continue;
            }
            BigDecimal leftPrice = offsettingUnitPrice.multiply(BigDecimal.ONE.add(rule.getBigDecimal("deviationleft").divide(new BigDecimal(100), 5, 4)));
            if (offsetUnitPrice.compareTo(leftPrice) < 0 || offsetUnitPrice.compareTo(rightPrice = offsettingUnitPrice.multiply(BigDecimal.ONE.add(rule.getBigDecimal("deviationright").divide(new BigDecimal(100), 5, 4)))) > 0) continue;
            canOffSetAmount = canOffSetAmount.add(offsetItem.getBigDecimal("remainvalidamount"));
            canOffsetItems.add(offsetItem);
        }
        if (offsettingItem.getBigDecimal("remainvalidamount").abs().compareTo(canOffSetAmount.abs()) >= 0) {
            BillNegativeOffsetMethod.checkCanOffsetItems(new ArrayList<DynamicObject>(1), bill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) > 0, bill);
        }
        return canOffsetItems;
    }

    private static void executeOffset(DynamicObject offsettingItem, List<DynamicObject> canOffsetItemList, DynamicObject bill, boolean isNumAdd, List<BillRelationDTO> relations) {
        int compare;
        DynamicObject canOffsetItem;
        DynamicObjectCollection mergeItems = bill.getDynamicObjectCollection("sim_original_bill_item");
        Iterator<DynamicObject> iterator = canOffsetItemList.iterator();
        while (iterator.hasNext()) {
            canOffsetItem = iterator.next();
            compare = canOffsetItem.getBigDecimal("remainvalidamount").add(canOffsetItem.getBigDecimal("discountamount")).abs().compareTo(offsettingItem.getBigDecimal("remainvalidamount").abs());
            if (compare > 0) {
                relations.stream().filter(relation -> relation.gettDetailId().equals(offsettingItem.getLong("id"))).forEach(relation -> relation.settDetailId(Long.valueOf(canOffsetItem.getLong("id"))));
                BillNegativeOffsetMethod.calcOffset(bill, mergeItems, canOffsetItem, offsettingItem, isNumAdd);
                return;
            }
            if (canOffsetItem.getBigDecimal("discountamount").compareTo(BigDecimal.ZERO) != 0) continue;
            if (compare == 0) {
                iterator.remove();
                if (canOffsetItemList.size() == 0) {
                    BillNegativeOffsetMethod.checkCanOffsetItems(new ArrayList<DynamicObject>(1), bill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) > 0, bill);
                }
                relations.stream().filter(relation -> relation.gettDetailId().equals(canOffsetItem.getLong("id"))).forEach(relation -> relation.settDetailId(Long.valueOf(((DynamicObject)canOffsetItemList.get(0)).getLong("id"))));
                mergeItems.remove((Object)canOffsetItem);
                relations.stream().filter(relation -> relation.gettDetailId().equals(offsettingItem.getLong("id"))).forEach(relation -> relation.settDetailId(Long.valueOf(((DynamicObject)canOffsetItemList.get(0)).getLong("id"))));
                mergeItems.remove((Object)offsettingItem);
                return;
            }
            BillNegativeOffsetMethod.calcOffset(bill, mergeItems, offsettingItem, canOffsetItem, isNumAdd);
            if (canOffsetItemList.size() != 0) {
                iterator.remove();
                relations.stream().filter(relation -> relation.gettDetailId().equals(canOffsetItem.getLong("id"))).forEach(relation -> relation.settDetailId(Long.valueOf(((DynamicObject)canOffsetItemList.get(0)).getLong("id"))));
                continue;
            }
            BillNegativeOffsetMethod.checkCanOffsetItems(new ArrayList<DynamicObject>(1), bill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) > 0, bill);
        }
        if (offsettingItem.getBigDecimal("remainvalidamount").compareTo(BigDecimal.ZERO) != 0 && canOffsetItemList.size() > 0 && (compare = (canOffsetItem = canOffsetItemList.get(0)).getBigDecimal("remainvalidamount").add(canOffsetItem.getBigDecimal("discountamount")).abs().compareTo(offsettingItem.getBigDecimal("remainvalidamount").abs())) > 0) {
            relations.stream().filter(relation -> relation.gettDetailId().equals(offsettingItem.getLong("id"))).forEach(relation -> relation.settDetailId(Long.valueOf(canOffsetItem.getLong("id"))));
            BillNegativeOffsetMethod.calcOffset(bill, mergeItems, canOffsetItem, offsettingItem, isNumAdd);
        }
        if (offsettingItem.getBigDecimal("remainvalidamount").compareTo(BigDecimal.ZERO) != 0) {
            BillNegativeOffsetMethod.checkCanOffsetItems(new ArrayList<DynamicObject>(1), bill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) > 0, bill);
        }
    }

    private static void calcOffset(DynamicObject bill, DynamicObjectCollection mergeItems, DynamicObject item, DynamicObject removeItem, boolean isNumAdd) {
        mergeItems.remove((Object)removeItem);
        item.set("remainvalidamount", (Object)item.getBigDecimal("remainvalidamount").add(removeItem.getBigDecimal("remainvalidamount")));
        item.set("remainvalidtax", (Object)item.getBigDecimal("remainvalidtax").add(removeItem.getBigDecimal("remainvalidtax")));
        if (isNumAdd) {
            item.set("remainvalidnum", (Object)item.getBigDecimal("remainvalidnum").add(removeItem.getBigDecimal("remainvalidnum")));
        } else {
            BigDecimal num = UnitPriceHelper.calcNum((BigDecimal)item.getBigDecimal("remainvalidamount"), (BigDecimal)item.getBigDecimal("taxunitprice"));
            item.set("remainvalidnum", (Object)num);
            bill.set("mergelable", (Object)"2");
        }
        removeItem.set("remainvalidamount", (Object)BigDecimal.ZERO);
        removeItem.set("remainvalidtax", (Object)BigDecimal.ZERO);
    }

    private static Pair<List<DynamicObject>, Map<String, List<DynamicObject>>> buildOffsetMap(DynamicObject bill) {
        boolean isAmountBiggerThanZero = bill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) > 0;
        DynamicObjectCollection mergeItems = bill.getDynamicObjectCollection("sim_original_bill_item");
        ArrayList<DynamicObject> offsettingItemList = new ArrayList<DynamicObject>(mergeItems.size());
        HashMap<String, List> offsetItemMaps = new HashMap<String, List>(mergeItems.size());
        for (int i = 0; i < mergeItems.size(); ++i) {
            DynamicObject mergeItem = (DynamicObject)mergeItems.get(i);
            if ("1".equals(mergeItem.getString("rowtype"))) continue;
            BigDecimal discountAmount = BigDecimal.ZERO;
            if (i != mergeItems.size() - 1 && "1".equals(((DynamicObject)mergeItems.get(i + 1)).getString("rowtype"))) {
                discountAmount = ((DynamicObject)mergeItems.get(i + 1)).getBigDecimal("remainvalidamount");
            }
            mergeItem.set("discountamount", (Object)discountAmount);
            if (bill.getBigDecimal("totalamount").multiply(mergeItem.getBigDecimal("remainvalidamount")).compareTo(BigDecimal.ZERO) > 0) {
                List list = offsetItemMaps.computeIfAbsent(mergeItem.getString("taxrate"), k -> new ArrayList());
                list.add(mergeItem);
                continue;
            }
            if (i != mergeItems.size() - 1 && "1".equals(((DynamicObject)mergeItems.get(i + 1)).getString("rowtype")) && !isAmountBiggerThanZero) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u88ab\u6298\u6263\u884c\u51b2\u62b5\u8d1f\u6570\u884c", (String)"BillNegativeOffsetMethod_4", (String)"imc-sim-service", (Object[])new Object[0]), bill.getString("billno")));
            }
            offsettingItemList.add(mergeItem);
        }
        return Pair.of(offsettingItemList, offsetItemMaps);
    }

    static void handleNumZero(DynamicObject mergeRule, boolean isMergeDetail, DynamicObject tObj, List<BillRelationDTO> relations) {
        List numZeroItems;
        if (!isMergeDetail || !"2".equals(mergeRule.getString("numzerohandletype"))) {
            return;
        }
        DynamicObjectCollection mergeItems = tObj.getDynamicObjectCollection("sim_original_bill_item");
        HashMap<String, List> taxRateMap = new HashMap<String, List>(mergeItems.size());
        HashMap<Object, List> numZeroItemsMap = new HashMap<Object, List>(mergeItems.size());
        for (int i = 0; i < mergeItems.size(); ++i) {
            DynamicObject mergeItem = (DynamicObject)mergeItems.get(i);
            if ("1".equals(mergeItem.getString("rowtype"))) continue;
            if (MathUtils.isNullOrZero((BigDecimal)mergeItem.getBigDecimal("remainvalidnum"))) {
                DynamicObject nextItem;
                boolean hasNum = relations.stream().filter(relation -> relation.gettDetailId().equals(mergeItem.getLong("id"))).anyMatch(relation -> !MathUtils.isNullOrZero((BigDecimal)relation.getNum()));
                if (!hasNum) continue;
                numZeroItems = numZeroItemsMap.computeIfAbsent(mergeItem.get("id"), k -> new ArrayList());
                numZeroItems.add(mergeItem);
                if (i == mergeItems.size() - 1 || !"1".equals((nextItem = (DynamicObject)mergeItems.get(i + 1)).getString("rowtype"))) continue;
                numZeroItems.add(mergeItems.get(i + 1));
                ++i;
                continue;
            }
            List taxRateGroup = taxRateMap.computeIfAbsent(mergeItem.getString("taxrate"), k -> new ArrayList());
            taxRateGroup.add(mergeItem);
        }
        if (numZeroItemsMap.size() == 0) {
            return;
        }
        Set entries = numZeroItemsMap.entrySet();
        for (Map.Entry entry : entries) {
            numZeroItems = (List)entry.getValue();
            DynamicObject numZeroItem = (DynamicObject)numZeroItems.get(0);
            List sameRateList = (List)taxRateMap.get(numZeroItem.getString("taxrate"));
            if (CollectionUtils.isEmpty((Collection)sameRateList)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5546\u54c1\u884c\u5206\u644a\u4e0d\u4e86,\u5f00\u7968\u7533\u8bf7\u5355\u7f16\u53f7%1$s\uff0c\u5546\u54c1\u540d\u79f0%2$s\uff0c\u5546\u54c1\u7a0e\u7387%3$s\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u9700\u8981\u5408\u5e76\u7684\u5355\u636e\uff01", (String)"BillNegativeOffsetMethod_3", (String)"imc-sim-service", (Object[])new Object[0]), tObj.getString("billno"), numZeroItem.getString("goodsname"), numZeroItem.getString("taxrate")));
            }
            sameRateList.sort((k1, k2) -> k2.getBigDecimal("remainvalidamount").compareTo(k1.getBigDecimal("remainvalidamount")));
            DynamicObject maxSameRate = (DynamicObject)sameRateList.get(0);
            BillNegativeOffsetMethod.mergeNumZeroRow2MaxRow(maxSameRate, numZeroItem, relations, mergeItems);
            if (numZeroItems.size() != 2) continue;
            DynamicObject numZeroDiscountItem = (DynamicObject)numZeroItems.get(1);
            DynamicObject maxSameRateDiscount = BillNegativeOffsetMethod.getMaxSameRateDiscount(mergeItems, maxSameRate);
            if (maxSameRateDiscount == null) {
                DynamicObject remove = mergeItems.remove(mergeItems.indexOf((Object)numZeroDiscountItem));
                mergeItems.add(mergeItems.indexOf((Object)maxSameRate) + 1, remove);
                numZeroDiscountItem.set("goodsname", maxSameRate.get("goodsname"));
                continue;
            }
            BillNegativeOffsetMethod.mergeNumZeroRow2MaxRow(maxSameRateDiscount, numZeroDiscountItem, relations, mergeItems);
        }
    }

    private static void mergeNumZeroRow2MaxRow(DynamicObject maxSameRate, DynamicObject numZeroItem, List<BillRelationDTO> relations, DynamicObjectCollection mergeItems) {
        maxSameRate.set("remainvalidamount", (Object)maxSameRate.getBigDecimal("remainvalidamount").add(numZeroItem.getBigDecimal("remainvalidamount")));
        maxSameRate.set("remainvalidtax", (Object)maxSameRate.getBigDecimal("remainvalidtax").add(numZeroItem.getBigDecimal("remainvalidtax")));
        relations.stream().filter(relation -> relation.gettDetailId().equals(numZeroItem.getLong("id"))).forEach(relation -> relation.settDetailId(Long.valueOf(maxSameRate.getLong("id"))));
        mergeItems.remove((Object)numZeroItem);
    }

    private static DynamicObject getMaxSameRateDiscount(DynamicObjectCollection mergeItems, DynamicObject maxSameRate) {
        int maxSameRateIndex = mergeItems.indexOf((Object)maxSameRate);
        if (maxSameRateIndex == mergeItems.size() - 1) {
            return null;
        }
        DynamicObject nextRow = (DynamicObject)mergeItems.get(maxSameRateIndex + 1);
        if ("1".equals(nextRow.getString("rowtype"))) {
            return nextRow;
        }
        return null;
    }
}

