/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.split.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.dto.split.LimitAmountsDTO;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.splitMerge.split.IBillSplitService;

public abstract class AbstractBillSplitServiceImpl
implements IBillSplitService {
    public static Map<String, BigDecimal> getLimitMap(LimitAmountsDTO limitAmountsDTO) {
        HashMap<String, BigDecimal> limitMap = new HashMap<String, BigDecimal>();
        limitMap.put(InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), limitAmountsDTO.getPcLimitAmt());
        limitMap.put(InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode(), limitAmountsDTO.getPsLimitAmt());
        limitMap.put(InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), limitAmountsDTO.getEcLimitAmt());
        limitMap.put(InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode(), limitAmountsDTO.getEsLimitAmt());
        limitMap.put(InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode(), new BigDecimal("9999999999999999"));
        limitMap.put(InvoiceType.ALL_E_NORMAL.getTypeCode(), new BigDecimal("9999999999999999"));
        limitMap.put(InvoiceType.ALL_E_SPECIAL.getTypeCode(), new BigDecimal("9999999999999999"));
        return limitMap;
    }

    public BigDecimal checkLimit(LimitAmountsDTO limitAmounts, DynamicObject bill) {
        Map<String, BigDecimal> limitMap = AbstractBillSplitServiceImpl.getLimitMap(limitAmounts);
        String invoiceType = bill.getString("invoicetype");
        BigDecimal limitAmount = limitMap.get(bill.getString("invoicetype"));
        if (MathUtils.isNullOrZero((BigDecimal)limitAmount)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u9650\u989d\u4e0d\u80fd\u4e3a0", (String)"AbstractBillSplitServiceImpl_0", (String)"imc-sim-service", (Object[])new Object[0]), InvoiceType.getInvoiceDescription((String)invoiceType)));
        }
        return limitAmount;
    }

    public String getMergeBillNoFirst(String billNo) {
        try {
            String[] billNos = billNo.split(",");
            return billNos[0];
        }
        catch (Exception e) {
            return billNo;
        }
    }

    public static void buildMainInvoiceData(DynamicObject invoice) {
        invoice.set("buyertype", (Object)"4");
        invoice.set("issuebillstatus", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
        invoice.set("billstatus", (Object)"");
        invoice.set("createtime", (Object)new Date());
        invoice.set("issuetime", null);
        invoice.set("issuewritebackstatus", (Object)"0");
        invoice.set("abolishwritebackstatus", (Object)"2");
        invoice.set("invoicestatus", (Object)"");
        invoice.set("issuestatus", (Object)IssueStatusEnum.none.getCode());
        invoice.set("orderno", (Object)UUID.randomUUID());
        invoice.set("invoicingoperator", (Object)Long.parseLong(RequestContext.get().getUserId()));
    }
}

