/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.split.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.SimpleGoodsNameUtil;
import kd.imc.sim.common.utils.ZeroTaxMarkUtil;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.AbstractBillSplitServiceImpl;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.SplitByRuleServiceImpl;

public abstract class AbstractSplitQuantityService
extends AbstractBillSplitServiceImpl {
    protected void createInvoices(SplitRequestDTO splitRequest, DynamicObject bill, List<DynamicObject> invoices) {
        String newBillNo = (String)splitRequest.getBillNoMap().get(bill.getString("billno"));
        int len = splitRequest.getNum();
        for (int i = 0; i < len; ++i) {
            DynamicObject invoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
            DynamicObjectUtil.copyDynamicObjectWithOutItems((DynamicObject)bill, (DynamicObject)invoice);
            invoice.set("splitorder", (Object)(i + 1));
            this.buildSplitInvoiceQuantityInvoiceMainData(splitRequest, bill, invoice, newBillNo);
            invoices.add(invoice);
        }
    }

    protected void buildSplitInvoiceQuantityInvoiceMainData(SplitRequestDTO splitRequest, DynamicObject bill, DynamicObject invoice, String newBillNo) {
        DynamicObjectCollection items;
        invoice.set("id", (Object)DBServiceHelper.genGlobalLongId());
        invoice.set("billno", (Object)newBillNo);
        invoice.set("issuetype", (Object)(invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0 ? "1" : "0"));
        invoice.set("taxedtype", bill.get("taxationstyle"));
        invoice.set("batchbelong", (Object)this.getMergeBillNoFirst(bill.getString("billno")));
        invoice.set("remark", bill.get("invoiceremark"));
        InvoiceUtils.setSpecialItemToInvoiceByBill((DynamicObject)bill, (DynamicObject)invoice);
        if (splitRequest.getFixedNumber().booleanValue()) {
            invoice.set("mergelable", (Object)"1");
        }
        if ((items = bill.getDynamicObjectCollection("sim_original_bill_item")).size() > 8) {
            invoice.set("inventorymark", (Object)"1");
        } else {
            invoice.set("inventorymark", (Object)"0");
        }
        AbstractSplitQuantityService.buildMainInvoiceData(invoice);
    }

    protected void createInvoiceItem(DynamicObject billItem, DynamicObject invoiceItem, BigDecimal scale, SplitRequestDTO configDto, boolean isDeduction) {
        DynamicObjectUtil.copyDynamicObject((DynamicObject)billItem, (DynamicObject)invoiceItem);
        invoiceItem.set("id", (Object)DBServiceHelper.genGlobalLongId());
        BigDecimal taxAmount = billItem.getBigDecimal("remainvalidamount").divide(scale, 2, 1);
        BigDecimal tax = billItem.getBigDecimal("remainvalidtax").divide(scale, 2, 1);
        if (tax.compareTo(BigDecimal.ZERO) == 0 && billItem.getBigDecimal("remainvalidtax").compareTo(BigDecimal.ZERO) != 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6%2$s\u62c6\u5206\u7a0e\u989d\u4e0d\u80fd\u62c6\u62100", (String)"AbstractSplitQuantityService_0", (String)"imc-sim-service", (Object[])new Object[0]), billItem.getInt("seq") + 1, isDeduction ? ResManager.loadKDString((String)"\u5dee\u989d\u62c6\u5206", (String)"AbstractSplitQuantityService_1", (String)"imc-sim-service", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5f20\u6570", (String)"AbstractSplitQuantityService_2", (String)"imc-sim-service", (Object[])new Object[0])));
        }
        invoiceItem.set("num", (Object)this.getSplitNum(billItem, configDto));
        invoiceItem.set("taxamount", (Object)taxAmount);
        invoiceItem.set("tax", (Object)tax);
        String invoiceType = configDto.getBill().getString("invoicetype");
        String isElePaper = configDto.getBill().getString("iselepaper");
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(isElePaper);
        this.calcPriceAndFillAmount(invoiceItem, isAllEle);
        String billRowType = billItem.getString("rowtype");
        if ("2".equals(billRowType)) {
            invoiceItem.set("rowtype", (Object)"0");
        }
        invoiceItem.set("taxpremark", (Object)billItem.getString("policylogo"));
        invoiceItem.set("zzstsgl", (Object)billItem.getString("policycontants"));
        invoiceItem.set("simplegoodsname", (Object)billItem.getString("goodssimplename"));
        SimpleGoodsNameUtil.handlerSimpleGoodsName((DynamicObject)invoiceItem);
        ZeroTaxMarkUtil.handlerZeroTaxMark((DynamicObject)invoiceItem);
    }

    protected BigDecimal getSplitNum(DynamicObject billItem, SplitRequestDTO request) {
        BigDecimal splitNum = billItem.getBigDecimal("remainvalidnum");
        if (!request.getFixedNumber().booleanValue() && !MathUtils.isNullOrZero((BigDecimal)splitNum)) {
            String remaingValidNumStr = splitNum.stripTrailingZeros().toPlainString();
            int pointLength = 0;
            String[] split = remaingValidNumStr.split("\\.");
            if (split.length == 2) {
                pointLength = split[1].length();
            }
            int maxPointLength = UnitPriceHelper.getMaxPointLength((BigDecimal)splitNum, (BigDecimal)new BigDecimal(request.getNum()));
            while (pointLength <= maxPointLength) {
                BigDecimal num = splitNum.divide(new BigDecimal(request.getNum()), pointLength, 1);
                if (!MathUtils.isNullOrZero((BigDecimal)num)) {
                    splitNum = num;
                    break;
                }
                ++pointLength;
            }
        }
        return splitNum;
    }

    protected void calcPriceAndFillAmount(DynamicObject invoiceItem, boolean isAllEle) {
        invoiceItem.set("amount", (Object)invoiceItem.getBigDecimal("taxamount").subtract(invoiceItem.getBigDecimal("tax")));
        SplitByRuleServiceImpl.calcPrice(invoiceItem, isAllEle);
    }

    protected void adjustmentTaxDiff(BigDecimal taxAmountSum, BigDecimal taxSum, DynamicObject billItem, List<DynamicObject> invoices, int itemIndex) {
        DynamicObject invoiceItem;
        BigDecimal taxDiff = billItem.getBigDecimal("remainvalidtax").subtract(taxSum);
        BigDecimal taxAmountDiff = billItem.getBigDecimal("remainvalidamount").subtract(taxAmountSum);
        BigDecimal taxAdjustment = taxAmountDiff.compareTo(BigDecimal.ZERO) < 0 ? InvoiceConstant.DIFF_01.negate() : InvoiceConstant.DIFF_01;
        String invoiceType = invoices.get(0).getString("invoicetype");
        String isElePaper = invoices.get(0).getString("iselepaper");
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(isElePaper);
        int invoiceIndex = 0;
        while (taxAmountDiff.compareTo(BigDecimal.ZERO) != 0) {
            invoiceItem = (DynamicObject)invoices.get(invoiceIndex).getDynamicObjectCollection("items").get(itemIndex);
            invoiceItem.set("taxamount", (Object)invoiceItem.getBigDecimal("taxamount").add(taxAdjustment));
            taxAmountDiff = taxAmountDiff.subtract(taxAdjustment);
            if (taxDiff.compareTo(BigDecimal.ZERO) != 0) {
                taxDiff = taxDiff.subtract(taxAdjustment);
                invoiceItem.set("tax", (Object)invoiceItem.getBigDecimal("tax").add(taxAdjustment));
            }
            this.calcPriceAndFillAmount(invoiceItem, isAllEle);
            invoiceIndex = invoiceIndex == invoices.size() - 1 ? 0 : ++invoiceIndex;
        }
        BigDecimal bigDecimal = taxAdjustment = taxDiff.compareTo(BigDecimal.ZERO) < 0 ? InvoiceConstant.DIFF_01.negate() : InvoiceConstant.DIFF_01;
        while (taxDiff.compareTo(BigDecimal.ZERO) != 0) {
            invoiceItem = (DynamicObject)invoices.get(invoiceIndex).getDynamicObjectCollection("items").get(itemIndex);
            invoiceItem.set("tax", (Object)invoiceItem.getBigDecimal("tax").add(taxAdjustment));
            taxDiff = taxDiff.subtract(taxAdjustment);
            this.calcPriceAndFillAmount(invoiceItem, isAllEle);
            invoiceIndex = invoiceIndex == invoices.size() - 1 ? 0 : ++invoiceIndex;
        }
    }

    protected List<BillRelationDTO> createBillInvoiceRelation(Integer num, DynamicObject bill, List<DynamicObject> invoices) {
        DynamicObjectCollection billItems = bill.getDynamicObjectCollection("sim_original_bill_item");
        ArrayList<BillRelationDTO> relations = new ArrayList<BillRelationDTO>(num * billItems.size());
        for (int numIndex = 0; numIndex < num; ++numIndex) {
            int size = billItems.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject billItem = (DynamicObject)billItems.get(i);
                DynamicObject invoice = invoices.get(numIndex);
                DynamicObject invoiceItem = (DynamicObject)invoice.getDynamicObjectCollection("items").get(i);
                BillRelationDTO relation = new BillRelationDTO(Long.valueOf(bill.getLong("id")), "", Long.valueOf(billItem.getLong("id")), Long.valueOf(invoice.getLong("id")), invoice.getString("billno"), Long.valueOf(invoiceItem.getLong("id")), invoiceItem.getBigDecimal("amount"), invoiceItem.getBigDecimal("tax"), invoiceItem.getBigDecimal("num"), invoiceItem.getBigDecimal("unitprice"), "sim_vatinvoice", "1", DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("orgid")));
                relations.add(relation);
            }
        }
        return relations;
    }

    protected void calcInvoiceHeadAmount(List<DynamicObject> invoices) {
        for (DynamicObject invoice : invoices) {
            BigDecimal amountSum = BigDecimal.ZERO;
            BigDecimal taxAmountSum = BigDecimal.ZERO;
            BigDecimal taxSum = BigDecimal.ZERO;
            DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
            for (DynamicObject item : items) {
                amountSum = amountSum.add(item.getBigDecimal("amount"));
                taxAmountSum = taxAmountSum.add(item.getBigDecimal("taxamount"));
                taxSum = taxSum.add(item.getBigDecimal("tax"));
            }
            invoice.set("totalamount", (Object)taxAmountSum);
            invoice.set("invoiceamount", (Object)amountSum);
            invoice.set("totaltax", (Object)taxSum);
        }
    }
}

