/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.split.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.table.SplitRuleTable;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.merge.MergeTaxDeviationDTO;
import kd.imc.bdm.common.dto.split.LimitAmountsDTO;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.dto.split.SplitResponseDTO;
import kd.imc.bdm.common.helper.ReducedHelper;
import kd.imc.bdm.common.helper.SplitRuleHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.enums.TaxDiffEnum;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;
import kd.imc.sim.common.utils.ZeroTaxMarkUtil;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeHelper;
import kd.imc.sim.formplugin.bill.splitMerge.split.dto.SplitAisinoDTO;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.AbstractBillSplitServiceImpl;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.SplitBySameTypeServiceImpl;
import kd.imc.sim.split.SMSERN;
import kd.imc.sim.split.dto.BillDealResultDto;
import kd.imc.sim.split.dto.BillDetailDto;
import kd.imc.sim.split.dto.BillDetailIdDto;
import kd.imc.sim.split.dto.BillSubjectDto;
import kd.imc.sim.split.dto.InvoiceDetailDto;
import kd.imc.sim.split.dto.InvoiceSubjectDto;
import kd.imc.sim.split.dto.SmsResultDto;
import org.apache.commons.collections.CollectionUtils;

public class SplitByRuleServiceImpl
extends AbstractBillSplitServiceImpl
implements SplitRuleTable {
    private static Log LOGGER = LogFactory.getLog(SplitByRuleServiceImpl.class);
    public static final Map<String, String> ERROR_MSG_MAP = new ImmutableMap.Builder().put((Object)ResManager.loadKDString((String)"\u8d1f\u6570\u884c\u51b2\u62b5\u65f6\u5fc5\u987b\u7a0e\u7387\u4e00\u81f4\u624d\u5141\u8bb8\u51b2\u62b5\u3002\u4e0e\u8d1f\u6570\u884c\u7a0e\u7387\u76f8\u540c\u7684\u5546\u54c1\u660e\u7ec6\u91d1\u989d\u4e0d\u591f\u51b2\u62b5\uff0c\u8bf7\u8c03\u6574\u51b2\u62b5\u91d1\u989d", (String)"SplitByRuleServiceImpl_0", (String)"imc-sim-service", (Object[])new Object[0]), (Object)ResManager.loadKDString((String)"\u8d1f\u6570\u884c\u51b2\u62b5\u91d1\u989d\u5927\u4e8e\u7a0e\u7387\u4e00\u81f4\u7684\u6b63\u6570\u884c\u91d1\u989d\uff0c\u8bf7\u56de\u9000\u81f3\u5f00\u7968\u7533\u8bf7\u5355\u8fdb\u884c\u8c03\u6574", (String)"SplitByRuleServiceImpl_1", (String)"imc-sim-service", (Object[])new Object[0])).build();
    public static final ImmutableSet<String> DEFAULT_RULE = ImmutableSet.of((Object)"imc_no_split", (Object)"imc_split_by_detail", (Object)"imc_split_by_amount", (Object)"imc_split_by_invoice_quantity", (Object)"imc_deduction_split");

    @Override
    public boolean support(SplitRequestDTO request) {
        if (StringUtils.isBlank((CharSequence)request.getRuleCode())) {
            return false;
        }
        if (DEFAULT_RULE.contains((Object)request.getRuleCode())) {
            return false;
        }
        if (request.getRuleObj() != null) {
            return true;
        }
        DynamicObject rule = SplitRuleHelper.getRuleByCode((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)request.getBill().get("orgid")), (String)request.getRuleCode());
        if (null == rule) {
            return false;
        }
        request.setRuleObj(rule);
        return true;
    }

    @Override
    public SplitResponseDTO split(SplitRequestDTO request) {
        DynamicObject rule = request.getRuleObj();
        String invoiceType = request.getBill().getString("invoicetype");
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            if (MathUtils.isNullOrZero((BigDecimal)rule.getBigDecimal(InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType) ? "allelecommonlimitamount" : "allelespeciallimitamount"))) {
                throw new MsgException("9999", String.format(ResManager.loadKDString((String)"\u62c6\u5408\u89c4\u5219\u8bbe\u7f6e%s\u9650\u989d\u4e0d\u80fd\u4e3a0", (String)"SplitByRuleServiceImpl_2", (String)"imc-sim-service", (Object[])new Object[0]), InvoiceType.getDescription((String)invoiceType)));
            }
        } else if (rule.getBoolean("splitwithamount")) {
            if (this.checkRuleQuota(rule, invoiceType)) {
                throw new MsgException("9999", String.format(ResManager.loadKDString((String)"\u62c6\u5408\u89c4\u5219\u8bbe\u7f6e%s\u9650\u989d\u4e0d\u80fd\u4e3a0", (String)"SplitByRuleServiceImpl_2", (String)"imc-sim-service", (Object[])new Object[0]), InvoiceType.getDescription((String)invoiceType)));
            }
        } else if (this.checkDevQuota(request.getLimitAmounts(), invoiceType)) {
            throw new MsgException("9999", String.format(ResManager.loadKDString((String)"\u5f00\u7968\u8bbe\u5907\u8bbe\u7f6e%s\u9650\u989d\u4e0d\u80fd\u4e3a0", (String)"SplitByRuleServiceImpl_3", (String)"imc-sim-service", (Object[])new Object[0]), InvoiceType.getDescription((String)invoiceType)));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u5355\u636e\u7f16\u53f7[%s]\u6267\u884c\u7684\u62c6\u5206\u89c4\u5219\u662f[%s]", request.getBill().getString("billno"), SerializationUtils.toJsonString((Object)rule)));
        }
        if (rule.getBoolean("itemsplittype")) {
            return new SplitBySameTypeServiceImpl().split(request);
        }
        SplitAisinoDTO splitAisinoDTO = this.buildSplitDto(request, request.getBill().getDynamicObjectCollection("sim_original_bill_item"));
        SmsResultDto resultDto = this.doSplitBill(splitAisinoDTO);
        return this.handlerSplitResult(resultDto, request, 1);
    }

    private boolean checkDevQuota(LimitAmountsDTO devLimit, String invoiceType) {
        Map<String, BigDecimal> limitMap = SplitByRuleServiceImpl.getLimitMap(devLimit);
        BigDecimal invoiceAmount = limitMap.get(invoiceType);
        return MathUtils.isNullOrZero((BigDecimal)invoiceAmount);
    }

    private boolean checkRuleQuota(DynamicObject rule, String invoiceType) {
        HashMap<String, BigDecimal> limitMap = new HashMap<String, BigDecimal>();
        limitMap.put(InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), rule.getBigDecimal("papercommonlimitamount"));
        limitMap.put(InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode(), rule.getBigDecimal("paperspeciallimitamount"));
        limitMap.put(InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), rule.getBigDecimal("elecommonlimitamount"));
        limitMap.put(InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode(), rule.getBigDecimal("elespeciallimitamount"));
        limitMap.put(InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode(), new BigDecimal("9999999999.99"));
        BigDecimal invoiceAmount = (BigDecimal)limitMap.get(invoiceType);
        return MathUtils.isNullOrZero((BigDecimal)invoiceAmount);
    }

    public SplitAisinoDTO buildSplitDto(SplitRequestDTO request, DynamicObjectCollection items) {
        BillSubjectDto billSubjectDto = new BillSubjectDto();
        List<BillDetailDto> billDList = this.getDtoByItems(items, request.getBill());
        billSubjectDto.setBillDList(billDList);
        billSubjectDto.setBillNO((String)request.getBillNoMap().get(request.getBill().getString("billno")));
        String invType = Objects.requireNonNull(InvoiceType.getTypeCodeHx((String)request.getBill().getString("invoicetype")));
        invType = InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCodeHx().equals(invType) ? "52" : invType;
        billSubjectDto.setInvKind(Integer.valueOf(Integer.parseInt(invType)));
        return new SplitAisinoDTO.Builder(request).billSList(billSubjectDto).isAllEReducedTax(TaxedTypeEnum.all_e_reduced_tax.getValue().equals(request.getBill().getString("taxationstyle"))).isOil("08".equals(request.getBill().getString("specialtype"))).builder();
    }

    private List<BillDetailDto> getDtoByItems(DynamicObjectCollection items, DynamicObject bill) {
        ArrayList detailDtos = Lists.newArrayListWithExpectedSize((int)items.size());
        BigDecimal taxRate = null;
        for (DynamicObject item : items) {
            if (item.getBigDecimal("remainvalidamount").compareTo(BigDecimal.ZERO) == 0) continue;
            BillDetailDto billDetailDto = new BillDetailDto();
            billDetailDto.setBillNO(bill.getString("id"));
            billDetailDto.setBillDetailNO(item.getString("id"));
            String goodsSimpleName = item.getString("goodssimplename");
            if (StringUtils.isNotBlank((CharSequence)goodsSimpleName)) {
                billDetailDto.setGoodsName('*' + goodsSimpleName + '*' + item.getString("goodsname"));
            } else {
                billDetailDto.setGoodsName(item.getString("goodsname"));
            }
            billDetailDto.setGoodsCode(item.getString("goodscode"));
            billDetailDto.setGoodsModel(item.getString("specification"));
            billDetailDto.setGoodsUnit(item.getString("unit"));
            billDetailDto.setAmts(item.getBigDecimal("remainvalidnum"));
            billDetailDto.setTaxAmt(item.getBigDecimal("remainvalidtax"));
            if ("1".equals(item.getString("rowtype"))) {
                billDetailDto.setLineProperty(Integer.valueOf(4));
                billDetailDto.setDisRows(Integer.valueOf(1));
            } else {
                billDetailDto.setLineProperty(Integer.valueOf(0));
                billDetailDto.setDisRows(Integer.valueOf(0));
            }
            if (StringUtils.isNotEmpty((CharSequence)item.getString("taxrate"))) {
                billDetailDto.setTaxRate(new BigDecimal(item.getString("taxrate")));
                if (taxRate == null) {
                    taxRate = billDetailDto.getTaxRate();
                }
            }
            billDetailDto.setTaxPre(Integer.valueOf(item.getInt("policylogo")));
            billDetailDto.setTaxPreCon(item.getString("policycontants"));
            billDetailDto.setLineNote(item.getString("remark"));
            billDetailDto.setBy1(item.getString("billsourceid"));
            billDetailDto.setIncludeTax(Integer.valueOf(bill.getInt("hsbz")));
            if (0 == billDetailDto.getIncludeTax()) {
                billDetailDto.setAmounts(item.getBigDecimal("remainvalidamount").subtract(item.getBigDecimal("remainvalidtax")));
                billDetailDto.setPrice(item.getBigDecimal("unitprice"));
            } else {
                billDetailDto.setAmounts(item.getBigDecimal("remainvalidamount"));
                billDetailDto.setPrice(item.getBigDecimal("taxunitprice"));
            }
            detailDtos.add(billDetailDto);
        }
        for (BillDetailDto billDetailDto : detailDtos) {
            if (4 != billDetailDto.getLineProperty() || billDetailDto.getDisRows() != -1 || billDetailDto.getTaxRate() != null) continue;
            billDetailDto.setTaxRate(taxRate);
        }
        return detailDtos;
    }

    public SmsResultDto doSplitBill(SplitAisinoDTO requestDto) {
        String splitRequestStr = JSONObject.toJSONString((Object)requestDto.getSmsRequestDto());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("jar\u5305\u8c03\u7528\u5165\u53c2:" + splitRequestStr);
        }
        SmsResultDto smsr = new SMSERN().doSMSER(requestDto.getSmsRequestDto());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("jar\u5305\u8c03\u7528\u8f93\u51fa:" + JSON.toJSONString((Object)smsr));
        }
        return smsr;
    }

    public SplitResponseDTO handlerSplitResult(SmsResultDto resultDto, SplitRequestDTO request, int invoiceIndex) {
        boolean isAllEle;
        List invoiceSList = resultDto.getInvoiceSList();
        ArrayList<DynamicObject> invoices = new ArrayList<DynamicObject>(CollectionUtils.isEmpty((Collection)invoiceSList) ? 1 : resultDto.getInvoiceSList().size());
        ArrayList relationDTOS = Lists.newArrayList();
        String invoiceType = request.getBill().getString("invoicetype");
        String isElePaper = request.getBill().getString("iselepaper");
        boolean bl = isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(isElePaper);
        if (!resultDto.isSuccess()) {
            throw new MsgException("9999", resultDto.getErrorMsg());
        }
        if (resultDto.getTotals() != resultDto.getDoSucc()) {
            List bdrList = resultDto.getBdrList();
            StringBuilder buf = new StringBuilder();
            buf.append(ResManager.loadKDString((String)"\u62c6\u5206\u5904\u7406\u5931\u8d25-", (String)"SplitByRuleServiceImpl_4", (String)"imc-sim-service", (Object[])new Object[0]));
            for (BillDealResultDto bdr2 : bdrList) {
                if (bdr2.isSuccess()) continue;
                String errMsg = bdr2.getErrorMsg();
                if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                    String errorMsg = bdr2.getErrorMsg().replace(String.valueOf(request.getBill().getLong("id")), request.getBill().getString("billno"));
                    if (null != ERROR_MSG_MAP.get(errorMsg)) {
                        errorMsg = ERROR_MSG_MAP.get(errorMsg);
                    }
                    buf.append(errorMsg);
                    continue;
                }
                buf.append(ResManager.loadKDString((String)"\u62c6\u5206\u5931\u8d25", (String)"SplitByRuleServiceImpl_5", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            throw new MsgException("9998", buf.toString());
        }
        DynamicObjectCollection billItems = request.getBill().getDynamicObjectCollection("sim_original_bill_item");
        HashMap<Long, DynamicObject> billItemMap = new HashMap<Long, DynamicObject>(billItems.size());
        for (DynamicObject billItem : billItems) {
            billItemMap.put(billItem.getLong("id"), billItem);
        }
        DynamicObject rule = request.getRuleObj();
        for (InvoiceSubjectDto invoice : invoiceSList) {
            String invoiceBillNo = (String)request.getBillNoMap().get(request.getBill().getString("billno"));
            DynamicObject batchObj = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
            DynamicObjectUtil.copyDynamicObjectWithOutItems((DynamicObject)request.getBill(), (DynamicObject)batchObj);
            batchObj.set("billno", (Object)invoiceBillNo);
            batchObj.set("splitorder", (Object)invoiceIndex);
            ++invoiceIndex;
            this.initPrepareInvoice(batchObj, request, invoice);
            DynamicObject preItemDetail = null;
            List invoiceDetailList = invoice.getInvoiceDetailList();
            BigDecimal countNum = BigDecimal.ZERO;
            HashSet iscount = Sets.newHashSetWithExpectedSize((int)2);
            for (InvoiceDetailDto invoiceDetailDto : invoiceDetailList) {
                if (!Objects.nonNull(invoiceDetailDto.getAmts())) continue;
                countNum = countNum.add(invoiceDetailDto.getAmts());
                BigDecimal amts = invoiceDetailDto.getAmts();
                iscount.add(amts.setScale(rule.getInt("quantitydecimallimit"), 4).compareTo(amts) != 0);
            }
            BigDecimal invoiceAmount = BigDecimal.ZERO;
            BigDecimal tax = BigDecimal.ZERO;
            for (int i = 0; i < invoiceDetailList.size(); ++i) {
                InvoiceDetailDto invoiceDetail = (InvoiceDetailDto)invoiceDetailList.get(i);
                Long detailId = DBServiceHelper.genGlobalLongId();
                Set detailIdSet = invoiceDetail.getDetailIdSet();
                BillRelationDTO billRelation = null;
                for (BillDetailIdDto detail : detailIdSet) {
                    billRelation = new BillRelationDTO(Long.valueOf(Long.parseLong(detail.getBillNO())), "", Long.valueOf(Long.parseLong(detail.getBillDetailNO())), Long.valueOf(batchObj.getLong("id")), invoiceBillNo, detailId, invoiceDetail.getAmounts(), invoiceDetail.getTaxAmt(), invoiceDetail.getAmts(), invoiceDetail.getPrice(), "sim_vatinvoice", "1", DynamicObjectUtil.getDynamicObjectLongValue((Object)request.getBill().get("orgid")));
                    relationDTOS.add(billRelation);
                }
                DynamicObject itemDetail = batchObj.getDynamicObjectCollection("items").addNew();
                if (billRelation != null && billItemMap.get(billRelation.getsDetailId()) != null) {
                    DynamicObject billItem = (DynamicObject)billItemMap.get(billRelation.getsDetailId());
                    DynamicObjectUtil.copyDynamicObject((DynamicObject)billItem, (DynamicObject)itemDetail);
                    itemDetail.set("simplegoodsname", (Object)billItem.getString("goodssimplename"));
                    if (!itemDetail.getString("simplegoodsname").startsWith("*")) {
                        itemDetail.set("simplegoodsname", (Object)("*" + itemDetail.getString("simplegoodsname") + "*"));
                    }
                }
                itemDetail.set("id", (Object)detailId);
                itemDetail.set("seq", (Object)i);
                this.initPrepareInvoiceItem(itemDetail, invoiceDetail);
                invoiceAmount = invoiceAmount.add(invoiceDetail.getAmounts());
                tax = tax.add(invoiceDetail.getTaxAmt());
                if (invoiceDetail.getLineProperty() == 4) {
                    itemDetail.set("rowtype", (Object)"1");
                    if (null != preItemDetail) {
                        preItemDetail.set("rowtype", (Object)"2");
                        itemDetail.set("goodscode", preItemDetail.get("goodscode"));
                    }
                } else {
                    itemDetail.set("rowtype", (Object)"0");
                    preItemDetail = itemDetail;
                }
                if (rule.getBoolean("fixedquantity")) {
                    if (!MathUtils.isNullOrZero((BigDecimal)itemDetail.getBigDecimal("num"))) {
                        itemDetail.set("num", rule.get("quantity"));
                        batchObj.set("mergelable", (Object)"1");
                    }
                } else if ((iscount.size() > 1 || ((Boolean)iscount.iterator().next()).booleanValue()) && "2".equals(rule.getString("dealnum")) & ("1".equals(rule.getString("detailsplitrule")) && "2".equals(rule.getString("detailquantitysplitrule")) || "0".equals(rule.getString("detailsplitrule"))) && !MathUtils.isNullOrZero((BigDecimal)itemDetail.getBigDecimal("num"))) {
                    countNum = this.dealInvoiceNum(itemDetail, rule, countNum, i + 1 == invoiceDetailList.size());
                }
                SplitByRuleServiceImpl.calcPrice(itemDetail, isAllEle);
            }
            batchObj.set("invoiceamount", (Object)invoiceAmount);
            batchObj.set("totaltax", (Object)tax);
            batchObj.set("totalamount", (Object)invoiceAmount.add(tax));
            invoices.add(batchObj);
        }
        this.adjustmentTaxDeviation(invoices, relationDTOS, request.getBill());
        return new SplitResponseDTO(invoices, (List)relationDTOS);
    }

    private void adjustmentTaxDeviation(List<DynamicObject> invoices, List<BillRelationDTO> relationList, DynamicObject bill) {
        if (InvoiceUtils.isAllEInvoice((Object)invoices.get(0).getString("invoicetype"))) {
            return;
        }
        TaxDiffEnum taxDiff = new BillMergeHelper().getTaxDiff(bill, bill.getString("jqbh"));
        if (taxDiff != TaxDiffEnum.DIFF_AVG_001) {
            return;
        }
        for (DynamicObject invoice : invoices) {
            Integer taxDeviationNearIndex;
            DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
            BigDecimal allowTaxDeviation = InvoiceConstant.DIFF_01.multiply(new BigDecimal(items.size()));
            HashMap<Integer, MergeTaxDeviationDTO> taxDeviationMap = new HashMap<Integer, MergeTaxDeviationDTO>(items.size());
            for (int i = 0; i < items.size(); ++i) {
                taxDeviationMap.put(i, new MergeTaxDeviationDTO("", SplitByRuleServiceImpl.getTaxDeviation((DynamicObject)items.get(i))));
            }
            BigDecimal taxDeviationSum = SplitByRuleServiceImpl.getTaxDeviationSum(invoice);
            while (allowTaxDeviation.compareTo(taxDeviationSum.abs()) < 0 && (taxDeviationNearIndex = BillMergeHelper.getTaxDeviationNear(new ArrayList<Map.Entry<Integer, MergeTaxDeviationDTO>>(taxDeviationMap.entrySet()), taxDeviationSum)) != null) {
                DynamicObject item = (DynamicObject)items.get(taxDeviationNearIndex.intValue());
                BigDecimal calcTax = TaxCalcUtil.calTax((BigDecimal)item.getBigDecimal("amount"), (BigDecimal)BigDecimal.ZERO, (String)item.getString("taxrate"), (boolean)false, (int)2);
                BigDecimal diffTax = item.getBigDecimal("tax").subtract(calcTax);
                item.set("tax", (Object)calcTax);
                item.set("amount", (Object)item.getBigDecimal("amount").add(diffTax));
                SplitByRuleServiceImpl.calcPrice(item, false);
                invoice.set("totaltax", (Object)invoice.getBigDecimal("totaltax").subtract(diffTax));
                invoice.set("invoiceamount", (Object)invoice.getBigDecimal("invoiceamount").add(diffTax));
                taxDeviationMap.remove(taxDeviationNearIndex);
                taxDeviationSum = SplitByRuleServiceImpl.getTaxDeviationSum(invoice);
                relationList.stream().filter(relation -> relation.gettBillId().equals(invoice.getLong("id")) && relation.gettDetailId().equals(item.getLong("id"))).findFirst().ifPresent(relation -> {
                    relation.setTax(calcTax);
                    relation.setAmount(item.getBigDecimal("amount"));
                    relation.setTaxDeviation(diffTax);
                });
            }
        }
    }

    private static BigDecimal getTaxDeviationSum(DynamicObject invoice) {
        DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
        BigDecimal taxDeviationSum = BigDecimal.ZERO;
        for (DynamicObject item : items) {
            taxDeviationSum = taxDeviationSum.add(SplitByRuleServiceImpl.getTaxDeviation(item));
        }
        return taxDeviationSum.setScale(2, 4);
    }

    private static BigDecimal getTaxDeviation(DynamicObject item) {
        BigDecimal calcTax = TaxCalcUtil.calTax((BigDecimal)item.getBigDecimal("amount"), (BigDecimal)BigDecimal.ZERO, (String)item.getString("taxrate"), (boolean)false, (int)6);
        return item.getBigDecimal("tax").subtract(calcTax).setScale(6, 4);
    }

    private void initPrepareInvoice(DynamicObject prePareInvoice, SplitRequestDTO request, InvoiceSubjectDto invoice) {
        DynamicObject originalBill = request.getBill();
        prePareInvoice.set("mergelable", (Object)(invoice.isOneUnchange() ? "1" : ""));
        prePareInvoice.set("id", (Object)DBServiceHelper.genGlobalLongId());
        prePareInvoice.set("inventorymark", (Object)invoice.getListFlag());
        prePareInvoice.set("orgid", originalBill.get("orgid"));
        prePareInvoice.set("issuetype", (Object)IssueType.BLUE_INVOICE.getTypeCode());
        prePareInvoice.set("batchbelong", (Object)this.getMergeBillNoFirst(originalBill.getString("billno")));
        prePareInvoice.set("taxedtype", (Object)"0");
        if (null != originalBill.get("deduction") && originalBill.getBigDecimal("deduction").compareTo(BigDecimal.ZERO) != 0) {
            prePareInvoice.set("taxedtype", (Object)"2");
        }
        if (ReducedHelper.isReduced((Object)originalBill.get("taxationstyle"))) {
            prePareInvoice.set("taxedtype", (Object)"1");
        }
        if (TaxedTypeEnum.all_e_reduced_tax.getValue().equals(originalBill.getString("taxationstyle"))) {
            prePareInvoice.set("taxedtype", (Object)TaxedTypeEnum.all_e_reduced_tax.getValue());
        }
        InvoiceUtils.setSpecialItemToInvoiceByBill((DynamicObject)request.getBill(), (DynamicObject)prePareInvoice);
        String remark = originalBill.getString("invoiceremark");
        DynamicObject ruleObj = request.getRuleObj();
        int remarkRule = ruleObj.getInt("invoiceremarkrule");
        switch (remarkRule) {
            case 0: 
            case 1: {
                remark = remark + invoice.getInvoiceNote();
                break;
            }
            case 3: {
                String splitRegex;
                DynamicObjectCollection items = originalBill.getDynamicObjectCollection("sim_original_bill_item");
                Stream<String> remrakStream = items.stream().map(item -> item.getString("remark"));
                if (ruleObj.getBoolean("remarkautodistinct")) {
                    remrakStream = remrakStream.distinct();
                }
                if ("\\n".equals(splitRegex = ruleObj.getString("remarksplitregex"))) {
                    splitRegex = System.lineSeparator();
                }
                remark = remark + remrakStream.collect(Collectors.joining(splitRegex));
            }
        }
        if (InvoiceUtils.isAllEInvoice((Object)prePareInvoice.getString("invoicetype"))) {
            prePareInvoice.set("remark", (Object)(remark.length() > 200 ? remark.substring(0, 200) : remark));
        } else {
            prePareInvoice.set("remark", (Object)GBKUtils.cutGBKString((String)remark, (int)230));
        }
        SplitByRuleServiceImpl.buildMainInvoiceData(prePareInvoice);
    }

    private void initPrepareInvoiceItem(DynamicObject itemDetail, InvoiceDetailDto invoiceDetailDto) {
        itemDetail.set("billsourceid", (Object)invoiceDetailDto.getBy1());
        itemDetail.set("goodsname", (Object)invoiceDetailDto.getGoodsName());
        itemDetail.set("specification", (Object)invoiceDetailDto.getGoodsModel());
        itemDetail.set("unit", (Object)invoiceDetailDto.getGoodsUnit());
        itemDetail.set("num", (Object)invoiceDetailDto.getAmts());
        itemDetail.set("unitprice", (Object)invoiceDetailDto.getPrice());
        itemDetail.set("taxunitprice", (Object)invoiceDetailDto.getPriceIncTax());
        itemDetail.set("amount", (Object)invoiceDetailDto.getAmounts());
        itemDetail.set("tax", (Object)invoiceDetailDto.getTaxAmt());
        itemDetail.set("taxamount", (Object)invoiceDetailDto.getAmounts().add(invoiceDetailDto.getTaxAmt()));
        itemDetail.set("taxrate", (Object)invoiceDetailDto.getTaxRate());
        itemDetail.set("goodscode", (Object)invoiceDetailDto.getGoodsCode());
        itemDetail.set("taxflag", (Object)invoiceDetailDto.getIncludeTax());
        itemDetail.set("taxpremark", (Object)invoiceDetailDto.getTaxPre());
        itemDetail.set("zzstsgl", (Object)invoiceDetailDto.getTaxPreCon());
        itemDetail.set("zerotaxmark", (Object)invoiceDetailDto.getZeroTax());
        ZeroTaxMarkUtil.handlerZeroTaxMark((DynamicObject)itemDetail);
    }

    private BigDecimal dealInvoiceNum(DynamicObject itemDetail, DynamicObject rule, BigDecimal countNum, boolean isLastDetail) {
        int numLimit = rule.getInt("quantitydecimallimit");
        if (isLastDetail) {
            itemDetail.set("num", (Object)countNum);
            return BigDecimal.ZERO;
        }
        BigDecimal tempNum = itemDetail.getBigDecimal("num").setScale(numLimit, 1);
        if (tempNum.compareTo(BigDecimal.ZERO) == 0) {
            return countNum.subtract(itemDetail.getBigDecimal("num"));
        }
        if (tempNum.compareTo(itemDetail.getBigDecimal("num")) != 0) {
            itemDetail.set("num", (Object)tempNum);
        }
        return countNum.subtract(tempNum);
    }

    public static void calcPrice(DynamicObject item, boolean isAllEle) {
        BigDecimal num = item.getBigDecimal("num");
        if (MathUtils.isNullOrZero((BigDecimal)num)) {
            item.set("taxunitprice", (Object)BigDecimal.ZERO);
            item.set("unitprice", (Object)BigDecimal.ZERO);
            return;
        }
        BigDecimal unitPrice = item.getBigDecimal("unitprice");
        int unitPriceLength = unitPrice.stripTrailingZeros().toPlainString().length();
        int priceMaxLength = 16;
        if (isAllEle) {
            priceMaxLength = 25;
        }
        if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)num, (BigDecimal)unitPrice), (BigDecimal)item.getBigDecimal("amount"), (BigDecimal)InvoiceConstant.DIFF_01) || unitPriceLength > priceMaxLength) {
            item.set("unitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)item.getBigDecimal("amount"), (BigDecimal)num, (boolean)isAllEle));
        }
        BigDecimal taxUnitPrice = item.getBigDecimal("taxunitprice");
        int taxUnitPriceLength = taxUnitPrice.stripTrailingZeros().toPlainString().length();
        if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)num, (BigDecimal)taxUnitPrice), (BigDecimal)item.getBigDecimal("taxamount"), (BigDecimal)InvoiceConstant.DIFF_01) || taxUnitPriceLength > priceMaxLength) {
            item.set("taxunitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)item.getBigDecimal("taxamount"), (BigDecimal)num, (boolean)isAllEle));
        }
    }
}

