/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.splitMerge.split.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.dto.split.SplitResponseDTO;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeMethod;
import kd.imc.sim.formplugin.bill.splitMerge.split.dto.SplitAisinoDTO;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.SplitByRuleServiceImpl;
import kd.imc.sim.split.dto.SmsResultDto;
import org.apache.commons.lang3.StringUtils;

public class SplitBySameTypeServiceImpl {
    public SplitResponseDTO split(SplitRequestDTO request) {
        Collection<DynamicObjectCollection> splitBillItemList = this.groupByItemMerge(request);
        ArrayList invoices = Lists.newArrayList();
        ArrayList relationDTOS = Lists.newArrayList();
        int invoiceIndex = 1;
        SplitByRuleServiceImpl splitByRule = new SplitByRuleServiceImpl();
        for (DynamicObjectCollection billItems : splitBillItemList) {
            SplitAisinoDTO splitAisinoDTO = splitByRule.buildSplitDto(request, billItems);
            SmsResultDto resultDto = splitByRule.doSplitBill(splitAisinoDTO);
            SplitResponseDTO splitResponseDTO = splitByRule.handlerSplitResult(resultDto, request, invoiceIndex);
            invoices.addAll(splitResponseDTO.getInvoices());
            relationDTOS.addAll(splitResponseDTO.getRelations());
            invoiceIndex += splitResponseDTO.getInvoices().size();
        }
        return new SplitResponseDTO((List)invoices, (List)relationDTOS);
    }

    private Collection<DynamicObjectCollection> groupByItemMerge(SplitRequestDTO request) {
        DynamicObject bill = request.getBill();
        DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
        boolean isTax = "1".equals(bill.getString("hsbz"));
        String itemSplitKey = "";
        DynamicObject rule = request.getRuleObj();
        if (rule != null) {
            itemSplitKey = rule.getString("itemsplitkey");
        }
        LinkedHashMap<String, DynamicObjectCollection> returnMap = new LinkedHashMap<String, DynamicObjectCollection>(items.size());
        block8: for (int i = 0; i < items.size(); ++i) {
            DynamicObject item = (DynamicObject)items.get(i);
            switch (item.getString("rowtype")) {
                case "2": {
                    String mergeBillDetailKey = this.getGroupKey(item, isTax, itemSplitKey);
                    List dynamicObjects = (List)returnMap.computeIfAbsent(mergeBillDetailKey, k -> new DynamicObjectCollection());
                    dynamicObjects.add(item);
                    continue block8;
                }
                case "1": {
                    ((DynamicObjectCollection)returnMap.get(this.getGroupKey((DynamicObject)items.get(i - 1), isTax, itemSplitKey))).add((Object)item);
                }
            }
        }
        return returnMap.values();
    }

    private String getGroupKey(DynamicObject item, boolean isTax, String itemSplitKey) {
        ArrayList<String> list = new ArrayList<String>(15);
        if (StringUtils.isNotBlank((CharSequence)itemSplitKey)) {
            String price = isTax ? item.getString("taxunitprice") : item.getString("unitprice");
            String[] itemMergeFields = itemSplitKey.split(",");
            BillMergeMethod.getMergeValue(list, itemMergeFields, item, price);
        } else {
            list.add(item.getString("goodsname"));
            list.add(item.getString("goodscode"));
        }
        return String.join((CharSequence)"\u25cf\u25c6\u25a0", list);
    }
}

