/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.control;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.formplugin.issuing.invalid.InvalidInvoiceControl;

public class BatchInvoiceControl {
    private static final Log LOGGER = LogFactory.getLog(BatchInvoiceControl.class);
    private static final Set<String> invoiceStatusSet = new ImmutableSet.Builder().add((Object)IssueStatusEnum.none.getCode()).add((Object)IssueStatusEnum.underway.getCode()).add((Object)IssueStatusEnum.failed.getCode()).add((Object)IssueStatusEnum.submit.getCode()).build();

    public static Set<String> getInvoiceStatusSet() {
        return invoiceStatusSet;
    }

    public static void doBatchInvoice(Object jqbh, Object termerialNo, DynamicObject[] vatInvoiceList) {
        long start = System.currentTimeMillis();
        LOGGER.info("\u5f00\u59cb\u5904\u7406\u53d1\u7968\u6570\u636e" + start);
        if (StringUtils.isNotBlank((Object)jqbh)) {
            String equipmentType = EquipmentHelper.getEquipmentTypeByNo((String)((String)jqbh));
            for (DynamicObject vatInvoiceDynamicObject : vatInvoiceList) {
                vatInvoiceDynamicObject.set("jqbh", jqbh);
                if (!StringUtils.isNotBlank((CharSequence)equipmentType)) continue;
                if (!"8".equals(equipmentType)) {
                    vatInvoiceDynamicObject.set("terminalno", (Object)"");
                }
                vatInvoiceDynamicObject.set("issuesource", (Object)equipmentType);
            }
        }
        LOGGER.info("\u7ed3\u675f\u5904\u7406\u53d1\u7968\u6570\u636e\uff0c\u8017\u65f6:" + (System.currentTimeMillis() - start));
        IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])vatInvoiceList);
    }

    public static void checkBatchData(DynamicObject dObject) {
        String issueStatus = dObject.getString("issuestatus");
        String billNo = dObject.getString("billno");
        if (!invoiceStatusSet.contains(issueStatus)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s],\u5f00\u7968\u72b6\u6001\u662f[%2$s]\uff0c\u65e0\u6cd5\u8fdb\u884c\u5f00\u5177", (String)"BatchInvoiceControl_0", (String)"imc-sim-service", (Object[])new Object[0]), billNo, IssueStatusEnum.getName((String)issueStatus)));
        }
        if (BatchInvoiceControl.checkAsyncInvoiceIssuing(dObject)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u6d41\u6c34\u53f7[%2$s]\u6b63\u5728\u5f02\u6b65\u5f00\u7968\u4e2d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"BatchInvoiceControl_1", (String)"imc-sim-service", (Object[])new Object[0]), billNo, dObject.getString("orderno")));
        }
    }

    public static String checkSelectData(DynamicObject[] dynamicObjects, boolean checkBatch) {
        HashSet<String> invoiceTypeSet = new HashSet<String>(8);
        for (DynamicObject dynamicObject : dynamicObjects) {
            invoiceTypeSet.add(dynamicObject.getString("invoicetype"));
            if (checkBatch) {
                BatchInvoiceControl.checkBatchData(dynamicObject);
                continue;
            }
            InvalidInvoiceControl.checkInvalidData(dynamicObject);
        }
        if (invoiceTypeSet.contains(InvoiceType.ALL_E_NORMAL.getTypeCode()) || invoiceTypeSet.contains(InvoiceType.ALL_E_SPECIAL.getTypeCode()) || invoiceTypeSet.size() == 1) {
            return (String)invoiceTypeSet.iterator().next();
        }
        return "";
    }

    public static void doBatchVehicleInvoice(String jqbh, String account, DynamicObject[] vehicleInvoices) {
        for (DynamicObject vehicle : vehicleInvoices) {
            vehicle.set("jqbh", (Object)jqbh);
            vehicle.set("account", (Object)account);
            vehicle.set("issuestatus", (Object)IssueStatusEnum.submit.getCode());
            vehicle.set("result", (Object)"");
            vehicle.set("issuesource", (Object)"");
        }
        ImcSaveServiceHelper.update((DynamicObject[])vehicleInvoices);
        IssueInvoiceMqHelper.submitVehicleInvoice2MQ((DynamicObject[])vehicleInvoices);
    }

    public static boolean checkAsyncInvoiceIssuing(DynamicObject invoice) {
        if (!IssueStatusEnum.underway.getCode().equals(invoice.getString("issuestatus")) && !IssueStatusEnum.submit.getCode().equals(invoice.getString("issuestatus"))) {
            return false;
        }
        if (InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype")) || EquipmentType.isLyServer((String)invoice.getString("issuesource")) || "4".equals(invoice.getString("issuesource"))) {
            return QueryServiceHelper.exists((String)"sim_async_issue_invoice", (QFilter[])new QFilter("orderno", "=", (Object)invoice.getString("orderno")).toArray());
        }
        return false;
    }
}

