/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.match;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.dto.minusbill.MatchInvoiceDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillMatchConfig;
import kd.imc.sim.common.dto.minusbill.QueryInvoiceDTO;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractMinusBillMatchHelper {
    protected int pageSize = 100;
    protected int nameSize = 20;
    protected boolean detailLog = true;
    protected boolean isMatchSpbm = false;
    protected boolean isOldMatch = false;
    protected MinusBillMatchConfig config;
    protected MinusBillDTO minusBillDTO;
    protected Map<String, Boolean> originalInvoiceMap;

    protected void setParam(MinusBillDTO billDTO) {
        this.minusBillDTO = billDTO;
        this.originalInvoiceMap = new HashMap<String, Boolean>(10);
        this.config = this.minusBillDTO.getConfig();
        String randomEq = ImcConfigUtil.getValue((String)"sim_minusbill", (String)"param");
        if (!StringUtils.isEmpty((CharSequence)randomEq)) {
            try {
                JSONObject obj = JSONObject.parseObject((String)randomEq);
                this.pageSize = BigDecimalUtil.transDecimal((Object)obj.getString("pageSize")).intValue();
                this.detailLog = "1".equals(obj.getString("detailLog"));
                this.isOldMatch = "1".equals(obj.getString("oldMatch"));
                if (this.isOldMatch) {
                    this.isMatchSpbm = "1".equals(obj.getString("matchspbm"));
                    this.nameSize = BigDecimalUtil.transDecimal((Object)obj.getString("nameSize")).intValue();
                    if (this.nameSize < 1) {
                        this.nameSize = 20;
                    }
                }
                if (this.pageSize < 1) {
                    this.pageSize = this.isOldMatch ? 10000 : 100;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void check(MinusBillDTO minusBillDTO) {
        if (StringUtils.isEmpty((CharSequence)minusBillDTO.getSalerTaxNo())) {
            throw new MsgException("4001", ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"MinusBillMatchHelper_2", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)minusBillDTO.getBuyerTaxNo()) && StringUtils.isEmpty((CharSequence)minusBillDTO.getBuyerName())) {
            throw new MsgException("4003", ResManager.loadKDString((String)"\u8d2d\u65b9\u7a0e\u53f7\u4e0e\u8d2d\u65b9\u540d\u79f0\u4e0d\u80fd\u5168\u4e3a\u7a7a", (String)"MinusBillMatchHelper_4", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (minusBillDTO.getItems() == null || minusBillDTO.getItems().isEmpty()) {
            throw new MsgException("4004", ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u4e0d\u80fd\u4e3a\u7a7a", (String)"MinusBillMatchHelper_5", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (this.config == null) {
            throw new MsgException("4010", ResManager.loadKDString((String)"\u89c4\u5219\u914d\u7f6e\u4e3a\u7a7a", (String)"MinusBillMatchHelper_0", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }

    protected String[] getBlueInvoiceType(MinusBillDTO minusBillDTO, MinusBillMatchConfig config) {
        if (InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode().equals(minusBillDTO.getInvoiceType())) {
            return new String[]{InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode()};
        }
        if (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(minusBillDTO.getInvoiceType())) {
            return new String[]{InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode()};
        }
        if (InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode().equals(minusBillDTO.getInvoiceType())) {
            return new String[]{InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode()};
        }
        if (InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(minusBillDTO.getInvoiceType())) {
            return new String[]{InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode(), InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode()};
        }
        if (InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(minusBillDTO.getInvoiceType())) {
            if (config.getMatchSkp().booleanValue()) {
                return new String[]{InvoiceType.ALL_E_SPECIAL.getTypeCode(), InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode(), InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode()};
            }
            return new String[]{InvoiceType.ALL_E_SPECIAL.getTypeCode()};
        }
        if (InvoiceType.ALL_E_NORMAL.getTypeCode().equals(minusBillDTO.getInvoiceType())) {
            if (config.getMatchSkp().booleanValue()) {
                return new String[]{InvoiceType.ALL_E_NORMAL.getTypeCode(), InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode()};
            }
            return new String[]{InvoiceType.ALL_E_NORMAL.getTypeCode()};
        }
        return new String[]{minusBillDTO.getInvoiceType()};
    }

    protected Pair<Date, Date> getInvoceDate(Date invoiceDate) {
        int start = Math.abs(this.config.getStart());
        int end = Math.abs(this.config.getEnd());
        if ("month".equals(this.config.getTimeType())) {
            Date firstDate = DateUtils.trunc((Date)DateUtils.getFirstDateOfMonth((Date)invoiceDate));
            Date startDate = DateUtils.addMonth((Date)firstDate, (int)(1 - start));
            Date endDate = DateUtils.addMonth((Date)firstDate, (int)(1 - end));
            return Pair.of((Object)endDate, (Object)startDate);
        }
        Date startDate = DateUtils.trunc((Date)DateUtils.addDay((Date)invoiceDate, (int)(1 - start)));
        Date endDate = DateUtils.trunc((Date)DateUtils.addDay((Date)invoiceDate, (int)(1 - end)));
        return Pair.of((Object)endDate, (Object)startDate);
    }

    protected String getOrderBy() {
        switch (this.config.getBlueOrder()) {
            case "timefar": {
                return "issuetime ";
            }
            case "timenear": {
                return "issuetime desc ";
            }
            case "amountsmall": {
                return "items.amount";
            }
            case "amountbig": {
                return "items.amount desc";
            }
        }
        return "";
    }

    protected Pair<BigDecimal, BigDecimal> getUnitPriceAffect(BigDecimal unitPrice) {
        if (this.config.getUnitPriceAffect() == null) {
            return null;
        }
        if ("none".equals(this.config.getUnitPriceAffectType())) {
            return null;
        }
        if ("percent".equals(this.config.getUnitPriceAffectType())) {
            BigDecimal hundred = new BigDecimal("100");
            BigDecimal maxRate = this.config.getUnitPriceAffect().abs().add(hundred).divide(hundred, 100, 4);
            BigDecimal minRate = hundred.subtract(this.config.getUnitPriceAffect().abs()).divide(hundred, 100, 4);
            return Pair.of((Object)unitPrice.multiply(minRate), (Object)unitPrice.multiply(maxRate));
        }
        return Pair.of((Object)unitPrice.subtract(this.config.getUnitPriceAffect().abs()), (Object)unitPrice.add(this.config.getUnitPriceAffect().abs()));
    }

    protected DataSet queryInvoice(ORM orm, int page, String order, QFilter filter) {
        int from = (page - 1) * this.pageSize;
        String orderBy = StringUtils.isEmpty((CharSequence)order) ? "items.id" : order + ",items.id";
        return orm.queryDataSet("MinusBill.sim_vatinvoice", "sim_vatinvoice", String.join((CharSequence)",", "id", "orderno", "invoicecode", "invoiceno", "issuetime", "invoiceamount", "invoicetype") + ",items.id as itemid,items.seq as itemseq,items.goodscode as goodscode,items.goodsname as goodsname,items.rowtype as rowtype,items.unitprice as unitprice,items.taxunitprice as taxunitprice,items.redprice as redprice,items.itemremainrednum as itemremainrednum,items.num as num,items.itemremainredamount as itemremainredamount,items.amount as amount,items.remaindiscountamount as remaindiscountamount,items.itemremainredtax as itemremainredtax,items.taxrate as taxrate,items.specification as specification,items.spbm as spbm,items.unit as unit", filter.toArray(), orderBy, from, this.pageSize);
    }

    protected QueryInvoiceDTO createQueryInvoiceDTO(DynamicObject obj, boolean salesDiscount) {
        String invoiceCode = obj.getString("invoicecode");
        String invoiceNo = obj.getString("invoiceno");
        Boolean startZero = this.originalInvoiceMap.get(invoiceCode + "\u25cf\u25c6\u25a0" + invoiceNo);
        if (startZero == null) {
            startZero = RedConfirmBillHelper.checkOriginalInvoiceStartZero(invoiceCode, invoiceNo);
            this.originalInvoiceMap.put(invoiceCode + "\u25cf\u25c6\u25a0" + invoiceNo, startZero);
        }
        QueryInvoiceDTO invoiceDto = new QueryInvoiceDTO();
        invoiceDto.setInvoiceid(Long.valueOf(obj.getLong("id")));
        invoiceDto.setOrderno(obj.getString("orderno"));
        invoiceDto.setInvoicecode(invoiceCode);
        invoiceDto.setInvoiceno(invoiceNo);
        invoiceDto.setIssueTime(obj.getDate("issuetime"));
        invoiceDto.setInvoiceAmount(obj.getBigDecimal("invoiceamount"));
        invoiceDto.setItemid(Long.valueOf(obj.getLong("itemid")));
        invoiceDto.setItemseq(Long.valueOf(startZero != false ? obj.getLong("itemseq") + 1L : obj.getLong("itemseq")));
        invoiceDto.setGoodscode(obj.getString("goodscode"));
        invoiceDto.setGoodsname(obj.getString("goodsname"));
        invoiceDto.setTaxrate(obj.getString("taxrate"));
        invoiceDto.setSpecification(obj.getString("specification"));
        invoiceDto.setUnit(obj.getString("unit"));
        invoiceDto.setSpbm(obj.getString("spbm"));
        invoiceDto.setItemCanRedAmount(obj.getBigDecimal("itemremainredamount"));
        invoiceDto.setItemCanRedTax(obj.getBigDecimal("itemremainredtax"));
        if (MathUtils.isNullOrZero((BigDecimal)obj.getBigDecimal("itemremainrednum")) && !MathUtils.isNullOrZero((BigDecimal)obj.getBigDecimal("unitprice")) && obj.getBigDecimal("itemremainredamount").compareTo(obj.getBigDecimal("amount")) == 0) {
            invoiceDto.setItemCanRedNum(obj.getBigDecimal("num"));
        } else {
            invoiceDto.setItemCanRedNum(obj.getBigDecimal("itemremainrednum"));
        }
        if (!MathUtils.isNullOrZero((BigDecimal)invoiceDto.getItemCanRedNum())) {
            BigDecimal canRedPrice = obj.getBigDecimal("redprice");
            if (!MathUtils.isNullOrZero((BigDecimal)canRedPrice)) {
                invoiceDto.setUnitprice(canRedPrice);
            } else if ("2".equals(obj.getString("rowtype"))) {
                invoiceDto.setUnitprice(PriceHelper.calcPriceOrNum((BigDecimal)invoiceDto.getItemCanRedAmount(), (BigDecimal)invoiceDto.getItemCanRedNum(), (boolean)true));
            } else if (invoiceDto.getItemCanRedAmount().setScale(2, 4).compareTo(obj.getBigDecimal("amount").setScale(2, 4)) == 0) {
                invoiceDto.setUnitprice(obj.getBigDecimal("unitprice"));
            } else {
                BigDecimal calcAmount = invoiceDto.getItemCanRedNum().multiply(obj.getBigDecimal("unitprice"));
                if (BigDecimalUtil.compare((BigDecimal)calcAmount, (BigDecimal)invoiceDto.getItemCanRedAmount(), (BigDecimal)InvoiceConstant.DIFF_01)) {
                    invoiceDto.setUnitprice(PriceHelper.calcPriceOrNum((BigDecimal)invoiceDto.getItemCanRedAmount(), (BigDecimal)invoiceDto.getItemCanRedNum(), (boolean)true));
                }
            }
            invoiceDto.setTaxunitprice(PriceHelper.calcPriceOrNum((BigDecimal)invoiceDto.getItemCanRedAmount().add(invoiceDto.getItemCanRedTax()), (BigDecimal)invoiceDto.getItemCanRedNum(), (boolean)true));
        }
        invoiceDto.setItemCanRedAmountOrNum(obj.getBigDecimal("itemremainredamount"));
        if (salesDiscount) {
            if (!MathUtils.isNullOrZero((BigDecimal)obj.getBigDecimal("remaindiscountamount")) && obj.getBigDecimal("remaindiscountamount").compareTo(obj.getBigDecimal("itemremainredamount")) != 0) {
                invoiceDto.setItemCanRedAmountOrNum(obj.getBigDecimal("remaindiscountamount"));
                invoiceDto.setItemCanRedTax(TaxCalcUtil.calTax((BigDecimal)obj.getBigDecimal("remaindiscountamount"), (BigDecimal)BigDecimal.ZERO, (String)obj.getString("taxrate"), (boolean)false));
            }
            invoiceDto.setItemCanRedNum(BigDecimal.ZERO);
            invoiceDto.setUnitprice(BigDecimal.ZERO);
            invoiceDto.setTaxunitprice(BigDecimal.ZERO);
        }
        if (!this.config.getAmountStandard().booleanValue()) {
            invoiceDto.setItemCanRedAmountOrNum(invoiceDto.getItemCanRedNum());
        }
        invoiceDto.setRemainMatchAmountOrNum(invoiceDto.getItemCanRedAmountOrNum());
        return invoiceDto;
    }

    protected BigDecimal recursionAmtsCut(BigDecimal amounts, BigDecimal price, int scale, int maxPointLength) {
        if (maxPointLength <= scale) {
            return amounts.divide(price, maxPointLength, 4).stripTrailingZeros();
        }
        BigDecimal amts = amounts.divide(price, scale, 4);
        if (amts.compareTo(BigDecimal.ZERO) == 0) {
            return amounts.divide(price, maxPointLength, 4).stripTrailingZeros();
        }
        if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)amts, (BigDecimal)price), (BigDecimal)amounts, (BigDecimal)InvoiceConstant.DIFF_01)) {
            return this.recursionAmtsCut(amounts, price, scale + 1, maxPointLength);
        }
        return amts;
    }

    protected MatchInvoiceDTO createMatchInvoiceDTO(QueryInvoiceDTO invoiceDto, BigDecimal matchAmountOrNum) {
        MatchInvoiceDTO matchdto = new MatchInvoiceDTO();
        matchdto.setInvoiceid(invoiceDto.getInvoiceid());
        matchdto.setInvoicecode(invoiceDto.getInvoicecode());
        matchdto.setInvoiceno(invoiceDto.getInvoiceno());
        matchdto.setItemid(invoiceDto.getItemid());
        matchdto.setItemseq(invoiceDto.getItemseq());
        matchdto.setOrderno(invoiceDto.getOrderno());
        matchdto.setItemUnitprice(invoiceDto.getUnitprice());
        matchdto.setItemTaxUnitprice(invoiceDto.getTaxunitprice());
        matchdto.setGoodsName(invoiceDto.getGoodsname());
        matchdto.setSpecification(invoiceDto.getSpecification());
        matchdto.setUnit(invoiceDto.getUnit());
        matchdto.setSpbm(invoiceDto.getSpbm());
        if (this.config.getAmountStandard().booleanValue()) {
            matchdto.setItemAmount(matchAmountOrNum);
        } else {
            if (matchAmountOrNum.compareTo(invoiceDto.getItemCanRedNum()) == 0) {
                matchdto.setItemAmount(invoiceDto.getItemCanRedAmount());
            } else {
                matchdto.setItemAmount(matchAmountOrNum.multiply(invoiceDto.getUnitprice()).setScale(2, 4));
            }
            matchdto.setItemNum(matchAmountOrNum);
        }
        BigDecimal calcTax = matchdto.getItemAmount().multiply(BigDecimalUtil.transDecimal((Object)invoiceDto.getTaxrate())).setScale(6, 4);
        matchdto.setItemTax(calcTax.setScale(2, 4));
        if (this.config.getAmountStandard().booleanValue()) {
            this.setItemTaxAndNumByAmountStandard(matchdto, invoiceDto, calcTax);
            if (!MathUtils.isNullOrZero((BigDecimal)matchdto.getItemNum())) {
                BigDecimal unitPrice = matchdto.getItemUnitprice();
                BigDecimal amount = matchdto.getItemAmount();
                if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)matchdto.getItemNum(), (BigDecimal)unitPrice), (BigDecimal)amount, (BigDecimal)InvoiceConstant.DIFF_01)) {
                    return null;
                }
            }
        } else if (matchAmountOrNum.compareTo(invoiceDto.getItemCanRedNum()) == 0) {
            matchdto.setItemTax(invoiceDto.getItemCanRedTax());
        }
        if (matchdto.getItemTax().compareTo(BigDecimal.ZERO) < 0) {
            matchdto.setItemTax(BigDecimal.ZERO);
        }
        return matchdto;
    }

    private void setItemTaxAndNumByAmountStandard(MatchInvoiceDTO matchdto, QueryInvoiceDTO invoiceDto, BigDecimal calcTax) {
        if (!MathUtils.isNullOrZero((BigDecimal)matchdto.getItemUnitprice())) {
            if (matchdto.getItemAmount().compareTo(invoiceDto.getItemCanRedAmountOrNum()) == 0) {
                matchdto.setItemNum(invoiceDto.getItemCanRedNum());
                if (calcTax.subtract(invoiceDto.getItemCanRedTax()).setScale(2, 4).abs().compareTo(InvoiceConstant.DIFFF_06) <= 0) {
                    matchdto.setItemTax(invoiceDto.getItemCanRedTax());
                }
            } else {
                BigDecimal num = this.recursionAmtsCut(matchdto.getItemAmount(), matchdto.getItemUnitprice(), this.config.getQuantityLimit(), UnitPriceHelper.getMaxPointLength((BigDecimal)matchdto.getItemAmount(), (BigDecimal)matchdto.getItemUnitprice()));
                if (num.abs().compareTo(invoiceDto.getItemCanRedNum()) > 0) {
                    matchdto.setItemNum(invoiceDto.getItemCanRedNum());
                } else {
                    matchdto.setItemNum(num);
                }
            }
        }
    }
}

