/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.match;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.match.MatchInvoiceRedHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import org.apache.commons.collections4.CollectionUtils;

public class MatchBillRedHelper {
    public Set<DynamicObject> matchBillRed(DynamicObject matchBill, List<DynamicObject> redInvoiceLit, String currentAccount, OperationResult operationResult) {
        HashSet<DynamicObject> redConfirms = new HashSet<DynamicObject>(20);
        String matchTarget = matchBill.getString("matchtarget");
        if ("1".equals(matchTarget)) {
            this.matchRedConfirmRed(matchBill);
        } else if ("2".equals(matchTarget)) {
            this.manuallyRedconfirmRed(matchBill);
        } else if ("3".equals(matchTarget)) {
            this.manuallyInvoiceRed(matchBill, redConfirms, currentAccount);
        } else {
            new MatchInvoiceRedHelper().matchInvoiceRed(matchBill, redConfirms, redInvoiceLit, operationResult);
        }
        ImcSaveServiceHelper.save((DynamicObject)matchBill);
        return redConfirms;
    }

    private void matchRedConfirmRed(DynamicObject matchBill) {
        ArrayList<BillRelationDTO> relationList = new ArrayList<BillRelationDTO>(4);
        DynamicObjectCollection matchItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        HashSet<String> redConfirmIdAndItemId = new HashSet<String>(matchItems.size());
        HashSet<Object> redConfirmId = new HashSet<Object>(matchItems.size());
        for (DynamicObject matchItem : matchItems) {
            long matchItemId = matchItem.getLong("id");
            DynamicObjectCollection confirmItems = matchItem.getDynamicObjectCollection("confirmsubentryentity");
            for (DynamicObject confirmItem : confirmItems) {
                long confirmId = confirmItem.getLong("redconfirmpk");
                long confirmItemId = confirmItem.getLong("redconfirmitempk");
                if (redConfirmIdAndItemId.contains(matchItemId + "\u25cf\u25c6\u25a0" + confirmId + "\u25cf\u25c6\u25a0" + confirmItemId)) continue;
                BillRelationDTO relation = new BillRelationDTO(Long.valueOf(matchBill.getLong("id")), matchBill.getString("billno"), Long.valueOf(matchItemId), Long.valueOf(confirmId), confirmItem.getString("confirminfocode"), Long.valueOf(confirmItemId), confirmItem.getBigDecimal("confirmoriitemamount"), confirmItem.getBigDecimal("confirmoriitemtax"), confirmItem.getBigDecimal("confirmoriitemnum"), confirmItem.getBigDecimal("confirmoriitemunitprice"), "sim_red_confirm_bill");
                relation.setsSubDetailId(Long.valueOf(confirmItem.getLong("id")));
                relationList.add(relation);
                redConfirmIdAndItemId.add(matchItemId + "\u25cf\u25c6\u25a0" + confirmId + "\u25cf\u25c6\u25a0" + confirmItemId);
                redConfirmId.add(confirmId);
            }
        }
        this.setMatchBillAllMatch(matchBill, redConfirmId.size());
        this.setRedConfirmSource(matchBill, redConfirmId);
        DeleteServiceHelper.delete((String)"sim_match_inv_relation", (QFilter[])new QFilter("sbillid", "=", (Object)matchBill.getLong("id")).toArray());
        this.saveRelations(relationList, "1");
    }

    private void setRedConfirmSource(DynamicObject matchBill, Set<Object> redConfirmId) {
        if (CollectionUtils.isEmpty(redConfirmId)) {
            return;
        }
        DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "id", "source", "systemsource", "billno"), (QFilter[])new QFilter("id", "in", redConfirmId).toArray());
        if (redConfirms == null || redConfirms.length == 0) {
            return;
        }
        for (DynamicObject redConfirm : redConfirms) {
            redConfirm.set("source", (Object)"10");
            if (StringUtils.isNotBlank((CharSequence)matchBill.getString("systemsource"))) {
                redConfirm.set("systemsource", (Object)matchBill.getString("systemsource"));
            }
            redConfirm.set("billno", matchBill.get("billno"));
        }
        ImcSaveServiceHelper.update((DynamicObject[])redConfirms);
    }

    private void manuallyInvoiceRed(DynamicObject matchBill, Set<DynamicObject> redConfirms, String currentAccount) {
        ArrayList<BillRelationDTO> relationList = new ArrayList<BillRelationDTO>(4);
        String redReason = matchBill.getString("redreason");
        redReason = StringUtils.isNotBlank((CharSequence)redReason) ? RedConfirmBillRedReasonEnum.getCodeByBillCode((String)redReason) : RedConfirmBillRedReasonEnum.INVOICE_ERR.getCode();
        DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        HashSet<String> invoiceCodeNo = new HashSet<String>(items.size());
        for (DynamicObject item : items) {
            DynamicObjectCollection oriItems = item.getDynamicObjectCollection("subentryentity");
            for (DynamicObject oriItem : oriItems) {
                OperationResult operationResult;
                String invoicCode = oriItem.getString("oriinvoicecode");
                String invoiceNo = oriItem.getString("oriinvoiceno");
                if (invoiceCodeNo.contains(invoicCode + "\u25cf\u25c6\u25a0" + invoiceNo)) {
                    oriItem.set("pushstatus", (Object)"1");
                    continue;
                }
                if ("1".equals(oriItem.getString("pushstatus"))) {
                    invoiceCodeNo.add(invoicCode + "\u25cf\u25c6\u25a0" + invoiceNo);
                    continue;
                }
                oriItem.set("pushstatus", (Object)"1");
                DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoicCode, (String)invoiceNo).toArray());
                DynamicObject redConfirmObj = RedConfirmBillHelper.formatRedConfirm(matchBill.getString("billno"), UUID.randomUUID(), redReason, blueInvoice, currentAccount);
                redConfirmObj.set("source", (Object)"10");
                if (StringUtils.isNotBlank((CharSequence)matchBill.getString("systemsource"))) {
                    redConfirmObj.set("systemsource", (Object)matchBill.getString("systemsource"));
                }
                if (!(operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_confirm_bill", (DynamicObject[])new DynamicObject[]{redConfirmObj}, null)).isSuccess()) {
                    throw new MsgException(ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), OperationConstant.getErrorMsg((OperationResult)operationResult));
                }
                invoiceCodeNo.add(invoicCode + "\u25cf\u25c6\u25a0" + invoiceNo);
                BillRelationDTO relation = new BillRelationDTO(Long.valueOf(matchBill.getLong("id")), matchBill.getString("billno"), Long.valueOf(item.getLong("id")), Long.valueOf(redConfirmObj.getLong("id")), redConfirmObj.getString("billno"), Long.valueOf(0L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "sim_red_confirm_bill");
                relationList.add(relation);
                redConfirms.add(redConfirmObj);
            }
        }
        this.setMatchBillAllMatch(matchBill, invoiceCodeNo.size());
        this.saveRelations(relationList, "3");
    }

    private void manuallyRedconfirmRed(DynamicObject matchBill) {
        ArrayList<BillRelationDTO> relationList = new ArrayList<BillRelationDTO>(4);
        DynamicObjectCollection matchItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        HashSet<Object> redConfirmIdSet = new HashSet<Object>(matchItems.size());
        for (DynamicObject matchItem : matchItems) {
            DynamicObjectCollection confirmItems = matchItem.getDynamicObjectCollection("confirmsubentryentity");
            for (DynamicObject confirmItem : confirmItems) {
                if (redConfirmIdSet.contains(confirmItem.get("redconfirmpk"))) continue;
                BillRelationDTO relation = new BillRelationDTO(Long.valueOf(matchBill.getLong("id")), matchBill.getString("billno"), Long.valueOf(matchItem.getLong("id")), Long.valueOf(confirmItem.getLong("redconfirmpk")), confirmItem.getString("confirminfocode"), Long.valueOf(0L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, "sim_red_confirm_bill");
                relationList.add(relation);
                redConfirmIdSet.add(confirmItem.get("redconfirmpk"));
            }
        }
        this.setMatchBillAllMatch(matchBill, redConfirmIdSet.size());
        this.setRedConfirmSource(matchBill, redConfirmIdSet);
        DeleteServiceHelper.delete((String)"sim_match_inv_relation", (QFilter[])new QFilter("sbillid", "=", (Object)matchBill.getLong("id")).toArray());
        this.saveRelations(relationList, "2");
    }

    public void saveRelations(List<BillRelationDTO> relationList, String matchTarget) {
        if (CollectionUtils.isEmpty(relationList)) {
            return;
        }
        ArrayList<DynamicObject> relations = new ArrayList<DynamicObject>(relationList.size());
        for (BillRelationDTO relation : relationList) {
            DynamicObject relationObj = BusinessDataServiceHelper.newDynamicObject((String)"sim_match_inv_relation");
            DynamicObjectUtil.bean2DynamicObject((Object)relation, (DynamicObject)relationObj);
            relationObj.set("matchtarget", (Object)matchTarget);
            relations.add(relationObj);
        }
        ImcSaveServiceHelper.save(relations);
    }

    private void setMatchBillAllMatch(DynamicObject matchBill, int pushInvoiceNum) {
        matchBill.set("pushdownstatus", (Object)"2");
        matchBill.set("pushdowninvoicenum", (Object)pushInvoiceNum);
        matchBill.set("pushdownamount", matchBill.get("applyamount"));
        matchBill.set("pushdowntax", matchBill.get("applytax"));
    }

    protected void calcUnitPriceAndNum(DynamicObject oriItem, DynamicObject redInvoiceOrRedConfirmItem) {
        redInvoiceOrRedConfirmItem.set("unitprice", oriItem.get("oriitemunitprice"));
        redInvoiceOrRedConfirmItem.set("taxunitprice", oriItem.get("oriitemtaxunitprice"));
        BigDecimal num = oriItem.getBigDecimal("oriitemnum").negate();
        redInvoiceOrRedConfirmItem.set("num", (Object)num);
        if (!MathUtils.isNullOrZero((BigDecimal)num)) {
            BigDecimal unitPrice = redInvoiceOrRedConfirmItem.getBigDecimal("unitprice");
            BigDecimal amount = redInvoiceOrRedConfirmItem.getBigDecimal("amount");
            if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)num, (BigDecimal)unitPrice), (BigDecimal)amount, (BigDecimal)InvoiceConstant.DIFF_01)) {
                num = UnitPriceHelper.calcNum((BigDecimal)amount, (BigDecimal)unitPrice);
                redInvoiceOrRedConfirmItem.set("num", (Object)num);
            }
            BigDecimal taxUnitPrice = redInvoiceOrRedConfirmItem.getBigDecimal("taxunitprice");
            BigDecimal taxAmount = redInvoiceOrRedConfirmItem.getBigDecimal("taxamount");
            if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)num, (BigDecimal)taxUnitPrice), (BigDecimal)taxAmount, (BigDecimal)InvoiceConstant.DIFF_01)) {
                redInvoiceOrRedConfirmItem.set("taxunitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)num, (boolean)true));
            }
        }
    }
}

