/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.match;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.table.RedReasonEnum;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.dto.minusbill.MatchInvoiceDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillItemDTO;
import kd.imc.sim.common.dto.minusbill.QueryInvoiceDTO;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.match.AbstractMinusBillMatchHelper;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MinusBillMatchHelperOld
extends AbstractMinusBillMatchHelper {
    private static final Log logger = LogFactory.getLog(MinusBillMatchHelper.class);
    private String MATCH_TYPE_SPBM = "SPBM";
    private String MATCH_TYPE_GOODSCODE = "GOODESCODE";

    public void match(MinusBillDTO billDTO) {
        this.setParam(billDTO);
        long start = System.currentTimeMillis();
        if (this.isMatchSpbm) {
            this.matchByType(this.MATCH_TYPE_SPBM);
        }
        this.matchByType(this.MATCH_TYPE_GOODSCODE);
        if (this.detailLog) {
            logger.info("\u5339\u914d\u5355\u636e\u8bf7\u6c42\u5339\u914d\u4e4b\u540e:{}", (Object)SerializationUtils.toJsonString((Object)this.minusBillDTO));
        }
        logger.info("\u5339\u914d\u5355\u636e:{}\u8017\u65f6:", (Object)this.minusBillDTO.getBillNo(), (Object)(System.currentTimeMillis() - start));
    }

    private void matchByType(String matchType) {
        List items = this.minusBillDTO.getItems();
        LinkedHashMap<String, List<Integer>> typeMap = new LinkedHashMap<String, List<Integer>>(items.size());
        LinkedHashMap<String, Set> typeNameMap = new LinkedHashMap<String, Set>(items.size());
        for (int index = 0; index < items.size(); ++index) {
            MinusBillItemDTO item = (MinusBillItemDTO)items.get(index);
            if ("1".equals(item.getMatchStatus()) || this.MATCH_TYPE_GOODSCODE.equals(matchType) && StringUtils.isEmpty((CharSequence)item.getGoodscode()) || this.MATCH_TYPE_SPBM.equals(matchType) && StringUtils.isEmpty((CharSequence)item.getSpbm())) continue;
            String name = item.getGoodsname();
            String code = item.getGoodscode();
            if (this.MATCH_TYPE_SPBM.equals(matchType)) {
                name = item.getSpbm();
                code = "";
            }
            if (StringUtils.isEmpty((CharSequence)name)) continue;
            List idxList = typeMap.computeIfAbsent(code + name, k -> new ArrayList(16));
            idxList.add(index);
            Set set = typeNameMap.computeIfAbsent(code, k -> new HashSet(16));
            set.add(name);
        }
        QFilter invoicefilter = this.getInvoiceQFilterList(this.minusBillDTO);
        String orderBy = this.getOrderBy();
        logger.info("\u5339\u914d\u5355\u636e:{}\u8868\u5934\u8fc7\u6ee4\u6761\u4ef6{}\u6392\u5e8f{}", new Object[]{this.minusBillDTO.getBillNo(), invoicefilter.toString(), orderBy});
        for (Map.Entry entry : typeNameMap.entrySet()) {
            QFilter itemfilter = this.getItemQFilter(matchType, (String)entry.getKey(), null).and(invoicefilter);
            Set nameSet = (Set)entry.getValue();
            int group = (nameSet.size() + this.nameSize - 1) / this.nameSize;
            List nameFilterList = Stream.iterate(0, i -> i + 1).limit(group).map(i -> nameSet.stream().skip(i * this.nameSize).limit(this.nameSize).collect(Collectors.toList())).collect(Collectors.toList());
            if (nameFilterList.isEmpty()) continue;
            block2: for (List<String> namelist : nameFilterList) {
                int pageNo = 0;
                List<String> remainNames = namelist;
                do {
                    logger.info("\u5339\u914d\u5355\u636e:\u5f00\u59cb\u5339\u914d{},{}", (Object)(++pageNo), (Object)remainNames);
                    QFilter querFilter = this.MATCH_TYPE_SPBM.equals(matchType) ? new QFilter("items.spbm", "in", (Object)remainNames).and(itemfilter) : new QFilter("items.goodsname", "in", (Object)remainNames).and(itemfilter);
                    List<QueryInvoiceDTO> dataList = this.queryData(pageNo, querFilter, orderBy);
                    if (dataList == null || dataList.isEmpty()) {
                        if (!this.detailLog) continue block2;
                        logger.info("\u5339\u914d\u5355\u636e:\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a{},{}", (Object)pageNo, (Object)remainNames);
                        continue block2;
                    }
                    this.match(dataList, (String)entry.getKey(), typeMap, matchType);
                    remainNames = this.getRemainMatchName(typeMap, (String)entry.getKey(), remainNames);
                    if (!this.detailLog) continue;
                    logger.info("\u5339\u914d\u5355\u636e:\u5269\u4f59\u672a\u5339\u914d{},{}", (Object)pageNo, remainNames);
                } while (remainNames != null && !remainNames.isEmpty());
            }
        }
    }

    private List<String> getRemainMatchName(Map<String, List<Integer>> idxMap, String goodsCode, List<String> nameList) {
        List items = this.minusBillDTO.getItems();
        ArrayList<String> remainNameList = new ArrayList<String>(this.nameSize);
        block0: for (String name : nameList) {
            List<Integer> idxList = idxMap.get(goodsCode + name);
            for (Integer idx : idxList) {
                MinusBillItemDTO itmeDto = (MinusBillItemDTO)items.get(idx);
                if ("1".equals(itmeDto.getMatchStatus())) continue;
                remainNameList.add(name);
                continue block0;
            }
        }
        return remainNameList;
    }

    private void match(List<QueryInvoiceDTO> dataList, String goodsCode, Map<String, List<Integer>> typeMap, String matchType) {
        List items = this.minusBillDTO.getItems();
        block0: for (QueryInvoiceDTO invoiceDto : dataList) {
            List<Integer> idxList;
            if (BigDecimal.ZERO.compareTo(invoiceDto.getRemainMatchAmountOrNum()) >= 0 || (idxList = this.MATCH_TYPE_SPBM.equals(matchType) ? typeMap.get(goodsCode + invoiceDto.getSpbm()) : typeMap.get(goodsCode + invoiceDto.getGoodsname())) == null) continue;
            for (Integer idx : idxList) {
                BigDecimal matchAmount;
                BigDecimal remainamount;
                boolean isMatchSuccess;
                boolean availPrice;
                MinusBillItemDTO item;
                if (BigDecimal.ZERO.compareTo(invoiceDto.getRemainMatchAmountOrNum()) >= 0) continue block0;
                if (this.minusBillDTO.getMatchInvoiceItems().contains(invoiceDto.getInvoiceid() + "\u25cf\u25c6\u25a0" + invoiceDto.getItemid()) || "1".equals((item = (MinusBillItemDTO)items.get(idx)).getMatchStatus())) continue;
                Pair<BigDecimal, BigDecimal> priceAffect = this.getUnitPriceAffect(item.getUnitprice());
                boolean bl = availPrice = priceAffect == null || MathUtils.isNullOrZero((BigDecimal)invoiceDto.getUnitprice()) && MathUtils.isNullOrZero((BigDecimal)item.getUnitprice()) || invoiceDto.getUnitprice().compareTo((BigDecimal)priceAffect.getLeft()) >= 0 && invoiceDto.getUnitprice().compareTo((BigDecimal)priceAffect.getRight()) <= 0;
                if (!availPrice) {
                    logger.info("\u5339\u914d\u5355\u636e:\u5355\u4ef7{}\u4e0d\u5408\u9002", (Object)item.getUnitprice());
                    continue;
                }
                if (!item.getTaxRate().equals(invoiceDto.getTaxrate()) || !(isMatchSuccess = this.MATCH_TYPE_SPBM.equals(matchType) ? item.getSpbm().equals(invoiceDto.getSpbm()) : item.getGoodsname().equals(invoiceDto.getGoodsname()))) continue;
                if (this.detailLog) {
                    logger.info("\u5339\u914d\u5355\u636e:\u7a0e\u7387:{}\u540d\u79f0:{}:", (Object)item.getTaxRate(), (Object)item.getGoodsname());
                }
                if (!MathUtils.isNullOrZero((BigDecimal)(remainamount = invoiceDto.getRemainMatchAmountOrNum())) && !MathUtils.isNullOrZero((BigDecimal)invoiceDto.getUnitprice()) && MathUtils.isNullOrZero((BigDecimal)invoiceDto.getItemCanRedNum())) continue;
                BigDecimal unMatchAmount = item.getAmount().abs().subtract(item.getMatchAmountOrNum());
                if (remainamount.compareTo(unMatchAmount) >= 0) {
                    remainamount = remainamount.subtract(unMatchAmount);
                    matchAmount = unMatchAmount;
                } else {
                    matchAmount = remainamount;
                    remainamount = BigDecimal.ZERO;
                }
                invoiceDto.setRemainMatchAmountOrNum(remainamount);
                MatchInvoiceDTO matchdto = this.createMatchInvoiceDTO(invoiceDto, matchAmount);
                if (matchdto == null) continue;
                item.setMatchAmountOrNum(item.getMatchAmountOrNum().add(matchAmount));
                if (item.getAmount().abs().compareTo(item.getMatchAmountOrNum()) == 0) {
                    item.setMatchStatus(MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
                }
                item.getInvoiceList().add(matchdto);
                this.minusBillDTO.getMatchInvoiceItems().add(matchdto.getInvoiceid() + "\u25cf\u25c6\u25a0" + matchdto.getItemid());
            }
        }
    }

    private List<QueryInvoiceDTO> queryData(int pageNo, QFilter itemfilter, String order) {
        ORM orm = ORM.create();
        try (DataSet ds = this.queryInvoice(orm, pageNo, order, itemfilter);){
            DynamicObjectCollection collection;
            if (this.detailLog) {
                logger.info("\u5339\u914d\u5355\u636e:\u67e5\u8be2\u6570\u636e\u6761\u4ef6{},{},{}", new Object[]{pageNo, order, itemfilter.toString()});
            }
            if ((collection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"sim_vatinvoice")) != null) {
                boolean salesDiscount = RedReasonEnum.SALES_DISCOUNTS.getTypeCode().equals(this.minusBillDTO.getRedreason());
                ArrayList<QueryInvoiceDTO> list = new ArrayList<QueryInvoiceDTO>(collection.size());
                for (DynamicObject obj : collection) {
                    QueryInvoiceDTO invoiceDto = this.createQueryInvoiceDTO(obj, salesDiscount);
                    list.add(invoiceDto);
                }
                ArrayList<QueryInvoiceDTO> arrayList = list;
                return arrayList;
            }
            List<QueryInvoiceDTO> list = null;
            return list;
        }
    }

    private QFilter getInvoiceQFilterList(MinusBillDTO minusBillDTO) {
        Pair<Date, Date> invoiceDates = this.getInvoceDate(new Date());
        QFilter qFilter = new QFilter("salertaxno", "=", (Object)minusBillDTO.getSalerTaxNo());
        if (StringUtils.isNotBlank((CharSequence)minusBillDTO.getBuyerTaxNo())) {
            qFilter.and("buyertaxno", "=", (Object)minusBillDTO.getBuyerTaxNo());
        } else {
            qFilter.and("buyername", "=", (Object)minusBillDTO.getBuyerName());
        }
        qFilter.and("issuetype", "=", (Object)IssueType.BLUE_INVOICE.getTypeCode()).and("invoicetype", "in", (Object)this.getBlueInvoiceType(minusBillDTO, this.config)).and("issuetime", ">=", invoiceDates.getLeft()).and("issuetime", "<", invoiceDates.getRight()).and("invoicestatus", "in", (Object)InvoiceStatus.NormalStatusArray).and("remainredamount", ">", (Object)BigDecimal.ZERO).and("occupystatus", "!=", (Object)"1").and("id", "not in", (Object)minusBillDTO.getMatchInvoiceIds());
        return qFilter;
    }

    private QFilter getItemQFilter(String matchType, String goodsCode, String taxRate) {
        QFilter qFilter = new QFilter("items.itemremainredamount", ">", (Object)BigDecimal.ZERO);
        if (this.MATCH_TYPE_GOODSCODE.equals(matchType)) {
            qFilter.and("items.goodscode", "=", (Object)goodsCode);
        }
        if (taxRate != null) {
            qFilter.and("items.taxrate", "=", (Object)taxRate);
        }
        return qFilter;
    }
}

