/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.match;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.MatchRedConfirmQueryDTO;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.dto.matchconfirm.CheckRedConfirmDTO;
import kd.imc.sim.common.dto.matchconfirm.MatchRedConfirmBillDTO;
import kd.imc.sim.common.dto.matchconfirm.MatchRedConfirmBillItemDTO;
import kd.imc.sim.common.dto.matchconfirm.MatchRedConfirmResponse;
import kd.imc.sim.common.dto.matchconfirm.MatchRedConfirmResultDTO;

public class RedConfirmMatchHelper {
    public static final String QUERY_RED_CONFIRM_FIELDS = "id,number,redreason,occupystatus,totalamount,invoiceamount,buyertaxno,totaltax,invoicetype,specialtype,originalinvoicecode,originalinvoiceno,originalinvoicetype,items.goodsname,items.simplegoodsname,items.specification,items.unit,items.num,items.unitprice,items.taxunitprice,items.amount,items.taxamount,items.taxrate,items.tax,items.goodscode,items.originseq,items.seq,items.zzstsgl";
    public static final String AND_STR = " AND ";
    public static final String REDCONFIRM_LOCK_KEY = "RedConfirmMatchHelperMatch";
    private static final Log LOGGER = LogFactory.getLog(RedConfirmMatchHelper.class);

    public MatchRedConfirmResponse matchRedConfirm(List<DynamicObject> matchBills) {
        JSONArray matchInfoLogs = new JSONArray();
        Date dateStart = new Date();
        MatchRedConfirmResponse response = new MatchRedConfirmResponse();
        response.setMatchSuccess(false);
        boolean logDetail = "1".equals(ImcConfigUtil.getValue((String)"logMatchRedConfirmDetail", (String)"logMatchRedConfirmDetail"));
        try {
            if (logDetail) {
                LOGGER.info("matchRedConfirmDetail:" + SerializationUtils.toJsonString(matchBills));
            }
            this.baseCheck(matchBills);
            List<MatchRedConfirmBillDTO> list = this.createMatchDtoList(matchBills);
            if (logDetail) {
                LOGGER.info("matchRedConfirmDTOList:" + SerializationUtils.toJsonString(list));
            }
            List<BillRelationDTO> relation = this.match(list, matchInfoLogs);
            if (logDetail) {
                LOGGER.info("matchRedConfirmMatchResult:" + SerializationUtils.toJsonString(list));
            }
            this.fillMatchBillFromMatchResult(matchBills, list);
            if (logDetail) {
                LOGGER.info("fillMatchBillFromMatchResult:" + SerializationUtils.toJsonString(matchBills));
            }
            response.setMatchSuccess(true);
            response.setRelations(relation);
            response.setMatchBills(matchBills);
        }
        catch (KDBizException e) {
            response.setErrorMsg(ErrorType.FAIL.getCode());
            response.setErrorMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response.setErrorMsg(ErrorType.FAIL.getCode());
            response.setErrorMsg(GBKUtils.cutGBKString((String)e.getMessage(), (int)100));
        }
        Date dateEnd = new Date();
        JSONObject timeJson = new JSONObject();
        timeJson.put("timeSpend", (Object)DateUtils.timeDifferenceSecond((Date)dateStart, (Date)dateEnd));
        matchInfoLogs.add((Object)timeJson);
        this.saveLogs(matchInfoLogs);
        return response;
    }

    private void baseCheck(List<DynamicObject> matchBills) {
        if (null == matchBills || matchBills.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u5339\u914d\u5355\u4fe1\u606f\u4e3a\u7a7a", (String)"RedConfirmMatchHelper_6", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }

    public MatchRedConfirmResponse matchRedConfirmBillFromOriginalBillOrMatchBill(DynamicObject originalBillOrMatchBill, DynamicObject matchRedConfirmConfig) {
        JSONArray matchInfoLogs = new JSONArray();
        Date dateStart = new Date();
        MatchRedConfirmBillDTO dto = this.createMatchRedConfirmBillDTO(originalBillOrMatchBill, matchRedConfirmConfig);
        dto.setBillFormId(originalBillOrMatchBill.getDynamicObjectType().getName());
        ArrayList<MatchRedConfirmBillDTO> list = new ArrayList<MatchRedConfirmBillDTO>();
        list.add(dto);
        this.prepareAndCheckDtos(list);
        List<BillRelationDTO> relation = this.match(list, matchInfoLogs);
        Date dateEnd = new Date();
        JSONObject timeJson = new JSONObject();
        matchInfoLogs.add((Object)timeJson);
        timeJson.put("timeSpend", (Object)DateUtils.timeDifferenceSecond((Date)dateStart, (Date)dateEnd));
        MatchRedConfirmResponse response = new MatchRedConfirmResponse();
        response.setRelations(relation);
        response.setDto(dto);
        return response;
    }

    private MatchRedConfirmBillDTO createMatchRedConfirmBillDTO(DynamicObject matchBillOrMergeBill, DynamicObject matchRedConfirmConfig) {
        MatchRedConfirmBillDTO dto = (MatchRedConfirmBillDTO)DynamicObjectUtil.dynamicObject2Bean(MatchRedConfirmBillDTO.class, (DynamicObject)matchBillOrMergeBill);
        if ("sim_original_bill".equals(matchBillOrMergeBill.getDataEntityType().getName())) {
            dto.setOrgId(Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)matchBillOrMergeBill.get("orgid"))));
            dto.setTotalAmount(matchBillOrMergeBill.getBigDecimal("totalamount"));
            dto.setInvoiceAmount(matchBillOrMergeBill.getBigDecimal("invoiceamount"));
            dto.setTotalTax(matchBillOrMergeBill.getBigDecimal("totaltax"));
        } else {
            dto.setOrgId(Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)matchBillOrMergeBill.get("org"))));
        }
        dto.setMatchConfig(matchRedConfirmConfig);
        return dto;
    }

    private List<MatchRedConfirmBillDTO> createMatchDtoList(List<DynamicObject> matchBills) {
        ArrayList<MatchRedConfirmBillDTO> list = new ArrayList<MatchRedConfirmBillDTO>(matchBills.size());
        for (DynamicObject matchBill : matchBills) {
            MatchRedConfirmBillDTO dto = (MatchRedConfirmBillDTO)DynamicObjectUtil.dynamicObject2Bean(MatchRedConfirmBillDTO.class, (DynamicObject)matchBill);
            dto.setOrgId(Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)matchBill.get("org"))));
            dto.setMatchConfig(matchBill.getDynamicObject("matchconfig"));
            list.add(dto);
        }
        return list;
    }

    private void fillMatchBillFromMatchResult(List<DynamicObject> matchBills, List<MatchRedConfirmBillDTO> list) {
        HashMap matchBillItemPkRedConfirmItemPkMap = new HashMap(matchBills.size());
        HashMap<Long, MatchRedConfirmBillItemDTO> matchDetailPkMap = new HashMap<Long, MatchRedConfirmBillItemDTO>();
        for (MatchRedConfirmBillDTO dto : list) {
            List items = dto.getItems();
            for (MatchRedConfirmBillItemDTO item : items) {
                Long itemPk = item.getMatchOrMergeItemId();
                List matchResult = item.getMatchResult();
                if (null != matchResult && matchResult.size() > 0) {
                    HashMap<Long, MatchRedConfirmResultDTO> map = new HashMap<Long, MatchRedConfirmResultDTO>(items.size());
                    matchBillItemPkRedConfirmItemPkMap.put(itemPk, map);
                    for (MatchRedConfirmResultDTO resultDto : matchResult) {
                        map.put(resultDto.getRedConfirmItemPk(), resultDto);
                    }
                }
                matchDetailPkMap.put(itemPk, item);
            }
        }
        Date matchDate = new Date();
        for (DynamicObject matchBill : matchBills) {
            DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
            matchBill.set("matchtime", (Object)matchDate);
            for (DynamicObject item : items) {
                MatchRedConfirmBillItemDTO itemDto;
                DynamicObjectCollection subEntryEntitys = item.getDynamicObjectCollection("confirmsubentryentity");
                long itemPk = item.getLong("id");
                Map relateDtoMap = (Map)matchBillItemPkRedConfirmItemPkMap.get(itemPk);
                if (null != relateDtoMap && relateDtoMap.size() > 0) {
                    for (DynamicObject subEntryEntity : subEntryEntitys) {
                        long redConfirmItemPk = subEntryEntity.getLong("redconfirmitempk");
                        relateDtoMap.remove(redConfirmItemPk);
                    }
                    if (relateDtoMap.size() > 0) {
                        for (Map.Entry entry : relateDtoMap.entrySet()) {
                            MatchRedConfirmResultDTO value = (MatchRedConfirmResultDTO)entry.getValue();
                            this.createRedConfirmItem(subEntryEntitys, value);
                        }
                    }
                }
                if (null == (itemDto = (MatchRedConfirmBillItemDTO)matchDetailPkMap.get(item.getLong("id")))) continue;
                item.set("itemmatchstatus", (Object)itemDto.getItemMatchStatus());
            }
            this.countMatchBillAmountAndStatus(matchBill);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<BillRelationDTO> match(List<MatchRedConfirmBillDTO> dtos, JSONArray matchInfoLogs) {
        String salerTaxNo = dtos.get(0).getSalerTaxNo();
        String lockKey = salerTaxNo + REDCONFIRM_LOCK_KEY;
        if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)lockKey))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:%s\u6709\u5176\u4ed6\u5339\u914d\u4efb\u52a1\u5728\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"RedConfirmMatchHelper_0", (String)"imc-sim-service", (Object[])new Object[0]), salerTaxNo));
        }
        Throwable throwable = null;
        try (DLock lock = DLock.create((String)lockKey);){
            ArrayList<BillRelationDTO> arrayList;
            if (!lock.tryLock(100L)) throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:%s\u6709\u5176\u4ed6\u5339\u914d\u4efb\u52a1\u5728\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"RedConfirmMatchHelper_0", (String)"imc-sim-service", (Object[])new Object[0]), salerTaxNo));
            try {
                CacheHelper.put((String)lockKey, (String)lockKey, (int)300);
                this.prepareAndCheckDtos(dtos);
                HashSet<Long> matchedMatchBillPks = new HashSet<Long>(dtos.size());
                HashMap<Long, DynamicObject> occupiedRedConfirmPkMap = new HashMap<Long, DynamicObject>();
                this.matchRedConfirmByRedConfirmBillNo(dtos, matchedMatchBillPks, occupiedRedConfirmPkMap);
                dtos.removeIf(current -> matchedMatchBillPks.contains(current.getMergebillId()));
                MatchRedConfirmQueryDTO queryDTO = this.prepareQueryRedConfirms(dtos);
                Map prepareRedConfirmMap = queryDTO.getPrepareRedConfirmMap();
                for (MatchRedConfirmBillDTO dto : dtos) {
                    JSONObject matchProcess = new JSONObject();
                    matchInfoLogs.add((Object)matchProcess);
                    String checkMsg = this.checkNeedMatch(dto);
                    if (StringUtils.isNotBlank((CharSequence)checkMsg)) {
                        matchProcess.put("redConfirms", null);
                        matchProcess.put("failReason", (Object)checkMsg);
                        continue;
                    }
                    List<DynamicObject> redConfirms = this.filterRedConfirms(dto, prepareRedConfirmMap, queryDTO, occupiedRedConfirmPkMap);
                    matchProcess.put("billno", (Object)dto.getBillNo());
                    matchProcess.put("redConfirmFilter", (Object)dto.getFilterStr());
                    if (redConfirms.size() == 0) {
                        matchProcess.put("redConfirms", null);
                        matchProcess.put("failReason", (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u590d\u5408\u6761\u4ef6\u7684\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"RedConfirmMatchHelper_5", (String)"imc-sim-service", (Object[])new Object[0]));
                        dto.setProcess(matchProcess);
                        dto.setMatchStatusCode("-1");
                        continue;
                    }
                    List<DynamicObject> sortedList = redConfirms.stream().sorted(Comparator.comparing(o -> o.getBigDecimal("totalamount").abs(), Comparator.reverseOrder())).collect(Collectors.toList());
                    this.compareAndMatch(dto, sortedList, occupiedRedConfirmPkMap, matchProcess);
                }
                ArrayList<BillRelationDTO> relations = new ArrayList<BillRelationDTO>(dtos.size());
                for (MatchRedConfirmBillDTO dto : dtos) {
                    this.setMatchStatusCode(dto);
                    List dtoItems = dto.getItems();
                    for (MatchRedConfirmBillItemDTO dtoItem : dtoItems) {
                        List matchResultList = dtoItem.getMatchResult();
                        if (null == matchResultList) continue;
                        for (MatchRedConfirmResultDTO minResult : matchResultList) {
                            BillRelationDTO relation = new BillRelationDTO();
                            relation.setTax(minResult.getOriItemTax());
                            relation.setAmount(minResult.getOriItemAmount());
                            relation.settBillNo(minResult.getBillNo());
                            relation.setsBillId(dto.getMergebillId());
                            relation.setsDetailId(dtoItem.getMatchOrMergeItemId());
                            relation.settBillId(minResult.getRedConfirmPk());
                            relation.settDetailId(minResult.getRedConfirmItemPk());
                            relation.setNum(minResult.getOriItemNum());
                            relation.setOrgId(dto.getOrgId());
                            relation.setsBillNo(dto.getBillNo());
                            relations.add(relation);
                        }
                    }
                }
                if (occupiedRedConfirmPkMap.size() > 0) {
                    occupiedRedConfirmPkMap.values().stream().forEach(o -> o.set("occupystatus", (Object)"1"));
                    ImcSaveServiceHelper.save(new ArrayList(occupiedRedConfirmPkMap.values()));
                }
                arrayList = relations;
            }
            catch (Throwable throwable2) {
                try {
                    CacheHelper.remove((String)lockKey);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            CacheHelper.remove((String)lockKey);
            return arrayList;
        }
    }

    private String checkNeedMatch(MatchRedConfirmBillDTO dto) {
        BigDecimal totalRemainAmount = dto.getTotalRemainAmount();
        if (BigDecimalUtil.compareZero((BigDecimal)totalRemainAmount)) {
            return ResManager.loadKDString((String)"\u4f20\u5165\u7684\u5339\u914d\u5355\u7684\u5f85\u5339\u914d\u91d1\u989d\u4e3a0\uff0c\u8be5\u5339\u914d\u5355\u8df3\u8fc7\u5339\u914d\u8fc7\u7a0b", (String)"RedConfirmMatchHelper_10", (String)"imc-sim-service", (Object[])new Object[0]);
        }
        return null;
    }

    private void saveLogs(JSONArray matchInfoLogs) {
        try {
            if ("1".equals(ImcConfigUtil.getValue((String)"saveMatchRedConfirLog", (String)"saveMatchRedConfirLog"))) {
                ThreadPools.executeOnce((String)"downloadFileThread", () -> {
                    DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"bdm_api_log");
                    log.set("createdate", (Object)new Date());
                    log.set("request_tag", (Object)matchInfoLogs.toJSONString());
                    log.set("requesturl", (Object)"matchRedConfirm");
                    ImcSaveServiceHelper.save((DynamicObject)log);
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<DynamicObject> filterRedConfirms(MatchRedConfirmBillDTO dto, Map<Long, List<DynamicObject>> prepareRedConfirmMap, MatchRedConfirmQueryDTO queryDTO, Map<Long, DynamicObject> occupiedRedConfirmPkMap) {
        DynamicObject[] redConfirms;
        if ("1".equals(ImcConfigUtil.getValue((String)"matchRedConfirm", (String)"singleQuery"))) {
            List<QFilter> qFilters = this.getqFilters(dto);
            redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)QUERY_RED_CONFIRM_FIELDS, (QFilter[])qFilters.toArray(new QFilter[0]));
        } else {
            redConfirms = this.filterQueriedConfirms(dto, prepareRedConfirmMap, queryDTO);
        }
        return Arrays.stream(redConfirms).filter(o -> !occupiedRedConfirmPkMap.containsKey(o.getLong("id"))).collect(Collectors.toList());
    }

    private DynamicObject[] filterQueriedConfirms(MatchRedConfirmBillDTO dto, Map<Long, List<DynamicObject>> prepareRedConfirmMap, MatchRedConfirmQueryDTO queryDTO) {
        DynamicObject matchConfig = dto.getMatchConfig();
        List<DynamicObject> redConfirms = prepareRedConfirmMap.get(matchConfig.getLong("id"));
        ArrayList<DynamicObject> filteredRedConfirm = new ArrayList<DynamicObject>();
        StringBuilder extraFilter = this.logFilter(dto);
        String baseFilter = queryDTO.getFilterDescription().toString();
        String extraFilterStr = extraFilter.toString();
        dto.setFilterStr(baseFilter + extraFilterStr);
        for (DynamicObject redConfirm : redConfirms) {
            BigDecimal redConfirmTotalTax;
            BigDecimal remainTax;
            BigDecimal redConfirmInvoiceAmount;
            String invoiceType;
            if (StringUtils.isNotBlank((CharSequence)dto.getBlueInvoiceCode()) && !Objects.equals(dto.getBlueInvoiceCode(), redConfirm.getString("originalinvoicecode")) || StringUtils.isNotBlank((CharSequence)dto.getBlueInvoiceNo()) && !Objects.equals(dto.getBlueInvoiceNo(), redConfirm.getString("originalinvoiceno")) || StringUtils.isNotBlank((CharSequence)dto.getRedreason()) && !Objects.equals(InvoiceUtils.matchRedConfirmRedReason((String)dto.getRedreason()), redConfirm.getString("redreason")) || StringUtils.isNotBlank((CharSequence)dto.getBuyerTaxNo()) && !Objects.equals(dto.getBuyerTaxNo(), redConfirm.getString("buyertaxno")) || (!InvoiceUtils.isNormalInvoice((String)(invoiceType = dto.getInvoiceType())) && !InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType) ? !InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(redConfirm.getString("invoicetype")) : !InvoiceType.ALL_E_NORMAL.getTypeCode().equals(redConfirm.getString("invoicetype")))) continue;
            BigDecimal remainAmount = dto.getTotalRemainAmount();
            if (remainAmount.compareTo(redConfirmInvoiceAmount = redConfirm.getBigDecimal("invoiceamount")) > 0 || (remainTax = dto.getTotalRemainTax()).compareTo(redConfirmTotalTax = redConfirm.getBigDecimal("totaltax")) > 0) continue;
            filteredRedConfirm.add(redConfirm);
        }
        return filteredRedConfirm.toArray(new DynamicObject[0]);
    }

    private StringBuilder logFilter(MatchRedConfirmBillDTO dto) {
        String invoiceType;
        StringBuilder extraFilter = new StringBuilder(AND_STR);
        if (StringUtils.isNotBlank((CharSequence)dto.getBlueInvoiceCode())) {
            extraFilter.append("originalinvoicecode =").append(dto.getBlueInvoiceCode()).append(AND_STR);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getBlueInvoiceNo())) {
            extraFilter.append("originalinvoiceno =").append(dto.getBlueInvoiceNo()).append(AND_STR);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getRedreason())) {
            extraFilter.append("redreason =").append(InvoiceUtils.matchRedConfirmRedReason((String)dto.getRedreason())).append(AND_STR);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getBuyerTaxNo())) {
            extraFilter.append("buyertaxno =").append(dto.getBuyerTaxNo()).append(AND_STR);
        }
        if (InvoiceUtils.isNormalInvoice((String)(invoiceType = dto.getInvoiceType())) || InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
            extraFilter.append("invoicetype =").append(InvoiceType.ALL_E_NORMAL.getTypeCode()).append(AND_STR);
        } else {
            extraFilter.append("invoicetype =").append(InvoiceType.ALL_E_SPECIAL.getTypeCode()).append(AND_STR);
        }
        BigDecimal remainAmount = dto.getTotalRemainAmount();
        extraFilter.append("invoiceamount >=").append(remainAmount).append(AND_STR);
        BigDecimal remainTax = dto.getTotalRemainTax();
        extraFilter.append("totaltax >=").append(remainTax).append(AND_STR);
        return extraFilter;
    }

    private MatchRedConfirmQueryDTO prepareQueryRedConfirms(List<MatchRedConfirmBillDTO> dtos) {
        MatchRedConfirmQueryDTO queryResult = new MatchRedConfirmQueryDTO();
        if ("1".equals(ImcConfigUtil.getValue((String)"matchRedConfirm", (String)"singleQuery"))) {
            queryResult.setPrepareRedConfirmMap(new HashMap());
            return queryResult;
        }
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>();
        queryResult.setPrepareRedConfirmMap(result);
        HashMap<Long, QFilter> matchConfigMap = new HashMap<Long, QFilter>();
        for (MatchRedConfirmBillDTO matchRedConfirmBillDTO : dtos) {
            DynamicObject matchConfig = matchRedConfirmBillDTO.getMatchConfig();
            if (matchConfigMap.containsKey(matchConfig.getLong("id"))) continue;
            QFilter filter = this.generateQFilter(matchRedConfirmBillDTO);
            if (queryResult.getFilterDescription().length() == 0) {
                queryResult.getFilterDescription().append(filter.toString());
            }
            matchConfigMap.put(matchConfig.getLong("id"), filter);
        }
        for (Map.Entry entry : matchConfigMap.entrySet()) {
            this.addRedConfirm(result, entry);
        }
        return queryResult;
    }

    private void addRedConfirm(HashMap<Long, List<DynamicObject>> result, Map.Entry<Long, QFilter> entry) {
        DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)QUERY_RED_CONFIRM_FIELDS, (QFilter[])entry.getValue().toArray());
        result.put(entry.getKey(), Arrays.stream(redConfirms).collect(Collectors.toList()));
    }

    private QFilter generateQFilter(MatchRedConfirmBillDTO dto) {
        String salerTaxNo = dto.getSalerTaxNo();
        QFilter baseFilter = new QFilter("salertaxno", "=", (Object)salerTaxNo);
        DynamicObject matchRedConfirmConfig = dto.getMatchConfig();
        String uploadTime = matchRedConfirmConfig.getString("uploadtime");
        baseFilter.and(this.getUploadFilter(uploadTime));
        baseFilter.and(this.getConfirmStateFilter(matchRedConfirmConfig));
        baseFilter.and(this.getSourceFilter(matchRedConfirmConfig));
        if (!"1".equals(ImcConfigUtil.getValue((String)"matchRedConfirm", (String)"containsBuyerApply"))) {
            baseFilter.and("applicant", "=", (Object)"1");
        }
        baseFilter.and("issuestatus", "=", (Object)"2");
        baseFilter.and("occupystatus", "=", (Object)"0");
        return baseFilter;
    }

    private void createRedConfirmItem(DynamicObjectCollection oriInvoices, MatchRedConfirmResultDTO dto) {
        DynamicObject oriInvoice = oriInvoices.addNew();
        oriInvoice.set("confirmoriinvoicecode", (Object)dto.getBlueInvoiceCode());
        oriInvoice.set("confirmoriinvoiceno", (Object)dto.getBlueInvoiceNo());
        oriInvoice.set("confirmoriitemseq", (Object)dto.getConfirmOriItemSeq());
        oriInvoice.set("redconfirmitempk", (Object)dto.getRedConfirmItemPk());
        oriInvoice.set("redconfirmpk", (Object)dto.getRedConfirmPk());
        oriInvoice.set("confirmoriitemseq", (Object)dto.getConfirmOriItemSeq());
        oriInvoice.set("confirmoriitemamount", (Object)dto.getOriItemAmount());
        oriInvoice.set("confirmoriitemtax", (Object)dto.getOriItemTax());
        oriInvoice.set("confirmoritaxrate", (Object)dto.getOriTaxRate());
        oriInvoice.set("confirmoriitemnum", (Object)dto.getOriItemNum());
        oriInvoice.set("confirmoriitemunitprice", (Object)dto.getOriItemUnitprice());
        oriInvoice.set("confirminfocode", (Object)dto.getInfocode());
        oriInvoice.set("confiroriitemtaxunitprice", (Object)dto.getOriItemTaxUnitprice());
        oriInvoice.set("confirmoriitemgoodsname", (Object)dto.getOriitemGoodsName());
        oriInvoice.set("conforiitemspecification", (Object)dto.getOriItemSpecification());
        oriInvoice.set("confirmoriitemunit", (Object)dto.getOriItemUnit());
        oriInvoice.set("confirmissuestatus", (Object)"2");
    }

    private static String createMatchBatch() {
        String matchBatchNum = "400_";
        LocalDate date = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        matchBatchNum = matchBatchNum + date.format(formatter);
        matchBatchNum = matchBatchNum + RandomString.getRandom((int)15);
        return matchBatchNum;
    }

    private void prepareAndCheckDtos(List<MatchRedConfirmBillDTO> dtos) {
        for (MatchRedConfirmBillDTO dto : dtos) {
            if (dto.getMatchConfig() == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u5339\u914d\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedConfirmMatchHelper_1", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            List items = dto.getItems();
            BigDecimal totalRemainAmount = BigDecimal.ZERO;
            BigDecimal totalRemainTax = BigDecimal.ZERO;
            for (MatchRedConfirmBillItemDTO item : items) {
                List matchResult = item.getMatchResult();
                item.setRemainAmount(item.getAmount());
                item.setRemainNum(item.getNum());
                item.setRemainTax(item.getTax());
                if (null != matchResult && matchResult.size() > 0) {
                    for (MatchRedConfirmResultDTO resultDTO : matchResult) {
                        if (null != resultDTO.getOriItemAmount()) {
                            item.setRemainAmount(item.getAmount().subtract(resultDTO.getOriItemAmount()));
                        }
                        if (null != resultDTO.getOriItemTax()) {
                            item.setRemainTax(item.getRemainTax().subtract(resultDTO.getOriItemTax()));
                        }
                        if (null == resultDTO.getOriItemNum()) continue;
                        item.setRemainNum(item.getRemainNum().subtract(resultDTO.getOriItemNum()));
                    }
                }
                totalRemainAmount = totalRemainAmount.add(item.getRemainAmount());
                totalRemainTax = totalRemainTax.add(item.getRemainTax());
                if (!StringUtils.isBlank((CharSequence)item.getItemMatchStatus())) continue;
                item.setItemMatchStatus(MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode());
            }
            dto.setTotalRemainAmount(totalRemainAmount);
            dto.setTotalRemainTax(totalRemainTax);
        }
    }

    private void compareAndMatch(MatchRedConfirmBillDTO dto, List<DynamicObject> sortedList, Map<Long, DynamicObject> occupiedRedConfirmPkMap, JSONObject process) {
        List items = dto.getItems();
        Set<String> dtoTaxRateSet = items.stream().map(MatchRedConfirmBillItemDTO::getTaxRate).collect(Collectors.toSet());
        process.put("redConfirmSize", (Object)sortedList.size());
        JSONArray matchProcess = new JSONArray();
        process.put("matchRedConfirmProcess", (Object)matchProcess);
        process.put("billno", (Object)dto.getBillNo());
        int matchSeq = 0;
        for (DynamicObject redConfirm : sortedList) {
            JSONObject redConfirmMatchProcess = new JSONObject();
            redConfirmMatchProcess.put("matchSeq", (Object)matchSeq);
            redConfirmMatchProcess.put("matchStatus", (Object)"fail");
            redConfirmMatchProcess.put("number", (Object)redConfirm.getString("number"));
            matchProcess.add((Object)redConfirmMatchProcess);
            if (redConfirm.getBigDecimal("invoiceamount").compareTo(dto.getTotalRemainAmount()) < 0 || redConfirm.getBigDecimal("totaltax").compareTo(dto.getTotalRemainTax()) < 0) {
                redConfirmMatchProcess.put("failReason", (Object)String.format(ResManager.loadKDString((String)"\u5339\u914d\u5355\u5269\u4f59\u53ef\u5339\u914d\u91d1\u989d%1$s\uff0c\u7a0e\u989d%2$s\u8d85\u8fc7\u7ea2\u5b57\u786e\u8ba4\u5355\u91d1\u989d%3$s,\u7a0e\u989d%4$s", (String)"RedConfirmMatchHelper_3", (String)"imc-sim-service", (Object[])new Object[0]), dto.getTotalRemainAmount(), dto.getTotalRemainTax(), redConfirm.getBigDecimal("invoiceamount"), redConfirm.getBigDecimal("totaltax")));
                continue;
            }
            Set<String> redConfirmTaxRateSet = redConfirm.getDynamicObjectCollection("items").stream().map(o -> o.getString("taxrate")).collect(Collectors.toSet());
            if (!this.isRedConfirmTaxRateContains(dtoTaxRateSet, redConfirmTaxRateSet)) {
                redConfirmMatchProcess.put("failReason", (Object)ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u7a0e\u7387\u6bd4\u5339\u914d\u5355\u7a0e\u7387\u79cd\u7c7b\u66f4\u591a\uff0c\u8be5\u786e\u8ba4\u5355\u820d\u5f03", (String)"RedConfirmMatchHelper_4", (String)"imc-sim-service", (Object[])new Object[0]));
                continue;
            }
            DynamicObject copyRedConfirm = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_confirm_bill");
            DynamicObjectUtil.copyDynamicObject((DynamicObject)redConfirm, (DynamicObject)copyRedConfirm, (boolean)true);
            CheckRedConfirmDTO checkResult = this.checkRedConfirmCanUsed(dto, copyRedConfirm);
            if (checkResult.isCanUsed()) {
                redConfirmMatchProcess.put("matchStatus", (Object)"success");
                DynamicObject copyRedConfirm2 = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_confirm_bill");
                DynamicObjectUtil.copyDynamicObject((DynamicObject)redConfirm, (DynamicObject)copyRedConfirm2, (boolean)true);
                redConfirm.set("occupystatus", (Object)"1");
                this.matchDtoItemFromRedConfirm(dto, copyRedConfirm2);
                occupiedRedConfirmPkMap.put(redConfirm.getLong("id"), redConfirm);
                this.calculateTotalRemainInfo(dto);
            } else {
                redConfirmMatchProcess.put("failReason", (Object)checkResult.getErrorMsg());
                redConfirmMatchProcess.put("matchBillGroupInfo", (Object)checkResult.getMatchBillsOnlyKeyMap());
                redConfirmMatchProcess.put("redConfirmGroupInfo", (Object)checkResult.getRedConfirmOnlyKeyMap());
            }
            if (!BigDecimalUtil.compareZero((BigDecimal)dto.getTotalRemainAmount()) || !BigDecimalUtil.compareZero((BigDecimal)dto.getTotalRemainTax())) continue;
            redConfirmMatchProcess.put("lastOne", (Object)"lastOne");
            return;
        }
    }

    public CheckRedConfirmDTO checkRedConfirmCanUsedByMatchBill(DynamicObject matchBill, DynamicObject redConfirm) {
        MatchRedConfirmBillDTO dto = (MatchRedConfirmBillDTO)DynamicObjectUtil.dynamicObject2Bean(MatchRedConfirmBillDTO.class, (DynamicObject)matchBill);
        dto.setMatchConfig(matchBill.getDynamicObject("matchconfig"));
        ArrayList<MatchRedConfirmBillDTO> list = new ArrayList<MatchRedConfirmBillDTO>();
        list.add(dto);
        this.prepareAndCheckDtos(list);
        dto.setOrgId(Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)matchBill.get("org"))));
        dto.setMatchConfig(matchBill.getDynamicObject("matchconfig"));
        DynamicObject copyRedConfirm = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_confirm_bill");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)redConfirm, (DynamicObject)copyRedConfirm, (boolean)true);
        DynamicObject copyRedConfirm2 = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_confirm_bill");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)redConfirm, (DynamicObject)copyRedConfirm2, (boolean)true);
        CheckRedConfirmDTO result = this.checkRedConfirmCanUsed(dto, copyRedConfirm);
        if (result.isCanUsed()) {
            this.matchDtoItemFromRedConfirm(dto, copyRedConfirm2);
            result.setResult(dto);
        }
        return result;
    }

    private void calculateTotalRemainInfo(MatchRedConfirmBillDTO dto) {
        List items = dto.getItems();
        BigDecimal totalRemainAmount = BigDecimal.ZERO;
        BigDecimal totalRemainTax = BigDecimal.ZERO;
        for (MatchRedConfirmBillItemDTO item : items) {
            totalRemainAmount = totalRemainAmount.add(item.getRemainAmount());
            totalRemainTax = totalRemainTax.add(item.getRemainTax());
        }
        dto.setTotalRemainAmount(totalRemainAmount);
        dto.setTotalRemainTax(totalRemainTax);
    }

    private boolean isRedConfirmTaxRateContains(Set<String> dtoTaxRateSet, Set<String> redConfirmTaxRateSet) {
        for (String s : redConfirmTaxRateSet) {
            if (dtoTaxRateSet.contains(s)) continue;
            return false;
        }
        return true;
    }

    private void setMatchStatusCode(MatchRedConfirmBillDTO dto) {
        BigDecimal invoiceAmount = dto.getInvoiceAmount();
        BigDecimal totalTax = dto.getTotalTax();
        List items = dto.getItems();
        BigDecimal totalMatchAmount = BigDecimal.ZERO;
        BigDecimal totalMatchTax = BigDecimal.ZERO;
        for (MatchRedConfirmBillItemDTO item : items) {
            BigDecimal itemAmount = item.getAmount();
            BigDecimal itemTax = item.getTax();
            BigDecimal itemTotalAmount = BigDecimal.ZERO;
            BigDecimal itemTotalTax = BigDecimal.ZERO;
            List matchResult = item.getMatchResult();
            if (null == matchResult) continue;
            for (MatchRedConfirmResultDTO matchRedConfirmResultDTO : matchResult) {
                if (null == matchRedConfirmResultDTO.getOriItemAmount()) continue;
                totalMatchAmount = totalMatchAmount.add(matchRedConfirmResultDTO.getOriItemAmount());
                totalMatchTax = totalMatchTax.add(matchRedConfirmResultDTO.getOriItemTax());
                itemTotalTax = itemTotalTax.add(matchRedConfirmResultDTO.getOriItemTax());
                itemTotalAmount = itemTotalAmount.add(matchRedConfirmResultDTO.getOriItemAmount());
            }
            item.setItemMatchStatus(this.getMatchStatus(itemTotalAmount, itemAmount, itemTotalTax, itemTax));
        }
        dto.setMatchStatusCode(this.getMatchStatus(totalMatchAmount, invoiceAmount, totalMatchTax, totalTax));
    }

    private String getMatchStatus(BigDecimal totalAmount, BigDecimal compareAmount, BigDecimal totalTax, BigDecimal compareTax) {
        if (BigDecimalUtil.compareZero((BigDecimal)totalAmount) && BigDecimalUtil.compareZero((BigDecimal)totalTax)) {
            return "-1";
        }
        if (totalAmount.compareTo(compareAmount) == 0 && totalTax.compareTo(compareTax) == 0) {
            return "1";
        }
        return "5";
    }

    private void matchDtoItemFromRedConfirm(MatchRedConfirmBillDTO dto, DynamicObject redConfirm) {
        DynamicObjectCollection redConfirmItems = redConfirm.getDynamicObjectCollection("items");
        List dtoItems = dto.getItems();
        boolean containsOriginalSeq = 0L != ((MatchRedConfirmBillItemDTO)dtoItems.get(0)).getOriginalSeq();
        List<String> fieldSet = this.getItemMatchFields(dto);
        for (DynamicObject redConfirmItem : redConfirmItems) {
            String redConfirmOnlyKey = this.getRedConfirmOnlyKey(fieldSet, containsOriginalSeq, redConfirmItem);
            for (MatchRedConfirmBillItemDTO dtoItem : dtoItems) {
                BigDecimal usedNum;
                BigDecimal usedTax;
                BigDecimal usedAmount;
                if (!BigDecimalUtil.lessZero((BigDecimal)dtoItem.getRemainAmount()) || !BigDecimalUtil.lessZero((BigDecimal)redConfirmItem.getBigDecimal("amount"))) continue;
                String dtoItemOnlyKey = dtoItem.getDtoItemOnlyKey();
                if (StringUtils.isBlank((CharSequence)dtoItem.getDtoItemOnlyKey())) {
                    dtoItemOnlyKey = this.getDtoOnlyKey(fieldSet, containsOriginalSeq, dtoItem);
                }
                if (!redConfirmOnlyKey.equals(dtoItemOnlyKey)) continue;
                if (dtoItem.getRemainAmount().compareTo(redConfirmItem.getBigDecimal("amount")) == 0) {
                    usedAmount = dtoItem.getRemainAmount();
                    usedTax = dtoItem.getRemainTax();
                    usedNum = redConfirmItem.getBigDecimal("num");
                    dtoItem.setRemainAmount(BigDecimal.ZERO);
                    dtoItem.setRemainNum(BigDecimal.ZERO);
                    dtoItem.setRemainTax(BigDecimal.ZERO);
                    redConfirmItem.set("amount", (Object)BigDecimal.ZERO);
                    redConfirmItem.set("tax", (Object)BigDecimal.ZERO);
                    redConfirmItem.set("num", (Object)BigDecimal.ZERO);
                } else if (dtoItem.getRemainAmount().compareTo(redConfirmItem.getBigDecimal("amount")) > 0) {
                    usedAmount = dtoItem.getRemainAmount();
                    usedTax = dtoItem.getRemainTax();
                    usedNum = redConfirmItem.getBigDecimal("num").multiply(dtoItem.getRemainAmount()).divide(redConfirmItem.getBigDecimal("amount"), 2, RoundingMode.HALF_UP);
                    dtoItem.setRemainAmount(BigDecimal.ZERO);
                    dtoItem.setRemainNum(BigDecimal.ZERO);
                    dtoItem.setRemainTax(BigDecimal.ZERO);
                    redConfirmItem.set("amount", (Object)redConfirmItem.getBigDecimal("amount").subtract(usedAmount));
                    redConfirmItem.set("tax", (Object)redConfirmItem.getBigDecimal("tax").subtract(usedTax));
                    redConfirmItem.set("num", (Object)redConfirmItem.getBigDecimal("num").subtract(usedNum));
                } else {
                    usedAmount = redConfirmItem.getBigDecimal("amount");
                    usedTax = redConfirmItem.getBigDecimal("tax");
                    usedNum = redConfirmItem.getBigDecimal("num");
                    dtoItem.setRemainAmount(dtoItem.getRemainAmount().subtract(usedAmount));
                    dtoItem.setRemainNum(dtoItem.getRemainNum().subtract(usedNum));
                    dtoItem.setRemainTax(dtoItem.getRemainTax().subtract(usedTax));
                    redConfirmItem.set("amount", (Object)BigDecimal.ZERO);
                    redConfirmItem.set("tax", (Object)BigDecimal.ZERO);
                    redConfirmItem.set("num", (Object)BigDecimal.ZERO);
                }
                MatchRedConfirmResultDTO matchResult = this.generateBaseResultFromRedConfirm(redConfirm, dtoItem, redConfirmItem);
                this.fillItemMatchResultInfo(redConfirmItem, matchResult, usedAmount, usedTax, usedNum);
                ArrayList<MatchRedConfirmResultDTO> matchResultList = dtoItem.getMatchResult();
                if (null == matchResultList) {
                    matchResultList = new ArrayList<MatchRedConfirmResultDTO>();
                }
                matchResultList.add(matchResult);
                dtoItem.setMatchResult(matchResultList);
            }
        }
    }

    private CheckRedConfirmDTO checkRedConfirmCanUsed(MatchRedConfirmBillDTO dto, DynamicObject redConfirm) {
        Long l;
        Long l2;
        CheckRedConfirmDTO checkResult = new CheckRedConfirmDTO();
        Map matchBillsOnlyKeyMap = checkResult.getMatchBillsOnlyKeyMap();
        Map redConfirmOnlyKeyMap = checkResult.getRedConfirmOnlyKeyMap();
        checkResult.setCanUsed(false);
        List<String> fieldSet = this.getItemMatchFields(dto);
        List dtoItems = dto.getItems();
        boolean containsOriginalSeq = 0L != ((MatchRedConfirmBillItemDTO)dtoItems.get(0)).getOriginalSeq();
        DynamicObjectCollection redConfirmItems = redConfirm.getDynamicObjectCollection("items");
        DynamicObject firstRedConfirm = (DynamicObject)redConfirmItems.get(0);
        boolean isStartZero = 0L == firstRedConfirm.getLong("seq");
        HashMap<String, DynamicObject> redConfirmOnlyOneKeyMap = new HashMap<String, DynamicObject>();
        Long redConfirmSeq = 0L;
        Long matchBillItemSeq = 0L;
        for (DynamicObject dynamicObject : redConfirmItems) {
            String redConfirmOnlyKey = this.getRedConfirmOnlyKey(fieldSet, containsOriginalSeq, dynamicObject);
            DynamicObject valueRedConfirmItem = (DynamicObject)redConfirmOnlyOneKeyMap.get(redConfirmOnlyKey);
            if (null != valueRedConfirmItem) {
                valueRedConfirmItem.set("amount", (Object)valueRedConfirmItem.getBigDecimal("amount").add(dynamicObject.getBigDecimal("amount")));
                valueRedConfirmItem.set("tax", (Object)valueRedConfirmItem.getBigDecimal("tax").add(dynamicObject.getBigDecimal("tax")));
                valueRedConfirmItem.set("num", (Object)valueRedConfirmItem.getBigDecimal("num").add(dynamicObject.getBigDecimal("num")));
            } else {
                redConfirmOnlyOneKeyMap.put(redConfirmOnlyKey, dynamicObject);
            }
            ArrayList<Long> seqList = (ArrayList<Long>)redConfirmOnlyKeyMap.get(redConfirmOnlyKey);
            if (null == seqList) {
                seqList = new ArrayList<Long>();
                redConfirmOnlyKeyMap.put(redConfirmOnlyKey, seqList);
            }
            l2 = redConfirmSeq;
            l = redConfirmSeq = Long.valueOf(redConfirmSeq + 1L);
            seqList.add(l2);
        }
        for (MatchRedConfirmBillItemDTO matchRedConfirmBillItemDTO : dtoItems) {
            ArrayList<Long> dtoSeqList;
            String dtoItemOnlyKey = this.getDtoOnlyKey(fieldSet, containsOriginalSeq, matchRedConfirmBillItemDTO);
            matchRedConfirmBillItemDTO.setDtoItemOnlyKey(dtoItemOnlyKey);
            DynamicObject redConfirmItem = (DynamicObject)redConfirmOnlyOneKeyMap.get(dtoItemOnlyKey);
            if (null != redConfirmItem) {
                BigDecimal redConfirmItemAmount = redConfirmItem.getBigDecimal("amount");
                redConfirmItem.set("amount", (Object)redConfirmItemAmount.subtract(matchRedConfirmBillItemDTO.getRemainAmount()));
                redConfirmItem.set("tax", (Object)redConfirmItem.getBigDecimal("tax").subtract(matchRedConfirmBillItemDTO.getRemainTax()));
                redConfirmItem.set("num", (Object)redConfirmItem.getBigDecimal("num").subtract(matchRedConfirmBillItemDTO.getRemainNum()));
            }
            if (null == (dtoSeqList = (ArrayList<Long>)matchBillsOnlyKeyMap.get(dtoItemOnlyKey))) {
                dtoSeqList = new ArrayList<Long>();
                matchBillsOnlyKeyMap.put(dtoItemOnlyKey, dtoSeqList);
            }
            l2 = matchBillItemSeq;
            l = matchBillItemSeq = Long.valueOf(matchBillItemSeq + 1L);
            dtoSeqList.add(l2);
        }
        for (Map.Entry entry : redConfirmOnlyOneKeyMap.entrySet()) {
            DynamicObject redConfirmItem = (DynamicObject)entry.getValue();
            long rowSeq = redConfirmItem.getLong("seq");
            if (isStartZero) {
                ++rowSeq;
            }
            if (BigDecimalUtil.lessZero((BigDecimal)redConfirmItem.getBigDecimal("amount"))) {
                checkResult.setErrorMsg(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u7b2c%1$s\u884c\u660e\u7ec6\u672a\u80fd\u5339\u914d\u5230\u5339\u914d\u5355\u7684\u660e\u7ec6\u884c,\u7ea2\u5b57\u786e\u8ba4\u5355\u8be5\u884c\u91d1\u989d\u5339\u914d\u4e4b\u540e\u5b58\u5728\u5269\u4f59,\u8be5\u884c\u7ea2\u5b57\u786e\u8ba4\u5355\u660e\u7ec6\u5269\u4f59\u91d1\u989d:%2$s", (String)"RedConfirmMatchHelper_2", (String)"imc-sim-service", (Object[])new Object[0]), rowSeq, redConfirmItem.getBigDecimal("amount")));
                return checkResult;
            }
            if (BigDecimalUtil.lessZero((BigDecimal)redConfirmItem.getBigDecimal("tax"))) {
                checkResult.setErrorMsg(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u7b2c%1$s\u884c\u660e\u7ec6\u672a\u80fd\u5339\u914d\u5230\u5339\u914d\u5355\u7684\u660e\u7ec6\u884c,\u7ea2\u5b57\u786e\u8ba4\u5355\u8be5\u884c\u7a0e\u989d\u5339\u914d\u4e4b\u540e\u5b58\u5728\u5269\u4f59,\u8be5\u884c\u7ea2\u5b57\u786e\u8ba4\u5355\u660e\u7ec6\u5269\u4f59\u7a0e\u989d:%2$s", (String)"RedConfirmMatchHelper_7", (String)"imc-sim-service", (Object[])new Object[0]), rowSeq, redConfirmItem.getBigDecimal("tax")));
                return checkResult;
            }
            String taxRateStr = redConfirmItem.getString("taxrate");
            if ("1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.SIM_IGNORE_SMALL_DIFFERENCE_CONFIG))) continue;
            if (!TaxRate.ZERO_PERCENT.getRateValue().equals(taxRateStr) && !BigDecimalUtil.compareZero((BigDecimal)redConfirmItem.getBigDecimal("amount")) && BigDecimalUtil.compareZero((BigDecimal)redConfirmItem.getBigDecimal("tax"))) {
                checkResult.setErrorMsg(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u7b2c%1$s\u884c\u660e\u7ec6\u672a\u80fd\u5339\u914d\u5230\u5339\u914d\u5355\u7684\u660e\u7ec6\u884c\uff0c\u8be5\u884c\u7a0e\u989d\u5339\u914d\u5b8c\uff0c\u4f46\u662f\u91d1\u989d\u4e0d\u80fd\u5b8c\u5168\u88ab\u5339\u914d\u6216\u8005\u91d1\u989d\u8d85\u989d,\u8be5\u884c\u7ea2\u5b57\u786e\u8ba4\u5355\u91d1\u989d\u5269\u4f59:%2$s,\u7a0e\u989d\u5269\u4f59:%3$s", (String)"RedConfirmMatchHelper_9", (String)"imc-sim-service", (Object[])new Object[0]), rowSeq, redConfirmItem.getBigDecimal("amount"), redConfirmItem.getBigDecimal("tax")));
                return checkResult;
            }
            if (!BigDecimalUtil.compareZero((BigDecimal)redConfirmItem.getBigDecimal("amount")) || BigDecimalUtil.compareZero((BigDecimal)redConfirmItem.getBigDecimal("tax"))) continue;
            checkResult.setErrorMsg(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u7b2c%1$s\u884c\u660e\u7ec6\u672a\u80fd\u5339\u914d\u5230\u5339\u914d\u5355\u7684\u660e\u7ec6\u884c\uff0c\u8be5\u884c\u91d1\u989d\u5339\u914d\u5b8c\uff0c\u4f46\u662f\u7a0e\u989d\u4e0d\u80fd\u5b8c\u5168\u88ab\u5339\u914d\u6216\u8005\u7a0e\u989d\u8d85\u989d,\u8be5\u884c\u7ea2\u5b57\u786e\u8ba4\u5355\u91d1\u989d\u5269\u4f59:%2$s,\u7a0e\u989d\u5269\u4f59:%3$s", (String)"RedConfirmMatchHelper_8", (String)"imc-sim-service", (Object[])new Object[0]), rowSeq, redConfirmItem.getBigDecimal("amount"), redConfirmItem.getBigDecimal("tax")));
            return checkResult;
        }
        checkResult.setCanUsed(true);
        return checkResult;
    }

    private List<String> getItemMatchFields(MatchRedConfirmBillDTO dto) {
        DynamicObject matchConfig = dto.getMatchConfig();
        String fields = matchConfig.getString("matchfields");
        String[] fieldArray = fields.split(",");
        List<String> fieldSet = Arrays.stream(fieldArray).filter(o -> StringUtils.isNotBlank((CharSequence)o)).collect(Collectors.toList());
        if (fieldSet.isEmpty()) {
            fieldSet.add("taxrate");
            fieldSet.add("goodsname");
        }
        return fieldSet;
    }

    private String getDtoOnlyKey(List<String> fieldSet, boolean containsOriginalSeq, MatchRedConfirmBillItemDTO dtoItem) {
        StringBuilder start = new StringBuilder();
        if (containsOriginalSeq) {
            start.append('@').append(dtoItem.getOriginalSeq()).append('@');
        } else {
            start = new StringBuilder("@");
        }
        for (String field : fieldSet) {
            Class<?> clazz = dtoItem.getClass();
            Field[] clazzFields = clazz.getDeclaredFields();
            Object value = null;
            for (Field clazzField : clazzFields) {
                if (!field.equals(clazzField.getName().toLowerCase())) continue;
                ReflectionUtils.makeAccessible((Field)clazzField);
                try {
                    String goodsName;
                    value = clazzField.get(dtoItem);
                    if ("goodsname".equals(field) && (goodsName = String.valueOf(value)).charAt(0) == '*') {
                        String subValue = goodsName.substring(1, goodsName.length() - 1);
                        int i = subValue.indexOf(42) + 2;
                        value = goodsName.substring(i, goodsName.length());
                    }
                    if (!(value instanceof BigDecimal)) continue;
                    value = ((BigDecimal)value).stripTrailingZeros().toPlainString();
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            start.append(this.simpleValue(value)).append('@');
        }
        return start.toString();
    }

    private String getRedConfirmOnlyKey(List<String> fieldSet, boolean containsOriginalSeq, DynamicObject redConfirmItem) {
        StringBuilder start = new StringBuilder();
        if (containsOriginalSeq) {
            start.append('@').append(redConfirmItem.getLong("originseq")).append('@');
        } else {
            start = new StringBuilder("@");
        }
        for (String field : fieldSet) {
            String goodsName;
            if ("price".equals(field)) {
                field = "unitprice";
            }
            if ("policycontants".equalsIgnoreCase(field)) {
                field = "zzstsgl";
            }
            Object value = redConfirmItem.get(field);
            if ("goodsname".equals(field) && (goodsName = String.valueOf(value)).charAt(0) == '*') {
                String subValue = goodsName.substring(1, goodsName.length() - 1);
                int i = subValue.indexOf(42) + 2;
                value = goodsName.substring(i, goodsName.length());
            }
            if (value instanceof BigDecimal) {
                value = ((BigDecimal)value).stripTrailingZeros().toPlainString();
            }
            start.append(this.simpleValue(value)).append('@');
        }
        return start.toString();
    }

    private Object simpleValue(Object value) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).stripTrailingZeros();
        }
        return value;
    }

    private List<QFilter> getqFilters(MatchRedConfirmBillDTO dto) {
        String blueInvoiceNo;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        String blueInvoiceCode = dto.getBlueInvoiceCode();
        if (StringUtils.isNotBlank((CharSequence)blueInvoiceCode)) {
            qFilters.add(new QFilter("originalinvoicecode", "=", (Object)blueInvoiceCode));
        }
        if (StringUtils.isNotBlank((CharSequence)(blueInvoiceNo = dto.getBlueInvoiceNo()))) {
            qFilters.add(new QFilter("originalinvoiceno", "=", (Object)blueInvoiceNo));
        }
        String buyerName = dto.getBuyerName();
        qFilters.add(new QFilter("buyername", "=", (Object)buyerName));
        String buyerTaxNo = dto.getBuyerTaxNo();
        if (StringUtils.isNotBlank((CharSequence)buyerTaxNo)) {
            qFilters.add(new QFilter("buyertaxno", "=", (Object)buyerTaxNo));
        }
        String salerTaxNo = dto.getSalerTaxNo();
        qFilters.add(new QFilter("salertaxno", "=", (Object)salerTaxNo));
        String invoiceType = dto.getInvoiceType();
        if (InvoiceUtils.isNormalInvoice((String)invoiceType) || InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
            qFilters.add(new QFilter("invoicetype", "=", (Object)InvoiceType.ALL_E_NORMAL.getTypeCode()));
        } else {
            qFilters.add(new QFilter("invoicetype", "=", (Object)InvoiceType.ALL_E_SPECIAL.getTypeCode()));
        }
        BigDecimal totalAmount = dto.getTotalAmount();
        qFilters.add(new QFilter("totalamount", "<=", (Object)totalAmount));
        DynamicObject matchRedConfirmConfig = dto.getMatchConfig();
        String uploadTime = matchRedConfirmConfig.getString("uploadtime");
        QFilter uploadTimeFilter = this.getUploadFilter(uploadTime);
        QFilter confirmStateFilter = this.getConfirmStateFilter(matchRedConfirmConfig);
        QFilter sourceFilter = this.getSourceFilter(matchRedConfirmConfig);
        if (!"1".equals(ImcConfigUtil.getValue((String)"matchRedConfirm", (String)"containsBuyerApply"))) {
            QFilter applicantFilter = new QFilter("applicant", "=", (Object)"1");
            qFilters.add(applicantFilter);
        }
        QFilter occupyFilter = new QFilter("occupystatus", "!=", (Object)"1");
        QFilter notIssueFilter = new QFilter("issuestatus", "=", (Object)"2");
        String redReason = InvoiceUtils.matchRedConfirmRedReason((String)dto.getRedreason());
        if (StringUtils.isNotBlank((CharSequence)redReason)) {
            QFilter redReasonFilter = new QFilter("redreason", "=", (Object)redReason);
            qFilters.add(redReasonFilter);
        }
        Collections.addAll(qFilters, uploadTimeFilter, confirmStateFilter, sourceFilter, occupyFilter, notIssueFilter);
        return qFilters;
    }

    private QFilter getSourceFilter(DynamicObject matchRedConfirmConfig) {
        ArrayList<String> sources = new ArrayList<String>(8);
        if (matchRedConfirmConfig.getBoolean("taxdownload")) {
            sources.add("2");
        }
        if (matchRedConfirmConfig.getBoolean("new")) {
            sources.add("1");
        }
        if (matchRedConfirmConfig.getBoolean("apiinterface")) {
            sources.add("4");
        }
        return new QFilter("source", "in", sources);
    }

    private QFilter getConfirmStateFilter(DynamicObject matchRedConfirmConfig) {
        ArrayList<String> confirmStates = new ArrayList<String>(8);
        if (matchRedConfirmConfig.getBoolean("noneedconfirm")) {
            confirmStates.add(RedConfirmStatusEnum.NO_CONFIRM.getBillCode());
        }
        if (matchRedConfirmConfig.getBoolean("bothconfirm")) {
            confirmStates.add(RedConfirmStatusEnum.ALL_CONFIRM.getBillCode());
        }
        if (matchRedConfirmConfig.getBoolean("buyerconfirm")) {
            confirmStates.add(RedConfirmStatusEnum.BUYER_CONFIRM.getBillCode());
        }
        if (matchRedConfirmConfig.getBoolean("salerconfrim")) {
            confirmStates.add(RedConfirmStatusEnum.SELLER_CONFIRM.getBillCode());
        }
        return new QFilter("confirmstatus", "in", confirmStates);
    }

    private QFilter getUploadFilter(String uploadTime) {
        Calendar instance = Calendar.getInstance();
        if ("1".equals(uploadTime)) {
            instance.add(5, -7);
            return new QFilter("uploaddate", ">=", (Object)instance.getTime());
        }
        if ("2".equals(uploadTime)) {
            instance.add(2, -1);
            return new QFilter("uploaddate", ">=", (Object)instance.getTime());
        }
        instance.add(5, -3);
        return new QFilter("uploaddate", ">=", (Object)instance.getTime());
    }

    private void matchRedConfirmByRedConfirmBillNo(List<MatchRedConfirmBillDTO> dtos, Set<Long> matchedMatchBillPks, Map<Long, DynamicObject> occupiedRedConfirmPkMap) {
        QFilter redConfirmFilter = null;
        for (MatchRedConfirmBillDTO dto : dtos) {
            if (!StringUtils.isNotBlank((CharSequence)dto.getRedConfirmNumber())) continue;
            redConfirmFilter = redConfirmFilter != null ? redConfirmFilter.or(new QFilter("number", "=", (Object)dto.getRedConfirmNumber()).and(ImcBaseDataHelper.getRedConfirmFilter((Object)dto.getOrgId()))) : new QFilter("number", "=", (Object)dto.getRedConfirmNumber()).and(ImcBaseDataHelper.getRedConfirmFilter((Object)dto.getOrgId()));
            matchedMatchBillPks.add(dto.getMergebillId());
        }
        if (null != redConfirmFilter) {
            DynamicObject[] redConfirms;
            String loadFields = String.join((CharSequence)",", "number", "originalinvoicecode", "originalinvoiceno", "originalissuetime", "totalamount", "invoiceamount", "number", "occupystatus");
            loadFields = loadFields + this.getItemFields("items", "goodsname");
            for (DynamicObject redConfirm : redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)loadFields, (QFilter[])redConfirmFilter.toArray())) {
                occupiedRedConfirmPkMap.put(redConfirm.getLong("id"), redConfirm);
            }
        }
    }

    private void fillItemMatchResultInfo(DynamicObject copyRedConfirmItem, MatchRedConfirmResultDTO matchResult, BigDecimal usedAmount, BigDecimal usedTax, BigDecimal usedNum) {
        matchResult.setRedConfirmItemPk(Long.valueOf(copyRedConfirmItem.getLong("id")));
        matchResult.setOriItemNum(usedNum);
        matchResult.setOriItemAmount(usedAmount);
        matchResult.setOriItemTax(usedTax);
    }

    private MatchRedConfirmResultDTO generateBaseResultFromRedConfirm(DynamicObject redConfirm, MatchRedConfirmBillItemDTO item, DynamicObject copyRedConfirmItem) {
        MatchRedConfirmResultDTO dto = new MatchRedConfirmResultDTO();
        dto.setRedConfirmPk(Long.valueOf(redConfirm.getLong("id")));
        dto.setBlueInvoiceCode(redConfirm.getString("originalinvoicecode"));
        dto.setBlueInvoiceNo(redConfirm.getString("originalinvoiceno"));
        dto.setRedConfirmItemPk(Long.valueOf(copyRedConfirmItem.getLong("id")));
        dto.setInfocode(redConfirm.getString("number"));
        dto.setConfirmOriItemSeq(Long.valueOf(copyRedConfirmItem.getLong("originseq")));
        dto.setOriItemTaxUnitprice(copyRedConfirmItem.getBigDecimal("taxunitprice"));
        dto.setOriItemUnitprice(copyRedConfirmItem.getBigDecimal("unitprice"));
        dto.setOriitemGoodsName(copyRedConfirmItem.getString("goodsname"));
        dto.setOriItemUnit(copyRedConfirmItem.getString("specification"));
        dto.setOriTaxRate(copyRedConfirmItem.getString("taxrate"));
        dto.setOriItemSpecification(copyRedConfirmItem.getString("specification"));
        dto.setConfirmIssueStatus("2");
        dto.setNewMatchInfo(true);
        return dto;
    }

    private String getItemFields(String itemKey, String ... itemFields) {
        StringBuilder builder = new StringBuilder(",");
        int length = itemFields.length;
        for (int i = 0; i < length; ++i) {
            if (i != length - 1) {
                builder.append(itemKey).append('.').append(itemFields[i]).append(',');
                continue;
            }
            builder.append(itemKey).append('.').append(itemFields[i]);
        }
        return builder.toString();
    }

    public DynamicObject createMatchBillFromOriginalBill(DynamicObject mergeBill, MatchRedConfirmBillDTO dto) {
        DynamicObject matchBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_match_bill");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)mergeBill, (DynamicObject)matchBill, (boolean)false, (boolean)true, (boolean)true);
        matchBill.set("id", (Object)dto.getMergebillId());
        matchBill.set("billno", (Object)this.getMergeBillNoFirst(mergeBill.getString("billno")));
        matchBill.set("billstatus", (Object)BillStatusEnum.AUDIT_SUCCESS.getCode());
        matchBill.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        matchBill.set("org", mergeBill.get("orgid"));
        matchBill.set("applyamount", mergeBill.get("invoiceamount"));
        matchBill.set("applytax", mergeBill.get("totaltax"));
        matchBill.set("applytotalamount", mergeBill.get("totalamount"));
        matchBill.set("matchconfig", (Object)dto.getMatchConfig());
        matchBill.set("redreason", (Object)dto.getRedreason());
        matchBill.set("matchtype", (Object)"1");
        matchBill.set("remark", (Object)mergeBill.getString("invoiceremark"));
        matchBill.set("matchbatch", (Object)RedConfirmMatchHelper.createMatchBatch());
        matchBill.set("matchtime", (Object)new Date());
        List matchItems = dto.getItems();
        DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        items.clear();
        for (int i = 0; i < matchItems.size(); ++i) {
            MatchRedConfirmBillItemDTO matchItem = (MatchRedConfirmBillItemDTO)matchItems.get(i);
            DynamicObject item = items.addNew();
            item.set("id", (Object)matchItem.getMatchOrMergeItemId());
            item.set("seq", (Object)(i + 1));
            item.set("goodsname", (Object)matchItem.getGoodsname());
            item.set("spbm", (Object)matchItem.getSpbm());
            item.set("goodscode", (Object)matchItem.getGoodscode());
            item.set("specification", (Object)matchItem.getSpecification());
            item.set("unit", (Object)matchItem.getUnit());
            item.set("num", (Object)matchItem.getNum());
            item.set("taxrate", (Object)matchItem.getTaxRate());
            item.set("unitprice", (Object)matchItem.getUnitprice());
            item.set("taxunitprice", (Object)matchItem.getTaxUnitPrice());
            item.set("amount", (Object)matchItem.getAmount());
            item.set("tax", (Object)matchItem.getTax());
            item.set("itemmatchstatus", (Object)matchItem.getItemMatchStatus());
            DynamicObjectCollection subEntryEntitys = item.getDynamicObjectCollection("confirmsubentryentity");
            List matchResult = matchItem.getMatchResult();
            if (null == matchResult) continue;
            for (MatchRedConfirmResultDTO resultDto : matchResult) {
                this.createRedConfirmItem(subEntryEntitys, resultDto);
            }
        }
        this.countMatchBillAmountAndStatus(matchBill);
        return matchBill;
    }

    public void countMatchBillAmountAndStatus(DynamicObject matchBill) {
        DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        BigDecimal totalMatchAmount = BigDecimal.ZERO;
        BigDecimal totalMatchTax = BigDecimal.ZERO;
        HashSet<String> redConfirmNumSet = new HashSet<String>();
        for (DynamicObject item : items) {
            BigDecimal amount = item.getBigDecimal("amount");
            BigDecimal tax = item.getBigDecimal("tax");
            DynamicObjectCollection subColletion = item.getDynamicObjectCollection("confirmsubentryentity");
            BigDecimal totalItemMatchAmount = BigDecimal.ZERO;
            BigDecimal totalItemMatchTax = BigDecimal.ZERO;
            for (DynamicObject subItem : subColletion) {
                totalMatchAmount = totalMatchAmount.add(subItem.getBigDecimal("confirmoriitemamount"));
                totalMatchTax = totalMatchTax.add(subItem.getBigDecimal("confirmoriitemtax"));
                totalItemMatchAmount = totalItemMatchAmount.add(subItem.getBigDecimal("confirmoriitemamount"));
                totalItemMatchTax = totalItemMatchTax.add(subItem.getBigDecimal("confirmoriitemtax"));
                if (!StringUtils.isNotBlank((CharSequence)subItem.getString("confirminfocode"))) continue;
                redConfirmNumSet.add(subItem.getString("confirminfocode"));
            }
            if (amount.compareTo(totalItemMatchAmount) == 0 && tax.compareTo(totalItemMatchTax) == 0) {
                item.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
                continue;
            }
            if (BigDecimalUtil.compareZero((BigDecimal)totalItemMatchAmount) && BigDecimalUtil.compareZero((BigDecimal)totalItemMatchTax)) {
                item.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode());
                continue;
            }
            item.set("itemmatchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
        }
        matchBill.set("matchamount", (Object)totalMatchAmount);
        matchBill.set("matchtax", (Object)totalMatchTax);
        matchBill.set("matchtotalamount", (Object)totalMatchAmount.add(totalMatchTax));
        matchBill.set("matchtarget", (Object)"1");
        matchBill.set("matchtype", (Object)"1");
        matchBill.set("matchinvoicenum", (Object)redConfirmNumSet.size());
        if (redConfirmNumSet.size() == 0) {
            matchBill.set("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_FAIL.getCode());
        } else if (matchBill.getBigDecimal("applyamount").compareTo(matchBill.getBigDecimal("matchamount")) == 0) {
            matchBill.set("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode());
        } else {
            matchBill.set("matchstatus", (Object)MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode());
        }
    }

    public void updateMatchBillFromMatchDTO(DynamicObject matchBill, MatchRedConfirmBillDTO dto) {
        ArrayList<MatchRedConfirmBillDTO> dtos = new ArrayList<MatchRedConfirmBillDTO>();
        dtos.add(dto);
        ArrayList<DynamicObject> matchBills = new ArrayList<DynamicObject>();
        matchBills.add(matchBill);
        this.fillMatchBillFromMatchResult(matchBills, dtos);
    }

    private String getMergeBillNoFirst(String billNo) {
        try {
            String[] billNos = billNo.split(",");
            return billNos[0];
        }
        catch (Exception e) {
            return billNo;
        }
    }
}

