/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm.control;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.file.util.Handle;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;

public class RedConfirmBillAddControl {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editNum(AbstractFormPlugin plugin, int editIndex, BigDecimal newNum, BigDecimal oldValue) {
        plugin.getView().getModel().beginInit();
        IFormView view = plugin.getView();
        try {
            BigDecimal tax;
            String taxRate;
            Object applicant = view.getModel().getValue("applicant");
            boolean saleApplicant = RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant);
            BigDecimal taxUnitPrice = (BigDecimal)view.getModel().getValue("taxunitprice", editIndex);
            BigDecimal unitPrice = (BigDecimal)view.getModel().getValue("unitprice", editIndex);
            Object hsbz = view.getModel().getValue("hsbz");
            if (BigDecimalUtil.compareZero((BigDecimal)newNum)) {
                view.getModel().setValue("taxunitprice", (Object)BigDecimal.ZERO, editIndex);
                view.getModel().setValue("unitprice", (Object)BigDecimal.ZERO, editIndex);
                return;
            }
            if (BigDecimalUtil.greaterZero((BigDecimal)newNum)) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e0", (String)"RedConfirmBillAddControl_0", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
                view.getModel().setValue("num", (Object)oldValue, editIndex);
                return;
            }
            BigDecimal itemTaxAmount = BigDecimal.ZERO;
            BigDecimal itemAmount = BigDecimal.ZERO;
            if ("1".equals(hsbz)) {
                if (BigDecimalUtil.compareZero((BigDecimal)taxUnitPrice)) {
                    itemTaxAmount = (BigDecimal)view.getModel().getValue("taxamount", editIndex);
                    itemAmount = (BigDecimal)view.getModel().getValue("amount", editIndex);
                    if (!BigDecimalUtil.compareZero((BigDecimal)itemTaxAmount)) {
                        taxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)itemTaxAmount, (BigDecimal)newNum, (boolean)true);
                        view.getModel().setValue("taxunitprice", (Object)taxUnitPrice, editIndex);
                    }
                    if (!BigDecimalUtil.compareZero((BigDecimal)itemAmount)) {
                        unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)itemAmount, (BigDecimal)newNum, (boolean)true);
                        view.getModel().setValue("unitprice", (Object)unitPrice, editIndex);
                    }
                } else {
                    taxUnitPrice = (BigDecimal)view.getModel().getValue("taxunitprice");
                    unitPrice = (BigDecimal)view.getModel().getValue("unitprice");
                    itemTaxAmount = taxUnitPrice.multiply(newNum).setScale(2, RoundingMode.HALF_UP);
                    view.getModel().setValue("taxamount", (Object)itemTaxAmount, editIndex);
                    if (!BigDecimalUtil.compareZero((BigDecimal)unitPrice)) {
                        itemAmount = unitPrice.multiply(newNum).setScale(2, RoundingMode.HALF_UP);
                        view.getModel().setValue("amount", (Object)itemAmount, editIndex);
                    }
                }
            } else if (BigDecimalUtil.compareZero((BigDecimal)unitPrice)) {
                itemTaxAmount = (BigDecimal)view.getModel().getValue("taxamount", editIndex);
                itemAmount = (BigDecimal)view.getModel().getValue("amount", editIndex);
                if (!BigDecimalUtil.compareZero((BigDecimal)itemTaxAmount)) {
                    taxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)itemTaxAmount, (BigDecimal)newNum, (boolean)true);
                    view.getModel().setValue("taxunitprice", (Object)taxUnitPrice, editIndex);
                }
                if (!BigDecimalUtil.compareZero((BigDecimal)itemAmount)) {
                    unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)itemAmount, (BigDecimal)newNum, (boolean)true);
                    view.getModel().setValue("unitprice", (Object)unitPrice, editIndex);
                }
            } else {
                unitPrice = (BigDecimal)view.getModel().getValue("unitprice");
                itemAmount = unitPrice.multiply(newNum).setScale(2, RoundingMode.HALF_UP);
                view.getModel().setValue("amount", (Object)itemAmount, editIndex);
                taxRate = (String)view.getModel().getValue("taxrate");
                if (StringUtils.isNotBlank((CharSequence)taxRate)) {
                    tax = itemAmount.multiply(new BigDecimal(taxRate)).setScale(2, RoundingMode.HALF_UP);
                    itemTaxAmount = itemAmount.add(tax);
                    if (!saleApplicant) {
                        taxUnitPrice = PriceHelper.getValue((BigDecimal)unitPrice.multiply(BigDecimal.ONE.add(new BigDecimal(taxRate))), (boolean)true);
                        view.getModel().setValue("taxunitprice", (Object)taxUnitPrice, editIndex);
                    }
                    view.getModel().setValue("taxamount", (Object)itemTaxAmount, editIndex);
                    view.getModel().setValue("tax", (Object)tax, editIndex);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(taxRate = (String)view.getModel().getValue("taxrate", editIndex)))) {
                tax = BigDecimal.ZERO;
                if (!BigDecimalUtil.compareZero((BigDecimal)itemTaxAmount) && !BigDecimalUtil.compareZero((BigDecimal)itemAmount)) {
                    tax = itemTaxAmount.subtract(itemAmount);
                }
                if (null != itemAmount && !BigDecimalUtil.compareZero((BigDecimal)itemAmount) && BigDecimalUtil.compareZero((BigDecimal)itemTaxAmount)) {
                    tax = itemAmount.multiply(new BigDecimal(taxRate)).setScale(2, RoundingMode.HALF_UP);
                    itemTaxAmount = tax.add(itemAmount);
                    view.getModel().setValue("taxamount", (Object)itemTaxAmount, editIndex);
                    if (!saleApplicant) {
                        taxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)itemTaxAmount, (BigDecimal)newNum, (boolean)true);
                        view.getModel().setValue("taxunitprice", (Object)taxUnitPrice, editIndex);
                    }
                }
                if (BigDecimalUtil.compareZero((BigDecimal)itemAmount) && !BigDecimalUtil.compareZero((BigDecimal)itemTaxAmount)) {
                    itemAmount = itemTaxAmount.divide(BigDecimal.ONE.add(new BigDecimal(taxRate)), 2, RoundingMode.HALF_UP);
                    tax = itemTaxAmount.subtract(itemAmount);
                    view.getModel().setValue("amount", (Object)itemAmount, editIndex);
                    if (!saleApplicant) {
                        unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)itemAmount, (BigDecimal)newNum, (boolean)true);
                        view.getModel().setValue("unitprice", (Object)unitPrice, editIndex);
                    }
                }
                view.getModel().setValue("tax", (Object)tax, editIndex);
            }
        }
        finally {
            view.getModel().endInit();
        }
        RedConfirmBillAddControl.updateField(plugin, editIndex, null);
        RedConfirmBillAddControl.countHeadAmount(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editAmount(AbstractFormPlugin plugin, int editIndex, BigDecimal newAmount, BigDecimal oldAmount) {
        IFormView view = plugin.getView();
        view.getModel().beginInit();
        try {
            String taxRate;
            BigDecimal unitPrice;
            if (BigDecimalUtil.compareZero((BigDecimal)newAmount)) {
                view.getModel().setValue("num", (Object)BigDecimal.ZERO, editIndex);
                view.getModel().setValue("tax", (Object)BigDecimal.ZERO, editIndex);
                view.getModel().setValue("taxamount", (Object)BigDecimal.ZERO, editIndex);
                return;
            }
            if (BigDecimalUtil.greaterZero((BigDecimal)newAmount)) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u660e\u7ec6\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e0", (String)"RedConfirmBillAddControl_1", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
                view.getModel().setValue("amount", (Object)oldAmount, editIndex);
                return;
            }
            QFilter qFilter = new QFilter("items.id", "=", view.getModel().getValue("originalinvoiceitemid"));
            DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"items.itemremainredamount", (QFilter[])qFilter.toArray());
            if (blueInvoice != null) {
                DynamicObjectCollection items = blueInvoice.getDynamicObjectCollection("items");
                for (DynamicObject item : items) {
                    BigDecimal itemRemainAmount;
                    if (!item.getPkValue().equals(view.getModel().getValue("originalinvoiceitemid")) || (itemRemainAmount = item.getBigDecimal("itemremainredamount")).add(newAmount).compareTo(BigDecimal.ZERO) >= 0) continue;
                    plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u7ea2\u5b57\u786e\u8ba4\u5355\u660e\u7ec6\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u539f\u84dd\u7968\u660e\u7ec6\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d%s", (String)"RedConfirmBillAddControl_7", (String)"imc-sim-service", (Object[])new Object[0]), editIndex + 1, itemRemainAmount.stripTrailingZeros()), Integer.valueOf(5000));
                    view.getModel().setValue("amount", (Object)oldAmount, editIndex);
                    return;
                }
            }
            if (!BigDecimalUtil.compareZero((BigDecimal)(unitPrice = (BigDecimal)view.getModel().getValue("unitprice", editIndex)))) {
                BigDecimal num = PriceHelper.calcPriceOrNum((BigDecimal)newAmount, (BigDecimal)unitPrice, (boolean)true);
                view.getModel().setValue("num", (Object)num, editIndex);
            }
            if (StringUtils.isNotBlank((CharSequence)(taxRate = (String)view.getModel().getValue("taxrate", editIndex)))) {
                BigDecimal tax = newAmount.multiply(new BigDecimal(taxRate)).setScale(2, RoundingMode.HALF_UP);
                BigDecimal itemTaxAmount = newAmount.add(tax);
                view.getModel().setValue("tax", (Object)tax, editIndex);
                view.getModel().setValue("taxamount", (Object)itemTaxAmount, editIndex);
            }
        }
        finally {
            view.getModel().endInit();
        }
        RedConfirmBillAddControl.updateField(plugin, editIndex, null);
        RedConfirmBillAddControl.countHeadAmount(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editUnitPrice(AbstractFormPlugin plugin, int editIndex, BigDecimal newUnitPrice, BigDecimal oldUnitPrice) {
        IFormView view = plugin.getView();
        view.getModel().beginInit();
        try {
            if (BigDecimalUtil.compareZero((BigDecimal)newUnitPrice)) {
                view.getModel().setValue("taxunitprice", (Object)BigDecimal.ZERO, editIndex);
                view.getModel().setValue("num", (Object)BigDecimal.ZERO, editIndex);
                return;
            }
            if (BigDecimalUtil.lessZero((BigDecimal)newUnitPrice)) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u660e\u7ec6\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0", (String)"RedConfirmBillAddControl_2", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
                view.getModel().setValue("unitprice", (Object)oldUnitPrice, editIndex);
                return;
            }
            BigDecimal num = (BigDecimal)view.getModel().getValue("num", editIndex);
            String taxRate = (String)view.getModel().getValue("taxrate", editIndex);
            if (!BigDecimalUtil.compareZero((BigDecimal)num)) {
                BigDecimal itemAmount = newUnitPrice.multiply(num).setScale(2, RoundingMode.HALF_UP);
                if (StringUtils.isNotBlank((CharSequence)taxRate)) {
                    BigDecimal itemTax = itemAmount.multiply(new BigDecimal(taxRate)).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal itemTaxAmount = itemTax.add(itemAmount);
                    BigDecimal taxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)itemTaxAmount, (BigDecimal)num, (boolean)true);
                    view.getModel().setValue("taxunitprice", (Object)taxUnitPrice, editIndex);
                    view.getModel().setValue("taxamount", (Object)itemTaxAmount, editIndex);
                    view.getModel().setValue("tax", (Object)itemTax, editIndex);
                }
            } else {
                BigDecimal itemAmount = (BigDecimal)view.getModel().getValue("amount", editIndex);
                if (!BigDecimalUtil.compareZero((BigDecimal)itemAmount)) {
                    num = UnitPriceHelper.calcNum((BigDecimal)itemAmount, (BigDecimal)newUnitPrice);
                    view.getModel().setValue("num", (Object)num, editIndex);
                }
            }
        }
        finally {
            view.getModel().endInit();
        }
        RedConfirmBillAddControl.updateField(plugin, editIndex, null);
        RedConfirmBillAddControl.countHeadAmount(plugin);
    }

    public static void updateField(AbstractFormPlugin plugin, int editIndex, Set<String> fields) {
        if (null == fields) {
            fields = new HashSet<String>();
        }
        Collections.addAll(fields, "tax", "unitprice", "amount", "taxamount", "taxunitprice", "unitprice", "num");
        for (String field : fields) {
            plugin.getView().updateView(field, editIndex);
        }
    }

    public static void countHeadAmount(AbstractFormPlugin plugin) {
        IFormView view = plugin.getView();
        view.getModel().beginInit();
        DynamicObjectCollection itemList = view.getModel().getEntryEntity("items");
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (null != itemList) {
            for (DynamicObject item : itemList) {
                invoiceAmount = invoiceAmount.add(item.getBigDecimal("amount"));
                totalTax = totalTax.add(item.getBigDecimal("tax"));
                totalAmount = totalAmount.add(item.getBigDecimal("taxamount"));
            }
            view.getModel().setValue("totaltax", (Object)totalTax);
            view.getModel().setValue("totalamount", (Object)totalAmount);
            view.getModel().setValue("invoiceamount", (Object)invoiceAmount);
        }
        view.getModel().endInit();
        plugin.getView().updateView("totaltax");
        plugin.getView().updateView("totalamount");
        plugin.getView().updateView("invoiceamount");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editTaxRate(AbstractFormPlugin plugin, int editIndex, String taxRate) {
        IFormView view = plugin.getView();
        view.getModel().beginInit();
        try {
            if (StringUtils.isBlank((CharSequence)taxRate)) {
                return;
            }
            String hsbz = (String)view.getModel().getValue("hsbz");
            if ("1".equals(hsbz)) {
                BigDecimal taxAmount = (BigDecimal)view.getModel().getValue("taxamount", editIndex);
                if (BigDecimalUtil.compareZero((BigDecimal)taxAmount)) {
                    return;
                }
                BigDecimal itemAmount = taxAmount.divide(BigDecimal.ONE.add(new BigDecimal(taxRate)), 2, RoundingMode.HALF_UP);
                view.getModel().setValue("amount", (Object)itemAmount, editIndex);
                BigDecimal itemTax = taxAmount.subtract(itemAmount);
                view.getModel().setValue("tax", (Object)itemTax, editIndex);
                BigDecimal num = (BigDecimal)view.getModel().getValue("num", editIndex);
                if (!BigDecimalUtil.compareZero((BigDecimal)num)) {
                    BigDecimal unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)itemAmount, (BigDecimal)num, (boolean)true);
                    view.getModel().setValue("unitprice", (Object)unitPrice, editIndex);
                }
            } else {
                BigDecimal itemAmount = (BigDecimal)view.getModel().getValue("amount", editIndex);
                if (BigDecimalUtil.compareZero((BigDecimal)itemAmount)) {
                    return;
                }
                BigDecimal itemTax = itemAmount.multiply(new BigDecimal(taxRate)).setScale(2, RoundingMode.HALF_UP);
                BigDecimal taxAmount = itemTax.add(itemAmount);
                view.getModel().setValue("taxamount", (Object)taxAmount, editIndex);
                view.getModel().setValue("tax", (Object)itemTax, editIndex);
                BigDecimal num = (BigDecimal)view.getModel().getValue("num", editIndex);
                if (!BigDecimalUtil.compareZero((BigDecimal)num)) {
                    BigDecimal taxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)num, (boolean)true);
                    view.getModel().setValue("taxunitprice", (Object)taxUnitPrice, editIndex);
                }
            }
        }
        finally {
            view.getModel().endInit();
        }
        RedConfirmBillAddControl.updateField(plugin, editIndex, null);
        RedConfirmBillAddControl.countHeadAmount(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editTaxAmount(AbstractFormPlugin plugin, int editIndex, BigDecimal newTaxAmount, BigDecimal oldTaxAmount) {
        block12: {
            IFormView view = plugin.getView();
            view.getModel().beginInit();
            try {
                if (BigDecimalUtil.compareZero((BigDecimal)newTaxAmount)) {
                    view.getModel().setValue("num", (Object)BigDecimal.ZERO, editIndex);
                    view.getModel().setValue("tax", (Object)BigDecimal.ZERO, editIndex);
                    view.getModel().setValue("amount", (Object)BigDecimal.ZERO, editIndex);
                    return;
                }
                if (BigDecimalUtil.greaterZero((BigDecimal)newTaxAmount)) {
                    plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u660e\u7ec6\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e0", (String)"RedConfirmBillAddControl_3", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
                    view.getModel().setValue("taxamount", (Object)oldTaxAmount, editIndex);
                    return;
                }
                BigDecimal taxUnitPrice = (BigDecimal)view.getModel().getValue("taxunitprice", editIndex);
                BigDecimal num = (BigDecimal)view.getModel().getValue("num", editIndex);
                if (!BigDecimalUtil.compareZero((BigDecimal)taxUnitPrice)) {
                    num = UnitPriceHelper.calcNum((BigDecimal)newTaxAmount, (BigDecimal)taxUnitPrice);
                    view.getModel().setValue("num", (Object)num, editIndex);
                } else if (!BigDecimalUtil.compareZero((BigDecimal)num)) {
                    taxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)newTaxAmount, (BigDecimal)num, (boolean)true);
                    view.getModel().setValue("taxunitprice", (Object)taxUnitPrice);
                }
                String taxRate = (String)view.getModel().getValue("taxrate", editIndex);
                if (!StringUtils.isNotBlank((CharSequence)taxRate)) break block12;
                BigDecimal itemAmount = newTaxAmount.multiply(BigDecimal.ONE.divide(BigDecimal.ONE.add(new BigDecimal(taxRate)), 20, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
                QFilter qFilter = new QFilter("items.id", "=", view.getModel().getValue("originalinvoiceitemid"));
                DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"items.itemremainredamount", (QFilter[])qFilter.toArray());
                DynamicObjectCollection items = blueInvoice.getDynamicObjectCollection("items");
                for (DynamicObject item : items) {
                    BigDecimal itemRemainAmount;
                    if (!item.getPkValue().equals(view.getModel().getValue("originalinvoiceitemid")) || (itemRemainAmount = item.getBigDecimal("itemremainredamount")).add(itemAmount).compareTo(BigDecimal.ZERO) >= 0) continue;
                    plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u7ea2\u5b57\u786e\u8ba4\u5355\u660e\u7ec6\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u539f\u84dd\u7968\u660e\u7ec6\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d%s", (String)"RedConfirmBillAddControl_7", (String)"imc-sim-service", (Object[])new Object[0]), editIndex + 1, itemRemainAmount.stripTrailingZeros()), Integer.valueOf(5000));
                    view.getModel().setValue("taxamount", (Object)oldTaxAmount, editIndex);
                    return;
                }
                BigDecimal tax = newTaxAmount.subtract(itemAmount);
                view.getModel().setValue("tax", (Object)tax, editIndex);
                view.getModel().setValue("amount", (Object)itemAmount, editIndex);
            }
            finally {
                view.getModel().endInit();
            }
        }
        RedConfirmBillAddControl.updateField(plugin, editIndex, null);
        RedConfirmBillAddControl.countHeadAmount(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editTaxUnitPrice(AbstractFormPlugin plugin, int editIndex, BigDecimal newTaxUnitPrice, BigDecimal oldTaxUnitPrice) {
        IFormView view = plugin.getView();
        view.getModel().beginInit();
        try {
            if (BigDecimalUtil.compareZero((BigDecimal)newTaxUnitPrice)) {
                view.getModel().setValue("num", (Object)BigDecimal.ZERO, editIndex);
                view.getModel().setValue("unitprice", (Object)BigDecimal.ZERO, editIndex);
                return;
            }
            if (BigDecimalUtil.lessZero((BigDecimal)newTaxUnitPrice)) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u660e\u7ec6\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0", (String)"RedConfirmBillAddControl_4", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(3000));
                view.getModel().setValue("taxunitprice", (Object)oldTaxUnitPrice, editIndex);
                return;
            }
            BigDecimal num = (BigDecimal)view.getModel().getValue("num", editIndex);
            if (!BigDecimalUtil.compareZero((BigDecimal)num)) {
                BigDecimal itemTaxAmount = newTaxUnitPrice.multiply(num);
                view.getModel().setValue("taxamount", (Object)itemTaxAmount);
                String taxRate = (String)view.getModel().getValue("taxrate", editIndex);
                if (StringUtils.isNotBlank((CharSequence)taxRate)) {
                    BigDecimal itemAmount = itemTaxAmount.divide(BigDecimal.ONE.add(new BigDecimal(taxRate)), 2, RoundingMode.HALF_UP);
                    BigDecimal itemTax = itemTaxAmount.subtract(itemAmount);
                    BigDecimal unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)itemAmount, (BigDecimal)num, (boolean)true);
                    view.getModel().setValue("amount", (Object)itemAmount, editIndex);
                    view.getModel().setValue("tax", (Object)itemTax, editIndex);
                    view.getModel().setValue("unitprice", (Object)unitPrice, editIndex);
                }
            } else {
                BigDecimal itemTaxAmount = (BigDecimal)view.getModel().getValue("taxamount", editIndex);
                if (BigDecimalUtil.compareZero((BigDecimal)itemTaxAmount)) {
                    return;
                }
                num = UnitPriceHelper.calcNum((BigDecimal)itemTaxAmount, (BigDecimal)newTaxUnitPrice);
                BigDecimal itemAmount = (BigDecimal)view.getModel().getValue("amount", editIndex);
                BigDecimal itemPrice = PriceHelper.calcPriceOrNum((BigDecimal)itemAmount, (BigDecimal)num, (boolean)true);
                view.getModel().setValue("num", (Object)num, editIndex);
                view.getModel().setValue("unitprice", (Object)itemPrice, editIndex);
            }
        }
        finally {
            view.getModel().endInit();
        }
        RedConfirmBillAddControl.updateField(plugin, editIndex, null);
        RedConfirmBillAddControl.countHeadAmount(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editGoodsId(AbstractFormPlugin plugin, AfterF7SelectEvent event, int selectRow) {
        IFormView view = plugin.getView();
        if (event.getListSelectedRowCollection().size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5185\u5bb9", (String)"RedConfirmBillAddControl_5", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        DynamicObject goodsInfo = (DynamicObject)view.getModel().getValue("goodsid", selectRow);
        if (goodsInfo == null) {
            return;
        }
        view.getModel().beginInit();
        try {
            view.getModel().setValue("goodsname", (Object)goodsInfo.getString("name"), selectRow);
            view.getModel().setValue("specification", (Object)goodsInfo.getString("specifications"), selectRow);
            view.getModel().setValue("unit", (Object)goodsInfo.getString("unit"), selectRow);
            BigDecimal goodsInfoPrice = (BigDecimal)goodsInfo.get("price");
            Object goodsHsbz = goodsInfo.get("isinclusive");
            String hsbz = (String)view.getModel().getValue("hsbz");
            String taxRate = goodsInfo.getString("taxrate");
            view.getModel().setValue("taxrate", (Object)taxRate, selectRow);
            view.getModel().setValue("taxratecodeid", goodsInfo.get("taxcode"), selectRow);
            DynamicObject taxClassCode = TaxClassCodeCheckHelper.geTaxCodeById((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)goodsInfo.getDynamicObject("taxcode")));
            if (null == taxClassCode) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u6c47\u603b\u9879\u6216\u4e0d\u5b58\u5728", (String)"RedConfirmBillAddControl_6", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            view.getModel().setValue("goodscode", taxClassCode.get("mergecode"), selectRow);
            if (StringUtils.isNotBlank((Object)goodsHsbz) && !BigDecimalUtil.compareZero((BigDecimal)goodsInfoPrice)) {
                if ("1".equals(goodsHsbz) && "1".equals(hsbz)) {
                    view.getModel().setValue("taxunitprice", (Object)goodsInfoPrice, selectRow);
                    RedConfirmBillAddControl.editTaxUnitPrice(plugin, selectRow, goodsInfoPrice, BigDecimal.ZERO);
                } else if ("0".equals(goodsHsbz) && "0".equals(hsbz)) {
                    view.getModel().setValue("unitprice", (Object)goodsInfoPrice, selectRow);
                    RedConfirmBillAddControl.editUnitPrice(plugin, selectRow, goodsInfoPrice, BigDecimal.ZERO);
                } else if ("0".equals(goodsHsbz) && "1".equals(hsbz)) {
                    BigDecimal taxUnitPrice = PriceHelper.getValue((BigDecimal)goodsInfoPrice.multiply(BigDecimal.ONE.add(new BigDecimal(taxRate))), (boolean)true);
                    view.getModel().setValue("taxunitprice", (Object)taxUnitPrice);
                    RedConfirmBillAddControl.editTaxUnitPrice(plugin, selectRow, goodsInfoPrice, BigDecimal.ZERO);
                } else {
                    BigDecimal unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)goodsInfoPrice, (BigDecimal)BigDecimal.ONE.add(new BigDecimal(taxRate)), (boolean)true);
                    view.getModel().setValue("unitprice", (Object)unitPrice);
                    RedConfirmBillAddControl.editUnitPrice(plugin, selectRow, goodsInfoPrice, BigDecimal.ZERO);
                }
            }
        }
        finally {
            view.getModel().endInit();
        }
        HashSet<String> fields = new HashSet<String>();
        Collections.addAll(fields, "goodscode", "taxratecodeid", "taxrate", "unit", "specification", "goodsname");
        RedConfirmBillAddControl.updateField(plugin, selectRow, fields);
        RedConfirmBillAddControl.countHeadAmount(plugin);
    }

    public static void checkZZSTSGLNotNull(DynamicObjectCollection items) {
        for (int i = 0; i < items.size(); ++i) {
            String privilegeFlag = ((DynamicObject)items.get(i)).getString("taxpremark");
            String privilegeType = ((DynamicObject)items.get(i)).getString("zzstsgl");
            String rowtype = ((DynamicObject)items.get(i)).getString("rowtype");
            if (Handle.isEmpty((Object)rowtype) || "1".equals(rowtype) || Handle.isNotEmpty((Object)privilegeType) || Handle.isEmpty((Object)privilegeFlag) || !"1".equals(privilegeFlag)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u65f6\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RedConfirmBillAddDialogPlugin_18", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }
}

