/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.redconfirm.helper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.BillDetailVo;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseListDTO;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.model.DrawerInfo;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceQueryUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.lqpt.model.request.LqptRequest;
import kd.imc.bdm.lqpt.model.request.base.redconfirmapply.RedConfirmBillApplyRequest;
import kd.imc.bdm.lqpt.model.request.base.redconfirmapply.RedConfirmBillConfirmRequest;
import kd.imc.bdm.lqpt.model.request.base.redconfirmapply.RedConfirmBillItem;
import kd.imc.bdm.lqpt.model.request.base.redconfirmdownload.RedConfirmDetailRequest;
import kd.imc.bdm.lqpt.model.request.base.redconfirmdownload.RedConfirmDownloadHeadRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.base.redconfirmapply.RedConfirmBillApplyResponse;
import kd.imc.bdm.lqpt.model.response.base.redconfirmdownload.RedConfirmDetailItemResponse;
import kd.imc.bdm.lqpt.model.response.base.redconfirmdownload.RedConfirmDetailResponse;
import kd.imc.bdm.lqpt.model.response.base.redconfirmdownload.RedConfirmDownloadHeadResponse;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.sim.common.constant.OpenApiInterfaceCodeEnum;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.constant.RiskControlRecordConstant;
import kd.imc.sim.common.dto.allele.AllEleRedConfirmBillUploadResponseDTO;
import kd.imc.sim.common.dto.allele.issue.AllEleIssueItemRequestDTO;
import kd.imc.sim.common.dto.allele.issue.AllEleIssueRequestDTO;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadRequestDTO;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadResponseDTO;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmItemDownLoadResponseDTO;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmRefuseRequestDTO;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmRefuseResponseDTO;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.allele.ApiAllEHelper;
import kd.imc.sim.common.helper.allele.RedConfirmOriginalSeqHelper;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.model.invoice.IssueTypeEnum;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.service.issueinvoice.impl.AllEleIssueInvoiceImpl;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.ZeroTaxMarkUtil;
import kd.imc.sim.formplugin.risk.control.BillRiskControlService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class RedConfirmBillHelper {
    private static final Log logger = LogFactory.getLog(RedConfirmBillHelper.class);
    private static final ImmutableSet<String> validConfirmStatus = new ImmutableSet.Builder().add((Object[])new String[]{"05", "06", "07", "08", "09", "10"}).build();

    public static void openListPage(AbstractFormPlugin that, QFilter qFilter, String formId, String callBackKey, Map<String, Object> customParam, String caption) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)formId, (boolean)false);
        parameter.setLookUp(true);
        if (qFilter != null) {
            List filters = parameter.getListFilterParameter().getQFilters();
            filters.add(qFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)callBackKey)) {
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)that, callBackKey));
        }
        parameter.setCaption(caption);
        if (customParam != null) {
            parameter.setCustomParams(customParam);
        }
        that.getView().showForm((FormShowParameter)parameter);
    }

    public static void initRedConfirmBillFromInvoice(AbstractFormPlugin that, DynamicObject invoice, String billKey) {
        String invoiceType;
        IDataModel model = that.getView().getModel();
        model.setValue("ctrlstrategy", (Object)"7");
        model.setValue("issuestatus", (Object)"2");
        model.setValue("invoicetype", invoice.get("invoicetype"));
        model.setValue("originalinvoicecode", invoice.get("invoicecode"));
        model.setValue("originalinvoiceno", invoice.get("invoiceno"));
        model.setValue("originalinvoiceamount", invoice.get("invoiceamount"));
        model.setValue("originaltotaltax", invoice.get("totaltax"));
        model.setValue("originalissuetime", invoice.get("issuetime"));
        model.setValue("originalinvoicetype", invoice.get("invoicetype"));
        model.setValue("originalEtaxInvoiceNo", invoice.get("alletaxinvoiceno"));
        model.setValue("orderno", (Object)UUID.next());
        model.setValue("billno", invoice.get("billno"));
        model.setValue("buyerproperty", invoice.get("buyerproperty"));
        model.setValue("saleraddr", invoice.get("saleraddr"));
        model.setValue("salerbank", invoice.get("salerbank"));
        model.setValue("buyeraddr", invoice.get("buyeraddr"));
        model.setValue("buyerbank", invoice.get("buyerbank"));
        if ("02".equals(invoice.getString("specialtype"))) {
            model.setValue("salername", invoice.get("buyername"));
            model.setValue("salertaxno", invoice.get("buyertaxno"));
            model.setValue("buyername", invoice.get("salername"));
            model.setValue("buyertaxno", invoice.get("salertaxno"));
        } else {
            model.setValue("buyername", invoice.get("buyername"));
            model.setValue("buyertaxno", invoice.get("buyertaxno"));
            model.setValue("salername", invoice.get("salername"));
            model.setValue("salertaxno", invoice.get("salertaxno"));
        }
        model.setValue("hsbz", invoice.get("hsbz"));
        model.setValue("status", (Object)BillHelper.getBillStatusByTableName((String)"sim_red_confirm_bill", (String)"1"));
        model.setValue("iselepaper", (Object)invoice.getString("iselepaper"));
        model.setValue("buyerphone", (Object)invoice.getString("buyerphone"));
        model.setValue("buyeremail", (Object)invoice.getString("buyeremail"));
        String specialType = InvoiceSpecialType.InvoiceSpecialTypeEnum.getCodeBySpecialType((String)invoice.getString("specialtype"));
        if ("sim_vatinvoice".equals(billKey)) {
            model.setValue("specialtype", (Object)specialType);
            model.setValue("landtaxno", invoice.get("landtaxno"));
            model.setValue("simpleaddress", invoice.get("simpleaddress"));
            model.setValue("detailaddress", invoice.get("detailaddress"));
            model.setValue("startleasedate", invoice.get("startleasedate"));
            model.setValue("endleasedate", invoice.get("endleasedate"));
            model.setValue("buildingname", invoice.get("buildingname"));
            model.setValue("crosscitysign", invoice.get("crosscitysign"));
            model.setValue("estateid", invoice.get("estateid"));
            model.setValue("areaunit", invoice.get("areaunit"));
            model.setValue("approvedprice", invoice.get("approvedprice"));
            model.setValue("actualturnover", invoice.get("actualturnover"));
            model.setValue("estatecode", invoice.get("estatecode"));
            model.setValue("crosscitytaxverifyno", invoice.get("crosscitytaxverifyno"));
        }
        model.setValue("drawer", invoice.get("drawer"));
        model.setValue("payee", invoice.get("payee"));
        model.setValue("reviewer", invoice.get("reviewer"));
        if (EnterpriseHelper.isLqptChannel((String)model.getValue("salertaxno").toString())) {
            try {
                DrawerInfo drawerInfo;
                Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid"));
                if (null != orgId && StringUtils.isNotEmpty((CharSequence)(drawerInfo = DrawerStrategyHelper.getLeQiRedDrawerInfo((Long)orgId)).getDrawer())) {
                    model.setValue("drawer", (Object)drawerInfo.getDrawer());
                }
            }
            catch (Exception e) {
                logger.error("LeQi Set Drawer Error", (Throwable)e);
            }
        }
        model.setValue("systemsource", (Object)invoice.getString("systemsource"));
        boolean saleDiscounts = RedConfirmBillHelper.checkSalesDiscounts(invoice.getString("invoicecode"), invoice.getString("invoiceno"));
        Object applicant = model.getValue("applicant");
        boolean buyer = !RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant);
        model.setValue("enteridentity", (Object)(buyer ? "1" : "0"));
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
        int size = items.size();
        boolean startZero = "sim_vatinvoice".equals(billKey) && RedConfirmBillHelper.checkOriginalInvoiceStartZero(invoice.getString("invoicecode"), invoice.getString("invoiceno"));
        for (int i = 0; i < size; ++i) {
            BigDecimal num;
            BigDecimal taxAmount;
            DynamicObject disItem;
            DynamicObject item = (DynamicObject)items.get(i);
            String rowType = item.getString("rowtype");
            if ("1".equals(rowType)) continue;
            BigDecimal unitPrice = item.getBigDecimal("unitprice");
            BigDecimal taxUnitPrice = item.getBigDecimal("taxunitprice");
            BigDecimal oriNum = item.getBigDecimal("num");
            BigDecimal tax = item.getBigDecimal("itemremainredtax").negate();
            BigDecimal amount = item.getBigDecimal("itemremainredamount").negate();
            if (buyer) {
                tax = item.getBigDecimal("tax").negate();
                amount = item.getBigDecimal("amount").negate();
            }
            if ("2".equals(rowType) && i + 1 < size && "1".equals((disItem = (DynamicObject)items.get(i + 1)).getString("rowtype"))) {
                BigDecimal amountT = item.getBigDecimal("amount").abs().subtract(disItem.getBigDecimal("amount").abs());
                BigDecimal taxAmountT = item.getBigDecimal("taxamount").abs().subtract(disItem.getBigDecimal("taxamount").abs());
                if (buyer) {
                    amount = amountT.negate();
                    tax = item.getBigDecimal("tax").abs().subtract(disItem.getBigDecimal("tax").abs()).negate();
                }
                unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)amountT, (BigDecimal)oriNum, (boolean)Boolean.TRUE);
                taxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)taxAmountT, (BigDecimal)oriNum, (boolean)Boolean.TRUE);
            }
            if (MathUtils.isZero((BigDecimal)(taxAmount = amount.add(tax)))) continue;
            BigDecimal bigDecimal = num = buyer ? item.getBigDecimal("num") : item.getBigDecimal("itemremainrednum");
            if (MathUtils.isNullOrZero((BigDecimal)num)) {
                num = item.getBigDecimal("num");
            }
            if (MathUtils.isNotZero((BigDecimal)num)) {
                num = num.negate();
                if (saleDiscounts) {
                    unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)amount, (BigDecimal)num, (boolean)Boolean.TRUE);
                    taxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)num, (boolean)Boolean.TRUE);
                }
            }
            int index = that.getView().getModel().createNewEntryRow("items");
            model.setValue("originseq", (Object)(startZero ? item.getInt("seq") + 1 : item.getInt("seq")), index);
            model.setValue("goodsname", item.get("goodsname"), index);
            model.setValue("specification", item.get("specification"), index);
            model.setValue("unit", item.get("unit"), index);
            model.setValue("num", (Object)num, index);
            model.setValue("unitprice", (Object)unitPrice, index);
            model.setValue("taxunitprice", (Object)taxUnitPrice, index);
            model.setValue("amount", (Object)amount, index);
            model.setValue("tax", (Object)tax, index);
            model.setValue("taxamount", (Object)taxAmount, index);
            model.setValue("taxrate", item.get("taxrate"), index);
            model.setValue("goodscode", item.get("goodscode"), index);
            model.setValue("rowtype", (Object)"0", index);
            model.setValue("billsourceid", item.get("billsourceid"), index);
            model.setValue("originalinvoiceitemid", item.get("id"), index);
            model.setValue("taxpremark", item.get("taxpremark"), index);
            model.setValue("zzstsgl", item.get("zzstsgl"), index);
            totalAmount = totalAmount.add(amount);
            totalTax = totalTax.add(tax);
            totalTaxAmount = totalTaxAmount.add(taxAmount);
        }
        if (buyer) {
            totalAmount = invoice.getBigDecimal("invoiceamount").negate();
            totalTax = invoice.getBigDecimal("totaltax").negate();
            totalTaxAmount = invoice.getBigDecimal("totalamount").negate();
        }
        model.setValue("invoiceamount", (Object)totalAmount);
        model.setValue("totaltax", (Object)totalTax);
        model.setValue("totalamount", (Object)totalTaxAmount);
        if (StringUtils.equals((CharSequence)specialType, (CharSequence)"E04")) {
            DynamicObjectCollection freights = invoice.getDynamicObjectCollection("freights");
            RedConfirmBillHelper.setFreightsForView(that, model, freights);
        }
        if (StringUtils.equals((CharSequence)specialType, (CharSequence)"E09")) {
            DynamicObjectCollection travelerCollection = invoice.getDynamicObjectCollection("travelers");
            RedConfirmBillHelper.setTravelersForView(that, model, travelerCollection);
        }
        if (StringUtils.equals((CharSequence)specialType, (CharSequence)"E07")) {
            DynamicObjectCollection vesselVehicheCollection = invoice.getDynamicObjectCollection("vehichevesselships");
            RedConfirmBillHelper.setVesselVehicheShipForView(that, model, vesselVehicheCollection);
        }
        if (InvoiceUtils.isNormalInvoice((String)(invoiceType = (String)invoice.get("invoicetype")))) {
            model.setValue("invoicetype", (Object)InvoiceType.ALL_E_NORMAL.getTypeCode());
        } else if (InvoiceUtils.isSpecialInvoice((String)invoiceType)) {
            model.setValue("invoicetype", (Object)InvoiceType.ALL_E_SPECIAL.getTypeCode());
        }
    }

    private static void setTravelersForView(AbstractFormPlugin that, IDataModel model, DynamicObjectCollection travelerCollection) {
        if (null == travelerCollection || travelerCollection.isEmpty()) {
            return;
        }
        that.getView().getModel().beginInit();
        travelerCollection.forEach(travelerObject -> {
            int index = that.getView().getModel().createNewEntryRow("travelers");
            model.setValue("traveler", travelerObject.get("traveler"), index);
            model.setValue("travelercardtype", travelerObject.get("travelercardtype"), index);
            model.setValue("travelercardno", travelerObject.get("travelercardno"), index);
            model.setValue("traveldate", travelerObject.get("traveldate"), index);
            model.setValue("travelerstartplace", travelerObject.get("travelerstartplace"), index);
            model.setValue("travelerendplace", travelerObject.get("travelerendplace"), index);
            model.setValue("travelertransporttype", travelerObject.get("travelertransporttype"), index);
            model.setValue("travelerseatclass", travelerObject.get("travelerseatclass"), index);
        });
        that.getView().getModel().endInit();
        that.getView().updateView("travelers");
    }

    private static void setVesselVehicheShipForView(AbstractFormPlugin that, IDataModel model, DynamicObjectCollection vesselVehicheCollection) {
        if (null == vesselVehicheCollection || vesselVehicheCollection.isEmpty()) {
            return;
        }
        that.getView().getModel().beginInit();
        vesselVehicheCollection.forEach(vesselShipObject -> {
            int index = that.getView().getModel().createNewEntryRow("vehichevesselships");
            model.setValue("policyno", vesselShipObject.get("policyno"), index);
            model.setValue("vehiclecode", vesselShipObject.get("vehiclecode"), index);
            model.setValue("periodstartdate", vesselShipObject.get("periodstartdate"), index);
            model.setValue("periodenddate", vesselShipObject.get("periodenddate"), index);
            model.setValue("perioddate", vesselShipObject.get("perioddate"), index);
            model.setValue("shipsno", vesselShipObject.get("shipsno"), index);
            model.setValue("vehiclelateamount", vesselShipObject.get("vehiclelateamount"), index);
            model.setValue("vehiclevesselamount", vesselShipObject.get("vehiclevesselamount"), index);
            model.setValue("vehicletotalamount", vesselShipObject.get("vehicletotalamount"), index);
        });
        that.getView().getModel().endInit();
        that.getView().updateView("vehichevesselships");
    }

    private static void setFreightsForView(AbstractFormPlugin that, IDataModel model, DynamicObjectCollection freights) {
        if (null == freights || freights.isEmpty()) {
            return;
        }
        freights.forEach(freightObj -> {
            int index = that.getView().getModel().createNewEntryRow("freights");
            model.setValue("transporttype", freightObj.get("transporttype"), index);
            model.setValue("licenseplate", freightObj.get("licenseplate"), index);
            model.setValue("startplace", freightObj.get("startplace"), index);
            model.setValue("endplace", freightObj.get("endplace"), index);
            model.setValue("transportgoods", freightObj.get("transportgoods"), index);
        });
    }

    public static DynamicObject createWaitInvoice(DynamicObject redConfirmBill) {
        String redConfirmNumber = redConfirmBill.getString("number");
        String sellerTaxNo = redConfirmBill.getString("salertaxno");
        String lockKey = sellerTaxNo + redConfirmNumber;
        Throwable throwable = null;
        try (DLock dLock = DLock.create((String)lockKey);){
            if (dLock.tryLock(20L)) {
                if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)("issueRedConfirmCache" + lockKey)))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355%s\u5728\u5f00\u7968\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"RedConfirmBillHelper_17", (String)"imc-sim-service", (Object[])new Object[0]), redConfirmNumber));
                }
                CacheHelper.put((String)("issueRedConfirmCache" + lockKey), (String)lockKey, (int)20);
                DynamicObject waitInvoice = RedConfirmBillHelper.getInvoiceFromRedConfirm(redConfirmBill);
                if (waitInvoice != null) {
                    waitInvoice = BusinessDataServiceHelper.loadSingle((Object)waitInvoice.getPkValue(), (String)"sim_vatinvoice");
                    logger.info(String.format("redConfirmBillNo:%s,govuuid:%s,orderNo:%s", redConfirmBill.getString("number"), redConfirmBill.getString("govuuid"), waitInvoice.getString("orderno")));
                    String issueStatus = waitInvoice.getString("issuestatus");
                    if (!IssueStatusEnum.none.getCode().equals(issueStatus) && !IssueStatusEnum.failed.getCode().equals(issueStatus)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001\u4e3a%s\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u5f00\u7968", (String)"RedConfirmBillHelper_0", (String)"imc-sim-service", (Object[])new Object[0]), IssueStatusEnum.getName((String)issueStatus)));
                    }
                    if (StringUtils.isNotBlank((CharSequence)waitInvoice.getString("invoiceno"))) {
                        DynamicObject dynamicObject = waitInvoice;
                        return dynamicObject;
                    }
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"), (Object[])new Object[]{waitInvoice.getPkValue()});
                }
                DynamicObject invoiceObj = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
                DynamicObjectUtil.copyDynamicObject((DynamicObject)redConfirmBill, (DynamicObject)invoiceObj, (boolean)false, (boolean)true, (boolean)true);
                QFilter qFilter = new QFilter("invoiceno", "=", (Object)invoiceObj.getString("originalinvoiceno"));
                DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"cardtype", (QFilter[])qFilter.toArray());
                if (blueInvoice != null) {
                    invoiceObj.set("cardtype", blueInvoice.get("cardtype"));
                }
                invoiceObj.set("issuetime", null);
                invoiceObj.set("mergelable", (Object)"");
                invoiceObj.set("issuestatus", (Object)IssueStatusEnum.none.getCode());
                DynamicObjectCollection items = invoiceObj.getDynamicObjectCollection("items");
                for (int i = 0; i < items.size(); ++i) {
                    DynamicObject item = (DynamicObject)items.get(i);
                    item.set("seq", (Object)i);
                    ZeroTaxMarkUtil.handlerZeroTaxMark((DynamicObject)item);
                }
                invoiceObj.set("contraststatus", (Object)("10".equals(redConfirmBill.getString("source")) ? "10" : ""));
                invoiceObj.set("infocode", (Object)redConfirmBill.getString("number"));
                invoiceObj.set("createtime", (Object)new Date());
                String source = redConfirmBill.getString("source");
                invoiceObj.set("buyertype", (Object)("5".equals(source) || "10".equals(source) ? "4" : "0"));
                invoiceObj.set("issuesource", (Object)"");
                invoiceObj.set("issuetype", (Object)IssueTypeEnum.red.getValue());
                invoiceObj.set("orgid", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)redConfirmBill.get("createorg")));
                invoiceObj.set("taxedtype", (Object)TaxedTypeEnum.normal.getValue());
                invoiceObj.set("inventorymark", (Object)"0");
                invoiceObj.set("issuewritebackstatus", (Object)"0");
                invoiceObj.set("abolishwritebackstatus", (Object)"2");
                String interfaceCode = redConfirmBill.getString("interfacecode");
                if (OpenApiInterfaceCodeEnum.ALLE_INVOICE_RED.getCode().equals(interfaceCode)) {
                    invoiceObj.set("datahash", (Object)OpenApiInterfaceCodeEnum.ALLE_INVOICE_RED.getCode());
                }
                invoiceObj.set("invoicingoperator", (Object)Long.parseLong(RequestContext.get().getUserId()));
                invoiceObj.set("invoiceno", (Object)"");
                DynamicObject dynamicObject = invoiceObj;
                return dynamicObject;
            }
            try {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355%s\u5728\u5f00\u7968\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"RedConfirmBillHelper_17", (String)"imc-sim-service", (Object[])new Object[0]), redConfirmNumber));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static String getApplyTaxNo(DynamicObject redConfirmBill) {
        String taxNo = "2".equals(redConfirmBill.getString("applicant")) ? redConfirmBill.getString("salertaxno") : redConfirmBill.getString("buyertaxno");
        return taxNo;
    }

    public static DynamicObject getInvoiceFromRedConfirm(DynamicObject redConfirm) {
        String govUuid;
        String orderNo = redConfirm.getString("orderno");
        DynamicObject wait = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"", (QFilter[])new QFilter("orderno", "=", (Object)orderNo).toArray());
        if (wait != null) {
            return wait;
        }
        QFilter orgFilter = new QFilter("orgid", "in", (Object)new OrgHelper().getOrgIdsByTaxNo(redConfirm.getString("salertaxno")));
        Date uploadDate = redConfirm.getDate("uploaddate");
        if (uploadDate != null) {
            orgFilter.and("createtime", ">=", (Object)DateUtils.addHour((Date)redConfirm.getDate("uploaddate"), (int)-1));
        }
        if (StringUtils.isNotBlank((CharSequence)(govUuid = redConfirm.getString("govuuid")))) {
            orgFilter.and("govuuid", "=", (Object)govUuid);
        } else {
            orgFilter.and("infocode", "=", (Object)redConfirm.getString("number"));
        }
        return BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"", (QFilter[])orgFilter.toArray());
    }

    public static void setFailReason(DynamicObject redConfirm, String description) {
        String failReason = (String)StringUtils.defaultIfEmpty((CharSequence)description, (CharSequence)"");
        redConfirm.set("failreason", (Object)(failReason.length() > 80 ? failReason.substring(0, 80) : failReason));
    }

    public static DynamicObject formatRedConfirm(String billNo, String orderNo, String redReason, DynamicObject invoice, String account) {
        if (invoice == null) {
            throw new MsgException(ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), ResManager.loadKDString((String)"\u539f\u53d1\u7968\u4e0d\u5b58\u5728", (String)"RedConfirmBillHelper_4", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (!InvoiceStatus.isNormalInvIncludePartRed((String)invoice.getString("invoicestatus"))) {
            throw new MsgException(ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001\u975e\u6b63\u5e38\uff0c\u65e0\u6cd5\u7533\u8bf7\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"RedConfirmBillHelper_5", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) <= 0) {
            throw new MsgException(ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u65e0\u6cd5\u7533\u8bf7\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"RedConfirmBillHelper_6", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        DynamicObject redConfirm = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_confirm_bill");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)invoice, (DynamicObject)redConfirm);
        redConfirm.set("remark", null);
        redConfirm.set("issuetime", null);
        if (StringUtils.isNotBlank((CharSequence)account)) {
            redConfirm.set("account", (Object)account);
        } else {
            redConfirm.set("account", (Object)"");
        }
        DynamicObjectCollection items = redConfirm.getDynamicObjectCollection("items");
        items.clear();
        DynamicObjectCollection invoiceItems = invoice.getDynamicObjectCollection("items");
        boolean startZero = RedConfirmBillHelper.checkOriginalInvoiceStartZero(invoice.getString("invoicecode"), invoice.getString("invoiceno"));
        for (int i = 0; i < invoiceItems.size(); ++i) {
            DynamicObject discountItem;
            DynamicObject invoiceItem = (DynamicObject)invoiceItems.get(i);
            String rowType = invoiceItem.getString("rowtype");
            if ("2".equals(rowType) && (discountItem = (DynamicObject)invoiceItems.get(i + 1)).getBigDecimal("amount").add(invoiceItem.getBigDecimal("amount")).compareTo(BigDecimal.ZERO) == 0 || "1".equals(rowType)) continue;
            DynamicObject item = items.addNew();
            DynamicObjectUtil.copyDynamicObject((DynamicObject)invoiceItem, (DynamicObject)item);
            item.set("seq", (Object)(i + 1));
            item.set("originalinvoiceitemid", invoiceItem.get("id"));
            item.set("originseq", (Object)(startZero ? invoiceItem.getInt("seq") + 1 : invoiceItem.getInt("seq")));
            item.set("num", (Object)item.getBigDecimal("num").negate());
            item.set("amount", (Object)item.getBigDecimal("amount").negate());
            item.set("tax", (Object)item.getBigDecimal("tax").negate());
            item.set("taxamount", (Object)item.getBigDecimal("taxamount").negate());
            if ("04".equals(redReason)) {
                item.set("num", (Object)BigDecimal.ZERO);
                item.set("unitprice", (Object)BigDecimal.ZERO);
                item.set("taxunitprice", (Object)BigDecimal.ZERO);
            }
            if (!"2".equals(rowType)) continue;
            item.set("rowtype", (Object)"0");
            DynamicObject discountItem2 = (DynamicObject)invoiceItems.get(i + 1);
            item.set("amount", (Object)item.getBigDecimal("amount").subtract(discountItem2.getBigDecimal("amount")));
            item.set("tax", (Object)item.getBigDecimal("tax").subtract(discountItem2.getBigDecimal("tax")));
            item.set("taxamount", (Object)item.getBigDecimal("taxamount").subtract(discountItem2.getBigDecimal("taxamount")));
            if (MathUtils.isNullOrZero((BigDecimal)item.getBigDecimal("num"))) continue;
            item.set("unitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)item.getBigDecimal("amount"), (BigDecimal)item.getBigDecimal("num"), (boolean)Boolean.TRUE));
            item.set("taxunitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)item.getBigDecimal("taxamount"), (BigDecimal)item.getBigDecimal("num"), (boolean)Boolean.TRUE));
        }
        redConfirm.set("invoiceamount", (Object)redConfirm.getBigDecimal("invoiceamount").negate());
        redConfirm.set("totaltax", (Object)redConfirm.getBigDecimal("totaltax").negate());
        redConfirm.set("totalamount", (Object)redConfirm.getBigDecimal("totalamount").negate());
        redConfirm.set("org", invoice.get("orgid"));
        redConfirm.set("useorg", invoice.get("orgid"));
        redConfirm.set("createorg", invoice.get("orgid"));
        redConfirm.set("ctrlstrategy", (Object)"7");
        redConfirm.set("issuestatus", (Object)IssueStatusEnum.none.getCode());
        redConfirm.set("originalinvoiceno", invoice.get("invoiceno"));
        redConfirm.set("originalinvoicecode", invoice.get("invoicecode"));
        redConfirm.set("invoiceno", (Object)"");
        redConfirm.set("originalissuetime", invoice.get("issuetime"));
        String originalInvoiceType = invoice.getString("invoicetype");
        redConfirm.set("originalinvoicetype", (Object)originalInvoiceType);
        redConfirm.set("originalinvoiceamount", invoice.get("invoiceamount"));
        redConfirm.set("originaltotaltax", invoice.get("totaltax"));
        redConfirm.set("invoicetype", (Object)InvoiceType.blueTypeToAllEType((String)originalInvoiceType));
        if (StringUtils.isNotEmpty((CharSequence)orderNo)) {
            redConfirm.set("orderno", (Object)orderNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)billNo)) {
            redConfirm.set("billno", (Object)billNo);
        }
        String specialType = InvoiceSpecialType.InvoiceSpecialTypeEnum.getCodeBySpecialType((String)invoice.getString("specialtype"));
        redConfirm.set("specialtype", (Object)specialType);
        redConfirm.set("systemsource", (Object)invoice.getString("systemsource"));
        redConfirm.set("uploadstatus", (Object)"0");
        redConfirm.set("applicant", (Object)RedInfoConstant.ApplicantEnum.SALER.getCode());
        redConfirm.set("enteridentity", (Object)"0");
        redConfirm.set("redreason", (Object)redReason);
        redConfirm.set("source", (Object)"4");
        redConfirm.set("status", (Object)BillHelper.getBillStatusByTableName((String)"sim_red_confirm_bill", (String)redConfirm.getString("source")));
        redConfirm.set("enable", (Object)"1");
        redConfirm.set("creator", (Object)RequestContext.get().getUserId());
        return redConfirm;
    }

    public static DynamicObject createRedConfirmByBlue(BillVo bill, String orderNo, DynamicObject blueInvoiceObj, Boolean isPartRed) {
        if (null == blueInvoiceObj) {
            String msg = ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u539f\u84dd\u7968\u4fe1\u606f", (String)"RedConfirmBillHelper_16", (String)"imc-sim-service", (Object[])new Object[0]);
            throw new MsgException(ErrorType.FAIL.getCode(), msg);
        }
        List billDetailVos = bill.getBillDetail();
        DynamicObjectCollection invoiceItems = blueInvoiceObj.getDynamicObjectCollection("items");
        HashMap<Integer, DynamicObject> invoiceDetailSeqMap = new HashMap<Integer, DynamicObject>(invoiceItems.size());
        String errMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u7ea2\u5b57\u786e\u8ba4\u5355\uff0c\u518d\u5c06\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7\u5173\u8054\u586b\u5199\u5230\u5f00\u7968\u7533\u8bf7\u5355\u518d\u4e0b\u63a8\u5f00\u7968\u3002", (String)"RedConfirmBillHelper_9", (String)"imc-sim-service", (Object[])new Object[0]);
        if (!isPartRed.booleanValue()) {
            if (blueInvoiceObj.getBigDecimal("invoiceamount").compareTo(bill.getTotalAmount().abs()) != 0) {
                if (blueInvoiceObj.getBigDecimal("invoiceamount").compareTo(bill.getTotalAmount().abs()) < 0) {
                    errMsg = "";
                }
                throw new MsgException(ErrorType.FAIL.getCode(), String.format(ResManager.loadKDString((String)"\u539f\u84dd\u7968\u751f\u6210\u7ea2\u5b57\u786e\u8ba4\u5355\u5931\u8d25\uff0c\u5355\u636e\u91d1\u989d\u4e0e\u539f\u84dd\u7968\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u5355\u636e\u91d1\u989d[%1$s]\uff0c\u539f\u84dd\u7968\u91d1\u989d[%2$s]\u3002%3$s", (String)"RedConfirmBillHelper_10", (String)"imc-sim-service", (Object[])new Object[0]), bill.getTotalAmount().setScale(2, 4), blueInvoiceObj.getBigDecimal("invoiceamount").setScale(2, 4), errMsg));
            }
            if (blueInvoiceObj.getBigDecimal("totaltax").compareTo(bill.getTotalTaxAmount().abs()) != 0) {
                if (blueInvoiceObj.getBigDecimal("totaltax").compareTo(bill.getTotalTaxAmount().abs()) < 0) {
                    errMsg = "";
                }
                throw new MsgException(ErrorType.FAIL.getCode(), String.format(ResManager.loadKDString((String)"\u539f\u84dd\u7968\u751f\u6210\u7ea2\u5b57\u786e\u8ba4\u5355\u5931\u8d25\uff0c\u5355\u636e\u91d1\u989d\u4e0e\u539f\u84dd\u7968\u7a0e\u989d\u4e0d\u4e00\u81f4\uff0c\u5355\u636e\u7a0e\u989d[%1$s]\uff0c\u539f\u84dd\u7968\u7a0e\u989d[%2$s]\u3002%3$s", (String)"RedConfirmBillHelper_11", (String)"imc-sim-service", (Object[])new Object[0]), bill.getTotalTaxAmount().setScale(2, 4), blueInvoiceObj.getBigDecimal("totaltax").setScale(2, 4), errMsg));
            }
        } else {
            int i;
            QFilter qFilter = new QFilter("id", "=", (Object)blueInvoiceObj.getLong("id"));
            qFilter.and("items.seq", "=", (Object)0);
            boolean startZero = QueryServiceHelper.exists((String)"sim_vatinvoice", (QFilter[])qFilter.toArray());
            for (i = 0; i < invoiceItems.size(); ++i) {
                if (startZero) {
                    invoiceDetailSeqMap.put(((DynamicObject)invoiceItems.get(i)).getInt("seq") + 1, (DynamicObject)invoiceItems.get(i));
                    continue;
                }
                invoiceDetailSeqMap.put(((DynamicObject)invoiceItems.get(i)).getInt("seq"), (DynamicObject)invoiceItems.get(i));
            }
            for (i = 0; i < billDetailVos.size(); ++i) {
                Integer originalSeq = ((BillDetailVo)billDetailVos.get(i)).getOriginalSeq();
                if (null == originalSeq || originalSeq < 1) {
                    throw new MsgException(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u539f\u84dd\u7968\u660e\u7ec6\u884c\u5e8f\u53f7\u4ece1\u5f00\u59cb", (String)"RedConfirmBillHelper_13", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                DynamicObject invoiceItem = (DynamicObject)invoiceDetailSeqMap.get(originalSeq);
                if (null == invoiceItem) {
                    throw new MsgException(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u539f\u84dd\u7968\u4e0d\u5b58\u5728\u5e8f\u53f7\u4e3a[%s]\u7684\u660e\u7ec6\u884c", (String)"RedConfirmBillHelper_14", (String)"imc-sim-service", (Object[])new Object[]{originalSeq}));
                }
                if (((BillDetailVo)billDetailVos.get(i)).getAmount().abs().compareTo(invoiceItem.getBigDecimal("amount")) <= 0 && ((BillDetailVo)billDetailVos.get(i)).getTaxAmount().abs().compareTo(invoiceItem.getBigDecimal("taxamount")) <= 0) continue;
                throw new MsgException(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u660e\u7ec6\u884c[%s]\u7684\u7ea2\u51b2\u91d1\u989d\u5927\u4e8e\u539f\u84dd\u7968\u660e\u7ec6\u884c\u91d1\u989d", (String)"RedConfirmBillHelper_15", (String)"imc-sim-service", (Object[])new Object[]{originalSeq}));
            }
        }
        if (StringUtils.isBlank((CharSequence)bill.getRedReason())) {
            bill.setRedReason(RedConfirmBillRedReasonEnum.INVOICE_ERR.getBillCode());
        }
        if (Arrays.stream(RedConfirmBillRedReasonEnum.values()).noneMatch(reason -> reason.getBillCode().equals(bill.getRedReason()))) {
            throw new MsgException(ErrorType.FAIL.getCode(), ResManager.loadKDString((String)"\u7ea2\u51b2\u539f\u56e0\u586b\u5199\u9519\u8bef", (String)"RedConfirmBillHelper_12", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        logger.info(String.format("\u7ea2\u51b2\u539f\u56e0\u4e3a\uff1a%s", bill.getRedReason()));
        DynamicObject redConfirmObj = isPartRed != false ? RedConfirmBillHelper.formatBillVoConfirm(bill, orderNo, blueInvoiceObj, invoiceDetailSeqMap) : RedConfirmBillHelper.formatRedConfirm(bill.getBillNo(), orderNo, RedConfirmBillRedReasonEnum.getCodeByBillCode((String)bill.getRedReason()), blueInvoiceObj, bill.getAccount());
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_confirm_bill", (DynamicObject[])new DynamicObject[]{redConfirmObj}, null);
        if (!operationResult.isSuccess()) {
            throw new MsgException(ApiErrCodeEnum.NON_INV_CODE_NUM.getCode(), OperationConstant.getErrorMsg((OperationResult)operationResult));
        }
        ApiResult submitResult = RedConfirmBillHelper.submit(redConfirmObj);
        if (submitResult != null) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_red_confirm_bill"), (Object[])new Object[]{redConfirmObj.getPkValue()});
            logger.info(String.format("\u7533\u8bf7\u7ea2\u5b57\u786e\u8ba4\u5355\u8fd4\u56de\uff1a%s", JSON.toJSONString((Object)submitResult)));
            throw new MsgException(submitResult.getErrorCode(), String.format(ResManager.loadKDString((String)"\u539f\u84dd\u7968\u7ea2\u51b2\u751f\u6210\u7ea2\u5b57\u786e\u8ba4\u5355\u51fa\u9519\uff1a%s", (String)"RedConfirmBillHelper_8", (String)"imc-sim-service", (Object[])new Object[0]), submitResult.getMessage()));
        }
        return redConfirmObj;
    }

    private void invokeConfirmBillStatusUpdate(List<Long> confirmStatusUpdateConfirmList) {
        try {
            if (confirmStatusUpdateConfirmList.size() > 0) {
                OperationServiceHelper.executeOperate((String)"afterconfimstatusupdate", (String)"sim_vatinvoice", (Object[])confirmStatusUpdateConfirmList.toArray(), null);
            }
        }
        catch (Exception e) {
            logger.error("afterconfimstatusupdateFail:" + e.getMessage(), (Throwable)e);
        }
    }

    private static void reverseBuyer(DynamicObject redConfirmBill, RedConfirmBillApplyRequest request) {
        request.setGmfmc(request.getXsfmc());
        request.setGmfnsrsbh(request.getXsfnsrsbh());
        request.setXsfmc(redConfirmBill.getString("buyername"));
        request.setXsfnsrsbh(redConfirmBill.getString("buyertaxno"));
    }

    private DynamicObject buildRedConfirmMainData(AllEleRedConfirmDownLoadRequestDTO request, AllEleRedConfirmDownLoadResponseDTO datum, DynamicObject org) {
        DynamicObject redConfirm = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_confirm_bill");
        if ("0".equals(request.getIdentity())) {
            datum.setIdentity(RedInfoConstant.ApplicantEnum.SALER.getCode());
        } else {
            datum.setIdentity(RedInfoConstant.ApplicantEnum.BUYERNODEDUCTED.getCode());
        }
        DynamicObjectUtil.bean2DynamicObject((Object)datum, (DynamicObject)redConfirm);
        if (StringUtils.isNotBlank((CharSequence)datum.getRedConfirmEnterDate())) {
            redConfirm.set("uploaddate", (Object)DateUtils.handleDate((String)datum.getRedConfirmEnterDate()));
        }
        if (StringUtils.isNotBlank((CharSequence)datum.getBlueInvoiceDate())) {
            redConfirm.set("originalissuetime", (Object)DateUtils.handleDate((String)datum.getBlueInvoiceDate()));
        }
        redConfirm.set("ctrlstrategy", (Object)"7");
        String invoiceNo = redConfirm.getString("invoiceno");
        if (StringUtils.isBlank((CharSequence)invoiceNo)) {
            redConfirm.set("issuestatus", (Object)"2");
        } else {
            redConfirm.set("issuestatus", (Object)"0");
            redConfirm.set("issuetime", (Object)DateUtils.handleDate((String)datum.getRedInvoiceDate()));
        }
        redConfirm.set("salertaxno", (Object)datum.getSalerTaxNo());
        redConfirm.set("uploadstatus", (Object)"1");
        redConfirm.set("source", (Object)"2");
        redConfirm.set("enable", (Object)"1");
        redConfirm.set("creator", (Object)RequestContext.get().getUserId());
        redConfirm.set("org", (Object)org);
        redConfirm.set("createorg", (Object)org);
        redConfirm.set("useorg", (Object)org);
        String originalInvoiceType = InvoiceType.getInvoiceTypeCodeByBaseCode((String)redConfirm.getString("originalinvoicetype"));
        redConfirm.set("originalinvoicetype", (Object)originalInvoiceType);
        if (InvoiceUtils.isSpecialInvoice((String)originalInvoiceType) || InvoiceUtils.isAllESpecialInvoice((String)originalInvoiceType)) {
            redConfirm.set("invoicetype", (Object)InvoiceType.ALL_E_SPECIAL.getTypeCode());
        } else {
            redConfirm.set("invoicetype", (Object)InvoiceType.ALL_E_NORMAL.getTypeCode());
        }
        redConfirm.set("orderno", (Object)UUID.next());
        redConfirm.set("hsbz", (Object)"0");
        redConfirm.set("totalamount", (Object)redConfirm.getBigDecimal("invoiceamount").add(redConfirm.getBigDecimal("totaltax")));
        String billStatus = BillHelper.getBillStatusByTableName((String)"sim_red_confirm_bill", (String)"2");
        redConfirm.set("status", (Object)billStatus);
        if ("Y".equals(datum.getGoodsNameIsSame())) {
            redConfirm.set("goodsnamesame", (Object)"Y");
        } else {
            redConfirm.set("goodsnamesame", (Object)"N");
        }
        DynamicObjectCollection items = redConfirm.getDynamicObjectCollection("items");
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)redConfirm.getString("invoicetype"));
        for (DynamicObject item : items) {
            item.set("rowtype", (Object)"0");
            item.set("taxamount", (Object)item.getBigDecimal("amount").add(item.getBigDecimal("tax")));
            item.set("taxunitprice", (Object)PriceHelper.calTaxUnitPrice((BigDecimal)item.getBigDecimal("unitprice"), (BigDecimal)item.getBigDecimal("taxrate"), (boolean)isAllEle));
        }
        return redConfirm;
    }

    private static void buildSpecialType(DynamicObject redConfirmBill, RedConfirmBillApplyRequest request) {
        String specialType;
        RedConfirmBillItem firstItem = (RedConfirmBillItem)request.getHzqrdmxList().get(0);
        switch (specialType = redConfirmBill.getString("specialtype")) {
            case "E05": {
                DynamicObjectCollection estatesales;
                DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (QFilter[])InvoiceQueryUtil.getInvoiceByCodeAndNo((String)request.getLzfpdm(), (String)request.getLzfphm()).toArray());
                if (StringUtils.isNotEmpty((CharSequence)redConfirmBill.getString("areaunit"))) {
                    firstItem.setDw(redConfirmBill.getString("areaunit"));
                }
                if (blueInvoice == null || (estatesales = blueInvoice.getDynamicObjectCollection("estatesales")).isEmpty()) break;
                int estateXh = 0;
                for (int i = 0; i < request.getHzqrdmxList().size(); ++i) {
                    if (StringUtils.isNotEmpty((CharSequence)((DynamicObject)estatesales.get(estateXh)).getString("saleunit"))) {
                        ((RedConfirmBillItem)request.getHzqrdmxList().get(i)).setDw(((DynamicObject)estatesales.get(estateXh)).getString("saleunit"));
                    }
                    ++estateXh;
                }
                break;
            }
            case "E06": {
                firstItem.setDw(redConfirmBill.getString("areaunit"));
                break;
            }
        }
    }

    public static RedConfirmDownloadHeadResponse queryRedConfirmListByLq(RedConfirmDownloadHeadRequest request) {
        LqptResponse response = new LqptService().send((LqptRequest)request);
        if (response.success()) {
            RedConfirmDownloadHeadResponse data = (RedConfirmDownloadHeadResponse)response.getData();
            logger.info("\u4e50\u4f01\u8fd4\u56de\u67e5\u8be2\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)data));
            return data;
        }
        throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u7535\u7968\u7ea2\u5b57\u786e\u8ba4\u5355\u5217\u8868\u4fe1\u606f\u5931\u8d25\uff0c%s", (String)"RedConfirmBillHelper_1", (String)"imc-sim-service", (Object[])new Object[0]), response.getDescription()));
    }

    public static RedConfirmDetailResponse queryRedConfirmDetailByLq(RedConfirmDetailRequest request) {
        LqptResponse response = new LqptService().send((LqptRequest)request);
        if (response.success()) {
            RedConfirmDetailResponse data = (RedConfirmDetailResponse)response.getData();
            logger.info("\u4e50\u4f01\u8fd4\u56de\u67e5\u8be2\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)data));
            return data;
        }
        throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u7535\u7968\u7ea2\u5b57\u786e\u8ba4\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff0c%s", (String)"RedConfirmBillHelper_2", (String)"imc-sim-service", (Object[])new Object[0]), response.getDescription()));
    }

    public static RedConfirmDownloadHeadRequest formatLqRequest(AllEleRedConfirmDownLoadRequestDTO requestDTO, SaleInfo saleInfo) {
        RedConfirmDownloadHeadRequest lqRequest = new RedConfirmDownloadHeadRequest();
        lqRequest.setNsrsbh(saleInfo.getSaleTaxNo());
        if (StringUtils.equals((CharSequence)requestDTO.getIdentity(), (CharSequence)"1")) {
            lqRequest.setYhjslx("1");
            lqRequest.setGmfmc(saleInfo.getSaleName());
            lqRequest.setGmfnsrsbh(saleInfo.getSaleTaxNo());
            lqRequest.setXsfmc(requestDTO.getOtherSideName());
            lqRequest.setXsfnsrsbh(requestDTO.getOtherSideTaxNo());
        } else {
            lqRequest.setYhjslx("0");
            lqRequest.setXsfmc(saleInfo.getSaleName());
            lqRequest.setXsfnsrsbh(saleInfo.getSaleTaxNo());
            lqRequest.setGmfmc(requestDTO.getOtherSideName());
            lqRequest.setGmfnsrsbh(requestDTO.getOtherSideTaxNo());
        }
        lqRequest.setHzqrxxztDm(requestDTO.getRedConfirmBillStatus());
        if (StringUtils.isNotEmpty((CharSequence)requestDTO.getStartDate())) {
            lqRequest.setLrrqq(DateUtils.handleDate((String)requestDTO.getStartDate()));
        }
        if (StringUtils.isNotEmpty((CharSequence)requestDTO.getEndDate())) {
            lqRequest.setLrrqz(DateUtils.handleDate((String)requestDTO.getEndDate()));
        }
        lqRequest.setLzfpdm(requestDTO.getOriginalInvoiceCode());
        lqRequest.setLzfphm(requestDTO.getOriginalInvoiceNo());
        lqRequest.setHzfpxxqrdbh(requestDTO.getRedConfirmBillNo());
        lqRequest.setPageNumber(Integer.valueOf(requestDTO.getPage()));
        lqRequest.setPageSize(Integer.valueOf(requestDTO.getPageSize()));
        return lqRequest;
    }

    public static AllEleRedConfirmDownLoadResponseDTO parseDownloadResponse(RedConfirmDetailResponse data) {
        AllEleRedConfirmDownLoadResponseDTO result = new AllEleRedConfirmDownLoadResponseDTO();
        result.setGovRedConfirmBillUuid(data.getUuid());
        result.setRedConfirmBillNo(data.getHzfpxxqrdbh());
        result.setEnterIdentity(data.getLrfsf());
        result.setSalerTaxNo(data.getXsfnsrsbh());
        result.setSalerName(data.getXsfmc());
        result.setBuyerName(data.getGmfmc());
        result.setBuyerTaxNo(data.getGmfnsrsbh());
        result.setBlueInvoiceCode(data.getLzfpdm());
        result.setBlueInvoiceNo(data.getLzfphm());
        result.setBlueInvoiceDate(data.getLzkprq());
        result.setBlueInvoiceAmount(data.getLzhjje());
        result.setBlueTaxAmount(data.getLzhjse());
        result.setRedInvoiceAmount(data.getHzcxje());
        result.setRedTaxAmount(data.getHzcxse());
        result.setRedReason(data.getChyyDm());
        result.setRedConfirmBillStatus(data.getHzqrxxztDm());
        result.setRedConfirmEnterDate(data.getLrrq());
        result.setRedInvoiceNo(data.getHzfphm());
        result.setRedInvoiceDate(data.getHzkprq());
        String specialType = InvoiceSpecialType.InvoiceSpecialTypeEnum.getCodeByLqCode((String)data.getLzfpTdyslxDm());
        result.setSpecialType(specialType);
        result.setOriginalSpecialType(specialType);
        result.setComfirmDate(data.getQrrq());
        result.setPaperFlag(data.getYkjhzfpbz());
        InvoiceType invoiceType = RedConfirmBillHelper.getInvoiceTypeByLq(data.getLzfphm(), data.getLzfppzDm(), data.getSfzzfpbz());
        result.setBlueInvoiceType(invoiceType.getBaseCode());
        boolean goodsNamsIsSame = false;
        ArrayList<AllEleRedConfirmItemDownLoadResponseDTO> detailList = new ArrayList<AllEleRedConfirmItemDownLoadResponseDTO>(data.getHzqrxxmxList().size());
        for (RedConfirmDetailItemResponse detail : data.getHzqrxxmxList()) {
            AllEleRedConfirmItemDownLoadResponseDTO resultDetail = new AllEleRedConfirmItemDownLoadResponseDTO();
            resultDetail.setBlueInvoiceItemIndex(detail.getLzmxxh());
            resultDetail.setIndex(detail.getXh());
            resultDetail.setGoodsCode(detail.getSphfwssflhbbm());
            resultDetail.setGoodsName(detail.getHwhyslwfwmc());
            resultDetail.setSpecModel(detail.getGgxh());
            resultDetail.setUnitPrice(detail.getFpspdj());
            resultDetail.setNum(detail.getFpspsl());
            resultDetail.setDetailAmount(detail.getJe());
            resultDetail.setTaxAmount(detail.getSe());
            resultDetail.setTaxRate(detail.getSl1());
            resultDetail.setUnit(detail.getDw());
            if (detail.getXmmc().equals(detail.getHwhyslwfwmc())) {
                goodsNamsIsSame = true;
            }
            detailList.add(resultDetail);
        }
        result.setItems(detailList);
        result.setGoodsNameIsSame(goodsNamsIsSame ? "Y" : "N");
        return result;
    }

    public static InvoiceType getInvoiceTypeByLq(String lzfphm, String lzfppzDm, String sfzzfpbz) {
        if (StringUtils.isNotBlank((CharSequence)lzfphm) && lzfphm.length() < 20) {
            if ("Y".equals(sfzzfpbz)) {
                if ("01".equals(lzfppzDm)) {
                    return InvoiceType.PAPER_SPECIAL_INVOICE;
                }
                if ("02".equals(lzfppzDm)) {
                    return InvoiceType.PAPER_NOMAL_INVOICE;
                }
            } else {
                if ("01".equals(lzfppzDm)) {
                    return InvoiceType.ELECTRICAL_SPECIAL_INVOICE;
                }
                if ("02".equals(lzfppzDm)) {
                    return InvoiceType.ELECTRICAL_NORMAL_INVOICE;
                }
            }
        } else {
            if (StringUtils.equals((CharSequence)lzfppzDm, (CharSequence)InvoiceType.ALL_E_NORMAL.getLqptCode())) {
                return InvoiceType.ALL_E_NORMAL;
            }
            if (StringUtils.equals((CharSequence)lzfppzDm, (CharSequence)InvoiceType.ALL_E_SPECIAL.getLqptCode())) {
                return InvoiceType.ALL_E_SPECIAL;
            }
        }
        return InvoiceType.ALL_E_NORMAL;
    }

    private static boolean checkSalesDiscounts(String originalInvoiceCode, String originalInvoiceNo) {
        QFilter qFilter = new QFilter("originalinvoicecode", "=", ObjectUtils.defaultIfNull((Object)originalInvoiceCode, (Object)"")).and("originalinvoiceno", "=", (Object)originalInvoiceNo).and("uploadstatus", "=", (Object)"1").and("redreason", "=", (Object)RedConfirmBillRedReasonEnum.SALES_DISCOUNTS.getCode()).and("confirmstatus", "in", (Object)new String[]{"01", "02", "03", "04"});
        DynamicObject[] arrays = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"id", (QFilter[])qFilter.toArray());
        boolean flag = false;
        if (arrays != null && arrays.length > 0) {
            flag = true;
        }
        return flag;
    }

    public static void batchIssueRedConfirm(DynamicObject[] redConfirms, String account) {
        for (DynamicObject redConfirmBill : redConfirms) {
            DynamicObject invoiceObj = RedConfirmBillHelper.createWaitInvoice(redConfirmBill);
            if (StringUtils.isNotBlank((CharSequence)account)) {
                invoiceObj.set("account", (Object)account);
            }
            MsgResponse response = IssueInvoiceService.doIssueInvoice((DynamicObject)invoiceObj);
            if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode()) || ErrorType.SUBMITED.getCode().equals(response.getErrorCode())) {
                if (!ErrorType.SUBMITED.getCode().equals(response.getErrorCode())) continue;
                redConfirmBill.set("issuestatus", (Object)IssueStatusEnum.underway.getCode());
                continue;
            }
            String message = String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\uff1a%1$s\uff0c\u63d0\u4ea4\u5f00\u7968\u5931\u8d25,%2$s", (String)"RedConfirmBillHelper_3", (String)"imc-sim-service", (Object[])new Object[0]), redConfirmBill.getString("number"), response.getErrorMsg());
            throw new KDBizException(message);
        }
    }

    public static void dealGetVesselShipDataMethod(DynamicObject redConfirm, DynamicObject blueInvoiceDO) {
        String specialType = blueInvoiceDO.getString("specialtype");
        if ("E07".equals(specialType)) {
            DynamicObjectCollection vesselVehichCollection = blueInvoiceDO.getDynamicObjectCollection("vehichevesselships");
            if (vesselVehichCollection == null || vesselVehichCollection.isEmpty()) {
                return;
            }
            DynamicObjectCollection dynamicObjectCollection = redConfirm.getDynamicObjectCollection("vehichevesselships");
            if (dynamicObjectCollection != null) {
                for (DynamicObject vesselVehicheObject : vesselVehichCollection) {
                    DynamicObject dynamicObject = dynamicObjectCollection.addNew();
                    dynamicObject.set("policyno", (Object)vesselVehicheObject.getString("policyno"));
                    dynamicObject.set("shipsno", (Object)vesselVehicheObject.getString("shipsno"));
                    dynamicObject.set("vehiclecode", (Object)vesselVehicheObject.getString("vehiclecode"));
                    dynamicObject.set("perioddate", (Object)vesselVehicheObject.getString("perioddate"));
                    dynamicObject.set("periodstartdate", (Object)vesselVehicheObject.getDate("periodstartdate"));
                    dynamicObject.set("periodenddate", (Object)vesselVehicheObject.getDate("periodenddate"));
                    dynamicObject.set("vehiclevesselamount", (Object)vesselVehicheObject.getBigDecimal("vehiclevesselamount"));
                    dynamicObject.set("vehiclelateamount", (Object)vesselVehicheObject.getBigDecimal("vehiclelateamount"));
                    dynamicObject.set("vehicletotalamount", (Object)vesselVehicheObject.getBigDecimal("vehicletotalamount"));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ApiResult submit(DynamicObject redConfirmBill) {
        ApiResult riskControlResult = BillRiskControlService.riskControlSingleApi(redConfirmBill, "sim_red_confirm_bill", RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_ENTRY);
        if (riskControlResult != null) {
            return riskControlResult;
        }
        String taxNo = redConfirmBill.getString("salertaxno");
        if (EnterpriseHelper.isLqptChannel((String)taxNo)) {
            RedConfirmBillApplyRequest request = (RedConfirmBillApplyRequest)DynamicObjectUtil.dynamicObject2Bean(RedConfirmBillApplyRequest.class, (DynamicObject)redConfirmBill);
            request.setNsrsbh(redConfirmBill.getString("salertaxno"));
            RedConfirmBillHelper.buildRedConfirmApply(request, redConfirmBill);
            LqptResponse response = new LqptService().send((LqptRequest)request);
            if (!response.success()) {
                redConfirmBill.set("uploadstatus", (Object)"2");
                RedConfirmBillHelper.setFailReason(redConfirmBill, response.getDescription());
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u4e0a\u4f20\u5931\u8d25\uff0c%2$s", (String)"RedConfirmBillHelper_7", (String)"imc-sim-service", (Object[])new Object[0]), redConfirmBill.getString("orderno"), response.getDescription()), (String)response.getErrcode());
            }
            redConfirmBill.set("uploadstatus", (Object)"1");
            RedConfirmBillApplyResponse data = (RedConfirmBillApplyResponse)response.getData();
            redConfirmBill.set("uploaddate", (Object)new Date());
            redConfirmBill.set("govuuid", (Object)data.getUuid());
            redConfirmBill.set("number", (Object)data.getHzfpxxqrdbh());
            redConfirmBill.set("confirmstatus", (Object)data.getHzqrxxztDm());
            redConfirmBill.set("failreason", (Object)"");
        } else {
            ApiResult result = ApiAllEHelper.alleLoginCheck((String)redConfirmBill.getString("salertaxno"), (String)redConfirmBill.getString("account"));
            if (result != null) {
                return result;
            }
            AllEleIssueRequestDTO allEleIssueRequestDTO = AllEleIssueInvoiceImpl.buildIssueInvoide((DynamicObject)redConfirmBill);
            RedConfirmBillHelper.addOriginalSeq(allEleIssueRequestDTO);
            allEleIssueRequestDTO.setRequest_path(AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_APPLY.getRequestPath());
            AllEleResponseDTO response = AllEleServiceHelper.doPost((String)redConfirmBill.getString("salertaxno"), (AllEleRequestDTO)allEleIssueRequestDTO, AllEleRedConfirmBillUploadResponseDTO.class);
            if (!response.getSuccess().booleanValue()) {
                redConfirmBill.set("uploadstatus", (Object)"2");
                RedConfirmBillHelper.setFailReason(redConfirmBill, response.getDescription());
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u4e0a\u4f20\u5931\u8d25\uff0c%2$s", (String)"RedConfirmBillHelper_7", (String)"imc-sim-service", (Object[])new Object[0]), redConfirmBill.getString("orderno"), response.getDescription()), (String)ApiErrCodeEnum.ERROR.getCode());
            }
            redConfirmBill.set("uploadstatus", (Object)"1");
            AllEleRedConfirmBillUploadResponseDTO uploadResponse = (AllEleRedConfirmBillUploadResponseDTO)response.getData();
            redConfirmBill.set("uploaddate", (Object)DateUtils.stringToDate((String)uploadResponse.getRedConfirmEnterDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            redConfirmBill.set("govuuid", (Object)uploadResponse.getGovRedConfirmBillUuid());
            redConfirmBill.set("number", (Object)uploadResponse.getRedConfirmBillNo());
            redConfirmBill.set("confirmstatus", (Object)uploadResponse.getRedConfirmBillStatus());
            redConfirmBill.set("failreason", (Object)"");
        }
        if (redConfirmBill.getPkValue() != null && (Long)redConfirmBill.getPkValue() != 0L) {
            ImcSaveServiceHelper.update((DynamicObject)redConfirmBill);
            return null;
        }
        ImcSaveServiceHelper.save((DynamicObject)redConfirmBill);
        return null;
    }

    public static void redConfirmBillConfirmMethod(DynamicObject redConfirmBill, String account) {
        String taxNo = RedConfirmBillHelper.getConfirmTaxNo(redConfirmBill);
        if (EnterpriseHelper.isLqptChannel((String)taxNo)) {
            RedConfirmBillConfirmRequest request = (RedConfirmBillConfirmRequest)DynamicObjectUtil.dynamicObject2Bean(RedConfirmBillConfirmRequest.class, (DynamicObject)redConfirmBill);
            request.setNsrsbh(taxNo);
            request.setUuid(redConfirmBill.getString("govuuid"));
            request.setQrlx("Y");
            LqptResponse response = new LqptService().send((LqptRequest)request);
            if (response.success()) {
                redConfirmBill.set("confirmstatus", (Object)"04");
                redConfirmBill.set("failreason", (Object)"");
                return;
            }
            String desc = response.getDescription();
            if (StringUtils.isEmpty((CharSequence)desc)) {
                desc = ResManager.loadKDString((String)"\u786e\u8ba4\u5931\u8d25", (String)"RedConfirmBillOp_1", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            }
            RedConfirmBillHelper.setFailReason(redConfirmBill, desc);
            return;
        }
        AllEleResponseDTO<AllEleRedConfirmRefuseResponseDTO> response = RedConfirmBillHelper.requestConfirm(taxNo, "Y", redConfirmBill, account);
        if (response.getSuccess().booleanValue()) {
            AllEleRedConfirmRefuseResponseDTO confirmResponse = (AllEleRedConfirmRefuseResponseDTO)response.getData();
            redConfirmBill.set("confirmstatus", (Object)confirmResponse.getRedConfirmBillStatus());
            redConfirmBill.set("failreason", (Object)"");
            return;
        }
        String desc = response.getDescription();
        if (StringUtils.isEmpty((CharSequence)desc)) {
            desc = ResManager.loadKDString((String)"\u786e\u8ba4\u5931\u8d25", (String)"RedConfirmBillOp_1", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        }
        RedConfirmBillHelper.setFailReason(redConfirmBill, desc);
    }

    public static String getConfirmTaxNo(DynamicObject redConfirmBill) {
        String taxNo = redConfirmBill.getString("salertaxno");
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)redConfirmBill.getString("confirmstatus"), (CharSequence)RedConfirmStatusEnum.BUYER_CONFIRM.getBillCode())) {
            taxNo = redConfirmBill.getString("buyertaxno");
        }
        return taxNo;
    }

    public static AllEleResponseDTO<AllEleRedConfirmRefuseResponseDTO> requestConfirm(String taxNo, String confirmationType, DynamicObject redConfirmBill, String account) {
        AllEleRedConfirmRefuseRequestDTO requestDTO = new AllEleRedConfirmRefuseRequestDTO();
        requestDTO.setRequest_path(AllEleInterfaceTypeEnum.RED_CONFIRM_BILL_UPDATE.getRequestPath());
        requestDTO.setSalerTaxNo(redConfirmBill.getString("salertaxno"));
        requestDTO.setGovRedConfirmBillUuid(redConfirmBill.getString("govuuid"));
        requestDTO.setConfirmationType(confirmationType);
        requestDTO.setAccount(account);
        logger.info("RPA\u8bf7\u6c42\u7a0e\u5c40\u786e\u8ba4\u6216\u62d2\u7edd\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)requestDTO));
        AllEleResponseDTO response = AllEleServiceHelper.doPost((String)taxNo, (AllEleRequestDTO)requestDTO, AllEleRedConfirmRefuseResponseDTO.class);
        logger.info("RPA\u8bf7\u6c42\u7a0e\u5c40\u786e\u8ba4\u6216\u62d2\u7edd\u8fd4\u56de\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)response));
        if (response.getSuccess().booleanValue() && "Y".equals(confirmationType) && RedConfirmStatusEnum.SELLER_CONFIRM.getBillCode().equals(redConfirmBill.getString("confirmstatus"))) {
            redConfirmBill.set("account", (Object)requestDTO.getAccount());
            if (StringUtils.isNotBlank((CharSequence)requestDTO.getAccount())) {
                redConfirmBill.set("drawer", (Object)AllEleAuthHelper.getDrawerByAccount((String)requestDTO.getSalerTaxNo(), (String)requestDTO.getAccount()));
            }
        }
        return response;
    }

    public void download(AllEleRedConfirmDownLoadRequestDTO request, List<AllEleRedConfirmDownLoadResponseDTO> data) {
        OperationResult operationResult;
        BasedataProp orgProp = (BasedataProp)EntityMetadataCache.getDataEntityType((String)"sim_red_confirm_bill").getProperties().get((Object)"org");
        DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)orgProp.getBaseEntityId());
        org.set("id", (Object)request.getOrgId());
        ArrayList<DynamicObject> redConfirmList = new ArrayList<DynamicObject>(data.size());
        ArrayList<DynamicObject> insertConfirmList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> updateConfirmList = new ArrayList<DynamicObject>(10);
        ArrayList<Long> confirmStatusUpdateConfirmList = new ArrayList<Long>(10);
        logger.info("\u4e0b\u8f7d\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString(data));
        boolean isOnlyUpdate = null != request.getOnlyUpdate() && request.getOnlyUpdate() != false;
        Set confirmBillNos = data.stream().map(AllEleRedConfirmDownLoadResponseDTO::getRedConfirmBillNo).collect(Collectors.toSet());
        DynamicObject[] redConfirmBillArr = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"number", (QFilter[])new QFilter("number", "in", confirmBillNos).toArray());
        Map<String, DynamicObject> redConfirmBillNoMap = Arrays.stream(redConfirmBillArr).collect(Collectors.toMap(k -> k.getString("number"), v -> v, (v1, v2) -> v1));
        Iterator<AllEleRedConfirmDownLoadResponseDTO> iterator = data.iterator();
        while (iterator.hasNext()) {
            AllEleRedConfirmDownLoadResponseDTO datum = iterator.next();
            DynamicObject redConfirm = redConfirmBillNoMap.get(datum.getRedConfirmBillNo());
            if (redConfirm == null && isOnlyUpdate) continue;
            if (redConfirm == null) {
                QFilter qFilter = new QFilter("originalinvoicecode", "=", ObjectUtils.defaultIfNull((Object)datum.getBlueInvoiceCode(), (Object)"")).and("originalinvoiceno", "=", (Object)datum.getBlueInvoiceNo()).and("invoiceamount", "=", (Object)datum.getRedInvoiceAmount()).and("totaltax", "=", (Object)datum.getRedTaxAmount()).and("uploadstatus", "!=", (Object)"1");
                DynamicObject redConfirmOriInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "items.goodsname", "items.originseq", "items.specification", "items.unit", "items.amount", "items.tax"), (QFilter[])qFilter.toArray());
                if (redConfirmOriInvoice != null) {
                    redConfirm = this.matchRedConfirm(redConfirmOriInvoice, datum);
                }
            }
            if (redConfirm != null) {
                redConfirm = BusinessDataServiceHelper.loadSingle((Object)redConfirm.getPkValue(), (String)"sim_red_confirm_bill");
                this.updateExistRedConfirm(redConfirm, datum);
                updateConfirmList.add(redConfirm);
                if (validConfirmStatus.contains((Object)datum.getRedConfirmBillStatus()) && !datum.getRedConfirmBillStatus().equals(redConfirm.getString("confirmstatus"))) {
                    confirmStatusUpdateConfirmList.add(redConfirm.getLong("id"));
                }
            } else {
                if (request.getUpdateHead().booleanValue()) {
                    iterator.remove();
                    continue;
                }
                redConfirm = this.buildRedConfirmMainData(request, datum, org);
                insertConfirmList.add(redConfirm);
            }
            redConfirmList.add(redConfirm);
        }
        if (!updateConfirmList.isEmpty()) {
            ImcSaveServiceHelper.update(updateConfirmList);
        }
        if (isOnlyUpdate) {
            this.invokeConfirmBillStatusUpdate(confirmStatusUpdateConfirmList);
            return;
        }
        if (!insertConfirmList.isEmpty() && !(operationResult = ImcSaveServiceHelper.saveOperate((String)"sim_red_confirm_bill", (DynamicObject[])insertConfirmList.toArray(new DynamicObject[0]), null)).isSuccess()) {
            throw new KDBizException(OperationConstant.getErrorMsg((OperationResult)operationResult));
        }
        this.assignRedConfirm(request.getOrgId(), "0".equals(request.getIdentity()) ? RedInfoConstant.ApplicantEnum.SALER.getCode() : RedInfoConstant.ApplicantEnum.BUYERNODEDUCTED.getCode(), redConfirmList);
    }

    public static void buildRedConfirmApply(RedConfirmBillApplyRequest request, DynamicObject redConfirmBill) {
        BigDecimal originalInvoiceAmount;
        request.setLrfsf(RedInfoConstant.ApplicantEnum.SALER.getCode().equals(redConfirmBill.getString("applicant")) ? "0" : "1");
        BigDecimal originalTotalTax = redConfirmBill.getBigDecimal("originaltotaltax");
        if (originalTotalTax == null || originalTotalTax.compareTo(BigDecimal.ZERO) == 0) {
            originalTotalTax = request.getHzcxse().negate();
        }
        if ((originalInvoiceAmount = redConfirmBill.getBigDecimal("originalinvoiceamount")) == null || originalInvoiceAmount.compareTo(BigDecimal.ZERO) == 0) {
            originalInvoiceAmount = request.getHzcxje().negate();
        }
        request.setLzhjje(originalInvoiceAmount == null ? BigDecimal.ZERO : originalInvoiceAmount.setScale(2, 4));
        request.setLzhjse(originalTotalTax == null ? BigDecimal.ZERO : originalTotalTax.setScale(2, 4));
        String originInvoiceType = redConfirmBill.getString("originalinvoicetype");
        request.setSfzzfpbz(InvoiceUtils.isEtcInvoice((String)originInvoiceType) ? "N" : "Y");
        if (InvoiceUtils.isSpecialInvoice((String)originInvoiceType) || InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(originInvoiceType)) {
            request.setLzfppzDm("01");
        } else if (InvoiceUtils.isNormalInvoice((String)originInvoiceType) || InvoiceType.ALL_E_NORMAL.getTypeCode().equals(originInvoiceType)) {
            request.setLzfppzDm("02");
        }
        request.setLzfpTdyslxDm(InvoiceSpecialType.InvoiceSpecialTypeEnum.getLqCodeBySpecialType((String)redConfirmBill.getString("specialtype")));
        boolean addOne = RedConfirmOriginalSeqHelper.checkAddOne((String)redConfirmBill.getString("originalinvoicecode"), (String)redConfirmBill.getString("originalinvoiceno"));
        List hzqrdmxList = request.getHzqrdmxList();
        for (int i = 0; i < hzqrdmxList.size(); ++i) {
            String goodsName;
            RedConfirmBillItem item = (RedConfirmBillItem)hzqrdmxList.get(i);
            item.setXh(Integer.valueOf(i + 1));
            if (addOne) {
                item.setLzmxxh(Integer.valueOf(item.getLzmxxh() + 1));
            }
            if (StringUtils.isNotBlank((CharSequence)item.getFpspdj()) && BigDecimal.ZERO.compareTo(new BigDecimal(item.getFpspdj())) == 0) {
                item.setFpspdj("");
                item.setFpspsl("");
            }
            if (StringUtils.isNotBlank((CharSequence)item.getFpspsl()) && BigDecimal.ZERO.compareTo(new BigDecimal(item.getFpspsl())) == 0) {
                item.setFpspdj("");
                item.setFpspsl("");
            }
            if (StringUtils.isBlank((CharSequence)item.getSpfwjc())) {
                DynamicObject taxCode = TaxClassCodeCheckHelper.geTaxCode((String)item.getSphfwssflhbbm());
                item.setSpfwjc(taxCode.getString("simplename"));
            }
            if ((goodsName = item.getHwhyslwfwmc()).contains(item.getSpfwjc())) {
                item.setXmmc(goodsName.replaceAll("^\\*[A-Za-z0-9\\u4E00-\\u9FA5]+\\*", ""));
                continue;
            }
            item.setHwhyslwfwmc(String.format("*%s*%s", item.getSpfwjc(), goodsName));
        }
        if (InvoiceSpecialType.allEleSpecialType((String)redConfirmBill.getString("specialtype"))) {
            RedConfirmBillHelper.buildSpecialType(redConfirmBill, request);
        }
        RedConfirmBillHelper.setBuyerPerson(request, redConfirmBill);
        if ("02".equals(redConfirmBill.getString("specialtype"))) {
            RedConfirmBillHelper.reverseBuyer(redConfirmBill, request);
        }
    }

    private DynamicObject matchRedConfirm(DynamicObject redConfirmOriInvoice, AllEleRedConfirmDownLoadResponseDTO datum) {
        try {
            if (datum.getItems() == null) {
                return null;
            }
            DynamicObjectCollection items = redConfirmOriInvoice.getDynamicObjectCollection("items");
            if (items.size() != datum.getItems().size()) {
                return null;
            }
            Map<Integer, DynamicObject> itemMap = items.stream().collect(Collectors.toMap(k -> k.getInt("originseq"), v -> v, (v1, v2) -> v1));
            List downItems = datum.getItems();
            for (AllEleRedConfirmItemDownLoadResponseDTO downItem : downItems) {
                Integer blueInvoiceItemIndex = downItem.getBlueInvoiceItemIndex();
                if (blueInvoiceItemIndex == null) {
                    return null;
                }
                DynamicObject item = itemMap.get(blueInvoiceItemIndex);
                if (item == null) {
                    return null;
                }
                if (!StringUtils.trimToEmpty((String)item.getString("specification")).equals(StringUtils.trimToEmpty((String)downItem.getSpecModel()))) {
                    return null;
                }
                if (!StringUtils.trimToEmpty((String)item.getString("unit")).equals(StringUtils.trimToEmpty((String)downItem.getUnit()))) {
                    return null;
                }
                if (item.getBigDecimal("amount").setScale(2, 4).compareTo(downItem.getDetailAmount()) != 0) {
                    return null;
                }
                if (item.getBigDecimal("tax").setScale(2, 4).compareTo(downItem.getTaxAmount()) == 0) continue;
                return null;
            }
            return redConfirmOriInvoice;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void setBuyerPerson(RedConfirmBillApplyRequest request, DynamicObject redConfirmBill) {
        String buyerProperty = redConfirmBill.getString("buyerproperty");
        if (StringUtils.isBlank((CharSequence)buyerProperty) || !"1".equals(buyerProperty)) {
            logger.info("\u975e\u4e2a\u4eba\u7968\uff0c\u4e0d\u7528\u8865\u5145\u4e2a\u4eba");
            return;
        }
        String originalInvoiceType = redConfirmBill.getString("originalinvoicetype");
        if (StringUtils.isBlank((CharSequence)originalInvoiceType) || !InvoiceUtils.isAllEInvoice((Object)originalInvoiceType)) {
            logger.info("\u539f\u84dd\u7968\u975e\u6570\u7535\u7968\uff0c\u4e0d\u7528\u8865\u5145\u4e2a\u4eba");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)request.getGmfmc()) && !request.getGmfmc().endsWith("\uff08\u4e2a\u4eba\uff09")) {
            String gmfmc = request.getGmfmc().replaceAll("\uff08\u4e2a\u4eba\uff09", "");
            gmfmc = gmfmc.replaceAll("\\(\u4e2a\u4eba\\)", "") + "\uff08\u4e2a\u4eba\uff09";
            request.setGmfmc(gmfmc);
            redConfirmBill.set("buyername", (Object)gmfmc);
        }
    }

    public void assignRedConfirm(Long orgId, String applicant, List<DynamicObject> redConfirmList) {
        if (CollectionUtils.isEmpty(redConfirmList)) {
            return;
        }
        HashSet<String> taxNoSet = new HashSet<String>(redConfirmList.size());
        for (DynamicObject redConfirm : redConfirmList) {
            taxNoSet.add(redConfirm.getString("salertaxno"));
            taxNoSet.add(redConfirm.getString("buyertaxno"));
        }
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"epinfo.number", (QFilter[])new QFilter("epinfo.number", "in", taxNoSet).toArray());
        Map<String, List<DynamicObject>> orgGroup = Arrays.stream(orgs).collect(Collectors.groupingBy(k -> k.getString("epinfo.number")));
        Map<String, List<DynamicObject>> redConfirmGroup = redConfirmList.stream().collect(Collectors.groupingBy(k -> k.getString(RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant) ? "buyertaxno" : "salertaxno")));
        Set<Map.Entry<String, List<DynamicObject>>> entries = redConfirmGroup.entrySet();
        for (Map.Entry<String, List<DynamicObject>> entry : entries) {
            List<DynamicObject> othersideOrgList = orgGroup.get(entry.getKey());
            if (CollectionUtils.isEmpty(othersideOrgList)) continue;
            List<DynamicObject> redConfirms = entry.getValue();
            Map<Long, List<DynamicObject>> redConfirmOrg = redConfirms.stream().collect(Collectors.groupingBy(k -> DynamicObjectUtil.getDynamicObjectLongValue((Object)k.get("org"))));
            Set<Map.Entry<Long, List<DynamicObject>>> redConfirmOrgEntries = redConfirmOrg.entrySet();
            for (Map.Entry<Long, List<DynamicObject>> redConfirmOrgEntry : redConfirmOrgEntries) {
                Set orgIds = othersideOrgList.stream().map(k -> DynamicObjectUtil.getDynamicObjectLongValue((Object)k.getPkValue())).collect(Collectors.toSet());
                orgIds.add(orgId);
                Long confirmOrgId = redConfirmOrgEntry.getKey();
                if (orgId.equals(confirmOrgId)) {
                    orgIds.remove(confirmOrgId);
                }
                if (orgIds.size() == 0) continue;
                for (DynamicObject redConfirm : redConfirms) {
                    redConfirm.set("ctrlstrategy", (Object)"2");
                }
                BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])redConfirms.toArray(new DynamicObject[0]));
                BaseDataServiceHelper.batchAssignWithDetail((String)"sim_red_confirm_bill", (Long)redConfirmOrgEntry.getKey(), redConfirms.stream().map(k -> DynamicObjectUtil.getDynamicObjectLongValue((Object)k.getPkValue())).collect(Collectors.toList()), new ArrayList(orgIds));
                ImcSaveServiceHelper.save(redConfirms);
            }
        }
    }

    public static boolean checkOriginalInvoiceStartZero(String originalInvoiceCode, String originalInvoiceNo) {
        QFilter qFilter = InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)(originalInvoiceCode == null ? "" : originalInvoiceCode), (String)originalInvoiceNo);
        qFilter.and("items.seq", "=", (Object)0);
        return QueryServiceHelper.exists((String)"sim_vatinvoice", (QFilter[])qFilter.toArray());
    }

    public static void addOriginalSeq(AllEleIssueRequestDTO allEleIssueRequestDTO) {
        if (!RedConfirmOriginalSeqHelper.checkAddOne((String)allEleIssueRequestDTO.getOriginalInvoiceCode(), (String)allEleIssueRequestDTO.getOriginalInvoiceNo())) {
            return;
        }
        for (AllEleIssueItemRequestDTO item : allEleIssueRequestDTO.getItems()) {
            if (StringUtils.isEmpty((CharSequence)item.getLineNumber())) continue;
            int lineNumber = Integer.parseInt(item.getLineNumber()) + 1;
            item.setLineNumber(lineNumber + "");
        }
    }

    public static void dealGetTravlerDataMethod(DynamicObject redConfirm, DynamicObject blueInvoiceDO) {
        String specialType = blueInvoiceDO.getString("specialtype");
        if ("E09".equals(specialType)) {
            DynamicObjectCollection travlerCollection = blueInvoiceDO.getDynamicObjectCollection("travelers");
            if (travlerCollection == null || travlerCollection.isEmpty()) {
                return;
            }
            DynamicObjectCollection dynamicObjectCollection = redConfirm.getDynamicObjectCollection("travelers");
            for (DynamicObject travelObject : travlerCollection) {
                DynamicObject dynamicObject = dynamicObjectCollection.addNew();
                dynamicObject.set("traveler", (Object)travelObject.getString("traveler"));
                dynamicObject.set("travelercardno", (Object)travelObject.getString("travelercardno"));
                dynamicObject.set("travelercardtype", (Object)travelObject.getString("travelercardtype"));
                dynamicObject.set("travelertransporttype", (Object)travelObject.getString("travelertransporttype"));
                dynamicObject.set("travelerstartplace", (Object)travelObject.getString("travelerstartplace"));
                dynamicObject.set("travelerendplace", (Object)travelObject.getString("travelerendplace"));
                dynamicObject.set("traveldate", (Object)travelObject.getDate("traveldate"));
                dynamicObject.set("travelerseatclass", (Object)travelObject.getString("travelerseatclass"));
            }
        }
    }

    private void updateExistRedConfirm(DynamicObject redConfirm, AllEleRedConfirmDownLoadResponseDTO datum) {
        if (StringUtils.isNotBlank((CharSequence)datum.getEnterIdentity())) {
            redConfirm.set("enteridentity", (Object)datum.getEnterIdentity());
        }
        redConfirm.set("confirmstatus", (Object)datum.getRedConfirmBillStatus());
        redConfirm.set("uploadstatus", (Object)"1");
        if (StringUtils.isNotBlank((CharSequence)datum.getRedConfirmEnterDate())) {
            redConfirm.set("uploaddate", (Object)DateUtils.handleDate((String)datum.getRedConfirmEnterDate()));
        }
        redConfirm.set("govuuid", (Object)datum.getGovRedConfirmBillUuid());
        redConfirm.set("number", (Object)datum.getRedConfirmBillNo());
        if (StringUtils.isNotBlank((CharSequence)datum.getBlueInvoiceDate())) {
            redConfirm.set("originalissuetime", (Object)DateUtils.handleDate((String)datum.getBlueInvoiceDate()));
        }
        if (StringUtils.isNotBlank((CharSequence)datum.getSpecialType())) {
            redConfirm.set("specialtype", (Object)datum.getSpecialType());
        }
        if (StringUtils.isNotBlank((CharSequence)datum.getRedInvoiceDate())) {
            redConfirm.set("issuetime", (Object)DateUtils.handleDate((String)datum.getRedInvoiceDate()));
        }
        if (!"Y".equals(redConfirm.getString("goodsnamesame"))) {
            if ("Y".equals(datum.getGoodsNameIsSame())) {
                redConfirm.set("goodsnamesame", (Object)"Y");
            } else {
                redConfirm.set("goodsnamesame", (Object)"N");
            }
        }
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)redConfirm.getString("invoicetype"));
        if ("1".equals(datum.getEnterIdentity()) && "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.UPDATE_REDCONFIRM_BILL_ITEM)) || "1".equals(ImcConfigUtil.getValue((String)"dealHonorData", (String)"dealHonorData"))) {
            DynamicObject dbRow;
            int i;
            DynamicObjectCollection items = redConfirm.getDynamicObjectCollection("items");
            List datumItems = datum.getItems();
            if (null == datumItems || datumItems.size() == 0 || null == items) {
                return;
            }
            if (null == ((AllEleRedConfirmItemDownLoadResponseDTO)datumItems.get(0)).getBlueInvoiceItemIndex() || 0 == ((AllEleRedConfirmItemDownLoadResponseDTO)datumItems.get(0)).getBlueInvoiceItemIndex()) {
                return;
            }
            if (items.size() != datumItems.size()) {
                return;
            }
            boolean isEquals = true;
            for (i = 0; i < items.size(); ++i) {
                String specification;
                dbRow = (DynamicObject)items.get(i);
                String dbGoodsName = dbRow.getString("goodsname");
                String dbSpecification = StringUtils.isBlank((CharSequence)dbRow.getString("specification")) ? null : dbRow.getString("specification");
                BigDecimal dbAmount = dbRow.getBigDecimal("amount");
                Long dbBlueSeq = dbRow.getLong("originseq");
                AllEleRedConfirmItemDownLoadResponseDTO dto = (AllEleRedConfirmItemDownLoadResponseDTO)datumItems.get(i);
                String goodsName = dto.getGoodsName();
                BigDecimal amount = null == dto.getDetailAmount() ? BigDecimal.ZERO : dto.getDetailAmount();
                String string = specification = StringUtils.isBlank((CharSequence)dto.getSpecModel()) ? null : dto.getSpecModel();
                if (!Objects.equals(dbGoodsName, goodsName)) {
                    isEquals = false;
                }
                if (!Objects.equals(dbSpecification, specification)) {
                    isEquals = false;
                }
                if (dbAmount.compareTo(amount) != 0) {
                    isEquals = false;
                }
                if (Objects.equals(String.valueOf(dbBlueSeq), String.valueOf(dto.getBlueInvoiceItemIndex()))) continue;
                isEquals = false;
            }
            if (!isEquals) {
                for (i = 0; i < items.size(); ++i) {
                    dbRow = (DynamicObject)items.get(i);
                    AllEleRedConfirmItemDownLoadResponseDTO dto = (AllEleRedConfirmItemDownLoadResponseDTO)datumItems.get(i);
                    DynamicObjectUtil.bean2DynamicObject((Object)dto, (DynamicObject)dbRow);
                    dbRow.set("billsourceid", null);
                    dbRow.set("originalinvoiceitemid", null);
                    dbRow.set("rowtype", (Object)"0");
                    dbRow.set("taxamount", (Object)dbRow.getBigDecimal("amount").add(dbRow.getBigDecimal("tax")));
                    dbRow.set("taxunitprice", (Object)PriceHelper.calTaxUnitPrice((BigDecimal)dbRow.getBigDecimal("unitprice"), (BigDecimal)dbRow.getBigDecimal("taxrate"), (boolean)isAllEle));
                }
            }
        }
    }

    public static AllEleResponseListDTO<AllEleRedConfirmDownLoadResponseDTO> downloadRedConfirmHeadFromLq(AllEleRedConfirmDownLoadRequestDTO request, SaleInfo saleInfo) {
        AllEleResponseListDTO responseListDTO = new AllEleResponseListDTO();
        responseListDTO.setErrcode(ErrorType.SUCCESS.getCode());
        RedConfirmDownloadHeadRequest lqRequest = RedConfirmBillHelper.formatLqRequest(request, saleInfo);
        try {
            RedConfirmDownloadHeadResponse lqResponse = RedConfirmBillHelper.queryRedConfirmListByLq(lqRequest);
            List lqList = lqResponse.getList();
            if (lqList == null || lqList.isEmpty()) {
                responseListDTO.setData(new ArrayList(1));
                return responseListDTO;
            }
            ArrayList downloadList = new ArrayList(lqList.size());
            lqList.forEach(head -> {
                AllEleRedConfirmDownLoadResponseDTO downloadInvoice = new AllEleRedConfirmDownLoadResponseDTO();
                downloadInvoice.setSalerTaxNo(head.getXsfnsrsbh());
                downloadInvoice.setSalerName(head.getXsfmc());
                downloadInvoice.setGovRedConfirmBillUuid(head.getUuid());
                downloadInvoice.setRedConfirmBillNo(head.getHzfpxxqrdbh());
                downloadInvoice.setRedConfirmBillStatus(head.getHzqrxxztDm());
                downloadInvoice.setEnterIdentity(head.getLrfsf());
                downloadInvoice.setRedInvoiceNo(head.getHzfphm());
                downloadInvoice.setRedConfirmEnterDate(head.getLrrq());
                downloadInvoice.setBlueInvoiceDate(head.getLzkprq());
                downloadList.add(downloadInvoice);
            });
            responseListDTO.setPageNo(lqResponse.getPageNumber().intValue());
            responseListDTO.setPageSize(lqResponse.getPageSize().intValue());
            responseListDTO.setTotalElement(lqResponse.getTotal().intValue());
            responseListDTO.setData(downloadList);
            return responseListDTO;
        }
        catch (Exception e) {
            responseListDTO.setErrcode(ApiErrCodeEnum.ERROR.getCode());
            responseListDTO.setDescription(e.getMessage());
            return responseListDTO;
        }
    }

    public static DynamicObject formatBillVoConfirm(BillVo bill, String orderNo, DynamicObject invoice, Map<Integer, DynamicObject> invoiceDetailSeqMap) {
        String billNo = bill.getBillNo();
        String redReason = RedConfirmBillRedReasonEnum.getCodeByBillCode((String)bill.getRedReason());
        String account = bill.getAccount();
        DynamicObject redConfirm = DynamicObjectUtil.bean2DynamicObject((Object)bill, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sim_red_confirm_bill"));
        redConfirm.set("issuetime", null);
        Map extraField = ImcConfigUtil.getValue((String)"bill_extra_field");
        if (!extraField.isEmpty()) {
            QFilter qFilter = new QFilter("orgid", "=", (Object)bill.getOrgId());
            qFilter.and("billno", "=", (Object)billNo);
            DynamicObject billDO = BusinessDataServiceHelper.loadSingle((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill"), (QFilter[])qFilter.toArray());
            for (Map.Entry entry : extraField.entrySet()) {
                String field = (String)entry.getKey();
                redConfirm.set(field, billDO.get(field));
            }
        }
        DynamicObjectCollection items = redConfirm.getDynamicObjectCollection("items");
        items.clear();
        if (StringUtils.isNotBlank((CharSequence)account)) {
            redConfirm.set("account", (Object)account);
        } else {
            redConfirm.set("account", (Object)"");
        }
        List billDetailVos = bill.getBillDetail();
        for (int i = 0; i < billDetailVos.size(); ++i) {
            BillDetailVo billDetailVo = (BillDetailVo)billDetailVos.get(i);
            DynamicObject item = items.addNew();
            item = DynamicObjectUtil.bean2DynamicObject((Object)billDetailVo, (DynamicObject)item);
            String privilegeFlag = billDetailVo.getPrivilegeFlag() + "";
            String privilegeContent = billDetailVo.getPrivilegeContent();
            if (StringUtils.isNotEmpty((CharSequence)privilegeFlag) && "1".equals(privilegeFlag)) {
                item.set("taxpremark", (Object)"1");
                item.set("zzstsgl", (Object)privilegeContent);
            }
            item.set("seq", (Object)(i + 1));
            item.set("goodsname", invoiceDetailSeqMap.get(billDetailVo.getOriginalSeq()).get("goodsname"));
            item.set("rowtype", (Object)"0");
            item.set("originalinvoiceitemid", invoiceDetailSeqMap.get(billDetailVo.getOriginalSeq()).get("id"));
            item.set("originseq", (Object)billDetailVo.getOriginalSeq());
            if (!"04".equals(redReason)) continue;
            item.set("num", (Object)BigDecimal.ZERO);
            item.set("unitprice", (Object)BigDecimal.ZERO);
            item.set("taxunitprice", (Object)BigDecimal.ZERO);
        }
        redConfirm.set("org", invoice.get("orgid"));
        redConfirm.set("useorg", invoice.get("orgid"));
        redConfirm.set("createorg", invoice.get("orgid"));
        redConfirm.set("ctrlstrategy", (Object)"7");
        redConfirm.set("issuestatus", (Object)IssueStatusEnum.none.getCode());
        redConfirm.set("originalinvoiceno", invoice.get("invoiceno"));
        redConfirm.set("originalinvoicecode", invoice.get("invoicecode"));
        redConfirm.set("invoiceno", (Object)"");
        redConfirm.set("originalissuetime", invoice.get("issuetime"));
        String originalInvoiceType = invoice.getString("invoicetype");
        redConfirm.set("originalinvoicetype", (Object)originalInvoiceType);
        redConfirm.set("originalinvoiceamount", invoice.get("invoiceamount"));
        redConfirm.set("originaltotaltax", invoice.get("totaltax"));
        redConfirm.set("invoicetype", (Object)InvoiceType.blueTypeToAllEType((String)originalInvoiceType));
        if (StringUtils.isNotEmpty((CharSequence)orderNo)) {
            redConfirm.set("orderno", (Object)orderNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)billNo)) {
            redConfirm.set("billno", (Object)billNo);
        }
        String specialType = InvoiceSpecialType.InvoiceSpecialTypeEnum.getCodeBySpecialType((String)invoice.getString("specialtype"));
        redConfirm.set("specialtype", (Object)specialType);
        redConfirm.set("systemsource", (Object)invoice.getString("systemsource"));
        redConfirm.set("uploadstatus", (Object)"0");
        redConfirm.set("applicant", (Object)RedInfoConstant.ApplicantEnum.SALER.getCode());
        redConfirm.set("enteridentity", (Object)"0");
        redConfirm.set("redreason", (Object)redReason);
        redConfirm.set("source", (Object)"4");
        redConfirm.set("status", (Object)BillHelper.getBillStatusByTableName((String)"sim_red_confirm_bill", (String)redConfirm.getString("source")));
        redConfirm.set("enable", (Object)"1");
        redConfirm.set("creator", (Object)RequestContext.get().getUserId());
        return redConfirm;
    }
}

