/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.risk.control;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.table.RiskControlConfigConstant;
import kd.imc.bdm.common.constant.table.RiskControlRangeEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.NumberGenerateUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.constant.RiskControlRecordConstant;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.match.ConditionMatchHelper;
import org.apache.commons.collections.CollectionUtils;

public class BillRiskControlService {
    private static final Log LOGGER = LogFactory.getLog(BillRiskControlService.class);
    private static final String LOCK_KEY_PRE = "SIM:RISK:CONTROL:";
    private static final String QUERY_FIELDS = "id,bizno,riskstatus,unlockuser,unlocktime";

    public static boolean riskControl(Object[] ids, String formId, RiskControlRecordConstant.ExecuteActionEnum executeActionEnum, AbstractFormPlugin that, String callBackKey) {
        if (ids == null || ids.length == 0) {
            return false;
        }
        List<DynamicObject> list = Arrays.stream(ids).map(id -> BusinessDataServiceHelper.loadSingle((Object)id, (String)formId)).filter(Objects::nonNull).collect(Collectors.toList());
        return BillRiskControlService.riskControl(list, formId, executeActionEnum, that, callBackKey);
    }

    public static boolean riskControl(List<DynamicObject> dataList, String formId, RiskControlRecordConstant.ExecuteActionEnum executeActionEnum, AbstractFormPlugin that, String callBackKey) {
        boolean antiReplayControlFlag = false;
        JSONObject checkJson = BillRiskControlService.riskControl(dataList, formId, executeActionEnum);
        Set errorMsgSet = (Set)checkJson.get((Object)"ERROR_SET");
        String intensity = checkJson.getString("intensity");
        if (!errorMsgSet.isEmpty()) {
            List<String> errorMsgList = errorMsgSet.stream().sorted().collect(Collectors.toList());
            if ("high".equals(intensity)) {
                errorMsgList.forEach(errorMsg -> that.getView().showErrorNotification(errorMsg));
            } else if ("middle".equals(intensity)) {
                Object[] primaryKeyValues = (Object[])checkJson.get((Object)"RISK_PRIMARY_KEY_ARR");
                if (primaryKeyValues != null && primaryKeyValues.length > 0) {
                    that.getView().getPageCache().put("RISK_PRIMARY_KEY_ARR", SerializationUtils.toJsonString((Object)primaryKeyValues));
                }
                ViewUtil.openConfirm((String)callBackKey, (String)ResManager.loadKDString((String)"\u5b58\u5728\u4ee5\u4e0b\u4e2d\u98ce\u9669\u63a7\u5236\uff0c\u662f\u5426\u7ee7\u7eed\u5f00\u7968\uff1f", (String)"BillRiskControlService_2", (String)"imc-sim-service", (Object[])new Object[0]), (AbstractFormPlugin)that, (String)ResManager.loadKDString((String)"\u53d6\u6d88", (String)"BillRiskControlService_3", (String)"imc-sim-service", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u786e\u8ba4", (String)"BillRiskControlService_4", (String)"imc-sim-service", (Object[])new Object[0]), (String)errorMsgList.stream().collect(Collectors.joining(System.lineSeparator())));
            }
            antiReplayControlFlag = true;
        }
        return antiReplayControlFlag;
    }

    public static ApiResult riskControlSingleApi(DynamicObject data, String formId, RiskControlRecordConstant.ExecuteActionEnum executeActionEnum) {
        LOGGER.info("riskControlSingleApi start ");
        JSONObject dataBizJson = BillRiskControlService.riskControlSingle(data, formId, executeActionEnum);
        LOGGER.info("riskControlSingleApi end{}", (Object)dataBizJson);
        return BillRiskControlService.getApiResult(dataBizJson);
    }

    public static ApiResult riskControlSingleOpenApi(DynamicObject data, String formId, RiskControlRecordConstant.ExecuteActionEnum executeActionEnum) {
        LOGGER.info("riskControlSingleOpenApi start");
        JSONObject dataBizJson = BillRiskControlService.riskControlSingle(data, formId, executeActionEnum);
        LOGGER.info("riskControlSingleOpenApi end{}", (Object)dataBizJson);
        if (dataBizJson != null && !dataBizJson.isEmpty()) {
            LOGGER.info("\u5b58\u5728\u88ab\u98ce\u63a7\u7684\u6570\u636e{}", (Object)dataBizJson);
            for (Map.Entry entry : dataBizJson.entrySet()) {
                String key = (String)entry.getKey();
                String value = entry.getValue().toString();
                String riskMsg = BillRiskControlService.getSubstringAfterKey(value, String.valueOf('\u3011'));
                if (!StringUtils.isNotBlank((CharSequence)riskMsg)) continue;
                ApiResult fail = ResponseVo.fail((String)ApiErrCodeEnum.BILL_RISK_CONTROL.getCode(), (String)riskMsg);
                fail.setData((Object)key);
                return fail;
            }
            return null;
        }
        return null;
    }

    private static JSONObject riskControlSingle(DynamicObject data, String formId, RiskControlRecordConstant.ExecuteActionEnum executeActionEnum) {
        RiskControlRangeEnum riskControlRangeEnum = RiskControlRangeEnum.getRiskControlRangeEnumByFormId((String)formId);
        if (riskControlRangeEnum == null) {
            return null;
        }
        JSONObject riskResult = BillRiskControlService.riskControl(data, formId, riskControlRangeEnum, executeActionEnum);
        if (riskResult == null) {
            return null;
        }
        return riskResult.getJSONObject("DATA_BIZ_NO_MAP");
    }

    public static JSONObject riskControl(List<DynamicObject> dataList, String formId, RiskControlRecordConstant.ExecuteActionEnum executeActionEnum) {
        String intensity = null;
        HashSet highErrorSet = new HashSet(8);
        HashSet<Object> middleErrorSet = new HashSet<Object>(8);
        HashSet<Object> dataKeySet = new HashSet<Object>(8);
        HashMap<String, String> dataBizMap = new HashMap<String, String>(8);
        Object[] primaryKeyValues = new Object[8];
        for (DynamicObject dynamicObject : dataList) {
            Object[] currentPrimaryKeyValues;
            Set errorStringSet;
            JSONObject errorMsgJson;
            RiskControlRangeEnum riskControlRangeEnum = RiskControlRangeEnum.getRiskControlRangeEnumByFormId((String)formId);
            if (riskControlRangeEnum == null || (errorMsgJson = BillRiskControlService.riskControl(dynamicObject, formId, riskControlRangeEnum, executeActionEnum)) == null || (errorStringSet = (Set)errorMsgJson.getObject("ERROR_SET", Set.class)) == null || errorStringSet.isEmpty()) continue;
            String bizNo = dynamicObject.getString((String)riskControlRangeEnum.getRecordMap().get((Object)"bizno"));
            JSONObject errorMap = errorMsgJson.getJSONObject("DATA_BIZ_NO_MAP");
            if (StringUtils.isNotEmpty((CharSequence)bizNo) && errorMap != null && !errorMap.isEmpty()) {
                String riskMsg = errorMap.getString(bizNo);
                BillRiskControlService.setRiskMsg(bizNo, riskMsg, dataBizMap);
            }
            dataKeySet.add(dynamicObject.getPkValue());
            String currentIntensity = errorMsgJson.getString("intensity");
            if ("high".equals(intensity) && !"high".equals(currentIntensity)) continue;
            intensity = currentIntensity;
            if ("high".equals(currentIntensity)) {
                highErrorSet.addAll(errorStringSet);
            } else {
                middleErrorSet.addAll(errorStringSet);
            }
            if ((currentPrimaryKeyValues = (Object[])errorMsgJson.get((Object)"RISK_PRIMARY_KEY_ARR")) == null) continue;
            primaryKeyValues = Stream.concat(Arrays.stream(primaryKeyValues), Arrays.stream(currentPrimaryKeyValues)).filter(Objects::nonNull).toArray(Object[]::new);
        }
        return BillRiskControlService.getRsJson(intensity, highErrorSet.isEmpty() ? middleErrorSet : highErrorSet, primaryKeyValues, dataBizMap, dataKeySet);
    }

    private static JSONObject riskControl(DynamicObject data, String formId, RiskControlRangeEnum riskControlRangeEnum, RiskControlRecordConstant.ExecuteActionEnum executeActionEnum) {
        LOGGER.info("riskControl start");
        boolean checkFlag = BillRiskControlService.checkDataStatus(data, riskControlRangeEnum, executeActionEnum);
        if (!checkFlag) {
            return null;
        }
        ImmutableMap recordMap = riskControlRangeEnum.getRecordMap();
        RiskControlRecordConstant.ExecuteActionEnum currentExecuteActionEnum = BillRiskControlService.getExecuteAction(data, (ImmutableMap<String, String>)recordMap, executeActionEnum);
        String number = data.getString((String)recordMap.get((Object)"bizno"));
        JSONObject lockRiskRecord = BillRiskControlService.getLockRiskRecord(number);
        if (lockRiskRecord != null) {
            return lockRiskRecord;
        }
        String orgField = (String)recordMap.get((Object)"bizorg");
        DynamicObject[] riskControlConfigArr = BillRiskControlService.getRiskControlConfigArr(data, formId, orgField);
        if (riskControlConfigArr == null) {
            return null;
        }
        DLock riskLock = null;
        String riskLockKey = LOCK_KEY_PRE + number;
        try {
            riskLock = DLock.create((String)riskLockKey);
            if (!riskLock.tryLock(500L)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u98ce\u63a7\u6821\u9a8c\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5", (String)"BillRiskControlService_0", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            HashSet<Object> highErrorSet = new HashSet<Object>(8);
            HashSet<Object> middleErrorSet = new HashSet<Object>(8);
            HashMap<String, String> dataBizMap = new HashMap<String, String>(8);
            HashSet<Object> dataKeySet = new HashSet<Object>(8);
            ArrayList<DynamicObject> riskRecordList = new ArrayList<DynamicObject>(8);
            for (DynamicObject riskControlConfig : riskControlConfigArr) {
                String filterTag;
                boolean verify;
                DynamicObject riskControlConfigFull = BusinessDataServiceHelper.loadSingle((Object)riskControlConfig.getPkValue(), (String)"bdm_risk_control_config");
                if (riskControlConfigFull == null || !(verify = ConditionMatchHelper.verify(filterTag = riskControlConfigFull.getString("filter_tag"), data))) continue;
                String riskControlType = riskControlConfigFull.getString("type");
                if ("antiReplay".equals(riskControlType)) {
                    if (RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_ISSUE != currentExecuteActionEnum) continue;
                    BillRiskControlService.antiReplayControl(riskControlConfigFull, data, riskControlRangeEnum, riskRecordList, highErrorSet, middleErrorSet, currentExecuteActionEnum);
                    continue;
                }
                if (!"buyerBlackList".equals(riskControlType)) continue;
                BillRiskControlService.buyerBlackListControl(riskControlConfigFull, data, riskControlRangeEnum, riskRecordList, highErrorSet, middleErrorSet, currentExecuteActionEnum);
            }
            Object[] primaryKeyValues = null;
            if (!riskRecordList.isEmpty()) {
                primaryKeyValues = BillRiskControlService.saveRiskRecordList(riskRecordList);
            }
            String bizNo = data.getString((String)recordMap.get((Object)"bizno"));
            HashSet<Object> errorMsgSet = new HashSet<Object>(highErrorSet);
            errorMsgSet.addAll(middleErrorSet);
            String result = errorMsgSet.stream().filter(element -> StringUtils.isNotEmpty((CharSequence)element.toString())).map(Object::toString).collect(Collectors.joining("|"));
            dataBizMap.put(bizNo, result);
            dataKeySet.add(data.getPkValue());
            boolean middle = highErrorSet.isEmpty();
            LOGGER.info("riskControl end");
            JSONObject jSONObject = BillRiskControlService.getRsJson(middle ? "middle" : "high", middle ? middleErrorSet : highErrorSet, primaryKeyValues, dataBizMap, dataKeySet);
            return jSONObject;
        }
        catch (Exception e) {
            LOGGER.error("antiReplayControl error:", (Object)data, (Object)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u98ce\u63a7\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5", (String)"BillRiskControlService_1", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        finally {
            if (riskLock != null) {
                riskLock.unlock();
            }
        }
    }

    private static RiskControlRecordConstant.ExecuteActionEnum getExecuteAction(DynamicObject data, ImmutableMap<String, String> recordMap, RiskControlRecordConstant.ExecuteActionEnum executeActionEnum) {
        BigDecimal totalAmount;
        if (RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_ISSUE == executeActionEnum && (totalAmount = data.getBigDecimal((String)recordMap.get((Object)"totalamount"))) != null && totalAmount.signum() < 0) {
            return RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_REVERSAL;
        }
        return executeActionEnum;
    }

    private static void buyerBlackListControl(DynamicObject riskControlConfigFull, DynamicObject data, RiskControlRangeEnum riskControlRangeEnum, List<DynamicObject> riskRecordList, Set<Object> highErrorSet, Set<Object> middleErrorSet, RiskControlRecordConstant.ExecuteActionEnum executeActionEnum) {
        String intensity = riskControlConfigFull.getString("intensity");
        boolean highIntensity = "high".equals(intensity);
        Set<Object> errorMsgSet = highIntensity ? highErrorSet : middleErrorSet;
        ImmutableMap recordMap = riskControlRangeEnum.getRecordMap();
        String buyerNameField = (String)recordMap.get((Object)"buyername");
        String buyerNoField = (String)recordMap.get((Object)"buyertaxno");
        String bizNoField = (String)recordMap.get((Object)"bizno");
        String buyerName = StringUtils.defaultString((String)data.getString(buyerNameField));
        String buyerNo = StringUtils.defaultString((String)data.getString(buyerNoField));
        String bizNo = StringUtils.defaultString((String)data.getString(bizNoField));
        DynamicObjectCollection blackEntityCollection = riskControlConfigFull.getDynamicObjectCollection("blackentity");
        for (DynamicObject blackEntity : blackEntityCollection) {
            String blackEpName = StringUtils.defaultString((String)blackEntity.getString("epname"));
            String blackTaxNo = StringUtils.defaultString((String)blackEntity.getString("taxno"));
            if (!buyerName.equals(blackEpName) || !buyerNo.equals(blackTaxNo)) continue;
            String caseNature = StringUtils.defaultString((String)blackEntity.getString("casenature"));
            String errorMsg = String.format("\u5355\u636e\u3010%s\u3011\u8d2d\u4e70\u65b9\u4e3a\u81ea\u5b9a\u4e49\u9ed1\u540d\u5355\u4f01\u4e1a\uff0c\u6848\u4ef6\u7c7b\u578b\u4e3a%s", bizNo, caseNature);
            if (!errorMsgSet.contains(errorMsg)) {
                DynamicObject riskControlRecord = BillRiskControlService.getRiskControlRecord(riskControlConfigFull, data, (ImmutableMap<String, String>)recordMap);
                riskControlRecord.set("riskmsg", (Object)errorMsg);
                riskControlRecord.set("oribizno", (Object)"");
                riskControlRecord.set("executeaction", (Object)executeActionEnum.getCode());
                riskRecordList.add(riskControlRecord);
            }
            errorMsgSet.add(errorMsg);
            break;
        }
    }

    private static void antiReplayControl(DynamicObject riskControlConfigFull, DynamicObject data, RiskControlRangeEnum riskControlRangeEnum, List<DynamicObject> riskRecordList, Set<Object> highErrorSet, Set<Object> middleErrorSet, RiskControlRecordConstant.ExecuteActionEnum executeActionEnum) {
        DynamicObject[] existDataArr;
        String dataEntityTypeName = data.getDataEntityType().getName();
        boolean originalBillFlag = RiskControlRangeEnum.SIM_ORIGINAL_BILL == riskControlRangeEnum;
        String numberField = originalBillFlag ? "billno" : "billno";
        String number = data.getString(numberField);
        String createTimeField = originalBillFlag ? "billdate" : "createtime";
        String itemField = originalBillFlag ? "sim_original_bill_item" : "items";
        String orderBy = createTimeField + " desc";
        String intensity = riskControlConfigFull.getString("intensity");
        boolean highIntensity = "high".equals(intensity);
        QFilter fieldQFilter = BillRiskControlService.getFieldQFilter(riskControlConfigFull, data, originalBillFlag);
        QFilter dateRangeQFilter = BillRiskControlService.getDateRangeQFilter(riskControlConfigFull, createTimeField);
        if (dateRangeQFilter != null) {
            fieldQFilter.and(dateRangeQFilter);
        }
        if ((existDataArr = BusinessDataServiceHelper.load((String)dataEntityTypeName, (String)("id," + numberField), (QFilter[])fieldQFilter.toArray(), (String)orderBy)) != null && existDataArr.length != 0) {
            Set<String> existNumberSet;
            Set<Object> errorMsgSet = highIntensity ? highErrorSet : middleErrorSet;
            Object itemSelectFlag = riskControlConfigFull.get("itemselectflag");
            if (Boolean.TRUE.equals(itemSelectFlag)) {
                Object[] ids = Arrays.stream(existDataArr).map(DataEntityBase::getPkValue).filter(Objects::nonNull).toArray();
                DynamicObject[] existDataFullArr = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dataEntityTypeName));
                String itemFieldsStr = riskControlConfigFull.getString("itemselectkeys");
                existNumberSet = BillRiskControlService.antiReplayControlItemMatch(data, existDataFullArr, itemFieldsStr, itemField, numberField);
            } else {
                existNumberSet = new HashSet<String>(existDataArr.length);
                Arrays.stream(existDataArr).forEach(existData -> existNumberSet.add(existData.getString(numberField)));
            }
            BillRiskControlService.setAntiReplayControlRiskRecordList(riskRecordList, errorMsgSet, number, existNumberSet, data, riskControlConfigFull, (ImmutableMap<String, String>)riskControlRangeEnum.getRecordMap(), executeActionEnum);
        }
    }

    private static boolean checkDataStatus(DynamicObject data, RiskControlRangeEnum riskControlRangeEnum, RiskControlRecordConstant.ExecuteActionEnum executeActionEnum) {
        boolean flag = true;
        if (RiskControlRangeEnum.SIM_ORIGINAL_BILL == riskControlRangeEnum) {
            String closeStatus = data.getString("closestatus");
            flag = "0".equals(data.getString("validstate")) && (StringUtils.isEmpty((CharSequence)closeStatus) || "0".equals(closeStatus)) && "A".equals(data.getString("billsourcetype"));
        } else if (RiskControlRangeEnum.SIM_INVOICE_WAIT == riskControlRangeEnum) {
            flag = !"4".equals(data.getString("buyertype")) && !"11".equals(data.getString("buyertype"));
        } else if (RiskControlRangeEnum.SIM_VAT_INVOICE == riskControlRangeEnum) {
            if (DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)data, (String)"issuestatus")) {
                flag = StringUtils.isEmpty((CharSequence)data.getString("issuestatus")) || IssueStatusEnum.none.getCode().equals(data.getString("issuestatus")) || IssueStatusEnum.failed.getCode().equals(data.getString("issuestatus"));
            }
        } else if (RiskControlRangeEnum.SIM_RED_CONFIRM_BILL == riskControlRangeEnum && DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)data, (String)"source")) {
            String source = data.getString("source");
            if (RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_ENTRY == executeActionEnum) {
                flag = "1".equals(source) || "4".equals(source);
            } else if (RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_CONFIRM == executeActionEnum) {
                flag = "2".equals(source) && !"01".equals(data.getString("confirmstatus"));
            } else if (RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_REVERSAL == executeActionEnum) {
                flag = "2".equals(source) && "01".equals(data.getString("confirmstatus"));
            }
        }
        return flag;
    }

    private static Object[] saveRiskRecordList(List<DynamicObject> riskRecordList) {
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(riskRecordList.size());
        for (DynamicObject riskRecord : riskRecordList) {
            Object riskConfigPk = riskRecord.getDynamicObject("riskconfig").getPkValue();
            String bizNo = riskRecord.getString("bizno");
            String oriBizNo = StringUtils.defaultString((String)riskRecord.getString("oribizno"));
            QFilter queryQ = new QFilter("riskconfig", "=", riskConfigPk).and("bizno", "=", (Object)bizNo).and("oribizno", "=", (Object)oriBizNo);
            DynamicObject existData = BusinessDataServiceHelper.loadSingle((String)"sim_risk_control_record", (String)"id", (QFilter[])queryQ.toArray());
            if (existData != null) continue;
            saveList.add(riskRecord);
        }
        if (!saveList.isEmpty()) {
            ImcSaveServiceHelper.save(saveList);
        }
        return saveList.stream().map(DataEntityBase::getPkValue).filter(Objects::nonNull).toArray();
    }

    private static void setAntiReplayControlRiskRecordList(List<DynamicObject> riskRecordList, Set<Object> errorMsgSet, String number, Set<String> existNumberSet, DynamicObject data, DynamicObject riskControlConfigFull, ImmutableMap<String, String> recordMap, RiskControlRecordConstant.ExecuteActionEnum executeActionEnum) {
        if (existNumberSet == null || existNumberSet.isEmpty()) {
            return;
        }
        for (String existNumber : existNumberSet) {
            String errorMsg;
            if (existNumber.equals(number) || errorMsgSet.contains(errorMsg = String.format("\u5355\u636e\u3010%s\u3011\u4e0e\u5df2\u5f00\u7968\u5355\u636e\u3010%s\u3011\u6570\u636e\u5b8c\u5168\u4e00\u81f4", number, existNumber))) continue;
            errorMsgSet.add(errorMsg);
            DynamicObject riskControlRecord = BillRiskControlService.getRiskControlRecord(riskControlConfigFull, data, recordMap);
            riskControlRecord.set("riskmsg", (Object)errorMsg);
            riskControlRecord.set("oribizno", (Object)existNumber);
            riskControlRecord.set("executeaction", (Object)executeActionEnum.getCode());
            riskRecordList.add(riskControlRecord);
        }
    }

    private static Set<String> antiReplayControlItemMatch(DynamicObject data, DynamicObject[] existDataArr, String itemFieldsStr, String itemField, String numberField) {
        DynamicObjectCollection dataItemList = data.getDynamicObjectCollection(itemField);
        if (dataItemList == null || dataItemList.isEmpty()) {
            return null;
        }
        int dataItemSize = dataItemList.size();
        HashSet<String> existNumberSet = new HashSet<String>(dataItemSize);
        String[] itemFieldsArr = itemFieldsStr.split(",");
        List<String> itemList = BillRiskControlService.getItemListByItemFields(dataItemList, itemFieldsArr);
        for (DynamicObject existData : existDataArr) {
            List<String> currentItemList;
            boolean equals;
            DynamicObjectCollection existDataItemList = existData.getDynamicObjectCollection(itemField);
            if (existDataItemList == null || dataItemSize != existDataItemList.size() || !(equals = Objects.equals(itemList, currentItemList = BillRiskControlService.getItemListByItemFields(existDataItemList, itemFieldsArr)))) continue;
            String existNumber = existData.getString(numberField);
            existNumberSet.add(existNumber);
        }
        return existNumberSet;
    }

    private static List<String> getItemListByItemFields(DynamicObjectCollection itemList, String[] itemFieldsArr) {
        ArrayList<String> itemValueList = new ArrayList<String>(itemList.size());
        for (DynamicObject item : itemList) {
            StringBuilder builder = new StringBuilder();
            for (String itemField : itemFieldsArr) {
                builder.append(item.getString(itemField)).append(',');
            }
            itemValueList.add(builder.toString());
        }
        Collections.sort(itemValueList);
        return itemValueList;
    }

    private static DynamicObject[] getRiskControlConfigArr(DynamicObject data, String formId, String orgField) {
        Object orgId = data.get(orgField);
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"bdm_risk_control_config", (Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)orgId));
        if (filter == null) {
            return null;
        }
        filter.and("enable", "=", (Object)"1");
        filter.and("range", "=", (Object)formId);
        return BusinessDataServiceHelper.load((String)"bdm_risk_control_config", (String)"id", (QFilter[])filter.toArray());
    }

    private static QFilter getDateRangeQFilter(DynamicObject riskControlConfigFull, String createTimeField) {
        int scopeEndValue;
        String scopeUnit = riskControlConfigFull.getString("scopeunit");
        int scopeStartValue = riskControlConfigFull.getInt("scopestartvalue");
        if (scopeStartValue > (scopeEndValue = riskControlConfigFull.getInt("scopeendvalue"))) {
            scopeStartValue = riskControlConfigFull.getInt("scopeendvalue");
            scopeEndValue = riskControlConfigFull.getInt("scopestartvalue");
        }
        RiskControlConfigConstant.ScopeUnitEnum scopeUnitEnum = RiskControlConfigConstant.ScopeUnitEnum.getScopeUnitEnumByCode((String)scopeUnit);
        Date startDate = null;
        Date endDate = null;
        Date now = new Date();
        if (RiskControlConfigConstant.ScopeUnitEnum.SCOPE_UNIT_DAY == scopeUnitEnum) {
            startDate = DateUtils.addDay((Date)now, (int)(-scopeEndValue));
            endDate = DateUtils.addDay((Date)now, (int)(-scopeStartValue));
        } else if (RiskControlConfigConstant.ScopeUnitEnum.SCOPE_UNIT_MONTH == scopeUnitEnum) {
            startDate = DateUtils.addMonth((Date)now, (int)(-scopeEndValue));
            endDate = DateUtils.addMonth((Date)now, (int)(-scopeStartValue));
        }
        if (startDate != null) {
            return new QFilter(createTimeField, ">=", (Object)startDate).and(createTimeField, "<=", (Object)endDate);
        }
        return null;
    }

    private static QFilter getFieldQFilter(DynamicObject riskControlConfigFull, DynamicObject data, boolean originalBillFlag) {
        QFilter fieldQFilter;
        if (originalBillFlag) {
            QFilter billSourceQFilter = new QFilter("billsourcetype", "=", (Object)"A");
            QFilter confirmedQFilter = new QFilter("confirmstate", "=", (Object)"2");
            QFilter partQFilter = new QFilter("confirmstate", "=", (Object)"2");
            QFilter endQFilter = new QFilter("validstate", "=", (Object)"2");
            QFilter normalQFilter = new QFilter("validstate", "=", (Object)"0");
            fieldQFilter = billSourceQFilter.and(confirmedQFilter.and(endQFilter.or(normalQFilter)).or(partQFilter.and(normalQFilter)));
        } else {
            fieldQFilter = new QFilter("issuestatus", "!=", (Object)IssueStatusEnum.none.getCode());
        }
        Object headSelectFlag = riskControlConfigFull.get("headselectflag");
        if (Boolean.TRUE.equals(headSelectFlag)) {
            HashSet<String> dataSet = new HashSet<String>(8);
            String headFieldsStr = riskControlConfigFull.getString("headselectkeys");
            String[] headFieldArr = headFieldsStr.split(",");
            QFilter headFieldQFilter = BillRiskControlService.getFieldQFilter(data, headFieldArr, dataSet);
            if (headFieldQFilter != null) {
                fieldQFilter.and(headFieldQFilter);
            }
        }
        return fieldQFilter;
    }

    private static QFilter getFieldQFilter(DynamicObject data, String[] fieldArr, Set<String> dataSet) {
        QFilter fieldQFilter = null;
        for (String fieldStr : fieldArr) {
            String key;
            Object value;
            if (!DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)data, (String)fieldStr) || (value = data.get(fieldStr)) == null) continue;
            if (value instanceof DynamicObject) {
                value = ((DynamicObject)value).getPkValue();
            }
            if (dataSet.contains(key = fieldStr + "-" + value)) continue;
            dataSet.add(key);
            if (fieldQFilter == null) {
                fieldQFilter = new QFilter(fieldStr, "=", value);
                continue;
            }
            fieldQFilter.and(fieldStr, "=", value);
        }
        return fieldQFilter;
    }

    private static DynamicObject getRiskControlRecord(DynamicObject riskControlConfigFull, DynamicObject data, ImmutableMap<String, String> recordMap) {
        String recordNumber = NumberGenerateUtil.generateByPrefixWithRandom((String)"FKR", (int)3);
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"sim_risk_control_record");
        record.set("bizid", data.getPkValue());
        record.set("billno", (Object)recordNumber);
        record.set("billstatus", (Object)"C");
        record.set("creator", (Object)RequestContext.get().getCurrUserId());
        record.set("org", data.get((String)recordMap.get((Object)"bizorg")));
        record.set("riskstatus", (Object)"lock");
        recordMap.keySet().forEach(recordKey -> {
            if (DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)record, (String)recordKey)) {
                record.set(recordKey, data.get((String)recordMap.get(recordKey)));
            }
        });
        record.set("riskconfig", (Object)riskControlConfigFull);
        record.set("range", riskControlConfigFull.get("range"));
        record.set("type", riskControlConfigFull.get("type"));
        record.set("intensity", riskControlConfigFull.get("intensity"));
        return record;
    }

    private static JSONObject getLockRiskRecord(String number) {
        JSONObject highLockJson = BillRiskControlService.getLockRiskRecordByNumberAndIntensity(number, "high");
        if (highLockJson != null && !highLockJson.isEmpty()) {
            return highLockJson;
        }
        JSONObject middleLockJson = BillRiskControlService.getLockRiskRecordByNumberAndIntensity(number, "middle");
        if (middleLockJson != null && !middleLockJson.isEmpty()) {
            return middleLockJson;
        }
        QFilter qFilter = new QFilter("bizno", "=", (Object)number);
        DynamicObject existData = BusinessDataServiceHelper.loadSingle((String)"sim_risk_control_record", (String)"riskmsg", (QFilter[])qFilter.toArray());
        if (existData == null) {
            return null;
        }
        JSONObject rsJson = new JSONObject(1);
        rsJson.put("riskstatus", (Object)"unlock");
        return rsJson;
    }

    private static JSONObject getLockRiskRecordByNumberAndIntensity(String number, String riskIntensity) {
        QFilter qFilter = new QFilter("bizno", "=", (Object)number).and("riskstatus", "=", (Object)"lock").and("intensity", "=", (Object)riskIntensity);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"sim_risk_control_record", (String)"riskmsg", (QFilter[])qFilter.toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        HashSet<Object> errorSet = new HashSet<Object>(dynamicObjects.length);
        Object[] primaryKeyValues = new Object[dynamicObjects.length];
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dynamicObject = dynamicObjects[i];
            errorSet.add(dynamicObject.get("riskmsg"));
            primaryKeyValues[i] = dynamicObject.getPkValue();
        }
        QFilter dataQFilter = new QFilter("bizno", "=", (Object)number).and("riskstatus", "=", (Object)"lock");
        DynamicObject[] dataDynamicObjects = BusinessDataServiceHelper.load((String)"sim_risk_control_record", (String)"bizid,riskmsg", (QFilter[])dataQFilter.toArray());
        HashMap<String, String> dataBizMap = new HashMap<String, String>(8);
        HashSet<Object> dataKeySet = new HashSet<Object>(dataDynamicObjects.length);
        Arrays.stream(dataDynamicObjects).forEach(dataDynamicObject -> {
            if (dataDynamicObject != null) {
                String riskMsg = dataDynamicObject.getString("riskmsg");
                BillRiskControlService.setRiskMsg(number, riskMsg, dataBizMap);
                dataKeySet.add(dataDynamicObject.get("bizid"));
            }
        });
        return BillRiskControlService.getRsJson(riskIntensity, errorSet, primaryKeyValues, dataBizMap, dataKeySet);
    }

    private static JSONObject getRsJson(String riskIntensity, Set<Object> errorSet, Object[] primaryKeyValues, Map<String, String> dataBizMap, Set<Object> dataKeySet) {
        if (CollectionUtils.isEmpty(errorSet)) {
            dataBizMap = null;
            dataKeySet = null;
        }
        JSONObject rsJson = new JSONObject(3);
        rsJson.put("intensity", (Object)riskIntensity);
        rsJson.put("ERROR_SET", errorSet);
        rsJson.put("RISK_PRIMARY_KEY_ARR", (Object)primaryKeyValues);
        rsJson.put("DATA_BIZ_NO_MAP", dataBizMap);
        rsJson.put("DATA_BIZ_KEY_ARR", dataKeySet);
        return rsJson;
    }

    public static void unlockRiskRecord(AbstractFormPlugin that) {
        String primaryKeyValuesStr = that.getView().getPageCache().get("RISK_PRIMARY_KEY_ARR");
        Object[] primaryKeyValues = (Object[])SerializationUtils.fromJsonString((String)primaryKeyValuesStr, Object[].class);
        BillRiskControlService.unlockRiskRecord(primaryKeyValues);
    }

    public static ApiResult unlockRiskRecordApi(JSONArray dataNumberArr) {
        LOGGER.info("unlockRiskRecordApi record data number arr:{}", (Object)dataNumberArr);
        QFilter qFilter = new QFilter("bizno", "in", (Object)dataNumberArr);
        DynamicObject[] riskDataArr = BusinessDataServiceHelper.load((String)"sim_risk_control_record", (String)QUERY_FIELDS, (QFilter[])qFilter.toArray());
        ArrayList lockList = new ArrayList(8);
        HashSet lockSet = new HashSet(8);
        HashSet existSet = new HashSet(8);
        if (riskDataArr != null && riskDataArr.length > 0) {
            Arrays.stream(riskDataArr).forEach(dynamicObject -> {
                String riskStatus = dynamicObject.getString("riskstatus");
                String bizNo = dynamicObject.getString("bizno");
                existSet.add(bizNo);
                if ("lock".equals(riskStatus)) {
                    lockSet.add(bizNo);
                    dynamicObject.set("riskstatus", (Object)"unlock");
                    dynamicObject.set("unlockuser", (Object)RequestContext.get().getCurrUserId());
                    dynamicObject.set("unlocktime", (Object)new Date());
                    lockList.add(dynamicObject);
                }
            });
        }
        ImcSaveServiceHelper.update(lockList);
        HashSet unlockSet = new HashSet(existSet);
        unlockSet.removeAll(lockSet);
        HashSet notExistSet = new HashSet(dataNumberArr.size());
        dataNumberArr.stream().map(Object::toString).forEach(element -> {
            if (!existSet.contains(element)) {
                notExistSet.add(element);
            }
        });
        boolean success = true;
        JSONObject returnData = new JSONObject(3);
        if (!unlockSet.isEmpty() || !notExistSet.isEmpty()) {
            success = false;
        }
        returnData.put("successNumber", lockSet);
        returnData.put("unlockedNumber", unlockSet);
        returnData.put("notExistNumber", notExistSet);
        LOGGER.info("unlockRiskRecordApi result:{}", (Object)returnData);
        if (success) {
            return ResponseVo.success((String)ApiErrCodeEnum.OK.getMsg(), (Object)returnData);
        }
        ApiResult fail = ResponseVo.fail((ApiErrCodeEnum)ApiErrCodeEnum.BILL_RISK_UNLOCK_FAIL);
        fail.setData((Object)returnData);
        return fail;
    }

    public static void unlockRiskRecord(Object[] primaryKeyValues) {
        LOGGER.info("unlock risk control record ids:{}", Arrays.asList(primaryKeyValues));
        QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        BillRiskControlService.unlockRiskRecord(qFilter);
        LOGGER.info("unlock risk control record success!");
    }

    private static void unlockRiskRecord(QFilter qFilter) {
        qFilter.and("riskstatus", "=", (Object)"lock");
        DynamicObject[] riskDataArr = BusinessDataServiceHelper.load((String)"sim_risk_control_record", (String)QUERY_FIELDS, (QFilter[])qFilter.toArray());
        if (riskDataArr != null && riskDataArr.length > 0) {
            Arrays.stream(riskDataArr).forEach(dynamicObject -> {
                dynamicObject.set("riskstatus", (Object)"unlock");
                dynamicObject.set("unlockuser", (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("unlocktime", (Object)new Date());
            });
            SaveServiceHelper.update((DynamicObject[])riskDataArr);
        }
    }

    private static void setRiskMsg(String bizNo, String riskMsg, Map<String, String> dataBizMap) {
        if (StringUtils.isNotEmpty((CharSequence)riskMsg)) {
            String oldRiskMsg = dataBizMap.get(bizNo);
            if (StringUtils.isEmpty((CharSequence)oldRiskMsg)) {
                dataBizMap.put(bizNo, riskMsg);
            } else if (!oldRiskMsg.contains(riskMsg)) {
                dataBizMap.merge(bizNo, riskMsg, (oldValue, newValue) -> oldValue + "|" + newValue);
            }
        }
    }

    public static ApiResult getApiResult(JSONObject dataBizJson) {
        if (dataBizJson != null && !dataBizJson.isEmpty()) {
            LOGGER.info("\u5b58\u5728\u88ab\u98ce\u63a7\u7684\u6570\u636e{}", (Object)dataBizJson);
            ApiResult fail = ResponseVo.fail((ApiErrCodeEnum)ApiErrCodeEnum.BILL_RISK_CONTROL);
            JSONObject returnData = new JSONObject(1);
            JSONArray riskArr = new JSONArray(dataBizJson.size());
            for (String key : dataBizJson.keySet()) {
                String riskMsg = BillRiskControlService.getSubstringAfterKey(dataBizJson.getString(key), String.valueOf('\u3011'));
                JSONObject riskJson = new JSONObject(2);
                riskJson.put("riskNumber", (Object)key);
                riskJson.put("riskMsg", (Object)riskMsg);
                riskArr.add((Object)riskJson);
            }
            returnData.put("riskInfo", (Object)riskArr);
            fail.setData((Object)returnData);
            return fail;
        }
        return null;
    }

    public static String getSubstringAfterKey(String str, String subKey) {
        String substringAfter = StringUtils.substringAfter((String)str, (String)subKey);
        return (String)StringUtils.defaultIfBlank((CharSequence)substringAfter, (CharSequence)str);
    }
}

