/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.temp;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;

public class UpdateInvoiceTypePlugin
extends AbstractFormPlugin {
    private int pageSize = 300;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            int from = 0;
            Date start = (Date)this.getModel().getValue("start_date");
            Date end = (Date)this.getModel().getValue("end_date");
            if (start == null || end == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"UpdateInvoiceTypePlugin_0", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            try (DLock lock = DLock.create((String)"sim_UpdateInvoiceTypePlugin");){
                if (lock.tryLock()) {
                    List<Map<String, String>> list;
                    CacheHelper.remove((String)"sim_UpdateInvoiceTypePlugin_count");
                    int count = 0;
                    while ((list = this.queryInvoiceInfo(from)) != null) {
                        for (Map<String, String> map : list) {
                            count += this.updateInvoiceType(map);
                        }
                        CacheHelper.put((String)"sim_UpdateInvoiceTypePlugin_count", (String)(count + ""));
                        if (list.size() < this.pageSize) break;
                        from += this.pageSize;
                    }
                    String firstTip = ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\uff0c\u6570\u91cf", (String)"UpdateInvoiceTypePlugin_1", (String)"imc-sim-service", (Object[])new Object[0]);
                    this.getView().showTipNotification(firstTip + count);
                } else {
                    String tip = ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u8fd0\u884c\u4e2d\uff0c\u5df2\u4fee\u590d", (String)"UpdateInvoiceTypePlugin_2", (String)"imc-sim-service", (Object[])new Object[0]);
                    this.getView().showTipNotification(tip + CacheHelper.get((String)"sim_UpdateInvoiceTypePlugin_count"));
                }
            }
        }
    }

    private int updateInvoiceType(Map<String, String> invoice) {
        int count = 0;
        String oldType = invoice.get("invoicetype");
        String newType = this.getInvoiceType(invoice.get("invoicecode"), invoice.get("invoiceno"), invoice.get("alletaxinvoiceno"), invoice.get("invoicetype"));
        if (!StringUtils.isEmpty((CharSequence)newType) && !newType.equals(oldType)) {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)BigDecimalUtil.transDecimal((Object)invoice.get("id")).longValue(), (String)"sim_vatinvoice");
            object.set("invoicetype", (Object)newType);
            ++count;
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
        return count;
    }

    private String getInvoiceType(String invoicecode, String invoiceno, String alletaxinvoiceno, String invoiceType) {
        if (!InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType) && !InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode().equals(invoiceType)) {
            return "";
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceno) && invoiceno.length() == 20) {
            if (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType)) {
                return InvoiceType.ALL_E_SPECIAL.getTypeCode();
            }
            return InvoiceType.ALL_E_NORMAL.getTypeCode();
        }
        if (StringUtils.isNotEmpty((CharSequence)invoicecode) && StringUtils.isNotEmpty((CharSequence)invoiceno)) {
            if (invoicecode.length() == 12) {
                String lastTwoStr = invoicecode.substring(invoicecode.length() - 2);
                String firstStr = invoicecode.substring(0, 1);
                String sixthStr = invoicecode.substring(5, 6);
                String eighthStr = invoicecode.substring(7, 8);
                if (UpdateInvoiceTypePlugin.isBlockChainType(invoicecode, invoiceno) || UpdateInvoiceTypePlugin.isYunNanBlockchain(invoicecode, invoiceno)) {
                    // empty if block
                }
                if (!firstStr.equals("0") || lastTwoStr.equals("12")) {
                    // empty if block
                }
                if (firstStr.equals("0") && lastTwoStr.equals("11")) {
                    return InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode();
                }
                if (firstStr.equals("0") && lastTwoStr.equals("06")) {
                    return InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode();
                }
                if (firstStr.equals("0") && lastTwoStr.equals("07")) {
                    return InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode();
                }
                if (!firstStr.equals("0") || lastTwoStr.equals("17")) {
                    // empty if block
                }
                if (!sixthStr.equals("1") && !sixthStr.equals("2") || eighthStr.equals("2")) {
                    // empty if block
                }
                if (firstStr.equals("0") && lastTwoStr.equals("13")) {
                    return InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode();
                }
            } else if (invoicecode.length() == 10) {
                String endStr = invoicecode.substring(invoicecode.length() - 3);
                if (endStr.equals("130") || endStr.equals("140") || endStr.equals("160") || endStr.equals("170")) {
                    return InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode();
                }
                return InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode();
            }
        }
        return "";
    }

    public static boolean isBlockChainType(String invoiceCode, String invoiceNo) {
        return StringUtils.isNotEmpty((CharSequence)invoiceCode) && StringUtils.isNotEmpty((CharSequence)invoiceNo) && invoiceCode.length() == 12 && invoiceNo.length() == 8 && "14403".equals(invoiceCode.substring(0, 5)) && "9".equals(invoiceCode.substring(8, 9));
    }

    public static boolean isYunNanBlockchain(String invoiceCode, String invoiceNo) {
        if (StringUtils.isEmpty((CharSequence)invoiceCode) || StringUtils.isEmpty((CharSequence)invoiceNo)) {
            return false;
        }
        if (invoiceCode.length() != 12 || invoiceNo.length() != 8) {
            return false;
        }
        return "5300".equals(invoiceCode.substring(1, 5)) && ("09".equals(invoiceCode.substring(7, 9)) || "19".equals(invoiceCode.substring(7, 9)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, String>> queryInvoiceInfo(int from) {
        Date start = (Date)this.getModel().getValue("start_date");
        Date end = (Date)this.getModel().getValue("end_date");
        QFilter filter1 = new QFilter("buyertype", "=", (Object)"8");
        QFilter filter2 = new QFilter("createtime", ">=", (Object)start);
        QFilter filter3 = new QFilter("createtime", "<", (Object)end);
        ORM orm = ORM.create();
        try (DataSet ds = null;){
            ds = orm.queryDataSet("sim_UpdateInvoiceType", "sim_vatinvoice", "id,invoicecode,invoiceno,alletaxinvoiceno,invoicetype", new QFilter[]{filter1, filter2, filter3}, "id", from, this.pageSize);
            DynamicObjectCollection collection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"rim_invoice");
            if (collection != null) {
                ArrayList list = new ArrayList(collection.size());
                for (DynamicObject obj : collection) {
                    HashMap<String, String> map = new HashMap<String, String>(8);
                    map.put("id", obj.get("id").toString());
                    map.put("invoicecode", obj.get("invoicecode").toString());
                    map.put("invoiceno", obj.get("invoiceno").toString());
                    map.put("alletaxinvoiceno", obj.get("alletaxinvoiceno").toString());
                    map.put("invoicetype", obj.get("invoicetype").toString());
                    list.add(map);
                }
                ArrayList arrayList = list;
                return arrayList;
            }
            List<Map<String, String>> list = null;
            return list;
        }
    }
}

